/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.portal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jmi.reflect.RefObject;
import org.opencrx.kernel.account1.cci2.Account;
import org.opencrx.kernel.building1.cci2.AccountAssignmentInventoryItemQuery;
import org.opencrx.kernel.building1.jmi1.AccountAssignmentInventoryItem;
import org.opencrx.kernel.building1.jmi1.InventoryItem;
import org.opencrx.kernel.contract1.cci2.AccountAssignmentContractQuery;
import org.opencrx.kernel.contract1.jmi1.AbstractContract;
import org.opencrx.kernel.contract1.jmi1.AccountAssignmentContract;
import org.opencrx.kernel.product1.cci2.AccountAssignmentProductQuery;
import org.opencrx.kernel.product1.jmi1.AbstractProduct;
import org.opencrx.kernel.product1.jmi1.AccountAssignmentProduct;
import org.openmdx.portal.servlet.ApplicationContext;
import org.openmdx.portal.servlet.DataBinding;
import org.w3c.spi2.Datatypes;

public class AccountAssignmentDataBinding
extends DataBinding {
    private List<Short> accountRoles = null;

    public AccountAssignmentDataBinding(String parameterString) {
        if (parameterString != null && parameterString.startsWith("accountRole=")) {
            String[] accountRoles;
            this.accountRoles = new ArrayList<Short>();
            for (String value : accountRoles = parameterString.substring(12).split(",")) {
                String type = "short";
                if (value.startsWith("(")) {
                    type = value.substring(1, value.indexOf(")"));
                    value = value.substring(value.indexOf(")") + 1);
                }
                Class valueClass = null;
                if ("short".equalsIgnoreCase(type)) {
                    valueClass = Short.class;
                } else if ("int".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type)) {
                    valueClass = Integer.class;
                } else if ("long".equalsIgnoreCase(type)) {
                    valueClass = Long.class;
                } else if ("decimal".equalsIgnoreCase(type)) {
                    valueClass = BigDecimal.class;
                }
                this.accountRoles.add(((Number)Datatypes.create(valueClass, (String)value)).shortValue());
            }
        }
    }

    public Object getValue(RefObject object, String qualifiedFeatureName, ApplicationContext app) {
        TreeMap<String, Account> assignedAccounts = new TreeMap<String, Account>();
        try {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object);
            if (object instanceof AbstractContract) {
                AccountAssignmentContractQuery query = (AccountAssignmentContractQuery)pm.newQuery(AccountAssignmentContract.class);
                if (this.accountRoles != null) {
                    query.accountRole().elementOf(this.accountRoles);
                }
                for (AccountAssignmentContract assignment : ((AbstractContract)object).getAssignedAccount(query)) {
                    Account account = assignment.getAccount();
                    assignedAccounts.put(account.getFullName() + "*" + account.refGetPath(), account);
                }
            } else if (object instanceof AbstractProduct) {
                AccountAssignmentProductQuery query = (AccountAssignmentProductQuery)pm.newQuery(AccountAssignmentProduct.class);
                if (this.accountRoles != null) {
                    query.accountRole().elementOf(this.accountRoles);
                }
                for (AccountAssignmentProduct assignment : ((AbstractProduct)object).getAssignedAccount(query)) {
                    Account account = assignment.getAccount();
                    assignedAccounts.put(account.getFullName() + "*" + account.refGetPath(), account);
                }
            } else if (object instanceof InventoryItem) {
                AccountAssignmentInventoryItemQuery query = (AccountAssignmentInventoryItemQuery)pm.newQuery(AccountAssignmentInventoryItem.class);
                if (this.accountRoles != null) {
                    query.accountRole().elementOf(this.accountRoles);
                }
                for (AccountAssignmentInventoryItem assignment : ((InventoryItem)object).getAssignedAccount(query)) {
                    Account account = assignment.getAccount();
                    assignedAccounts.put(account.getFullName() + "*" + account.refGetPath(), account);
                }
            }
            return assignedAccounts.values();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setValue(RefObject object, String qualifiedFeatureName, Object newValue, ApplicationContext app) {
    }
}

