/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.exception.BasicException;

public class ExcelToText
implements HSSFListener {
    protected final StringBuilder text = new StringBuilder();
    protected SSTRecord sstrec = null;

    public Reader parse(InputStream document) throws ServiceException {
        try {
            this.text.setLength(0);
            POIFSFileSystem fs = new POIFSFileSystem(document);
            DocumentInputStream workbook = fs.createDocumentInputStream("Workbook");
            HSSFRequest request = new HSSFRequest();
            request.addListenerForAllRecords((HSSFListener)this);
            HSSFEventFactory eventFactory = new HSSFEventFactory();
            try {
                eventFactory.processEvents(request, (InputStream)workbook);
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
            catch (NoSuchMethodError e) {
                throw new ServiceException((Exception)BasicException.toExceptionStack((Throwable)e));
            }
            workbook.close();
            return new StringReader(this.text.toString());
        }
        catch (IOException e) {
            throw new ServiceException((Exception)e);
        }
    }

    public void processRecord(Record record) {
        block17: {
            int curentRow = 0;
            if (this.sstrec != null) {
                try {
                    String value2;
                    int rowNum;
                    LabelSSTRecord bof2;
                    if (!(record instanceof CellValueRecordInterface)) break block17;
                    if (record instanceof LabelSSTRecord) {
                        bof2 = (LabelSSTRecord)record;
                        rowNum = ((CellValueRecordInterface)record).getRow();
                        if (curentRow < rowNum) {
                            this.text.append(" ");
                            curentRow = rowNum;
                        }
                        try {
                            value2 = this.sstrec.getString(bof2.getSSTIndex()).toString();
                            this.text.append(value2 + " ");
                        }
                        catch (Exception value2) {
                            // empty catch block
                        }
                    }
                    if (record instanceof NumberRecord) {
                        bof2 = (NumberRecord)record;
                        rowNum = ((CellValueRecordInterface)record).getRow();
                        if (curentRow < rowNum) {
                            this.text.append(" ");
                            curentRow = rowNum;
                        }
                        value2 = new Double(bof2.getValue()).toString();
                        this.text.append(value2 + " ");
                    }
                }
                catch (Exception bof2) {
                }
                catch (NoSuchMethodError bof2) {
                    // empty catch block
                }
            }
        }
        switch (record.getSid()) {
            case 133: {
                BoundSheetRecord bsr = (BoundSheetRecord)record;
                this.text.append(bsr.getSheetname() + " ");
                break;
            }
            case 252: {
                this.sstrec = (SSTRecord)record;
                break;
            }
            case 353: {
                break;
            }
            case 438: {
                int ind;
                TextObjectRecord textObjectRecord = (TextObjectRecord)record;
                HSSFRichTextString q = textObjectRecord.getStr();
                String st = q.getString();
                if (st == null || "".equals(st) || (ind = this.text.indexOf(st)) != -1) break;
                this.text.append(st + " ");
                break;
            }
            case 519: {
                int ind;
                StringRecord selectionRecord = (StringRecord)record;
                String str = selectionRecord.getString();
                if (str == null || "".equals(str) || (ind = this.text.indexOf(str)) != -1) break;
                this.text.append(str + " ");
            }
        }
    }
}

