/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class QueryTool {
    public static void main(String[] args) throws SQLException, IOException, ClassNotFoundException {
        String queryFile = null;
        String conn = null;
        Integer loops = 1;
        Integer threads = 1;
        for (int i = 0; i < args.length; ++i) {
            if ("--query".equals(args[i])) {
                queryFile = args[i + 1];
                continue;
            }
            if ("--conn".equals(args[i])) {
                conn = args[i + 1];
                continue;
            }
            if ("--loops".equals(args[i])) {
                loops = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (!"--threads".equals(args[i])) continue;
            threads = Integer.parseInt(args[i + 1]);
        }
        Properties query = new Properties();
        query.load(new FileInputStream(queryFile));
        ArrayList<Thread> queryExecutors = new ArrayList<Thread>();
        for (int i = 0; i < threads; ++i) {
            Thread queryExecutor = new Thread(new QueryExecutor(query, conn, loops));
            queryExecutors.add(queryExecutor);
            queryExecutor.start();
        }
        for (Thread queryExecutor : queryExecutors) {
            try {
                queryExecutor.join();
            }
            catch (Exception exception) {}
        }
    }

    public static class QueryExecutor
    implements Runnable {
        private final String conn;
        private final Integer loops;
        private final Properties query;

        public QueryExecutor(Properties query, String conn, int loops) {
            this.query = query;
            this.conn = conn;
            this.loops = loops;
        }

        public void executeQuery(Connection connection, int statementIndex, String statement, List<String> statementParameters, int fetchSize, int fetchDirection, int maxRows, int loopIndex) throws SQLException {
            String prefix = new Date() + "   [" + loopIndex + "," + Thread.currentThread().getId() + "] ";
            System.out.println(prefix + "query: " + statementIndex);
            PreparedStatement ps = null;
            System.out.println(prefix + "statement[" + statementIndex + "]: " + statement);
            System.out.println(prefix + "parameters[" + statementIndex + "]: " + statementParameters);
            System.out.println(prefix + "fetchSize[" + statementIndex + "]: " + fetchSize);
            System.out.println(prefix + "fetchDirection[" + statementIndex + "]: " + fetchDirection);
            System.out.println(prefix + "maxRows[" + statementIndex + "]: " + maxRows);
            long startTime = System.currentTimeMillis();
            ps = connection.prepareStatement(statement);
            if (statementParameters.size() == 1 && statementParameters.get(0).isEmpty()) {
                statementParameters.clear();
            }
            for (int i = 0; i < statementParameters.size(); ++i) {
                String value = statementParameters.get(i);
                if (value.startsWith(":integer:")) {
                    ps.setInt(i + 1, Integer.parseInt(value.substring(9)));
                    continue;
                }
                if (value.startsWith(":decimal:")) {
                    ps.setBigDecimal(i + 1, new BigDecimal(value.substring(9)));
                    continue;
                }
                if (value.startsWith(":boolean:")) {
                    ps.setBoolean(i + 1, Boolean.parseBoolean(value.substring(9)));
                    continue;
                }
                ps.setString(i + 1, value);
            }
            long duration = System.currentTimeMillis() - startTime;
            System.out.println(prefix + "prepare time[" + statementIndex + "]: " + Long.valueOf(duration));
            ps.setFetchSize(fetchSize);
            ps.setFetchDirection(fetchDirection);
            ps.setMaxRows(maxRows);
            ResultSet rs = null;
            long startTime2 = System.currentTimeMillis();
            rs = ps.executeQuery();
            long duration2 = System.currentTimeMillis() - startTime2;
            System.out.println(prefix + "executeQuery[" + statementIndex + "]: " + Long.valueOf(duration2) + "");
            startTime2 = System.currentTimeMillis();
            ResultSetMetaData rsm = rs.getMetaData();
            for (int j = 0; j < rsm.getColumnCount(); ++j) {
                String string = rsm.getColumnName(j + 1);
            }
            int count = 0;
            while (rs.next()) {
                if (count == 0) {
                    long duration3 = System.currentTimeMillis() - startTime2;
                    System.out.println(prefix + "rs.next() for first row[" + statementIndex + "]: " + Long.valueOf(duration3) + "");
                    startTime2 = System.currentTimeMillis();
                }
                for (int j = 0; j < rsm.getColumnCount(); ++j) {
                    Object object = rs.getObject(j + 1);
                }
                if (++count <= maxRows) continue;
            }
            long duration4 = System.currentTimeMillis() - startTime2;
            System.out.println(prefix + "total fetch time for {" + count + "} rows[" + statementIndex + "]: " + Long.valueOf(duration4) + "");
            rs.close();
            ps.close();
        }

        public void executeQuery(Connection connection, int statementIndex, String statement, int fetchSize, int fetchDirection, int maxRows, int loopIndex) {
            String prefix = new Date() + "   [" + loopIndex + "," + Thread.currentThread().getId() + "] ";
            try {
                System.out.println(prefix + "query: " + statementIndex);
                Statement s = null;
                System.out.println(prefix + "statement[" + statementIndex + "]: " + statement);
                System.out.println(prefix + "fetchSize[" + statementIndex + "]: " + fetchSize);
                System.out.println(prefix + "fetchDirection[" + statementIndex + "]: " + fetchDirection);
                System.out.println(prefix + "maxRows[" + statementIndex + "]: " + maxRows);
                long startTime = System.currentTimeMillis();
                s = connection.createStatement();
                long duration = System.currentTimeMillis() - startTime;
                System.out.println(prefix + "prepare time[" + statementIndex + "]: " + Long.valueOf(duration));
                s.setFetchSize(fetchSize);
                s.setFetchDirection(fetchDirection);
                s.setMaxRows(maxRows);
                ResultSet rs = null;
                long startTime2 = System.currentTimeMillis();
                rs = s.executeQuery(statement);
                long duration2 = System.currentTimeMillis() - startTime2;
                System.out.println(prefix + "executeQuery[" + statementIndex + "]: " + Long.valueOf(duration2) + "");
                startTime2 = System.currentTimeMillis();
                ResultSetMetaData rsm = rs.getMetaData();
                for (int j = 0; j < rsm.getColumnCount(); ++j) {
                    String string = rsm.getColumnName(j + 1);
                }
                int count = 0;
                while (rs.next()) {
                    if (count == 0) {
                        long duration3 = System.currentTimeMillis() - startTime2;
                        System.out.println(prefix + "rs.next() for first row[" + statementIndex + "]: " + Long.valueOf(duration3) + "");
                        startTime2 = System.currentTimeMillis();
                    }
                    for (int j = 0; j < rsm.getColumnCount(); ++j) {
                        Object object = rs.getObject(j + 1);
                    }
                    if (++count <= maxRows) continue;
                }
                long duration4 = System.currentTimeMillis() - startTime2;
                System.out.println(prefix + "total fetch time for {" + count + "} rows[" + statementIndex + "]: " + Long.valueOf(duration4) + "");
                rs.close();
                s.close();
            }
            catch (Exception e) {
                System.out.println(prefix + "error: " + e.getMessage());
            }
        }

        @Override
        public void run() {
            for (int loopIndex = 0; loopIndex < this.loops; ++loopIndex) {
                String prefix = new Date() + "   [" + loopIndex + "," + Thread.currentThread().getId() + "] ";
                try {
                    Properties props;
                    Connection connection = null;
                    if (this.conn == null) {
                        props = new Properties();
                        props.put("user", this.query.get("username"));
                        props.put("password", this.query.get("password"));
                        Class.forName(this.query.getProperty("jdbcDriver"));
                        connection = DriverManager.getConnection(this.query.getProperty("jdbcUrl"), props);
                    } else {
                        props = new Properties();
                        props.put("user", this.query.get("username[" + this.conn + "]"));
                        props.put("password", this.query.get("password[" + this.conn + "]"));
                        Class.forName(this.query.getProperty("jdbcDriver[" + this.conn + "]"));
                        connection = DriverManager.getConnection(this.query.getProperty("jdbcUrl[" + this.conn + "]"), props);
                    }
                    connection.setAutoCommit(Boolean.parseBoolean(this.query.getProperty("autoCommit")));
                    if (this.query.containsKey("statement")) {
                        String statementParameters = this.query.getProperty("statementParameters");
                        if (statementParameters == null || statementParameters.isEmpty()) {
                            this.executeQuery(connection, 0, this.query.getProperty("statement"), Integer.valueOf(this.query.getProperty("fetchSize")), Integer.valueOf(this.query.getProperty("fetchDirection")), Integer.valueOf(this.query.getProperty("maxRows")), loopIndex);
                            continue;
                        }
                        this.executeQuery(connection, 0, this.query.getProperty("statement"), new ArrayList<String>(Arrays.asList(statementParameters.split(","))), Integer.valueOf(this.query.getProperty("fetchSize")), Integer.valueOf(this.query.getProperty("fetchDirection")), Integer.valueOf(this.query.getProperty("maxRows")), loopIndex);
                        continue;
                    }
                    int statementIndex = 0;
                    long startTime = System.currentTimeMillis();
                    while (this.query.containsKey("statement[" + statementIndex + "]")) {
                        try {
                            System.out.println(prefix + "#");
                            String statementParameters = this.query.getProperty("statementParameters[" + statementIndex + "]");
                            if (statementParameters == null || statementParameters.isEmpty()) {
                                this.executeQuery(connection, statementIndex, this.query.getProperty("statement[" + statementIndex + "]"), Integer.valueOf(this.query.getProperty("fetchSize")), Integer.valueOf(this.query.getProperty("fetchDirection")), Integer.valueOf(this.query.getProperty("maxRows")), loopIndex);
                            } else {
                                this.executeQuery(connection, statementIndex, this.query.getProperty("statement[" + statementIndex + "]"), new ArrayList<String>(Arrays.asList(statementParameters.split(","))), Integer.valueOf(this.query.getProperty("fetchSize")), Integer.valueOf(this.query.getProperty("fetchDirection")), Integer.valueOf(this.query.getProperty("maxRows")), loopIndex);
                            }
                        }
                        catch (Exception e) {
                            System.out.println(prefix + "error: " + e.getMessage());
                        }
                        ++statementIndex;
                    }
                    long duration = System.currentTimeMillis() - startTime;
                    System.out.println(prefix + "#");
                    System.out.println(prefix + "total execution time: " + Long.valueOf(duration));
                    continue;
                }
                catch (Exception e) {
                    System.out.println(prefix + "error: " + e.getMessage());
                }
            }
        }
    }
}

