/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.openmdx.kernel.log.SysLog;

public class QuotaByteArrayOutputStream
extends ByteArrayOutputStream {
    private int div = 12;
    private final String id;
    private static final Map<String, Counter> counters = new ConcurrentHashMap<String, Counter>();

    public QuotaByteArrayOutputStream(String id) {
        this.id = id;
        Counter counter = counters.get(id);
        if (counter == null) {
            counter = new Counter();
            counters.put(id, counter);
        }
        ++counter.count;
        if (counter.count % 100 == 0) {
            SysLog.log((Level)Level.INFO, (String)"{0} has created {1} byte array output streams", (Object[])new Object[]{id, counter.count});
        }
    }

    public ByteArrayInputStream toInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.size());
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        super.write(b, off, len);
        if (this.count >> this.div > 0) {
            SysLog.log((Level)Level.WARNING, (String)"{0} has allocated a byte array output stream which is larger than {1} bytes ", (Object[])new Object[]{this.id, this.count});
            ++this.div;
        }
    }

    @Override
    public synchronized void write(int b) {
        super.write(b);
        if (this.count >> this.div > 0) {
            SysLog.log((Level)Level.WARNING, (String)"{0} has allocated a byte array output stream which is larger than {1} bytes ", (Object[])new Object[]{this.id, this.count});
            ++this.div;
        }
    }

    private static class Counter {
        public int count = 0;
    }
}

