/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.workflow;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.activity1.cci2.ActivityDoFollowUpParams;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityDoFollowUpParams;
import org.opencrx.kernel.activity1.jmi1.ActivityGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessState;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessTransition;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.home1.jmi1.WfProcessInstance;
import org.opencrx.kernel.utils.WorkflowHelper;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.UserObjects;
import org.openmdx.kernel.log.SysLog;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class BulkActivityFollowUpWorkflow
extends Workflows.AsynchronousWorkflow {
    private static final int FETCH_SIZE = 200;
    public static final String OPTION_ACTIVITY = "activity";
    public static final String OPTION_TRANSITION = "transition";
    public static final String OPTION_FOLLOWUP_TITLE = "followUpTitle";
    public static final String OPTION_FOLLOWUP_TEXT = "followUpText";
    public static final String OPTION_ASSIGN_TO = "assignTo";

    protected void createLogEntry(String name, WfProcessInstance wfProcessInstance, int numberOfActivities, int countSuccess, int countFailed) throws ServiceException {
        HashMap<String, String> report = new HashMap<String, String>();
        report.put("Total", Integer.toString(numberOfActivities));
        report.put("Success", Integer.toString(countSuccess));
        report.put("Failed", Integer.toString(countFailed));
        report.put("Pending", Integer.toString(numberOfActivities - countSuccess - countFailed));
        WorkflowHelper.createLogEntry(wfProcessInstance, name, ((Object)report).toString());
    }

    @Override
    public void execute(WfProcessInstance wfProcessInstance) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
        try {
            ActivityProcessState processState;
            PersistenceManager pmUser = pm.getPersistenceManagerFactory().getPersistenceManager(wfProcessInstance.refGetPath().get(6), null);
            UserObjects.setBulkLoad((PersistenceManager)pmUser, (boolean)true);
            Map<String, Object> params = WorkflowHelper.getWorkflowParameters((WfProcessInstance)pmUser.getObjectById((Object)wfProcessInstance.refGetPath()));
            Activity activity = null;
            if (params.get(OPTION_ACTIVITY) instanceof Activity) {
                activity = (Activity)pmUser.getObjectById((Object)((Activity)params.get(OPTION_ACTIVITY)).refGetPath());
            }
            if (activity == null) {
                WorkflowHelper.createLogEntry(wfProcessInstance, OPTION_ACTIVITY, "Option >activity< must be a ReferenceProperty and reference an Activity");
            }
            ActivityGroup activityGroup = null;
            if (wfProcessInstance.getTargetObject() != null) {
                try {
                    activityGroup = (ActivityGroup)pmUser.getObjectById((Object)new Path(wfProcessInstance.getTargetObject()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (activityGroup == null) {
                WorkflowHelper.createLogEntry(wfProcessInstance, "Target", "Target must be of type ActivityGroup");
            }
            ArrayList<ActivityProcessTransition> processTransitions = new ArrayList<ActivityProcessTransition>();
            ArrayList<String> followUpTitles = new ArrayList<String>();
            ArrayList<String> followUpTexts = new ArrayList<String>();
            if (params.get(OPTION_TRANSITION) instanceof ActivityProcessTransition) {
                processTransitions.add((ActivityProcessTransition)pmUser.getObjectById((Object)((ActivityProcessTransition)params.get(OPTION_TRANSITION)).refGetPath()));
            }
            if (params.get(OPTION_FOLLOWUP_TITLE) instanceof String) {
                followUpTitles.add((String)params.get(OPTION_FOLLOWUP_TITLE));
            }
            if (params.get(OPTION_FOLLOWUP_TEXT) instanceof String) {
                followUpTexts.add((String)params.get(OPTION_FOLLOWUP_TEXT));
            }
            int idx = 0;
            while (params.get(OPTION_TRANSITION + idx) instanceof ActivityProcessTransition) {
                processTransitions.add((ActivityProcessTransition)pmUser.getObjectById((Object)((ActivityProcessTransition)params.get(OPTION_TRANSITION + idx)).refGetPath()));
                followUpTitles.add((String)params.get(OPTION_FOLLOWUP_TITLE + idx));
                followUpTexts.add((String)params.get(OPTION_FOLLOWUP_TEXT + idx));
                ++idx;
            }
            Contact assignTo = null;
            if (params.get(OPTION_ASSIGN_TO) instanceof Contact) {
                assignTo = (Contact)pmUser.getObjectById((Object)((Contact)params.get(OPTION_ASSIGN_TO)).refGetPath());
            }
            ArrayList<Path> activityIdentities = new ArrayList<Path>();
            int countSuccess = 0;
            int countFailed = 0;
            ActivityProcessState activityProcessState = processState = activity == null ? null : activity.getProcessState();
            if (activityGroup != null && processState != null && !processTransitions.isEmpty()) {
                ActivityQuery activityQuery = (ActivityQuery)pmUser.newQuery(Activity.class);
                activityQuery.thereExistsProcessState().equalTo(processState);
                ((Query)activityQuery).getFetchPlan().setFetchSize(200);
                List activities = activityGroup.getFilteredActivity(activityQuery);
                int count = 0;
                for (Activity a : activities) {
                    activityIdentities.add(a.refGetPath());
                    if (++count % 1000 != 0) continue;
                    this.createLogEntry("Report @" + new Date(), wfProcessInstance, activityIdentities.size(), countSuccess, countFailed);
                }
                this.createLogEntry("Report @" + new Date(), wfProcessInstance, activityIdentities.size(), countSuccess, countFailed);
                WfProcessInstance parentProcessInstance = (WfProcessInstance)pmUser.getObjectById((Object)wfProcessInstance.refGetPath());
                for (Path activityIdentity : activityIdentities) {
                    try {
                        Activity a = (Activity)pmUser.getObjectById((Object)activityIdentity);
                        for (int i = 0; i < processTransitions.size(); ++i) {
                            ActivityDoFollowUpParams doFollowUpParams = (ActivityDoFollowUpParams)Structures.create(ActivityDoFollowUpParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ActivityDoFollowUpParams.Member.assignTo, (Object)assignTo), Datatypes.member((Enum)ActivityDoFollowUpParams.Member.followUpText, followUpTexts.get(i)), Datatypes.member((Enum)ActivityDoFollowUpParams.Member.followUpTitle, followUpTitles.get(i)), Datatypes.member((Enum)ActivityDoFollowUpParams.Member.transition, processTransitions.get(i)), Datatypes.member((Enum)ActivityDoFollowUpParams.Member.parentProcessInstance, (Object)parentProcessInstance)});
                            pmUser.currentTransaction().begin();
                            a.doFollowUp(doFollowUpParams);
                            pmUser.currentTransaction().commit();
                        }
                        ++countSuccess;
                        if (assignTo != null) {
                            pmUser.currentTransaction().begin();
                            a.setAssignedTo(assignTo);
                            pmUser.currentTransaction().commit();
                        }
                    }
                    catch (Exception e) {
                        ++countFailed;
                        ServiceException e0 = new ServiceException(e);
                        SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
                        try {
                            pmUser.currentTransaction().rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((countSuccess + countFailed) % 100 != 0) continue;
                    this.createLogEntry("Report @" + new Date(), wfProcessInstance, activityIdentities.size(), countSuccess, countFailed);
                }
            }
            this.createLogEntry("Report - Complete", wfProcessInstance, activityIdentities.size(), countSuccess, countFailed);
            pmUser.close();
        }
        catch (Exception e) {
            SysLog.warning((String)"Can not perform BulkActivityFollowUp (reason=Exception)", (Object)e.getMessage());
            ServiceException e0 = new ServiceException(e);
            SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
            WorkflowHelper.createLogEntry(wfProcessInstance, "Can not perform BulkActivityFollowUp: Exception", e.getMessage());
            throw e0;
        }
    }
}

