/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.workflow;

import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.home1.jmi1.WfProcessInstance;
import org.opencrx.kernel.utils.WorkflowHelper;
import org.opencrx.kernel.workflow1.jmi1.ExporterTask;
import org.opencrx.kernel.workflow1.jmi1.RunExportResult;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;

public class RunExport
extends Workflows.AsynchronousWorkflow {
    @Override
    public void execute(WfProcessInstance wfProcessInstance) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
        Object targetObject = pm.getObjectById((Object)new Path(wfProcessInstance.getTargetObject()));
        if (targetObject instanceof ExporterTask) {
            ExporterTask exporterTask = (ExporterTask)targetObject;
            TreeMap<String, Object> wfParams = new TreeMap<String, Object>(WorkflowHelper.getWorkflowParameters(wfProcessInstance));
            ArrayList<String> params = new ArrayList<String>();
            for (Object value : wfParams.values()) {
                params.add(value.toString());
            }
            RunExportResult result = Workflows.getInstance().runExport(exporterTask, params);
            WorkflowHelper.createLogEntry(wfProcessInstance, "status", Short.toString(result.getStatus()));
            WorkflowHelper.createLogEntry(wfProcessInstance, "statusMessage", result.getStatusMessage());
            WorkflowHelper.createLogEntry(wfProcessInstance, "fileMimeType", result.getFileMimeType());
            WorkflowHelper.createLogEntry(wfProcessInstance, "fileName", result.getFileName());
            try {
                java.nio.file.Path filePath = Files.createTempFile(null, "-" + result.getFileName(), new FileAttribute[0]);
                WorkflowHelper.createLogEntry(wfProcessInstance, "file", filePath.toString());
                FileOutputStream out = new FileOutputStream(filePath.toFile());
                out.write(result.getFile());
                out.close();
            }
            catch (Exception e) {
                new ServiceException(e).log();
            }
        }
    }
}

