/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.backend.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.datatypes.AddressT;
import org.opencrx.application.airsync.datatypes.AttachmentDataT;
import org.opencrx.application.airsync.datatypes.AttachmentT;
import org.opencrx.application.airsync.datatypes.AttendeeStatus;
import org.opencrx.application.airsync.datatypes.AttendeeT;
import org.opencrx.application.airsync.datatypes.AttendeeType;
import org.opencrx.application.airsync.datatypes.BusyStatus;
import org.opencrx.application.airsync.datatypes.ContactT;
import org.opencrx.application.airsync.datatypes.DataType;
import org.opencrx.application.airsync.datatypes.EmailBodyT;
import org.opencrx.application.airsync.datatypes.EmailT;
import org.opencrx.application.airsync.datatypes.EventT;
import org.opencrx.application.airsync.datatypes.IData;
import org.opencrx.application.airsync.datatypes.Importance;
import org.opencrx.application.airsync.datatypes.MeetingStatus;
import org.opencrx.application.airsync.datatypes.MethodAttachment;
import org.opencrx.application.airsync.datatypes.MimeType;
import org.opencrx.application.airsync.datatypes.NoteT;
import org.opencrx.application.airsync.datatypes.RecurrenceDayOfWeek;
import org.opencrx.application.airsync.datatypes.RecurrenceT;
import org.opencrx.application.airsync.datatypes.RecurrenceType;
import org.opencrx.application.airsync.datatypes.Sensitivity;
import org.opencrx.application.airsync.datatypes.SyncDataItem;
import org.opencrx.application.airsync.datatypes.TaskT;
import org.opencrx.kernel.account1.cci2.MemberQuery;
import org.opencrx.kernel.account1.jmi1.AbstractGroup;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.Member;
import org.opencrx.kernel.account1.jmi1.PhoneNumber;
import org.opencrx.kernel.account1.jmi1.PostalAddress;
import org.opencrx.kernel.account1.jmi1.WebAddress;
import org.opencrx.kernel.activity1.jmi1.Absence;
import org.opencrx.kernel.activity1.jmi1.AbstractActivityParty;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityCategory;
import org.opencrx.kernel.activity1.jmi1.ActivityFilterGlobal;
import org.opencrx.kernel.activity1.jmi1.ActivityFilterGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityMilestone;
import org.opencrx.kernel.activity1.jmi1.ActivityTracker;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.activity1.jmi1.ExternalActivity;
import org.opencrx.kernel.activity1.jmi1.Incident;
import org.opencrx.kernel.activity1.jmi1.Mailing;
import org.opencrx.kernel.activity1.jmi1.Meeting;
import org.opencrx.kernel.activity1.jmi1.PhoneCall;
import org.opencrx.kernel.activity1.jmi1.Task;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.ICalendar;
import org.opencrx.kernel.backend.Notifications;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.backend.VCard;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.document1.jmi1.DocumentRevision;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.generic.cci2.CrxObjectHasMedia;
import org.opencrx.kernel.generic.cci2.MediaQuery;
import org.opencrx.kernel.generic.jmi1.Media;
import org.opencrx.kernel.generic.jmi1.Note;
import org.opencrx.kernel.home1.cci2.EMailAccountQuery;
import org.opencrx.kernel.home1.jmi1.Alert;
import org.opencrx.kernel.home1.jmi1.EMailAccount;
import org.opencrx.kernel.home1.jmi1.SyncFeed;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.MimeUtils;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.naming.Path;
import org.openmdx.base.text.conversion.Base64;
import org.openmdx.kernel.exception.BasicException;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.format.DateTimeFormat;
import org.w3c.spi2.Datatypes;

public class DatatypeMapper {
    public static final String SYNC_FEED_URI_SCHEME = "feed://";
    public static final String ACTIVITY_TRACKER_URI_SCHEME = "tracker://";
    public static final String ACTIVITY_CATEGORY_URI_SCHEME = "category://";
    public static final String ACTIVITY_MILESTONE_URI_SCHEME = "milestone://";
    public static final String ACTIVITY_FILTER_GLOBAL_URI_SCHEME = "activityFilterGlobal://";
    public static final String ACTIVITY_FILTER_GROUP_URI_SCHEME = "activityFilterGroup://";
    public static final String USER_HOME_URI_SCHEME = "userHome://";
    public static final String ACTIVITY_URI_SCHEME = "activity://";
    public static final String ACCOUNT_URI_SCHEME = "account://";
    public static final String ALERT_URI_SCHEME = "alert://";
    public static final String MEDIA_URI_SCHEME = "media://";
    public static final String DOCUMENT_FOLDER_URI_SCHEME = "documentFolder://";
    public static final String DOCUMENT_URI_SCHEME = "document://";

    public SyncDataItem toDataItem(RefObject_1_0 object, boolean noData, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        if (object instanceof Meeting || object instanceof Incident || object instanceof PhoneCall || object instanceof Mailing || object instanceof Absence || object instanceof ExternalActivity) {
            return this.toEventT((Activity)object, noData, user, requestContext);
        }
        if (object instanceof EMail) {
            return this.toEMailT((EMail)object, noData, user, requestContext);
        }
        if (object instanceof Task) {
            return this.toTaskT((Task)object, noData, user, requestContext);
        }
        if (object instanceof Account) {
            return this.toContactT((Account)object, noData, user, requestContext);
        }
        if (object instanceof Alert) {
            return this.toEMailT((Alert)object, noData, user, requestContext);
        }
        return null;
    }

    public void toObject(IData data, RefObject_1_0 object, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        if (data instanceof ContactT) {
            this.toAccount((ContactT)data, (Account)object, user, requestContext);
        } else if (data instanceof TaskT) {
            this.toTask((TaskT)data, (Activity)object, user, requestContext);
        } else if (data instanceof EventT) {
            this.toEvent((EventT)data, (Activity)object, user, requestContext);
        } else if (data instanceof EmailT) {
            if (object instanceof Alert) {
                this.toAlert((EmailT)data, (Alert)object, user, requestContext);
            } else if (object instanceof EMail) {
                this.toEMail((EmailT)data, (EMail)object, user, requestContext);
            }
        } else if (data instanceof NoteT) {
            this.toNote((NoteT)data, (Document)object, user, requestContext);
        }
    }

    public String normalizeMultilineString(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder target = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\n' && c != '\t' && c < ' ') continue;
            target.append(c);
        }
        return target.toString();
    }

    public String matchItem(UserHome user, IData data) throws ServiceException {
        return null;
    }

    private void updateContact(Account account, String vcard) throws ServiceException {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> report = new ArrayList<String>();
        byte[] item = null;
        try {
            item = vcard.getBytes("UTF-8");
        }
        catch (Exception e) {
            item = vcard.getBytes();
        }
        VCard.getInstance().importItem(item, account, (short)0, errors, report);
    }

    private String getVCardContactName(ContactT contactT) {
        return (contactT.getLastName() == null ? "" : contactT.getLastName()) + ";" + (contactT.getFirstName() == null ? "" : contactT.getFirstName()) + ";" + (contactT.getMiddleName() == null ? "" : contactT.getMiddleName()) + ";" + (contactT.getTitle() == null ? "" : contactT.getTitle()) + ";" + (contactT.getSuffix() == null ? "" : contactT.getSuffix());
    }

    private String getVCardPostalAddress(String street, String city, String state, String postalCode, String country) {
        if (!(street != null && street.length() != 0 || city != null && city.length() != 0 || state != null && state.length() != 0 || postalCode != null && postalCode.length() != 0 || country != null && country.length() != 0)) {
            return null;
        }
        return ";;" + (street == null ? "" : street.replace("  ", "\r\n").replace("\r\n", "=0D=0A")).replace("\n", "=0D=0A") + ";" + (city == null ? "" : city) + ";" + (state == null ? "" : state) + ";" + (postalCode == null ? "" : postalCode) + ";" + (country == null ? "" : country);
    }

    private String parseEmailAddress(String emailAddress) {
        int end;
        if (emailAddress.startsWith("\"") && (end = emailAddress.lastIndexOf("\"")) > 0) {
            emailAddress = emailAddress.substring(end + 1);
        }
        if (emailAddress.indexOf("<") >= 0) {
            int start = emailAddress.indexOf("<");
            int end2 = emailAddress.lastIndexOf(">");
            if (end2 > start) {
                emailAddress = emailAddress.substring(start + 1, end2);
            }
        }
        return emailAddress.trim();
    }

    private DateTimeFormat getUserDateTimeFormat(UserHome user) throws ServiceException {
        String userTz = UserHomes.getInstance().getUserTimezone(UserHomes.getInstance().getUserSettings(user));
        return DateTimeFormat.getInstance((String)"yyyyMMdd'T'HHmmss.SSS'Z'", (String)userTz, (boolean)false);
    }

    public void toAccount(ContactT contactT, Account account, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        String adrHome;
        String adrWork;
        String uid;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        DateTimeFormat utcf = DateTimeFormat.BASIC_UTC_FORMAT;
        StringBuilder vcard = new StringBuilder();
        vcard.append("BEGIN:VCARD\n");
        vcard.append("VERSION:2.1\n");
        if (account.getVcard() != null && (uid = VCard.getInstance().getVCardUid(account.getVcard())) != null) {
            vcard.append("UID:" + uid + "\n");
        }
        if (account instanceof Contact) {
            vcard.append("N:" + this.getVCardContactName(contactT) + "\n");
            if (contactT.getBirthday() != null) {
                vcard.append("BDAY:" + utcf.format(contactT.getBirthday()).substring(0, 15) + "Z\n");
            }
            if (contactT.getCompanyName() != null) {
                vcard.append("ORG:" + contactT.getCompanyName() + "\n");
            }
            if (contactT.getJobTitle() != null) {
                vcard.append("TITLE:" + contactT.getJobTitle() + "\n");
            }
        } else if (contactT.getFileAs() != null && contactT.getFileAs().length() > 0) {
            vcard.append("N:" + contactT.getFileAs() + "\n");
            vcard.append("FN:" + contactT.getFileAs() + "\n");
        } else if (contactT.getLastName() != null && contactT.getLastName().length() > 0) {
            vcard.append("N:" + contactT.getLastName() + "\n");
            vcard.append("FN:" + contactT.getLastName() + "\n");
        }
        if (contactT.getBusinessPhoneNumber() != null) {
            vcard.append("TEL;WORK;VOICE:" + contactT.getBusinessPhoneNumber() + "\n");
        }
        if (contactT.getHomePhoneNumber() != null) {
            vcard.append("TEL;HOME;VOICE:" + contactT.getHomePhoneNumber() + "\n");
        }
        if (contactT.getMobilePhoneNumber() != null) {
            vcard.append("TEL;CELL;VOICE:" + contactT.getMobilePhoneNumber() + "\n");
        }
        if (contactT.getEmail1Address() != null) {
            vcard.append("EMAIL;TYPE=PREF,INTERNET,WORK:" + this.parseEmailAddress(contactT.getEmail1Address()) + "\n");
        }
        if (contactT.getEmail2Address() != null) {
            vcard.append("EMAIL;TYPE=INTERNET,HOME:" + this.parseEmailAddress(contactT.getEmail2Address()) + "\n");
        }
        if (contactT.getBusinessFaxNumber() != null) {
            vcard.append("TEL;WORK;FAX:" + contactT.getBusinessFaxNumber() + "\n");
        }
        if (contactT.getHomeFaxNumber() != null) {
            vcard.append("TEL;HOME;FAX:" + contactT.getHomeFaxNumber() + "\n");
        }
        if (contactT.getWebPage() != null) {
            vcard.append("URL;WORK:" + contactT.getWebPage() + "\n");
        }
        if ((adrWork = this.getVCardPostalAddress(contactT.getBusinessStreet(), contactT.getBusinessAddressCity(), contactT.getBusinessState(), contactT.getBusinessPostalCode(), contactT.getBusinessAddressCountry())) != null) {
            vcard.append("ADR;WORK;ENCODING=QUOTED-PRINTABLE:" + adrWork + "\n");
        }
        if ((adrHome = this.getVCardPostalAddress(contactT.getHomeAddressStreet(), contactT.getHomeAddressCity(), contactT.getHomeAddressState(), contactT.getHomeAddressPostalCode(), contactT.getHomeAddressCountry())) != null) {
            vcard.append("ADR;HOME;ENCODING=QUOTED-PRINTABLE:" + adrHome + "\n");
        }
        vcard.append("END:VCARD");
        this.updateContact(account, vcard.toString());
        if (account instanceof Contact) {
            Contact contact = (Contact)account;
            if (contactT.getPicture() != null && contactT.getPicture().length() > 0) {
                byte[] picture = null;
                try {
                    picture = Base64.decode((String)contactT.getPicture());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (picture != null) {
                    Media media = null;
                    MediaQuery mediaQuery = (MediaQuery)pm.newQuery(Media.class);
                    mediaQuery.thereExistsContentName().equalTo((Object)"me.jpg");
                    List medias = account.getMedia(mediaQuery);
                    if (!medias.isEmpty()) {
                        media = (Media)medias.iterator().next();
                    } else {
                        media = (Media)pm.newInstance(Media.class);
                        media.setContentMimeType("image/jpeg");
                        media.setContentName("me.jpg");
                        account.addMedia(Base.getInstance().getUidAsString(), media);
                    }
                    media.setContent(BinaryLargeObjects.valueOf((byte[])picture));
                    contact.setPicture(media);
                }
            }
            if (contactT.getNickName() != null) {
                contact.setNickName(contactT.getNickName());
            }
            if (contactT.getDepartment() != null) {
                contact.setDepartment(contactT.getDepartment());
            }
            if (contactT.getAnniversary() != null) {
                contact.setAnniversary(contactT.getAnniversary());
            }
            if (contactT.getChildren() != null) {
                contact.getChildrenNames().clear();
                contact.getChildrenNames().addAll(contactT.getChildren());
            }
        }
        if (contactT.getCategories() != null) {
            account.getCategory().clear();
            account.getCategory().addAll(contactT.getCategories());
        }
        if (contactT.getBody() != null) {
            String body = this.normalizeMultilineString(contactT.getBody());
            int pos = body.startsWith("//") ? 0 : body.lastIndexOf(" //");
            body = pos >= 0 ? body.substring(0, pos) : body;
            account.setDescription(body);
        }
    }

    public void toNote(NoteT noteT, Document document, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)document);
        document.setName(noteT.getSubject());
        document.setTitle(noteT.getSubject());
        MediaContent revision = (MediaContent)pm.newInstance(MediaContent.class);
        revision.setName(noteT.getSubject());
        if (document.getHeadRevision() != null) {
            revision.setVersion(document.getHeadRevision().getVersion() + "1");
        }
        revision.setContentMimeType("text/plain");
        revision.setContentName(noteT.getSubject());
        if (noteT.getBody() != null) {
            try {
                revision.setContent(BinaryLargeObjects.valueOf((byte[])noteT.getBody().getBytes("UTF-8")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (noteT.getCategories() != null) {
            Object keywords = "";
            String sep = "";
            for (String category : noteT.getCategories()) {
                keywords = (String)keywords + sep + category;
                sep = ",";
            }
            document.setKeywords((String)keywords);
        }
        document.addRevision(Base.getInstance().getUidAsString(), revision);
        document.setHeadRevision(revision);
    }

    private void updateActivity(Activity activity, String ical) throws ServiceException {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> report = new ArrayList<String>();
        byte[] item = null;
        try {
            item = ical.getBytes("UTF-8");
        }
        catch (Exception e) {
            item = ical.getBytes();
        }
        ICalendar.getInstance().importItem(item, activity, (short)0, errors, report);
    }

    private String getCalendarUID(Activity activity) {
        String uid = activity.refGetPath().getLastSegment().toString();
        for (String externalLink : activity.getExternalLink()) {
            if (!externalLink.startsWith("ICAL:")) continue;
            uid = externalLink.substring("ICAL:".length());
            break;
        }
        return uid;
    }

    public void toTask(TaskT taskT, Activity task, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        DateTimeFormat utcf = DateTimeFormat.BASIC_UTC_FORMAT;
        StringBuilder vtodo = new StringBuilder();
        vtodo.append("BEGIN:VCALENDAR\n");
        vtodo.append("PRODID://OPENCRX//V2//EN\n");
        vtodo.append("VERSION:2.0\n");
        vtodo.append("BEGIN:VTODO\n");
        vtodo.append("CLASS:CONFIDENTIAL\n");
        vtodo.append("UID:" + this.getCalendarUID(task) + "\n");
        if (taskT.getSubject() != null) {
            vtodo.append("SUMMARY:" + taskT.getSubject() + "\n");
        }
        if (taskT.getStartdate() != null || taskT.getUtcstartdate() != null) {
            if (taskT.getStartdate() != null) {
                vtodo.append("DTSTART:" + utcf.format(taskT.getStartdate()).substring(0, 15) + "Z\n");
            } else {
                vtodo.append("DTSTART:" + utcf.format(taskT.getUtcstartdate()).substring(0, 15) + "Z\n");
            }
        }
        if (Boolean.TRUE.equals(taskT.getComplete()) && taskT.getDatecompleted() != null) {
            vtodo.append("COMPLETE:" + utcf.format(taskT.getDatecompleted()).substring(0, 15) + "Z\n");
        }
        if (taskT.getDuedate() != null || taskT.getUtcduedate() != null) {
            if (taskT.getUtcduedate() != null) {
                vtodo.append("DUE:" + utcf.format(taskT.getUtcduedate()).substring(0, 15) + "Z\n");
            } else {
                vtodo.append("DUE:" + utcf.format(taskT.getDuedate()).substring(0, 15) + "Z\n");
            }
        }
        if (taskT.getRecurrence() != null) {
            vtodo.append("RRULE:" + this.getICalRRule(taskT.getRecurrence()) + "\n");
        }
        if (taskT.getImportance() != null) {
            vtodo.append("PRIORITY:" + this.getICalPriority(taskT.getImportance()) + "\n");
        }
        vtodo.append("END:VTODO\n");
        vtodo.append("END:VCALENDAR");
        if (taskT.getCategories() != null) {
            task.getCategory().clear();
            task.getCategory().addAll(taskT.getCategories());
        }
        this.updateActivity(task, vtodo.toString());
        if (taskT.getBody() != null) {
            String body = this.normalizeMultilineString(taskT.getBody());
            int pos = body.startsWith("//") ? 0 : body.lastIndexOf(" //");
            body = pos >= 0 ? body.substring(0, pos) : body;
            task.setDescription(body);
        }
    }

    public void toEvent(EventT eventT, Activity event, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        DateTimeFormat utcf = DateTimeFormat.BASIC_UTC_FORMAT;
        DateTimeFormat userf = this.getUserDateTimeFormat(user);
        StringBuilder vevent = new StringBuilder();
        vevent.append("BEGIN:VCALENDAR\n");
        vevent.append("PRODID://OPENCRX//V2//EN\n");
        vevent.append("VERSION:2.0\n");
        vevent.append("BEGIN:VEVENT\n");
        vevent.append("CLASS:CONFIDENTIAL\n");
        vevent.append("UID:" + (eventT.getUID() == null ? this.getCalendarUID(event) : eventT.getUID()) + "\n");
        if (eventT.getStartTime() != null) {
            vevent.append(eventT.getAllDayEvent() != false ? "DTSTART;VALUE=DATE:" + userf.format(eventT.getStartTime()).substring(0, 8) + "\n" : "DTSTART:" + utcf.format(eventT.getStartTime()).substring(0, 15) + "Z\n");
        }
        if (eventT.getEndTime() != null) {
            vevent.append(eventT.getAllDayEvent() != false ? "DTEND;VALUE=DATE:" + userf.format(eventT.getEndTime()).substring(0, 8) + "\n" : "DTEND:" + utcf.format(eventT.getEndTime()).substring(0, 15) + "Z\n");
        }
        if (eventT.getLocation() != null) {
            vevent.append("LOCATION:" + eventT.getLocation() + "\n");
        }
        if (eventT.getDtStamp() != null) {
            vevent.append("DTSTAMP:" + utcf.format(eventT.getDtStamp()).substring(0, 15) + "Z\n");
        }
        if (eventT.getSubject() != null) {
            vevent.append("SUMMARY:" + eventT.getSubject() + "\n");
        }
        if (eventT.getMeetingStatus() != null) {
            vevent.append("STATUS:" + this.getICalStatus(eventT.getMeetingStatus()) + "\n");
        }
        if (eventT.getOrganizerEmail() != null) {
            vevent.append("ORGANIZER:MAILTO:" + this.parseEmailAddress(eventT.getOrganizerEmail()) + "\n");
        }
        if (eventT.getRecurrence() != null) {
            vevent.append("RRULE:" + this.getICalRRule(eventT.getRecurrence()) + "\n");
        }
        if (eventT.getAttendees() != null) {
            for (AttendeeT attendeeT : eventT.getAttendees()) {
                String partyType = attendeeT.getAttendeeType() == AttendeeType.OPTIONAL ? "OPT-PARTICIPANT" : "REQ-PARTICIPANT";
                Activities.PartyStatus partyStatus = null;
                if (attendeeT.getAttendeeStatus() == AttendeeStatus.ACCEPT) {
                    partyStatus = Activities.PartyStatus.ACCEPTED;
                } else if (attendeeT.getAttendeeStatus() == AttendeeStatus.DECLINE) {
                    partyStatus = Activities.PartyStatus.DECLINED;
                } else if (attendeeT.getAttendeeStatus() == AttendeeStatus.TENTATIVE) {
                    partyStatus = Activities.PartyStatus.TENTATIVE;
                } else if (attendeeT.getAttendeeStatus() == AttendeeStatus.NOT_RESPONDED) {
                    partyStatus = Activities.PartyStatus.NEEDS_ACTION;
                } else if (attendeeT.getAttendeeStatus() == AttendeeStatus.RESPONSE_UNKNOWN) {
                    partyStatus = Activities.PartyStatus.NEEDS_ACTION;
                }
                if (attendeeT.getName() == null) {
                    vevent.append("ATTENDEE;CN=" + this.parseEmailAddress(attendeeT.getEmail()) + ";ROLE=" + partyType + ";" + (String)(partyStatus == null ? "" : ";PARTSTAT=" + partyStatus.toString().replace("_", "-")) + ";RSVP=TRUE:MAILTO:" + this.parseEmailAddress(attendeeT.getEmail()) + "\n");
                    continue;
                }
                vevent.append("ATTENDEE;CN=\"" + attendeeT.getName() + " (" + this.parseEmailAddress(attendeeT.getEmail()) + ")\";ROLE=" + partyType + (String)(partyStatus == null ? "" : ";PARTSTAT=" + partyStatus.toString().replace("_", "-")) + ";RSVP=TRUE:MAILTO:" + this.parseEmailAddress(attendeeT.getEmail()) + "\n");
            }
        }
        if (eventT.getExceptions() != null && !eventT.getExceptions().isEmpty()) {
            vevent.append("EXDATE:" + this.getICalExdates(eventT.getExceptions()) + "\n");
        }
        vevent.append("END:VEVENT\n");
        vevent.append("END:VCALENDAR");
        if (eventT.getCategories() != null) {
            event.getCategory().clear();
            event.getCategory().addAll(eventT.getCategories());
        }
        this.updateActivity(event, vevent.toString());
        if (eventT.getBody() != null) {
            String body = this.normalizeMultilineString(eventT.getBody());
            int pos = body.startsWith("//") ? 0 : body.lastIndexOf(" //");
            body = pos >= 0 ? body.substring(0, pos) : body;
            event.setDescription(body);
        }
    }

    public void toEMail(EmailT emailT, EMail email, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)email);
        String providerName = email.refGetPath().get(2);
        String segmentName = email.refGetPath().get(4);
        if (emailT.getMimeData() != null) {
            try {
                MimeUtils.MimeMessageImpl mimeMessage = new MimeUtils.MimeMessageImpl(new ByteArrayInputStream(emailT.getMimeData().getBytes("US-ASCII")));
                pm.currentTransaction().begin();
                Activities.getInstance().importMimeMessage(email, mimeMessage, true);
                pm.currentTransaction().commit();
            }
            catch (Exception e) {
                new ServiceException(e).log();
            }
        } else {
            String[] addressesFrom = new String[]{emailT.getFrom().getMail()};
            List<EMailAddress> senderAddresses = Accounts.getInstance().lookupEmailAddress(pm, providerName, segmentName, emailT.getFrom().getMail());
            if (senderAddresses.isEmpty()) {
                senderAddresses = Accounts.getInstance().lookupEmailAddress(pm, providerName, segmentName, "UNASSIGNED");
            }
            EMailAddress from = null;
            if (!senderAddresses.isEmpty()) {
                from = senderAddresses.iterator().next();
                email.setSender(from);
            }
            ArrayList<String> addresses = new ArrayList<String>();
            for (AddressT addressT : emailT.getTo()) {
                addresses.add(addressT.getMail());
            }
            String[] addressesTo = addresses.toArray(new String[addresses.size()]);
            Activities.getInstance().mapAddressesToEMailRecipients(email, addressesTo, Activities.PartyType.EMAIL_TO);
            addresses = new ArrayList();
            for (AddressT addressT : emailT.getCc()) {
                addresses.add(addressT.getMail());
            }
            String[] stringArray = addresses.toArray(new String[addresses.size()]);
            Activities.getInstance().mapAddressesToEMailRecipients(email, stringArray, Activities.PartyType.EMAIL_CC);
            addresses = new ArrayList();
            for (AddressT addressT : emailT.getBcc()) {
                addresses.add(addressT.getMail());
            }
            String[] stringArray2 = addresses.toArray(new String[addresses.size()]);
            Activities.getInstance().mapAddressesToEMailRecipients(email, stringArray2, Activities.PartyType.EMAIL_BCC);
            String recipientsAsText = Activities.getInstance().getRecipientsAsNoteText(pm, providerName, segmentName, addressesFrom, addressesTo, stringArray, stringArray2);
            Note note = (Note)pm.newInstance(Note.class);
            note.setTitle("Recipients");
            note.setText(recipientsAsText);
            email.addNote(Activities.getInstance().getUidAsString(), note);
            switch (emailT.getImportance()) {
                case LOW: {
                    email.setPriority(Activities.Priority.LOW.getValue());
                    break;
                }
                case NORMAL: {
                    email.setPriority(Activities.Priority.NORMAL.getValue());
                    break;
                }
                case HIGH: {
                    email.setPriority(Activities.Priority.HIGH.getValue());
                }
            }
            email.setSendDate(emailT.getDateReceived());
            email.setMessageSubject(emailT.getSubject());
            email.setMessageBody(emailT.getBody() == null ? null : emailT.getBody().getData());
        }
        if (emailT.getCategories() != null) {
            email.getCategory().clear();
            email.getCategory().addAll(emailT.getCategories());
        }
    }

    public void toAlert(EmailT emailT, Alert alert, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        if (emailT.isRead()) {
            alert.setAlertState(UserHomes.AlertState.READ.getValue());
        } else {
            alert.setAlertState(UserHomes.AlertState.NEW.getValue());
        }
    }

    public Path toObjectIdentity(String objectId) {
        if (objectId == null) {
            return null;
        }
        if (objectId.indexOf("?") > 0) {
            objectId = objectId.substring(0, objectId.lastIndexOf("?"));
        }
        if (objectId.startsWith(SYNC_FEED_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:home1", "provider", components[0], "segment", components[1], "userHome", components[2], "syncProfile", components[3], "feed", components[4]});
        }
        if (objectId.startsWith(ACTIVITY_TRACKER_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:activity1", "provider", components[0], "segment", components[1], "activityTracker", components[2]});
        }
        if (objectId.startsWith(ACTIVITY_CATEGORY_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:activity1", "provider", components[0], "segment", components[1], "activityCategory", components[2]});
        }
        if (objectId.startsWith(ACTIVITY_MILESTONE_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:activity1", "provider", components[0], "segment", components[1], "activityMilestone", components[2]});
        }
        if (objectId.startsWith(ACTIVITY_FILTER_GLOBAL_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:activity1", "provider", components[0], "segment", components[1], "activityFilter", components[2]});
        }
        if (objectId.startsWith(ACTIVITY_FILTER_GROUP_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:activity1", "provider", components[0], "segment", components[1], components[2], components[3], "activityFilter", components[4]});
        }
        if (objectId.startsWith(USER_HOME_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:home1", "provider", components[0], "segment", components[1], "userHome", components[2]});
        }
        if (objectId.startsWith(ACTIVITY_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:activity1", "provider", components[0], "segment", components[1], "activity", components[2]});
        }
        if (objectId.startsWith(ACCOUNT_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:account1", "provider", components[0], "segment", components[1], "account", components[2]});
        }
        if (objectId.startsWith(ALERT_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:home1", "provider", components[0], "segment", components[1], "userHome", components[2], "alert", components[3]});
        }
        if (objectId.startsWith(MEDIA_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:activity1", "provider", components[0], "segment", components[1], "activity", components[2], "media", components[3]});
        }
        if (objectId.startsWith(DOCUMENT_FOLDER_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:document1", "provider", components[0], "segment", components[1], "folder", components[2]});
        }
        if (objectId.startsWith(DOCUMENT_URI_SCHEME)) {
            String[] components = objectId.substring(objectId.indexOf("://") + 3).split("/");
            return new Path(new String[]{"org:opencrx:kernel:document1", "provider", components[0], "segment", components[1], "document", components[2]});
        }
        return null;
    }

    public String toObjectId(RefObject_1_0 object) {
        if (object == null) {
            return null;
        }
        Path path = object.refGetPath();
        if (object instanceof SyncFeed) {
            return SYNC_FEED_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6) + "/" + path.get(8) + "/" + path.get(10);
        }
        if (object instanceof ActivityTracker) {
            return ACTIVITY_TRACKER_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6);
        }
        if (object instanceof ActivityCategory) {
            return ACTIVITY_CATEGORY_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6);
        }
        if (object instanceof ActivityMilestone) {
            return ACTIVITY_MILESTONE_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6);
        }
        if (object instanceof ActivityFilterGlobal) {
            return ACTIVITY_FILTER_GLOBAL_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6);
        }
        if (object instanceof ActivityFilterGroup) {
            return ACTIVITY_FILTER_GROUP_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(5) + "/" + path.get(6) + "/" + path.get(8);
        }
        if (object instanceof UserHome) {
            return USER_HOME_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6);
        }
        if (object instanceof Activity) {
            return ACTIVITY_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6);
        }
        if (object instanceof Account) {
            return ACCOUNT_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6);
        }
        if (object instanceof Alert) {
            return ALERT_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6) + "/" + path.get(8);
        }
        if (object instanceof Media) {
            return MEDIA_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6) + "/" + path.get(8);
        }
        if (object instanceof DocumentFolder) {
            return DOCUMENT_FOLDER_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6);
        }
        if (object instanceof Document) {
            return DOCUMENT_URI_SCHEME + path.get(2) + "/" + path.get(4) + "/" + path.get(6);
        }
        return null;
    }

    public Account findAccountMember(Account parent, short memberRole) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)parent);
        MemberQuery memberQuery = (MemberQuery)pm.newQuery(Member.class);
        memberQuery.thereExistsMemberRole().equalTo((Object)memberRole);
        memberQuery.orderByName().ascending();
        List members = parent.getMember(memberQuery);
        return !members.isEmpty() ? ((Member)members.iterator().next()).getAccount() : null;
    }

    private List<AttendeeT> getAttendeesT(Activity activity) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)activity);
        ArrayList<AttendeeT> attendeesT = new ArrayList<AttendeeT>();
        List<AbstractActivityParty> parties = Activities.getInstance().getActivityParties(activity);
        for (AbstractActivityParty party : parties) {
            if (party.getPartyType() == Activities.PartyType.NA.getValue()) continue;
            RefObject_1_0 partyHolder = null;
            try {
                partyHolder = (RefObject_1_0)party.refGetValue("party");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (partyHolder == null) continue;
            try {
                String fullName;
                AttendeeType partyType;
                Account account = null;
                String emailAddress = null;
                if (partyHolder instanceof Account) {
                    account = (Account)partyHolder;
                    emailAddress = Accounts.getInstance().getPrimaryBusinessEMail(account, party.getEmailHint());
                } else if (partyHolder instanceof EMailAddress) {
                    account = (Account)pm.getObjectById((Object)partyHolder.refGetPath().getParent().getParent());
                    emailAddress = ((EMailAddress)partyHolder).getEmailAddress();
                }
                if ((partyType = party.getPartyType() == Activities.PartyType.OPTIONAL.getValue() ? AttendeeType.OPTIONAL : (party.getPartyType() == Activities.PartyType.REQUIRED.getValue() ? AttendeeType.REQUIRED : null)) == null || emailAddress == null) continue;
                AttendeeStatus attendeeStatus = AttendeeStatus.RESPONSE_UNKNOWN;
                if (party.getPartyStatus() == Activities.PartyStatus.ACCEPTED.getValue()) {
                    attendeeStatus = AttendeeStatus.ACCEPT;
                } else if (party.getPartyStatus() == Activities.PartyStatus.DECLINED.getValue()) {
                    attendeeStatus = AttendeeStatus.DECLINE;
                } else if (party.getPartyStatus() == Activities.PartyStatus.TENTATIVE.getValue()) {
                    attendeeStatus = AttendeeStatus.TENTATIVE;
                } else if (party.getPartyStatus() == Activities.PartyStatus.NEEDS_ACTION.getValue()) {
                    attendeeStatus = AttendeeStatus.NOT_RESPONDED;
                }
                String string = fullName = account == null ? null : account.getFullName();
                if (fullName == null) {
                    attendeesT.add(new AttendeeT(emailAddress, emailAddress, attendeeStatus, partyType));
                    continue;
                }
                attendeesT.add(new AttendeeT(emailAddress, fullName, attendeeStatus, partyType));
            }
            catch (ServiceException e) {
                if (e.getExceptionCode() == -9) continue;
                throw e;
            }
        }
        return attendeesT;
    }

    private MeetingStatus getCalendarMeetingStatus(Activity activity) {
        Short percentComplete = activity.getPercentComplete();
        if (Boolean.TRUE.equals(activity.isDisabled())) {
            return MeetingStatus.MEETING_IS_CANCELED;
        }
        if (percentComplete == null || ((Number)percentComplete).intValue() == 0) {
            return MeetingStatus.MEETING_RECEIVED;
        }
        return MeetingStatus.IS_A_MEETING;
    }

    private String getICalStatus(MeetingStatus status) {
        switch (status) {
            case IS_A_MEETING: {
                return "CONFIRMED";
            }
            case IS_NOT_A_MEETING: {
                return "CANCELLED";
            }
            case MEETING_RECEIVED: {
                return "TENTATIVE";
            }
            case MEETING_IS_CANCELED: {
                return "CANCELLED";
            }
            case MEETING_IS_CANCELED_AND_RECEIVED: {
                return "CANCELLED";
            }
        }
        return "CONFIRMED";
    }

    public RecurrenceT getRecurrence(Activity activity) {
        int start;
        int end;
        String ical = activity.getIcal();
        if (ical != null && ical.indexOf("RRULE:") > 0 && (end = ical.indexOf("\n", start = ical.indexOf("RRULE:"))) > start) {
            String[] params;
            RecurrenceT recurrenceT = new RecurrenceT();
            String rrule = ical.substring(start + 6, end);
            for (String param : params = rrule.split(";")) {
                if (param.startsWith("UNTIL=")) {
                    Object until = param.substring(6);
                    if (!((String)until).endsWith("Z")) {
                        until = ((String)until).length() >= 15 ? ((String)until).substring(0, 15) + "Z" : ((String)until).substring(0, 8) + "T000000Z";
                    }
                    recurrenceT.setUntil((Date)Datatypes.create(Date.class, (String)until));
                    continue;
                }
                if (param.startsWith("FREQ=")) {
                    String freq = param.substring(5);
                    if ("DAILY".equals(freq)) {
                        recurrenceT.setType(RecurrenceType.DAILY);
                        continue;
                    }
                    if ("WEEKLY".equals(freq)) {
                        recurrenceT.setType(RecurrenceType.WEEKLY);
                        continue;
                    }
                    if ("MONTHLY".equals(freq)) {
                        recurrenceT.setType(RecurrenceType.MONTHLY);
                        continue;
                    }
                    if (!"YEARLY".equals(freq)) continue;
                    recurrenceT.setType(RecurrenceType.YEARLY);
                    continue;
                }
                if (param.startsWith("BYWEEK=")) {
                    recurrenceT.setWeekOfMonth(Integer.valueOf(param.substring(7)));
                    continue;
                }
                if (param.startsWith("BYMONTH=")) {
                    recurrenceT.setMonthOfYear(Integer.valueOf(param.substring(8)));
                    continue;
                }
                if (param.startsWith("BYDAY=")) {
                    String[] days = param.substring(6).split(",");
                    HashSet<RecurrenceDayOfWeek> daysOfWeek = new HashSet<RecurrenceDayOfWeek>();
                    for (String day : days) {
                        try {
                            daysOfWeek.add(RecurrenceDayOfWeek.valueOf(day));
                        }
                        catch (Exception e) {
                            new ServiceException("DefaultDomain", -2, "Invalid day of week", new BasicException.Parameter[]{new BasicException.Parameter("day", (Object)day), new BasicException.Parameter("ical", (Object)ical), new BasicException.Parameter("activity", (Object)activity.refGetPath())}).log();
                        }
                    }
                    recurrenceT.setDayOfWeek(daysOfWeek);
                    continue;
                }
                if (param.startsWith("COUNT=")) {
                    recurrenceT.setOccurrences(Integer.valueOf(param.substring(6)));
                    continue;
                }
                if (!param.startsWith("INTERVAL=")) continue;
                recurrenceT.setInterval(Integer.valueOf(param.substring(9)));
            }
            return recurrenceT;
        }
        return null;
    }

    public String getICalRRule(RecurrenceT recurrenceT) {
        DateTimeFormat utcf = DateTimeFormat.BASIC_UTC_FORMAT;
        Object byDay = null;
        if (recurrenceT.getDayOfWeek() != null && !recurrenceT.getDayOfWeek().isEmpty()) {
            String sep = "";
            byDay = "";
            for (RecurrenceDayOfWeek day : recurrenceT.getDayOfWeek()) {
                byDay = (String)byDay + sep;
                byDay = (String)byDay + day.toString();
                sep = ",";
            }
        }
        return (String)(recurrenceT.getType() == null ? "" : "FREQ=" + recurrenceT.getType().toString()) + (String)(recurrenceT.getUntil() == null ? "" : ";UNTIL=" + utcf.format(recurrenceT.getUntil()).substring(0, 15) + "Z") + (String)(recurrenceT.getOccurrences() == null ? "" : ";COUNT=" + recurrenceT.getOccurrences()) + (String)(recurrenceT.getInterval() == null ? "" : ";INTERVAL=" + recurrenceT.getInterval()) + (String)(byDay == null ? "" : ";BYDAY=" + (String)byDay) + (String)(recurrenceT.getMonthOfYear() == null ? "" : ";BYMONTH=" + recurrenceT.getMonthOfYear()) + (String)(recurrenceT.getWeekOfMonth() == null ? "" : ";BYWEEK=" + recurrenceT.getWeekOfMonth());
    }

    private List<EventT> getExceptions(Activity activity) throws ServiceException {
        ArrayList<EventT> exceptionsT = new ArrayList<EventT>();
        String ical = activity.getIcal();
        int pos = 0;
        while (ical != null && ical.indexOf("EXDATE:", pos) >= 0) {
            int start = ical.indexOf("EXDATE:", pos);
            int end = ical.indexOf("\n", start);
            if (end > start) {
                String[] exdates;
                for (String exdate : exdates = ical.substring(start + 7, end).split(",")) {
                    try {
                        EventT exceptionT = new EventT();
                        exceptionT.setExceptionStartTime((Date)Datatypes.create(Date.class, (String)exdate));
                        exceptionT.setCategories(new ArrayList<String>(activity.getCategory()));
                        exceptionsT.add(exceptionT);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            pos = end;
        }
        return exceptionsT;
    }

    private String getICalExdates(List<EventT> exceptionsT) {
        DateTimeFormat utcf = DateTimeFormat.BASIC_UTC_FORMAT;
        String sep = "";
        Object exdates = "";
        for (EventT exceptionT : exceptionsT) {
            exdates = (String)exdates + sep;
            try {
                exdates = (String)exdates + utcf.format(exceptionT.getStartTime()).substring(0, 15) + "Z";
                sep = ",";
            }
            catch (Exception exception) {}
        }
        return exdates;
    }

    private Importance getImportance(Activity activity) {
        Short priority = activity.getPriority();
        if (priority != null) {
            if (priority.shortValue() == Activities.Priority.LOW.getValue()) {
                return Importance.LOW;
            }
            if (priority.shortValue() == Activities.Priority.NORMAL.getValue()) {
                return Importance.NORMAL;
            }
            if (priority.shortValue() == Activities.Priority.HIGH.getValue()) {
                return Importance.HIGH;
            }
            if (priority.shortValue() == Activities.Priority.URGENT.getValue()) {
                return Importance.HIGH;
            }
            if (priority.shortValue() == Activities.Priority.IMMEDIATE.getValue()) {
                return Importance.HIGH;
            }
        }
        return Importance.NORMAL;
    }

    private Importance getImportance(Alert alert) {
        Short importance = alert.getImportance();
        if (importance != null) {
            if (importance.shortValue() == Activities.Priority.LOW.getValue()) {
                return Importance.LOW;
            }
            if (importance.shortValue() == Activities.Priority.NORMAL.getValue()) {
                return Importance.NORMAL;
            }
            if (importance.shortValue() == Activities.Priority.HIGH.getValue()) {
                return Importance.HIGH;
            }
            if (importance.shortValue() == Activities.Priority.URGENT.getValue()) {
                return Importance.HIGH;
            }
            if (importance.shortValue() == Activities.Priority.IMMEDIATE.getValue()) {
                return Importance.HIGH;
            }
        }
        return Importance.NORMAL;
    }

    private String getICalPriority(Importance importance) {
        switch (importance) {
            case HIGH: {
                return "5";
            }
            case LOW: {
                return "1";
            }
        }
        return "2";
    }

    private AddressT getSender(Alert alert) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)alert);
        UserHome userHome = (UserHome)pm.getObjectById((Object)alert.refGetPath().getParent().getParent());
        EMailAccountQuery emailAccountQuery = (EMailAccountQuery)pm.newQuery(EMailAccount.class);
        emailAccountQuery.thereExistsIsDefault().isTrue();
        emailAccountQuery.thereExistsIsActive().isTrue();
        List eMailAccounts = userHome.getEMailAccount(emailAccountQuery);
        return eMailAccounts.isEmpty() ? null : new AddressT(((EMailAccount)eMailAccounts.iterator().next()).getName());
    }

    private AddressT getSender(EMail email) {
        AccountAddress sender = null;
        try {
            sender = email.getSender();
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
        if (sender != null && sender instanceof EMailAddress) {
            return new AddressT(((EMailAddress)sender).getEmailAddress());
        }
        return null;
    }

    private List<AttachmentT> getAttachments(Activity activity) throws ServiceException {
        ArrayList<AttachmentT> attachmentsT = new ArrayList<AttachmentT>();
        String originalMessageMediaName = activity.getActivityNumber().trim() + ".eml.zip";
        CrxObjectHasMedia.Media medias = activity.getMedia();
        Iterator iterator = medias.iterator();
        while (iterator.hasNext()) {
            Media media = (Media)iterator.next();
            if (media.getContentName() == null) continue;
            try {
                if (originalMessageMediaName.equals(media.getContentName())) continue;
                AttachmentT attachmentT = new AttachmentT();
                attachmentT.setAttachmentName(this.toObjectId(media));
                attachmentT.setDisplayName(media.getContentName());
                attachmentT.setEstimatedDataSize(1000);
                attachmentT.setIsInline(false);
                attachmentT.setMethod(MethodAttachment.NormalAttachment);
                attachmentsT.add(attachmentT);
            }
            catch (Exception e) {
                new ServiceException(e).log();
            }
        }
        return attachmentsT;
    }

    private EmailBodyT getEMailBody(EMail email) throws ServiceException {
        EmailBodyT bodyT = new EmailBodyT();
        String data = email.getMessageBody();
        bodyT.setData(data);
        bodyT.setType(MimeType.PlainText);
        bodyT.setEstimatedDataSize(data == null ? 0 : data.length());
        bodyT.setTruncated(false);
        return bodyT;
    }

    private EmailBodyT getEMailBody(Alert alert) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)alert);
        UserHome userHome = (UserHome)pm.getObjectById((Object)alert.refGetPath().getParent().getParent());
        EmailBodyT bodyT = new EmailBodyT();
        String data = Notifications.getInstance().getNotificationText(pm, (ContextCapable)alert, null, userHome, new HashMap<String, Object>());
        bodyT.setData(data);
        bodyT.setType(MimeType.PlainText);
        bodyT.setEstimatedDataSize(data.length());
        bodyT.setTruncated(false);
        return bodyT;
    }

    private String getEMailSubject(Alert alert) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)alert);
        UserHome userHome = (UserHome)pm.getObjectById((Object)alert.refGetPath().getParent().getParent());
        return Notifications.getInstance().getNotificationSubject(pm, (ContextCapable)alert, null, userHome, new HashMap<String, Object>(), true);
    }

    public SyncDataItem toEventT(Activity event, boolean noData, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        EventT eventT = new EventT();
        if (!noData) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)event);
            Account organizer = null;
            String organizerEmail = null;
            List<AbstractActivityParty> parties = Activities.getInstance().getActivityParties(event);
            for (AbstractActivityParty party : parties) {
                if (party.getPartyType() != Activities.PartyType.OPTIONAL.getValue()) continue;
                RefObject_1_0 partyHolder = null;
                try {
                    partyHolder = (RefObject_1_0)party.refGetValue("party");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (partyHolder == null) continue;
                if (partyHolder instanceof Account) {
                    organizer = (Account)partyHolder;
                    organizerEmail = Accounts.getInstance().getPrimaryBusinessEMail(organizer, party.getEmailHint());
                    continue;
                }
                if (!(partyHolder instanceof EMailAddress)) continue;
                organizer = (Account)pm.getObjectById((Object)partyHolder.refGetPath().getParent().getParent());
                organizerEmail = ((EMailAddress)partyHolder).getEmailAddress();
            }
            if (organizer == null && (organizer = event.getAssignedTo()) != null) {
                organizerEmail = Accounts.getInstance().getPrimaryBusinessEMail(organizer, null);
            }
            if (organizer != null) {
                eventT.setOrganizerName(organizer.getFullName());
            }
            eventT.setOrganizerEmail(organizerEmail);
            eventT.setBusyStatus(BusyStatus.TENTATIVE);
            eventT.setLocation(event.getLocation());
            eventT.setSubject(event.getName() + (String)(event.getActivityNumber() == null ? "" : " // #" + event.getActivityNumber()));
            eventT.setUID(this.getCalendarUID(event));
            String accessUrl = Base.getInstance().getAccessUrl(requestContext.getContext(), "-airsync-", event);
            eventT.setBody((event.getDescription() == null ? "" : event.getDescription().trim()) + (String)(accessUrl == null ? "" : " // " + accessUrl));
            eventT.setDtStamp(event.getModifiedAt());
            eventT.setEndTime(event.getScheduledEnd());
            eventT.setStartTime(event.getScheduledStart());
            eventT.setAllDayEvent(event.isAllDayEvent());
            eventT.setMeetingStatus(this.getCalendarMeetingStatus(event));
            eventT.setAttendees(this.getAttendeesT(event));
            eventT.setCategories(new ArrayList<String>(event.getCategory()));
            eventT.setRecurrence(this.getRecurrence(event));
            eventT.setExceptions(this.getExceptions(event));
        }
        SyncDataItem dataItem = new SyncDataItem();
        dataItem.setServerId(this.toObjectId(event));
        dataItem.setDataType(DataType.Calendar);
        dataItem.setData(eventT);
        return dataItem;
    }

    public SyncDataItem toEMailT(EMail email, boolean noData, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        EmailT emailT = new EmailT();
        if (!noData) {
            ArrayList<AddressT> to = new ArrayList<AddressT>();
            ArrayList<AddressT> cc = new ArrayList<AddressT>();
            ArrayList<AddressT> bcc = new ArrayList<AddressT>();
            try {
                List<Address> recipients = Activities.getInstance().mapMessageRecipients(email);
                for (Address recipient : recipients) {
                    if (!(recipient instanceof InternetAddress)) continue;
                    InternetAddress inetAddress = (InternetAddress)recipient;
                    if (Message.RecipientType.TO.equals(recipient.getType())) {
                        to.add(new AddressT(inetAddress.getAddress()));
                        continue;
                    }
                    if (Message.RecipientType.CC.equals(recipient.getType())) {
                        cc.add(new AddressT(inetAddress.getAddress()));
                        continue;
                    }
                    if (!Message.RecipientType.BCC.equals(recipient.getType())) continue;
                    bcc.add(new AddressT(inetAddress.getAddress()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            emailT.setSubject(email.getMessageSubject());
            emailT.setBody(this.getEMailBody(email));
            emailT.setDateReceived(email.getCreatedAt());
            emailT.setAttachements(this.getAttachments(email));
            emailT.setImportance(this.getImportance(email));
            emailT.setFrom(this.getSender(email));
            emailT.setTo(to);
            emailT.setCc(cc);
            emailT.setBcc(bcc);
            emailT.setRead(Boolean.TRUE);
        }
        SyncDataItem dataItem = new SyncDataItem();
        dataItem.setServerId(this.toObjectId(email));
        dataItem.setDataType(DataType.Email);
        dataItem.setData(emailT);
        return dataItem;
    }

    public SyncDataItem toEMailT(Alert alert, boolean noData, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        EmailT emailT = new EmailT();
        if (!noData) {
            ArrayList<AddressT> to = new ArrayList<AddressT>();
            ArrayList<AddressT> cc = new ArrayList<AddressT>();
            ArrayList<AddressT> bcc = new ArrayList<AddressT>();
            emailT.setSubject(this.getEMailSubject(alert));
            emailT.setBody(this.getEMailBody(alert));
            emailT.setDateReceived(alert.getCreatedAt());
            emailT.setImportance(this.getImportance(alert));
            emailT.setFrom(this.getSender(alert));
            emailT.setFrom(this.getSender(alert));
            emailT.setTo(to);
            emailT.setCc(cc);
            emailT.setBcc(bcc);
            emailT.setRead(alert.getAlertState() != UserHomes.AlertState.NEW.getValue());
        }
        SyncDataItem dataItem = new SyncDataItem();
        dataItem.setServerId(this.toObjectId(alert));
        dataItem.setDataType(DataType.Email);
        dataItem.setData(emailT);
        return dataItem;
    }

    public SyncDataItem toTaskT(Activity task, boolean noData, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        TaskT taskT = new TaskT();
        if (!noData) {
            DateTimeFormat userf = this.getUserDateTimeFormat(user);
            DateTimeFormat utcf = DateTimeFormat.BASIC_UTC_FORMAT;
            taskT.setCategories(new ArrayList<String>(task.getCategory()));
            taskT.setComplete(task.getPercentComplete() != null && task.getPercentComplete().intValue() >= 100 && task.getActualEnd() != null);
            taskT.setDatecompleted(task.getActualEnd());
            try {
                taskT.setDuedate(utcf.parse(userf.format(task.getDueBy())));
            }
            catch (Exception e) {
                taskT.setDuedate(task.getDueBy());
            }
            taskT.setUtcduedate(task.getDueBy());
            taskT.setImportance(this.getImportance(task));
            taskT.setRecurrence(this.getRecurrence(task));
            taskT.setSensitivity(Sensitivity.NORMAL);
            try {
                taskT.setStartdate(utcf.parse(userf.format(task.getScheduledStart())));
            }
            catch (Exception e) {
                taskT.setStartdate(task.getScheduledStart());
            }
            taskT.setUtcstartdate(task.getScheduledStart());
            taskT.setSubject(task.getName() + (String)(task.getActivityNumber() == null ? "" : " // #" + task.getActivityNumber().trim()));
            String accessUrl = Base.getInstance().getAccessUrl(requestContext.getContext(), "-airsync-", task);
            taskT.setBody((task.getDescription() == null ? "" : task.getDescription().trim()) + (String)(accessUrl == null ? "" : " // " + accessUrl));
        }
        SyncDataItem dataItem = new SyncDataItem();
        dataItem.setServerId(this.toObjectId(task));
        dataItem.setDataType(DataType.Tasks);
        dataItem.setData(taskT);
        return dataItem;
    }

    public SyncDataItem toContactT(Account account, boolean noData, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        ContactT contactT = new ContactT();
        if (!noData) {
            String sep;
            Account assistant = this.findAccountMember(account, (short)17);
            AccountAddress[] contactAddresses = Accounts.getInstance().getMainAddresses(account);
            contactT.setFileAs(account.getFullName());
            if (account instanceof Contact) {
                Contact contact = (Contact)account;
                contactT.setFirstName(contact.getFirstName());
                contactT.setMiddleName(contact.getMiddleName());
                contactT.setDepartment(contact.getDepartment());
                contactT.setSuffix(contact.getSuffix());
                contactT.setNickName(contact.getNickName());
                contactT.setCompanyName(contact.getOrganization());
                contactT.setTitle(contact.getSalutation());
                contactT.setLastName(contact.getLastName());
                contactT.setJobTitle(contact.getJobTitle());
                contactT.setAnniversary(contact.getAnniversary());
                contactT.setBirthday(contact.getBirthdate());
                contactT.setChildren(new ArrayList<String>(contact.getChildrenNames()));
                if (contact.getPicture() != null && "image/jpeg".equals(contact.getPicture().getContentMimeType())) {
                    contactT.setPicture(Base64.encode((byte[])contact.getPictureContent()));
                }
            } else if (account instanceof AbstractGroup) {
                contactT.setLastName(account.getFullName());
            }
            contactT.setCategories(new ArrayList<String>(account.getCategory()));
            String accessUrl = Base.getInstance().getAccessUrl(requestContext.getContext(), "-airsync-", account);
            contactT.setBody((account.getDescription() == null ? "" : account.getDescription().trim()) + (String)(accessUrl == null ? "" : " // " + accessUrl));
            if (assistant != null) {
                contactT.setAssistantName(assistant.getFullName());
                String assistantPhoneNumber = Accounts.getInstance().getPrimaryBusinessPhone(assistant);
                contactT.setAssistantPhoneNumber(assistantPhoneNumber);
                contactT.setAssistnamePhoneNumber(assistantPhoneNumber);
            }
            if (contactAddresses[6] != null) {
                PostalAddress postalBusiness = (PostalAddress)contactAddresses[6];
                contactT.setBusinessAddressCity(postalBusiness.getPostalCity());
                contactT.setBusinessPostalCode(postalBusiness.getPostalCode());
                contactT.setBusinessState(postalBusiness.getPostalState());
                sep = "";
                Object businessStreet = "";
                for (String line : postalBusiness.getPostalAddressLine()) {
                    businessStreet = (String)businessStreet + sep;
                    businessStreet = (String)businessStreet + line;
                    sep = "\r\n";
                }
                for (String street : postalBusiness.getPostalStreet()) {
                    businessStreet = (String)businessStreet + sep;
                    businessStreet = (String)businessStreet + street;
                    sep = "\r\n";
                }
                if (businessStreet != null) {
                    businessStreet = ((String)businessStreet).trim();
                    while (!sep.isEmpty() && ((String)businessStreet).endsWith(sep)) {
                        businessStreet = ((String)businessStreet).substring(0, ((String)businessStreet).length() - sep.length());
                    }
                }
                contactT.setBusinessStreet((String)businessStreet);
                contactT.setBusinessAddressCountry(Addresses.POSTAL_COUNTRIES_BY_CODE.get(postalBusiness.getPostalCountry()));
            }
            if (contactAddresses[8] != null) {
                PostalAddress postalHome = (PostalAddress)contactAddresses[8];
                contactT.setHomeAddressCity(postalHome.getPostalCity());
                contactT.setHomeAddressPostalCode(postalHome.getPostalCode());
                contactT.setHomeAddressState(postalHome.getPostalState());
                sep = "";
                Object homeStreet = "";
                for (String line : postalHome.getPostalAddressLine()) {
                    homeStreet = (String)homeStreet + sep;
                    homeStreet = (String)homeStreet + line;
                    sep = "\r\n";
                }
                for (String street : postalHome.getPostalStreet()) {
                    homeStreet = (String)homeStreet + sep;
                    homeStreet = (String)homeStreet + street;
                    sep = "\r\n";
                }
                if (homeStreet != null) {
                    homeStreet = ((String)homeStreet).trim();
                    while (!sep.isEmpty() && ((String)homeStreet).endsWith(sep)) {
                        homeStreet = ((String)homeStreet).substring(0, ((String)homeStreet).length() - sep.length());
                    }
                }
                contactT.setHomeAddressStreet((String)homeStreet);
                contactT.setHomeAddressCountry(Addresses.POSTAL_COUNTRIES_BY_CODE.get(postalHome.getPostalCountry()));
            }
            if (contactAddresses[2] != null) {
                PhoneNumber phoneBusiness = (PhoneNumber)contactAddresses[2];
                contactT.setBusinessPhoneNumber(phoneBusiness.getPhoneNumberFull());
            }
            if (contactAddresses[3] != null) {
                PhoneNumber phoneHome = (PhoneNumber)contactAddresses[3];
                contactT.setHomePhoneNumber(phoneHome.getPhoneNumberFull());
            }
            if (contactAddresses[11] != null) {
                PhoneNumber phoneNumberOther = (PhoneNumber)contactAddresses[11];
                contactT.setBusiness2PhoneNumber(phoneNumberOther.getPhoneNumberFull());
            }
            if (contactAddresses[7] != null) {
                WebAddress webAddress = (WebAddress)contactAddresses[7];
                contactT.setWebPage(webAddress.getWebUrl());
            }
            if (contactAddresses[4] != null) {
                PhoneNumber faxBusiness = (PhoneNumber)contactAddresses[4];
                contactT.setBusinessFaxNumber(faxBusiness.getPhoneNumberFull());
            }
            if (contactAddresses[5] != null) {
                PhoneNumber faxHome = (PhoneNumber)contactAddresses[5];
                contactT.setHomeFaxNumber(faxHome.getPhoneNumberFull());
            }
            if (contactAddresses[10] != null) {
                PhoneNumber phoneMobile = (PhoneNumber)contactAddresses[10];
                contactT.setMobilePhoneNumber(phoneMobile.getPhoneNumberFull());
            }
            if (contactAddresses[0] != null) {
                EMailAddress emailBusiness = (EMailAddress)contactAddresses[0];
                contactT.setEmail1Address(emailBusiness.getEmailAddress());
            }
            if (contactAddresses[1] != null) {
                EMailAddress emailHome = (EMailAddress)contactAddresses[1];
                contactT.setEmail2Address(emailHome.getEmailAddress());
            }
        }
        SyncDataItem dataItem = new SyncDataItem();
        dataItem.setServerId(this.toObjectId(account));
        dataItem.setDataType(DataType.Contacts);
        dataItem.setData(contactT);
        return dataItem;
    }

    public SyncDataItem toNoteT(Document document, boolean noData, UserHome user, SyncBackend.RequestContext requestContext) throws ServiceException {
        DocumentRevision headRevision;
        NoteT noteT = new NoteT();
        if (!noData && (headRevision = document.getHeadRevision()) instanceof MediaContent) {
            MediaContent content = (MediaContent)headRevision;
            noteT.setSubject(document.getName());
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            try {
                BinaryLargeObjects.streamCopy((InputStream)content.getContent().getContent(), (long)0L, (OutputStream)bytes);
                noteT.setBody(new String(bytes.toString("UTF-8")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (document.getKeywords() != null) {
                noteT.setCategories(Arrays.asList(document.getKeywords().split(",")));
            }
            noteT.setLastModifiedDate(headRevision.getCreatedAt());
        }
        SyncDataItem dataItem = new SyncDataItem();
        dataItem.setServerId(this.toObjectId(document));
        dataItem.setDataType(DataType.Notes);
        dataItem.setData(noteT);
        return dataItem;
    }

    public AttachmentDataT toAttachmentData(RefObject_1_0 object) throws ServiceException {
        if (object instanceof Media) {
            try {
                AttachmentDataT attachmentDataT = new AttachmentDataT();
                Media media = (Media)object;
                attachmentDataT.setContentType(media.getContentMimeType());
                attachmentDataT.setContent(media.getContent().getContent());
                return attachmentDataT;
            }
            catch (Exception e) {
                throw new ServiceException(e);
            }
        }
        return null;
    }

    public Account newAccount(PersistenceManager pm, ContactT contactT) {
        return (Account)pm.newInstance(Contact.class);
    }
}

