/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.datatypes;

import java.util.HashSet;
import java.util.Set;

public enum RecurrenceDayOfWeek {
    SU,
    MO,
    TU,
    WE,
    TH,
    FR,
    SA;


    public int asInt() {
        switch (this) {
            case SU: {
                return 1;
            }
            case MO: {
                return 2;
            }
            case TU: {
                return 4;
            }
            case WE: {
                return 8;
            }
            case TH: {
                return 16;
            }
            case FR: {
                return 32;
            }
            case SA: {
                return 64;
            }
        }
        return 0;
    }

    public static int dayOfWeekToInt(int i) {
        switch (i) {
            case 1: {
                return SU.asInt();
            }
            case 2: {
                return MO.asInt();
            }
            case 3: {
                return TU.asInt();
            }
            case 4: {
                return WE.asInt();
            }
            case 5: {
                return TH.asInt();
            }
            case 6: {
                return FR.asInt();
            }
        }
        return SA.asInt();
    }

    public static int asInt(Set<RecurrenceDayOfWeek> dayOfWeek) {
        int pattern = 0;
        if (dayOfWeek.contains((Object)MO)) {
            pattern |= MO.asInt();
        }
        if (dayOfWeek.contains((Object)TU)) {
            pattern |= TU.asInt();
        }
        if (dayOfWeek.contains((Object)WE)) {
            pattern |= WE.asInt();
        }
        if (dayOfWeek.contains((Object)TH)) {
            pattern |= TH.asInt();
        }
        if (dayOfWeek.contains((Object)FR)) {
            pattern |= FR.asInt();
        }
        if (dayOfWeek.contains((Object)SA)) {
            pattern |= SA.asInt();
        }
        if (dayOfWeek.contains((Object)SU)) {
            pattern |= SU.asInt();
        }
        return pattern;
    }

    public static Set<RecurrenceDayOfWeek> fromInt(Integer i) {
        HashSet<RecurrenceDayOfWeek> ret = new HashSet<RecurrenceDayOfWeek>();
        if ((i & MO.asInt()) == MO.asInt()) {
            ret.add(MO);
        }
        if ((i & TU.asInt()) == TU.asInt()) {
            ret.add(TU);
        }
        if ((i & WE.asInt()) == WE.asInt()) {
            ret.add(WE);
        }
        if ((i & TH.asInt()) == TH.asInt()) {
            ret.add(TH);
        }
        if ((i & FR.asInt()) == FR.asInt()) {
            ret.add(FR);
        }
        if ((i & SA.asInt()) == SA.asInt()) {
            ret.add(SA);
        }
        if ((i & SU.asInt()) == SU.asInt()) {
            ret.add(SU);
        }
        return ret;
    }
}

