/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.stream.StreamResult;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.server.ServerHandler;
import org.opencrx.application.airsync.server.SyncRequest;
import org.opencrx.application.airsync.server.SyncResponse;
import org.opencrx.application.airsync.utils.WbXMLTransformer;
import org.opencrx.kernel.utils.QuotaByteArrayOutputStream;
import org.openmdx.base.exception.ServiceException;
import org.w3c.dom.Document;

public abstract class AbstractServerHandler
implements ServerHandler {
    protected SyncBackend backend;
    protected static final Logger logger = Logger.getLogger(AbstractServerHandler.class.getPackage().getName());
    private final String profilePrefix;

    protected AbstractServerHandler(SyncBackend backend, String profilePrefix) {
        this.backend = backend;
        this.profilePrefix = profilePrefix;
    }

    protected String getProfilePrefix() {
        return this.profilePrefix;
    }

    protected String getProfileName(SyncRequest request) {
        return this.getProfilePrefix() + request.getDeviceId();
    }

    @Override
    public void handle(SyncRequest request, SyncResponse response) throws IOException {
        Document docRequest = null;
        PushbackInputStream in = new PushbackInputStream(request.getInputStream());
        int b = in.read();
        if (b >= 0) {
            try {
                in.unread(b);
                docRequest = WbXMLTransformer.transformFromWBXML(in);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("=-=-=-= Request =-=-=-= ");
                    QuotaByteArrayOutputStream xml = new QuotaByteArrayOutputStream(AbstractServerHandler.class.getName());
                    WbXMLTransformer.transform(docRequest, new StreamResult(xml), true);
                    xml.close();
                    logger.finest(new String(xml.getBuffer(), 0, xml.size(), "UTF-8"));
                    logger.finest("=-=-=-= Request =-=-=-= ");
                }
            }
            catch (Exception e) {
                new ServiceException(e).log();
            }
        }
        Document docResponse = this.handle(request, docRequest);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("=-=-=-=  Response =-=-=-= ");
            QuotaByteArrayOutputStream xml = new QuotaByteArrayOutputStream(AbstractServerHandler.class.getName());
            WbXMLTransformer.transform(docResponse, new StreamResult(xml), true);
            xml.close();
            logger.finest(new String(xml.getBuffer(), 0, xml.size(), "UTF-8"));
            logger.finest("=-=-=-=  Response =-=-=-= ");
        }
        response.setContentType("application/vnd.ms-sync.wbxml");
        response.setStatus(200);
        OutputStream out = response.getOutputStream();
        WbXMLTransformer.transformToWBXML(docResponse, out);
        out.flush();
    }

    protected abstract Document handle(SyncRequest var1, Document var2);
}

