/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.opencrx.application.airsync.backend.cci.GetChangedDataItemsResult;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.datatypes.DataFormatFactory;
import org.opencrx.application.airsync.datatypes.IData;
import org.opencrx.application.airsync.datatypes.IDataFormat;
import org.opencrx.application.airsync.datatypes.SyncCollection;
import org.opencrx.application.airsync.datatypes.SyncDataItem;
import org.opencrx.application.airsync.datatypes.SyncStatus;
import org.opencrx.application.airsync.server.AbstractServerHandler;
import org.opencrx.application.airsync.server.SyncRequest;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.opencrx.kernel.backend.Base;
import org.openmdx.base.exception.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SyncHandler
extends AbstractServerHandler {
    private static final int BATCH_SIZE = 64;

    public SyncHandler(SyncBackend backend, String profilePrefix) {
        super(backend, profilePrefix);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Document handle(SyncRequest request, Document docRequest) {
        Object data;
        SyncBackend.RequestContext requestContext = this.backend.newRequestContext(request.getUserId(), request.getContext());
        String profileName = this.getProfileName(request);
        ArrayList<SyncCollection> requestedCollections = new ArrayList<SyncCollection>();
        HashMap<String, SyncResponse> syncResponses = new HashMap<String, SyncResponse>();
        ArrayList<String> fetchIds = new ArrayList<String>();
        if (docRequest != null) {
            Element eRoot = docRequest.getDocumentElement();
            NodeList lCollection = eRoot.getElementsByTagNameNS("AirSync:", "Collection");
            for (int i = 0; i < lCollection.getLength(); ++i) {
                try {
                    Element eCollection = (Element)lCollection.item(i);
                    SyncCollection collection = SyncCollection.decode("AirSync:", eCollection);
                    Element eCommands = DOMUtils.getUniqueElement(eCollection, "AirSync:", "Commands");
                    if (eCommands != null) {
                        NodeList lCommand = eCommands.getChildNodes();
                        for (int j = 0; j < lCommand.getLength(); ++j) {
                            Node node = lCommand.item(j);
                            if (!(node instanceof Element)) continue;
                            Element eCommand = (Element)node;
                            String command = eCommand.getNodeName();
                            String serverId = DOMUtils.getElementText(eCommand, "AirSync:", "ServerId");
                            String clientId = DOMUtils.getElementText(eCommand, "AirSync:", "ClientId");
                            Element eApplicationData = DOMUtils.getUniqueElement(eCommand, "AirSync:", "ApplicationData");
                            IDataFormat iDataFormat = DataFormatFactory.getXmlFormat(collection.getDataType());
                            data = null;
                            if (eApplicationData != null) {
                                data = iDataFormat.parse(eApplicationData);
                            }
                            if (command.endsWith("Modify")) {
                                if (data == null) continue;
                                try {
                                    if (data.isRead()) {
                                        this.backend.setDataItemReadFlag(requestContext, collection.getCollectionId(), serverId, data.isRead());
                                    } else {
                                        this.backend.createOrUpdateDataItem(requestContext, profileName, collection, serverId, (IData)data);
                                    }
                                    collection.setImportedChanges(true);
                                    syncResponses.put(serverId, new SyncResponse("Modify", clientId, serverId, 1));
                                }
                                catch (Exception e) {
                                    new ServiceException(e).log();
                                    syncResponses.put(serverId, new SyncResponse("Modify", clientId, serverId, 5));
                                }
                                continue;
                            }
                            if (command.endsWith("Add")) {
                                if (data == null) continue;
                                try {
                                    String newServerId = this.backend.createOrUpdateDataItem(requestContext, profileName, collection, null, (IData)data);
                                    if (newServerId == null || clientId == null) continue;
                                    syncResponses.put(newServerId, new SyncResponse("Add", clientId, newServerId, 1));
                                    collection.setImportedChanges(true);
                                }
                                catch (Exception e) {
                                    new ServiceException(e).log();
                                    syncResponses.put(Base.getInstance().getUidAsString(), new SyncResponse("Add", clientId, null, 5));
                                }
                                continue;
                            }
                            if (command.endsWith("Change")) {
                                if (data == null) continue;
                                try {
                                    this.backend.createOrUpdateDataItem(requestContext, profileName, collection, serverId, (IData)data);
                                    syncResponses.put(serverId, new SyncResponse("Change", clientId, serverId, 1));
                                    collection.setImportedChanges(true);
                                }
                                catch (Exception e) {
                                    new ServiceException(e).log();
                                    syncResponses.put(serverId, new SyncResponse("Change", clientId, serverId, 5));
                                }
                                continue;
                            }
                            if (command.endsWith("Delete")) {
                                try {
                                    this.backend.deleteDataItem(requestContext, profileName, collection, serverId);
                                    syncResponses.put(serverId, new SyncResponse("Delete", clientId, serverId, 1));
                                    collection.setImportedChanges(true);
                                }
                                catch (Exception e) {
                                    new ServiceException(e).log();
                                    syncResponses.put(serverId, new SyncResponse("Delete", clientId, serverId, 5));
                                }
                                continue;
                            }
                            if (!command.endsWith("Fetch")) continue;
                            fetchIds.add(serverId);
                        }
                    }
                    requestedCollections.add(collection);
                    continue;
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
            }
        }
        Document docResponse = null;
        docResponse = DOMUtils.createDoc("AirSync:", "Sync", {"xmlns:Email", "POOMMAIL:"}, {"xmlns:Email2", "POOMMAIL2:"}, {"xmlns:Contacts", "POOMCONTACTS:"}, {"xmlns:Contacts2", "POOMCONTACTS2:"}, {"xmlns:Tasks", "POOMTASKS:"}, {"xmlns:Calendar", "POOMCAL:"}, {"xmlns:AirSyncBase", "AirSyncBase:"});
        Element eRoot = docResponse.getDocumentElement();
        Element eCollections = DOMUtils.createElement(eRoot, null, "Collections");
        for (SyncCollection collection : requestedCollections) {
            String newSyncKey = null;
            boolean hasMore = false;
            ArrayList newDataItems = null;
            ArrayList changedDataItems = null;
            List<String> deletedItemIds = null;
            if (!"0".equals(collection.getSyncKey()) && collection.isGetChanges()) {
                try {
                    int windowSize = collection.getWindowSize() == null ? 64 : collection.getWindowSize();
                    HashSet<String> excludes = new HashSet<String>();
                    logger.log(Level.FINE, "Get new items for client collection {0} and syncKey {1}", new String[]{collection.getCollectionId(), collection.getSyncKey()});
                    Iterator getNewDataItemsResult = this.backend.getChangedDataItems(requestContext, profileName, collection, false, windowSize, SyncDataItem.State.NEW, excludes);
                    for (List list : ((GetChangedDataItemsResult)((Object)getNewDataItemsResult)).getDataItems().values()) {
                        for (SyncDataItem dataItem : list) {
                            excludes.add(dataItem.getServerId());
                        }
                    }
                    logger.log(Level.FINE, "Get changed items for client collection {0} and syncKey {1}", new String[]{collection.getCollectionId(), collection.getSyncKey()});
                    GetChangedDataItemsResult getChangedDataItemsResult = this.backend.getChangedDataItems(requestContext, profileName, collection, false, windowSize, SyncDataItem.State.MODIFIED, excludes);
                    newSyncKey = ((GetChangedDataItemsResult)((Object)getNewDataItemsResult)).getDataItems().isEmpty() ? getChangedDataItemsResult.getSyncKey() : (getChangedDataItemsResult.getDataItems().isEmpty() ? ((GetChangedDataItemsResult)((Object)getNewDataItemsResult)).getSyncKey() : (((GetChangedDataItemsResult)((Object)getNewDataItemsResult)).getSyncKey().compareTo(getChangedDataItemsResult.getSyncKey()) < 0 ? ((GetChangedDataItemsResult)((Object)getNewDataItemsResult)).getSyncKey() : getChangedDataItemsResult.getSyncKey()));
                    hasMore = ((GetChangedDataItemsResult)((Object)getNewDataItemsResult)).hasMore() || getChangedDataItemsResult.hasMore();
                    for (Map.Entry<String, List<SyncDataItem>> entries : ((GetChangedDataItemsResult)((Object)getNewDataItemsResult)).getDataItems().entrySet()) {
                        if (entries.getKey().compareTo(newSyncKey) <= 0) {
                            if (newDataItems == null) {
                                newDataItems = new ArrayList();
                            }
                            newDataItems.addAll(entries.getValue());
                            continue;
                        }
                        hasMore = true;
                    }
                    for (Map.Entry<String, List<SyncDataItem>> entries : getChangedDataItemsResult.getDataItems().entrySet()) {
                        if (entries.getKey().compareTo(newSyncKey) <= 0) {
                            if (changedDataItems == null) {
                                changedDataItems = new ArrayList();
                            }
                            changedDataItems.addAll(entries.getValue());
                            continue;
                        }
                        hasMore = true;
                    }
                    if (newDataItems != null && !newDataItems.isEmpty() || changedDataItems != null && !changedDataItems.isEmpty()) {
                        deletedItemIds = this.backend.getDeletedDataItems(requestContext, profileName, collection, newSyncKey);
                    } else {
                        String string = this.backend.getNextSyncKey(requestContext, newSyncKey);
                        deletedItemIds = this.backend.getDeletedDataItems(requestContext, profileName, collection, string);
                        if (!deletedItemIds.isEmpty()) {
                            newSyncKey = string;
                        }
                    }
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
            } else if ("0".equals(collection.getSyncKey())) {
                try {
                    newSyncKey = this.backend.getNextSyncKey(requestContext, collection.getSyncKey());
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
            } else {
                newSyncKey = collection.getSyncKey();
            }
            Element eCollection = DOMUtils.createElement(eCollections, null, "Collection");
            if (collection.getDataType() != null) {
                DOMUtils.createElementAndText(eCollection, null, "Class", collection.getDataType().toString());
            }
            DOMUtils.createElementAndText(eCollection, null, "SyncKey", newSyncKey);
            DOMUtils.createElementAndText(eCollection, null, "CollectionId", collection.getCollectionId());
            DOMUtils.createElementAndText(eCollection, null, "Status", "1");
            Element eResponses = DOMUtils.createElement(eCollection, null, "Responses");
            for (SyncResponse syncResponse : syncResponses.values()) {
                Element element = DOMUtils.createElement(eResponses, null, syncResponse.command);
                if (syncResponse.clientId != null) {
                    DOMUtils.createElementAndText(element, null, "ClientId", syncResponse.clientId);
                }
                if (syncResponse.serverId != null) {
                    DOMUtils.createElementAndText(element, null, "ServerId", syncResponse.serverId);
                }
                DOMUtils.createElementAndText(element, null, "Status", Integer.toString(syncResponse.status));
            }
            for (String id : fetchIds) {
                void var22_43;
                SyncStatus syncStatus = SyncStatus.OK;
                SyncDataItem dataItem = null;
                try {
                    dataItem = this.backend.fetchDataItem(requestContext, profileName, collection, id);
                    if (dataItem == null) {
                        SyncStatus syncStatus2 = SyncStatus.OBJECT_NOT_FOUND;
                    }
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    SyncStatus syncStatus3 = SyncStatus.SERVER_ERROR;
                }
                Element eFetch = DOMUtils.createElement(eResponses, null, "Fetch");
                DOMUtils.createElementAndText(eFetch, null, "ServerId", id);
                DOMUtils.createElementAndText(eFetch, null, "Status", Integer.toString(var22_43.getValue()));
                if (var22_43 != SyncStatus.OK) continue;
                IData data2 = dataItem.getData();
                Element eApplicationData = DOMUtils.createElement(eFetch, null, "ApplicationData");
                try {
                    DataFormatFactory.getXmlFormat(data2.getType()).format(eApplicationData, data2, request.getProtocolVersion());
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
            }
            if (eResponses.getChildNodes().getLength() == 0) {
                eResponses.getParentNode().removeChild(eResponses);
            }
            if (collection.isGetChanges() && (newDataItems != null && !newDataItems.isEmpty() || changedDataItems != null && !changedDataItems.isEmpty() || deletedItemIds != null && !deletedItemIds.isEmpty())) {
                Element eApplicationData;
                Element eCommand;
                Element eCommands = DOMUtils.createElement(eCollection, null, "Commands");
                if (newDataItems != null) {
                    for (SyncDataItem syncDataItem : newDataItems) {
                        if (syncResponses.keySet().contains(syncDataItem.getServerId())) continue;
                        data = syncDataItem.getData();
                        eCommand = null;
                        eCommand = DOMUtils.createElement(eCommands, null, "Add");
                        DOMUtils.createElementAndText(eCommand, null, "ServerId", syncDataItem.getServerId());
                        eApplicationData = DOMUtils.createElement(eCommand, null, "ApplicationData");
                        try {
                            DataFormatFactory.getXmlFormat(data.getType()).format(eApplicationData, (IData)data, request.getProtocolVersion());
                        }
                        catch (Exception e) {
                            new ServiceException(e).log();
                        }
                    }
                }
                if (changedDataItems != null) {
                    for (SyncDataItem syncDataItem : changedDataItems) {
                        if (syncResponses.keySet().contains(syncDataItem.getServerId())) continue;
                        data = syncDataItem.getData();
                        eCommand = null;
                        eCommand = DOMUtils.createElement(eCommands, null, "Change");
                        DOMUtils.createElementAndText(eCommand, null, "ServerId", syncDataItem.getServerId());
                        eApplicationData = DOMUtils.createElement(eCommand, null, "ApplicationData");
                        try {
                            DataFormatFactory.getXmlFormat(data.getType()).format(eApplicationData, (IData)data, request.getProtocolVersion());
                        }
                        catch (Exception e) {
                            new ServiceException(e).log();
                        }
                    }
                }
                if (deletedItemIds != null) {
                    for (String string : deletedItemIds) {
                        if (syncResponses.keySet().contains(string)) continue;
                        Element eDelete = DOMUtils.createElement(eCommands, null, "Delete");
                        DOMUtils.createElementAndText(eDelete, null, "ServerId", string);
                    }
                }
                if (eCommands.getChildNodes().getLength() == 0) {
                    eCommands.getParentNode().removeChild(eCommands);
                }
            }
            if (!hasMore) continue;
            DOMUtils.createElement(eCollection, null, "MoreAvailable");
        }
        return docResponse;
    }

    private static class SyncResponse {
        public final String command;
        public final String clientId;
        public final String serverId;
        public final int status;

        public SyncResponse(String command, String clientId, String serverId, int status) {
            this.command = command;
            this.clientId = clientId;
            this.serverId = serverId;
            this.status = status;
        }
    }
}

