/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.caldav;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.opencrx.application.caldav.CalDavRequestContext;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.jmi1.Creatable;
import org.openmdx.base.jmi1.Modifiable;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;

abstract class CalDavResource
implements Resource {
    private final RequestContext requestContext;
    private final ContextCapable object;

    public CalDavResource(RequestContext requestContext, ContextCapable object) {
        this.requestContext = requestContext;
        this.object = object;
    }

    @Override
    public Date getCreationDate() {
        return this.object instanceof Creatable ? ((Creatable)this.object).getCreatedAt() : new Date();
    }

    @Override
    public Date getLastModified() {
        return this.object instanceof Modifiable ? ((Modifiable)this.object).getModifiedAt() : new Date();
    }

    public ContextCapable getObject() {
        return this.object;
    }

    public <T extends Resource> Collection<T> getChildren(Date timeRangeStart, Date timeRangeEnd) {
        return Collections.emptyList();
    }

    public CalDavRequestContext getRequestContext() {
        return (CalDavRequestContext)this.requestContext;
    }

    @Override
    public String getName() {
        return this.object.refGetPath().getLastSegment().toString();
    }

    public String getMimeType() {
        return "application/xml";
    }

    public WebDavStore.ResourceContent getContent() {
        return new WebDavStore.ResourceContent(){

            @Override
            public BinaryLargeObject getContent() {
                return BinaryLargeObjects.valueOf((byte[])new byte[0]);
            }

            @Override
            public Long getLength() {
                return 0L;
            }
        };
    }
}

