/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.caldav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.opencrx.application.caldav.ActivityCollectionResource;
import org.opencrx.application.caldav.CalDavResource;
import org.opencrx.application.caldav.SyncFeedBasedActivityCollectionResource;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.kernel.home1.cci2.SyncProfileContainsSyncFeed;
import org.opencrx.kernel.home1.jmi1.ActivityFilterCalendarFeed;
import org.opencrx.kernel.home1.jmi1.ActivityGroupCalendarFeed;
import org.opencrx.kernel.home1.jmi1.CalendarProfile;
import org.opencrx.kernel.home1.jmi1.SyncFeed;
import org.opencrx.kernel.home1.jmi1.SyncProfile;
import org.openmdx.base.jmi1.ContextCapable;

class CalendarProfileResource
extends CalDavResource {
    private final String runAs;

    public CalendarProfileResource(RequestContext requestContext, CalendarProfile syncProfile, String runAs) {
        super(requestContext, (ContextCapable)syncProfile);
        this.runAs = runAs;
    }

    public SyncProfile getObject() {
        return (SyncProfile)super.getObject();
    }

    @Override
    public String getDisplayName() {
        return this.getObject().getName();
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    public Collection<Resource> getChildren(Date timeRangeStart, Date timeRangeEnd) {
        SyncProfile syncProfile = this.getObject();
        ArrayList<Resource> children = new ArrayList<Resource>();
        SyncProfileContainsSyncFeed.Feed syncFeeds = syncProfile.getFeed();
        Iterator iterator = syncFeeds.iterator();
        while (iterator.hasNext()) {
            SyncFeed syncFeed = (SyncFeed)iterator.next();
            if (!Boolean.TRUE.equals(syncFeed.isActive()) || !(syncFeed instanceof ActivityGroupCalendarFeed) && !(syncFeed instanceof ActivityFilterCalendarFeed)) continue;
            children.add(new SyncFeedBasedActivityCollectionResource(this.getRequestContext(), syncFeed, ActivityCollectionResource.Type.VEVENT, this.runAs));
            children.add(new SyncFeedBasedActivityCollectionResource(this.getRequestContext(), syncFeed, ActivityCollectionResource.Type.VTODO, this.runAs));
        }
        return children;
    }
}

