/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.carddav;

import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.carddav.AccountCollectionResource;
import org.opencrx.application.carddav.AccountResource;
import org.opencrx.application.carddav.CardProfileResource;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.Resource;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.uses.net.sf.webdav.fromcatalina.XMLWriter;
import org.opencrx.kernel.home1.jmi1.SyncProfile;
import org.opencrx.kernel.home1.jmi1.UserHome;

public class DoPropfind
extends org.opencrx.application.uses.net.sf.webdav.methods.DoPropfind {
    public DoPropfind(WebDavStore store) {
        super(store);
    }

    @Override
    protected Map<String, String> getNamespaces() {
        Map<String, String> namespaces = super.getNamespaces();
        namespaces.put("urn:ietf:params:xml:ns:carddav", "C");
        return namespaces;
    }

    @Override
    protected void writeCollectionType(RequestContext requestContext, XMLWriter writer, Resource res) {
        if (res instanceof AccountCollectionResource) {
            writer.writeElement("urn:ietf:params:xml:ns:carddav:addressbook", 2);
        }
    }

    @Override
    protected String getVersion() {
        return "1, 2, addressbook";
    }

    @Override
    protected boolean handleExtension(RequestContext requestContext, XMLWriter writer, String contextPath, Resource res, String property) {
        HttpServletRequest req = requestContext.getHttpServletRequest();
        HttpServletResponse resp = requestContext.getHttpServletResponse();
        if (res instanceof CardProfileResource) {
            SyncProfile syncProfile = ((CardProfileResource)res).getObject();
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)syncProfile);
            UserHome userHome = (UserHome)pm.getObjectById((Object)syncProfile.refGetPath().getParent().getParent());
            String providerName = userHome.refGetPath().getSegment(2).toString();
            String segmentName = userHome.refGetPath().getSegment(4).toString();
            if (property.indexOf("current-user-principal") > 0) {
                String principalUrl = this.encodeURL(resp, this.getHRef(req, "/" + providerName + "/" + segmentName + "/user/" + userHome.refGetPath().getLastSegment() + "/profile/" + syncProfile.getName(), true));
                writer.writeElement("DAV::principal-URL", 0);
                writer.writeElement("DAV::href", 0);
                writer.writeText(principalUrl);
                writer.writeElement("DAV::href", 1);
                writer.writeElement("DAV::principal-URL", 1);
                writer.writeElement("DAV::current-user-principal", 0);
                writer.writeElement("DAV::href", 0);
                writer.writeText(principalUrl);
                writer.writeElement("DAV::href", 1);
                writer.writeElement("DAV::current-user-principal", 1);
                return true;
            }
            if (property.indexOf("principal-address") > 0) {
                writer.writeElement("urn:ietf:params:xml:ns:carddav:principal-address", 0);
                writer.writeElement("DAV::href", 0);
                writer.writeText(resp.encodeRedirectURL(this.getHRef(req, req.getServletPath(), true)));
                writer.writeElement("DAV::href", 1);
                writer.writeElement("urn:ietf:params:xml:ns:carddav:principal-address", 1);
                return true;
            }
            if (property.indexOf("addressbook-home-set") > 0) {
                writer.writeElement("urn:ietf:params:xml:ns:carddav:addressbook-home-set", 0);
                writer.writeElement("DAV::href", 0);
                writer.writeText(this.encodeURL(resp, this.getHRef(req, "/" + providerName + "/" + segmentName + "/" + userHome.refGetPath().getLastSegment() + "/" + res.getName(), true)));
                writer.writeElement("DAV::href", 1);
                writer.writeElement("urn:ietf:params:xml:ns:carddav:addressbook-home-set", 1);
                return true;
            }
            if (property.indexOf("principal-URL") > 0) {
                writer.writeElement("DAV::principal-URL", 0);
                writer.writeElement("DAV::href", 0);
                writer.writeText(this.encodeURL(resp, this.getHRef(req, "/" + providerName + "/" + segmentName + "/user/" + userHome.refGetPath().getLastSegment() + "/profile/" + syncProfile.getName(), true)));
                writer.writeElement("DAV::href", 1);
                writer.writeElement("DAV::principal-URL", 1);
                return true;
            }
            return false;
        }
        if (res instanceof AccountCollectionResource) {
            AccountCollectionResource accountCollectionResource = (AccountCollectionResource)res;
            if (property.indexOf("addressbook-description") > 0) {
                writer.writeElement("urn:ietf:params:xml:ns:carddav:addressbook-description", 0);
                writer.writeData(res.getDisplayName());
                writer.writeElement("urn:ietf:params:xml:ns:carddav:addressbook-description", 1);
                return true;
            }
            if (property.indexOf("supported-address-data") > 0) {
                writer.writeElement("urn:ietf:params:xml:ns:carddav:supported-address-data", 0);
                writer.writeText("<C:address-data-type content-type=\"text/vcard\" version=\"3.0\"/>");
                writer.writeElement("urn:ietf:params:xml:ns:carddav:supported-address-data", 1);
                return true;
            }
            if (property.indexOf("getctag") > 0) {
                long ctag = System.currentTimeMillis() / 10000L;
                writer.writeElement("http://calendarserver.org/ns/:getctag", 0);
                writer.writeText(Long.toString(ctag));
                writer.writeElement("http://calendarserver.org/ns/:getctag", 1);
                return true;
            }
            if (property.indexOf("sync-token") > 0) {
                long syncToken = System.currentTimeMillis() / 10000L;
                writer.writeElement("DAV::sync-token", 0);
                writer.writeText("http://opencrx.org/ns/sync-token/" + syncToken);
                writer.writeElement("DAV::sync-token", 1);
                return true;
            }
            if (property.indexOf("current-user-privilege-set") > 0) {
                writer.writeElement("DAV::current-user-privilege-set", 0);
                writer.writeElement("DAV::privilege", 0);
                if (Boolean.TRUE.equals(accountCollectionResource.getObject().isAllowAddDelete()) && Boolean.TRUE.equals(accountCollectionResource.getObject().isAllowChange())) {
                    writer.writeElement("DAV::all", 2);
                } else {
                    writer.writeElement("DAV::read", 2);
                }
                writer.writeElement("DAV::privilege", 1);
                writer.writeElement("DAV::current-user-privilege-set", 1);
                return true;
            }
            return false;
        }
        if (res instanceof AccountResource) {
            if (property.indexOf("getctag") > 0) {
                writer.writeElement("http://calendarserver.org/ns/:getctag", 0);
                writer.writeText(this.getETag(res));
                writer.writeElement("http://calendarserver.org/ns/:getctag", 1);
                return true;
            }
            if (property.indexOf("owner") > 0) {
                return true;
            }
        }
        return false;
    }
}

