/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.ldap;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.kernel.account1.cci2.AccountFilterGlobalQuery;
import org.opencrx.kernel.account1.cci2.ContactQuery;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.AccountFilterGlobal;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.Segment;
import org.opencrx.kernel.admin1.jmi1.ComponentConfiguration;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.base.jmi1.StringProperty;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.utils.ComponentConfigHelper;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.security.realm1.jmi1.PrincipalGroup;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.log.SysLog;

public class LDAPSynchronizer
extends HttpServlet {
    private static final long serialVersionUID = 8358818934432722015L;
    protected static final String COMMAND_EXECUTE = "/execute";
    protected static final String WORKFLOW_NAME = "LDAPSynchronizer";
    protected static final String COMPONENT_CONFIGURATION_ID = "LDAPSynchronizer";
    protected static final Map<String, Thread> runningSegments = new ConcurrentHashMap<String, Thread>();
    protected static final String OPTION_SYNC_KEY = "syncKey";
    protected static final String OPTION_SYNC_DIR = "syncDir";
    protected static final String OPTION_RUN_AS = "runAs";
    protected static final String OPTION_BASE_DN_PEOPLE = "baseDNPeople";
    protected static final String OPTION_BASE_DN_GROUPS = "baseDNGroups";
    protected PersistenceManagerFactory pmf = null;
    protected long startedAt = System.currentTimeMillis();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.pmf = Utils.getPersistenceManagerFactory();
        }
        catch (Exception e) {
            throw new ServletException("Can not get connection to data provider", (Throwable)e);
        }
    }

    protected AccountFilterGlobal getAccountFilter(Segment accountSegment) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountSegment);
        AccountFilterGlobalQuery query = (AccountFilterGlobalQuery)pm.newQuery(AccountFilterGlobal.class);
        query.name().equalTo((Object)LDAPSynchronizer.class.getSimpleName());
        List accountFilters = accountSegment.getAccountFilter(query);
        return accountFilters.isEmpty() ? null : (AccountFilterGlobal)accountFilters.iterator().next();
    }

    protected String getUid(Contact contact) throws ServiceException {
        return contact.getAliasName();
    }

    protected String getDN(Contact contact, String baseDNPeople) throws ServiceException {
        String uid = this.getUid(contact);
        return uid == null || uid.isEmpty() ? null : "uid=" + uid + "," + baseDNPeople;
    }

    protected String getUserpassword(Contact contact) throws ServiceException {
        String uid = this.getUid(contact);
        return "changeit-" + uid;
    }

    protected String getEmployeeNumber(Contact contact) throws ServiceException {
        return null;
    }

    protected void writeLdifAddEntry(Contact contact, String baseDNPeople, PrintWriter pw) throws ServiceException {
        pw.println("dn: " + this.getDN(contact, baseDNPeople));
        pw.println("objectclass: inetOrgPerson");
        pw.println("cn: " + contact.getFullName());
        pw.println("sn: " + contact.getLastName());
        pw.println("uid: " + this.getUid(contact));
        pw.println("userpassword: " + this.getUserpassword(contact));
        pw.println();
    }

    protected void writeLdifModifyEntry(Contact contact, String baseDNPeople, PrintWriter pw) throws ServiceException {
        String employeeNumber;
        AccountAddress[] mainAddresses = Accounts.getInstance().getMainAddresses(contact);
        pw.println("dn: " + this.getDN(contact, baseDNPeople));
        pw.println("changetype: modify");
        pw.println("replace: cn");
        pw.println("cn: " + contact.getFullName());
        pw.println("-");
        pw.println("replace: sn");
        pw.println("sn: " + contact.getLastName());
        pw.println("-");
        pw.println("replace: gn");
        pw.println("gn: " + contact.getFirstName());
        pw.println("-");
        if (mainAddresses[0] instanceof EMailAddress) {
            pw.println("replace: mail");
            pw.println("mail: " + ((EMailAddress)mainAddresses[0]).getEmailAddress());
            pw.println("-");
        }
        if ((employeeNumber = this.getEmployeeNumber(contact)) != null && !employeeNumber.isEmpty()) {
            pw.println("replace: employeeNumber");
            pw.println("employeeNumber: " + employeeNumber);
            pw.println("-");
        }
        pw.println();
    }

    protected void writeLdifDeleteEntry(Contact contact, String baseDNPeople, PrintWriter pw) throws ServiceException {
        pw.println("dn: " + this.getDN(contact, baseDNPeople));
        pw.println("changetype: delete");
    }

    protected void writeError(Contact contact, String baseDNPeople, Exception e, PrintWriter pw) throws ServiceException {
        String dn = this.getDN(contact, baseDNPeople);
        pw.println("DN: " + (dn == null ? "N/A" : dn));
        pw.println("XRI: " + contact.refGetPath().toXRI());
        if (e != null) {
            pw.println("Error:");
            ServiceException e0 = new ServiceException(e);
            e0.printStackTrace(pw);
        }
    }

    protected String getDN(String groupName, String baseDNGroups) throws ServiceException {
        return "cn=" + groupName + "," + baseDNGroups;
    }

    protected void writeLdifAddEntry(String groupName, String baseDNGroups, PrintWriter pw) throws ServiceException {
        pw.println("dn: " + this.getDN(groupName, baseDNGroups));
        pw.println("objectclass: groupofnames");
        pw.println("cn: " + groupName);
        pw.println("member: ");
        pw.println();
    }

    protected void writeLdifModifyEntry(String groupName, List<String[]> members, String baseDNGroups, PrintWriter pw) throws ServiceException {
        pw.println("dn: " + this.getDN(groupName, baseDNGroups));
        pw.println("changetype: modify");
        pw.println("replace: member");
        for (String[] member : members) {
            pw.println("member: " + member[0]);
        }
        pw.println("-");
        pw.println();
    }

    protected void writeError(String groupName, String baseDNGroups, Exception e, PrintWriter pw) throws ServiceException {
        String dn = this.getDN(groupName, baseDNGroups);
        pw.println("DN: " + (dn == null ? "N/A" : dn));
        if (e != null) {
            pw.println("Error:");
            ServiceException e0 = new ServiceException(e);
            e0.printStackTrace(pw);
        }
    }

    protected void writeError(String groupName, String baseDNGroups, List<String[]> validMembers, List<String[]> duplicateMembers, PrintWriter pw) throws ServiceException {
        String dn = this.getDN(groupName, baseDNGroups);
        pw.println("DN: " + (dn == null ? "N/A" : dn));
        pw.println();
        pw.println("Valid members:");
        for (String[] member : validMembers) {
            pw.println(member[0] + ": " + member[1]);
        }
        pw.println();
        pw.println("Duplicate members:");
        for (String[] member : duplicateMembers) {
            pw.println(member[0] + ": " + member[1]);
        }
    }

    protected void sync(String id, String providerName, String segmentName, HttpServletRequest req, HttpServletResponse res) throws IOException {
        block23: {
            System.out.println(new Date().toString() + ": LDAPSynchronizer " + providerName + "/" + segmentName);
            try {
                String uid;
                PersistenceManager rootPm = this.pmf.getPersistenceManager("admin-Root", null);
                ComponentConfiguration configuration = ComponentConfigHelper.getComponentConfiguration("LDAPSynchronizer", providerName, rootPm, true, null);
                String syncKeyId = providerName + "." + segmentName + ".syncKey";
                StringProperty syncKeyProperty = ComponentConfigHelper.getComponentConfigProperty(syncKeyId, configuration);
                long syncKey = syncKeyProperty == null ? 0L : Long.valueOf(syncKeyProperty.getStringValue());
                String syncDirId = providerName + "." + segmentName + ".syncDir";
                StringProperty syncDirProperty = ComponentConfigHelper.getComponentConfigProperty(syncDirId, configuration);
                File syncDir = syncDirProperty == null ? new File(new File("ldapdir", providerName), segmentName) : new File(syncDirProperty.getStringValue());
                syncDir.mkdirs();
                String runAsId = providerName + "." + segmentName + ".runAs";
                StringProperty runAsProperty = ComponentConfigHelper.getComponentConfigProperty(runAsId, configuration);
                Object runAs = runAsProperty == null ? "admin" + SecurityKeys.ID_SEPARATOR + segmentName : runAsProperty.getStringValue();
                String baseDNPeopleId = providerName + "." + segmentName + ".baseDNPeople";
                StringProperty baseDNPeopleProperty = ComponentConfigHelper.getComponentConfigProperty(baseDNPeopleId, configuration);
                String baseDNPeople = baseDNPeopleProperty == null ? "ou=people,dc=example,dc=com" : baseDNPeopleProperty.getStringValue();
                String baseDNGroupsId = providerName + "." + segmentName + ".baseDNGroups";
                StringProperty baseDNGroupsProperty = ComponentConfigHelper.getComponentConfigProperty(baseDNGroupsId, configuration);
                String baseDNGroups = baseDNGroupsProperty == null ? "ou=groups,dc=example,dc=com" : baseDNGroupsProperty.getStringValue();
                PersistenceManager pm = this.pmf.getPersistenceManager((String)runAs, null);
                Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, providerName, segmentName);
                AccountFilterGlobal accountFilter = this.getAccountFilter(accountSegment);
                if (accountFilter == null) break block23;
                long newSyncKey = System.currentTimeMillis();
                int contactCount = 0;
                ContactQuery contactQuery = (ContactQuery)pm.newQuery(Contact.class);
                contactQuery.modifiedAt().greaterThanOrEqualTo((Comparable)new Date(syncKey));
                contactQuery.modifiedAt().lessThan((Comparable)new Date(newSyncKey));
                List contacts = accountFilter.getFilteredAccount(contactQuery);
                File fPeople = new File(syncDir, "people");
                fPeople.mkdir();
                File fPeopleAdd = new File(fPeople, "Add");
                fPeopleAdd.mkdir();
                File fPeopleModify = new File(fPeople, "Modify");
                fPeopleModify.mkdir();
                File fPeopleDelete = new File(fPeople, "Delete");
                fPeopleDelete.mkdir();
                File fPeopleError = new File(fPeople, "Error");
                fPeopleError.mkdir();
                for (Contact contact : contacts) {
                    block24: {
                        uid = this.getUid(contact);
                        if (uid != null && !uid.isEmpty()) {
                            try {
                                if (Boolean.TRUE.equals(contact.isDisabled())) {
                                    File fPersonDelete = new File(fPeopleDelete, syncKey + "-" + contactCount + ".ldif");
                                    fPeopleDelete.mkdirs();
                                    PrintWriter pwPersonDelete = new PrintWriter(fPersonDelete, "UTF-8");
                                    this.writeLdifDeleteEntry(contact, baseDNPeople, pwPersonDelete);
                                    pwPersonDelete.close();
                                    break block24;
                                }
                                File fPersonAdd = new File(fPeopleAdd, syncKey + "-" + contactCount + ".ldif");
                                fPeopleAdd.mkdirs();
                                PrintWriter pwPersonAdd = new PrintWriter(fPersonAdd, "UTF-8");
                                this.writeLdifAddEntry(contact, baseDNPeople, pwPersonAdd);
                                pwPersonAdd.close();
                                File fPersonModify = new File(fPeopleModify, syncKey + "-" + contactCount + ".ldif");
                                fPeopleModify.mkdirs();
                                PrintWriter pwPersonModify = new PrintWriter(fPersonModify, "UTF-8");
                                this.writeLdifModifyEntry(contact, baseDNPeople, pwPersonModify);
                                pwPersonModify.close();
                            }
                            catch (Exception e) {
                                File fPersonError = new File(fPeopleError, syncKey + "-" + contactCount + ".ldif");
                                fPeopleError.mkdirs();
                                PrintWriter pwPersonError = new PrintWriter(fPersonError, "UTF-8");
                                this.writeError(contact, baseDNPeople, e, pwPersonError);
                                pwPersonError.close();
                            }
                        } else {
                            File fPersonError = new File(fPeopleError, syncKey + "-" + contactCount + ".ldif");
                            fPeopleError.mkdirs();
                            PrintWriter pwPersonError = new PrintWriter(fPersonError, "UTF-8");
                            this.writeError(contact, baseDNPeople, null, pwPersonError);
                            pwPersonError.close();
                        }
                    }
                    ++contactCount;
                }
                File fGroups = new File(syncDir, "groups");
                fGroups.mkdirs();
                File fGroupsAdd = new File(fGroups, "Add");
                fGroupsAdd.mkdir();
                File fGroupsModify = new File(fGroups, "Modify");
                fGroupsModify.mkdir();
                File fGroupsError = new File(fGroups, "Error");
                fGroupsError.mkdir();
                if (contactCount > 0) {
                    HashMap<Object, ArrayList<String[]>> groupMemberships = new HashMap<Object, ArrayList<String[]>>();
                    ContactQuery contactQuery2 = (ContactQuery)pm.newQuery(Contact.class);
                    contactQuery2.forAllDisabled().isFalse();
                    List contacts2 = accountFilter.getFilteredAccount(contactQuery2);
                    for (Contact contact : contacts2) {
                        uid = this.getUid(contact);
                        if (uid == null || uid.isEmpty()) continue;
                        String memberDN = this.getDN(contact, baseDNPeople);
                        try {
                            for (PrincipalGroup group : contact.getOwningGroup()) {
                                String groupName = group.getName();
                                ArrayList<String[]> members = (ArrayList<String[]>)groupMemberships.get(groupName);
                                if (members == null) {
                                    members = new ArrayList<String[]>();
                                    groupMemberships.put(groupName, members);
                                }
                                members.add(new String[]{memberDN, contact.refGetPath().toXRI()});
                            }
                        }
                        catch (Exception pwPersonError) {
                        }
                    }
                    int groupCount = 0;
                    for (String groupName : groupMemberships.keySet()) {
                        List members = (List)groupMemberships.get(groupName);
                        ArrayList<String[]> validMembers = new ArrayList<String[]>();
                        ArrayList<String[]> duplicateMembers = new ArrayList<String[]>();
                        for (String[] member : members) {
                            boolean found = false;
                            for (String[] validMember : validMembers) {
                                if (!member[0].equals(validMember[0])) continue;
                                found = true;
                                break;
                            }
                            if (found) {
                                duplicateMembers.add(member);
                                continue;
                            }
                            validMembers.add(member);
                        }
                        if (!duplicateMembers.isEmpty()) {
                            File fGroupError = new File(fGroupsError, syncKey + "-" + groupCount + ".ldif");
                            fGroupsError.mkdirs();
                            PrintWriter pwGroupError = new PrintWriter(fGroupError, "UTF-8");
                            this.writeError(groupName, baseDNGroups, validMembers, duplicateMembers, pwGroupError);
                            pwGroupError.close();
                        } else {
                            try {
                                File fGroupAdd = new File(fGroupsAdd, syncKey + "-" + groupCount + ".ldif");
                                fGroupsAdd.mkdirs();
                                PrintWriter pwGroupAdd = new PrintWriter(fGroupAdd, "UTF-8");
                                this.writeLdifAddEntry(groupName, baseDNGroups, pwGroupAdd);
                                pwGroupAdd.close();
                                File fGroupModify = new File(fGroupsModify, syncKey + "-" + groupCount + ".ldif");
                                fGroupsModify.mkdirs();
                                PrintWriter pwGroupModify = new PrintWriter(fGroupModify, "UTF-8");
                                this.writeLdifModifyEntry(groupName, members, baseDNGroups, pwGroupModify);
                                pwGroupModify.close();
                            }
                            catch (Exception e) {
                                File fGroupError = new File(fGroupsError, syncKey + "-" + groupCount + ".ldif");
                                fGroupsError.mkdirs();
                                PrintWriter pwGroupError = new PrintWriter(fGroupError, "UTF-8");
                                this.writeError(groupName, baseDNGroups, e, pwGroupError);
                                pwGroupError.close();
                            }
                        }
                        ++groupCount;
                    }
                }
                if ((syncKeyProperty = ComponentConfigHelper.getComponentConfigProperty(syncKeyId, configuration)) == null) {
                    syncKeyProperty = ComponentConfigHelper.addComponentConfigProperty(syncKeyId, "", configuration);
                }
                rootPm.currentTransaction().begin();
                syncKeyProperty.setStringValue(Long.toString(newSyncKey));
                rootPm.currentTransaction().commit();
            }
            catch (Exception e) {
                new ServiceException(e).log();
                System.out.println(new Date() + ": LDAPSynchronizer " + providerName + "/" + segmentName + ": exception occured " + e.getMessage() + ". Continuing");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (System.currentTimeMillis() > this.startedAt + 180000L) {
            String segmentName = req.getParameter("segment");
            String providerName = req.getParameter("provider");
            String id = providerName + "/" + segmentName;
            if (COMMAND_EXECUTE.equals(req.getPathInfo())) {
                if (!runningSegments.containsKey(id)) {
                    try {
                        runningSegments.put(id, Thread.currentThread());
                        this.sync(id, providerName, segmentName, req, res);
                    }
                    catch (Exception e) {
                        SysLog.warning((String)e.getMessage(), (Throwable)e.getCause());
                    }
                    finally {
                        runningSegments.remove(id);
                        System.out.println(new Date() + ": LDAPSynchronizer " + providerName + "/" + segmentName + ": Done.");
                    }
                } else if (!runningSegments.get(id).isAlive() || runningSegments.get(id).isInterrupted()) {
                    Thread t = runningSegments.get(id);
                    System.out.println(new Date() + ": LDAPSynchronizer " + providerName + "/" + segmentName + ": Workflow " + t.getId() + " is alive=" + t.isAlive() + "; interrupted=" + t.isInterrupted() + ". Skipping execution.");
                } else {
                    System.out.println(new Date() + ": LDAPSynchronizer " + providerName + "/" + segmentName + ": Workflow is active. Ignoring command. Running segments are " + runningSegments);
                }
            } else {
                SysLog.warning((String)("LDAPSynchronizer " + providerName + "/" + segmentName + ". Ignoring command. Running segments are"), runningSegments);
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }
}

