/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.mail.exporter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.activity1.cci2.EMailRecipientQuery;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.activity1.jmi1.EMailRecipient;
import org.opencrx.kernel.backend.Notifications;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.home1.cci2.EMailAccountQuery;
import org.opencrx.kernel.home1.jmi1.EMailAccount;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.home1.jmi1.WfProcessInstance;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.kernel.utils.WorkflowHelper;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.naming.Path;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.uses.org.apache.commons.pool.ObjectPool;
import org.openmdx.uses.org.apache.commons.pool.PoolableObjectFactory;
import org.openmdx.uses.org.apache.commons.pool.impl.GenericObjectPool;

public abstract class MailWorkflow
extends Workflows.AsynchronousWorkflow {
    private static final long TRANSPORT_TTL = 60000L;
    private static final String OPTION_MAIL_SERVICE_NAME = "mailServiceName";
    private static final Map<String, ObjectPool> MAIL_TRANSPORT_POOL = new ConcurrentHashMap<String, ObjectPool>();

    @Override
    public boolean isAtomic() {
        return true;
    }

    protected String setContent(Message message, Session session, PersistenceManager pm, Path targetIdentity, Path wfProcessInstanceIdentity, UserHome userHome, Map<String, Object> params) throws ServiceException {
        ContextCapable targetObject = null;
        try {
            targetObject = (ContextCapable)pm.getObjectById((Object)targetIdentity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String text = null;
        try {
            text = Notifications.getInstance().getNotificationText(pm, targetObject, wfProcessInstanceIdentity, userHome, params);
            if (text.regionMatches(true, 0, "<!DOCTYPE html", 0, 14)) {
                message.setContent((Object)text, "text/html; charset=utf-8");
            } else {
                message.setText(text);
            }
        }
        catch (MessagingException e) {
            throw new ServiceException((Exception)((Object)e));
        }
        return text;
    }

    protected Address[] setRecipients(Message message, PersistenceManager pm, Path targetIdentity, EMailAccount eMailAccount, String defaultFromAddress) throws ServiceException {
        Address[] recipients = null;
        try {
            message.setFrom((Address)new InternetAddress(eMailAccount.getReplyEMailAddress() == null ? (defaultFromAddress == null ? "noreply@localhost" : defaultFromAddress) : eMailAccount.getReplyEMailAddress()));
            if (eMailAccount.getName() != null && !eMailAccount.getName().isEmpty()) {
                recipients = InternetAddress.parse((String)eMailAccount.getName());
                message.setRecipients(Message.RecipientType.TO, recipients);
            } else {
                recipients = new Address[]{};
            }
        }
        catch (AddressException e) {
            throw new ServiceException((Exception)((Object)e));
        }
        catch (MessagingException e) {
            throw new ServiceException((Exception)((Object)e));
        }
        return recipients;
    }

    abstract boolean useSendMailSubjectPrefix();

    protected void createLogEntry(WfProcessInstance wfProcessInstance, String name, String description, ContextCapable target, Address address) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
        AccountAddress context = null;
        if (target instanceof EMail) {
            EMail email = (EMail)target;
            EMailRecipientQuery emailRecipientQuery = (EMailRecipientQuery)pm.newQuery(EMailRecipient.class);
            for (EMailRecipient emailRecipient : email.getEmailRecipient(emailRecipientQuery)) {
                if (!(emailRecipient.getParty() instanceof EMailAddress) || !((EMailAddress)emailRecipient.getParty()).getEmailAddress().equalsIgnoreCase(address.toString())) continue;
                context = emailRecipient.getParty();
            }
        }
        WorkflowHelper.createLogEntry(wfProcessInstance, name, description, context);
    }

    protected String doSendmail(Message message, String envelopeSenderAddress) {
        Object err = "";
        try {
            Process p = Runtime.getRuntime().exec("sendmail " + (String)(envelopeSenderAddress == null ? "" : "-f " + envelopeSenderAddress + " ") + "-t", null);
            OutputStream os = p.getOutputStream();
            message.writeTo(os);
            os.close();
            if (SysLog.isTraceOn()) {
                File sendmaildir = new File("./sendmaildir");
                sendmaildir.mkdirs();
                FileOutputStream fout = new FileOutputStream(new File(sendmaildir, Utils.getUidAsString()));
                message.writeTo((OutputStream)fout);
                fout.close();
            }
            BufferedReader out = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = out.readLine()) != null) {
                err = (String)err + line + "\n";
            }
            out = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            line = null;
            while ((line = out.readLine()) != null) {
                err = (String)err + line + "\n";
            }
            p.waitFor();
        }
        catch (Exception e) {
            new ServiceException(e).log();
            err = (String)err + e.getMessage();
        }
        return err;
    }

    protected static MailTransport getMailTransport(final String mailServiceName, final String fallbackMailServiceName) throws ServiceException {
        if (!MAIL_TRANSPORT_POOL.containsKey(mailServiceName)) {
            GenericObjectPool pool = new GenericObjectPool(new PoolableObjectFactory(){

                public Object makeObject() throws Exception {
                    InitialContext initialContext = new InitialContext();
                    Session session = null;
                    try {
                        session = (Session)initialContext.lookup("java:comp/env" + mailServiceName);
                    }
                    catch (Exception e) {
                        SysLog.detail((String)"Mail service not found", (Object)mailServiceName);
                        SysLog.detail((String)"Fall back to mail service", (Object)fallbackMailServiceName);
                        session = (Session)initialContext.lookup("java:comp/env" + fallbackMailServiceName);
                    }
                    if (session != null) {
                        Transport transport = session.getTransport();
                        String protocol = transport.getURLName().getProtocol();
                        String port = session.getProperty("mail." + protocol + ".port");
                        transport.connect(session.getProperty("mail." + protocol + ".host"), port == null ? -1 : Integer.valueOf(port), session.getProperty("mail." + protocol + ".user"), session.getProperty("mail." + protocol + ".password"));
                        return new MailTransport(mailServiceName, session, transport, System.currentTimeMillis() + 60000L);
                    }
                    throw new ServiceException("OpenCrxDomain", -27, "Unable to get mail session", new BasicException.Parameter[]{new BasicException.Parameter("mailService.name", (Object)mailServiceName), new BasicException.Parameter("mailService.fallback.name", (Object)fallbackMailServiceName)});
                }

                public void destroyObject(Object obj) throws Exception {
                    if (obj instanceof MailTransport) {
                        ((MailTransport)obj).destroy();
                    }
                }

                public boolean validateObject(Object obj) {
                    if (obj instanceof MailTransport) {
                        MailTransport mailTransport = (MailTransport)obj;
                        return mailTransport.getTransport().isConnected() && System.currentTimeMillis() < mailTransport.getExpiresAt();
                    }
                    return false;
                }

                public void activateObject(Object obj) throws Exception {
                    if (obj instanceof MailTransport) {
                        MailTransport mailTransport = (MailTransport)obj;
                    }
                }

                public void passivateObject(Object obj) throws Exception {
                    if (obj instanceof MailTransport) {
                        MailTransport mailTransport = (MailTransport)obj;
                    }
                }
            });
            pool.setTestOnBorrow(true);
            MAIL_TRANSPORT_POOL.put(mailServiceName, (ObjectPool)pool);
        }
        try {
            return (MailTransport)MAIL_TRANSPORT_POOL.get(mailServiceName).borrowObject();
        }
        catch (Exception e) {
            throw new ServiceException(e, "OpenCrxDomain", -27, "Unable to get mail session", new BasicException.Parameter[]{new BasicException.Parameter("mailService.name", (Object)mailServiceName), new BasicException.Parameter("mailService.fallback.name", (Object)fallbackMailServiceName)});
        }
    }

    @Override
    public void execute(WfProcessInstance wfProcessInstance) throws ServiceException {
        block29: {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfProcessInstance);
            MailTransport mailTransport = null;
            Address[] recipients = null;
            ContextCapable target = null;
            try {
                boolean useSendmail;
                EMailAccount eMailAccountUser;
                Path wfProcessInstanceIdentity = new Path(wfProcessInstance.refMofId());
                String providerName = wfProcessInstanceIdentity.getSegment(2).toString();
                String segmentName = wfProcessInstanceIdentity.getSegment(4).toString();
                Map<String, Object> params = WorkflowHelper.getWorkflowParameters(wfProcessInstance);
                UserHome userHome = (UserHome)pm.getObjectById((Object)wfProcessInstance.refGetPath().getParent().getParent());
                Path targetIdentity = new Path(wfProcessInstance.getTargetObject());
                try {
                    target = (ContextCapable)pm.getObjectById((Object)targetIdentity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                EMailAccountQuery emailAccountQuery = (EMailAccountQuery)pm.newQuery(EMailAccount.class);
                emailAccountQuery.thereExistsIsDefault().isTrue();
                emailAccountQuery.thereExistsIsActive().isTrue();
                List eMailAccounts = userHome.getEMailAccount(emailAccountQuery);
                EMailAccount eMailAccount = eMailAccountUser = eMailAccounts.isEmpty() ? null : (EMailAccount)eMailAccounts.iterator().next();
                if (eMailAccountUser == null) {
                    throw new ServiceException("DefaultDomain", -2, "Unable to send email. No default email account configured", new BasicException.Parameter[]{new BasicException.Parameter("user", (Object)userHome.refGetPath().toXRI())});
                }
                boolean bl = System.getProperty("org.opencrx.usesendmail." + providerName + "." + segmentName) == null ? (System.getProperty("org.opencrx.usesendmail." + providerName) == null ? false : Boolean.valueOf(System.getProperty("org.opencrx.usesendmail." + providerName))) : (useSendmail = Boolean.valueOf(System.getProperty("org.opencrx.usesendmail." + providerName + "." + segmentName)).booleanValue());
                if (!useSendmail) {
                    String fallbackMailServiceName;
                    Object mailServiceName = eMailAccountUser.getOutgoingMailServiceName();
                    if ((mailServiceName == null || ((String)mailServiceName).isEmpty()) && wfProcessInstance.getProcess() != null) {
                        mailServiceName = (String)params.get(OPTION_MAIL_SERVICE_NAME);
                    }
                    if (mailServiceName == null) {
                        mailServiceName = "/mail/provider/" + providerName + "/segment/" + segmentName;
                    }
                    if ((mailTransport = MailWorkflow.getMailTransport((String)mailServiceName, fallbackMailServiceName = "/mail/provider/" + providerName)) == null) {
                        throw new ServiceException("DefaultDomain", -2, "Unable to get mail transport", new BasicException.Parameter[]{new BasicException.Parameter("mailService.name", mailServiceName), new BasicException.Parameter("fallbackMailService.name", (Object)fallbackMailServiceName)});
                    }
                }
                MimeMessage message = new MimeMessage(mailTransport == null ? null : mailTransport.getSession());
                message.setSentDate(new Date());
                message.setHeader("X-Mailer", "//OPENCRX//V2//" + providerName + "/" + segmentName);
                String envelopeSenderAddress = mailTransport == null ? (System.getProperty("org.opencrx.sendmail.from." + providerName + "." + segmentName) == null ? (System.getProperty("org.opencrx.sendmail.from." + providerName) == null ? null : System.getProperty("org.opencrx.sendmail.from." + providerName)) : System.getProperty("org.opencrx.sendmail.from." + providerName + "." + segmentName)) : mailTransport.getSession().getProperty("mail.from");
                recipients = this.setRecipients((Message)message, pm, targetIdentity, eMailAccountUser, envelopeSenderAddress);
                if (recipients.length > 0) {
                    String subject = null;
                    subject = Notifications.getInstance().getNotificationSubject(pm, target, wfProcessInstanceIdentity, userHome, params, this.useSendMailSubjectPrefix());
                    message.setSubject(subject, "UTF-8");
                    String text = this.setContent((Message)message, mailTransport == null ? null : mailTransport.getSession(), pm, targetIdentity, wfProcessInstanceIdentity, userHome, params);
                    message.saveChanges();
                    if (mailTransport == null) {
                        SysLog.detail((String)"Send message using sendmail");
                        String err = this.doSendmail((Message)message, envelopeSenderAddress);
                        if (!err.isEmpty()) {
                            throw new SendFailedException(err);
                        }
                    } else {
                        SysLog.detail((String)"Send message using JavaMail");
                        mailTransport.getTransport().sendMessage((Message)message, message.getAllRecipients());
                    }
                    SysLog.detail((String)"Done");
                    WorkflowHelper.createLogEntry(wfProcessInstance, subject, text == null ? null : (text.indexOf("\n") > 0 ? text.substring(0, text.indexOf("\n")) + "..." : text));
                    break block29;
                }
                throw new ServiceException("DefaultDomain", -2, "No recipients", new BasicException.Parameter[0]);
            }
            catch (SendFailedException e) {
                String reason;
                SysLog.warning((String)"Can not send message to recipients (reason=SendFailedException)", recipients == null ? null : Arrays.asList(recipients));
                ServiceException e0 = new ServiceException((Exception)((Object)e));
                SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
                Pattern reasonPattern = Pattern.compile(".*(\\d\\.\\d\\.\\d).*");
                Matcher reasonMatcher = reasonPattern.matcher(e.getMessage());
                String string = reason = reasonMatcher.matches() ? reasonMatcher.group(1) : "N/A";
                if (e.getValidUnsentAddresses() != null) {
                    for (Address address : e.getValidUnsentAddresses()) {
                        this.createLogEntry(wfProcessInstance, String.format("ERROR: Reason is >%s<", reason), e.getMessage(), target, address);
                    }
                }
                if (e.getInvalidAddresses() != null) {
                    for (Address address : e.getInvalidAddresses()) {
                        this.createLogEntry(wfProcessInstance, String.format("ERROR: Reason is >%s<", reason), e.getMessage(), target, address);
                    }
                }
                throw e0;
            }
            catch (AuthenticationFailedException e) {
                SysLog.warning((String)"Can not send message to recipients (reason=AuthenticationFailedException)", recipients == null ? null : Arrays.asList(recipients));
                ServiceException e0 = new ServiceException((Exception)((Object)e));
                SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
                WorkflowHelper.createLogEntry(wfProcessInstance, "Can not send mail: AuthenticationFailedException", e.getMessage());
                throw e0;
            }
            catch (AddressException e) {
                SysLog.warning((String)"Can not send message to recipients (reason=AddressException)", recipients == null ? null : Arrays.asList(recipients));
                ServiceException e0 = new ServiceException((Exception)((Object)e));
                SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
                WorkflowHelper.createLogEntry(wfProcessInstance, "Can not send mail: AddressException", e.getMessage());
                throw e0;
            }
            catch (MessagingException e) {
                SysLog.warning((String)"Can not send message to recipients (reason=MessagingException)", recipients == null ? null : Arrays.asList(recipients));
                ServiceException e0 = new ServiceException((Exception)((Object)e));
                SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
                WorkflowHelper.createLogEntry(wfProcessInstance, "Can not send mail: MessagingException", e.getMessage());
                throw e0;
            }
            catch (Exception e) {
                SysLog.warning((String)"Can not send message to recipients (reason=Exception)", recipients == null ? null : Arrays.asList(recipients));
                ServiceException e0 = new ServiceException(e);
                SysLog.detail((String)e0.getMessage(), (Throwable)e0.getCause());
                WorkflowHelper.createLogEntry(wfProcessInstance, "Can not send mail: Exception", e.getMessage());
                throw e0;
            }
            finally {
                ObjectPool mailTransportPool;
                if (mailTransport != null && (mailTransportPool = MAIL_TRANSPORT_POOL.get(mailTransport.getName())) != null) {
                    try {
                        mailTransportPool.returnObject((Object)mailTransport);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public static class MailTransport {
        private String name;
        private long expiresAt;
        private Session session;
        private Transport transport;

        public MailTransport(String name, Session session, Transport transport, long expiresAt) {
            this.name = name;
            this.session = session;
            this.transport = transport;
            this.expiresAt = expiresAt;
        }

        public void destroy() {
            this.name = null;
            this.session = null;
            if (this.transport != null) {
                try {
                    this.transport.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.transport = null;
        }

        public Session getSession() {
            return this.session;
        }

        public Transport getTransport() {
            return this.transport;
        }

        public long getExpiresAt() {
            return this.expiresAt;
        }

        public String getName() {
            return this.name;
        }
    }
}

