/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.shop.prestashop;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.opencrx.application.shop.prestashop.PrestaShopMapper;
import org.opencrx.kernel.admin1.jmi1.ComponentConfiguration;
import org.opencrx.kernel.base.jmi1.StringProperty;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.utils.ComponentConfigHelper;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.log.SysLog;

public class PrestaShopSynchronizer
extends HttpServlet {
    private static final long serialVersionUID = -2134096761120818592L;
    protected static final String COMMAND_EXECUTE = "/execute";
    protected static final String WORKFLOW_NAME = "PrestaShopSynchronizer";
    protected static final String COMPONENT_CONFIGURATION_ID = "PrestaShopSynchronizer";
    protected static final int MAX_STORES_PER_SEGMENT = 10;
    protected static final String OPTION_SHOP_NAME = "shopName";
    protected static final String OPTION_JDBC_RESOURCE_NAME = "jdbcResourceName";
    protected static final String OPTION_TABLE_PREFIX = "tablePrefix";
    protected static final String OPTION_SYNC_KEY = "syncKey";
    protected static final String OPTION_RUN_AS = "runAs";
    protected static final String OPTION_EMAIL_UNIQUE = "emailUnique";
    protected PersistenceManagerFactory pmf = null;
    protected final List<String> runningSegments = new ArrayList<String>();
    protected long startedAt = System.currentTimeMillis();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String providerName = this.getInitParameter("providerName");
        if (providerName.startsWith("provider/")) {
            providerName = providerName.substring(9);
        }
        try {
            this.pmf = Utils.getPersistenceManagerFactory();
        }
        catch (Exception e) {
            throw new ServletException("Can not get persistence manager factory", (Throwable)e);
        }
    }

    protected void synchronize(String id, String providerName, String segmentName, HttpServletRequest req, HttpServletResponse res) throws IOException {
        System.out.println(new Date().toString() + ": PrestaShopSynchronizer " + providerName + "/" + segmentName);
        try {
            int i;
            PersistenceManager rootPm = this.pmf.getPersistenceManager("admin-Root", null);
            ComponentConfiguration configuration = ComponentConfigHelper.getComponentConfiguration("PrestaShopSynchronizer", providerName, rootPm, true, null);
            ArrayList<String> shopNames = new ArrayList<String>();
            ArrayList<String> jdbcResourceNames = new ArrayList<String>();
            ArrayList<String> tablePrefixes = new ArrayList<String>();
            ArrayList<String> syncKeys = new ArrayList<String>();
            ArrayList<Object> runAss = new ArrayList<Object>();
            ArrayList<Boolean> emailUniques = new ArrayList<Boolean>();
            for (i = 0; i < 10; ++i) {
                String shopName;
                String shopNameId = providerName + "." + segmentName + ".shopName[" + i + "]";
                StringProperty shopNameProperty = ComponentConfigHelper.getComponentConfigProperty(shopNameId, configuration);
                String jdbcResourceNameId = providerName + "." + segmentName + ".jdbcResourceName[" + i + "]";
                StringProperty jdbcResourceNameProperty = ComponentConfigHelper.getComponentConfigProperty(jdbcResourceNameId, configuration);
                String tablePrefixId = providerName + "." + segmentName + ".tablePrefix[" + i + "]";
                StringProperty tablePrefixProperty = ComponentConfigHelper.getComponentConfigProperty(tablePrefixId, configuration);
                String syncKeyId = providerName + "." + segmentName + ".syncKey[" + i + "]";
                StringProperty syncKeyProperty = ComponentConfigHelper.getComponentConfigProperty(syncKeyId, configuration);
                String runAsId = providerName + "." + segmentName + ".runAs[" + i + "]";
                StringProperty runAsProperty = ComponentConfigHelper.getComponentConfigProperty(runAsId, configuration);
                String emailUniqueId = providerName + "." + segmentName + ".emailUnique[" + i + "]";
                StringProperty emailUniqueProperty = ComponentConfigHelper.getComponentConfigProperty(emailUniqueId, configuration);
                String string = shopName = shopNameProperty == null ? null : shopNameProperty.getStringValue();
                if (shopName == null || shopName.isEmpty()) break;
                String jdbcResourceName = jdbcResourceNameProperty == null ? null : jdbcResourceNameProperty.getStringValue();
                String tablePrefix = tablePrefixProperty == null ? null : tablePrefixProperty.getStringValue();
                String syncKey = syncKeyProperty == null ? null : syncKeyProperty.getStringValue();
                String runAs = runAsProperty == null ? null : runAsProperty.getStringValue();
                Boolean emailUnique = emailUniqueProperty == null ? null : Boolean.valueOf(emailUniqueProperty.getStringValue());
                shopNames.add(shopName == null ? "" : shopName);
                jdbcResourceNames.add(jdbcResourceName == null ? "" : jdbcResourceName);
                tablePrefixes.add(tablePrefix == null ? "" : tablePrefix);
                syncKeys.add(syncKey == null ? "0" : syncKey);
                runAss.add(runAs == null ? "admin" + SecurityKeys.ID_SEPARATOR + segmentName : runAs);
                emailUniques.add(emailUnique == null ? Boolean.TRUE : emailUnique);
            }
            SysLog.info((String)"Syncing shops", Arrays.asList(providerName, segmentName, shopNames, jdbcResourceNames, syncKeys));
            for (i = 0; i < shopNames.size(); ++i) {
                String shopName = (String)shopNames.get(i);
                String jdbcResourceName = (String)jdbcResourceNames.get(i);
                String tablePrefix = (String)tablePrefixes.get(i);
                long syncKey = Long.valueOf((String)syncKeys.get(i));
                String runAs = (String)runAss.get(i);
                boolean emailUnique = (Boolean)emailUniques.get(i);
                if (shopName.isEmpty()) continue;
                if (jdbcResourceName.isEmpty()) {
                    System.out.println(new Date() + ": PrestaShopSynchronizer " + providerName + "/" + segmentName + ": Option jdbcResourceName is not set for store " + shopName + ". Ignoring");
                    continue;
                }
                InitialContext initialContext = new InitialContext();
                DataSource ds = null;
                try {
                    ds = (DataSource)initialContext.lookup("java:comp/env/" + jdbcResourceName);
                }
                catch (Exception e) {
                    System.out.println(new Date() + ": PrestaShopSynchronizer " + providerName + "/" + segmentName + ": Unable to get resource for " + jdbcResourceName + ". Reason: " + e.getMessage());
                }
                if (ds == null) continue;
                long newSyncKey = System.currentTimeMillis();
                System.out.println(new Date() + ": PrestaShopSynchronizer " + providerName + "/" + segmentName + ": Synchronizing shop @" + shopName);
                Connection conn = ds.getConnection();
                PersistenceManager pm = this.pmf.getPersistenceManager(runAs, null);
                PrestaShopMapper prestaShopMapper = new PrestaShopMapper(pm, providerName, segmentName, shopName, emailUnique, conn, tablePrefix);
                PreparedStatement ps = conn.prepareStatement("SELECT * FROM " + tablePrefix + "customer WHERE date_upd >= ? AND date_upd < ? ORDER BY date_upd");
                ps.setTimestamp(1, new Timestamp(syncKey));
                ps.setTimestamp(2, new Timestamp(newSyncKey));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    System.out.println(new Date().toString() + ": PrestaShopSynchronizer " + providerName + "/" + segmentName + ": Customer " + rs.getInt("id_customer") + " @" + shopName);
                    prestaShopMapper.mapCustomer(rs);
                }
                rs.close();
                ps.close();
                ps = conn.prepareStatement("SELECT * FROM " + tablePrefix + "customer c WHERE id_customer IN (SELECT id_customer FROM " + tablePrefix + "address a WHERE a.id_customer = c.id_customer AND a.date_upd >= ? AND a.date_upd < ?) ORDER BY c.date_upd");
                ps.setTimestamp(1, new Timestamp(syncKey));
                ps.setTimestamp(2, new Timestamp(newSyncKey));
                rs = ps.executeQuery();
                while (rs.next()) {
                    System.out.println(new Date().toString() + ": PrestaShopSynchronizer " + providerName + "/" + segmentName + ": Customer addresses " + rs.getInt("id_customer") + " @" + shopName);
                    prestaShopMapper.mapCustomer(rs);
                }
                rs.close();
                ps.close();
                ps = conn.prepareStatement("SELECT * FROM " + tablePrefix + "product WHERE date_upd >= ? AND date_upd < ? ORDER BY date_upd");
                ps.setTimestamp(1, new Timestamp(syncKey));
                ps.setTimestamp(2, new Timestamp(newSyncKey));
                rs = ps.executeQuery();
                while (rs.next()) {
                    System.out.println(new Date().toString() + ": PrestaShopSynchronizer " + providerName + "/" + segmentName + ": Product " + rs.getInt("id_product") + " @" + shopName);
                    prestaShopMapper.mapProduct(rs);
                }
                rs.close();
                ps.close();
                ps = conn.prepareStatement("SELECT * FROM " + tablePrefix + "orders WHERE date_upd >= ? AND date_upd < ? ORDER BY date_upd");
                ps.setTimestamp(1, new Timestamp(syncKey));
                ps.setTimestamp(2, new Timestamp(newSyncKey));
                rs = ps.executeQuery();
                while (rs.next()) {
                    System.out.println(new Date().toString() + ": PrestaShopSynchronizer " + providerName + "/" + segmentName + ": Order " + rs.getInt("id_order") + " @" + shopName);
                    prestaShopMapper.mapOrder(rs);
                }
                rs.close();
                ps.close();
                ps = conn.prepareStatement("SELECT * FROM " + tablePrefix + "order_history WHERE date_add >= ? AND date_add < ? ORDER BY date_add");
                ps.setTimestamp(1, new Timestamp(syncKey));
                ps.setTimestamp(2, new Timestamp(newSyncKey));
                rs = ps.executeQuery();
                while (rs.next()) {
                    System.out.println(new Date().toString() + ": PrestaShopSynchronizer " + providerName + "/" + segmentName + ": Order History " + rs.getInt("id_order_history") + " @" + shopName);
                    prestaShopMapper.mapOrderHistory(rs);
                }
                rs.close();
                ps.close();
                pm.close();
                conn.close();
                String syncKeyId = providerName + "." + segmentName + ".syncKey[" + i + "]";
                StringProperty syncKeyProperty = ComponentConfigHelper.getComponentConfigProperty(syncKeyId, configuration);
                if (syncKeyProperty == null) {
                    syncKeyProperty = ComponentConfigHelper.addComponentConfigProperty(syncKeyId, "", configuration);
                }
                rootPm.currentTransaction().begin();
                syncKeyProperty.setStringValue(Long.toString(newSyncKey));
                rootPm.currentTransaction().commit();
            }
            rootPm.close();
        }
        catch (Exception e) {
            new ServiceException(e).log();
            System.out.println(new Date() + ": PrestaShopSynchronizer " + providerName + "/" + segmentName + ": exception occured " + e.getMessage() + ". Continuing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (System.currentTimeMillis() > this.startedAt + 60000L) {
            String segmentName = req.getParameter("segment");
            String providerName = req.getParameter("provider");
            String id = providerName + "/" + segmentName;
            if (COMMAND_EXECUTE.equals(req.getPathInfo()) && !this.runningSegments.contains(id)) {
                try {
                    this.runningSegments.add(id);
                    this.synchronize(id, providerName, segmentName, req, res);
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
                finally {
                    this.runningSegments.remove(id);
                }
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }
}

