/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.shop1.service;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jdo.PersistenceManager;
import org.opencrx.application.shop1.cci2.ActivityT;
import org.opencrx.application.shop1.cci2.AddActivityFollowUpParams;
import org.opencrx.application.shop1.cci2.AddActivityFollowUpResult;
import org.opencrx.application.shop1.cci2.AddCustomerToCustomerContractParams;
import org.opencrx.application.shop1.cci2.AddCustomerToCustomerContractResult;
import org.opencrx.application.shop1.cci2.AddDeliveryInformationParams;
import org.opencrx.application.shop1.cci2.AddDeliveryInformationResult;
import org.opencrx.application.shop1.cci2.AddSalesOrderPositionParams;
import org.opencrx.application.shop1.cci2.AddSalesOrderPositionResult;
import org.opencrx.application.shop1.cci2.CancelInvoiceParams;
import org.opencrx.application.shop1.cci2.CancelInvoiceResult;
import org.opencrx.application.shop1.cci2.CancelSalesOrderParams;
import org.opencrx.application.shop1.cci2.CancelSalesOrderResult;
import org.opencrx.application.shop1.cci2.CodeValueContainerT;
import org.opencrx.application.shop1.cci2.CodeValueEntryT;
import org.opencrx.application.shop1.cci2.ContactT;
import org.opencrx.application.shop1.cci2.ContractPositionT;
import org.opencrx.application.shop1.cci2.ContractStatusT;
import org.opencrx.application.shop1.cci2.ContractT;
import org.opencrx.application.shop1.cci2.CreateActivityParams;
import org.opencrx.application.shop1.cci2.CreateActivityResult;
import org.opencrx.application.shop1.cci2.CreateCustomerAsContactParams;
import org.opencrx.application.shop1.cci2.CreateCustomerAsContactResult;
import org.opencrx.application.shop1.cci2.CreateCustomerAsLegalEntityParams;
import org.opencrx.application.shop1.cci2.CreateCustomerAsLegalEntityResult;
import org.opencrx.application.shop1.cci2.CreateCustomerContractParams;
import org.opencrx.application.shop1.cci2.CreateCustomerContractResult;
import org.opencrx.application.shop1.cci2.CreateInvoiceFromInvoiceParams;
import org.opencrx.application.shop1.cci2.CreateInvoiceFromInvoiceResult;
import org.opencrx.application.shop1.cci2.CreateInvoiceFromSalesOrderParams;
import org.opencrx.application.shop1.cci2.CreateInvoiceFromSalesOrderResult;
import org.opencrx.application.shop1.cci2.CreateInvoiceParams;
import org.opencrx.application.shop1.cci2.CreateInvoiceResult;
import org.opencrx.application.shop1.cci2.CreateProductClassificationParams;
import org.opencrx.application.shop1.cci2.CreateProductClassificationResult;
import org.opencrx.application.shop1.cci2.CreateProductsParams;
import org.opencrx.application.shop1.cci2.CreateProductsResult;
import org.opencrx.application.shop1.cci2.CreateSalesOrderParams;
import org.opencrx.application.shop1.cci2.CreateSalesOrderResult;
import org.opencrx.application.shop1.cci2.CustomerContractT;
import org.opencrx.application.shop1.cci2.CustomerHobbyAndInterestT;
import org.opencrx.application.shop1.cci2.CustomerT;
import org.opencrx.application.shop1.cci2.DeliveryInformationT;
import org.opencrx.application.shop1.cci2.DocumentT;
import org.opencrx.application.shop1.cci2.GetActivitiesByQueryParams;
import org.opencrx.application.shop1.cci2.GetActivitiesByQueryResult;
import org.opencrx.application.shop1.cci2.GetActivityParams;
import org.opencrx.application.shop1.cci2.GetActivityResult;
import org.opencrx.application.shop1.cci2.GetCodeValueContainerParams;
import org.opencrx.application.shop1.cci2.GetCodeValueContainerResult;
import org.opencrx.application.shop1.cci2.GetCredentialsByEmailAddressParams;
import org.opencrx.application.shop1.cci2.GetCredentialsByEmailAddressResult;
import org.opencrx.application.shop1.cci2.GetCredentialsParams;
import org.opencrx.application.shop1.cci2.GetCredentialsResult;
import org.opencrx.application.shop1.cci2.GetCustomerParams;
import org.opencrx.application.shop1.cci2.GetCustomerResult;
import org.opencrx.application.shop1.cci2.GetCustomersByQueryParams;
import org.opencrx.application.shop1.cci2.GetCustomersByQueryResult;
import org.opencrx.application.shop1.cci2.GetDocumentsParams;
import org.opencrx.application.shop1.cci2.GetDocumentsResult;
import org.opencrx.application.shop1.cci2.GetInvoiceParams;
import org.opencrx.application.shop1.cci2.GetInvoicePositionsParams;
import org.opencrx.application.shop1.cci2.GetInvoicePositionsResult;
import org.opencrx.application.shop1.cci2.GetInvoiceResult;
import org.opencrx.application.shop1.cci2.GetInvoicesParams;
import org.opencrx.application.shop1.cci2.GetInvoicesResult;
import org.opencrx.application.shop1.cci2.GetPriceLevelParams;
import org.opencrx.application.shop1.cci2.GetPriceLevelResult;
import org.opencrx.application.shop1.cci2.GetProductConfigurationTypesResult;
import org.opencrx.application.shop1.cci2.GetProductPricesParams;
import org.opencrx.application.shop1.cci2.GetProductPricesResult;
import org.opencrx.application.shop1.cci2.GetProductsByQueryParams;
import org.opencrx.application.shop1.cci2.GetProductsByQueryResult;
import org.opencrx.application.shop1.cci2.GetProductsParams;
import org.opencrx.application.shop1.cci2.GetProductsResult;
import org.opencrx.application.shop1.cci2.GetSalesOrderParams;
import org.opencrx.application.shop1.cci2.GetSalesOrderPositionsParams;
import org.opencrx.application.shop1.cci2.GetSalesOrderPositionsResult;
import org.opencrx.application.shop1.cci2.GetSalesOrderResult;
import org.opencrx.application.shop1.cci2.GetSalesOrdersParams;
import org.opencrx.application.shop1.cci2.GetSalesOrdersResult;
import org.opencrx.application.shop1.cci2.InvoiceT;
import org.opencrx.application.shop1.cci2.LegalEntityT;
import org.opencrx.application.shop1.cci2.MessengerAddressT;
import org.opencrx.application.shop1.cci2.PostalAddressT;
import org.opencrx.application.shop1.cci2.ProductClassificationT;
import org.opencrx.application.shop1.cci2.ProductConfigurationT;
import org.opencrx.application.shop1.cci2.ProductConfigurationTypeT;
import org.opencrx.application.shop1.cci2.ProductDescriptionT;
import org.opencrx.application.shop1.cci2.ProductPhaseT;
import org.opencrx.application.shop1.cci2.ProductPriceListT;
import org.opencrx.application.shop1.cci2.ProductPriceT;
import org.opencrx.application.shop1.cci2.ProductT;
import org.opencrx.application.shop1.cci2.SalesOrderT;
import org.opencrx.application.shop1.cci2.SendEMailParams;
import org.opencrx.application.shop1.cci2.SendEMailResult;
import org.opencrx.application.shop1.cci2.SetCredentialsParams;
import org.opencrx.application.shop1.cci2.SetCredentialsResult;
import org.opencrx.application.shop1.cci2.SetCustomerContractStatusParams;
import org.opencrx.application.shop1.cci2.SetCustomerContractStatusResult;
import org.opencrx.application.shop1.cci2.SetCustomerStatusParams;
import org.opencrx.application.shop1.cci2.SetCustomerStatusResult;
import org.opencrx.application.shop1.cci2.SetInvoiceStatusParams;
import org.opencrx.application.shop1.cci2.SetInvoiceStatusResult;
import org.opencrx.application.shop1.cci2.SetProductStatusParams;
import org.opencrx.application.shop1.cci2.SetProductStatusResult;
import org.opencrx.application.shop1.cci2.SetSalesOrderPositionQuantityParams;
import org.opencrx.application.shop1.cci2.SetSalesOrderPositionQuantityResult;
import org.opencrx.application.shop1.cci2.SetSalesOrderStatusParams;
import org.opencrx.application.shop1.cci2.SetSalesOrderStatusResult;
import org.opencrx.application.shop1.cci2.ShopService;
import org.opencrx.application.shop1.cci2.StringPropertyT;
import org.opencrx.application.shop1.cci2.UpdateCustomerContractParams;
import org.opencrx.application.shop1.cci2.UpdateCustomerContractResult;
import org.opencrx.application.shop1.cci2.UpdateCustomerParams;
import org.opencrx.application.shop1.cci2.UpdateCustomerResult;
import org.opencrx.application.shop1.cci2.UpdateProductParams;
import org.opencrx.application.shop1.cci2.UpdateProductResult;
import org.opencrx.application.shop1.datatypes.DatatypeMappers;
import org.opencrx.application.shop1.datatypes.InvoiceState;
import org.opencrx.application.shop1.datatypes.ProductFilterType;
import org.opencrx.application.shop1.datatypes.PropertySetName;
import org.opencrx.application.shop1.datatypes.SalesOrderState;
import org.opencrx.kernel.account1.cci2.AccountHasAccountAddress;
import org.opencrx.kernel.account1.cci2.AccountQuery;
import org.opencrx.kernel.account1.cci2.EMailAddressQuery;
import org.opencrx.kernel.account1.cci2.LegalEntityQuery;
import org.opencrx.kernel.account1.cci2.MemberQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.LegalEntity;
import org.opencrx.kernel.account1.jmi1.Member;
import org.opencrx.kernel.account1.jmi1.PhoneNumber;
import org.opencrx.kernel.account1.jmi1.PostalAddress;
import org.opencrx.kernel.account1.jmi1.WebAddress;
import org.opencrx.kernel.activity1.cci2.ActivityDoFollowUpParams;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.cci2.NewActivityParams;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.activity1.jmi1.ActivityCreator;
import org.opencrx.kernel.activity1.jmi1.ActivityDoFollowUpParams;
import org.opencrx.kernel.activity1.jmi1.ActivityDoFollowUpResult;
import org.opencrx.kernel.activity1.jmi1.ActivityFollowUp;
import org.opencrx.kernel.activity1.jmi1.ActivityProcessTransition;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.activity1.jmi1.NewActivityParams;
import org.opencrx.kernel.activity1.jmi1.NewActivityResult;
import org.opencrx.kernel.address1.jmi1.PostalAddressable;
import org.opencrx.kernel.backend.Accounts;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.base.cci2.PropertySetContainsProperty;
import org.opencrx.kernel.base.jmi1.Property;
import org.opencrx.kernel.base.jmi1.SecureObject;
import org.opencrx.kernel.base.jmi1.StringProperty;
import org.opencrx.kernel.code1.cci2.CodeValueContainerContainsEntry;
import org.opencrx.kernel.code1.cci2.CodeValueContainerQuery;
import org.opencrx.kernel.code1.jmi1.AbstractEntry;
import org.opencrx.kernel.code1.jmi1.CodeValueContainer;
import org.opencrx.kernel.code1.jmi1.CodeValueEntry;
import org.opencrx.kernel.code1.jmi1.SimpleEntry;
import org.opencrx.kernel.contract1.cci2.CreatePositionParams;
import org.opencrx.kernel.contract1.cci2.InvoiceContainsInvoicePosition;
import org.opencrx.kernel.contract1.cci2.InvoicePositionQuery;
import org.opencrx.kernel.contract1.cci2.InvoiceQuery;
import org.opencrx.kernel.contract1.cci2.LeadQuery;
import org.opencrx.kernel.contract1.cci2.SalesOrderContainsSalesOrderPosition;
import org.opencrx.kernel.contract1.cci2.SalesOrderQuery;
import org.opencrx.kernel.contract1.jmi1.AbstractContract;
import org.opencrx.kernel.contract1.jmi1.AbstractInvoicePosition;
import org.opencrx.kernel.contract1.jmi1.AbstractSalesOrderPosition;
import org.opencrx.kernel.contract1.jmi1.AccountAssignmentContract;
import org.opencrx.kernel.contract1.jmi1.CreatePositionParams;
import org.opencrx.kernel.contract1.jmi1.CreatePositionResult;
import org.opencrx.kernel.contract1.jmi1.DeliveryInformation;
import org.opencrx.kernel.contract1.jmi1.Invoice;
import org.opencrx.kernel.contract1.jmi1.InvoicePosition;
import org.opencrx.kernel.contract1.jmi1.Lead;
import org.opencrx.kernel.contract1.jmi1.SalesContract;
import org.opencrx.kernel.contract1.jmi1.SalesContractPosition;
import org.opencrx.kernel.contract1.jmi1.SalesOrder;
import org.opencrx.kernel.contract1.jmi1.SalesOrderCreateInvoiceResult;
import org.opencrx.kernel.contract1.jmi1.SalesOrderPosition;
import org.opencrx.kernel.document1.cci2.DocumentFolderQuery;
import org.opencrx.kernel.document1.cci2.DocumentQuery;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.generic.cci2.CrxObjectContainsPropertySet;
import org.opencrx.kernel.generic.cci2.CrxObjectHasMedia;
import org.opencrx.kernel.generic.cci2.DescriptionContainerContainsDescription;
import org.opencrx.kernel.generic.cci2.PropertySetQuery;
import org.opencrx.kernel.generic.jmi1.CrxObject;
import org.opencrx.kernel.generic.jmi1.Description;
import org.opencrx.kernel.generic.jmi1.Media;
import org.opencrx.kernel.generic.jmi1.PropertySet;
import org.opencrx.kernel.product1.cci2.AbstractPriceLevelQuery;
import org.opencrx.kernel.product1.cci2.CreateInitialPricesParams;
import org.opencrx.kernel.product1.cci2.GetPriceLevelParams;
import org.opencrx.kernel.product1.cci2.PricingRuleQuery;
import org.opencrx.kernel.product1.cci2.ProductBasePriceQuery;
import org.opencrx.kernel.product1.cci2.ProductClassificationFilterProperty;
import org.opencrx.kernel.product1.cci2.ProductClassificationQuery;
import org.opencrx.kernel.product1.cci2.ProductConfigurationSetContainsConfiguration;
import org.opencrx.kernel.product1.cci2.ProductConfigurationTypeSetQuery;
import org.opencrx.kernel.product1.cci2.ProductContainsProductPhase;
import org.opencrx.kernel.product1.cci2.ProductFilterHasFilterProperty;
import org.opencrx.kernel.product1.cci2.ProductQuery;
import org.opencrx.kernel.product1.cci2.SalesTaxTypeQuery;
import org.opencrx.kernel.product1.cci2.SegmentContainsConfigurationTypeSet;
import org.opencrx.kernel.product1.cci2.SegmentContainsPriceLevel;
import org.opencrx.kernel.product1.cci2.SegmentContainsProductFilter;
import org.opencrx.kernel.product1.cci2.SetConfigurationTypeParams;
import org.opencrx.kernel.product1.jmi1.AbstractPriceLevel;
import org.opencrx.kernel.product1.jmi1.ConfiguredProduct;
import org.opencrx.kernel.product1.jmi1.CreateInitialPricesParams;
import org.opencrx.kernel.product1.jmi1.PriceUomFilterProperty;
import org.opencrx.kernel.product1.jmi1.PricingRule;
import org.opencrx.kernel.product1.jmi1.Product;
import org.opencrx.kernel.product1.jmi1.ProductBasePrice;
import org.opencrx.kernel.product1.jmi1.ProductClassification;
import org.opencrx.kernel.product1.jmi1.ProductConfiguration;
import org.opencrx.kernel.product1.jmi1.ProductConfigurationTypeSet;
import org.opencrx.kernel.product1.jmi1.ProductFilterGlobal;
import org.opencrx.kernel.product1.jmi1.ProductFilterProperty;
import org.opencrx.kernel.product1.jmi1.ProductPhase;
import org.opencrx.kernel.product1.jmi1.SalesTaxType;
import org.opencrx.kernel.product1.jmi1.SetConfigurationTypeParams;
import org.opencrx.kernel.uom1.cci2.UomQuery;
import org.opencrx.kernel.uom1.jmi1.Segment;
import org.opencrx.kernel.uom1.jmi1.Uom;
import org.openmdx.base.cci2.ExtentCapableQuery;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.query.ConditionType;
import org.openmdx.base.query.Quantifier;
import org.openmdx.base.rest.cci.QueryExtensionRecord;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.format.DateTimeFormat;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class ShopServiceImpl
implements ShopService {
    protected final PersistenceManager pm;
    protected final String providerName;
    protected final String segmentName;
    protected final boolean emailAddressMustBeUnique;
    protected final boolean noCopyOfProductConfiguration;
    protected final String shopName;
    protected final DatatypeMappers datatypeMappers;

    public ShopServiceImpl(PersistenceManager pm, String providerName, String segmentName, String shopName, boolean emailAddressMustBeUnique, boolean noCopyOfProductConfiguration, DatatypeMappers datatypeMappers) {
        this.pm = pm;
        this.providerName = providerName;
        this.segmentName = segmentName;
        this.shopName = shopName;
        this.emailAddressMustBeUnique = emailAddressMustBeUnique;
        this.noCopyOfProductConfiguration = noCopyOfProductConfiguration;
        this.datatypeMappers = datatypeMappers;
    }

    protected String getShopCategory() {
        return this.shopName;
    }

    public org.opencrx.kernel.account1.jmi1.Segment getAccountSegment() {
        return (org.opencrx.kernel.account1.jmi1.Segment)this.pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.account1/provider/" + this.providerName + "/segment/" + this.segmentName));
    }

    public org.opencrx.kernel.code1.jmi1.Segment getCodeSegment(String segmentName) {
        return (org.opencrx.kernel.code1.jmi1.Segment)this.pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.code1/provider/" + this.providerName + "/segment/" + segmentName));
    }

    public org.opencrx.kernel.contract1.jmi1.Segment getContractSegment() {
        return (org.opencrx.kernel.contract1.jmi1.Segment)this.pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.contract1/provider/" + this.providerName + "/segment/" + this.segmentName));
    }

    public org.opencrx.kernel.depot1.jmi1.Segment getDepotSegment() {
        return (org.opencrx.kernel.depot1.jmi1.Segment)this.pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.depot1/provider/" + this.providerName + "/segment/" + this.segmentName));
    }

    public org.opencrx.kernel.product1.jmi1.Segment getProductSegment() {
        return (org.opencrx.kernel.product1.jmi1.Segment)this.pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.product1/provider/" + this.providerName + "/segment/" + this.segmentName));
    }

    public org.opencrx.kernel.activity1.jmi1.Segment getActivitySegment() {
        return (org.opencrx.kernel.activity1.jmi1.Segment)this.pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1/provider/" + this.providerName + "/segment/" + this.segmentName));
    }

    public org.opencrx.kernel.document1.jmi1.Segment getDocumentSegment() {
        return (org.opencrx.kernel.document1.jmi1.Segment)this.pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.document1/provider/" + this.providerName + "/segment/" + this.segmentName));
    }

    public Segment getUomSegment() {
        return (Segment)this.pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.uom1/provider/" + this.providerName + "/segment/" + this.segmentName));
    }

    public String uuidAsString() {
        return UUIDConversion.toUID((UUID)UUIDs.newUUID());
    }

    protected Account findAccount(String customerNumber) {
        if (customerNumber == null) {
            return null;
        }
        AccountQuery accountQuery = (AccountQuery)this.pm.newQuery(Account.class);
        accountQuery.thereExistsAliasName().equalTo((Object)customerNumber);
        List accounts = this.getAccountSegment().getAccount(accountQuery);
        if (!accounts.isEmpty()) {
            return (Account)accounts.iterator().next();
        }
        return null;
    }

    protected Activity findActivity(String activityNumber, org.opencrx.kernel.activity1.jmi1.Segment activitySegment) {
        ActivityQuery activityQuery = (ActivityQuery)this.pm.newQuery(Activity.class);
        activityQuery.thereExistsActivityNumber().equalTo((Object)activityNumber);
        List activities = activitySegment.getActivity(activityQuery);
        if (!activities.isEmpty()) {
            return (Activity)activities.iterator().next();
        }
        return null;
    }

    protected PricingRule findPricingRule() {
        PricingRuleQuery pricingRuleQuery = (PricingRuleQuery)this.pm.newQuery(PricingRule.class);
        pricingRuleQuery.name().equalTo((Object)this.shopName);
        List pricingRules = this.getProductSegment().getPricingRule(pricingRuleQuery);
        if (!pricingRules.isEmpty()) {
            return (PricingRule)pricingRules.iterator().next();
        }
        return null;
    }

    protected Collection<ContractPositionT> getInvoicePositions(Account customer, Integer invoiceStatusThreshold, boolean includeVouchers, Product restrictToProduct) {
        String contractCategory = this.getShopCategory();
        ArrayList<ContractPositionT> positionsT = new ArrayList<ContractPositionT>();
        if (restrictToProduct == null) {
            InvoiceQuery invoiceQuery = (InvoiceQuery)this.pm.newQuery(Invoice.class);
            invoiceQuery.thereExistsCustomer().equalTo(customer);
            if (invoiceStatusThreshold != null) {
                invoiceQuery.contractState().greaterThanOrEqualTo((Comparable)Short.valueOf(invoiceStatusThreshold.shortValue()));
            }
            if (contractCategory != null) {
                invoiceQuery.thereExistsCategory().equalTo((Object)contractCategory);
            }
            for (Invoice invoice : this.getContractSegment().getInvoice(invoiceQuery)) {
                if (this.datatypeMappers.getInvoiceFieldMapper().isVoucher(invoice).booleanValue() && (!this.datatypeMappers.getInvoiceFieldMapper().isVoucher(invoice).booleanValue() || !includeVouchers)) continue;
                InvoiceContainsInvoicePosition.Position positions = invoice.getPosition();
                Iterator iterator = positions.iterator();
                while (iterator.hasNext()) {
                    AbstractInvoicePosition position = (AbstractInvoicePosition)iterator.next();
                    if (!(position instanceof InvoicePosition)) continue;
                    positionsT.add(this.datatypeMappers.mapContractPosition(position, invoice.getContractNumber(), this.datatypeMappers.getInvoiceFieldMapper().getPaymentDate(invoice), ((InvoicePosition)position).getProduct()));
                }
            }
        } else {
            org.opencrx.kernel.contract1.jmi1.Segment contractSegment = this.getContractSegment();
            InvoicePositionQuery positionQuery = (InvoicePositionQuery)this.pm.newQuery(InvoicePosition.class);
            positionQuery.identity().like((Object)contractSegment.refGetPath().getDescendant(new String[]{"invoice", ":*", "position", ":*"}).toString());
            positionQuery.thereExistsProduct().equalTo(restrictToProduct);
            QueryExtensionRecord queryFilter = PersistenceHelper.newQueryExtension((AnyTypePredicate)positionQuery);
            Object clause = "EXISTS (SELECT 0 FROM OOCKE1_CONTRACT c INNER JOIN OOCKE1_ACCOUNT a ON c.customer = a.object_id WHERE v.p$$parent = c.object_id AND a.alias_name = ?s0";
            queryFilter.setStringParam(new String[]{this.datatypeMappers.getAccountFieldMapper().getAccountNumber(customer)});
            clause = (String)clause + " AND c.is_gift = ?b0";
            queryFilter.setBooleanParam(new Boolean[]{includeVouchers});
            if (invoiceStatusThreshold != null) {
                clause = (String)clause + " AND c.contract_state >= ?i0";
            }
            queryFilter.setIntegerParam(new Integer[]{invoiceStatusThreshold});
            clause = (String)clause + ")";
            queryFilter.setClause((String)clause);
            List positions = contractSegment.getExtent((ExtentCapableQuery)positionQuery);
            for (AbstractInvoicePosition position : positions) {
                if (!(position instanceof InvoicePosition)) continue;
                Invoice invoice = (Invoice)this.pm.getObjectById((Object)position.refGetPath().getParent().getParent());
                if (contractCategory != null && !invoice.getCategory().contains(contractCategory)) continue;
                positionsT.add(this.datatypeMappers.mapContractPosition(position, invoice.getContractNumber(), this.datatypeMappers.getInvoiceFieldMapper().getPaymentDate(invoice), ((InvoicePosition)position).getProduct()));
            }
        }
        return positionsT;
    }

    public Invoice findInvoice(String invoiceNumber) {
        InvoiceQuery query = (InvoiceQuery)this.pm.newQuery(Invoice.class);
        query.thereExistsContractNumber().equalTo((Object)invoiceNumber);
        List invoices = this.getContractSegment().getInvoice(query);
        if (!invoices.isEmpty()) {
            return (Invoice)invoices.iterator().next();
        }
        return null;
    }

    public SalesOrder findSalesOrder(String salesOrderNumber) {
        SalesOrderQuery query = (SalesOrderQuery)this.pm.newQuery(SalesOrder.class);
        query.thereExistsContractNumber().equalTo((Object)salesOrderNumber);
        List salesOrder = this.getContractSegment().getSalesOrder(query);
        if (!salesOrder.isEmpty()) {
            return (SalesOrder)salesOrder.iterator().next();
        }
        return null;
    }

    public List<Lead> findCustomerContracts(Account account) {
        List<Lead> leads;
        LeadQuery leadQuery = (LeadQuery)this.pm.newQuery(Lead.class);
        String contractCategory = this.getShopCategory();
        if (contractCategory != null) {
            leadQuery.thereExistsCategory().equalTo((Object)contractCategory);
        }
        if (!(leads = account.getAssignedContract(leadQuery)).isEmpty()) {
            return leads;
        }
        Lead customerContract = this.findCustomerContractByContractNumber(this.datatypeMappers.getAccountFieldMapper().getAccountNumber(account));
        return customerContract == null ? null : Collections.singletonList(customerContract);
    }

    public Lead findMainCustomerContract(Account account) {
        LeadQuery leadQuery = (LeadQuery)this.pm.newQuery(Lead.class);
        String contractCategory = this.getShopCategory();
        if (contractCategory != null) {
            leadQuery.thereExistsCategory().equalTo((Object)contractCategory);
        }
        leadQuery.thereExistsCustomer().equalTo(account);
        List leads = account.getAssignedContract(leadQuery);
        if (!leads.isEmpty()) {
            return (Lead)leads.iterator().next();
        }
        return this.findCustomerContractByContractNumber(this.datatypeMappers.getAccountFieldMapper().getAccountNumber(account));
    }

    public Lead findCustomerContract(AbstractContract contract) {
        if (contract instanceof Lead) {
            return (Lead)contract;
        }
        if (contract.getOrigin() != null) {
            return this.findCustomerContract(contract.getOrigin());
        }
        return null;
    }

    public Lead findCustomerContractByContractNumber(String customerContractNumber) {
        LeadQuery query = (LeadQuery)this.pm.newQuery(Lead.class);
        query.thereExistsContractNumber().equalTo((Object)customerContractNumber);
        List leads = this.getContractSegment().getLead(query);
        if (!leads.isEmpty()) {
            return (Lead)leads.iterator().next();
        }
        return null;
    }

    public ProductConfigurationTypeSet findProductConfigurationType(String name) {
        ProductConfigurationTypeSetQuery query = (ProductConfigurationTypeSetQuery)this.pm.newQuery(ProductConfigurationTypeSet.class);
        query.name().equalTo((Object)name);
        List configurationTypes = this.getProductSegment().getConfigurationTypeSet(query);
        if (!configurationTypes.isEmpty()) {
            return (ProductConfigurationTypeSet)configurationTypes.iterator().next();
        }
        return null;
    }

    public Product findProduct(String productNumber) {
        ProductQuery query = (ProductQuery)this.pm.newQuery(Product.class);
        query.thereExistsProductNumber().equalTo((Object)productNumber);
        List products = this.getProductSegment().getProduct(query);
        if (!products.isEmpty()) {
            return (Product)products.iterator().next();
        }
        return null;
    }

    public ProductClassification findProductClassification(String classificationName) {
        ProductClassificationQuery query = (ProductClassificationQuery)this.pm.newQuery(ProductClassification.class);
        query.name().equalTo((Object)classificationName);
        List productClassifications = this.getProductSegment().getProductClassification(query);
        if (!productClassifications.isEmpty()) {
            return (ProductClassification)productClassifications.iterator().next();
        }
        return null;
    }

    public Uom findUom(String uomName) {
        UomQuery query = (UomQuery)this.pm.newQuery(Uom.class);
        query.name().equalTo((Object)uomName);
        List uoms = this.getUomSegment().getUom(query);
        if (!uoms.isEmpty()) {
            return (Uom)uoms.iterator().next();
        }
        return null;
    }

    public SalesTaxType findSalesTaxType(String salesTaxTypeName) {
        SalesTaxTypeQuery query = (SalesTaxTypeQuery)this.pm.newQuery(SalesTaxType.class);
        query.name().equalTo((Object)salesTaxTypeName);
        List salesTaxTypes = this.getProductSegment().getSalesTaxType(query);
        if (!salesTaxTypes.isEmpty()) {
            return (SalesTaxType)salesTaxTypes.iterator().next();
        }
        return null;
    }

    public CodeValueContainer findCodeValueContainer(String name, boolean isRootContainers) {
        if (name == null) {
            return null;
        }
        CodeValueContainerQuery query = (CodeValueContainerQuery)this.pm.newQuery(CodeValueContainer.class);
        query.thereExistsName().equalTo((Object)name);
        List containers = this.getCodeSegment(isRootContainers ? "Root" : this.segmentName).getValueContainer(query);
        if (!containers.isEmpty()) {
            return (CodeValueContainer)containers.iterator().next();
        }
        return null;
    }

    private String getNextSalesOrderNumber(Account customer) {
        String salesOrderNumber;
        String[] ids;
        SalesOrderQuery salesOrderQuery = (SalesOrderQuery)this.pm.newQuery(SalesOrder.class);
        salesOrderQuery.orderByContractNumber().descending();
        salesOrderQuery.thereExistsCustomer().equalTo(customer);
        List salesOrders = this.getContractSegment().getSalesOrder(salesOrderQuery);
        int lastSalesOrderNumber = 1000000;
        if (!salesOrders.isEmpty() && (ids = (salesOrderNumber = ((SalesOrder)salesOrders.iterator().next()).getContractNumber()).split("-")).length == 3 && ids[1].endsWith("S")) {
            lastSalesOrderNumber = Integer.valueOf(ids[1].substring(0, ids[1].length() - 1));
        }
        long suffix = System.currentTimeMillis() % 10000L;
        return this.datatypeMappers.getAccountFieldMapper().getAccountNumber(customer) + "-" + (lastSalesOrderNumber + 1) + "S-" + (suffix < 10L ? "000" + suffix : (suffix < 100L ? "00" + suffix : (suffix < 1000L ? "0" + suffix : "" + suffix)));
    }

    protected String getNextInvoiceNumber(Account customer) {
        String[] ids;
        String invoiceNumber;
        InvoiceQuery invoiceQuery = (InvoiceQuery)this.pm.newQuery(Invoice.class);
        invoiceQuery.orderByContractNumber().descending();
        invoiceQuery.thereExistsCustomer().equalTo(customer);
        List invoices = this.getContractSegment().getInvoice(invoiceQuery);
        int lastInvoiceNumber = 100000000;
        if (!invoices.isEmpty() && (invoiceNumber = ((Invoice)invoices.iterator().next()).getContractNumber()) != null && (ids = invoiceNumber.split("-")).length == 3 && ids[1].endsWith("I")) {
            lastInvoiceNumber = Integer.valueOf(ids[1].substring(0, ids[1].length() - 1));
        }
        long suffix = System.currentTimeMillis() % 10000L;
        return this.datatypeMappers.getAccountFieldMapper().getAccountNumber(customer) + "-" + (lastInvoiceNumber + 1) + "I-" + (suffix < 10L ? "000" + suffix : (suffix < 100L ? "00" + suffix : (suffix < 1000L ? "0" + suffix : "" + suffix)));
    }

    protected SalesContractPosition createContractPosition(SalesContract contract, String productNumber, BigDecimal quantity, Boolean ignoreProductConfiguration, ProductConfigurationT actualProductConfigurationT, String priceUomName, Date pricingDate, SalesTaxType salesTaxType, Boolean discountIsPercentage, BigDecimal discount, BigDecimal pricePerUnit) {
        ProductConfiguration configuration;
        Product product = this.findProduct(productNumber);
        Uom priceUom = this.findUom(priceUomName);
        String positionName = product.getName() + " (" + priceUom.getName() + ")";
        CreatePositionParams createPositionParams = (CreatePositionParams)Structures.create(CreatePositionParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CreatePositionParams.Member.ignoreProductConfiguration, (Object)ignoreProductConfiguration), Datatypes.member((Enum)CreatePositionParams.Member.name, (Object)positionName), Datatypes.member((Enum)CreatePositionParams.Member.priceUom, (Object)priceUom), Datatypes.member((Enum)CreatePositionParams.Member.pricingDate, (Object)pricingDate), Datatypes.member((Enum)CreatePositionParams.Member.pricingRule, null), Datatypes.member((Enum)CreatePositionParams.Member.product, (Object)product), Datatypes.member((Enum)CreatePositionParams.Member.quantity, (Object)quantity), Datatypes.member((Enum)CreatePositionParams.Member.priceUom, (Object)priceUom)});
        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
        CreatePositionResult createPositionResult = contract.createPosition(createPositionParams);
        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
        SalesContractPosition contractPosition = (SalesContractPosition)this.pm.getObjectById((Object)createPositionResult.getPosition().refGetPath());
        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
        contractPosition.setSalesTaxType(salesTaxType);
        contractPosition.setDiscountIsPercentage(discountIsPercentage == null ? Boolean.TRUE : discountIsPercentage);
        contractPosition.setDiscount(discount == null ? BigDecimal.ZERO : discount);
        if (contractPosition instanceof SecureObject) {
            ((SecureObject)((Object)contractPosition)).getOwningGroup().addAll(contract.getOwningGroup());
        }
        if (actualProductConfigurationT != null && contractPosition instanceof ConfiguredProduct && (configuration = ((ConfiguredProduct)((Object)contractPosition)).getCurrentConfig()).getName().equals(actualProductConfigurationT.getPropertySetName())) {
            this.updatePropertySet(actualProductConfigurationT.getProperty(), configuration, false);
        }
        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
        this.pm.refresh((Object)contractPosition);
        if (pricePerUnit != null && pricePerUnit.compareTo(contractPosition.getPricePerUnit()) != 0) {
            PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
            contractPosition.setPricePerUnit(pricePerUnit);
            PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
        }
        return contractPosition;
    }

    protected void updatePropertySet(List<StringPropertyT> propertiesT, org.opencrx.kernel.base.jmi1.PropertySet propertySet, boolean removeNonExisting) {
        HashMap<CallSite, Object[]> newProperties = new HashMap<CallSite, Object[]>();
        for (StringPropertyT propertyT : propertiesT) {
            for (int i = 0; i < propertyT.getStringValue().size(); ++i) {
                newProperties.put((CallSite)((Object)(propertyT.getName() + "[" + i + "]")), new Object[]{propertyT, i});
            }
        }
        PropertySetContainsProperty.Property properties = propertySet.getProperty();
        Iterator<Object> iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!(property instanceof StringProperty)) continue;
            String propertyName = property.getName();
            newProperties.remove(propertyName);
            int propertyIndex = 0;
            if (propertyName.indexOf("[") > 0) {
                propertyIndex = Integer.valueOf(propertyName.substring(propertyName.indexOf("[") + 1, propertyName.indexOf("]")));
                propertyName = propertyName.substring(0, propertyName.indexOf("["));
            }
            StringPropertyT matchingPropertyT = null;
            for (StringPropertyT propertyT : propertiesT) {
                if (!propertyT.getName().equals(propertyName)) continue;
                matchingPropertyT = propertyT;
                break;
            }
            if (matchingPropertyT != null) {
                if (propertyIndex < matchingPropertyT.getStringValue().size()) {
                    ((StringProperty)property).setStringValue(matchingPropertyT.getStringValue().get(propertyIndex));
                    continue;
                }
                property.refDelete();
                continue;
            }
            if (!removeNonExisting) continue;
            property.refDelete();
        }
        for (Map.Entry entry : newProperties.entrySet()) {
            StringProperty property = (StringProperty)this.pm.newInstance(StringProperty.class);
            StringPropertyT propertyT = (StringPropertyT)((Object[])entry.getValue())[0];
            Integer index = (Integer)((Object[])entry.getValue())[1];
            this.datatypeMappers.mapStringProperty(propertyT.getName() + "[" + index + "]", this.findCodeValueContainer(propertyT.getDomain(), false), propertyT.getStringValue().get(index), property);
            if (propertySet instanceof SecureObject) {
                property.getOwningGroup().addAll(((SecureObject)((Object)propertySet)).getOwningGroup());
            }
            propertySet.addProperty(false, this.uuidAsString(), property);
        }
    }

    protected void addContractAddresses(AbstractContract contract, PostalAddressT postalAddressInvoiceT, PostalAddressT postalAddressDeliveryT) {
        if (postalAddressInvoiceT != null) {
            org.opencrx.kernel.contract1.jmi1.PostalAddress postalAddressInvoice = (org.opencrx.kernel.contract1.jmi1.PostalAddress)this.pm.newInstance(org.opencrx.kernel.contract1.jmi1.PostalAddress.class);
            this.datatypeMappers.mapPostalAddress(postalAddressInvoiceT, postalAddressInvoice);
            postalAddressInvoice.getUsage().add(Addresses.USAGE_CONTRACT_INVOICE);
            postalAddressInvoice.getOwningGroup().addAll(contract.getOwningGroup());
            contract.addAddress(false, this.uuidAsString(), postalAddressInvoice);
        }
        if (postalAddressDeliveryT != null) {
            org.opencrx.kernel.contract1.jmi1.PostalAddress postalAddressDelivery = (org.opencrx.kernel.contract1.jmi1.PostalAddress)this.pm.newInstance(org.opencrx.kernel.contract1.jmi1.PostalAddress.class);
            this.datatypeMappers.mapPostalAddress(postalAddressDeliveryT, postalAddressDelivery);
            postalAddressDelivery.getUsage().add(Addresses.USAGE_CONTRACT_DELIVERY);
            postalAddressDelivery.getOwningGroup().addAll(contract.getOwningGroup());
            contract.addAddress(false, this.uuidAsString(), postalAddressDelivery);
        }
    }

    protected void addContractPositions(SalesContract contract, List<ContractPositionT> contractPositions, String defaultSalesTaxType, Boolean discountIsPercentage, BigDecimal discount) {
        for (ContractPositionT positionT : contractPositions) {
            String salesTaxTypeName = positionT.getSalesTaxType() == null ? defaultSalesTaxType : positionT.getSalesTaxType();
            SalesTaxType salesTaxType = this.findSalesTaxType(salesTaxTypeName);
            this.createContractPosition(contract, positionT.getProductNumber(), new BigDecimal(positionT.getQuantity()), this.noCopyOfProductConfiguration, positionT.getActualProductConfiguration(), positionT.getPriceUom(), positionT.getPricingDate(), salesTaxType, discountIsPercentage == null ? positionT.isDiscountIsPercentage() : discountIsPercentage, (BigDecimal)(discount == null ? (positionT.getDiscount() == null ? null : new BigDecimal(positionT.getDiscount())) : discount), positionT.getPricePerUnit() == null ? null : new BigDecimal(positionT.getPricePerUnit()));
        }
    }

    protected String validateContractPosition(String productNumber, String priceUomName) {
        Product product = this.findProduct(productNumber);
        if (product == null) {
            return "product '" + productNumber + "' not found";
        }
        Uom priceUom = this.findUom(priceUomName);
        if (priceUom == null) {
            return "priceUom '" + priceUom + "' not found";
        }
        if (!product.getPriceUom().contains(priceUom)) {
            HashSet<String> validPriceUoms = new HashSet<String>();
            List priceUoms = product.getPriceUom();
            for (Uom uom : priceUoms) {
                validPriceUoms.add(uom.getName());
            }
            return "priceUom '" + priceUom + "' not valid. Must be one of " + validPriceUoms;
        }
        return null;
    }

    protected String validateContractPositions(List<ContractPositionT> contractPositions) {
        int ii = 0;
        for (ContractPositionT position : contractPositions) {
            String validationResult = this.validateContractPosition(position.getProductNumber(), position.getPriceUom());
            if (validationResult != null) {
                return "ContractPosition " + ii + ": " + validationResult;
            }
            ++ii;
        }
        return null;
    }

    protected Collection<Object> toNonNullElementsCollection(Collection<?> source, Collection<Object> target, Object nullValue) {
        for (Object e : source) {
            if (e == null) {
                target.add(nullValue);
                continue;
            }
            target.add(e);
        }
        return target;
    }

    protected void updateProductConfiguration(ProductT productT, Product product, ProductConfigurationTypeSet configurationType) {
        SetConfigurationTypeParams setConfigurationTypeParams = (SetConfigurationTypeParams)Structures.create(SetConfigurationTypeParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)SetConfigurationTypeParams.Member.configurationType, (Object)configurationType)});
        product.setConfigurationType(setConfigurationTypeParams);
        ProductConfigurationSetContainsConfiguration.Configuration configurations = product.getConfiguration();
        ArrayList<ProductConfiguration> configurationsToBeDeleted = new ArrayList<ProductConfiguration>();
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            ProductConfiguration configuration = (ProductConfiguration)iterator.next();
            if (productT.getPriceUom().contains(configuration.getName())) {
                for (ProductConfigurationT configurationT : productT.getConfiguration()) {
                    if (!configuration.getName().equals(configurationT.getPropertySetName())) continue;
                    this.updatePropertySet(configurationT.getProperty(), configuration, false);
                }
                continue;
            }
            configurationsToBeDeleted.add(configuration);
        }
        for (ProductConfiguration configuration : configurationsToBeDeleted) {
            configuration.refDelete();
        }
    }

    protected void updateProductDescriptions(ProductT productT, Product product) {
        for (ProductDescriptionT descriptionT : productT.getDescription()) {
            org.opencrx.kernel.generic.cci2.Description description = null;
            DescriptionContainerContainsDescription.AdditionalDescription descriptions = product.getAdditionalDescription();
            Iterator iterator = descriptions.iterator();
            while (iterator.hasNext()) {
                Description e = (Description)iterator.next();
                if (e.getLanguage() != descriptionT.getLanguage()) continue;
                description = e;
                break;
            }
            if (description == null) {
                description = (Description)this.pm.newInstance(Description.class);
                description.getOwningGroup().addAll(product.getOwningGroup());
                product.addAdditionalDescription(false, this.uuidAsString(), (Description)description);
            }
            description.setDescription(descriptionT.getDescription());
            description.setDetailedDescription(descriptionT.getDetailedDescription());
            description.setLanguage((short)descriptionT.getLanguage());
        }
    }

    protected void updateProductPicture(ProductT productT, Product product) {
        if (productT.getPictureTitle() != null) {
            org.opencrx.kernel.document1.cci2.Media picture = null;
            CrxObjectHasMedia.Media pictures = product.getMedia();
            Iterator iterator = pictures.iterator();
            while (iterator.hasNext()) {
                Media e = (Media)iterator.next();
                if (e.getContentName() == null || !e.getContentName().equals(productT.getPictureTitle())) continue;
                picture = e;
                break;
            }
            if (picture == null) {
                picture = (Media)this.pm.newInstance(Media.class);
                picture.getOwningGroup().addAll(product.getOwningGroup());
                product.addMedia(this.uuidAsString(), (Media)picture);
            }
            picture.setDescription(productT.getPictureTitle());
            picture.setContentName(productT.getPictureTitle());
            picture.setContentMimeType(productT.getPictureMimeType());
            if (productT.getPictureContent() != null) {
                picture.setContent(BinaryLargeObjects.valueOf((byte[])productT.getPictureContent()));
            }
            product.setPicture(picture);
        } else {
            product.setPicture(null);
        }
    }

    protected void updateProductPhase(ProductT productT, Product product) {
        ProductContainsProductPhase.ProductPhase productPhases = product.getProductPhase();
        Iterator<Object> iterator = productPhases.iterator();
        while (iterator.hasNext()) {
            ProductPhase productPhase = (ProductPhase)iterator.next();
            productPhase.refDelete();
        }
        for (ProductPhaseT productPhaseT : productT.getProductPhase()) {
            ProductPhase productPhase = (ProductPhase)this.pm.newInstance(ProductPhase.class);
            productPhase.setName(productPhaseT.getName());
            productPhase.setProductPhaseKey(productPhaseT.getProductPhaseKey());
            productPhase.setValidFrom(productPhaseT.getValidFrom());
            productPhase.setValidTo(productPhaseT.getValidTo());
            productPhase.getOwningGroup().addAll(product.getOwningGroup());
            product.addProductPhase(this.uuidAsString(), productPhase);
        }
    }

    protected Collection<ContractPositionT> getSalesOrderPositions(Account customer, Integer salesOrderStatusThreshold) {
        String contractCategory = this.getShopCategory();
        ArrayList<ContractPositionT> positionsT = new ArrayList<ContractPositionT>();
        SalesOrderQuery salesOrderQuery = (SalesOrderQuery)this.pm.newQuery(SalesOrder.class);
        salesOrderQuery.thereExistsCustomer().equalTo(customer);
        if (salesOrderStatusThreshold != null) {
            salesOrderQuery.contractState().greaterThanOrEqualTo((Comparable)Short.valueOf(salesOrderStatusThreshold.shortValue()));
        }
        if (contractCategory != null) {
            salesOrderQuery.thereExistsCategory().equalTo((Object)contractCategory);
        }
        for (SalesOrder salesOrder : this.getContractSegment().getSalesOrder(salesOrderQuery)) {
            SalesOrderContainsSalesOrderPosition.Position positions = salesOrder.getPosition();
            Iterator iterator = positions.iterator();
            while (iterator.hasNext()) {
                AbstractSalesOrderPosition position = (AbstractSalesOrderPosition)iterator.next();
                if (!(position instanceof SalesOrderPosition)) continue;
                positionsT.add(this.datatypeMappers.mapContractPosition(position, salesOrder.getContractNumber(), null, ((SalesOrderPosition)position).getProduct()));
            }
        }
        return positionsT;
    }

    public void setContractStatus(AbstractContract contract, ContractStatusT contractStatusT) {
        String shortDescription = contract.getDescription();
        String string = shortDescription = shortDescription == null ? "" : shortDescription.substring(0, Math.min(shortDescription.length(), 50));
        if (contract.getModifiedAt() != null) {
            this.datatypeMappers.getAbstractContractFieldMapper().getStateHistory(contract).add(contract.getContractState() + "@" + DateTimeFormat.BASIC_UTC_FORMAT.format(contract.getModifiedAt()) + " // " + shortDescription);
        }
        contract.setContractState(DatatypeMappers.toShort(contractStatusT.getStatus()));
        contract.setDescription(contractStatusT.getDescription());
        if (contractStatusT.getTag() != null) {
            CrxObjectContainsPropertySet.PropertySet propertySets = contract.getPropertySet();
            String contractStatusPropertySetName = PropertySetName.ContractStatus + "." + contract.getContractState();
            PropertySet contractStatusProperties = null;
            Iterator iterator = propertySets.iterator();
            while (iterator.hasNext()) {
                PropertySet propertySet = (PropertySet)iterator.next();
                if (!propertySet.getName().equals(contractStatusPropertySetName)) continue;
                contractStatusProperties = propertySet;
                break;
            }
            if (contractStatusProperties == null) {
                contractStatusProperties = (PropertySet)this.pm.newInstance(PropertySet.class);
                contractStatusProperties.setName(contractStatusPropertySetName);
                contractStatusProperties.getOwningGroup().addAll(contract.getOwningGroup());
                contract.addPropertySet(this.uuidAsString(), contractStatusProperties);
            }
            this.updatePropertySet(contractStatusT.getTag(), contractStatusProperties, true);
        }
    }

    public void updateProductBundle(ProductT productT, Product product) {
        Boolean isBundle = productT.isBundle();
        this.datatypeMappers.getProductFieldMapper().setIsBundle(product, productT.isBundle());
        if (isBundle != null && isBundle.booleanValue()) {
            org.opencrx.kernel.product1.jmi1.Segment productSegment = this.getProductSegment();
            ProductFilterGlobal bundleFilter = null;
            SegmentContainsProductFilter.ProductFilter productFilters = productSegment.getProductFilter();
            Iterator iterator = productFilters.iterator();
            while (iterator.hasNext()) {
                ProductFilterGlobal f = (ProductFilterGlobal)iterator.next();
                if (!f.getName().equals(productT.getProductNumber())) continue;
                bundleFilter = f;
                break;
            }
            if (bundleFilter == null) {
                bundleFilter = (ProductFilterGlobal)this.pm.newInstance(ProductFilterGlobal.class);
                bundleFilter.setName(productT.getProductNumber());
                bundleFilter.setDescription("Filter for product bundle " + productT.getProductNumber());
                this.datatypeMappers.getProductFilterFieldMapper().setProductFilterType(bundleFilter, ProductFilterType.PRODUCT_BUNDLE.getValue());
                bundleFilter.getOwningGroup().addAll(productSegment.getOwningGroup());
                productSegment.addProductFilter(this.uuidAsString(), bundleFilter);
            }
            ProductClassificationFilterProperty filterProperty = null;
            ProductFilterHasFilterProperty.ProductFilterProperty filterProperties = bundleFilter.getProductFilterProperty();
            Iterator<Object> iterator2 = filterProperties.iterator();
            while (iterator2.hasNext()) {
                org.opencrx.kernel.product1.jmi1.ProductClassificationFilterProperty p = (org.opencrx.kernel.product1.jmi1.ProductClassificationFilterProperty)iterator2.next();
                if (!"Classifications".equals(p.getName())) continue;
                filterProperty = p;
                break;
            }
            if (filterProperty == null) {
                filterProperty = (org.opencrx.kernel.product1.jmi1.ProductClassificationFilterProperty)this.pm.newInstance(org.opencrx.kernel.product1.jmi1.ProductClassificationFilterProperty.class);
                filterProperty.setName("Classifications");
                filterProperty.setActive(Boolean.TRUE);
                filterProperty.setFilterOperator(ConditionType.IS_IN.code());
                filterProperty.setFilterQuantor(Quantifier.THERE_EXISTS.code());
                filterProperty.getOwningGroup().addAll(bundleFilter.getOwningGroup());
                bundleFilter.addProductFilterProperty(this.uuidAsString(), (ProductFilterProperty)((Object)filterProperty));
            }
            filterProperty.getClassification().clear();
            if (productT.getBundleData() != null && productT.getBundleData().getClassificationIdFilter() != null) {
                for (String classificationId : productT.getBundleData().getClassificationIdFilter()) {
                    filterProperty.getClassification().add(this.findProductClassification(classificationId));
                }
            }
        }
    }

    @Override
    public AddActivityFollowUpResult addActivityFollowUp(AddActivityFollowUpParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String activityNumber = params.getActivityNumber();
            if (activityNumber != null && activityNumber.length() > 0) {
                org.opencrx.kernel.activity1.jmi1.Segment activitySegment = this.getActivitySegment();
                Activity activity = this.findActivity(activityNumber, activitySegment);
                if (activity != null) {
                    String transitionName = params.getTransitionName();
                    ActivityProcessTransition transition = Activities.getInstance().findActivityProcessTransition(activity, transitionName);
                    if (transition != null) {
                        Account reportingCustomer = null;
                        if (params.getReportingCustomerNumber() != null) {
                            reportingCustomer = this.findAccount(params.getReportingCustomerNumber());
                        }
                        ActivityDoFollowUpParams doFollowUpParams = (ActivityDoFollowUpParams)Structures.create(ActivityDoFollowUpParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ActivityDoFollowUpParams.Member.assignTo, (Object)(reportingCustomer instanceof Contact ? (Contact)reportingCustomer : null)), Datatypes.member((Enum)ActivityDoFollowUpParams.Member.followUpText, (Object)params.getDescription()), Datatypes.member((Enum)ActivityDoFollowUpParams.Member.followUpTitle, (Object)params.getName()), Datatypes.member((Enum)ActivityDoFollowUpParams.Member.transition, (Object)transition)});
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                        ActivityDoFollowUpResult doFollowUpResult = activity.doFollowUp(doFollowUpParams);
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                        ActivityFollowUp followUp = doFollowUpResult.getFollowUp();
                        this.pm.refresh((Object)followUp);
                        if (params.getCategory() != null && !params.getCategory().isEmpty()) {
                            PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                            followUp.getCategory().addAll(params.getCategory());
                            PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                        }
                        result.add(Datatypes.member((Enum)AddActivityFollowUpResult.Member.followUp, (Object)this.datatypeMappers.mapActivityFollowUp(followUp)));
                        result.add(Datatypes.member((Enum)AddActivityFollowUpResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                    } else {
                        result.add(Datatypes.member((Enum)AddActivityFollowUpResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"ActivityProcessTransition", transitionName})));
                    }
                } else {
                    result.add(Datatypes.member((Enum)AddActivityFollowUpResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Activity", activityNumber})));
                }
            } else {
                result.add(Datatypes.member((Enum)AddActivityFollowUpResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-2, new String[]{"ActivityNumber is null or empty", activityNumber})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)AddActivityFollowUpResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (AddActivityFollowUpResult)Structures.create(AddActivityFollowUpResult.class, result);
    }

    @Override
    public AddCustomerToCustomerContractResult addCustomerToCustomerContract(AddCustomerToCustomerContractParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String customerNumber = params.getCustomerNumber();
            Account customer = this.findAccount(customerNumber);
            if (customer != null) {
                String customerContractNumber = params.getCustomerContractNumber();
                List<Lead> customerContracts = this.findCustomerContracts(customer);
                Lead customerContract = this.findCustomerContractByContractNumber(customerContractNumber);
                if (customerContract != null) {
                    if (customerContracts == null || !customerContracts.contains(customerContract)) {
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                        AccountAssignmentContract accountAssignment = (AccountAssignmentContract)this.pm.newInstance(AccountAssignmentContract.class);
                        accountAssignment.setAccount(customer);
                        customerContract.addAssignedAccount(this.uuidAsString(), accountAssignment);
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                        result.add(Datatypes.member((Enum)AddCustomerToCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, new String[]{"CustomerContract", customerContractNumber})));
                    } else {
                        result.add(Datatypes.member((Enum)AddCustomerToCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-26, new String[]{"Duplicate assignment of customer contract", customerNumber, customerContractNumber})));
                    }
                } else {
                    result.add(Datatypes.member((Enum)AddCustomerToCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Customer contract not found", customerContractNumber})));
                }
            } else {
                result.add(Datatypes.member((Enum)AddCustomerToCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Customer", customerNumber})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)AddCustomerToCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (AddCustomerToCustomerContractResult)Structures.create(AddCustomerToCustomerContractResult.class, result);
    }

    @Override
    public AddDeliveryInformationResult addDeliveryInformation(AddDeliveryInformationParams params) {
        ArrayList<Structures.Member> result;
        block15: {
            result = new ArrayList<Structures.Member>();
            try {
                String contractNumber = params.getContractNumber();
                String positionNumber = params.getPositionNumber();
                DeliveryInformationT deliveryInformationT = params.getDeliveryInformation();
                if (deliveryInformationT != null && contractNumber != null && contractNumber.length() > 0) {
                    SalesContract contract = this.findSalesOrder(contractNumber);
                    if (contract == null) {
                        contract = this.findInvoice(contractNumber);
                    }
                    if (contract != null) {
                        Object positions;
                        CrxObject position = null;
                        if (contract instanceof SalesOrder) {
                            positions = contract.getPosition();
                            Iterator iterator = positions.iterator();
                            while (iterator.hasNext()) {
                                AbstractSalesOrderPosition p = (AbstractSalesOrderPosition)iterator.next();
                                if (!p.getPositionNumber().equals(positionNumber)) continue;
                                position = p;
                                break;
                            }
                        } else if (contract instanceof Invoice) {
                            positions = ((Invoice)contract).getPosition();
                            Iterator iterator = positions.iterator();
                            while (iterator.hasNext()) {
                                AbstractInvoicePosition p = (AbstractInvoicePosition)iterator.next();
                                if (!p.getPositionNumber().equals(positionNumber)) continue;
                                position = p;
                                break;
                            }
                        }
                        if (position != null) {
                            PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                            DeliveryInformation deliveryInformation = (DeliveryInformation)this.pm.newInstance(DeliveryInformation.class);
                            deliveryInformation.setActualDeliveryOn(deliveryInformationT.getActualDeliveryOn());
                            deliveryInformation.setQuantityShipped(deliveryInformationT.getQuantityShipped() == null ? BigDecimal.ZERO : new BigDecimal(deliveryInformationT.getQuantityShipped()));
                            this.datatypeMappers.getDeliveryInformationFieldMapper().setDeliveryStatus(deliveryInformation, deliveryInformationT.getDeliveryStatus());
                            this.datatypeMappers.getDeliveryInformationFieldMapper().setDeliveryStatusDescription(deliveryInformation, deliveryInformationT.getDeliveryStatusDescription());
                            this.datatypeMappers.getDeliveryInformationFieldMapper().setProductAssembledAt(deliveryInformation, deliveryInformationT.getProductAssembledAt());
                            position.addDeliveryInformation(this.uuidAsString(), deliveryInformation);
                            PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                            result.add(Datatypes.member((Enum)AddDeliveryInformationResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                        } else {
                            result.add(Datatypes.member((Enum)AddDeliveryInformationResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Position", contractNumber, positionNumber})));
                        }
                        break block15;
                    }
                    result.add(Datatypes.member((Enum)AddDeliveryInformationResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"(SalesOrder|Invoice)", contractNumber})));
                    break block15;
                }
                result.add(Datatypes.member((Enum)AddDeliveryInformationResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-2, new String[]{"ContractNumber or DeliveryInformation is null or empty", contractNumber})));
            }
            catch (Exception e) {
                try {
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                new ServiceException(e).log();
                result.add(Datatypes.member((Enum)AddDeliveryInformationResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
            }
        }
        return (AddDeliveryInformationResult)Structures.create(AddDeliveryInformationResult.class, result);
    }

    @Override
    public AddSalesOrderPositionResult addSalesOrderPosition(AddSalesOrderPositionParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            SalesOrder salesOrder = this.findSalesOrder(params.getSalesOrderNumber());
            if (salesOrder != null) {
                String customerNumber = this.datatypeMappers.getAccountFieldMapper().getAccountNumber((Account)salesOrder.getCustomer());
                Lead customerContract = this.findCustomerContract(salesOrder);
                if (customerContract != null) {
                    String salesTaxTypeName = params.getSalesTaxType() == null || params.getSalesTaxType().isEmpty() ? this.datatypeMappers.getLeadFieldMapper().getSalesTaxType(customerContract) : params.getSalesTaxType();
                    SalesTaxType salesTaxType = this.findSalesTaxType(salesTaxTypeName);
                    if (salesTaxType != null || salesTaxTypeName == null) {
                        String validationResult = this.validateContractPosition(params.getProductNumber(), params.getPriceUom());
                        if (validationResult == null) {
                            this.createContractPosition(salesOrder, params.getProductNumber(), new BigDecimal(params.getQuantity()), this.noCopyOfProductConfiguration, params.getActualProductConfiguration(), params.getPriceUom(), params.getPricingDate(), salesTaxType, params.isDiscountIsPercentage() == null ? Boolean.TRUE : params.isDiscountIsPercentage(), params.getDiscount() == null ? BigDecimal.ZERO : new BigDecimal(params.getDiscount()), params.getPricePerUnit() == null ? null : new BigDecimal(params.getPricePerUnit()));
                            result.add(Datatypes.member((Enum)AddSalesOrderPositionResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                        } else {
                            result.add(Datatypes.member((Enum)AddSalesOrderPositionResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-2, new String[]{"SalesOrderPosition", validationResult})));
                        }
                    } else {
                        result.add(Datatypes.member((Enum)AddSalesOrderPositionResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"SalesTaxType", salesTaxTypeName})));
                    }
                } else {
                    result.add(Datatypes.member((Enum)AddSalesOrderPositionResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"CustomerContract", customerNumber})));
                }
            } else {
                result.add(Datatypes.member((Enum)AddSalesOrderPositionResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"SalesOrder", params.getSalesOrderNumber()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)AddSalesOrderPositionResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (AddSalesOrderPositionResult)Structures.create(AddSalesOrderPositionResult.class, result);
    }

    @Override
    public CancelInvoiceResult cancelInvoice(CancelInvoiceParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Invoice invoice = this.findInvoice(params.getInvoiceNumber());
            if (invoice != null) {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                invoice.setCancelOn(params.getCancelOn() == null ? new Date() : params.getCancelOn());
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                result.add(Datatypes.member((Enum)CancelInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)CancelInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Invoice", params.getInvoiceNumber()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CancelInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CancelInvoiceResult)Structures.create(CancelInvoiceResult.class, result);
    }

    @Override
    public CancelSalesOrderResult cancelSalesOrder(CancelSalesOrderParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            SalesOrder salesOrder = this.findSalesOrder(params.getSalesOrderNumber());
            if (salesOrder != null) {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                salesOrder.setCancelOn(params.getCancelOn() == null ? new Date() : params.getCancelOn());
                SalesOrderContainsSalesOrderPosition.Position positions = salesOrder.getPosition();
                Iterator iterator = positions.iterator();
                while (iterator.hasNext()) {
                    SalesOrderPosition position = (SalesOrderPosition)iterator.next();
                    position.setDisabled(true);
                }
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                result.add(Datatypes.member((Enum)CancelSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)CancelSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"SalesOrder", params.getSalesOrderNumber()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CancelSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CancelSalesOrderResult)Structures.create(CancelSalesOrderResult.class, result);
    }

    @Override
    public CreateActivityResult createActivity(CreateActivityParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String activityCreatorName = params.getActivityCreatorName();
            if (activityCreatorName != null && activityCreatorName.length() > 0) {
                org.opencrx.kernel.activity1.jmi1.Segment activitySegment = this.getActivitySegment();
                ActivityCreator activityCreator = Activities.getInstance().findActivityCreator(activityCreatorName, activitySegment);
                if (activityCreator != null) {
                    Account reportingCustomer = null;
                    if (params.getReportingCustomerNumber() != null) {
                        reportingCustomer = this.findAccount(params.getReportingCustomerNumber());
                    }
                    NewActivityParams newActivityParams = (NewActivityParams)Structures.create(NewActivityParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)NewActivityParams.Member.creationContext, null), Datatypes.member((Enum)NewActivityParams.Member.description, (Object)params.getDescription()), Datatypes.member((Enum)NewActivityParams.Member.detailedDescription, (Object)params.getDetailedDescription()), Datatypes.member((Enum)NewActivityParams.Member.dueBy, (Object)params.getDueBy()), Datatypes.member((Enum)NewActivityParams.Member.icalType, (Object)0), Datatypes.member((Enum)NewActivityParams.Member.name, (Object)params.getName()), Datatypes.member((Enum)NewActivityParams.Member.priority, (Object)(params.getPriority() == null ? (short)0 : params.getPriority().shortValue())), Datatypes.member((Enum)NewActivityParams.Member.reportingContact, (Object)(reportingCustomer instanceof Contact ? (Contact)reportingCustomer : null)), Datatypes.member((Enum)NewActivityParams.Member.scheduledEnd, (Object)params.getScheduledEnd()), Datatypes.member((Enum)NewActivityParams.Member.scheduledStart, (Object)params.getScheduledStart())});
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    NewActivityResult newActivityResult = activityCreator.newActivity(newActivityParams);
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    Activity activity = newActivityResult.getActivity();
                    this.pm.refresh((Object)activity);
                    result.add(Datatypes.member((Enum)CreateActivityResult.Member.activity, (Object)this.datatypeMappers.mapActivity(activity)));
                    result.add(Datatypes.member((Enum)CreateActivityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                } else {
                    result.add(Datatypes.member((Enum)CreateActivityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"ActivityCreator", activityCreatorName})));
                }
            } else {
                result.add(Datatypes.member((Enum)CreateActivityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-2, new String[]{"ActivityCreator is null or empty", activityCreatorName})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CreateActivityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CreateActivityResult)Structures.create(CreateActivityResult.class, result);
    }

    @Override
    public CreateCustomerAsContactResult createCustomerAsContact(CreateCustomerAsContactParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            AccountQuery accountQuery = (AccountQuery)this.pm.newQuery(Account.class);
            accountQuery.thereExistsUserString0().equalTo((Object)params.getUserName());
            List accounts = this.getAccountSegment().getAccount(accountQuery);
            if (accounts.isEmpty()) {
                boolean isDuplicateEMailAddressHome = false;
                boolean isDuplicateEMailAddressBusiness = false;
                if (this.emailAddressMustBeUnique) {
                    List addresses;
                    EMailAddressQuery addressQuery;
                    if (params.getEmailAddressHome() != null) {
                        addressQuery = (EMailAddressQuery)this.pm.newQuery(EMailAddress.class);
                        addressQuery.thereExistsEmailAddress().equalTo((Object)params.getEmailAddressHome());
                        addresses = this.getAccountSegment().getAddress(addressQuery);
                        boolean bl = isDuplicateEMailAddressHome = !addresses.isEmpty();
                    }
                    if (params.getEmailAddressBusiness() != null) {
                        addressQuery = (EMailAddressQuery)this.pm.newQuery(EMailAddress.class);
                        addressQuery.thereExistsEmailAddress().equalTo((Object)params.getEmailAddressBusiness());
                        addresses = this.getAccountSegment().getAddress(addressQuery);
                        boolean bl = isDuplicateEMailAddressBusiness = !addresses.isEmpty();
                    }
                }
                if (!this.emailAddressMustBeUnique || !isDuplicateEMailAddressHome && !isDuplicateEMailAddressBusiness) {
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    Contact customer = (Contact)this.pm.newInstance(Contact.class);
                    customer.setLastName(params.getLastName());
                    customer.setFirstName(params.getFirstName());
                    this.datatypeMappers.getAccountFieldMapper().setUserName(customer, params.getUserName());
                    customer.getOwningGroup().addAll(this.getAccountSegment().getOwningGroup());
                    this.getAccountSegment().addAccount(false, this.uuidAsString(), customer);
                    if (params.getEmailAddressHome() != null && params.getEmailAddressHome().length() > 0) {
                        EMailAddress emailAddressHome = (EMailAddress)this.pm.newInstance(EMailAddress.class);
                        emailAddressHome.setEmailAddress(params.getEmailAddressHome());
                        emailAddressHome.getUsage().add(Addresses.USAGE_HOME);
                        this.datatypeMappers.getEmailAddressFieldMapper().setEmailValid(emailAddressHome, false);
                        emailAddressHome.getOwningGroup().addAll(customer.getOwningGroup());
                        customer.addAddress(false, this.uuidAsString(), emailAddressHome);
                    }
                    if (params.getEmailAddressBusiness() != null && params.getEmailAddressBusiness().length() > 0) {
                        EMailAddress emailAddressBusiness = (EMailAddress)this.pm.newInstance(EMailAddress.class);
                        emailAddressBusiness.setEmailAddress(params.getEmailAddressBusiness());
                        emailAddressBusiness.getUsage().add(Addresses.USAGE_BUSINESS);
                        this.datatypeMappers.getEmailAddressFieldMapper().setEmailValid(emailAddressBusiness, false);
                        emailAddressBusiness.getOwningGroup().addAll(customer.getOwningGroup());
                        customer.addAddress(false, this.uuidAsString(), emailAddressBusiness);
                    }
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    customer = (Contact)this.pm.getObjectById((Object)customer.refGetPath());
                    this.pm.refresh((Object)customer);
                    result.add(Datatypes.member((Enum)CreateCustomerAsContactResult.Member.customer, (Object)this.datatypeMappers.mapCustomer(customer, null, this.getShopCategory())));
                    result.add(Datatypes.member((Enum)CreateCustomerAsContactResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                } else {
                    result.add(Datatypes.member((Enum)CreateCustomerAsContactResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-26, new String[]{"EmailAddress", params.getEmailAddressHome()})));
                }
            } else {
                result.add(Datatypes.member((Enum)CreateCustomerAsContactResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-26, new String[]{"Account", params.getUserName()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CreateCustomerAsContactResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CreateCustomerAsContactResult)Structures.create(CreateCustomerAsContactResult.class, result);
    }

    @Override
    public CreateCustomerAsLegalEntityResult createCustomerAsLegalEntity(CreateCustomerAsLegalEntityParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            LegalEntityQuery legalEntityQuery = (LegalEntityQuery)this.pm.newQuery(LegalEntity.class);
            legalEntityQuery.name().equalTo((Object)params.getLegalName());
            List legalEntities = this.getAccountSegment().getAccount(legalEntityQuery);
            if (legalEntities.isEmpty()) {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                LegalEntity customer = (LegalEntity)this.pm.newInstance(LegalEntity.class);
                customer.setName(params.getLegalName());
                customer.getOwningGroup().addAll(this.getAccountSegment().getOwningGroup());
                this.getAccountSegment().addAccount(false, this.uuidAsString(), customer);
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                customer = (LegalEntity)this.pm.getObjectById((Object)customer.refGetPath());
                this.pm.refresh((Object)customer);
                result.add(Datatypes.member((Enum)CreateCustomerAsLegalEntityResult.Member.customer, (Object)this.datatypeMappers.mapCustomer(customer, null, this.getShopCategory())));
                result.add(Datatypes.member((Enum)CreateCustomerAsLegalEntityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)CreateCustomerAsLegalEntityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-26, new String[]{"legalName", params.getLegalName()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CreateCustomerAsLegalEntityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CreateCustomerAsLegalEntityResult)Structures.create(CreateCustomerAsLegalEntityResult.class, result);
    }

    @Override
    public CreateCustomerContractResult createCustomerContract(CreateCustomerContractParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String customerNumber = params.getCustomerContract().getCustomerNumber();
            Account customer = this.findAccount(customerNumber);
            if (customer != null) {
                Lead customerContract = this.findMainCustomerContract(customer);
                if (customerContract == null) {
                    CustomerContractT customerContractT = params.getCustomerContract();
                    customerContract = (Lead)this.pm.newInstance(Lead.class);
                    customerContract.setCustomer(customer);
                    customerContract.setPricingRule(this.findPricingRule());
                    String contractCategory = this.getShopCategory();
                    if (contractCategory != null) {
                        customerContract.getCategory().add(contractCategory);
                    }
                    this.datatypeMappers.getLeadFieldMapper().setContractNumber(customerContract, customerNumber);
                    this.datatypeMappers.getLeadFieldMapper().setAcceptedLegal(customerContract, customerContractT.isAcceptedLegal());
                    this.datatypeMappers.getLeadFieldMapper().setAcceptedMarketing(customerContract, customerContractT.isAcceptedMarketing());
                    this.datatypeMappers.getLeadFieldMapper().setAcceptedPrivateDataForwarding(customerContract, customerContractT.isAcceptedPrivateDataForwarding());
                    this.datatypeMappers.getLeadFieldMapper().setReferrer(customerContract, customerContractT.getReferrer());
                    this.datatypeMappers.getLeadFieldMapper().setContactSource(customerContract, customerContractT.getContactSource());
                    this.datatypeMappers.getLeadFieldMapper().setSalesTaxType(customerContract, customerContractT.getSalesTaxType());
                    this.datatypeMappers.getLeadFieldMapper().setContractCurrency(customerContract, customerContractT.getContractCurrency());
                    this.datatypeMappers.getLeadFieldMapper().setNoBilling(customerContract, customerContractT.isNoBilling());
                    this.datatypeMappers.getAbstractContractFieldMapper().setBillingPartner(customerContract, customerContractT.getBillingPartner());
                    this.datatypeMappers.getAbstractContractFieldMapper().setBillingPartnerRegistrationId(customerContract, customerContractT.getBillingPartnerRegistrationId());
                    if (customerContractT.getContractStatus() != null) {
                        this.setContractStatus(customerContract, customerContractT.getContractStatus());
                    }
                    customerContract.getOwningGroup().addAll(this.getContractSegment().getOwningGroup());
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    this.getContractSegment().addLead(this.uuidAsString(), customerContract);
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    customerContract = (Lead)this.pm.getObjectById((Object)customerContract.refGetPath());
                    this.pm.refresh((Object)customerContract);
                    result.add(Datatypes.member((Enum)CreateCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                    result.add(Datatypes.member((Enum)CreateCustomerContractResult.Member.customerContract, (Object)this.datatypeMappers.mapCustomerContract(customerContract)));
                } else {
                    result.add(Datatypes.member((Enum)CreateCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-26, new String[]{"CustomerContract", customerNumber})));
                }
            } else {
                result.add(Datatypes.member((Enum)CreateCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Customer", customerNumber})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CreateCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CreateCustomerContractResult)Structures.create(CreateCustomerContractResult.class, result);
    }

    @Override
    public CreateInvoiceResult createInvoice(CreateInvoiceParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String customerNumber = params.getInvoice().getContract().getCustomerNumber();
            Account customer = this.findAccount(customerNumber);
            if (customer != null) {
                Lead customerContract = null;
                if (params.getCustomerContractNumber() != null) {
                    customerContract = this.findCustomerContractByContractNumber(params.getCustomerContractNumber());
                } else {
                    List<Lead> customerContracts;
                    customerContract = this.findMainCustomerContract(customer);
                    if (customerContract == null && (customerContracts = this.findCustomerContracts(customer)) != null && customerContracts.size() == 1) {
                        customerContract = customerContracts.iterator().next();
                    }
                }
                if (customerContract != null) {
                    String validationResult = this.validateContractPositions(params.getInvoice().getContract().getPosition());
                    if (validationResult == null) {
                        String invoiceNumber = this.getNextInvoiceNumber(customer);
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                        Invoice invoice = Accounts.getInstance().createInvoice(customer, invoiceNumber + " /" + customerNumber, null, null);
                        this.datatypeMappers.mapInvoice(invoice, customerContract, customer, invoiceNumber, params.getInvoice().isVoucher(), InvoiceState.DRAFT, this.findPricingRule());
                        String contractCategory = this.getShopCategory();
                        if (contractCategory != null) {
                            invoice.getCategory().add(contractCategory);
                        }
                        invoice.getOwningGroup().addAll(this.getContractSegment().getOwningGroup());
                        this.addContractAddresses(invoice, params.getInvoice().getContract().getPostalAddressInvoice(), params.getInvoice().getContract().getPostalAddressDelivery());
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                        this.addContractPositions(invoice, params.getInvoice().getContract().getPosition(), this.datatypeMappers.getLeadFieldMapper().getSalesTaxType(customerContract), null, null);
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                        invoice.reprice();
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                        this.pm.refresh((Object)invoice);
                        result.add(Datatypes.member((Enum)CreateInvoiceResult.Member.invoice, (Object)this.datatypeMappers.mapInvoice(invoice)));
                        result.add(Datatypes.member((Enum)CreateInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                    } else {
                        result.add(Datatypes.member((Enum)CreateInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-2, new String[]{"CustomerContract", customerNumber, validationResult})));
                    }
                } else {
                    result.add(Datatypes.member((Enum)CreateInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"No CustomerContract not found for customer. Check existence of main contract of customer or specify customerContractNumber as input.", customerNumber})));
                }
            } else {
                result.add(Datatypes.member((Enum)CreateInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Account", customerNumber})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CreateInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CreateInvoiceResult)Structures.create(CreateInvoiceResult.class, result);
    }

    @Override
    public CreateInvoiceFromInvoiceResult createInvoiceFromInvoice(CreateInvoiceFromInvoiceParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Invoice originalInvoice = this.findInvoice(params.getInvoiceNumber());
            if (originalInvoice != null) {
                String contractCategory;
                org.opencrx.kernel.account1.cci2.Account customer = originalInvoice.getCustomer();
                String customerNumber = this.datatypeMappers.getAccountFieldMapper().getAccountNumber((Account)customer);
                String newInvoiceNumber = this.getNextInvoiceNumber((Account)originalInvoice.getCustomer());
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                Invoice newInvoice = Accounts.getInstance().createInvoice((Account)customer, newInvoiceNumber + " /" + customerNumber, null, originalInvoice);
                this.datatypeMappers.mapInvoice(newInvoice, originalInvoice, (Account)originalInvoice.getCustomer(), newInvoiceNumber, Boolean.FALSE, InvoiceState.DRAFT, (PricingRule)originalInvoice.getPricingRule());
                this.datatypeMappers.getAbstractContractFieldMapper().getStateHistory(newInvoice).clear();
                if (params.getExpiresOn() != null) {
                    newInvoice.setExpiresOn(params.getExpiresOn());
                }
                if ((contractCategory = this.getShopCategory()) != null) {
                    newInvoice.getCategory().add(contractCategory);
                }
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                InvoiceT originalInvoiceT = this.datatypeMappers.mapInvoice(originalInvoice);
                Lead customerContract = this.findCustomerContract(originalInvoice);
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                this.addContractAddresses(newInvoice, originalInvoiceT.getContract().getPostalAddressInvoice(), originalInvoiceT.getContract().getPostalAddressDelivery());
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                SysLog.detail((String)"Adding positions to newly created invoice", (Object)originalInvoiceT.getContract().getPosition().size());
                this.addContractPositions(newInvoice, originalInvoiceT.getContract().getPosition(), this.datatypeMappers.getLeadFieldMapper().getSalesTaxType(customerContract), null, null);
                this.pm.refresh((Object)newInvoice);
                result.add(Datatypes.member((Enum)CreateInvoiceFromInvoiceResult.Member.invoice, (Object)this.datatypeMappers.mapInvoice(newInvoice)));
                result.add(Datatypes.member((Enum)CreateInvoiceFromInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)CreateInvoiceFromInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Invoice", params.getInvoiceNumber()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CreateInvoiceFromInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CreateInvoiceFromInvoiceResult)Structures.create(CreateInvoiceFromInvoiceResult.class, result);
    }

    @Override
    public CreateInvoiceFromSalesOrderResult createInvoiceFromSalesOrder(CreateInvoiceFromSalesOrderParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            SalesOrder salesOrder = this.findSalesOrder(params.getSalesOrderNumber());
            if (salesOrder != null) {
                String invoiceNumber = this.getNextInvoiceNumber((Account)salesOrder.getCustomer());
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                SalesOrderCreateInvoiceResult createInvoiceResult = salesOrder.createInvoice();
                this.pm.flush();
                Invoice invoice = (Invoice)this.pm.getObjectById((Object)createInvoiceResult.getInvoice().refGetPath());
                this.datatypeMappers.mapInvoice(invoice, salesOrder, (Account)salesOrder.getCustomer(), invoiceNumber, Boolean.FALSE, InvoiceState.DRAFT, (PricingRule)salesOrder.getPricingRule());
                this.datatypeMappers.getAbstractContractFieldMapper().getStateHistory(invoice).clear();
                String contractCategory = this.getShopCategory();
                if (contractCategory != null) {
                    invoice.getCategory().add(contractCategory);
                }
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                this.pm.refresh((Object)invoice);
                result.add(Datatypes.member((Enum)CreateInvoiceFromSalesOrderResult.Member.invoice, (Object)this.datatypeMappers.mapInvoice(invoice)));
                result.add(Datatypes.member((Enum)CreateInvoiceFromSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)CreateInvoiceFromSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"SalesOrder", params.getSalesOrderNumber()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CreateInvoiceFromSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CreateInvoiceFromSalesOrderResult)Structures.create(CreateInvoiceFromSalesOrderResult.class, result);
    }

    @Override
    public CreateProductClassificationResult createProductClassification(CreateProductClassificationParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            boolean hasErrors = false;
            for (ProductClassificationT classificationT : params.getClassification()) {
                ProductClassification classification = this.findProductClassification(classificationT.getClassificationId());
                if (classification == null) {
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    classification = (ProductClassification)this.pm.newInstance(ProductClassification.class);
                    classification.setName(classificationT.getClassificationId());
                    classification.setDescription(classificationT.getDescription());
                    classification.getOwningGroup().addAll(this.getProductSegment().getOwningGroup());
                    this.getProductSegment().addProductClassification(this.uuidAsString(), classification);
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    continue;
                }
                result.add(Datatypes.member((Enum)CreateProductClassificationResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-26, new String[]{"ProductClassification", classificationT.getClassificationId()})));
                hasErrors = true;
                break;
            }
            if (!hasErrors) {
                result.add(Datatypes.member((Enum)CreateProductClassificationResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CreateProductClassificationResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CreateProductClassificationResult)Structures.create(CreateProductClassificationResult.class, result);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CreateProductsResult createProducts(CreateProductsParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            boolean hasErrors = false;
            Date creationStartedAt = new Date();
            for (ProductT productT : params.getProduct()) {
                Product product = this.findProduct(productT.getProductNumber());
                if (product == null) {
                    void var10_12;
                    ProductConfigurationTypeSet productConfigurationTypeSet;
                    product = (Product)this.pm.newInstance(Product.class);
                    ArrayList<ProductClassification> productClassifications = new ArrayList<ProductClassification>();
                    for (String string : productT.getClassificationId()) {
                        ProductClassification classification = this.findProductClassification(string);
                        if (classification != null) {
                            productClassifications.add(classification);
                            continue;
                        }
                        result.add(Datatypes.member((Enum)CreateProductsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Product", productT.getProductNumber(), "ProductClassification", string})));
                        hasErrors = true;
                        break;
                    }
                    if (hasErrors) break;
                    ArrayList<Uom> priceUoms = new ArrayList<Uom>();
                    for (String priceUomName : productT.getPriceUom()) {
                        Uom priceUom = this.findUom(priceUomName);
                        if (priceUom != null) {
                            priceUoms.add(priceUom);
                            continue;
                        }
                        result.add(Datatypes.member((Enum)CreateProductsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Product", productT.getProductNumber(), "PriceUom", priceUomName})));
                        hasErrors = true;
                        break;
                    }
                    if (hasErrors) break;
                    this.datatypeMappers.mapProduct(productT, product);
                    product.getClassification().addAll(productClassifications);
                    product.getPriceUom().addAll(priceUoms);
                    product.getOwningGroup().addAll(this.getProductSegment().getOwningGroup());
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    this.getProductSegment().addProduct(productT.getProductNumber(), product);
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    Object var10_16 = null;
                    if (productT.getConfigurationType() != null && (productConfigurationTypeSet = this.findProductConfigurationType(productT.getConfigurationType())) == null) {
                        result.add(Datatypes.member((Enum)CreateProductsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"ProductConfigurationType", productT.getConfigurationType()})));
                        hasErrors = true;
                        break;
                    }
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    if (var10_12 != null) {
                        this.updateProductConfiguration(productT, product, (ProductConfigurationTypeSet)var10_12);
                    }
                    this.updateProductDescriptions(productT, product);
                    this.updateProductPicture(productT, product);
                    this.updateProductPhase(productT, product);
                    this.updateProductBundle(productT, product);
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    result.add(Datatypes.member((Enum)CreateProductsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                    continue;
                }
                result.add(Datatypes.member((Enum)CreateProductsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-26, new String[]{"Product", productT.getProductNumber()})));
                hasErrors = true;
                break;
            }
            SegmentContainsPriceLevel.PriceLevel priceLevels = this.getProductSegment().getPriceLevel();
            Iterator iterator = priceLevels.iterator();
            while (iterator.hasNext()) {
                AbstractPriceLevel priceLevel = (AbstractPriceLevel)iterator.next();
                if (priceLevel.isFinal() != null && priceLevel.isFinal().booleanValue()) continue;
                Uom priceUom = null;
                ProductFilterHasFilterProperty.ProductFilterProperty filterProperties = priceLevel.getProductFilterProperty();
                Iterator iterator2 = filterProperties.iterator();
                while (iterator2.hasNext()) {
                    List filteredPriceUoms;
                    ProductFilterProperty filterProperty = (ProductFilterProperty)iterator2.next();
                    if (!(filterProperty instanceof PriceUomFilterProperty) || (filteredPriceUoms = ((PriceUomFilterProperty)filterProperty).getPriceUom()).isEmpty()) continue;
                    priceUom = (Uom)filteredPriceUoms.iterator().next();
                    break;
                }
                if (priceUom == null) continue;
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                CreateInitialPricesParams createInitialPricesParams = (CreateInitialPricesParams)Structures.create(CreateInitialPricesParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CreateInitialPricesParams.Member.includeProductsModifiedSince, (Object)creationStartedAt), Datatypes.member((Enum)CreateInitialPricesParams.Member.priceUom, (Object)priceUom), Datatypes.member((Enum)CreateInitialPricesParams.Member.processingMode, (Object)2)});
                priceLevel.createInitialPrices(createInitialPricesParams);
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
            }
            if (!hasErrors) {
                result.add(Datatypes.member((Enum)CreateProductsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CreateProductsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CreateProductsResult)Structures.create(CreateProductsResult.class, result);
    }

    @Override
    public CreateSalesOrderResult createSalesOrder(CreateSalesOrderParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String customerNumber = params.getSalesOrder().getContract().getCustomerNumber();
            Account customer = this.findAccount(customerNumber);
            if (customer != null) {
                Lead customerContract = null;
                if (params.getCustomerContractNumber() != null) {
                    customerContract = this.findCustomerContractByContractNumber(params.getCustomerContractNumber());
                } else {
                    List<Lead> customerContracts;
                    customerContract = this.findMainCustomerContract(customer);
                    if (customerContract == null && (customerContracts = this.findCustomerContracts(customer)) != null && customerContracts.size() == 1) {
                        customerContract = customerContracts.iterator().next();
                    }
                }
                if (customerContract != null) {
                    String validationResult = this.validateContractPositions(params.getSalesOrder().getContract().getPosition());
                    if (validationResult == null) {
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                        String contractNumber = params.getSalesOrder().getContract().getContractNumber();
                        String salesOrderNumber = contractNumber == null || contractNumber.isEmpty() ? this.getNextSalesOrderNumber(customer) : contractNumber;
                        SalesOrder salesOrder = (SalesOrder)this.pm.newInstance(SalesOrder.class);
                        this.getContractSegment().addSalesOrder(this.uuidAsString(), salesOrder);
                        ContractT contractT = params.getSalesOrder().getContract();
                        this.datatypeMappers.mapSalesOrder(salesOrder, customerContract, customer, salesOrderNumber, SalesOrderState.DRAFT, contractT.getContractCurrency(), contractT.getActiveOn(), contractT.getExpiresOn(), contractT.getCancelOn(), contractT.getClosedOn(), contractT.isGift(), contractT.getGiftMessage(), this.findPricingRule());
                        salesOrder.getOwningGroup().addAll(this.getContractSegment().getOwningGroup());
                        String contractCategory = this.getShopCategory();
                        if (contractCategory != null) {
                            salesOrder.getCategory().add(contractCategory);
                        }
                        this.addContractAddresses(salesOrder, params.getSalesOrder().getContract().getPostalAddressDelivery(), params.getSalesOrder().getContract().getPostalAddressInvoice());
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                        this.pm.refresh((Object)salesOrder);
                        this.addContractPositions(salesOrder, params.getSalesOrder().getContract().getPosition(), this.datatypeMappers.getLeadFieldMapper().getSalesTaxType(customerContract), null, null);
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                        salesOrder.reprice();
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                        this.pm.refresh((Object)salesOrder);
                        result.add(Datatypes.member((Enum)CreateSalesOrderResult.Member.salesOrder, (Object)this.datatypeMappers.mapSalesOrder(salesOrder)));
                        result.add(Datatypes.member((Enum)CreateSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                    } else {
                        result.add(Datatypes.member((Enum)CreateSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-2, new String[]{"CustomerContract", customerNumber, validationResult})));
                    }
                } else {
                    result.add(Datatypes.member((Enum)CreateSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"No CustomerContract not found for customer. Check existence of main contract of customer or specify customerContractNumber as input.", customerNumber})));
                }
            } else {
                result.add(Datatypes.member((Enum)CreateSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Account", customerNumber})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)CreateSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (CreateSalesOrderResult)Structures.create(CreateSalesOrderResult.class, result);
    }

    @Override
    public GetActivitiesByQueryResult getActivitiesByQuery(GetActivitiesByQueryParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String customerNumber = params.getCustomerNumber();
            Account customer = this.findAccount(customerNumber);
            if (customer != null) {
                ActivityQuery activityQuery = (ActivityQuery)this.pm.newQuery(Activity.class);
                if (params.getPercentCompleteThreshold() != null) {
                    activityQuery.thereExistsPercentComplete().greaterThanOrEqualTo((Comparable)Short.valueOf(params.getPercentCompleteThreshold().shortValue()));
                }
                activityQuery.orderByActivityNumber().descending();
                List activities = customer.getAssignedActivity(activityQuery);
                ArrayList<ActivityT> activitiesT = new ArrayList<ActivityT>();
                for (Activity activity : activities) {
                    activitiesT.add(this.datatypeMappers.mapActivity(activity));
                }
                result.add(Datatypes.member((Enum)GetActivitiesByQueryResult.Member.activity, activitiesT));
                result.add(Datatypes.member((Enum)GetActivitiesByQueryResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)GetActivitiesByQueryResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Customer", customerNumber})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetActivitiesByQueryResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetActivitiesByQueryResult)Structures.create(GetActivitiesByQueryResult.class, result);
    }

    @Override
    public GetActivityResult getActivity(GetActivityParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String activityNumber = params.getActivityNumber();
            Activity activity = this.findActivity(activityNumber, this.getActivitySegment());
            if (activity != null) {
                result.add(Datatypes.member((Enum)GetActivityResult.Member.activity, (Object)this.datatypeMappers.mapActivity(activity)));
                result.add(Datatypes.member((Enum)GetActivityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)GetActivityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Activity", activityNumber})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetActivityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetActivityResult)Structures.create(GetActivityResult.class, result);
    }

    @Override
    public GetCodeValueContainerResult getCodeValueContainer(GetCodeValueContainerParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            ArrayList<CodeValueContainerT> containersT = new ArrayList<CodeValueContainerT>();
            boolean hasErrors = false;
            for (String name : params.getContainerName()) {
                CodeValueContainer container = this.findCodeValueContainer(name, params.isRootContainers());
                if (container != null) {
                    ArrayList<CodeValueEntryT> entriesT = new ArrayList<CodeValueEntryT>();
                    CodeValueContainerContainsEntry.Entry entries = container.getEntry();
                    Iterator iterator = entries.iterator();
                    while (iterator.hasNext()) {
                        AbstractEntry entry = (AbstractEntry)iterator.next();
                        if (entry instanceof CodeValueEntry) {
                            CodeValueEntry codeValueEntry = (CodeValueEntry)entry;
                            entriesT.add((CodeValueEntryT)Datatypes.create(CodeValueEntryT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CodeValueEntryT.Member.code, (Object)(codeValueEntry.getEntryValue() == null ? codeValueEntry.refGetPath().getLastSegment().toString() : codeValueEntry.getEntryValue())), Datatypes.member((Enum)CodeValueEntryT.Member.shortText, codeValueEntry.getShortText() == null ? Collections.emptyList() : this.toNonNullElementsCollection(codeValueEntry.getShortText(), new ArrayList<Object>(), "")), Datatypes.member((Enum)CodeValueEntryT.Member.longText, codeValueEntry.getLongText() == null ? Collections.emptyList() : this.toNonNullElementsCollection(codeValueEntry.getLongText(), new ArrayList<Object>(), "")), Datatypes.member((Enum)CodeValueEntryT.Member.validFrom, (Object)codeValueEntry.getValidFrom()), Datatypes.member((Enum)CodeValueEntryT.Member.validTo, (Object)codeValueEntry.getValidTo())}));
                            continue;
                        }
                        if (!(entry instanceof SimpleEntry)) continue;
                        SimpleEntry simpleEntry = (SimpleEntry)entry;
                        entriesT.add((CodeValueEntryT)Datatypes.create(CodeValueEntryT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CodeValueEntryT.Member.code, (Object)(simpleEntry.getEntryValue() == null ? simpleEntry.refGetPath().getLastSegment().toString() : simpleEntry.getEntryValue())), Datatypes.member((Enum)CodeValueEntryT.Member.shortText, Collections.emptyList()), Datatypes.member((Enum)CodeValueEntryT.Member.longText, Collections.emptyList()), Datatypes.member((Enum)CodeValueEntryT.Member.validFrom, (Object)simpleEntry.getValidFrom()), Datatypes.member((Enum)CodeValueEntryT.Member.validTo, (Object)simpleEntry.getValidTo())}));
                    }
                    containersT.add((CodeValueContainerT)Datatypes.create(CodeValueContainerT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CodeValueContainerT.Member.name, (Object)name), Datatypes.member((Enum)CodeValueContainerT.Member.entry, entriesT)}));
                    continue;
                }
                result.add(Datatypes.member((Enum)GetCodeValueContainerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"CodeValueContainer", name})));
                hasErrors = true;
                break;
            }
            if (!hasErrors) {
                result.add(Datatypes.member((Enum)GetCodeValueContainerResult.Member.container, containersT));
                result.add(Datatypes.member((Enum)GetCodeValueContainerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetCodeValueContainerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetCodeValueContainerResult)Structures.create(GetCodeValueContainerResult.class, result);
    }

    @Override
    public GetCredentialsResult getCredentials(GetCredentialsParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            AccountQuery query = (AccountQuery)this.pm.newQuery(Account.class);
            query.thereExistsUserString0().equalTo((Object)params.getUserName());
            List accounts = this.getAccountSegment().getAccount(query);
            if (!accounts.isEmpty()) {
                Account customer = (Account)accounts.iterator().next();
                result.add(Datatypes.member((Enum)GetCredentialsResult.Member.customerNumber, (Object)customer.getAliasName()));
                result.add(Datatypes.member((Enum)GetCredentialsResult.Member.credentials, (Object)this.datatypeMappers.mapCredentials(customer)));
                result.add(Datatypes.member((Enum)GetCredentialsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)GetCredentialsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Account", params.getUserName()})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetCredentialsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetCredentialsResult)Structures.create(GetCredentialsResult.class, result);
    }

    @Override
    public GetCredentialsByEmailAddressResult getCredentialsByEmailAddress(GetCredentialsByEmailAddressParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            if (params.getEmailAddress() != null && params.getEmailAddress().length() > 0) {
                EMailAddressQuery addressQuery = (EMailAddressQuery)this.pm.newQuery(EMailAddress.class);
                addressQuery.thereExistsEmailAddress().equalTo((Object)params.getEmailAddress());
                List addresses = this.getAccountSegment().getAddress(addressQuery);
                ArrayList<Account> accounts = new ArrayList<Account>();
                ArrayList<String> customerNumbers = new ArrayList<String>();
                for (AccountAddress address : addresses) {
                    Account account = (Account)this.pm.getObjectById((Object)address.refGetPath().getParent().getParent());
                    if (accounts.contains(account)) continue;
                    accounts.add(account);
                    customerNumbers.add(this.datatypeMappers.getAccountFieldMapper().getAccountNumber(account));
                }
                if (!accounts.isEmpty()) {
                    if (accounts.size() == 1) {
                        Account customer = (Account)accounts.iterator().next();
                        result.add(Datatypes.member((Enum)GetCredentialsByEmailAddressResult.Member.customerNumber, (Object)customer.getAliasName()));
                        result.add(Datatypes.member((Enum)GetCredentialsByEmailAddressResult.Member.credentials, (Object)this.datatypeMappers.mapCredentials(customer)));
                        result.add(Datatypes.member((Enum)GetCredentialsByEmailAddressResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                    } else {
                        result.add(Datatypes.member((Enum)GetCredentialsByEmailAddressResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-2, new String[]{"Email address is not unique. Multiple customers found.", params.getEmailAddress(), ((Object)customerNumbers).toString()})));
                    }
                } else {
                    result.add(Datatypes.member((Enum)GetCredentialsByEmailAddressResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Account", params.getEmailAddress()})));
                }
            } else {
                result.add(Datatypes.member((Enum)GetCredentialsByEmailAddressResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-2, new String[]{"emailAddress is null or empty"})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetCredentialsByEmailAddressResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetCredentialsByEmailAddressResult)Structures.create(GetCredentialsByEmailAddressResult.class, result);
    }

    @Override
    public GetCustomerResult getCustomer(GetCustomerParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Account customer = this.findAccount(params.getCustomerNumber());
            if (customer != null) {
                List<Lead> customerContracts = this.findCustomerContracts(customer);
                result.add(Datatypes.member((Enum)GetCustomerResult.Member.customer, (Object)this.datatypeMappers.mapCustomer(customer, customerContracts, this.getShopCategory())));
                result.add(Datatypes.member((Enum)GetCustomerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)GetCustomerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Account", params.getCustomerNumber()})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetCustomerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetCustomerResult)Structures.create(GetCustomerResult.class, result);
    }

    @Override
    public GetCustomersByQueryResult getCustomersByQuery(GetCustomersByQueryParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            ArrayList<String> customerNumbers = new ArrayList<String>();
            if (params.getLegalName() != null) {
                LegalEntityQuery legalEntityQuery = (LegalEntityQuery)this.pm.newQuery(LegalEntity.class);
                legalEntityQuery.name().equalTo((Object)params.getLegalName());
                List legalEntities = this.getAccountSegment().getAccount(legalEntityQuery);
                for (Account legalEntity : legalEntities) {
                    String customerNumber = this.datatypeMappers.getAccountFieldMapper().getAccountNumber(legalEntity);
                    if (customerNumber == null) {
                        SysLog.warning((String)"Customer number is null. Skipping customer", (Object)legalEntity.refGetPath());
                        continue;
                    }
                    customerNumbers.add(customerNumber);
                }
            } else if (params.getEmailAddress() != null) {
                EMailAddressQuery addressQuery = (EMailAddressQuery)this.pm.newQuery(EMailAddress.class);
                addressQuery.thereExistsEmailAddress().equalTo((Object)params.getEmailAddress());
                List addresses = this.getAccountSegment().getAddress(addressQuery);
                for (AccountAddress address : addresses) {
                    Account account = (Account)this.pm.getObjectById((Object)address.refGetPath().getParent().getParent());
                    String customerNumber = this.datatypeMappers.getAccountFieldMapper().getAccountNumber(account);
                    if (customerNumber == null) {
                        SysLog.warning((String)"Customer number is null. Skipping customer", (Object)account.refGetPath());
                        continue;
                    }
                    if (customerNumbers.contains(customerNumber)) continue;
                    customerNumbers.add(customerNumber);
                }
            }
            result.add(Datatypes.member((Enum)GetCustomersByQueryResult.Member.customerNumber, customerNumbers));
            result.add(Datatypes.member((Enum)GetCustomersByQueryResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetCustomersByQueryResult.Member.customerNumber, Collections.emptyList()));
            result.add(Datatypes.member((Enum)GetCustomersByQueryResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetCustomersByQueryResult)Structures.create(GetCustomersByQueryResult.class, result);
    }

    @Override
    public GetDocumentsResult getDocuments(GetDocumentsParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String folderName = params.getFolderName();
            if (folderName != null && folderName.length() > 0) {
                DocumentFolderQuery documentFolderQuery = (DocumentFolderQuery)this.pm.newQuery(DocumentFolder.class);
                documentFolderQuery.name().equalTo((Object)folderName);
                List documentFolders = this.getDocumentSegment().getFolder(documentFolderQuery);
                if (!documentFolders.isEmpty()) {
                    DocumentFolder documentFolder = (DocumentFolder)documentFolders.iterator().next();
                    DocumentQuery documentQuery = (DocumentQuery)this.pm.newQuery(Document.class);
                    documentQuery.thereExistsFolder().equalTo(documentFolder);
                    List documents = this.getDocumentSegment().getDocument(documentQuery);
                    ArrayList<DocumentT> documentsT = new ArrayList<DocumentT>();
                    for (Document document : documents) {
                        documentsT.add(this.datatypeMappers.mapDocument(document));
                    }
                    result.add(Datatypes.member((Enum)GetDocumentsResult.Member.document, documentsT));
                    result.add(Datatypes.member((Enum)GetDocumentsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                } else {
                    result.add(Datatypes.member((Enum)GetDocumentsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"DocumentFolder", folderName})));
                }
            } else {
                result.add(Datatypes.member((Enum)GetDocumentsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Folder name is null or empty", folderName})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetDocumentsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetDocumentsResult)Structures.create(GetDocumentsResult.class, result);
    }

    @Override
    public GetInvoiceResult getInvoice(GetInvoiceParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Invoice invoice = this.findInvoice(params.getInvoiceNumber());
            if (invoice != null) {
                result.add(Datatypes.member((Enum)GetInvoiceResult.Member.invoice, (Object)this.datatypeMappers.mapInvoice(invoice)));
                result.add(Datatypes.member((Enum)GetInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)GetInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Invoice", params.getInvoiceNumber()})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetInvoiceResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetInvoiceResult)Structures.create(GetInvoiceResult.class, result);
    }

    @Override
    public GetInvoicePositionsResult getInvoicePositions(GetInvoicePositionsParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Account customer = this.findAccount(params.getCustomerNumber());
            if (customer != null) {
                Collection<ContractPositionT> positions = this.getInvoicePositions(customer, params.getInvoiceStatusThreshold(), true, null);
                result.add(Datatypes.member((Enum)GetInvoicePositionsResult.Member.position, positions));
                result.add(Datatypes.member((Enum)GetInvoicePositionsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)GetInvoicePositionsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Account", params.getCustomerNumber()})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetInvoicePositionsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetInvoicePositionsResult)Structures.create(GetInvoicePositionsResult.class, result);
    }

    @Override
    public GetInvoicesResult getInvoices(GetInvoicesParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Account customer = this.findAccount(params.getCustomerNumber());
            if (customer != null) {
                InvoiceQuery invoiceQuery = (InvoiceQuery)this.pm.newQuery(Invoice.class);
                invoiceQuery.thereExistsCustomer().equalTo(customer);
                String contractCategory = this.getShopCategory();
                if (contractCategory != null) {
                    invoiceQuery.thereExistsCategory().equalTo((Object)contractCategory);
                }
                ArrayList<InvoiceT> invoicesT = new ArrayList<InvoiceT>();
                for (Invoice invoice : this.getContractSegment().getInvoice(invoiceQuery)) {
                    invoicesT.add(this.datatypeMappers.mapInvoice(invoice));
                }
                result.add(Datatypes.member((Enum)GetInvoicesResult.Member.invoice, invoicesT));
                result.add(Datatypes.member((Enum)GetInvoicesResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)GetInvoicesResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Account", params.getCustomerNumber()})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetInvoicesResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetInvoicesResult)Structures.create(GetInvoicesResult.class, result);
    }

    @Override
    public GetPriceLevelResult getPriceLevel(GetPriceLevelParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            AbstractPriceLevelQuery query = (AbstractPriceLevelQuery)this.pm.newQuery(AbstractPriceLevel.class);
            query.name().equalTo((Object)params.getPriceLevel());
            List priceLevels = this.getProductSegment().getPriceLevel(query);
            if (!priceLevels.isEmpty()) {
                AbstractPriceLevel priceLevel = (AbstractPriceLevel)priceLevels.iterator().next();
                result.add(Datatypes.member((Enum)GetPriceLevelResult.Member.priceLevel, (Object)this.datatypeMappers.mapPriceLevel(priceLevel)));
                result.add(Datatypes.member((Enum)GetPriceLevelResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)GetPriceLevelResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"PriceLevel", params.getPriceLevel()})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetPriceLevelResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetPriceLevelResult)Structures.create(GetPriceLevelResult.class, result);
    }

    @Override
    public GetProductsResult getProducts(GetProductsParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            boolean hasErrors = false;
            ArrayList<ProductT> productsT = new ArrayList<ProductT>();
            for (String productNumber : params.getProductNumber()) {
                Product product = this.findProduct(productNumber);
                if (product != null) {
                    productsT.add(this.datatypeMappers.mapProduct(product, params.isReturnPictureContent(), this.getProductSegment()));
                    continue;
                }
                result.add(Datatypes.member((Enum)GetProductsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Product", productNumber})));
                hasErrors = true;
                break;
            }
            if (!hasErrors) {
                result.add(Datatypes.member((Enum)GetProductsResult.Member.product, productsT));
                result.add(Datatypes.member((Enum)GetProductsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetProductsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetProductsResult)Structures.create(GetProductsResult.class, result);
    }

    @Override
    public GetProductsByQueryResult getProductsByQuery(GetProductsByQueryParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            ArrayList<ProductClassification> productClassifications = new ArrayList<ProductClassification>();
            for (String classificationId : params.getClassificationId()) {
                productClassifications.add(this.findProductClassification(classificationId));
            }
            ProductQuery query = (ProductQuery)this.pm.newQuery(Product.class);
            query.thereExistsClassification().elementOf(productClassifications);
            if (params.getProductStatus() != null) {
                query.productState().equalTo((Object)params.getProductStatus());
            }
            ArrayList<String> productNumbers = new ArrayList<String>();
            for (Product product : this.getProductSegment().getProduct(query)) {
                productNumbers.add(product.getProductNumber());
            }
            result.add(Datatypes.member((Enum)GetProductsByQueryResult.Member.productNumber, productNumbers));
            result.add(Datatypes.member((Enum)GetProductsByQueryResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetProductsByQueryResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetProductsByQueryResult)Structures.create(GetProductsByQueryResult.class, result);
    }

    @Override
    public GetProductConfigurationTypesResult getProductConfigurationTypes() {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            ArrayList<ProductConfigurationTypeT> configurationTypesT = new ArrayList<ProductConfigurationTypeT>();
            SegmentContainsConfigurationTypeSet.ConfigurationTypeSet configurationTypeSets = this.getProductSegment().getConfigurationTypeSet();
            Iterator iterator = configurationTypeSets.iterator();
            while (iterator.hasNext()) {
                ProductConfigurationTypeSet configurationTypeSet = (ProductConfigurationTypeSet)iterator.next();
                configurationTypesT.add(this.datatypeMappers.mapProductConfigurationTypeSet(configurationTypeSet));
            }
            result.add(Datatypes.member((Enum)GetProductConfigurationTypesResult.Member.configurationType, configurationTypesT));
            result.add(Datatypes.member((Enum)GetProductConfigurationTypesResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetProductConfigurationTypesResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetProductConfigurationTypesResult)Structures.create(GetProductConfigurationTypesResult.class, result);
    }

    @Override
    public GetProductPricesResult getProductPrices(GetProductPricesParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Object customerNumber = params.getCustomerNumber();
            Lead customerContract = null;
            if (customerNumber == null) {
                customerNumber = this.shopName + "." + params.getPriceCurrency();
                customerContract = this.findCustomerContractByContractNumber((String)customerNumber);
                if (customerContract == null) {
                    customerContract = (Lead)this.pm.newInstance(Lead.class);
                    this.datatypeMappers.getLeadFieldMapper().setContractNumber(customerContract, (String)customerNumber);
                    this.datatypeMappers.getLeadFieldMapper().setContractCurrency(customerContract, params.getPriceCurrency());
                    customerContract.getOwningGroup().addAll(this.getContractSegment().getOwningGroup());
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    this.getContractSegment().addLead(this.uuidAsString(), customerContract);
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                }
            } else {
                customerContract = this.findMainCustomerContract(this.findAccount(params.getCustomerNumber()));
            }
            String salesTaxTypeName = params.getSalesTaxType();
            BigDecimal salesTaxRate = null;
            if (salesTaxTypeName != null) {
                SalesTaxType salesTaxType = this.findSalesTaxType(salesTaxTypeName);
                salesTaxRate = salesTaxType.getRate();
            } else {
                salesTaxRate = BigDecimal.ZERO;
            }
            if (salesTaxRate != null) {
                PricingRuleQuery ruleQuery = (PricingRuleQuery)this.pm.newQuery(PricingRule.class);
                ruleQuery.name().equalTo((Object)this.shopName);
                List rules = this.getProductSegment().getPricingRule(ruleQuery);
                if (!rules.isEmpty()) {
                    PricingRule rule = (PricingRule)rules.iterator().next();
                    boolean hasErrors = false;
                    ArrayList<ProductPriceListT> productPriceListsT = new ArrayList<ProductPriceListT>();
                    for (String productNumber : params.getProductNumber()) {
                        Product product = this.findProduct(productNumber);
                        if (product != null) {
                            ArrayList<ProductPriceT> productPricesT = new ArrayList<ProductPriceT>();
                            List priceUoms = product.getPriceUom();
                            for (Uom priceUom : priceUoms) {
                                for (Date pricingDate : params.getPricingDate()) {
                                    org.opencrx.kernel.product1.jmi1.GetPriceLevelParams getPriceLevelParams = (org.opencrx.kernel.product1.jmi1.GetPriceLevelParams)Structures.create(org.opencrx.kernel.product1.jmi1.GetPriceLevelParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)GetPriceLevelParams.Member.contract, (Object)customerContract), Datatypes.member((Enum)GetPriceLevelParams.Member.priceUom, (Object)priceUom), Datatypes.member((Enum)GetPriceLevelParams.Member.pricingDate, (Object)pricingDate), Datatypes.member((Enum)GetPriceLevelParams.Member.product, (Object)product), Datatypes.member((Enum)GetPriceLevelParams.Member.quantity, (Object)new BigDecimal(params.getQuantity() == null ? "1.0" : params.getQuantity()))});
                                    org.opencrx.kernel.product1.jmi1.GetPriceLevelResult getPriceLevelResult = rule.getPriceLevel(getPriceLevelParams);
                                    if (getPriceLevelResult.getPriceLevel() == null) continue;
                                    AbstractPriceLevel priceLevel = (AbstractPriceLevel)this.pm.getObjectById((Object)getPriceLevelResult.getPriceLevel().refGetPath());
                                    ProductBasePriceQuery priceQuery = (ProductBasePriceQuery)this.pm.newQuery(ProductBasePrice.class);
                                    priceQuery.thereExistsPriceLevel().equalTo(priceLevel);
                                    priceQuery.uom().equalTo(priceUom);
                                    List prices = product.getBasePrice(priceQuery);
                                    if (prices.isEmpty()) continue;
                                    ProductBasePrice price = (ProductBasePrice)prices.iterator().next();
                                    productPricesT.add(this.datatypeMappers.mapProductPrice(price, pricingDate, salesTaxRate));
                                }
                            }
                            productPriceListsT.add((ProductPriceListT)Datatypes.create(ProductPriceListT.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ProductPriceListT.Member.productNumber, (Object)productNumber), Datatypes.member((Enum)ProductPriceListT.Member.salesTaxType, (Object)salesTaxTypeName), Datatypes.member((Enum)ProductPriceListT.Member.productPrice, productPricesT)}));
                            continue;
                        }
                        result.add(Datatypes.member((Enum)GetProductPricesResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Product", productNumber})));
                        hasErrors = true;
                        break;
                    }
                    if (!hasErrors) {
                        result.add(Datatypes.member((Enum)GetProductPricesResult.Member.productPriceList, productPriceListsT));
                        result.add(Datatypes.member((Enum)GetProductPricesResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                    }
                } else {
                    result.add(Datatypes.member((Enum)GetProductPricesResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"PricingRule", this.shopName})));
                }
            } else {
                result.add(Datatypes.member((Enum)GetProductPricesResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"SalesTaxType", params.getSalesTaxType()})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetProductPricesResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetProductPricesResult)Structures.create(GetProductPricesResult.class, result);
    }

    @Override
    public GetSalesOrderResult getSalesOrder(GetSalesOrderParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            SalesOrderQuery query = (SalesOrderQuery)this.pm.newQuery(SalesOrder.class);
            query.thereExistsContractNumber().equalTo((Object)params.getSalesOrderNumber());
            List salesOrders = this.getContractSegment().getSalesOrder(query);
            if (!salesOrders.isEmpty()) {
                SalesOrder salesOrder = (SalesOrder)salesOrders.iterator().next();
                result.add(Datatypes.member((Enum)GetSalesOrderResult.Member.salesOrder, (Object)this.datatypeMappers.mapSalesOrder(salesOrder)));
                result.add(Datatypes.member((Enum)GetSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)GetSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"SalesOrder", params.getSalesOrderNumber()})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetSalesOrderResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetSalesOrderResult)Structures.create(GetSalesOrderResult.class, result);
    }

    @Override
    public GetSalesOrdersResult getSalesOrders(GetSalesOrdersParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Account customer = this.findAccount(params.getCustomerNumber());
            if (customer != null) {
                SalesOrderQuery salesOrderQuery = (SalesOrderQuery)this.pm.newQuery(SalesOrder.class);
                salesOrderQuery.thereExistsCustomer().equalTo(customer);
                String contractCategory = this.getShopCategory();
                if (contractCategory != null) {
                    salesOrderQuery.thereExistsCategory().equalTo((Object)contractCategory);
                }
                ArrayList<SalesOrderT> salesOrdersT = new ArrayList<SalesOrderT>();
                for (SalesOrder salesOrder : this.getContractSegment().getSalesOrder(salesOrderQuery)) {
                    salesOrdersT.add(this.datatypeMappers.mapSalesOrder(salesOrder));
                }
                result.add(Datatypes.member((Enum)GetSalesOrdersResult.Member.salesOrder, salesOrdersT));
                result.add(Datatypes.member((Enum)GetSalesOrdersResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)GetSalesOrdersResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Account", params.getCustomerNumber()})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetSalesOrdersResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetSalesOrdersResult)Structures.create(GetSalesOrdersResult.class, result);
    }

    @Override
    public GetSalesOrderPositionsResult getSalesOrderPositions(GetSalesOrderPositionsParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Account customer = this.findAccount(params.getCustomerNumber());
            if (customer != null) {
                Collection<ContractPositionT> positions = this.getSalesOrderPositions(customer, params.getSalesOrderStatusThreshold());
                result.add(Datatypes.member((Enum)GetSalesOrderPositionsResult.Member.position, positions));
                result.add(Datatypes.member((Enum)GetSalesOrderPositionsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)GetSalesOrderPositionsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Account", params.getCustomerNumber()})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)GetSalesOrderPositionsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (GetSalesOrderPositionsResult)Structures.create(GetSalesOrderPositionsResult.class, result);
    }

    @Override
    public SendEMailResult sendEMail(SendEMailParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String activityCreatorName = params.getEmailCreatorName();
            if (activityCreatorName != null && activityCreatorName.length() > 0) {
                org.opencrx.kernel.activity1.jmi1.Segment activitySegment = this.getActivitySegment();
                ActivityCreator activityCreator = Activities.getInstance().findActivityCreator(activityCreatorName, activitySegment);
                if (activityCreator != null) {
                    Account reportingCustomer = null;
                    if (params.getOnBehalfOfCustomerNumber() != null) {
                        reportingCustomer = this.findAccount(params.getOnBehalfOfCustomerNumber());
                    }
                    NewActivityParams newActivityParams = (NewActivityParams)Structures.create(NewActivityParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)NewActivityParams.Member.creationContext, null), Datatypes.member((Enum)NewActivityParams.Member.description, (Object)params.getSubject()), Datatypes.member((Enum)NewActivityParams.Member.detailedDescription, null), Datatypes.member((Enum)NewActivityParams.Member.dueBy, null), Datatypes.member((Enum)NewActivityParams.Member.icalType, (Object)0), Datatypes.member((Enum)NewActivityParams.Member.name, (Object)params.getSubject()), Datatypes.member((Enum)NewActivityParams.Member.priority, (Object)Activities.Priority.NORMAL.getValue()), Datatypes.member((Enum)NewActivityParams.Member.reportingContact, (Object)(reportingCustomer instanceof Contact ? (Contact)reportingCustomer : null)), Datatypes.member((Enum)NewActivityParams.Member.scheduledStart, null), Datatypes.member((Enum)NewActivityParams.Member.scheduledEnd, null)});
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    NewActivityResult newActivityResult = activityCreator.newActivity(newActivityParams);
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    Activity activity = newActivityResult.getActivity();
                    this.pm.refresh((Object)activity);
                    if (activity instanceof EMail) {
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                        EMail email = (EMail)activity;
                        email.setMessageSubject(params.getSubject());
                        email.setMessageBody(params.getBody());
                        Activities.getInstance().addEMailRecipients(email, params.getSender(), params.getRecipientTo(), params.getRecipientCc(), params.getRecipientBcc());
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                        Activities.getInstance().sendEMail(email);
                        result.add(Datatypes.member((Enum)SendEMailResult.Member.activity, (Object)this.datatypeMappers.mapActivity(activity)));
                        result.add(Datatypes.member((Enum)SendEMailResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                    } else {
                        result.add(Datatypes.member((Enum)SendEMailResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-2, new String[]{"Activity is not of type EMail", activity.getClass().getName()})));
                    }
                } else {
                    result.add(Datatypes.member((Enum)SendEMailResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"ActivityCreator", activityCreatorName})));
                }
            } else {
                result.add(Datatypes.member((Enum)SendEMailResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-2, new String[]{"ActivityCreator is null or empty", activityCreatorName})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)SendEMailResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (SendEMailResult)Structures.create(SendEMailResult.class, result);
    }

    @Override
    public SetCredentialsResult setCredentials(SetCredentialsParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Account customer = this.findAccount(params.getCustomerNumber());
            if (customer != null) {
                boolean duplicateUserName = false;
                String customerUserName = this.datatypeMappers.getAccountFieldMapper().getUserName(customer);
                if (customerUserName != null && !customerUserName.equals(params.getCredentials().getUserName())) {
                    AccountQuery accountQuery = (AccountQuery)this.pm.newQuery(Account.class);
                    accountQuery.thereExistsUserString0().equalTo((Object)params.getCredentials().getUserName());
                    List accounts = this.getAccountSegment().getAccount(accountQuery);
                    boolean bl = duplicateUserName = !accounts.isEmpty();
                }
                if (!duplicateUserName) {
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    this.datatypeMappers.getAccountFieldMapper().setUserName(customer, params.getCredentials().getUserName());
                    this.datatypeMappers.getAccountFieldMapper().setPasswordMd5(customer, params.getCredentials().getPasswordMd5());
                    this.datatypeMappers.getAccountFieldMapper().setResetPasswordChallenge(customer, params.getCredentials().getResetPasswordChallenge());
                    this.datatypeMappers.getAccountFieldMapper().setResetPasswordResponse(customer, params.getCredentials().getResetPasswordResponse());
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    result.add(Datatypes.member((Enum)SetCredentialsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                } else {
                    result.add(Datatypes.member((Enum)SetCredentialsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-26, new String[]{"Account", params.getCredentials().getUserName()})));
                }
            } else {
                result.add(Datatypes.member((Enum)SetCredentialsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Account", params.getCustomerNumber()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)SetCredentialsResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (SetCredentialsResult)Structures.create(SetCredentialsResult.class, result);
    }

    @Override
    public SetCustomerContractStatusResult setCustomerContractStatus(SetCustomerContractStatusParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String customerContractNumber = params.getCustomerContractNumber();
            if (customerContractNumber != null) {
                Lead customerContract = this.findCustomerContractByContractNumber(customerContractNumber);
                if (customerContract != null) {
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    this.setContractStatus(customerContract, params.getContractStatus());
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    result.add(Datatypes.member((Enum)SetCustomerContractStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                } else {
                    result.add(Datatypes.member((Enum)SetCustomerContractStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"CustomerContract", customerContractNumber})));
                }
            } else {
                result.add(Datatypes.member((Enum)SetCustomerContractStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"CustomerContract", customerContractNumber})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)SetCustomerContractStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (SetCustomerContractStatusResult)Structures.create(SetCustomerContractStatusResult.class, result);
    }

    @Override
    public SetCustomerStatusResult setCustomerStatus(SetCustomerStatusParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Account customer = this.findAccount(params.getCustomerNumber());
            if (customer != null) {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                String shortDescription = customer.getDescription();
                shortDescription = shortDescription == null ? "" : shortDescription.substring(0, Math.min(shortDescription.length(), 50));
                this.datatypeMappers.getAccountFieldMapper().getStateHistory(customer).add(customer.getAccountState() + "@" + DateTimeFormat.BASIC_UTC_FORMAT.format(customer.getModifiedAt()) + " // " + shortDescription);
                customer.setAccountState(DatatypeMappers.toShort(params.getCustomerStatus().getStatus()));
                customer.setDescription(params.getCustomerStatus().getDescription());
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                result.add(Datatypes.member((Enum)SetCustomerStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)SetCustomerStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Account", params.getCustomerNumber()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)SetCustomerStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (SetCustomerStatusResult)Structures.create(SetCustomerStatusResult.class, result);
    }

    @Override
    public SetInvoiceStatusResult setInvoiceStatus(SetInvoiceStatusParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Invoice invoice = this.findInvoice(params.getInvoiceNumber());
            if (invoice != null) {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                this.setContractStatus(invoice, params.getInvoiceStatus());
                if (params.getInvoiceStatus().getStatus().intValue() == InvoiceState.PAID.getValue()) {
                    this.datatypeMappers.getInvoiceFieldMapper().setPaymentDate(invoice, new Date());
                }
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                result.add(Datatypes.member((Enum)SetInvoiceStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)SetInvoiceStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Invoice", params.getInvoiceNumber()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)SetInvoiceStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (SetInvoiceStatusResult)Structures.create(SetInvoiceStatusResult.class, result);
    }

    @Override
    public SetProductStatusResult setProductStatus(SetProductStatusParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            Product product = this.findProduct(params.getProductNumber());
            if (product != null) {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                String shortDescription = product.getDescription();
                shortDescription = shortDescription == null ? "" : shortDescription.substring(0, Math.min(shortDescription.length(), 50));
                this.datatypeMappers.getProductFieldMapper().getStateHistory(product).add(product.getProductState() + "@" + DateTimeFormat.BASIC_UTC_FORMAT.format(product.getModifiedAt()) + " // " + shortDescription);
                product.setProductState((short)params.getProductStatus().getStatus());
                product.setDescription(params.getProductStatus().getDescription());
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                result.add(Datatypes.member((Enum)SetProductStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)SetProductStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Product", params.getProductNumber()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)SetProductStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (SetProductStatusResult)Structures.create(SetProductStatusResult.class, result);
    }

    @Override
    public SetSalesOrderPositionQuantityResult setSalesOrderPositionQuantity(SetSalesOrderPositionQuantityParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String contractNumber = params.getContractNumber();
            SalesOrder salesOrder = this.findSalesOrder(contractNumber);
            if (salesOrder != null) {
                SalesOrderContainsSalesOrderPosition.Position positions = salesOrder.getPosition();
                Iterator iterator = positions.iterator();
                while (iterator.hasNext()) {
                    SalesOrderPosition position = (SalesOrderPosition)iterator.next();
                    if (!params.getPositionNumber().equals(position.getPositionNumber())) continue;
                    BigDecimal quantity = new BigDecimal(params.getQuantity());
                    if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                        position.refDelete();
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    } else {
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                        position.setQuantity(quantity);
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    }
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    salesOrder.reprice();
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                }
                result.add(Datatypes.member((Enum)SetSalesOrderPositionQuantityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)SetSalesOrderPositionQuantityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"SalesOrder", contractNumber})));
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)SetSalesOrderPositionQuantityResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (SetSalesOrderPositionQuantityResult)Structures.create(SetSalesOrderPositionQuantityResult.class, result);
    }

    @Override
    public SetSalesOrderStatusResult setSalesOrderStatus(SetSalesOrderStatusParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            SalesOrder salesOrder = this.findSalesOrder(params.getSalesOrderNumber());
            if (salesOrder != null) {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                this.setContractStatus(salesOrder, params.getSalesOrderStatus());
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                result.add(Datatypes.member((Enum)SetSalesOrderStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
            } else {
                result.add(Datatypes.member((Enum)SetSalesOrderStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"SalesOrder", params.getSalesOrderNumber()})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)SetSalesOrderStatusResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (SetSalesOrderStatusResult)Structures.create(SetSalesOrderStatusResult.class, result);
    }

    @Override
    public UpdateCustomerResult updateCustomer(UpdateCustomerParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String customerNumber = params.getCustomer().getCustomerNumber();
            Account customer = this.findAccount(customerNumber);
            CustomerT customerT = params.getCustomer();
            if (customer != null && customerT != null) {
                if (customerT.getLegalEntity() != null) {
                    LegalEntity legalEntity = (LegalEntity)customer;
                    LegalEntityT legalEntityT = customerT.getLegalEntity();
                    boolean isDuplicateEmailAddressBusiness = false;
                    if (this.emailAddressMustBeUnique && Boolean.TRUE.equals(params.isUpdateAddressData()) && legalEntityT.getEmailAddressBusiness() != null) {
                        EMailAddressQuery addressQuery = (EMailAddressQuery)this.pm.newQuery(EMailAddress.class);
                        addressQuery.thereExistsEmailAddress().equalTo((Object)legalEntityT.getEmailAddressBusiness().getEmailAddress());
                        List addresses = this.getAccountSegment().getAddress(addressQuery);
                        for (AccountAddress address : addresses) {
                            if (address.refGetPath().startsWith(legalEntity.refGetPath())) continue;
                            isDuplicateEmailAddressBusiness = true;
                            break;
                        }
                    }
                    if (!this.emailAddressMustBeUnique || !isDuplicateEmailAddressBusiness) {
                        String primaryContactNumber = legalEntityT.getPrimaryContactNumber();
                        Account primaryContact = null;
                        if (primaryContactNumber != null) {
                            primaryContact = this.findAccount(primaryContactNumber);
                        }
                        if (primaryContact != null || primaryContactNumber == null) {
                            PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                            if (params.isUpdateMainData().booleanValue()) {
                                customer.getExternalLink().clear();
                                customer.getExternalLink().addAll(customerT.getExternalId());
                                if (customerT.getAccountRating() != null) {
                                    customer.setAccountRating(DatatypeMappers.toShort(customerT.getAccountRating()));
                                }
                                customer.getAccountCategory().clear();
                                customer.getAccountCategory().addAll(DatatypeMappers.toShortList(customerT.getAccountCategory()));
                                legalEntity.setName(legalEntityT.getLegalName());
                                if (primaryContact != null) {
                                    Member member;
                                    MemberQuery memberQuery = (MemberQuery)this.pm.newQuery(Member.class);
                                    if (this.getShopCategory() != null) {
                                        memberQuery.thereExistsCategory().equalTo((Object)this.getShopCategory());
                                    }
                                    memberQuery.thereExistsMemberRole().equalTo((Object)11);
                                    List members = customer.getMember(memberQuery);
                                    if (members.isEmpty()) {
                                        member = (Member)this.pm.newInstance(Member.class);
                                        member.setName(primaryContact.getFullName());
                                        member.setAccount(primaryContact);
                                        member.getMemberRole().add((short)11);
                                        if (this.getShopCategory() != null) {
                                            member.getCategory().add(this.getShopCategory());
                                        }
                                        customer.addMember(this.uuidAsString(), member);
                                    } else {
                                        member = (Member)members.iterator().next();
                                        member.setAccount(primaryContact);
                                    }
                                }
                            }
                            if (Boolean.TRUE.equals(params.isUpdateAddressData())) {
                                AccountAddress address;
                                AccountAddress[] addresses = Accounts.getInstance().getMainAddresses(legalEntity);
                                if (legalEntityT.getPostalAddressBusiness() == null) {
                                    if (addresses[6] != null) {
                                        addresses[6].refDelete();
                                    }
                                } else {
                                    address = (PostalAddress)addresses[6];
                                    if (address == null) {
                                        address = (PostalAddress)this.pm.newInstance(PostalAddress.class);
                                        address.getUsage().add(Addresses.USAGE_BUSINESS);
                                        address.getOwningGroup().addAll(legalEntity.getOwningGroup());
                                        legalEntity.addAddress(false, this.uuidAsString(), address);
                                    }
                                    this.datatypeMappers.mapPostalAddress(legalEntityT.getPostalAddressBusiness(), (PostalAddressable)((Object)address));
                                }
                                if (legalEntityT.getEmailAddressBusiness() == null) {
                                    if (addresses[0] != null) {
                                        addresses[0].refDelete();
                                    }
                                } else {
                                    address = (EMailAddress)addresses[0];
                                    if (address == null) {
                                        address = (EMailAddress)this.pm.newInstance(EMailAddress.class);
                                        address.getUsage().add(Addresses.USAGE_BUSINESS);
                                        address.getOwningGroup().addAll(legalEntity.getOwningGroup());
                                        legalEntity.addAddress(this.uuidAsString(), address);
                                    }
                                    this.datatypeMappers.mapEmailAddress(legalEntityT.getEmailAddressBusiness(), (EMailAddress)address);
                                }
                                if (legalEntityT.getFaxNumberBusiness() == null) {
                                    if (addresses[4] != null) {
                                        addresses[4].refDelete();
                                    }
                                } else {
                                    address = (PhoneNumber)addresses[4];
                                    if (address == null) {
                                        address = (PhoneNumber)this.pm.newInstance(PhoneNumber.class);
                                        address.getUsage().add(Addresses.USAGE_BUSINESS_FAX);
                                        address.getOwningGroup().addAll(legalEntity.getOwningGroup());
                                        legalEntity.addAddress(this.uuidAsString(), address);
                                    }
                                    this.datatypeMappers.mapPhoneNumber(legalEntityT.getFaxNumberBusiness(), (PhoneNumber)address);
                                }
                                if (legalEntityT.getPhoneNumberBusiness() == null) {
                                    if (addresses[2] != null) {
                                        addresses[2].refDelete();
                                    }
                                } else {
                                    address = (PhoneNumber)addresses[2];
                                    if (address == null) {
                                        address = (PhoneNumber)this.pm.newInstance(PhoneNumber.class);
                                        address.getUsage().add(Addresses.USAGE_BUSINESS);
                                        address.getOwningGroup().addAll(legalEntity.getOwningGroup());
                                        legalEntity.addAddress(this.uuidAsString(), address);
                                    }
                                    this.datatypeMappers.mapPhoneNumber(legalEntityT.getPhoneNumberBusiness(), (PhoneNumber)address);
                                }
                                if (legalEntityT.getWebAddressBusiness() == null) {
                                    if (addresses[7] != null) {
                                        addresses[7].refDelete();
                                    }
                                } else {
                                    address = (WebAddress)addresses[7];
                                    if (address == null) {
                                        address = (WebAddress)this.pm.newInstance(WebAddress.class);
                                        address.getUsage().add(Addresses.USAGE_BUSINESS);
                                        address.getOwningGroup().addAll(legalEntity.getOwningGroup());
                                        legalEntity.addAddress(this.uuidAsString(), address);
                                    }
                                    this.datatypeMappers.mapWebAddress(legalEntityT.getWebAddressBusiness(), (WebAddress)address);
                                }
                            }
                            if (Boolean.TRUE.equals(params.isUpdateGenericData())) {
                                CrxObjectContainsPropertySet.PropertySet propertySets = legalEntity.getPropertySet();
                                List<StringPropertyT> genericData = params.getCustomer().getGenericData();
                                if (genericData != null) {
                                    boolean isNew = true;
                                    Iterator iterator = propertySets.iterator();
                                    while (iterator.hasNext()) {
                                        PropertySet propertySet = (PropertySet)iterator.next();
                                        if (!propertySet.getName().equals(PropertySetName.GenericData.toString())) continue;
                                        this.updatePropertySet(genericData, propertySet, true);
                                        isNew = false;
                                        break;
                                    }
                                    if (isNew) {
                                        PropertySet propertySet = (PropertySet)this.pm.newInstance(PropertySet.class);
                                        propertySet.setName(PropertySetName.GenericData.toString());
                                        propertySet.getOwningGroup().addAll(legalEntity.getOwningGroup());
                                        legalEntity.addPropertySet(this.uuidAsString(), propertySet);
                                        this.updatePropertySet(genericData, propertySet, true);
                                    }
                                }
                            }
                            PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                            result.add(Datatypes.member((Enum)UpdateCustomerResult.Member.customer, (Object)this.datatypeMappers.mapCustomer(customer, this.findCustomerContracts(customer), this.getShopCategory())));
                            result.add(Datatypes.member((Enum)UpdateCustomerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                        } else {
                            result.add(Datatypes.member((Enum)UpdateCustomerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"PrimaryContact", primaryContactNumber})));
                        }
                    } else {
                        ArrayList<String> addresses = new ArrayList<String>();
                        if (legalEntityT.getEmailAddressBusiness() != null) {
                            addresses.add(legalEntityT.getEmailAddressBusiness().getEmailAddress());
                        }
                        result.add(Datatypes.member((Enum)UpdateCustomerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-26, new String[]{"EmailAddress", ((Object)addresses).toString()})));
                    }
                } else if (customerT.getContact() != null) {
                    AccountAddress[] addresses;
                    Contact contact = (Contact)customer;
                    ContactT contactT = customerT.getContact();
                    boolean isDuplicateEmailAddressHome = false;
                    boolean isDuplicateEmailAddressBusiness = false;
                    if (this.emailAddressMustBeUnique && Boolean.TRUE.equals(params.isUpdateAddressData())) {
                        List addresses2;
                        EMailAddressQuery addressQuery;
                        if (contactT.getEmailAddressHome() != null) {
                            addressQuery = (EMailAddressQuery)this.pm.newQuery(EMailAddress.class);
                            addressQuery.thereExistsEmailAddress().equalTo((Object)contactT.getEmailAddressHome().getEmailAddress());
                            addresses2 = this.getAccountSegment().getAddress(addressQuery);
                            for (Object address2 : addresses2) {
                                if (address2.refGetPath().startsWith(contact.refGetPath())) continue;
                                isDuplicateEmailAddressHome = true;
                                break;
                            }
                        }
                        if (contactT.getEmailAddressBusiness() != null) {
                            addressQuery = (EMailAddressQuery)this.pm.newQuery(EMailAddress.class);
                            addressQuery.thereExistsEmailAddress().equalTo((Object)contactT.getEmailAddressBusiness().getEmailAddress());
                            addresses2 = this.getAccountSegment().getAddress(addressQuery);
                            for (Object address2 : addresses2) {
                                if (address2.refGetPath().startsWith(contact.refGetPath())) continue;
                                isDuplicateEmailAddressBusiness = true;
                                break;
                            }
                        }
                    }
                    if (!this.emailAddressMustBeUnique || !isDuplicateEmailAddressHome && !isDuplicateEmailAddressBusiness) {
                        List<StringPropertyT> bookmarks;
                        CustomerHobbyAndInterestT hobbyAndInterestT;
                        PropertySet propertySet;
                        PropertySetQuery propertySetQuery;
                        List<StringPropertyT> genericData;
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                        if (Boolean.TRUE.equals(params.isUpdateMainData())) {
                            customer.getExternalLink().clear();
                            customer.getExternalLink().addAll(customerT.getExternalId());
                            if (customerT.getAccountRating() != null) {
                                customer.setAccountRating(DatatypeMappers.toShort(customerT.getAccountRating()));
                            }
                            customer.getAccountCategory().clear();
                            if (customerT.getAccountCategory() != null) {
                                customer.getAccountCategory().addAll(DatatypeMappers.toShortList(customerT.getAccountCategory()));
                            }
                            contact.setOrganization(contactT.getOrganization());
                            contact.setSalutationCode(DatatypeMappers.toShort(contactT.getSalutationCode()));
                            contact.setSalutation(contactT.getSalutation());
                            this.datatypeMappers.getAccountFieldMapper().setTitle(contact, contactT.getTitle());
                            contact.setFirstName(contactT.getFirstName());
                            contact.setLastName(contactT.getLastName());
                            contact.setMiddleName(contactT.getMiddleName());
                            contact.setNickName(contactT.getNickName());
                            contact.setBirthdate(contactT.getBirthDate());
                            this.datatypeMappers.getAccountFieldMapper().setPlaceOfBirth(contact, contactT.getPlaceOfBirth());
                            this.datatypeMappers.getAccountFieldMapper().setBirthDateIsValidated(contact, contactT.getBirthDateIsValidated());
                            contact.setDoNotPostalMail(contactT.isDoNotPostalMail());
                            contact.setDoNotEMail(contactT.isDoNotEmail());
                            contact.setDoNotPhone(contactT.isDoNotPhone());
                            contact.setDoNotFax(contactT.isDoNotFax());
                            this.datatypeMappers.getAccountFieldMapper().setNativeLanguage(contact, contactT.getNativeLanguage());
                            if (contactT.getPreferredSpokenLanguage() != null) {
                                contact.setPreferredSpokenLanguage(DatatypeMappers.toShort(contactT.getPreferredSpokenLanguage()));
                            }
                            if (contactT.getPreferredWrittenLanguage() != null) {
                                contact.setPreferredWrittenLanguage(DatatypeMappers.toShort(contactT.getPreferredWrittenLanguage()));
                            }
                            contact.setGender(DatatypeMappers.toShort(contactT.getGender()));
                            this.datatypeMappers.getAccountFieldMapper().setJobRole(contact, contactT.getJobRole());
                            contact.setJobTitle(contactT.getJobTitle());
                            contact.getCitizenship().clear();
                            contact.getCitizenship().addAll(DatatypeMappers.toShortList(contactT.getCitizenship()));
                            if (contactT.getEducation() != null) {
                                contact.setEducation(DatatypeMappers.toShort(contactT.getEducation()));
                            }
                            this.datatypeMappers.getAccountFieldMapper().setAnnualIncomeAmount(contact, contactT.getAnnualIncomeAmount());
                            this.datatypeMappers.getAccountFieldMapper().setAnnualIncomeCurrency(contact, contactT.getAnnualIncomeCurrency());
                            this.datatypeMappers.getAccountFieldMapper().setMonthlyIncomeAmount(contact, contactT.getMonthlyIncomeAmount());
                            this.datatypeMappers.getAccountFieldMapper().setMonthlyIncomeCurrency(contact, contactT.getMonthlyIncomeCurrency());
                            if (contactT.getAnnualIncomeCurrency() != null) {
                                contact.setAnnualIncomeCurrency(DatatypeMappers.toShort(contactT.getAnnualIncomeCurrency()));
                            }
                            if (contactT.getNumberOfChildren() != null) {
                                contact.setNumberOfChildren(DatatypeMappers.toShort(contactT.getNumberOfChildren()));
                            }
                            contact.getChildrenNames().clear();
                            contact.getChildrenNames().addAll(contactT.getChildrenNames());
                            contact.setFamilyStatus(DatatypeMappers.toShort(contactT.getFamilyStatus()));
                            if (contactT.getPreferredContactMethod() != null) {
                                contact.setPreferredContactMethod(DatatypeMappers.toShort(contactT.getPreferredContactMethod()));
                            }
                            contact.getReligion().clear();
                            contact.getReligion().addAll(DatatypeMappers.toShortList(contactT.getReligion()));
                            this.datatypeMappers.getAccountFieldMapper().setCommunityStatus(contact, contactT.getCommunityStatus());
                            this.datatypeMappers.getAccountFieldMapper().setCommerceStatus(contact, contactT.getCommerceStatus());
                            this.datatypeMappers.getAccountFieldMapper().setPersonsInHousehold(contact, contactT.getPersonsInHousehold());
                            this.datatypeMappers.getAccountFieldMapper().setProfessionalSkills(contact, contactT.getProfessionalSkills());
                            this.datatypeMappers.getAccountFieldMapper().setInternetUsage(contact, contactT.getInternetUsage());
                            this.datatypeMappers.getAccountFieldMapper().setInternetProvider(contact, contactT.getInternetProvider());
                            this.datatypeMappers.getAccountFieldMapper().setPcUsage(contact, contactT.getPcUsage());
                            this.datatypeMappers.getAccountFieldMapper().setPortalRating(contact, contactT.getPortalRating());
                        }
                        if (Boolean.TRUE.equals(params.isUpdateAddressData())) {
                            AccountAddress address;
                            addresses = Accounts.getInstance().getMainAddresses(contact);
                            if (contactT.getPostalAddressHome() == null) {
                                if (addresses[8] != null) {
                                    addresses[8].refDelete();
                                }
                            } else {
                                address = (PostalAddress)addresses[8];
                                if (address == null) {
                                    address = (PostalAddress)this.pm.newInstance(PostalAddress.class);
                                    address.getUsage().add(Addresses.USAGE_HOME);
                                    address.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), address);
                                }
                                this.datatypeMappers.mapPostalAddress(contactT.getPostalAddressHome(), (PostalAddressable)((Object)address));
                            }
                            if (contactT.getPostalAddressBusiness() == null) {
                                if (addresses[6] != null) {
                                    addresses[6].refDelete();
                                }
                            } else {
                                address = (PostalAddress)addresses[6];
                                if (address == null) {
                                    address = (PostalAddress)this.pm.newInstance(PostalAddress.class);
                                    address.getUsage().add(Addresses.USAGE_BUSINESS);
                                    address.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), address);
                                }
                                this.datatypeMappers.mapPostalAddress(contactT.getPostalAddressBusiness(), (PostalAddressable)((Object)address));
                            }
                            if (contactT.getEmailAddressHome() == null) {
                                if (addresses[1] != null) {
                                    addresses[1].refDelete();
                                }
                            } else {
                                address = (EMailAddress)addresses[1];
                                if (address == null) {
                                    address = (EMailAddress)this.pm.newInstance(EMailAddress.class);
                                    address.getUsage().add(Addresses.USAGE_HOME);
                                    address.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), address);
                                }
                                this.datatypeMappers.mapEmailAddress(contactT.getEmailAddressHome(), (EMailAddress)address);
                            }
                            if (contactT.getEmailAddressBusiness() == null) {
                                if (addresses[0] != null) {
                                    addresses[0].refDelete();
                                }
                            } else {
                                address = (EMailAddress)addresses[0];
                                if (address == null) {
                                    address = (EMailAddress)this.pm.newInstance(EMailAddress.class);
                                    address.getUsage().add(Addresses.USAGE_BUSINESS);
                                    address.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), address);
                                }
                                this.datatypeMappers.mapEmailAddress(contactT.getEmailAddressBusiness(), (EMailAddress)address);
                            }
                            if (contactT.getFaxNumberHome() == null) {
                                if (addresses[5] != null) {
                                    addresses[5].refDelete();
                                }
                            } else {
                                address = (PhoneNumber)addresses[5];
                                if (address == null) {
                                    address = (PhoneNumber)this.pm.newInstance(PhoneNumber.class);
                                    address.getUsage().add(Addresses.USAGE_HOME_FAX);
                                    address.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), address);
                                }
                                this.datatypeMappers.mapPhoneNumber(contactT.getFaxNumberHome(), (PhoneNumber)address);
                            }
                            if (contactT.getFaxNumberBusiness() == null) {
                                if (addresses[4] != null) {
                                    addresses[4].refDelete();
                                }
                            } else {
                                address = (PhoneNumber)addresses[4];
                                if (address == null) {
                                    address = (PhoneNumber)this.pm.newInstance(PhoneNumber.class);
                                    address.getUsage().add(Addresses.USAGE_BUSINESS_FAX);
                                    address.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), address);
                                }
                                this.datatypeMappers.mapPhoneNumber(contactT.getFaxNumberBusiness(), (PhoneNumber)address);
                            }
                            if (contactT.getPhoneNumberHome() == null) {
                                if (addresses[3] != null) {
                                    addresses[3].refDelete();
                                }
                            } else {
                                address = (PhoneNumber)addresses[3];
                                if (address == null) {
                                    address = (PhoneNumber)this.pm.newInstance(PhoneNumber.class);
                                    address.getUsage().add(Addresses.USAGE_HOME);
                                    address.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), address);
                                }
                                this.datatypeMappers.mapPhoneNumber(contactT.getPhoneNumberHome(), (PhoneNumber)address);
                            }
                            if (contactT.getPhoneNumberBusiness() == null) {
                                if (addresses[2] != null) {
                                    addresses[2].refDelete();
                                }
                            } else {
                                address = (PhoneNumber)addresses[2];
                                if (address == null) {
                                    address = (PhoneNumber)this.pm.newInstance(PhoneNumber.class);
                                    address.getUsage().add(Addresses.USAGE_BUSINESS);
                                    address.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), address);
                                }
                                this.datatypeMappers.mapPhoneNumber(contactT.getPhoneNumberBusiness(), (PhoneNumber)address);
                            }
                            if (contactT.getPhoneNumberMobile() == null) {
                                if (addresses[10] != null) {
                                    addresses[10].refDelete();
                                }
                            } else {
                                address = (PhoneNumber)addresses[10];
                                if (address == null) {
                                    address = (PhoneNumber)this.pm.newInstance(PhoneNumber.class);
                                    address.getUsage().add(Addresses.USAGE_MOBILE);
                                    address.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), address);
                                }
                                this.datatypeMappers.mapPhoneNumber(contactT.getPhoneNumberMobile(), (PhoneNumber)address);
                            }
                            if (contactT.getWebAddressHome() == null) {
                                if (addresses[9] != null) {
                                    addresses[9].refDelete();
                                }
                            } else {
                                address = (WebAddress)addresses[9];
                                if (address == null) {
                                    address = (WebAddress)this.pm.newInstance(WebAddress.class);
                                    address.getUsage().add(Addresses.USAGE_HOME);
                                    address.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), address);
                                }
                                this.datatypeMappers.mapWebAddress(contactT.getWebAddressHome(), (WebAddress)address);
                            }
                            if (contactT.getWebAddressBusiness() == null) {
                                if (addresses[7] != null) {
                                    addresses[7].refDelete();
                                }
                            } else {
                                address = (WebAddress)addresses[7];
                                if (address == null) {
                                    address = (WebAddress)this.pm.newInstance(WebAddress.class);
                                    address.getUsage().add(Addresses.USAGE_BUSINESS);
                                    address.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), address);
                                }
                                this.datatypeMappers.mapWebAddress(contactT.getWebAddressBusiness(), (WebAddress)address);
                            }
                            if (contactT.getMessengerAddress() != null) {
                                Object address2;
                                AccountHasAccountAddress.Address accountAddresses = contact.getAddress();
                                int i = 0;
                                address2 = accountAddresses.iterator();
                                while (address2.hasNext()) {
                                    AccountAddress address3 = (AccountAddress)address2.next();
                                    if (!(address3 instanceof PhoneNumber)) continue;
                                    boolean containsUsageOther = false;
                                    for (Short usage : address3.getUsage()) {
                                        if (usage.compareTo(Addresses.USAGE_OTHER) != 0) continue;
                                        containsUsageOther = true;
                                        break;
                                    }
                                    if (!containsUsageOther) continue;
                                    if (i >= contactT.getMessengerAddress().size()) {
                                        address3.refDelete();
                                    } else {
                                        this.datatypeMappers.mapMessengerAddress((MessengerAddressT)contactT.getMessengerAddress().get(i), (PhoneNumber)address3);
                                    }
                                    ++i;
                                }
                                while (i < contactT.getMessengerAddress().size()) {
                                    address2 = (PhoneNumber)this.pm.newInstance(PhoneNumber.class);
                                    address2.getUsage().add(Addresses.USAGE_OTHER);
                                    address2.getOwningGroup().addAll(contact.getOwningGroup());
                                    contact.addAddress(this.uuidAsString(), (AccountAddress)address2);
                                    this.datatypeMappers.mapMessengerAddress((MessengerAddressT)contactT.getMessengerAddress().get(i), (PhoneNumber)address2);
                                    ++i;
                                }
                            }
                            this.datatypeMappers.getAccountFieldMapper().setBlogAddress(contact, contactT.getBlogAddress());
                        }
                        if (Boolean.TRUE.equals(params.isUpdateGenericData()) && (genericData = params.getCustomer().getGenericData()) != null) {
                            propertySetQuery = (PropertySetQuery)this.pm.newQuery(PropertySet.class);
                            propertySetQuery.name().equalTo((Object)PropertySetName.GenericData.toString());
                            List propertySets = contact.getPropertySet(propertySetQuery);
                            propertySet = null;
                            if (propertySets.isEmpty()) {
                                propertySet = (PropertySet)this.pm.newInstance(PropertySet.class);
                                propertySet.setName(PropertySetName.GenericData.toString());
                                propertySet.getOwningGroup().addAll(customer.getOwningGroup());
                                contact.addPropertySet(this.uuidAsString(), propertySet);
                            } else {
                                propertySet = (PropertySet)propertySets.iterator().next();
                            }
                            this.updatePropertySet(genericData, propertySet, true);
                        }
                        if (Boolean.TRUE.equals(params.isUpdateHobbyAndInterestData()) && (hobbyAndInterestT = contactT.getHobbyAndInterest()) != null) {
                            this.datatypeMappers.getAccountFieldMapper().setSports(contact, hobbyAndInterestT.getSports());
                            this.datatypeMappers.getAccountFieldMapper().setTravel(contact, hobbyAndInterestT.getTravel());
                            this.datatypeMappers.getAccountFieldMapper().setFinance(contact, hobbyAndInterestT.getFinance());
                            this.datatypeMappers.getAccountFieldMapper().setComputerInternet(contact, hobbyAndInterestT.getComputerInternet());
                            this.datatypeMappers.getAccountFieldMapper().setTelecommunication(contact, hobbyAndInterestT.getTelecommunication());
                            this.datatypeMappers.getAccountFieldMapper().setEntertainment(contact, hobbyAndInterestT.getEntertainment());
                            this.datatypeMappers.getAccountFieldMapper().setMusic(contact, hobbyAndInterestT.getMusic());
                            this.datatypeMappers.getAccountFieldMapper().setLifestyle(contact, hobbyAndInterestT.getLifestyle());
                            this.datatypeMappers.getAccountFieldMapper().setOther(contact, hobbyAndInterestT.getOther());
                        }
                        if (Boolean.TRUE.equals(params.isUpdateBookmarks()) && (bookmarks = contactT.getBookmarks()) != null) {
                            propertySetQuery = (PropertySetQuery)this.pm.newQuery(PropertySet.class);
                            propertySetQuery.name().equalTo((Object)PropertySetName.Bookmarks.toString());
                            List propertySets = contact.getPropertySet(propertySetQuery);
                            propertySet = null;
                            if (propertySets.isEmpty()) {
                                propertySet = (PropertySet)this.pm.newInstance(PropertySet.class);
                                propertySet.setName(PropertySetName.Bookmarks.toString());
                                propertySet.getOwningGroup().addAll(customer.getOwningGroup());
                                customer.addPropertySet(this.uuidAsString(), propertySet);
                            } else {
                                propertySet = (PropertySet)propertySets.iterator().next();
                            }
                            this.updatePropertySet(bookmarks, propertySet, true);
                        }
                        PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                        result.add(Datatypes.member((Enum)UpdateCustomerResult.Member.customer, (Object)this.datatypeMappers.mapCustomer(customer, this.findCustomerContracts(customer), this.getShopCategory())));
                        result.add(Datatypes.member((Enum)UpdateCustomerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                    } else {
                        addresses = new ArrayList();
                        if (contactT.getEmailAddressHome() != null) {
                            addresses.add(contactT.getEmailAddressHome().getEmailAddress());
                        }
                        if (contactT.getEmailAddressBusiness() != null) {
                            addresses.add(contactT.getEmailAddressBusiness().getEmailAddress());
                        }
                        result.add(Datatypes.member((Enum)UpdateCustomerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-26, new String[]{"EmailAddress", addresses.toString()})));
                    }
                }
            } else {
                result.add(Datatypes.member((Enum)UpdateCustomerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Customer", customerNumber})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)UpdateCustomerResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (UpdateCustomerResult)Structures.create(UpdateCustomerResult.class, result);
    }

    @Override
    public UpdateCustomerContractResult updateCustomerContract(UpdateCustomerContractParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String customerContractNumber = params.getCustomerContract().getContractNumber();
            if (customerContractNumber != null) {
                Lead customerContract = this.findCustomerContractByContractNumber(customerContractNumber);
                CustomerContractT customerContractT = params.getCustomerContract();
                if (customerContract != null && customerContractT != null) {
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                    this.datatypeMappers.mapCustomerContract(customerContractT, customerContract);
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    result.add(Datatypes.member((Enum)UpdateCustomerContractResult.Member.customerContract, (Object)this.datatypeMappers.mapCustomerContract(customerContract)));
                    result.add(Datatypes.member((Enum)UpdateCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                } else {
                    result.add(Datatypes.member((Enum)UpdateCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"CustomerContract", customerContractNumber})));
                }
            } else {
                result.add(Datatypes.member((Enum)UpdateCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"CustomerContract", customerContractNumber})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)UpdateCustomerContractResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (UpdateCustomerContractResult)Structures.create(UpdateCustomerContractResult.class, result);
    }

    @Override
    public UpdateProductResult updateProduct(UpdateProductParams params) {
        ArrayList<Structures.Member> result = new ArrayList<Structures.Member>();
        try {
            String productNumber = params.getProduct().getProductNumber();
            Product product = this.findProduct(productNumber);
            if (product != null) {
                ProductT productT = params.getProduct();
                boolean hasErrors = false;
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).begin();
                if (!hasErrors && params.isUpdateMainData().booleanValue()) {
                    this.datatypeMappers.mapProduct(productT, product);
                    this.updateProductDescriptions(productT, product);
                }
                if (!hasErrors && Boolean.TRUE.equals(params.isUpdateClassification())) {
                    ArrayList<ProductClassification> newClassifications = new ArrayList<ProductClassification>();
                    for (String classificationId : params.getProduct().getClassificationId()) {
                        ProductClassification classification = this.findProductClassification(classificationId);
                        if (classification != null) {
                            newClassifications.add(classification);
                            continue;
                        }
                        result.add(Datatypes.member((Enum)UpdateProductResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"ProductClassification", classificationId})));
                        hasErrors = true;
                        break;
                    }
                    if (!hasErrors) {
                        product.getClassification().clear();
                        product.getClassification().addAll(newClassifications);
                    }
                }
                if (!hasErrors && Boolean.TRUE.equals(params.isUpdateUom())) {
                    ArrayList<Uom> newUoms = new ArrayList<Uom>();
                    for (String uomName : params.getProduct().getPriceUom()) {
                        Uom uom = this.findUom(uomName);
                        if (uom != null) {
                            newUoms.add(uom);
                            continue;
                        }
                        result.add(Datatypes.member((Enum)UpdateProductResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Uom", uomName})));
                        hasErrors = true;
                        break;
                    }
                    if (!hasErrors) {
                        product.getPriceUom().clear();
                        product.getPriceUom().addAll(newUoms);
                    }
                }
                if (!hasErrors && Boolean.TRUE.equals(params.isUpdateConfiguration())) {
                    ProductConfigurationTypeSet configurationType = this.findProductConfigurationType(productT.getConfigurationType());
                    if (configurationType == null) {
                        result.add(Datatypes.member((Enum)UpdateProductResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"ProductConfigurationType", productT.getConfigurationType()})));
                        hasErrors = true;
                    }
                    if (!hasErrors) {
                        this.updateProductConfiguration(productT, product, configurationType);
                    }
                }
                if (!hasErrors && Boolean.TRUE.equals(params.isUpdatePicture())) {
                    this.updateProductPicture(productT, product);
                }
                if (!hasErrors && Boolean.TRUE.equals(params.isUpdateProductPhase())) {
                    this.updateProductPhase(productT, product);
                }
                if (!hasErrors && Boolean.TRUE.equals(params.isUpdateBundleData())) {
                    this.updateProductBundle(productT, product);
                }
                if (!hasErrors) {
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).commit();
                    result.add(Datatypes.member((Enum)UpdateProductResult.Member.product, (Object)this.datatypeMappers.mapProduct(product, params.isUpdatePicture(), this.getProductSegment())));
                    result.add(Datatypes.member((Enum)UpdateProductResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(0, null)));
                } else {
                    PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
                }
            } else {
                result.add(Datatypes.member((Enum)UpdateProductResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(-34, new String[]{"Product", productNumber})));
            }
        }
        catch (Exception e) {
            try {
                PersistenceHelper.currentUnitOfWork((PersistenceManager)this.pm).rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            new ServiceException(e).log();
            result.add(Datatypes.member((Enum)UpdateProductResult.Member.status, (Object)this.datatypeMappers.mapOperationStatus(e)));
        }
        return (UpdateProductResult)Structures.create(UpdateProductResult.class, result);
    }

    public void close() {
        if (this.pm != null) {
            this.pm.close();
        }
    }
}

