/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.text;

import java.util.Arrays;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;

public class VCardRawLine {
    private final String group;
    private final String name;
    private final String value;
    private final VCardParameters parameters;

    public VCardRawLine(String group, String name, VCardParameters parameters, String value) {
        this.group = group;
        this.name = name;
        this.value = value;
        this.parameters = parameters;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public VCardParameters getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VCardRawLine other = (VCardRawLine)obj;
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static class Builder {
        private String group;
        private String name;
        private String value;
        private VCardParameters parameters = new VCardParameters();

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder param(String name, String ... values) {
            this.parameters.putAll(name, Arrays.asList(values));
            return this;
        }

        public VCardRawLine build() {
            if (this.name == null) {
                throw new IllegalArgumentException("Property name required.");
            }
            return new VCardRawLine(this.group, this.name, this.parameters, this.value);
        }
    }
}

