/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.xml;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.namespace.QName;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.CannotParseException;
import org.opencrx.application.uses.ezvcard.io.EmbeddedVCardException;
import org.opencrx.application.uses.ezvcard.io.SkipMeException;
import org.opencrx.application.uses.ezvcard.io.StreamReader;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardQNames;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;
import org.opencrx.application.uses.ezvcard.property.Xml;
import org.opencrx.application.uses.ezvcard.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XCardReader
extends StreamReader {
    private final VCardVersion version = VCardVersion.V4_0;
    private final String NS = this.version.getXmlNamespace();
    private final Source source;
    private final Closeable stream;
    private volatile VCard readVCard;
    private volatile TransformerException thrown;
    private final ReadThread thread = new ReadThread();
    private final Object lock = new Object();
    private final BlockingQueue<Object> readerBlock = new ArrayBlockingQueue<Object>(1);
    private final BlockingQueue<Object> threadBlock = new ArrayBlockingQueue<Object>(1);

    public XCardReader(String xml) {
        this(new StringReader(xml));
    }

    public XCardReader(InputStream in) {
        this.source = new StreamSource(in);
        this.stream = in;
    }

    public XCardReader(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public XCardReader(Reader reader) {
        this.source = new StreamSource(reader);
        this.stream = reader;
    }

    public XCardReader(Node node) {
        this.source = new DOMSource(node);
        this.stream = null;
    }

    @Override
    protected VCard _readNext() throws IOException {
        this.readVCard = null;
        this.thrown = null;
        if (!this.thread.started) {
            this.thread.start();
        } else {
            if (this.thread.finished || this.thread.closed) {
                return null;
            }
            try {
                this.threadBlock.put(this.lock);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        try {
            this.readerBlock.take();
        }
        catch (InterruptedException e) {
            return null;
        }
        if (this.thrown != null) {
            throw new IOException(this.thrown);
        }
        return this.readVCard;
    }

    @Override
    public void close() throws IOException {
        if (this.thread.isAlive()) {
            this.thread.closed = true;
            this.thread.interrupt();
        }
        if (this.stream != null) {
            this.stream.close();
        }
    }

    private class XCardStructure {
        private final List<ElementType> stack = new ArrayList<ElementType>();

        private XCardStructure() {
        }

        public ElementType pop() {
            return this.stack.isEmpty() ? null : this.stack.remove(this.stack.size() - 1);
        }

        public ElementType peek() {
            return this.stack.isEmpty() ? null : this.stack.get(this.stack.size() - 1);
        }

        public void push(ElementType type) {
            this.stack.add(type);
        }

        public boolean isUnderParameters() {
            ElementType nonNull = null;
            for (int i = this.stack.size() - 1; i >= 0; --i) {
                ElementType type = this.stack.get(i);
                if (type == null) continue;
                nonNull = type;
                break;
            }
            return nonNull == ElementType.parameters || nonNull == ElementType.parameter || nonNull == ElementType.parameterValue;
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }
    }

    private static enum ElementType {
        vcards,
        vcard,
        group,
        property,
        parameters,
        parameter,
        parameterValue;

    }

    private class ContentHandlerImpl
    extends DefaultHandler {
        private final Document DOC = XmlUtils.createDocument();
        private final XCardStructure structure = new XCardStructure();
        private final StringBuilder characterBuffer = new StringBuilder();
        private String group;
        private Element propertyElement;
        private Element parent;
        private QName paramName;
        private VCardParameters parameters;

        private ContentHandlerImpl() {
        }

        @Override
        public void characters(char[] buffer, int start, int length) throws SAXException {
            if (this.propertyElement == null) {
                return;
            }
            this.characterBuffer.append(buffer, start, length);
        }

        @Override
        public void startElement(String namespace, String localName, String qName, Attributes attributes) throws SAXException {
            QName qname = new QName(namespace, localName);
            String textContent = this.characterBuffer.toString();
            this.characterBuffer.setLength(0);
            if (this.structure.isEmpty()) {
                if (XCardQNames.VCARDS.equals(qname)) {
                    this.structure.push(ElementType.vcards);
                }
                return;
            }
            ElementType parentType = this.structure.peek();
            ElementType typeToPush = null;
            if (parentType != null) {
                switch (parentType) {
                    case vcards: {
                        if (!XCardQNames.VCARD.equals(qname)) break;
                        XCardReader.this.readVCard = new VCard();
                        XCardReader.this.readVCard.setVersion(XCardReader.this.version);
                        typeToPush = ElementType.vcard;
                        break;
                    }
                    case vcard: {
                        if (XCardQNames.GROUP.equals(qname)) {
                            this.group = attributes.getValue("name");
                            typeToPush = ElementType.group;
                            break;
                        }
                        this.propertyElement = this.createElement(namespace, localName, attributes);
                        this.parameters = new VCardParameters();
                        this.parent = this.propertyElement;
                        typeToPush = ElementType.property;
                        break;
                    }
                    case group: {
                        this.propertyElement = this.createElement(namespace, localName, attributes);
                        this.parameters = new VCardParameters();
                        this.parent = this.propertyElement;
                        typeToPush = ElementType.property;
                        break;
                    }
                    case property: {
                        if (!XCardQNames.PARAMETERS.equals(qname)) break;
                        typeToPush = ElementType.parameters;
                        break;
                    }
                    case parameters: {
                        if (!XCardReader.this.NS.equals(namespace)) break;
                        this.paramName = qname;
                        typeToPush = ElementType.parameter;
                        break;
                    }
                    case parameter: {
                        if (!XCardReader.this.NS.equals(namespace)) break;
                        typeToPush = ElementType.parameterValue;
                        break;
                    }
                }
            }
            if (this.propertyElement != null && typeToPush != ElementType.property && typeToPush != ElementType.parameters && !this.structure.isUnderParameters()) {
                if (textContent.length() > 0) {
                    this.parent.appendChild(this.DOC.createTextNode(textContent));
                }
                Element element = this.createElement(namespace, localName, attributes);
                this.parent.appendChild(element);
                this.parent = element;
            }
            this.structure.push(typeToPush);
        }

        @Override
        public void endElement(String namespace, String localName, String qName) throws SAXException {
            String textContent = this.characterBuffer.toString();
            this.characterBuffer.setLength(0);
            if (this.structure.isEmpty()) {
                return;
            }
            ElementType type = this.structure.pop();
            if (type == null && (this.propertyElement == null || this.structure.isUnderParameters())) {
                return;
            }
            if (type != null) {
                switch (type) {
                    case parameterValue: {
                        this.parameters.put(this.paramName.getLocalPart(), textContent);
                        break;
                    }
                    case parameter: {
                        break;
                    }
                    case parameters: {
                        break;
                    }
                    case property: {
                        this.propertyElement.appendChild(this.DOC.createTextNode(textContent));
                        String propertyName = localName;
                        QName propertyQName = new QName(this.propertyElement.getNamespaceURI(), this.propertyElement.getLocalName());
                        VCardPropertyScribe<? extends VCardProperty> scribe = XCardReader.this.index.getPropertyScribe(propertyQName);
                        try {
                            VCardPropertyScribe.Result<? extends VCardProperty> result = scribe.parseXml(this.propertyElement, this.parameters);
                            VCardProperty property = result.getProperty();
                            property.setGroup(this.group);
                            XCardReader.this.readVCard.addProperty(property);
                            for (String warning : result.getWarnings()) {
                                XCardReader.this.warnings.add(null, propertyName, warning);
                            }
                        }
                        catch (SkipMeException e) {
                            XCardReader.this.warnings.add(null, propertyName, 22, e.getMessage());
                        }
                        catch (CannotParseException e) {
                            String xml = XmlUtils.toString(this.propertyElement);
                            XCardReader.this.warnings.add(null, propertyName, 33, xml, e.getMessage());
                            scribe = XCardReader.this.index.getPropertyScribe(Xml.class);
                            VCardPropertyScribe.Result<? extends VCardProperty> result = scribe.parseXml(this.propertyElement, this.parameters);
                            VCardProperty property = result.getProperty();
                            property.setGroup(this.group);
                            XCardReader.this.readVCard.addProperty(property);
                        }
                        catch (EmbeddedVCardException e) {
                            XCardReader.this.warnings.add(null, propertyName, 34, new Object[0]);
                        }
                        this.propertyElement = null;
                        break;
                    }
                    case group: {
                        this.group = null;
                        break;
                    }
                    case vcard: {
                        try {
                            XCardReader.this.readerBlock.put(XCardReader.this.lock);
                            XCardReader.this.threadBlock.take();
                            break;
                        }
                        catch (InterruptedException e) {
                            throw new SAXException(e);
                        }
                    }
                }
            }
            if (this.propertyElement != null && type != ElementType.property && type != ElementType.parameters && !this.structure.isUnderParameters()) {
                if (textContent.length() > 0) {
                    this.parent.appendChild(this.DOC.createTextNode(textContent));
                }
                this.parent = (Element)this.parent.getParentNode();
            }
        }

        private Element createElement(String namespace, String localName, Attributes attributes) {
            Element element = this.DOC.createElementNS(namespace, localName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String qname = attributes.getQName(i);
                if (qname.startsWith("xmlns:")) continue;
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                element.setAttribute(name, value);
            }
            return element;
        }
    }

    private class ReadThread
    extends Thread {
        private final SAXResult result;
        private final Transformer transformer;
        private volatile boolean finished = false;
        private volatile boolean started = false;
        private volatile boolean closed = false;

        public ReadThread() {
            this.setName(this.getClass().getSimpleName());
            try {
                this.transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException(e);
            }
            this.transformer.setErrorListener(new ErrorListener(){

                @Override
                public void error(TransformerException e) {
                }

                @Override
                public void fatalError(TransformerException e) {
                }

                @Override
                public void warning(TransformerException e) {
                }
            });
            this.result = new SAXResult(new ContentHandlerImpl());
        }

        @Override
        public void run() {
            this.started = true;
            try {
                this.transformer.transform(XCardReader.this.source, this.result);
            }
            catch (TransformerException e) {
                if (!XCardReader.this.thread.closed) {
                    XCardReader.this.thrown = e;
                }
            }
            finally {
                this.finished = true;
                try {
                    XCardReader.this.readerBlock.put(XCardReader.this.lock);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

