/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.org.apache.commons.csv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

final class ExtendedBufferedReader
extends BufferedReader {
    private int lastChar = -2;
    private long lineCounter;

    ExtendedBufferedReader(Reader r) {
        super(r);
    }

    @Override
    public int read() throws IOException {
        int current = super.read();
        if (current == 13 || current == 10 && this.lastChar != 13) {
            ++this.lineCounter;
        }
        this.lastChar = current;
        return this.lastChar;
    }

    int getLastChar() {
        return this.lastChar;
    }

    @Override
    public int read(char[] buf, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int len = super.read(buf, offset, length);
        if (len > 0) {
            for (int i = offset; i < offset + len; ++i) {
                char ch = buf[i];
                if (ch == '\n') {
                    if (13 == (i > 0 ? buf[i - 1] : this.lastChar)) continue;
                    ++this.lineCounter;
                    continue;
                }
                if (ch != '\r') continue;
                ++this.lineCounter;
            }
            this.lastChar = buf[offset + len - 1];
        } else if (len == -1) {
            this.lastChar = -1;
        }
        return len;
    }

    @Override
    public String readLine() throws IOException {
        String line = super.readLine();
        if (line != null) {
            this.lastChar = 10;
            ++this.lineCounter;
        } else {
            this.lastChar = -1;
        }
        return line;
    }

    int lookAhead() throws IOException {
        super.mark(1);
        int c = super.read();
        super.reset();
        return c;
    }

    long getLineNumber() {
        return this.lineCounter;
    }
}

