/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.utils;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.application.ical.ICalServlet;
import org.opencrx.kernel.account1.jmi1.AbstractGroup;
import org.opencrx.kernel.account1.jmi1.AccountFilterGlobal;
import org.opencrx.kernel.activity1.jmi1.ActivityCategory;
import org.opencrx.kernel.activity1.jmi1.ActivityFilterGlobal;
import org.opencrx.kernel.activity1.jmi1.ActivityFilterGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityMilestone;
import org.opencrx.kernel.activity1.jmi1.ActivityTracker;
import org.opencrx.kernel.activity1.jmi1.Resource;
import org.opencrx.kernel.home1.cci2.SyncFeedQuery;
import org.opencrx.kernel.home1.jmi1.ActivityFilterCalendarFeed;
import org.opencrx.kernel.home1.jmi1.ActivityGroupCalendarFeed;
import org.opencrx.kernel.home1.jmi1.AirSyncProfile;
import org.opencrx.kernel.home1.jmi1.CalendarProfile;
import org.opencrx.kernel.home1.jmi1.CardProfile;
import org.opencrx.kernel.home1.jmi1.ContactsFeed;
import org.opencrx.kernel.home1.jmi1.DocumentProfile;
import org.opencrx.kernel.home1.jmi1.SyncFeed;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;

public class AdapterConnectionHelper {
    private static List<ConnectionURL> mapToURLs(String baseUrl, RefObject_1_0 obj, String servletType, List<ResourcePath> paths) throws ServiceException {
        try {
            String providerName = obj.refGetPath().get(2);
            String segmentName = obj.refGetPath().get(4);
            ArrayList<ConnectionURL> urls = new ArrayList<ConnectionURL>();
            for (ResourcePath path : paths) {
                urls.add(new ConnectionURL(new URL(baseUrl.replace("-core-", "-" + servletType + "-") + providerName + "/" + segmentName + path.getPath()), path.getObject()));
            }
            return urls;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private static List<ResourcePath> getCalendarPaths(RefObject_1_0 obj, boolean isCollectionTypeTask, String suffix) throws ServiceException {
        try {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)obj);
            ArrayList<ResourcePath> paths = new ArrayList<ResourcePath>();
            if (obj instanceof ActivityFilterGroup) {
                ActivityFilterGroup activityFilterGroup = (ActivityFilterGroup)obj;
                if (activityFilterGroup.getName() != null && !activityFilterGroup.getName().isEmpty()) {
                    ActivityGroup group = (ActivityGroup)pm.getObjectById((Object)activityFilterGroup.refGetPath().getParent().getParent());
                    if (group instanceof ActivityTracker) {
                        paths.add(new ResourcePath(group, "/tracker/" + group.getName() + "/filter/" + activityFilterGroup.getName() + (isCollectionTypeTask ? "/VTODO" : "") + suffix));
                    } else if (group instanceof ActivityMilestone) {
                        paths.add(new ResourcePath(group, "/milestone/" + group.getName() + "/filter/" + activityFilterGroup.getName() + (isCollectionTypeTask ? "/VTODO" : "") + suffix));
                    } else if (group instanceof ActivityCategory) {
                        paths.add(new ResourcePath(group, "/category/" + group.getName() + "/filter/" + activityFilterGroup.getName() + (isCollectionTypeTask ? "/VTODO" : "") + suffix));
                    }
                }
            } else if (obj instanceof ActivityFilterGlobal) {
                ActivityFilterGlobal activityFilterGlobal = (ActivityFilterGlobal)obj;
                if (activityFilterGlobal.getName() != null && !activityFilterGlobal.getName().isEmpty()) {
                    paths.add(new ResourcePath(activityFilterGlobal, "/globalfilter/" + activityFilterGlobal.getName() + (isCollectionTypeTask ? "/VTODO" : "") + suffix));
                }
            } else if (obj instanceof ActivityTracker) {
                ActivityTracker activityTracker = (ActivityTracker)obj;
                if (activityTracker.getName() != null && !activityTracker.getName().isEmpty()) {
                    paths.add(new ResourcePath(activityTracker, "/tracker/" + activityTracker.getName() + (isCollectionTypeTask ? "/VTODO" : "") + suffix));
                }
            } else if (obj instanceof ActivityCategory) {
                ActivityCategory activityCategory = (ActivityCategory)obj;
                if (activityCategory.getName() != null && !activityCategory.getName().isEmpty()) {
                    paths.add(new ResourcePath(activityCategory, "/category/" + activityCategory.getName() + (isCollectionTypeTask ? "/VTODO" : "") + suffix));
                }
            } else if (obj instanceof ActivityMilestone) {
                ActivityMilestone activityMilestone = (ActivityMilestone)obj;
                if (activityMilestone.getName() != null && !activityMilestone.getName().isEmpty()) {
                    paths.add(new ResourcePath(activityMilestone, "/milestone/" + activityMilestone.getName() + (isCollectionTypeTask ? "/VTODO" : "") + suffix));
                }
            } else if (obj instanceof CalendarProfile) {
                CalendarProfile calendarProfile = (CalendarProfile)obj;
                SyncFeedQuery syncFeedQuery = (SyncFeedQuery)pm.newQuery(SyncFeed.class);
                syncFeedQuery.orderByName().ascending();
                syncFeedQuery.forAllIsActive().isTrue();
                for (SyncFeed feed : calendarProfile.getFeed(syncFeedQuery)) {
                    if (!Boolean.TRUE.equals(feed.isActive())) continue;
                    if (feed instanceof ActivityFilterCalendarFeed) {
                        try {
                            paths.addAll(AdapterConnectionHelper.getCalendarPaths(((ActivityFilterCalendarFeed)feed).getActivityFilter(), isCollectionTypeTask, suffix));
                        }
                        catch (Exception exception) {}
                    } else if (feed instanceof ActivityGroupCalendarFeed) {
                        try {
                            paths.addAll(AdapterConnectionHelper.getCalendarPaths(((ActivityGroupCalendarFeed)feed).getActivityGroup(), isCollectionTypeTask, suffix));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    paths.add(new ResourcePath(feed, "/user/" + calendarProfile.refGetPath().getSegment(6).toString() + "/profile/" + calendarProfile.refGetPath().getSegment(8).toString() + "/" + feed.refGetPath().getLastSegment().toString() + (isCollectionTypeTask ? "/VTODO" : "") + suffix));
                }
            } else if (obj instanceof UserHome) {
                paths.add(new ResourcePath(obj, "/home/" + obj.refGetPath().getLastSegment().toString() + (isCollectionTypeTask ? "/VTODO" : "") + suffix));
            }
            return paths;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    private static List<ResourcePath> getCardPaths(RefObject_1_0 obj, String suffix) throws ServiceException {
        try {
            ArrayList<ResourcePath> paths = new ArrayList<ResourcePath>();
            if (obj instanceof AccountFilterGlobal) {
                AccountFilterGlobal accountFilterGlobal = (AccountFilterGlobal)obj;
                if (accountFilterGlobal.getName() != null && !accountFilterGlobal.getName().isEmpty()) {
                    paths.add(new ResourcePath(accountFilterGlobal, "/filter/" + accountFilterGlobal.getName() + suffix));
                }
            } else if (obj instanceof AbstractGroup) {
                AbstractGroup accountGroup = (AbstractGroup)obj;
                if (accountGroup.getName() != null && !accountGroup.getName().isEmpty()) {
                    paths.add(new ResourcePath(accountGroup, "/group/" + accountGroup.getName() + suffix));
                }
            } else if (obj instanceof CardProfile) {
                CardProfile cardProfile = (CardProfile)obj;
                Iterator iterator = cardProfile.getFeed().iterator();
                while (iterator.hasNext()) {
                    SyncFeed feed = (SyncFeed)iterator.next();
                    if (!Boolean.TRUE.equals(feed.isActive())) continue;
                    try {
                        if (!(feed instanceof ContactsFeed)) continue;
                        paths.addAll(AdapterConnectionHelper.getCardPaths(((ContactsFeed)feed).getAccountGroup(), suffix));
                    }
                    catch (Exception exception) {}
                }
            }
            return paths;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static List<ConnectionURL> getCalDavCollectionSetURLs(String baseUrl, RefObject_1_0 obj) throws ServiceException {
        try {
            CalendarProfile calendarProfile;
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)obj);
            ArrayList<ResourcePath> paths = new ArrayList<ResourcePath>();
            if (obj instanceof CalendarProfile && (calendarProfile = (CalendarProfile)obj).getName() != null && !calendarProfile.getName().isEmpty()) {
                UserHome userHome = (UserHome)pm.getObjectById((Object)new Path(obj.refMofId()).getParent().getParent());
                paths.add(new ResourcePath(userHome, "/user/" + userHome.refGetPath().getLastSegment().toString() + "/profile/" + calendarProfile.getName()));
            }
            return AdapterConnectionHelper.mapToURLs((String)(baseUrl.endsWith("/") ? baseUrl : baseUrl + "/"), obj, "caldav", paths);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static List<ConnectionURL> getCalDavEventCollectionURLs(String baseUrl, RefObject_1_0 obj) throws ServiceException {
        return AdapterConnectionHelper.mapToURLs((String)(baseUrl.endsWith("/") ? baseUrl : baseUrl + "/"), obj, "caldav", AdapterConnectionHelper.getCalendarPaths(obj, false, ""));
    }

    public static List<ConnectionURL> getCalDavTaskCollectionURLs(String baseUrl, RefObject_1_0 obj) throws ServiceException {
        return AdapterConnectionHelper.mapToURLs((String)(baseUrl.endsWith("/") ? baseUrl : baseUrl + "/"), obj, "caldav", AdapterConnectionHelper.getCalendarPaths(obj, true, ""));
    }

    public static List<ConnectionURL> getWebDavCollectionURLs(String baseUrl, RefObject_1_0 obj) throws ServiceException {
        try {
            DocumentProfile documentProfile;
            ArrayList<ResourcePath> paths = new ArrayList<ResourcePath>();
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)obj);
            if (obj instanceof DocumentProfile && (documentProfile = (DocumentProfile)obj).getName() != null && !documentProfile.getName().isEmpty()) {
                UserHome userHome = (UserHome)pm.getObjectById((Object)obj.refGetPath().getParent().getParent());
                paths.add(new ResourcePath(userHome, "/user/" + userHome.refGetPath().getLastSegment().toString() + "/profile/" + documentProfile.getName()));
            }
            return AdapterConnectionHelper.mapToURLs((String)(baseUrl.endsWith("/") ? baseUrl : baseUrl + "/"), obj, "webdav", paths);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static List<ConnectionURL> getCardDavCollectionSetURLs(String baseUrl, RefObject_1_0 obj) throws ServiceException {
        try {
            CardProfile cardProfile;
            ArrayList<ResourcePath> paths = new ArrayList<ResourcePath>();
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)obj);
            if (obj instanceof CardProfile && (cardProfile = (CardProfile)obj).getName() != null && !cardProfile.getName().isEmpty()) {
                UserHome userHome = (UserHome)pm.getObjectById((Object)obj.refGetPath().getParent().getParent());
                paths.add(new ResourcePath(userHome, "/user/" + userHome.refGetPath().getLastSegment().toString() + "/profile/" + cardProfile.getName()));
            }
            return AdapterConnectionHelper.mapToURLs((String)(baseUrl.endsWith("/") ? baseUrl : baseUrl + "/"), obj, "carddav", paths);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static List<ConnectionURL> getCardDavCollectionURLs(String baseUrl, RefObject_1_0 obj) throws ServiceException {
        try {
            CardProfile cardProfile;
            ArrayList<ResourcePath> paths = new ArrayList<ResourcePath>();
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)obj);
            if (obj instanceof CardProfile && (cardProfile = (CardProfile)obj).getName() != null && !cardProfile.getName().isEmpty()) {
                UserHome userHome = (UserHome)pm.getObjectById((Object)obj.refGetPath().getParent().getParent());
                Iterator iterator = cardProfile.getFeed().iterator();
                while (iterator.hasNext()) {
                    SyncFeed feed = (SyncFeed)iterator.next();
                    if (!Boolean.TRUE.equals(feed.isActive()) || !(feed instanceof ContactsFeed)) continue;
                    paths.add(new ResourcePath(feed, "/" + userHome.refGetPath().getLastSegment().toString() + "/" + cardProfile.refGetPath().getLastSegment().toString() + "/" + feed.refGetPath().getLastSegment().toString()));
                }
            }
            return AdapterConnectionHelper.mapToURLs((String)(baseUrl.endsWith("/") ? baseUrl : baseUrl + "/"), obj, "carddav", paths);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static List<ConnectionURL> getICalURLs(String baseUrl, RefObject_1_0 obj, String optionMax, String optionIsDisabled) throws ServiceException {
        try {
            Resource resource;
            ArrayList<ResourcePath> paths = new ArrayList<ResourcePath>();
            String suffix = "&type=ics&max=" + (optionMax == null ? "" : optionMax) + "&disabled=" + (optionIsDisabled == null ? "" : optionIsDisabled);
            if (obj instanceof Resource && (resource = (Resource)obj).getName() != null && !resource.getName().isEmpty()) {
                paths.add(new ResourcePath(resource, "/resource/" + resource.getName() + suffix));
            }
            paths.addAll(AdapterConnectionHelper.getCalendarPaths(obj, false, suffix));
            return AdapterConnectionHelper.mapToURLs(baseUrl.endsWith("/") ? baseUrl + "activities?id=" : baseUrl + "/activities?id=", obj, "ical", paths);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static List<ConnectionURL> getFreeBusyURLs(String baseUrl, RefObject_1_0 obj, String optionUser, String optionMax, String optionIsDisabled) throws ServiceException {
        try {
            Resource resource;
            ArrayList<ResourcePath> paths = new ArrayList<ResourcePath>();
            String suffix1 = "&user=" + (optionUser == null ? "" : optionUser) + "&max=" + (optionMax == null ? "" : optionMax) + "&disabled=" + (optionIsDisabled == null ? "" : optionIsDisabled);
            String suffix2 = "&type=ics&user=" + (optionUser == null ? "" : optionUser) + "&max=" + (optionMax == null ? "" : optionMax) + "&disabled=" + (optionIsDisabled == null ? "" : optionIsDisabled);
            if (obj instanceof Resource && (resource = (Resource)obj).getName() != null && !resource.getName().isEmpty()) {
                paths.add(new ResourcePath(resource, "/resource/" + resource.getName() + suffix1));
                paths.add(new ResourcePath(resource, "/resource/" + resource.getName() + suffix2));
            }
            paths.addAll(AdapterConnectionHelper.getCalendarPaths(obj, false, suffix1));
            paths.addAll(AdapterConnectionHelper.getCalendarPaths(obj, false, suffix2));
            return AdapterConnectionHelper.mapToURLs(baseUrl.endsWith("/") ? baseUrl + "freebusy?id=" : baseUrl + "/freebusy?id=", obj, "ical", paths);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static List<ConnectionURL> getOtherCalendarURLs(String baseUrl, RefObject_1_0 obj, String optionMax, String optionSummaryPrefix, String optionCategories, String optionYear, String optionAlarm) throws ServiceException {
        try {
            ArrayList<ResourcePath> paths = new ArrayList<ResourcePath>();
            paths.addAll(AdapterConnectionHelper.getCardPaths(obj, "&type=ics&max=" + optionMax + "&icalType=VEVENT&summaryPrefix=" + (optionSummaryPrefix == null ? "" : optionSummaryPrefix) + "&categories=" + (optionCategories == null ? "" : optionCategories) + "&year=" + (optionYear == null ? "" : optionYear) + "&alarm=" + (optionAlarm == null ? "" : optionAlarm)));
            paths.addAll(AdapterConnectionHelper.getCardPaths(obj, "&type=ics&max=" + optionMax + "&icalType=VTODO&summaryPrefix=" + (optionSummaryPrefix == null ? "" : optionSummaryPrefix) + "&categories=" + (optionCategories == null ? "" : optionCategories) + "&year=" + (optionYear == null ? "" : optionYear) + "&alarm=" + (optionAlarm == null ? "" : optionAlarm)));
            ArrayList<ConnectionURL> urls = new ArrayList<ConnectionURL>();
            for (ICalServlet.CalendarType calendarType : ICalServlet.CalendarType.values()) {
                urls.addAll(AdapterConnectionHelper.mapToURLs(baseUrl.endsWith("/") ? baseUrl + calendarType.getPath().substring(1) + "?id=" : baseUrl + calendarType.getPath() + "?id=", obj, "ical", paths));
            }
            return urls;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static List<ConnectionURL> getVCardURLs(String baseUrl, RefObject_1_0 obj) throws ServiceException {
        try {
            List<ResourcePath> paths = AdapterConnectionHelper.getCardPaths(obj, "&type=vcf");
            return AdapterConnectionHelper.mapToURLs(baseUrl.endsWith("/") ? baseUrl + "accounts?id=" : baseUrl + "/accounts?id=", obj, "vcard", paths);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static List<ConnectionURL> getAirSyncURLs(String baseUrl, RefObject_1_0 obj) throws ServiceException {
        try {
            AirSyncProfile syncProfile;
            ArrayList<ResourcePath> paths = new ArrayList<ResourcePath>();
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)obj);
            if (obj instanceof AirSyncProfile && (syncProfile = (AirSyncProfile)obj).getName() != null && !syncProfile.getName().isEmpty()) {
                UserHome userHome = (UserHome)pm.getObjectById((Object)obj.refGetPath().getParent().getParent());
                paths.add(new ResourcePath(userHome, "/user/" + userHome.refGetPath().getLastSegment().toString() + "/profile/" + syncProfile.getName()));
            }
            return AdapterConnectionHelper.mapToURLs((String)(baseUrl.endsWith("/") ? baseUrl : baseUrl + "/"), obj, "airsync", paths);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static class ResourcePath {
        private RefObject_1_0 object;
        private String path;

        public ResourcePath(RefObject_1_0 object, String path) {
            this.object = object;
            this.path = path;
        }

        public RefObject_1_0 getObject() {
            return this.object;
        }

        public void setObject(RefObject_1_0 object) {
            this.object = object;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class ConnectionURL {
        private RefObject_1_0 object;
        private URL url;

        public ConnectionURL(URL url, RefObject_1_0 object) {
            this.url = url;
            this.object = object;
        }

        public RefObject_1_0 getObject() {
            return this.object;
        }

        public void setObject(RefObject_1_0 object) {
            this.object = object;
        }

        public URL getUrl() {
            return this.url;
        }

        public void setUrl(URL url) {
            this.url = url;
        }
    }
}

