/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.base.jmi1.SecureObject;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.persistence.cci.ConfigurableProperty;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.log.SysLog;

public abstract class AbstractImpl {
    private static ConcurrentMap<String, Object> currentImpls = new ConcurrentHashMap<String, Object>();
    private static Set<String> registeredImpls = new HashSet<String>();

    protected static <B extends AbstractImpl> B getInstance(Class<B> backendClass) throws ServiceException {
        AbstractImpl impl = (AbstractImpl)currentImpls.get(backendClass.getSimpleName());
        if (impl == null) {
            throw new ServiceException("DefaultDomain", -34, "Requested backend class is not registered", new BasicException.Parameter[]{new BasicException.Parameter("backend.id", (Object)backendClass.getSimpleName())});
        }
        return (B)impl;
    }

    protected static void registerImpl(AbstractImpl impl) {
        if (!registeredImpls.contains(impl.getClass().getName())) {
            String key = impl.getClass().getSimpleName();
            try {
                SysLog.info((String)"Registering impl", (Object)impl.getClass().getName());
                currentImpls.put(key, impl);
                registeredImpls.add(impl.getClass().getName());
            }
            catch (Exception e) {
                ServiceException e0 = new ServiceException(e, "DefaultDomain", -10, "Backend class can not be registered", new BasicException.Parameter[]{new BasicException.Parameter("backend.id", (Object)key)});
                e0.log();
            }
        } else {
            SysLog.detail((String)"Impl already registered. Ignoring.", (Object)impl.getClass().getName());
        }
    }

    public String getUidAsString() {
        return UUIDConversion.toUID((UUID)UUIDs.newUUID());
    }

    public void preDelete(RefObject_1_0 object, boolean preDelete) throws ServiceException {
    }

    public void preStore(RefObject_1_0 object) throws ServiceException {
    }

    public PersistenceManager getContainerManagedPersistenceManager(SecureObject secureObject) throws ServiceException {
        String owningUserName = secureObject.getOwningUser().getName();
        String ownerPrincipal = owningUserName.substring(0, owningUserName.lastIndexOf("."));
        return this.getContainerManagedPersistenceManager(ownerPrincipal);
    }

    public PersistenceManager getContainerManagedPersistenceManager(String userid) throws ServiceException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(ConfigurableProperty.ContainerManaged.qualifiedName(), Boolean.TRUE);
        return Utils.getPersistenceManagerFactory(props).getPersistenceManager(userid, null);
    }
}

