/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.jdo.Extent;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.oasisopen.jmi1.RefContainer;
import org.omg.mof.spi.Names;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Workflows;
import org.opencrx.kernel.code1.cci2.ValidateObjectResult;
import org.opencrx.kernel.code1.cci2.ValidatorCondition;
import org.opencrx.kernel.code1.cci2.ValueRangeUpdateValuesResult;
import org.opencrx.kernel.code1.jmi1.BasicValidatorCondition;
import org.opencrx.kernel.code1.jmi1.ComplexValidatorCondition;
import org.opencrx.kernel.code1.jmi1.ObjectValidator;
import org.opencrx.kernel.code1.jmi1.SequenceBasedValueRange;
import org.opencrx.kernel.code1.jmi1.ValidateObjectResult;
import org.opencrx.kernel.code1.jmi1.ValueRange;
import org.opencrx.kernel.code1.jmi1.ValueRangeUpdateValuesResult;
import org.opencrx.kernel.jmi1.Segment;
import org.opencrx.kernel.workflow1.cci2.ExporterTaskQuery;
import org.opencrx.kernel.workflow1.jmi1.ExporterTask;
import org.opencrx.kernel.workflow1.jmi1.RunExportResult;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.cci2.BasicObjectQuery;
import org.openmdx.base.cci2.ContextCapableQuery;
import org.openmdx.base.cci2.ExtentCapableQuery;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.query.ConditionType;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.Query_2Facade;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.loading.Classes;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.format.DateTimeFormat;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class Codes
extends AbstractImpl {
    public static final int DEFAULT_BATCH_SIZE = 50;

    public static void register() {
        Codes.registerImpl(new Codes());
    }

    public static Codes getInstance() throws ServiceException {
        return Codes.getInstance(Codes.class);
    }

    protected Codes() {
    }

    public org.opencrx.kernel.code1.jmi1.Segment getCodeSegment(PersistenceManager pm, String providerName, String segmentName) {
        return (org.opencrx.kernel.code1.jmi1.Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.code1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
    }

    public ValueRangeProvider getValueRangeProvider(ValueRange valueRange) throws ServiceException {
        if (valueRange instanceof SequenceBasedValueRange) {
            SequenceBasedValueRange sequenceBasedValueRange = (SequenceBasedValueRange)valueRange;
            return new SequenceBasedValueRangeProvider(sequenceBasedValueRange.getStartValue(), sequenceBasedValueRange.getNextValue(), sequenceBasedValueRange.getIncrementValue());
        }
        throw new ServiceException("DefaultDomain", -36, "no value range provider for given value range type", new BasicException.Parameter[]{new BasicException.Parameter("type", (Object)valueRange.getClass().getName())});
    }

    public String getUpdateValuesQuery(ValueRange valueRange, String restrictToQuery) throws ServiceException {
        Object query = valueRange.getStoragePath() + "().isNull()";
        if ("name".equals(valueRange.getStoragePath())) {
            query = "name().equalTo(\"\")";
        }
        if (valueRange.getQuery() != null && !"".equals(valueRange.getQuery())) {
            query = valueRange.getQuery().startsWith(";") ? (String)query + valueRange.getQuery() : valueRange.getQuery();
        }
        if (restrictToQuery != null && !restrictToQuery.isEmpty()) {
            query = restrictToQuery.startsWith(";") ? (String)query + restrictToQuery : (String)query + ";" + restrictToQuery;
        }
        return query;
    }

    public Query newUpdateValuesQuery(ValueRange valueRange, String restrictToQuery) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)valueRange);
        Query_2Facade queryFacade = Facades.newQuery(null);
        queryFacade.setQueryType(valueRange.getQueryType());
        queryFacade.setQuery(this.getUpdateValuesQuery(valueRange, restrictToQuery));
        Query query = pm.newQuery("org.openmdx.query.OPENMDXQL", (Object)queryFacade.getDelegate());
        try {
            String providerName = valueRange.refGetPath().getSegment(2).toString();
            String segmentName = valueRange.refGetPath().getSegment(4).toString();
            Path identityPattern = new Path(valueRange.getIdentityPattern());
            query.setCandidates(PersistenceHelper.getCandidates((Extent)pm.getExtent(Classes.getApplicationClass((String)Names.toClassName((String)valueRange.getQueryType(), (String)"jmi1"))), (Object)new Path(new String[]{identityPattern.getSegment(0).toString(), "provider", providerName, "segment", segmentName}).getDescendant(identityPattern.getSegments().subList(5, identityPattern.size()))));
        }
        catch (Exception e) {
            new ServiceException(e);
        }
        if (!valueRange.getObjectType().isEmpty()) {
            try {
                Class[] objectTypes = new Class[valueRange.getObjectType().size()];
                for (int i = 0; i < objectTypes.length; ++i) {
                    objectTypes[i] = Classes.getApplicationClass((String)Names.toClassName((String)valueRange.getObjectType().get(i), (String)"jmi1"));
                }
                PersistenceHelper.setClasses((AnyTypePredicate)((AnyTypePredicate)query), (Class[])objectTypes);
            }
            catch (Exception e) {
                new ServiceException(e);
            }
        }
        return query;
    }

    public Object getValue(RefObject_1_0 object, String feature, ValueRangeProvider valueRangeProvider) throws ServiceException {
        Object value = null;
        value = "$nextValue".equals(feature) ? Integer.valueOf(valueRangeProvider.getNextValue()) : ("$date".equals(feature) ? new Date() : object.refGetValue(feature));
        return value;
    }

    public Object getValue(RefObject_1_0 object, RefObject_1_0 anchor, String feature, org.opencrx.kernel.code1.jmi1.ValidatorCondition condition, Date validationTime) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object);
        String providerName = object.refGetPath().getSegment(2).toString();
        String segmentName = object.refGetPath().getSegment(4).toString();
        org.opencrx.kernel.workflow1.jmi1.Segment workflowSegment = Workflows.getInstance().getWorkflowSegment(pm, providerName, segmentName);
        Object value = null;
        if (feature.startsWith("$")) {
            String exporterTaskName = feature.substring(1);
            ExporterTaskQuery exporterTaskQuery = (ExporterTaskQuery)pm.newQuery(ExporterTask.class);
            exporterTaskQuery.forAllDisabled().isFalse();
            exporterTaskQuery.orderByCreatedAt().ascending();
            exporterTaskQuery.name().equalTo((Object)exporterTaskName);
            List exporterTasks = workflowSegment.getWfProcess(exporterTaskQuery);
            if (!exporterTasks.isEmpty()) {
                ExporterTask exporterTask = (ExporterTask)exporterTasks.iterator().next();
                RunExportResult result = Workflows.getInstance().runExport(exporterTask, Arrays.asList(workflowSegment.refGetPath().toXRI(), object.refGetPath().toXRI(), anchor == null ? "" : anchor.refGetPath().toXRI(), validationTime == null ? "" : DateTimeFormat.BASIC_UTC_FORMAT.format(validationTime)));
                if (result.getFile() != null) {
                    try {
                        value = new String(result.getFile(), "UTF-8");
                    }
                    catch (Exception exception) {}
                }
            }
        } else {
            value = object.refGetValue(feature);
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                value = values.isEmpty() ? null : values.iterator().next();
            }
        }
        return value;
    }

    public void updateValue(RefObject_1_0 object, ValueRange valueRange, ValueRangeProvider valueRangeProvider) throws ServiceException {
        List<String> arguments = valueRange.getArgument();
        Object[] args = new Object[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            String featurePath = arguments.get(i);
            Object value = object;
            for (String feature : featurePath.split("\\.")) {
                value = this.getValue((RefObject_1_0)value, feature, valueRangeProvider);
            }
            args[i] = value;
        }
        object.refSetValue(valueRange.getStoragePath(), (Object)String.format(valueRange.getFormat(), args));
    }

    public ValueRangeUpdateValuesResult updateValues(SequenceBasedValueRange valueRange, Integer batchSize, String restrictToQuery) throws ServiceException {
        int numberProcessed = 0;
        Object statusMessage = null;
        short statusCode = 0;
        boolean rollbackOnError = false;
        ServiceException se = null;
        try {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)valueRange);
            Path identityPattern = new Path(valueRange.getIdentityPattern());
            String providerName = valueRange.refGetPath().getSegment(2).toString();
            String segmentName = valueRange.refGetPath().getSegment(4).toString();
            if (batchSize == null) {
                batchSize = 50;
            }
            Path segmentIdentity = new Path(new String[]{identityPattern.getSegment(0).toString(), "provider", providerName, "segment", segmentName});
            Segment segment = (Segment)pm.getObjectById((Object)segmentIdentity);
            Query query = this.newUpdateValuesQuery(valueRange, restrictToQuery);
            if (query instanceof BasicObjectQuery) {
                BasicObjectQuery basicObjectQuery = (BasicObjectQuery)query;
                basicObjectQuery.orderByCreatedAt().ascending();
                if (query != null) {
                    List objects = segment.getExtent((ExtentCapableQuery)basicObjectQuery);
                    ValueRangeProvider valueRangeProvider = this.getValueRangeProvider(valueRange);
                    statusMessage = "{\"statusMessage\":[";
                    String separator = "";
                    for (BasicObject object : objects) {
                        this.updateValue((RefObject_1_0)object, valueRange, valueRangeProvider);
                        statusMessage = (String)statusMessage + separator + "{\"object\": \"" + object.refGetPath().toXRI() + "\"}";
                        separator = ",";
                        rollbackOnError = true;
                        if (++numberProcessed < batchSize) continue;
                        break;
                    }
                    statusMessage = (String)statusMessage + "]}";
                    valueRange.setNextValue(valueRangeProvider.getNextValue());
                    rollbackOnError = true;
                }
            }
        }
        catch (Exception e) {
            se = new ServiceException(e);
        }
        if (rollbackOnError && se != null) {
            throw se;
        }
        if (se != null) {
            statusMessage = se.getMessage();
            statusCode = (short)se.getExceptionCode();
        }
        return (ValueRangeUpdateValuesResult)Structures.create(ValueRangeUpdateValuesResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ValueRangeUpdateValuesResult.Member.statusMessage, (Object)statusMessage), Datatypes.member((Enum)ValueRangeUpdateValuesResult.Member.statusCode, (Object)statusCode), Datatypes.member((Enum)ValueRangeUpdateValuesResult.Member.numberProcessed, (Object)numberProcessed)});
    }

    protected BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        return new BigDecimal(value.toString());
    }

    /*
     * WARNING - void declaration
     */
    public Boolean evaluateCondition(org.opencrx.kernel.code1.jmi1.ValidatorCondition condition, ContextCapable object, Date validationTime, List<String> selectors, org.openmdx.base.cci2.ContextCapable anchor, List<ValidatorCondition> includes, List<ValidatorCondition> excludes, StringBuffer statusMessage) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)condition);
        Boolean result = null;
        Object comment = "";
        if (condition instanceof ComplexValidatorCondition) {
            ComplexValidatorCondition complexCondition = (ComplexValidatorCondition)condition;
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            for (org.opencrx.kernel.code1.jmi1.ValidatorCondition operand : complexCondition.getOperand()) {
                if (Boolean.TRUE.equals(condition.isDisabled()) || validationTime != null && operand.getValidFrom() != null && validationTime.compareTo(operand.getValidFrom()) <= 0 || validationTime != null && operand.getValidTo() != null && validationTime.compareTo(operand.getValidTo()) >= 0 || !selectors.isEmpty() && Collections.disjoint(selectors, operand.getSelector()) || !includes.isEmpty() && !includes.contains(operand) || !excludes.isEmpty() && excludes.contains(operand)) continue;
                values.add(this.evaluateCondition(operand, object, validationTime, selectors, anchor, includes, excludes, statusMessage));
            }
            if (values.contains(null)) {
                result = null;
            } else if (complexCondition.getOperator() == BooleanOperator.OR.getValue()) {
                result = values.contains(Boolean.TRUE);
            } else if (complexCondition.getOperator() == BooleanOperator.AND.getValue()) {
                result = !values.contains(Boolean.FALSE);
            }
            comment = ((Object)values).toString();
        } else if (condition instanceof BasicValidatorCondition) {
            void var16_48;
            void var16_45;
            Object referenceName;
            BasicValidatorCondition basicCondition = (BasicValidatorCondition)condition;
            ArrayList<ContextCapable> candidates = new ArrayList<ContextCapable>();
            if ("this".equalsIgnoreCase(basicCondition.getObjectQuery())) {
                candidates.add(object);
            } else {
                void var16_21;
                String[] objectQuery = basicCondition.getObjectQuery().split("\\?");
                referenceName = objectQuery[0];
                Object var16_20 = null;
                String queryString = null;
                int size = 50;
                if (objectQuery.length > 1) {
                    for (String nv : objectQuery[1].split("&")) {
                        int pos = nv.indexOf("=");
                        if (pos <= 0) continue;
                        String name = nv.substring(0, pos);
                        String value = nv.substring(pos + 1);
                        if ("query".equals(name)) {
                            queryString = value;
                            continue;
                        }
                        if ("queryType".equals(name)) {
                            String string = value;
                            continue;
                        }
                        if (!"size".equals(name)) continue;
                        size = Integer.valueOf(value);
                    }
                }
                if (var16_21 == null || var16_21.isEmpty()) {
                    throw new ServiceException("DefaultDomain", -2, "Missing parameter queryType in objectQuery", new BasicException.Parameter[]{new BasicException.Parameter("objectQuery", (Object)basicCondition.getObjectQuery())});
                }
                if (queryString == null || queryString.isEmpty()) {
                    throw new ServiceException("DefaultDomain", -2, "Missing parameter queryString in objectQuery", new BasicException.Parameter[]{new BasicException.Parameter("objectQuery", (Object)basicCondition.getObjectQuery())});
                }
                ContextCapableQuery query = null;
                Query_2Facade queryFacade = Facades.newQuery(null);
                queryFacade.setQueryType((String)var16_21);
                if (queryString != null) {
                    queryFacade.setQuery(queryString);
                }
                query = (ContextCapableQuery)pm.newQuery("org.openmdx.query.OPENMDXQL", (Object)queryFacade.getDelegate());
                int count = 0;
                for (ContextCapable candidate : ((RefContainer)object.refGetValue((String)referenceName)).refGetAll((Object)query)) {
                    candidates.add(candidate);
                    if (++count < size) continue;
                    break;
                }
            }
            HashMap<RefObject_1_0, ContextCapable> valueMap = new HashMap<RefObject_1_0, ContextCapable>();
            referenceName = candidates.iterator();
            while (referenceName.hasNext()) {
                ContextCapable contextCapable;
                Object value = contextCapable = (ContextCapable)referenceName.next();
                RefObject_1_0 lastObjectValue = null;
                for (String feature : basicCondition.getFeaturePath().split("\\.")) {
                    lastObjectValue = (RefObject_1_0)value;
                    value = this.getValue((RefObject_1_0)value, (RefObject_1_0)anchor, feature, condition, validationTime);
                }
                if (value instanceof RefObject_1_0) {
                    lastObjectValue = (RefObject_1_0)value;
                }
                valueMap.put(lastObjectValue, (ContextCapable)(value instanceof RefObject_1_0 ? ((RefObject_1_0)value).refGetPath() : value));
            }
            ArrayList values = new ArrayList();
            if (basicCondition.getScope().isEmpty()) {
                values.addAll(valueMap.values());
            } else {
                for (Object scope : basicCondition.getScope()) {
                    if (!valueMap.containsKey(scope)) continue;
                    values.add(valueMap.get(scope));
                }
            }
            Object var16_27 = null;
            comment = ((Object)values).toString();
            if (basicCondition.getAggregateFunction() == AggregateFunction.SUM.getValue()) {
                BigDecimal bigDecimal = BigDecimal.ZERO;
                for (Object value : values) {
                    void var16_29;
                    if (value == null) continue;
                    BigDecimal bigDecimal2 = ((BigDecimal)var16_29).add(this.toBigDecimal(value));
                }
            } else if (basicCondition.getAggregateFunction() == AggregateFunction.MIN.getValue()) {
                Object var16_31 = null;
                for (Object value : values) {
                    void var16_32;
                    if (var16_32 == null || value == null) {
                        Object e = value;
                        continue;
                    }
                    if (var16_32 instanceof Comparable && value instanceof Comparable) {
                        if (((Comparable)var16_32).compareTo((Comparable)value) >= 0) continue;
                        Object e = value;
                        continue;
                    }
                    if (var16_32.toString().compareTo(value.toString()) >= 0) continue;
                    Object e = value;
                }
            } else if (basicCondition.getAggregateFunction() == AggregateFunction.MAX.getValue()) {
                Object var16_36 = null;
                for (Object value : values) {
                    void var16_37;
                    if (var16_37 == null || value == null) {
                        Object e = value;
                        continue;
                    }
                    if (var16_37 instanceof Comparable && value instanceof Comparable) {
                        if (((Comparable)var16_37).compareTo((Comparable)value) <= 0) continue;
                        Object e = value;
                        continue;
                    }
                    if (var16_37.toString().compareTo(value.toString()) <= 0) continue;
                    Object e = value;
                }
            } else if (basicCondition.getAggregateFunction() == AggregateFunction.COUNT.getValue()) {
                Integer n = values.size();
            } else if (basicCondition.getAggregateFunction() == AggregateFunction.TOSTRING.getValue()) {
                String string = "";
                String sep = "";
                for (Object value : values) {
                    void var16_43;
                    if (value == null) continue;
                    String stringifiedValue = null;
                    stringifiedValue = value instanceof Date ? DateTimeFormat.BASIC_UTC_FORMAT.format((Date)value) : (value instanceof Path ? ((Path)value).getLastSegment().toString() : value.toString());
                    String string2 = var16_43 + sep + stringifiedValue;
                    sep = " ";
                }
            }
            if (var16_45 == null) {
                String string = "";
            } else if (var16_45 instanceof Date) {
                String string = DateTimeFormat.BASIC_UTC_FORMAT.format((Date)var16_45);
            }
            if (basicCondition.getCondition() == ConditionType.IS_IN.code()) {
                result = false;
                for (String argument : basicCondition.getConditionArgument()) {
                    if (!argument.equals(var16_48.toString())) continue;
                    result = true;
                    break;
                }
            } else if (basicCondition.getCondition() == ConditionType.IS_NOT_IN.code()) {
                result = true;
                for (String argument : basicCondition.getConditionArgument()) {
                    if (!argument.equals(var16_48.toString())) continue;
                    result = false;
                    break;
                }
            } else if (basicCondition.getCondition() == ConditionType.IS_LESS_OR_EQUAL.code()) {
                result = var16_48 instanceof Number ? Boolean.valueOf(this.toBigDecimal(var16_48).compareTo(this.toBigDecimal(basicCondition.getConditionArgument().get(0))) <= 0) : Boolean.valueOf(var16_48.toString().compareTo(basicCondition.getConditionArgument().get(0)) <= 0);
            } else if (basicCondition.getCondition() == ConditionType.IS_LESS.code()) {
                result = var16_48 instanceof Number ? Boolean.valueOf(this.toBigDecimal(var16_48).compareTo(this.toBigDecimal(basicCondition.getConditionArgument().get(0))) < 0) : Boolean.valueOf(var16_48.toString().compareTo(basicCondition.getConditionArgument().get(0)) < 0);
            } else if (basicCondition.getCondition() == ConditionType.IS_GREATER_OR_EQUAL.code()) {
                result = var16_48 instanceof Number ? Boolean.valueOf(this.toBigDecimal(var16_48).compareTo(this.toBigDecimal(basicCondition.getConditionArgument().get(0))) >= 0) : Boolean.valueOf(var16_48.toString().compareTo(basicCondition.getConditionArgument().get(0)) >= 0);
            } else if (basicCondition.getCondition() == ConditionType.IS_BETWEEN.code()) {
                if (var16_48 instanceof Number) {
                    result = this.toBigDecimal(var16_48).compareTo(this.toBigDecimal(basicCondition.getConditionArgument().get(0))) >= 0 & this.toBigDecimal(var16_48).compareTo(this.toBigDecimal(basicCondition.getConditionArgument().get(1))) <= 0;
                }
            } else if (basicCondition.getCondition() == ConditionType.IS_OUTSIDE.code()) {
                if (var16_48 instanceof Number) {
                    result = this.toBigDecimal(var16_48).compareTo(this.toBigDecimal(basicCondition.getConditionArgument().get(0))) < 0 || this.toBigDecimal(var16_48).compareTo(this.toBigDecimal(basicCondition.getConditionArgument().get(1))) > 0;
                }
            } else if (basicCondition.getCondition() == ConditionType.IS_GREATER.code()) {
                result = var16_48 instanceof Number ? Boolean.valueOf(this.toBigDecimal(var16_48).compareTo(this.toBigDecimal(basicCondition.getConditionArgument().get(0))) > 0) : Boolean.valueOf(var16_48.toString().compareTo(basicCondition.getConditionArgument().get(0)) > 0);
            } else if (basicCondition.getCondition() == ConditionType.IS_LIKE.code()) {
                result = false;
                for (String argument : basicCondition.getConditionArgument()) {
                    if (!var16_48.toString().matches(argument)) continue;
                    result = true;
                }
            } else if (basicCondition.getCondition() == ConditionType.IS_UNLIKE.code()) {
                result = true;
                for (String argument : basicCondition.getConditionArgument()) {
                    if (!var16_48.toString().matches(argument)) continue;
                    result = false;
                }
            }
            comment = (String)comment + " \u2192 " + var16_48.toString();
        }
        if (statusMessage.length() > 0) {
            statusMessage.append(", ");
        }
        statusMessage.append("{\"name\": \"" + condition.getName() + "\", \"value\": " + result + ", \"comment\": \"" + (String)comment + "\"}");
        return result;
    }

    public ValidateObjectResult validateObject(ObjectValidator objectValidator, ContextCapable object, Date validationTime, List<String> selectors, org.openmdx.base.cci2.ContextCapable anchor, List<ValidatorCondition> includes, List<ValidatorCondition> excludes) throws ServiceException {
        Boolean isValid = false;
        short statusCode = 0;
        StringBuffer validationResult = new StringBuffer("");
        if (objectValidator.getMainCondition() != null) {
            isValid = this.evaluateCondition(objectValidator.getMainCondition(), object, validationTime, selectors, (org.openmdx.base.cci2.ContextCapable)(anchor == null ? objectValidator.getAnchor() : anchor), includes, excludes, validationResult);
        }
        return (ValidateObjectResult)Structures.create(ValidateObjectResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)ValidateObjectResult.Member.isValid, (Object)isValid), Datatypes.member((Enum)ValidateObjectResult.Member.statusMessage, (Object)("{\"validationResult\": [" + validationResult.toString() + "]}")), Datatypes.member((Enum)ValidateObjectResult.Member.statusCode, (Object)statusCode)});
    }

    public static enum BooleanOperator {
        NA(0),
        AND(1),
        OR(2);

        private short value;

        private BooleanOperator(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }
    }

    public static enum AggregateFunction {
        NA(0),
        COUNT(1),
        SUM(2),
        MIN(3),
        MAX(4),
        AVG(5),
        TOSTRING(6);

        private short value;

        private AggregateFunction(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }
    }

    public class SequenceBasedValueRangeProvider
    implements ValueRangeProvider {
        private int nextValue;
        private int incrementValue;

        public SequenceBasedValueRangeProvider(Integer startValue, Integer nextValue, Integer incrementValue) {
            this.nextValue = nextValue == null ? startValue : nextValue;
            this.incrementValue = incrementValue == null ? 1 : incrementValue;
        }

        @Override
        public int getNextValue() {
            int nextValue = this.nextValue;
            this.nextValue += this.incrementValue;
            return nextValue;
        }
    }

    public static interface ValueRangeProvider {
        public int getNextValue();
    }
}

