/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.Extent;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jmi.reflect.RefObject;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.depot1.cci2.BookingPeriod;
import org.opencrx.kernel.depot1.cci2.BookingPeriodQuery;
import org.opencrx.kernel.depot1.cci2.BookingTextQuery;
import org.opencrx.kernel.depot1.cci2.CompoundBookingQuery;
import org.opencrx.kernel.depot1.cci2.CreditBookingQuery;
import org.opencrx.kernel.depot1.cci2.DepotEntityHasBookingPeriod;
import org.opencrx.kernel.depot1.cci2.DepotPositionQuery;
import org.opencrx.kernel.depot1.cci2.DepotQuery;
import org.opencrx.kernel.depot1.cci2.DepotReportItemPositionQuery;
import org.opencrx.kernel.depot1.cci2.DepotReportQuery;
import org.opencrx.kernel.depot1.cci2.InventoryLevelQuery;
import org.opencrx.kernel.depot1.cci2.ProductDepotPositionQuery;
import org.opencrx.kernel.depot1.cci2.SimpleBookingQuery;
import org.opencrx.kernel.depot1.cci2.SingleBookingQuery;
import org.opencrx.kernel.depot1.jmi1.AbstractFilterCompoundBooking;
import org.opencrx.kernel.depot1.jmi1.AbstractFilterSimpleBooking;
import org.opencrx.kernel.depot1.jmi1.AbstractFilterSingleBooking;
import org.opencrx.kernel.depot1.jmi1.BookingOrigin;
import org.opencrx.kernel.depot1.jmi1.BookingTemplate;
import org.opencrx.kernel.depot1.jmi1.BookingText;
import org.opencrx.kernel.depot1.jmi1.CompoundBooking;
import org.opencrx.kernel.depot1.jmi1.CreditBooking;
import org.opencrx.kernel.depot1.jmi1.DebitBooking;
import org.opencrx.kernel.depot1.jmi1.Depot;
import org.opencrx.kernel.depot1.jmi1.DepotEntity;
import org.opencrx.kernel.depot1.jmi1.DepotGroup;
import org.opencrx.kernel.depot1.jmi1.DepotHolder;
import org.opencrx.kernel.depot1.jmi1.DepotPosition;
import org.opencrx.kernel.depot1.jmi1.DepotReport;
import org.opencrx.kernel.depot1.jmi1.DepotReportItemPosition;
import org.opencrx.kernel.depot1.jmi1.DepotType;
import org.opencrx.kernel.depot1.jmi1.EMailAddress;
import org.opencrx.kernel.depot1.jmi1.InventoryLevel;
import org.opencrx.kernel.depot1.jmi1.PhoneNumber;
import org.opencrx.kernel.depot1.jmi1.ProductDepotPosition;
import org.opencrx.kernel.depot1.jmi1.Segment;
import org.opencrx.kernel.depot1.jmi1.SimpleBooking;
import org.opencrx.kernel.depot1.jmi1.SingleBooking;
import org.opencrx.kernel.depot1.jmi1.UriAddress;
import org.opencrx.kernel.generic.jmi1.CrxObject;
import org.opencrx.kernel.product1.jmi1.Product;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.persistence.cci.UserObjects;
import org.openmdx.base.rest.cci.QueryExtensionRecord;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.format.DateTimeFormat;

public class Depots
extends AbstractImpl {
    public static void register() {
        Depots.registerImpl(new Depots());
    }

    public static Depots getInstance() throws ServiceException {
        return Depots.getInstance(Depots.class);
    }

    protected Depots() {
    }

    public Segment getDepotSegment(PersistenceManager pm, String providerName, String segmentName) {
        return (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.depot1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
    }

    public void assertOpenPosition(Date valueDate, short bookingType, DepotPosition depotPosition) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)depotPosition);
        DepotEntity depotEntity = (DepotEntity)pm.getObjectById((Object)depotPosition.refGetPath().getPrefix(7));
        DepotEntityHasBookingPeriod.BookingPeriod bookingPeriods = depotEntity.getBookingPeriod();
        Depot depot = (Depot)pm.getObjectById((Object)depotPosition.refGetPath().getParent().getParent());
        String depotNumber = depot.getDepotNumber();
        String positionName = depotPosition.getName();
        if (depotPosition.isLocked()) {
            throw new ServiceException("OpenCrxDomain", 1216, "Depot position is locked", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)depotNumber), new BasicException.Parameter("param1", (Object)positionName)});
        }
        if (depotPosition.getClosingDate() != null && valueDate.compareTo(depotPosition.getClosingDate()) >= 0) {
            throw new ServiceException("OpenCrxDomain", 1217, "Depot position is closed", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)depotNumber), new BasicException.Parameter("param1", (Object)positionName), new BasicException.Parameter("param2", (Object)depotPosition.getClosingDate())});
        }
        if (depotPosition.getOpeningDate() != null && valueDate.compareTo(depotPosition.getOpeningDate()) < 0) {
            throw new ServiceException("OpenCrxDomain", 1218, "Depot position is not open", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)depotNumber), new BasicException.Parameter("param1", (Object)positionName), new BasicException.Parameter("param2", (Object)depotPosition.getOpeningDate())});
        }
        if (depot.isLocked()) {
            throw new ServiceException("OpenCrxDomain", 1213, "Depot is locked", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)depotNumber)});
        }
        if (depot.getClosingDate() != null && valueDate.compareTo(depot.getClosingDate()) >= 0) {
            throw new ServiceException("OpenCrxDomain", 1214, "Depot is closed", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)depotNumber), new BasicException.Parameter("param1", (Object)depot.getClosingDate())});
        }
        if (depot.getOpeningDate() != null && valueDate.compareTo(depot.getOpeningDate()) < 0) {
            throw new ServiceException("OpenCrxDomain", 1215, "Depot is not open", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)depotNumber), new BasicException.Parameter("param1", (Object)depot.getOpeningDate())});
        }
        BookingPeriod bookingPeriod = null;
        Iterator iterator = bookingPeriods.iterator();
        while (iterator.hasNext()) {
            org.opencrx.kernel.depot1.jmi1.BookingPeriod period = (org.opencrx.kernel.depot1.jmi1.BookingPeriod)iterator.next();
            Date periodStartsAt = period.getPeriodStartsAt();
            Date periodEndsAtExclusive = period.getPeriodEndsAtExclusive();
            if (periodStartsAt != null && valueDate.compareTo(periodStartsAt) < 0 || periodEndsAtExclusive != null && valueDate.compareTo(periodEndsAtExclusive) >= 0) continue;
            bookingPeriod = period;
            break;
        }
        if (bookingPeriod == null) {
            throw new ServiceException("OpenCrxDomain", 1210, "No booking period found for value date", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)valueDate)});
        }
        String bookingPeriodName = bookingPeriod.getName();
        if (bookingPeriod.isFinal() != null && bookingPeriod.isFinal().booleanValue()) {
            throw new ServiceException("OpenCrxDomain", 1212, "Booking period is final", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)bookingPeriodName)});
        }
        if (bookingPeriod.isClosed() != null && bookingPeriod.isClosed().booleanValue() && bookingType <= bookingPeriod.getClosingBookingTypeThreshold()) {
            throw new ServiceException("OpenCrxDomain", 1211, "Booking period is closed", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)bookingPeriodName), new BasicException.Parameter("param1", bookingPeriod.getClosingBookingTypeThreshold())});
        }
    }

    public void assertCreditBalance(CompoundBooking cb, BigDecimal balance) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)cb);
        Segment depotSegment = this.getDepotSegment(pm, cb.refGetPath().getSegment(2).toString(), cb.refGetPath().getSegment(4).toString());
        CreditBookingQuery creditBookingQuery = (CreditBookingQuery)pm.newQuery(CreditBooking.class);
        creditBookingQuery.thereExistsCb().equalTo(cb);
        List creditBookings = depotSegment.getBooking(creditBookingQuery);
        BigDecimal compoundBalance = BigDecimal.ZERO;
        for (CreditBooking booking : creditBookings) {
            compoundBalance = compoundBalance.add(booking.getQuantityCredit());
        }
        if (compoundBalance.compareTo(balance) != 0) {
            throw new ServiceException("OpenCrxDomain", 1219, "Balance mismatch", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)compoundBalance), new BasicException.Parameter("param1", (Object)balance)});
        }
    }

    public BookingText findBookingText(DepotEntity depotEntity, String bookingTextName) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)depotEntity);
        BookingTextQuery bookingTextQuery = (BookingTextQuery)pm.newQuery(BookingText.class);
        bookingTextQuery.name().equalTo((Object)bookingTextName);
        List texts = depotEntity.getBookingText(bookingTextQuery);
        return texts.isEmpty() ? null : (BookingText)texts.iterator().next();
    }

    public String getCompoundBookingName(DepotPosition positionCredit, DepotPosition positionDebit, BookingText bookingText) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)positionCredit);
        String positionNameCredit = positionCredit.getName();
        Depot depotCredit = (Depot)pm.getObjectById((Object)positionCredit.refGetPath().getParent().getParent());
        String depotNumberCredit = depotCredit.getDepotNumber();
        Depot depotDebit = (Depot)pm.getObjectById((Object)positionDebit.refGetPath().getParent().getParent());
        String depotNumberDebit = depotDebit.getDepotNumber();
        String compoundBookingName = null;
        compoundBookingName = !bookingText.isCreditFirst() ? depotNumberCredit + " " + bookingText.getCbNameInfix1() + " " + positionNameCredit + " " + bookingText.getCbNameInfix2() + " " + depotNumberDebit : depotNumberDebit + " " + bookingText.getCbNameInfix1() + " " + positionNameCredit + " " + bookingText.getCbNameInfix2() + " " + depotNumberCredit;
        return compoundBookingName;
    }

    public String getCreditBookingName(DepotPosition depotPosition, BookingText bookingText, String bookingTextSuffix) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)depotPosition);
        String positionName = depotPosition.getName();
        Depot depot = (Depot)pm.getObjectById((Object)depotPosition.refGetPath().getParent().getParent());
        String depotNumber = depot.getDepotNumber();
        return (depotNumber + " " + bookingText.getCreditBookingNameInfix() + " " + positionName + (bookingTextSuffix == null ? "" : bookingTextSuffix)).trim();
    }

    public String getDebitBookingName(DepotPosition depotPosition, BookingText bookingText, String bookingTextSuffix) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)depotPosition);
        String positionName = depotPosition.getName();
        Depot depot = (Depot)pm.getObjectById((Object)depotPosition.refGetPath().getParent().getParent());
        String depotNumber = depot.getDepotNumber();
        return (depotNumber + " " + bookingText.getDebitBookingNameInfix() + " " + positionName + (bookingTextSuffix == null ? "" : bookingTextSuffix)).trim();
    }

    public CompoundBooking createCreditDebitBooking(DepotEntity depotEntity, Date valueDate, short bookingType, BigDecimal quantity, String bookingTextName, BookingText bookingText, DepotPosition positionCredit, DepotPosition positionDebit, BookingOrigin originIdentity, String bookingTextSuffix, List<String> errors) throws ServiceException {
        if (bookingText == null && bookingTextName != null) {
            bookingText = this.findBookingText(depotEntity, bookingTextName);
        }
        if (bookingText == null) {
            throw new ServiceException("OpenCrxDomain", 1200, "Missing booking text", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)bookingTextName)});
        }
        if (positionCredit.getName() == null || positionDebit.getName() == null || !positionCredit.getName().equals(positionDebit.getName())) {
            throw new ServiceException("OpenCrxDomain", 1204, "position names debit/credit do not match", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)positionCredit.getName()), new BasicException.Parameter("param1", (Object)positionDebit.getName())});
        }
        CompoundBooking compoundBooking = this.createCompoundBooking(depotEntity, this.getCompoundBookingName(positionCredit, positionDebit, bookingText), bookingType);
        this.appendBookings(compoundBooking, valueDate, bookingType, false, new Boolean[]{Boolean.TRUE, Boolean.FALSE}, new BigDecimal[]{quantity, quantity}, new BookingText[]{bookingText, bookingText}, new DepotPosition[]{positionCredit, positionDebit}, new BookingOrigin[]{originIdentity, originIdentity}, new String[]{bookingTextSuffix, bookingTextSuffix}, null, errors);
        return compoundBooking;
    }

    public void validateBookings(Date valueDate, short bookingType, Boolean noBalanceValidation, Boolean[] isCreditBookings, BigDecimal[] quantities, BookingText[] bookingTexts, DepotPosition[] depotPositions, BookingOrigin[] origins, List<String> errors) throws ServiceException {
        if (depotPositions == null || depotPositions.length == 0) {
            errors.add("Missing depot positions");
            return;
        }
        int numberOfPositions = depotPositions.length;
        if (isCreditBookings == null || isCreditBookings.length != numberOfPositions || quantities == null || quantities.length != numberOfPositions || bookingTexts == null || bookingTexts.length != numberOfPositions || origins == null || origins.length != numberOfPositions) {
            errors.add("Number of quantities, booking texts, depot positions and origins must match");
            return;
        }
        int index = 0;
        for (DepotPosition depotPosition : depotPositions) {
            if (depotPosition == null) {
                errors.add("depot position at index " + index + " is empty");
            }
            ++index;
        }
        index = 0;
        for (CrxObject crxObject : bookingTexts) {
            if (crxObject != null) continue;
            errors.add("booking text at index " + index + " is empty");
        }
        index = 0;
        for (BigDecimal bigDecimal : quantities) {
            if (bigDecimal == null) {
                errors.add("quantity at index " + index + " is empty");
            }
            ++index;
        }
        if (!errors.isEmpty()) {
            return;
        }
        BigDecimal balanceCredit = BigDecimal.ZERO;
        BigDecimal balanceDebit = BigDecimal.ZERO;
        index = 0;
        for (BigDecimal quantity : quantities) {
            if (Boolean.TRUE.equals(isCreditBookings[index])) {
                balanceCredit = balanceCredit.add(quantity);
            } else {
                balanceDebit = balanceDebit.add(quantity);
            }
            ++index;
        }
        if (!Boolean.TRUE.equals(noBalanceValidation) && balanceCredit.compareTo(balanceDebit) != 0) {
            errors.add("balance credit / debit mismatch {balanceCredit: " + balanceCredit + "; balanceDebit: " + balanceDebit + "}");
        }
    }

    public List<SingleBooking> appendBookings(CompoundBooking compoundBooking, Date valueDate, short bookingType, Boolean noBalanceValidation, Boolean[] isCreditBookings, BigDecimal[] quantities, BookingText[] bookingTexts, DepotPosition[] depotPositions, BookingOrigin[] origins, String[] bookingTextSuffixes, String[] bookingIds, List<String> errors) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)compoundBooking);
        Segment depotSegment = this.getDepotSegment(pm, compoundBooking.refGetPath().getSegment(2).toString(), compoundBooking.refGetPath().getSegment(4).toString());
        if (compoundBooking.isLocked()) {
            throw new ServiceException("OpenCrxDomain", 1216, "Booking is locked. Append is not allowed.", new BasicException.Parameter[0]);
        }
        if (compoundBooking.getBookingStatus() != BookingStatus.PENDING.getValue()) {
            throw new ServiceException("OpenCrxDomain", 1223, "Booking status must be pending. Append is not allowed.", new BasicException.Parameter[0]);
        }
        this.validateBookings(valueDate, bookingType, noBalanceValidation, isCreditBookings, quantities, bookingTexts, depotPositions, origins, errors);
        if (!errors.isEmpty()) {
            throw new ServiceException("OpenCrxDomain", 1201, "Invalid compound booking.", new BasicException.Parameter[0]);
        }
        if (valueDate == null) {
            valueDate = new Date();
        }
        for (DepotPosition position : depotPositions) {
            this.assertOpenPosition(valueDate, bookingType, position);
        }
        ArrayList<SingleBooking> bookings = new ArrayList<SingleBooking>();
        Date bookingDate = new Date();
        for (int i = 0; i < depotPositions.length; ++i) {
            String bookingTextSuffix;
            DepotPosition depotPosition = depotPositions[i];
            SingleBooking booking = null;
            String string = bookingTextSuffixes == null ? null : (bookingTextSuffix = i < bookingTextSuffixes.length ? bookingTextSuffixes[i] : null);
            if (Boolean.TRUE.equals(isCreditBookings[i])) {
                CreditBooking creditBooking = (CreditBooking)pm.newInstance(CreditBooking.class);
                creditBooking.setQuantityCredit(quantities[i]);
                creditBooking.setName(this.getCreditBookingName(depotPosition, bookingTexts[i], bookingTextSuffix));
                creditBooking.setBookingText(bookingTexts[i]);
                bookings.add(creditBooking);
                booking = creditBooking;
            } else {
                DebitBooking debitBooking = (DebitBooking)pm.newInstance(DebitBooking.class);
                debitBooking.setQuantityDebit(quantities[i]);
                debitBooking.setName(this.getDebitBookingName(depotPosition, bookingTexts[i], bookingTextSuffix));
                debitBooking.setBookingText(bookingTexts[i]);
                bookings.add(debitBooking);
                booking = debitBooking;
            }
            booking.setValueDate(valueDate);
            booking.setBookingType(new Short(bookingType));
            booking.setBookingStatus(BookingStatus.PENDING.getValue());
            booking.setBookingDate(bookingDate);
            booking.setPosition(depotPosition);
            booking.setCb(compoundBooking);
            if (origins[i] != null) {
                booking.setOrigin(origins[i]);
            }
            depotSegment.addBooking(bookingIds == null ? this.getUidAsString() : bookingIds[i], booking);
        }
        return bookings;
    }

    public CompoundBooking createCompoundBooking(DepotEntity depotEntity, String name, short bookingType) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)depotEntity);
        Segment depotSegment = this.getDepotSegment(pm, depotEntity.refGetPath().getSegment(2).toString(), depotEntity.refGetPath().getSegment(4).toString());
        Date bookingDate = new Date();
        CompoundBooking compoundBooking = (CompoundBooking)pm.newInstance(CompoundBooking.class);
        compoundBooking.setName(name);
        compoundBooking.setBookingType(new Short(bookingType));
        compoundBooking.setBookingStatus(BookingStatus.PENDING.getValue());
        compoundBooking.setBookingDate(bookingDate);
        depotSegment.addCb(this.getUidAsString(), compoundBooking);
        return compoundBooking;
    }

    public DepotPosition getAndCreateDepotPosition(DepotEntity depotEntity, String depotNumber, Depot depot, String positionName, Product product, Date openingDate) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)depotEntity);
        if (depot == null) {
            if (depotNumber == null) {
                throw new ServiceException("OpenCrxDomain", 1208, "Missing depot number", new BasicException.Parameter[0]);
            }
            DepotQuery depotQuery = (DepotQuery)pm.newQuery(Depot.class);
            depotQuery.depotNumber().equalTo((Object)depotNumber);
            List depots = depotEntity.getDepot(depotQuery);
            if (!depots.isEmpty()) {
                depot = (Depot)depots.iterator().next();
            } else {
                throw new ServiceException("OpenCrxDomain", 1209, "Depot not found", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)depotNumber)});
            }
        }
        DepotPositionQuery depotPositionQuery = (DepotPositionQuery)pm.newQuery(DepotPosition.class);
        depotPositionQuery.name().equalTo((Object)positionName);
        List depotPositions = depot.getPosition(depotPositionQuery);
        if (!depotPositions.isEmpty()) {
            return (DepotPosition)depotPositions.iterator().next();
        }
        if (depot.isAllowPositionAutoCreate()) {
            return this.openDepotPosition(depot, positionName, null, openingDate, null, product, Boolean.FALSE);
        }
        return null;
    }

    public CompoundBooking createBookingByPosition(DepotEntity depotEntity, Date valueDate, short bookingType, BigDecimal quantity, String bookingTextName, BookingText bookingText, DepotPosition positionCredit, DepotPosition positionDebit, BookingOrigin origin, String bookingTextSuffix, List<String> errors) throws ServiceException {
        return this.createCreditDebitBooking(depotEntity, valueDate, bookingType, quantity, bookingTextName, bookingText, positionCredit, positionDebit, origin, bookingTextSuffix, errors);
    }

    public CompoundBooking createBookingByProduct(DepotEntity depotEntity, Date valueDate, short bookingType, BigDecimal quantity, String bookingTextName, BookingText bookingText, Product product, String depotNumberCredit, Depot depotCredit, String depotNumberDebit, Depot depotDebit, BookingOrigin origin, String bookingTextSuffix, List<String> errors) throws ServiceException {
        if (product == null) {
            throw new ServiceException("OpenCrxDomain", 1205, "Missing product", new BasicException.Parameter[0]);
        }
        String positionName = product.getProductNumber() != null ? product.getProductNumber() : product.getName();
        DepotPosition positionCredit = this.getAndCreateDepotPosition(depotEntity, depotNumberCredit, depotCredit, positionName, product, valueDate);
        if (positionCredit == null) {
            throw new ServiceException("OpenCrxDomain", 1206, "Can not get/create credit depot position", new BasicException.Parameter[0]);
        }
        DepotPosition positionDebit = this.getAndCreateDepotPosition(depotEntity, depotNumberDebit, depotDebit, positionName, product, valueDate);
        if (positionDebit == null) {
            throw new ServiceException("OpenCrxDomain", 1207, "Can not get/create debit depot position", new BasicException.Parameter[0]);
        }
        return this.createCreditDebitBooking(depotEntity, valueDate, bookingType, quantity, bookingTextName, bookingText, positionCredit, positionDebit, origin, bookingTextSuffix, errors);
    }

    public CompoundBooking createBookingByPositionName(DepotEntity depotEntity, Date valueDate, short bookingType, BigDecimal quantity, String bookingTextName, BookingText bookingText, String positionName, String depotNumberCredit, Depot depotCredit, String depotNumberDebit, Depot depotDebit, BookingOrigin origin, String bookingTextSuffix, List<String> errors) throws ServiceException {
        DepotPosition positionCredit = this.getAndCreateDepotPosition(depotEntity, depotNumberCredit, depotCredit, positionName, null, valueDate);
        if (positionCredit == null) {
            throw new ServiceException("OpenCrxDomain", 1206, "Can not get/create credit depot position", new BasicException.Parameter[0]);
        }
        DepotPosition positionDebit = this.getAndCreateDepotPosition(depotEntity, depotNumberDebit, depotDebit, positionName, null, valueDate);
        if (positionDebit == null) {
            throw new ServiceException("OpenCrxDomain", 1207, "Can not get/create debit depot position", new BasicException.Parameter[0]);
        }
        return this.createCreditDebitBooking(depotEntity, valueDate, bookingType, quantity, bookingTextName, bookingText, positionCredit, positionDebit, origin, bookingTextSuffix, errors);
    }

    public String getDepotReportItemPositionName(DepotPosition depotPosition) throws ServiceException {
        return depotPosition.getName();
    }

    public void refreshReport(Depot depot, DepotReport report, DepotReport reportPreviousPeriod, List<DepotPosition> includePositions, List<DepotPosition> excludePositions) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)depot);
        Segment depotSegment = this.getDepotSegment(pm, depot.refGetPath().getSegment(2).toString(), depot.refGetPath().getSegment(4).toString());
        if (report.isDraft()) {
            int FETCH_SIZE = 500;
            HashMap<DepotPosition, DepotReportItemPosition> depotReportItemPositions = new HashMap<DepotPosition, DepotReportItemPosition>();
            DepotReportItemPositionQuery depotReportItemPositionQuery = (DepotReportItemPositionQuery)pm.newQuery(DepotReportItemPosition.class);
            ((Query)depotReportItemPositionQuery).getFetchPlan().setFetchSize(500);
            for (DepotReportItemPosition depotReportItemPosition : report.getItemPosition(depotReportItemPositionQuery)) {
                if (!includePositions.isEmpty() && !includePositions.contains(depotReportItemPosition.getPosition()) || !excludePositions.isEmpty() && excludePositions.contains(depotReportItemPosition.getPosition())) continue;
                depotReportItemPositions.put(depotReportItemPosition.getPosition(), depotReportItemPosition);
            }
            org.opencrx.kernel.depot1.jmi1.BookingPeriod bookingPeriod = report.getBookingPeriod();
            Date periodStartsAt = bookingPeriod.getPeriodStartsAt();
            HashMap<org.opencrx.kernel.depot1.cci2.DepotPosition, DepotReportItem> reportItems = new HashMap<org.opencrx.kernel.depot1.cci2.DepotPosition, DepotReportItem>();
            DepotPositionQuery depotPositionQuery = (DepotPositionQuery)pm.newQuery(DepotPosition.class);
            ((Query)depotPositionQuery).getFetchPlan().setFetchSize(500);
            for (DepotPosition position : depot.getPosition(depotPositionQuery)) {
                boolean excludePosition;
                boolean includePosition = includePositions.isEmpty() || includePositions.contains(position);
                boolean bl = excludePosition = !excludePositions.isEmpty() && excludePositions.contains(position);
                if (!includePosition || excludePosition) continue;
                DepotReportItem reportItem = new DepotReportItem();
                reportItems.put(position, reportItem);
            }
            if (reportPreviousPeriod != null) {
                Iterator iterator = reportPreviousPeriod.getItemPosition().iterator();
                while (iterator.hasNext()) {
                    boolean isOpen;
                    DepotReportItemPosition reportItemPreviousPeriod = (DepotReportItemPosition)iterator.next();
                    DepotPosition position = reportItemPreviousPeriod.getPosition();
                    boolean includePosition = includePositions.isEmpty() || includePositions.contains(position);
                    boolean excludePosition = !excludePositions.isEmpty() && excludePositions.contains(position);
                    boolean bl = isOpen = position.getClosingDate() == null || periodStartsAt != null && periodStartsAt.compareTo(position.getClosingDate()) <= 0;
                    if (!includePosition || excludePosition || !isOpen) continue;
                    DepotReportItem reportItem = new DepotReportItem();
                    reportItems.put(position, reportItem);
                    reportItem.setBalanceBop(reportItemPreviousPeriod.getBalance());
                    reportItem.setBalanceCreditBop(reportItemPreviousPeriod.getBalanceCredit());
                    reportItem.setBalanceDebitBop(reportItemPreviousPeriod.getBalanceDebit());
                    reportItem.setBalanceCredit(reportItemPreviousPeriod.getBalanceCredit());
                    reportItem.setBalanceDebit(reportItemPreviousPeriod.getBalanceDebit());
                    reportItem.setBalanceSimpleBop(reportItemPreviousPeriod.getBalanceSimple());
                    reportItem.setBalanceSimple(reportItemPreviousPeriod.getBalanceSimple());
                }
            }
            SingleBookingQuery singleBookingQuery = (SingleBookingQuery)pm.newQuery(SingleBooking.class);
            singleBookingQuery.forAllDisabled().isFalse();
            if (!includePositions.isEmpty()) {
                singleBookingQuery.thereExistsPosition().elementOf(includePositions);
            } else {
                singleBookingQuery.thereExistsPosition().elementOf(PersistenceHelper.getCandidates((Extent)pm.getExtent(DepotPosition.class), (Object)depot.refGetPath().getDescendant(new String[]{"position", "%"})));
            }
            if (!excludePositions.isEmpty()) {
                singleBookingQuery.thereExistsPosition().notAnElementOf(excludePositions);
            }
            singleBookingQuery.bookingStatus().greaterThanOrEqualTo((Comparable)Short.valueOf(report.getBookingStatusThreshold()));
            if (bookingPeriod.getPeriodStartsAt() != null) {
                singleBookingQuery.valueDate().greaterThanOrEqualTo((Comparable)bookingPeriod.getPeriodStartsAt());
            }
            if (bookingPeriod.getPeriodEndsAtExclusive() != null) {
                singleBookingQuery.valueDate().lessThan((Comparable)bookingPeriod.getPeriodEndsAtExclusive());
            }
            ((Query)singleBookingQuery).getFetchPlan().setFetchSize(500);
            List singleBookings = depotSegment.getBooking(singleBookingQuery);
            for (SingleBooking singleBooking : singleBookings) {
                try {
                    org.opencrx.kernel.depot1.cci2.DepotPosition position = singleBooking.getPosition();
                    DepotReportItem reportItem = (DepotReportItem)reportItems.get(position);
                    if (reportItem == null) {
                        reportItem = new DepotReportItem();
                        reportItems.put(position, reportItem);
                    }
                    if (singleBooking instanceof CreditBooking) {
                        BigDecimal quantityCredit = ((CreditBooking)singleBooking).getQuantityCredit();
                        reportItem.setBalanceCredit(reportItem.getBalanceCredit().add(quantityCredit));
                        continue;
                    }
                    if (!(singleBooking instanceof DebitBooking)) continue;
                    BigDecimal quantityDebit = ((DebitBooking)singleBooking).getQuantityDebit();
                    reportItem.setBalanceDebit(reportItem.getBalanceDebit().add(quantityDebit));
                }
                catch (Exception e) {
                    SysLog.error((String)"Ignoring booking", (Object)singleBooking.refGetPath());
                    new ServiceException(e).log();
                }
            }
            SimpleBookingQuery simpleBookingQuery = (SimpleBookingQuery)pm.newQuery(SimpleBooking.class);
            if (!includePositions.isEmpty()) {
                simpleBookingQuery.thereExistsPosition().elementOf(includePositions);
            } else {
                simpleBookingQuery.thereExistsPosition().elementOf(PersistenceHelper.getCandidates((Extent)pm.getExtent(DepotPosition.class), (Object)depot.refGetPath().getDescendant(new String[]{"position", "%"})));
            }
            if (!excludePositions.isEmpty()) {
                simpleBookingQuery.thereExistsPosition().notAnElementOf(excludePositions);
            }
            simpleBookingQuery.bookingStatus().greaterThanOrEqualTo((Comparable)Short.valueOf(report.getBookingStatusThreshold()));
            if (bookingPeriod.getPeriodStartsAt() != null) {
                simpleBookingQuery.valueDate().greaterThanOrEqualTo((Comparable)bookingPeriod.getPeriodStartsAt());
            }
            if (bookingPeriod.getPeriodEndsAtExclusive() != null) {
                simpleBookingQuery.valueDate().lessThan((Comparable)bookingPeriod.getPeriodEndsAtExclusive());
            }
            ((Query)simpleBookingQuery).getFetchPlan().setFetchSize(500);
            List simpleBookings = depotSegment.getSimpleBooking(simpleBookingQuery);
            for (SimpleBooking simpleBooking : simpleBookings) {
                try {
                    org.opencrx.kernel.depot1.cci2.DepotPosition position = simpleBooking.getPosition();
                    DepotReportItem reportItem = (DepotReportItem)reportItems.get(position);
                    if (reportItem == null) {
                        reportItem = new DepotReportItem();
                        reportItems.put(position, reportItem);
                    }
                    BigDecimal quantity = simpleBooking.getQuantity();
                    reportItem.setBalanceSimple(reportItem.getBalanceSimple().add(quantity));
                }
                catch (Exception e) {
                    SysLog.error((String)"Ignoring booking", (Object)simpleBooking.refGetPath());
                    new ServiceException(e).log();
                }
            }
            for (Map.Entry entry : reportItems.entrySet()) {
                DepotPosition position = (DepotPosition)entry.getKey();
                DepotReportItem depotReportItem = (DepotReportItem)entry.getValue();
                DepotReportItemPosition depotReportItemPosition = null;
                if (!depotReportItemPositions.containsKey(position)) {
                    depotReportItemPosition = (DepotReportItemPosition)pm.newInstance(DepotReportItemPosition.class);
                    report.addItemPosition(this.getUidAsString(), depotReportItemPosition);
                } else {
                    depotReportItemPosition = (DepotReportItemPosition)depotReportItemPositions.get(position);
                }
                if (depotReportItemPosition.getAccessLevelBrowse() != report.getAccessLevelBrowse()) {
                    depotReportItemPosition.setAccessLevelBrowse(report.getAccessLevelBrowse());
                }
                if (depotReportItemPosition.getAccessLevelDelete() != report.getAccessLevelDelete()) {
                    depotReportItemPosition.setAccessLevelDelete(report.getAccessLevelDelete());
                }
                if (depotReportItemPosition.getAccessLevelUpdate() != report.getAccessLevelUpdate()) {
                    depotReportItemPosition.setAccessLevelUpdate(report.getAccessLevelUpdate());
                }
                String positionName = this.getDepotReportItemPositionName(position);
                if (!Utils.areEqual(depotReportItemPosition.getPositionName(), positionName)) {
                    depotReportItemPosition.setPositionName(positionName);
                }
                if (!Utils.areEqual(depotReportItemPosition.getValueDate(), periodStartsAt)) {
                    depotReportItemPosition.setValueDate(periodStartsAt);
                }
                if (!Utils.areEqual(depotReportItemPosition.getPosition(), position)) {
                    depotReportItemPosition.setPosition(position);
                }
                if (!Utils.areEqual(depotReportItemPosition.getBalanceBop(), depotReportItem.getBalanceBop())) {
                    depotReportItemPosition.setBalanceBop(depotReportItem.getBalanceBop());
                }
                if (!Utils.areEqual(depotReportItemPosition.getBalanceCreditBop(), depotReportItem.getBalanceCreditBop())) {
                    depotReportItemPosition.setBalanceCreditBop(depotReportItem.getBalanceCreditBop());
                }
                if (!Utils.areEqual(depotReportItemPosition.getBalanceDebitBop(), depotReportItem.getBalanceDebitBop())) {
                    depotReportItemPosition.setBalanceDebitBop(depotReportItem.getBalanceDebitBop());
                }
                if (!Utils.areEqual(depotReportItemPosition.getBalanceSimpleBop(), depotReportItem.getBalanceSimpleBop())) {
                    depotReportItemPosition.setBalanceSimpleBop(depotReportItem.getBalanceSimpleBop());
                }
                BigDecimal balance = depotReportItem.getBalanceCredit().subtract(depotReportItem.getBalanceDebit());
                if (!Utils.areEqual(depotReportItemPosition.getBalance(), balance)) {
                    depotReportItemPosition.setBalance(balance);
                }
                if (!Utils.areEqual(depotReportItemPosition.getBalanceCredit(), depotReportItem.getBalanceCredit())) {
                    depotReportItemPosition.setBalanceCredit(depotReportItem.getBalanceCredit());
                }
                if (!Utils.areEqual(depotReportItemPosition.getBalanceDebit(), depotReportItem.getBalanceDebit())) {
                    depotReportItemPosition.setBalanceDebit(depotReportItem.getBalanceDebit());
                }
                if (Utils.areEqual(depotReportItemPosition.getBalanceSimple(), depotReportItem.getBalanceSimple())) continue;
                depotReportItemPosition.setBalanceSimple(depotReportItem.getBalanceSimple());
            }
            depotReportItemPositions.keySet().removeAll(reportItems.keySet());
            for (DepotReportItemPosition depotReportItemPosition : depotReportItemPositions.values()) {
                depotReportItemPosition.refDelete();
            }
        }
    }

    public void assertReports(Depot depot, short bookingStatusThreshold, List<DepotPosition> includePositions, List<DepotPosition> excludePositions) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)depot);
        DepotEntity depotEntity = (DepotEntity)pm.getObjectById((Object)depot.refGetPath().getPrefix(7));
        BookingPeriodQuery bookingPeriodQuery = (BookingPeriodQuery)pm.newQuery(org.opencrx.kernel.depot1.jmi1.BookingPeriod.class);
        bookingPeriodQuery.orderByPeriodStartsAt().ascending();
        List bookingPeriods = depotEntity.getBookingPeriod(bookingPeriodQuery);
        DepotReport reportPreviousPeriod = null;
        boolean refreshedReportPreviousPeriod = false;
        DepotReport latestReport = null;
        for (org.opencrx.kernel.depot1.jmi1.BookingPeriod bookingPeriod : bookingPeriods) {
            boolean requiresReport;
            DepotReportQuery depotReportQuery = (DepotReportQuery)pm.newQuery(DepotReport.class);
            depotReportQuery.thereExistsBookingPeriod().equalTo(bookingPeriod);
            List reports = depot.getReport(depotReportQuery);
            DepotReport report = null;
            boolean requiresRefresh = false;
            boolean bl = requiresReport = depot.getClosingDate() == null || bookingPeriod.getPeriodStartsAt().compareTo(depot.getClosingDate()) <= 0;
            if (!reports.isEmpty()) {
                report = (DepotReport)reports.iterator().next();
                requiresRefresh = report.getModifiedAt().compareTo(bookingPeriod.getModifiedAt()) < 0;
                requiresReport = true;
            } else if (requiresReport) {
                DepotReport newReport = (DepotReport)pm.newInstance(DepotReport.class);
                newReport.setAccessLevelBrowse(depot.getAccessLevelBrowse());
                newReport.setAccessLevelDelete(depot.getAccessLevelDelete());
                newReport.setAccessLevelUpdate(depot.getAccessLevelUpdate());
                newReport.setName(bookingPeriod.getName());
                newReport.setDescription(bookingPeriod.getDescription());
                newReport.setDraft(Boolean.TRUE);
                newReport.setBookingStatusThreshold(new Short(bookingStatusThreshold));
                newReport.setBookingPeriod(bookingPeriod);
                depot.addReport(this.getUidAsString(), newReport);
                report = newReport;
                requiresRefresh = true;
            }
            Date currentDate = new Date();
            if (currentDate.compareTo(bookingPeriod.getPeriodStartsAt()) >= 0 && (bookingPeriod.getPeriodEndsAtExclusive() == null || currentDate.compareTo(bookingPeriod.getPeriodEndsAtExclusive()) < 0)) {
                latestReport = report;
            }
            if (!requiresReport) continue;
            if (refreshedReportPreviousPeriod || requiresRefresh || !Boolean.TRUE.equals(bookingPeriod.isFinal())) {
                Utils.touchObject((RefObject)report);
                this.refreshReport(depot, report, reportPreviousPeriod, includePositions, excludePositions);
                refreshedReportPreviousPeriod = true;
            }
            reportPreviousPeriod = report;
        }
        if (latestReport != null) {
            depot.setLatestReport(latestReport);
        }
    }

    public CompoundBooking cancelCompoundBooking(CompoundBooking cb, List<String> errors) throws ServiceException {
        short bookingType;
        boolean isFinal;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)cb);
        Segment depotSegment = this.getDepotSegment(pm, cb.refGetPath().getSegment(2).toString(), cb.refGetPath().getSegment(4).toString());
        boolean bl = isFinal = cb.getBookingStatus() == BookingStatus.FINAL.getValue();
        if (!isFinal) {
            throw new ServiceException("OpenCrxDomain", 1224, "Booking status must be final. Cancel is not allowed.", new BasicException.Parameter[0]);
        }
        short s = bookingType = cb.getBookingType() > 0 ? cb.getBookingType() : BookingType.STANDARD.getValue();
        if (bookingType == BookingType.REVERSAL.getValue()) {
            throw new ServiceException("OpenCrxDomain", 1220, "Can not cancel reversal booking", new BasicException.Parameter[0]);
        }
        CompoundBookingQuery cbQuery = (CompoundBookingQuery)pm.newQuery(CompoundBooking.class);
        cbQuery.thereExistsReversalOf().equalTo(cb);
        List compoundBookings = depotSegment.getCb(cbQuery);
        if (!compoundBookings.isEmpty()) {
            CompoundBooking reversal = (CompoundBooking)compoundBookings.iterator().next();
            throw new ServiceException("OpenCrxDomain", 1221, "Compound booking already cancelled", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)(reversal.getName() + " / " + reversal.getBookingDate()))});
        }
        CompoundBooking cancelCb = (CompoundBooking)pm.newInstance(CompoundBooking.class);
        if (cb.getName() != null) {
            cancelCb.setName(cb.getName());
        }
        if (cb.getDescription() != null) {
            cancelCb.setDescription(cb.getDescription());
        }
        cancelCb.setBookingDate(new Date());
        cancelCb.setBookingType(BookingType.REVERSAL.getValue());
        cancelCb.setBookingStatus(BookingStatus.PENDING.getValue());
        cancelCb.setReversalOf(cb);
        depotSegment.addCb(this.getUidAsString(), cancelCb);
        SingleBookingQuery singleBookingQuery = (SingleBookingQuery)pm.newQuery(SingleBooking.class);
        singleBookingQuery.thereExistsCb().equalTo(cb);
        List bookings = depotSegment.getBooking(singleBookingQuery);
        for (SingleBooking booking : bookings) {
            SingleBooking cancelBooking = null;
            if (booking instanceof CreditBooking) {
                cancelBooking = (SingleBooking)pm.newInstance(DebitBooking.class);
                ((DebitBooking)cancelBooking).setQuantityDebit(((CreditBooking)booking).getQuantityCredit());
            } else if (booking instanceof DebitBooking) {
                cancelBooking = (SingleBooking)pm.newInstance(CreditBooking.class);
                ((CreditBooking)cancelBooking).setQuantityCredit(((DebitBooking)booking).getQuantityDebit());
            }
            cancelBooking.setName(booking.getName());
            cancelBooking.setBookingText(booking.getBookingText());
            cancelBooking.setDescription(booking.getDescription());
            cancelBooking.setValueDate(booking.getValueDate());
            cancelBooking.setBookingDate(new Date());
            cancelBooking.setPosition(booking.getPosition());
            this.assertOpenPosition(cancelBooking.getValueDate(), BookingType.REVERSAL.getValue(), (DepotPosition)cancelBooking.getPosition());
            cancelBooking.setBookingType(BookingType.REVERSAL.getValue());
            cancelBooking.setBookingStatus(BookingStatus.PENDING.getValue());
            cancelBooking.setCb(cancelCb);
            depotSegment.addBooking(this.getUidAsString(), cancelBooking);
        }
        return cancelCb;
    }

    public void acceptCompoundBooking(CompoundBooking compoundBooking) throws ServiceException {
        boolean isPending;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)compoundBooking);
        boolean bl = isPending = compoundBooking.getBookingStatus() == BookingStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1223, "Booking status must be pending. Accept is not allowed.", new BasicException.Parameter[0]);
        }
        List principals = UserObjects.getPrincipalChain((PersistenceManager)pm);
        String acceptedBy = principals.isEmpty() ? "NA" : (String)principals.get(0) + " @ " + DateTimeFormat.BASIC_UTC_FORMAT.format(new Date());
        compoundBooking.getAcceptedBy().add(acceptedBy);
    }

    public void acceptInventoryLevel(InventoryLevel inventoryLevel) throws ServiceException {
        boolean isPending;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)inventoryLevel);
        boolean bl = isPending = inventoryLevel.getInventoryLevelStatus() == InventoryLevelStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1259, "Inventory level status must be pending. Accept is not allowed.", new BasicException.Parameter[0]);
        }
        List principals = UserObjects.getPrincipalChain((PersistenceManager)pm);
        String acceptedBy = principals.isEmpty() ? "NA" : (String)principals.get(0) + " @ " + DateTimeFormat.BASIC_UTC_FORMAT.format(new Date());
        inventoryLevel.getAcceptedBy().add(acceptedBy);
    }

    public void finalizeCompoundBooking(CompoundBooking cb) throws ServiceException {
        boolean isPending;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)cb);
        Segment depotSegment = this.getDepotSegment(pm, cb.refGetPath().getSegment(2).toString(), cb.refGetPath().getSegment(4).toString());
        boolean bl = isPending = cb.getBookingStatus() == BookingStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1223, "Booking status must be pending. Finalize is not allowed.", new BasicException.Parameter[0]);
        }
        SingleBookingQuery singleBookingQuery = (SingleBookingQuery)pm.newQuery(SingleBooking.class);
        singleBookingQuery.thereExistsCb().equalTo(cb);
        List bookings = depotSegment.getBooking(singleBookingQuery);
        for (SingleBooking booking : bookings) {
            this.assertOpenPosition(booking.getValueDate(), booking.getBookingType(), (DepotPosition)booking.getPosition());
            booking.setBookingStatus(BookingStatus.FINAL.getValue());
        }
        cb.setBookingStatus(BookingStatus.FINAL.getValue());
    }

    public void finalizeInventoryLevel(InventoryLevel inventoryLevel) throws ServiceException {
        boolean isPending;
        boolean bl = isPending = inventoryLevel.getInventoryLevelStatus() == InventoryLevelStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1259, "Inventory level status must be pending. Finalize is not allowed.", new BasicException.Parameter[0]);
        }
        inventoryLevel.setInventoryLevelStatus(InventoryLevelStatus.FINAL.getValue());
    }

    protected void removeCompoundBooking(CompoundBooking cb, boolean preDelete) throws ServiceException {
        boolean isPending;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)cb);
        Segment depotSegment = this.getDepotSegment(pm, cb.refGetPath().getSegment(2).toString(), cb.refGetPath().getSegment(4).toString());
        boolean bl = isPending = cb.getBookingStatus() == BookingStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1223, "Booking status is not pending. Delete is not allowed.", new BasicException.Parameter[0]);
        }
        boolean isLocked = cb.isLocked();
        if (isLocked) {
            throw new ServiceException("OpenCrxDomain", 1235, "Compound booking is locked. Delete is not allowed.", new BasicException.Parameter[0]);
        }
        SingleBookingQuery bookingQuery = (SingleBookingQuery)pm.newQuery(SingleBooking.class);
        bookingQuery.thereExistsCb().equalTo(cb);
        List bookings = depotSegment.getBooking(bookingQuery);
        for (SingleBooking booking : bookings) {
            booking.refDelete();
        }
        if (!preDelete) {
            cb.refDelete();
        }
    }

    protected void removeSimpleBooking(SimpleBooking simpleBooking, boolean preDelete) throws ServiceException {
        boolean isPending;
        boolean bl = isPending = simpleBooking.getBookingStatus() == BookingStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1223, "Booking status is not pending. Delete is not allowed.", new BasicException.Parameter[0]);
        }
        if (!preDelete) {
            simpleBooking.refDelete();
        }
    }

    protected void removeSingleBooking(SingleBooking singleBooking, boolean preDelete) throws ServiceException {
        boolean isPending;
        boolean bl = isPending = singleBooking.getBookingStatus() == BookingStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1223, "Booking status is not pending. Delete is not allowed.", new BasicException.Parameter[0]);
        }
        if (!preDelete) {
            singleBooking.refDelete();
        }
    }

    public boolean hasBookings(CrxObject bookingTarget) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)bookingTarget);
        Segment depotSegment = this.getDepotSegment(pm, bookingTarget.refGetPath().getSegment(2).toString(), bookingTarget.refGetPath().getSegment(4).toString());
        SingleBookingQuery bookingQuery = (SingleBookingQuery)pm.newQuery(SingleBooking.class);
        bookingQuery.thereExistsPosition().elementOf(PersistenceHelper.getCandidates((Extent)pm.getExtent(DepotPosition.class, true), (Object)(bookingTarget.refMofId() + (bookingTarget.refGetPath().size() < 13 ? "/($...)" : ""))));
        List bookings = depotSegment.getBooking(bookingQuery);
        return !bookings.isEmpty();
    }

    protected void removeDepotEntity(DepotEntity depotEntity, boolean preDelete) throws ServiceException {
        if (this.hasBookings(depotEntity)) {
            throw new ServiceException("OpenCrxDomain", 1228, "Depot entity has bookings.", new BasicException.Parameter[0]);
        }
        if (!preDelete) {
            depotEntity.refDelete();
        }
    }

    protected void removeDepotHolder(DepotHolder depotHolder, boolean preDelete) throws ServiceException {
        if (this.hasBookings(depotHolder)) {
            throw new ServiceException("OpenCrxDomain", 1229, "Depot holder has bookings.", new BasicException.Parameter[0]);
        }
        if (!preDelete) {
            depotHolder.refDelete();
        }
    }

    protected void removeDepot(Depot depot, boolean preDelete) throws ServiceException {
        if (this.hasBookings(depot)) {
            throw new ServiceException("OpenCrxDomain", 1230, "Depot has bookings.", new BasicException.Parameter[0]);
        }
        if (!preDelete) {
            depot.refDelete();
        }
    }

    protected void removeDepotPosition(DepotPosition depotPosition, boolean preDelete) throws ServiceException {
        if (this.hasBookings(depotPosition)) {
            throw new ServiceException("OpenCrxDomain", 1231, "Depot position has bookings.", new BasicException.Parameter[0]);
        }
        if (!preDelete) {
            depotPosition.refDelete();
        }
    }

    protected void removeDepotGroup(DepotGroup depotGroup, boolean preDelete) throws ServiceException {
        if (!preDelete) {
            depotGroup.refDelete();
        }
    }

    public Depot openDepot(DepotHolder depotHolder, String name, String description, String depotNumber, Date openingDate, DepotType depotType, DepotGroup depotGroup, List<String> errors) throws ServiceException {
        if (depotNumber == null) {
            throw new ServiceException("OpenCrxDomain", 1225, "Depot number is required.", new BasicException.Parameter[0]);
        }
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)depotHolder);
        Depot depot = (Depot)pm.newInstance(Depot.class);
        if (name != null) {
            depot.setName(name);
        }
        if (description != null) {
            depot.setDescription(description);
        }
        depot.setDepotNumber(depotNumber);
        depot.setOpeningDate(openingDate == null ? new Date() : openingDate);
        if (depotType != null) {
            depot.getDepotType().add(depotType);
        }
        if (depotGroup != null) {
            depot.setDepotGroup(depotGroup);
        }
        depot.setDefault(Boolean.FALSE);
        depot.setLocked(Boolean.FALSE);
        depot.setAllowPositionAutoCreate(Boolean.FALSE);
        depotHolder.addDepot(this.getUidAsString(), depot);
        return depot;
    }

    public void closeDepot(Depot depot, Date closingDate, List<String> errors) throws ServiceException {
        if (depot.getClosingDate() != null) {
            throw new ServiceException("OpenCrxDomain", 1226, "Depot is closed. Can not close.", new BasicException.Parameter[0]);
        }
        depot.setLocked(Boolean.TRUE);
        depot.setClosingDate(closingDate == null ? new Date() : closingDate);
    }

    public DepotPosition openDepotPosition(Depot depot, String positionName, String positionDescription, Date openingDate, String depotPositionQualifier, Product product, Boolean isLocked) throws ServiceException {
        Object name;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)depot);
        DepotPosition depotPosition = null;
        if (product != null) {
            List positions = null;
            if (depotPositionQualifier == null) {
                ProductDepotPositionQuery depotPositionQuery = (ProductDepotPositionQuery)pm.newQuery(ProductDepotPosition.class);
                depotPositionQuery.thereExistsProduct().equalTo(product);
                positions = depot.getPosition(depotPositionQuery);
            } else {
                ProductDepotPositionQuery depotPositionQuery = (ProductDepotPositionQuery)pm.newQuery(ProductDepotPosition.class);
                depotPositionQuery.thereExistsProduct().equalTo(product);
                depotPositionQuery.thereExistsQualifier().equalTo((Object)depotPositionQualifier);
                positions = depot.getPosition(depotPositionQuery);
            }
            if (!positions.isEmpty()) {
                return (DepotPosition)positions.iterator().next();
            }
            depotPosition = (DepotPosition)pm.newInstance(ProductDepotPosition.class);
            ((ProductDepotPosition)depotPosition).setProduct(product);
        } else {
            depotPosition = (DepotPosition)pm.newInstance(DepotPosition.class);
        }
        Object object = positionName != null ? positionName : (product != null ? (product.getProductNumber() != null ? product.getProductNumber() : product.getName()) : (name = "N/A"));
        if (depotPositionQualifier != null) {
            depotPosition.setQualifier(depotPositionQualifier);
            name = (String)name + " #" + depotPositionQualifier;
        }
        depotPosition.setName((String)name);
        depotPosition.setDescription(positionDescription != null ? positionDescription : (product != null ? product.getDescription() : ""));
        if (openingDate != null) {
            depotPosition.setOpeningDate(openingDate);
        }
        depotPosition.setLocked(isLocked);
        depot.addPosition(this.getUidAsString(), depotPosition);
        return depotPosition;
    }

    public void closeDepotPosition(DepotPosition depotPosition, Date closingDate, List<String> errors) throws ServiceException {
        if (depotPosition.getClosingDate() != null) {
            throw new ServiceException("OpenCrxDomain", 1227, "Depot position is closed. Can not close.", new BasicException.Parameter[0]);
        }
        depotPosition.setLocked(Boolean.TRUE);
        depotPosition.setClosingDate(closingDate == null ? new Date() : closingDate);
    }

    public void lockCompoundBooking(CompoundBooking cb, short lockingReason) throws ServiceException {
        boolean isPending;
        boolean bl = isPending = cb.getBookingStatus() == BookingStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1223, "Booking status is not pending. Locking is not allowed.", new BasicException.Parameter[0]);
        }
        cb.setLocked(Boolean.TRUE);
        cb.setLockingReason(new Short(lockingReason));
        cb.setLockModifiedAt(new Date());
    }

    public void lockSimpleBooking(SimpleBooking simpleBooking, Short lockingReason) throws ServiceException {
        boolean isPending;
        boolean bl = isPending = simpleBooking.getBookingStatus() == BookingStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1223, "Booking status is not pending. Locking is not allowed.", new BasicException.Parameter[0]);
        }
        simpleBooking.setLocked(Boolean.TRUE);
        simpleBooking.setLockingReason(lockingReason);
        simpleBooking.setLockModifiedAt(new Date());
    }

    public void lockInventoryLevel(InventoryLevel inventoryLevel, short lockingReason) throws ServiceException {
        boolean isPending;
        boolean bl = isPending = inventoryLevel.getInventoryLevelStatus() == InventoryLevelStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1259, "Inventory level status is not pending. Locking is not allowed.", new BasicException.Parameter[0]);
        }
        inventoryLevel.setLocked(Boolean.TRUE);
        inventoryLevel.setLockingReason(new Short(lockingReason));
        inventoryLevel.setLockModifiedAt(new Date());
    }

    public void unlockCompoundBooking(CompoundBooking cb) throws ServiceException {
        boolean isPending;
        boolean bl = isPending = cb.getBookingStatus() == BookingStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1223, "Booking status is not pending. Unlocking is not allowed.", new BasicException.Parameter[0]);
        }
        cb.setLocked(Boolean.FALSE);
        cb.setLockingReason(new Short(0));
        cb.setLockModifiedAt(new Date());
    }

    public void unlockSimpleBooking(SimpleBooking simpleBooking) throws ServiceException {
        boolean isPending;
        boolean bl = isPending = simpleBooking.getBookingStatus() == BookingStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1223, "Booking status is not pending. Unlocking is not allowed.", new BasicException.Parameter[0]);
        }
        simpleBooking.setLocked(Boolean.FALSE);
        simpleBooking.setLockingReason(new Short(0));
        simpleBooking.setLockModifiedAt(new Date());
    }

    public void unlockInventoryLevel(InventoryLevel inventoryLevel) throws ServiceException {
        boolean isPending;
        boolean bl = isPending = inventoryLevel.getInventoryLevelStatus() == InventoryLevelStatus.PENDING.getValue();
        if (!isPending) {
            throw new ServiceException("OpenCrxDomain", 1259, "Inventory level status is not pending. Unlocking is not allowed.", new BasicException.Parameter[0]);
        }
        inventoryLevel.setLocked(Boolean.FALSE);
        inventoryLevel.setLockingReason(new Short(0));
        inventoryLevel.setLockModifiedAt(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createOrUpdateInventoryLevelCorrectionBooking(InventoryLevel inventoryLevel) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)inventoryLevel);
        PersistenceManager pmBooking = null;
        try {
            String providerName = inventoryLevel.refGetPath().getSegment(2).toString();
            String segmentName = inventoryLevel.refGetPath().getSegment(4).toString();
            if (inventoryLevel.getPosition() != null && inventoryLevel.getCorrectionBookingTemplate() != null && inventoryLevel.getCorrectionBookingTemplate().getPositionDebit() != null && inventoryLevel.getCorrectionBookingTemplate().getPositionCredit() != null && inventoryLevel.getCorrectionBookingTemplate().getBookingText() != null) {
                String bookingTextSuffix;
                BookingText bookingText;
                List correctionBookings = new ArrayList();
                if (!JDOHelper.isNew((Object)inventoryLevel)) {
                    CompoundBookingQuery compoundBookingQuery = (CompoundBookingQuery)pm.newQuery(CompoundBooking.class);
                    compoundBookingQuery.bookingType().equalTo((Object)BookingType.INVENTORY_CORRECTION.getValue());
                    compoundBookingQuery.orderByDescription().ascending();
                    correctionBookings = inventoryLevel.getCompoundBooking(compoundBookingQuery);
                }
                CompoundBooking correctionBooking = null;
                BookingTemplate bookingTemplate = null;
                List<Object> bookings = Collections.emptyList();
                if (correctionBookings.isEmpty()) {
                    bookingTemplate = inventoryLevel.getCorrectionBookingTemplate();
                    ArrayList<String> errors = new ArrayList<String>();
                    DepotEntity depotEntity = (DepotEntity)pm.getObjectById((Object)inventoryLevel.getPosition().refGetPath().getPrefix(7));
                    correctionBooking = this.createCompoundBooking(depotEntity, bookingTemplate.getName() + " / " + inventoryLevel.getName(), bookingTemplate.getBookingType());
                    correctionBooking.setOrigin(inventoryLevel);
                    bookingText = bookingTemplate.getBookingText();
                    bookingTextSuffix = bookingTemplate.getBookingTextSuffix();
                    String correctionBookingId = correctionBooking.refGetPath().getLastSegment().toString();
                    bookings = this.appendBookings(correctionBooking, inventoryLevel.getValueDate(), BookingType.INVENTORY_CORRECTION.getValue(), false, new Boolean[]{true, false, true, false}, new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO}, new BookingText[]{bookingText, bookingText, bookingText, bookingText}, new DepotPosition[]{inventoryLevel.getPosition(), bookingTemplate.getPositionDebit(), bookingTemplate.getPositionCredit(), inventoryLevel.getPosition()}, new BookingOrigin[]{inventoryLevel, inventoryLevel, inventoryLevel, inventoryLevel}, new String[]{bookingTextSuffix, bookingTextSuffix, bookingTextSuffix, bookingTextSuffix}, new String[]{correctionBookingId + ":0", correctionBookingId + ":1", correctionBookingId + ":2", correctionBookingId + ":3"}, errors);
                } else {
                    correctionBooking = (CompoundBooking)correctionBookings.iterator().next();
                    pmBooking = this.getContainerManagedPersistenceManager(correctionBooking);
                    Segment depotSegment = this.getDepotSegment(pmBooking, providerName, segmentName);
                    bookingTemplate = (BookingTemplate)pmBooking.getObjectById((Object)inventoryLevel.getCorrectionBookingTemplate().refGetPath());
                    correctionBooking = (CompoundBooking)pmBooking.getObjectById((Object)correctionBooking.refGetPath());
                    bookings = new ArrayList();
                    if (Boolean.TRUE.equals(correctionBooking.isLocked())) {
                        throw new ServiceException("OpenCrxDomain", 1216, "Booking is locked. Correction booking can not be updated.", new BasicException.Parameter[0]);
                    }
                    if (correctionBooking.getBookingStatus() != BookingStatus.PENDING.getValue()) {
                        throw new ServiceException("OpenCrxDomain", 1223, "Booking status must be pending. Correction booking can not be updated.", new BasicException.Parameter[0]);
                    }
                    correctionBooking.setName(bookingTemplate.getName() + " / " + inventoryLevel.getName());
                    String string = correctionBooking.refGetPath().getLastSegment().toString();
                    bookingText = bookingTemplate.getBookingText();
                    bookingTextSuffix = bookingTemplate.getBookingTextSuffix();
                    this.assertOpenPosition(inventoryLevel.getValueDate(), BookingType.INVENTORY_CORRECTION.getValue(), inventoryLevel.getPosition());
                    SingleBooking singleBooking = depotSegment.getBooking(string + ":0");
                    bookings.add(singleBooking);
                    singleBooking.setName(this.getCreditBookingName(inventoryLevel.getPosition(), bookingText, bookingTextSuffix));
                    singleBooking.setPosition(inventoryLevel.getPosition() == null ? null : (DepotPosition)pmBooking.getObjectById((Object)inventoryLevel.getPosition().refGetPath()));
                    singleBooking.setValueDate(inventoryLevel.getValueDate());
                    this.assertOpenPosition(inventoryLevel.getValueDate(), BookingType.INVENTORY_CORRECTION.getValue(), bookingTemplate.getPositionDebit());
                    singleBooking = depotSegment.getBooking(string + ":1");
                    bookings.add(singleBooking);
                    singleBooking.setName(this.getDebitBookingName(bookingTemplate.getPositionDebit(), bookingText, bookingTextSuffix));
                    singleBooking.setPosition(bookingTemplate.getPositionDebit() == null ? null : (DepotPosition)pmBooking.getObjectById((Object)bookingTemplate.getPositionDebit().refGetPath()));
                    singleBooking.setValueDate(inventoryLevel.getValueDate());
                    this.assertOpenPosition(inventoryLevel.getValueDate(), BookingType.INVENTORY_CORRECTION.getValue(), bookingTemplate.getPositionCredit());
                    singleBooking = depotSegment.getBooking(string + ":2");
                    bookings.add(singleBooking);
                    singleBooking.setName(this.getCreditBookingName(bookingTemplate.getPositionCredit(), bookingText, bookingTextSuffix));
                    singleBooking.setPosition(bookingTemplate.getPositionCredit() == null ? null : (DepotPosition)pmBooking.getObjectById((Object)bookingTemplate.getPositionCredit().refGetPath()));
                    singleBooking.setValueDate(inventoryLevel.getValueDate());
                    this.assertOpenPosition(inventoryLevel.getValueDate(), BookingType.INVENTORY_CORRECTION.getValue(), inventoryLevel.getPosition());
                    singleBooking = depotSegment.getBooking(string + ":3");
                    bookings.add(singleBooking);
                    singleBooking.setName(this.getDebitBookingName(inventoryLevel.getPosition(), bookingText, bookingTextSuffix));
                    singleBooking.setPosition(inventoryLevel.getPosition() == null ? null : (DepotPosition)pmBooking.getObjectById((Object)inventoryLevel.getPosition().refGetPath()));
                    singleBooking.setValueDate(inventoryLevel.getValueDate());
                }
                correctionBooking.setOwningUser(bookingTemplate.getOwningUser());
                correctionBooking.getOwningGroup().clear();
                correctionBooking.getOwningGroup().addAll(bookingTemplate.getOwningGroup());
                correctionBooking.setAccessLevelBrowse(bookingTemplate.getAccessLevelBrowse());
                correctionBooking.setAccessLevelUpdate(bookingTemplate.getAccessLevelUpdate());
                correctionBooking.setAccessLevelDelete(bookingTemplate.getAccessLevelDelete());
                for (SingleBooking singleBooking : bookings) {
                    singleBooking.setOwningUser(bookingTemplate.getOwningUser());
                    singleBooking.getOwningGroup().clear();
                    singleBooking.getOwningGroup().addAll(bookingTemplate.getOwningGroup());
                    singleBooking.setAccessLevelBrowse(bookingTemplate.getAccessLevelBrowse());
                    singleBooking.setAccessLevelUpdate(bookingTemplate.getAccessLevelUpdate());
                    singleBooking.setAccessLevelDelete(bookingTemplate.getAccessLevelDelete());
                }
            }
        }
        finally {
            if (pmBooking != null) {
                pmBooking.flush();
                pmBooking.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInventoryLevel(InventoryLevel inventoryLevel) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)inventoryLevel);
        if (inventoryLevel.getCorrectionBookingTemplate() != null && inventoryLevel.getPosition() != null && !Utils.areEqual(inventoryLevel.getCorrectionBookingTemplate().refGetPath().getParent().getParent(), inventoryLevel.getPosition().refGetPath())) {
            throw new ServiceException("OpenCrxDomain", 1260, "Invalid correction booking template: depot position of booking template and inventory level are not equal.", new BasicException.Parameter[0]);
        }
        if (inventoryLevel.getCorrectionBookingTemplate() != null && inventoryLevel.getCorrectionBookingTemplate().getBookingType() != BookingType.INVENTORY_CORRECTION.getValue()) {
            throw new ServiceException("OpenCrxDomain", 1260, "Invalid correction booking template: booking type must be INVENTORY_CORRECTION.", new BasicException.Parameter[0]);
        }
        boolean createOrUpdateCorrectionBooking = false;
        boolean removeCorrectionBooking = false;
        if (JDOHelper.isNew((Object)inventoryLevel)) {
            createOrUpdateCorrectionBooking = true;
        } else {
            PersistenceManager pmOld = null;
            InventoryLevel inventoryLevelOld = null;
            try {
                pmOld = pm.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
                inventoryLevelOld = (InventoryLevel)pmOld.getObjectById((Object)inventoryLevel.refGetPath());
                createOrUpdateCorrectionBooking = !Utils.areEqual(inventoryLevelOld == null || inventoryLevelOld.getCorrectionBookingTemplate() == null ? null : inventoryLevelOld.getCorrectionBookingTemplate().refGetPath(), inventoryLevel.getCorrectionBookingTemplate() == null ? null : inventoryLevel.getCorrectionBookingTemplate().refGetPath());
                createOrUpdateCorrectionBooking |= !Utils.areEqual(inventoryLevelOld == null ? null : inventoryLevelOld.getValueDate(), inventoryLevel.getValueDate());
                createOrUpdateCorrectionBooking |= !Utils.areEqual(inventoryLevelOld == null ? null : inventoryLevelOld.isDisabled(), inventoryLevel.isDisabled());
                removeCorrectionBooking = Boolean.TRUE.equals(inventoryLevel.isDisabled()) || inventoryLevel.getCorrectionBookingTemplate() == null;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (pmOld != null) {
                        pmOld.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (removeCorrectionBooking) {
            CompoundBookingQuery compoundBookingQuery = (CompoundBookingQuery)pm.newQuery(CompoundBooking.class);
            compoundBookingQuery.bookingType().equalTo((Object)BookingType.INVENTORY_CORRECTION.getValue());
            compoundBookingQuery.orderByDescription().ascending();
            for (CompoundBooking correctionBooking : inventoryLevel.getCompoundBooking(compoundBookingQuery)) {
                PersistenceManager pmBooking = null;
                try {
                    pmBooking = this.getContainerManagedPersistenceManager(correctionBooking);
                    this.removeCompoundBooking((CompoundBooking)pmBooking.getObjectById((Object)correctionBooking.refGetPath()), false);
                    pmBooking.flush();
                }
                catch (Exception e) {
                    throw new ServiceException(e);
                }
                finally {
                    if (pmBooking == null) continue;
                    pmBooking.close();
                }
            }
        } else if (createOrUpdateCorrectionBooking) {
            this.createOrUpdateInventoryLevelCorrectionBooking(inventoryLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInventoryLevel(InventoryLevel inventoryLevel, boolean preDelete) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)inventoryLevel);
        CompoundBookingQuery compoundBookingQuery = (CompoundBookingQuery)pm.newQuery(CompoundBooking.class);
        compoundBookingQuery.bookingType().equalTo((Object)BookingType.INVENTORY_CORRECTION.getValue());
        compoundBookingQuery.orderByDescription().ascending();
        for (CompoundBooking correctionBooking : inventoryLevel.getCompoundBooking(compoundBookingQuery)) {
            PersistenceManager pmBooking = null;
            try {
                pmBooking = this.getContainerManagedPersistenceManager(correctionBooking);
                this.removeCompoundBooking((CompoundBooking)pmBooking.getObjectById((Object)correctionBooking.refGetPath()), false);
                pmBooking.flush();
            }
            finally {
                if (pmBooking == null) continue;
                pmBooking.close();
            }
        }
        if (!preDelete) {
            inventoryLevel.refDelete();
        }
    }

    public void updateBookingTemplate(BookingTemplate bookingTemplate) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)bookingTemplate);
        String providerName = bookingTemplate.refGetPath().getSegment(2).toString();
        String segmentName = bookingTemplate.refGetPath().getSegment(4).toString();
        Segment depotSegment = this.getDepotSegment(pm, providerName, segmentName);
        if (bookingTemplate.getBookingType() == BookingType.INVENTORY_CORRECTION.getValue() && (JDOHelper.isPersistent((Object)bookingTemplate) || !JDOHelper.isNew((Object)bookingTemplate))) {
            InventoryLevelQuery inventoryLevelQuery = (InventoryLevelQuery)pm.newQuery(InventoryLevel.class);
            inventoryLevelQuery.thereExistsCorrectionBookingTemplate().equalTo(bookingTemplate);
            for (InventoryLevel inventoryLevel : depotSegment.getInventoryLevel(inventoryLevelQuery)) {
                this.createOrUpdateInventoryLevelCorrectionBooking(inventoryLevel);
            }
        }
    }

    public int countFilteredSingleBooking(AbstractFilterSingleBooking bookingFilter) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)bookingFilter);
        SingleBookingQuery query = (SingleBookingQuery)pm.newQuery(SingleBooking.class);
        QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
        queryExtension.setClause("/*!COUNT*/(1=1)");
        List singleBookings = bookingFilter.getFilteredSingleBooking(query);
        return singleBookings.size();
    }

    public int countFilteredSimpleBooking(AbstractFilterSimpleBooking bookingFilter) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)bookingFilter);
        SimpleBookingQuery query = (SimpleBookingQuery)pm.newQuery(SimpleBooking.class);
        QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
        queryExtension.setClause("/*!COUNT*/(1=1)");
        List simpleBookings = bookingFilter.getFilteredSimpleBooking(query);
        return simpleBookings.size();
    }

    public int countFilteredCompoundBooking(AbstractFilterCompoundBooking bookingFilter) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)bookingFilter);
        CompoundBookingQuery query = (CompoundBookingQuery)pm.newQuery(CompoundBooking.class);
        QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
        queryExtension.setClause("/*!COUNT*/(1=1)");
        List compoundBookings = bookingFilter.getFilteredCompoundBooking(query);
        return compoundBookings.size();
    }

    @Override
    public void preDelete(RefObject_1_0 object, boolean preDelete) throws ServiceException {
        super.preDelete(object, preDelete);
        if (object instanceof CompoundBooking) {
            this.removeCompoundBooking((CompoundBooking)object, preDelete);
        } else if (object instanceof DepotEntity) {
            this.removeDepotEntity((DepotEntity)object, preDelete);
        } else if (object instanceof DepotGroup) {
            this.removeDepotGroup((DepotGroup)object, preDelete);
        } else if (object instanceof DepotHolder) {
            this.removeDepotHolder((DepotHolder)object, preDelete);
        } else if (object instanceof Depot) {
            this.removeDepot((Depot)object, preDelete);
        } else if (object instanceof DepotPosition) {
            this.removeDepotPosition((DepotPosition)object, preDelete);
        } else if (object instanceof SimpleBooking) {
            this.removeSimpleBooking((SimpleBooking)object, preDelete);
        } else if (object instanceof SingleBooking) {
            this.removeSingleBooking((SingleBooking)object, preDelete);
        } else if (object instanceof InventoryLevel) {
            this.removeInventoryLevel((InventoryLevel)object, preDelete);
        }
    }

    @Override
    public void preStore(RefObject_1_0 object) throws ServiceException {
        super.preStore(object);
        if (object instanceof PhoneNumber) {
            Addresses.getInstance().updatePhoneNumber((PhoneNumber)object);
        } else if (object instanceof EMailAddress) {
            Addresses.getInstance().updateEMailAddress((EMailAddress)object);
        } else if (object instanceof InventoryLevel) {
            this.updateInventoryLevel((InventoryLevel)object);
        } else if (object instanceof BookingTemplate) {
            this.updateBookingTemplate((BookingTemplate)object);
        } else if (object instanceof UriAddress) {
            Addresses.getInstance().updateUriAddress((UriAddress)object);
        }
    }

    public static enum DepotUsage {
        GOODS_ISSUE(1),
        GOODS_RETURN(2),
        GOODS_DELIVERY(3),
        WORK_EFFORT(10);

        private final short value;

        private DepotUsage(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }
    }

    public static enum InventoryLevelStatus {
        NONE(0),
        PENDING(1),
        FINAL(2);

        private final short value;

        private InventoryLevelStatus(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }
    }

    public static enum BookingStatus {
        NONE(0),
        PENDING(1),
        FINAL(2);

        private final short value;

        private BookingStatus(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }
    }

    public static enum BookingType {
        STANDARD(10),
        CLOSING(20),
        REVERSAL(30),
        INVENTORY_CORRECTION(40);

        private final short value;

        private BookingType(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }
    }

    private static class DepotReportItem {
        private BigDecimal balanceBop = BigDecimal.ZERO;
        private BigDecimal balanceDebitBop = BigDecimal.ZERO;
        private BigDecimal balanceCreditBop = BigDecimal.ZERO;
        private BigDecimal balanceCredit = BigDecimal.ZERO;
        private BigDecimal balanceDebit = BigDecimal.ZERO;
        private BigDecimal balanceSimple = BigDecimal.ZERO;
        private BigDecimal balanceSimpleBop = BigDecimal.ZERO;

        private DepotReportItem() {
        }

        public BigDecimal getBalanceBop() {
            return this.balanceBop;
        }

        public void setBalanceBop(BigDecimal balanceBop) {
            this.balanceBop = balanceBop;
        }

        public BigDecimal getBalanceDebitBop() {
            return this.balanceDebitBop;
        }

        public void setBalanceDebitBop(BigDecimal balanceDebitBop) {
            this.balanceDebitBop = balanceDebitBop;
        }

        public BigDecimal getBalanceCreditBop() {
            return this.balanceCreditBop;
        }

        public void setBalanceCreditBop(BigDecimal balanceCreditBop) {
            this.balanceCreditBop = balanceCreditBop;
        }

        public BigDecimal getBalanceCredit() {
            return this.balanceCredit;
        }

        public void setBalanceCredit(BigDecimal balanceCredit) {
            this.balanceCredit = balanceCredit;
        }

        public BigDecimal getBalanceDebit() {
            return this.balanceDebit;
        }

        public void setBalanceDebit(BigDecimal balanceDebit) {
            this.balanceDebit = balanceDebit;
        }

        public BigDecimal getBalanceSimple() {
            return this.balanceSimple;
        }

        public void setBalanceSimple(BigDecimal balanceSimple) {
            this.balanceSimple = balanceSimple;
        }

        public BigDecimal getBalanceSimpleBop() {
            return this.balanceSimpleBop;
        }

        public void setBalanceSimpleBop(BigDecimal balanceSimpleBop) {
            this.balanceSimpleBop = balanceSimpleBop;
        }
    }
}

