/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.application.mail.exporter.ExportMailWorkflow;
import org.opencrx.application.mail.exporter.SendMailNotificationWorkflow;
import org.opencrx.application.mail.exporter.SendMailWorkflow;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.base.cci2.StringPropertyQuery;
import org.opencrx.kernel.base.jmi1.ObjectCreationAuditEntry;
import org.opencrx.kernel.base.jmi1.ObjectModificationAuditEntry;
import org.opencrx.kernel.base.jmi1.ObjectRemovalAuditEntry;
import org.opencrx.kernel.base.jmi1.Property;
import org.opencrx.kernel.base.jmi1.StringProperty;
import org.opencrx.kernel.base.jmi1.WorkflowTarget;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.home1.jmi1.WfActionLogEntry;
import org.opencrx.kernel.home1.jmi1.WfBooleanParameter;
import org.opencrx.kernel.home1.jmi1.WfDecimalParameter;
import org.opencrx.kernel.home1.jmi1.WfIntegerParameter;
import org.opencrx.kernel.home1.jmi1.WfProcessInstance;
import org.opencrx.kernel.home1.jmi1.WfProcessInstanceParameter;
import org.opencrx.kernel.home1.jmi1.WfStringParameter;
import org.opencrx.kernel.home1.jmi1.WfUriParameter;
import org.opencrx.kernel.utils.ScriptUtils;
import org.opencrx.kernel.workflow.BulkActivityFollowUpWorkflow;
import org.opencrx.kernel.workflow.BulkCreateActivityWorkflow;
import org.opencrx.kernel.workflow.PrintConsole;
import org.opencrx.kernel.workflow.RunExport;
import org.opencrx.kernel.workflow.RunImport;
import org.opencrx.kernel.workflow.SendAlert;
import org.opencrx.kernel.workflow1.cci2.TopicQuery;
import org.opencrx.kernel.workflow1.cci2.WfProcessQuery;
import org.opencrx.kernel.workflow1.jmi1.ExporterTask;
import org.opencrx.kernel.workflow1.jmi1.ImporterExporterTask;
import org.opencrx.kernel.workflow1.jmi1.ImporterTask;
import org.opencrx.kernel.workflow1.jmi1.RunExportResult;
import org.opencrx.kernel.workflow1.jmi1.RunImportResult;
import org.opencrx.kernel.workflow1.jmi1.Segment;
import org.opencrx.kernel.workflow1.jmi1.Topic;
import org.opencrx.kernel.workflow1.jmi1.WfProcess;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.naming.Path;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.loading.Classes;
import org.openmdx.kernel.log.SysLog;

public class Workflows
extends AbstractImpl {
    public static final short STATUS_OK = 0;
    public static final short STATUS_FAILED = 1;
    public static final String PARAM_NAME_TRIGGERED_BY_EVENT_ID = "triggeredByEventId";
    public static final String PARAM_NAME_TRIGGERED_BY = "triggeredBy";
    public static final String PARAM_NAME_TRIGGERED_BY_EVENT_TYPE = "triggeredByEventType";
    public static final String WORKFLOW_EXPORT_MAIL = "ExportMail";
    public static final String WORKFLOW_SEND_MAIL = "SendMail";
    public static final String WORKFLOW_SEND_MAIL_NOTIFICATION = "SendMailNotification";
    public static final String WORKFLOW_SEND_ALERT = SendAlert.class.getName();
    public static final String WORKFLOW_PRINT_CONSOLE = PrintConsole.class.getName();
    public static final String WORKFLOW_BULK_ACTIVITY_FOLLOWUP = "BulkActivityFollowUp";
    public static final String WORKFLOW_BULK_CREATE_ACTIVITY = "BulkCreateActivity";
    public static final String WORKFLOW_RUN_EXPORT = RunExport.class.getName();
    public static final String WORKFLOW_RUN_IMPORT = RunImport.class.getName();
    public static final String TOPIC_NAME_ACCOUNT_MODIFICATIONS = "Account Modifications";
    public static final String TOPIC_NAME_ACTIVITY_FOLLOWUP_MODIFICATIONS = "Activity Follow Up Modifications";
    public static final String TOPIC_NAME_ACTIVITY_MODIFICATIONS = "Activity Modifications";
    public static final String TOPIC_NAME_ALERT_MODIFICATIONS_EMAIL = "Alert Modifications";
    public static final String TOPIC_NAME_BOOKING_MODIFICATIONS = "Booking Modifications";
    public static final String TOPIC_NAME_COMPETITOR_MODIFICATIONS = "Competitor Modifications";
    public static final String TOPIC_NAME_COMPOUND_BOOKING_MODIFICATIONS = "Compound Booking Modifications";
    public static final String TOPIC_NAME_INVOICE_MODIFICATIONS = "Invoice Modifications";
    public static final String TOPIC_NAME_LEAD_MODIFICATIONS = "Lead Modifications";
    public static final String TOPIC_NAME_OPPORTUNITY_MODIFICATIONS = "Opportunity Modifications";
    public static final String TOPIC_NAME_ORGANIZATION_MODIFICATIONS = "Organization Modifications";
    public static final String TOPIC_NAME_PRODUCT_MODIFICATIONS = "Product Modifications";
    public static final String TOPIC_NAME_QUOTE_MODIFICATIONS = "Quote Modifications";
    public static final String TOPIC_NAME_SALES_ORDER_MODIFICATIONS = "SalesOrder Modifications";
    public static final String TOPIC_NAME_TIMER_MODIFICATIONS = "Timer Modifications (Alert)";
    public static final String WORKFLOW_NAME_PRINT_CONSOLE = PrintConsole.class.getName();
    public static final String WORKFLOW_NAME_SEND_ALERT = SendAlert.class.getName();
    public static final String WORKFLOW_NAME_EXPORT_MAIL = ExportMailWorkflow.class.getName();
    public static final String WORKFLOW_NAME_SEND_MAIL_NOTIFICATION = SendMailNotificationWorkflow.class.getName();
    public static final String WORKFLOW_NAME_SEND_MAIL = SendMailWorkflow.class.getName();
    public static final String WORKFLOW_NAME_BULK_ACTIVITY_FOLLOWUP = BulkActivityFollowUpWorkflow.class.getName();
    public static final String WORKFLOW_NAME_BULK_CREATE_ACTIVITY = BulkCreateActivityWorkflow.class.getName();
    public static final String WORKFLOW_NAME_RUN_EXPORT = RunExport.class.getName();
    public static final String WORKFLOW_NAME_RUN_IMPORT = RunImport.class.getName();

    public static void register() {
        Workflows.registerImpl(new Workflows());
    }

    public static Workflows getInstance() throws ServiceException {
        return Workflows.getInstance(Workflows.class);
    }

    protected Workflows() {
    }

    public static EventType getEventType(ContextCapable object) {
        return object instanceof ObjectRemovalAuditEntry ? EventType.OBJECT_REMOVAL : (object instanceof ObjectCreationAuditEntry ? EventType.OBJECT_CREATION : (object instanceof ObjectModificationAuditEntry ? EventType.OBJECT_REPLACEMENT : EventType.NONE));
    }

    public Segment getWorkflowSegment(PersistenceManager pm, String providerName, String segmentName) {
        return (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.workflow1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
    }

    @Deprecated
    public Topic findTopic(String name, Segment segment, PersistenceManager pm) {
        return this.findTopic(name, segment);
    }

    public Topic findTopic(String name, Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        TopicQuery topicQuery = (TopicQuery)pm.newQuery(Topic.class);
        topicQuery.name().equalTo((Object)name);
        List topics = segment.getTopic(topicQuery);
        return topics.isEmpty() ? null : (Topic)topics.iterator().next();
    }

    public WfProcess findWfProcess(String name, Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        WfProcessQuery wfProcessQuery = (WfProcessQuery)pm.newQuery(WfProcess.class);
        wfProcessQuery.name().equalTo((Object)name);
        List wfProcesses = segment.getWfProcess(wfProcessQuery);
        return wfProcesses.isEmpty() ? null : (WfProcess)wfProcesses.iterator().next();
    }

    public Topic initTopic(Segment workflowSegment, String id, String name, String description, String topicPathPattern, WfProcess[] actions) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)workflowSegment);
        Topic topic = null;
        try {
            topic = workflowSegment.getTopic(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (topic == null) {
            pm.currentTransaction().begin();
            topic = (Topic)pm.newInstance(Topic.class);
            topic.setName(name);
            topic.setDescription(description);
            topic.setTopicPathPattern(topicPathPattern);
            topic.getPerformAction().addAll(Arrays.asList(actions));
            topic.getOwningGroup().addAll(workflowSegment.getOwningGroup());
            workflowSegment.addTopic(id, topic);
            pm.currentTransaction().commit();
        }
        return topic;
    }

    public WfProcess initWorkflow(Segment workflowSegment, String id, String name, String description, Boolean isSynchronous, Property[] properties) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)workflowSegment);
        WfProcess wfProcess = null;
        try {
            wfProcess = (WfProcess)workflowSegment.getWfProcess(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (wfProcess == null) {
            pm.currentTransaction().begin();
            wfProcess = (WfProcess)pm.newInstance(WfProcess.class);
            wfProcess.setName(name);
            wfProcess.setDescription(description);
            wfProcess.setSynchronous(isSynchronous);
            wfProcess.setPriority(0);
            wfProcess.getOwningGroup().addAll(workflowSegment.getOwningGroup());
            workflowSegment.addWfProcess(false, id, wfProcess);
            pm.currentTransaction().commit();
            if (properties != null) {
                pm.currentTransaction().begin();
                for (int i = 0; i < properties.length; ++i) {
                    wfProcess.addProperty(UUIDConversion.toUID((UUID)UUIDs.newUUID()), properties[i]);
                }
                pm.currentTransaction().commit();
            }
        }
        return wfProcess;
    }

    public void initWorkflows(PersistenceManager pm, String providerName, String segmentName) throws ServiceException {
        Segment workflowSegment = this.getWorkflowSegment(pm, providerName, segmentName);
        this.initWorkflow(workflowSegment, WORKFLOW_EXPORT_MAIL, ExportMailWorkflow.class.getName(), "Export mails", Boolean.FALSE, null);
        this.initWorkflow(workflowSegment, WORKFLOW_SEND_MAIL, SendMailWorkflow.class.getName(), "Send mails", Boolean.FALSE, null);
        WfProcess sendMailNotificationWorkflow = this.initWorkflow(workflowSegment, WORKFLOW_SEND_MAIL_NOTIFICATION, SendMailNotificationWorkflow.class.getName(), "Send mail notifications", Boolean.FALSE, null);
        WfProcess sendAlertWorkflow = this.initWorkflow(workflowSegment, WORKFLOW_SEND_ALERT, SendAlert.class.getName(), "Send alert", Boolean.TRUE, null);
        this.initWorkflow(workflowSegment, WORKFLOW_PRINT_CONSOLE, PrintConsole.class.getName(), "Print to console", Boolean.TRUE, null);
        this.initWorkflow(workflowSegment, WORKFLOW_RUN_EXPORT, RunExport.class.getName(), "Run export", Boolean.FALSE, null);
        this.initWorkflow(workflowSegment, WORKFLOW_RUN_IMPORT, RunImport.class.getName(), "Run import", Boolean.FALSE, null);
        WfProcess bulkCreateActivityWorkflow = this.initWorkflow(workflowSegment, WORKFLOW_BULK_CREATE_ACTIVITY, BulkCreateActivityWorkflow.class.getName(), "Perform bulk create activities. Parameters are:\n* locale: Locale used to apply place holders\n* defaultPlaceHolders: Default place holders as properties\n* creationType: Creation type (CREATE,CREATE\\_CONFIRMED,CREATE\\_TEST,CREATE\\_TEST\\_CONFIRMED)\n* accountsSelector: Accounts selector (Group,AccountFilter,AddressFilter,AddressGroup)\n* activityName: Template activity name\n* activityDescription: Template activity description\n* activityDetailedDescription: Template activity detailed description\n* activityPriority: Template activity priority\n* activityScheduledStart: Template activity scheduled start\n* activityScheduledEnd: Template activity scheduled end\n* activityDueBy: Template activity due by\n* emailSender: Template activity email sender\n* emailMessageSubject: Template activity email subject\n* emailMessageBody[0..9]: Template activity message body\n* emailAddressUsage[0..9]: Select email addresses with given usage\n* testAccount: Test account when in test mode\n* testEMail[0..9]: Test email addresses when in test mode\n* excludeNoBulkEMail: Skip accounts with 'no bulk email flag' set", Boolean.FALSE, null);
        WfProcess bulkActivityFollowUpWorkflow = this.initWorkflow(workflowSegment, WORKFLOW_BULK_ACTIVITY_FOLLOWUP, BulkActivityFollowUpWorkflow.class.getName(), "Perform bulk activity follow up. Parameters are:\n* activity: Template activity\n* transition[0..9]: Process transition\n* followUpTitle[0..9]: Follow up title\n* followUpText[0..9]: Follow up text\n* assignTo: Assign activity to contact", Boolean.FALSE, null);
        WfProcess[] sendAlertActions = new WfProcess[]{sendAlertWorkflow};
        WfProcess[] sendMailNotificationsActions = new WfProcess[]{sendMailNotificationWorkflow};
        this.initTopic(workflowSegment, "AccountModifications", TOPIC_NAME_ACCOUNT_MODIFICATIONS, "Send alert for modified accounts", "xri:@openmdx:org.opencrx.kernel.account1/provider/:*/segment/:*/account/:*", sendAlertActions);
        this.initTopic(workflowSegment, "ActivityFollowUpModifications", TOPIC_NAME_ACTIVITY_FOLLOWUP_MODIFICATIONS, "Send alert for modified activity follow ups", "xri:@openmdx:org.opencrx.kernel.activity1/provider/:*/segment/:*/activity/:*/followUp/:*", sendAlertActions);
        this.initTopic(workflowSegment, "ActivityModifications", TOPIC_NAME_ACTIVITY_MODIFICATIONS, "Send alert for modified activities", "xri:@openmdx:org.opencrx.kernel.activity1/provider/:*/segment/:*/activity/:*", sendAlertActions);
        this.initTopic(workflowSegment, "BookingModifications", TOPIC_NAME_BOOKING_MODIFICATIONS, "Send alert for modified bookings", "xri:@openmdx:org.opencrx.kernel.depot1/provider/:*/segment/:*/booking/:*", sendAlertActions);
        this.initTopic(workflowSegment, TOPIC_NAME_COMPETITOR_MODIFICATIONS, TOPIC_NAME_COMPETITOR_MODIFICATIONS, "Send alert for modified competitors", "xri:@openmdx:org.opencrx.kernel.account1/provider/:*/segment/:*/competitor/:*", sendAlertActions);
        this.initTopic(workflowSegment, "CompoundBookingModifications", TOPIC_NAME_COMPOUND_BOOKING_MODIFICATIONS, "Send alert for modified compound bookings", "xri:@openmdx:org.opencrx.kernel.depot1/provider/:*/segment/:*/cb/:*", sendAlertActions);
        this.initTopic(workflowSegment, "InvoiceModifications", TOPIC_NAME_INVOICE_MODIFICATIONS, "Send alert for modified invoices", "xri:@openmdx:org.opencrx.kernel.contract1/provider/:*/segment/:*/invoice/:*", sendAlertActions);
        this.initTopic(workflowSegment, "LeadModifications", TOPIC_NAME_LEAD_MODIFICATIONS, "Send alert for modified leads", "xri:@openmdx:org.opencrx.kernel.contract1/provider/:*/segment/:*/lead/:*", sendAlertActions);
        this.initTopic(workflowSegment, "OpportunityModifications", TOPIC_NAME_OPPORTUNITY_MODIFICATIONS, "Send alert for modified opportunities", "xri:@openmdx:org.opencrx.kernel.contract1/provider/:*/segment/:*/opportunity/:*", sendAlertActions);
        this.initTopic(workflowSegment, "OrganizationModifications", TOPIC_NAME_ORGANIZATION_MODIFICATIONS, "Send alert for modified organizations", "xri:@openmdx:org.opencrx.kernel.account1/provider/:*/segment/:*/organization/:*", sendAlertActions);
        this.initTopic(workflowSegment, "ProductModifications", TOPIC_NAME_PRODUCT_MODIFICATIONS, "Send alert for modified products", "xri:@openmdx:org.opencrx.kernel.product1/provider/:*/segment/:*/product/:*", sendAlertActions);
        this.initTopic(workflowSegment, "QuoteModifications", TOPIC_NAME_QUOTE_MODIFICATIONS, "Send alert for modified quotes", "xri:@openmdx:org.opencrx.kernel.contract1/provider/:*/segment/:*/quote/:*", sendAlertActions);
        this.initTopic(workflowSegment, "SalesOrderModifications", TOPIC_NAME_SALES_ORDER_MODIFICATIONS, "Send alert for modified sales orders", "xri:@openmdx:org.opencrx.kernel.contract1/provider/:*/segment/:*/salesOrder/:*", sendAlertActions);
        this.initTopic(workflowSegment, "AlertModifications", TOPIC_NAME_ALERT_MODIFICATIONS_EMAIL, "Send mail for new alerts", "xri:@openmdx:org.opencrx.kernel.home1/provider/:*/segment/:*/userHome/:*/alert/:*", sendMailNotificationsActions);
        this.initTopic(workflowSegment, "TimerModifications", TOPIC_NAME_TIMER_MODIFICATIONS, "Send alert when timer is triggered", "xri:@openmdx:org.opencrx.kernel.home1/provider/:*/segment/:*/userHome/:*/timer/:*", sendAlertActions);
    }

    /*
     * WARNING - void declaration
     */
    public WfProcessInstance executeWorkflow(String name, WorkflowTarget wfTarget, WfProcess wfProcess, ContextCapable targetObject, Map<String, Boolean> booleanParams, Map<String, String> stringParams, Map<String, Integer> integerParams, Map<String, BigDecimal> decimalParams, Map<String, Date> dateTimeParams, Map<String, Path> uriParams, WfProcessInstance parentProcessInstance) throws ServiceException {
        WfProcessInstanceParameter parameter;
        if (wfProcess == null) {
            throw new ServiceException("OpenCrxDomain", 1239, "Missing workflow", new BasicException.Parameter[0]);
        }
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)wfTarget);
        boolean isSynchronous = Boolean.TRUE.equals(wfProcess.isSynchronous());
        if (targetObject == null) {
            throw new ServiceException("OpenCrxDomain", 1240, "Missing target object", new BasicException.Parameter[0]);
        }
        Path targetObjectIdentity = targetObject.refGetPath();
        Path wfInstanceIdentity = wfTarget.refGetPath().getDescendant(new String[]{"wfProcessInstance", stringParams == null || stringParams.get(PARAM_NAME_TRIGGERED_BY_EVENT_ID) == null ? this.getUidAsString() : stringParams.get(PARAM_NAME_TRIGGERED_BY_EVENT_ID)});
        WfProcessInstance processInstance = null;
        try {
            processInstance = (WfProcessInstance)pm.getObjectById((Object)wfInstanceIdentity);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (processInstance == null) {
            processInstance = (WfProcessInstance)pm.newInstance(WfProcessInstance.class);
            processInstance.setName(name == null ? wfProcess.getName() : name);
            processInstance.setStepCounter(new Integer(0));
            processInstance.setProcess(wfProcess);
            processInstance.setTargetObject(targetObjectIdentity.toXRI());
            processInstance.setFailed(Boolean.FALSE);
            processInstance.setParent(parentProcessInstance);
            if (wfTarget instanceof UserHome) {
                ((UserHome)wfTarget).addWfProcessInstance(this.getUidAsString(), processInstance);
            }
        }
        if (stringParams != null) {
            for (Map.Entry<String, Object> entry : stringParams.entrySet()) {
                parameter = (WfStringParameter)pm.newInstance(WfStringParameter.class);
                parameter.setName(entry.getKey());
                parameter.setStringValue((String)entry.getValue());
                processInstance.addParameter(this.getUidAsString(), parameter);
            }
        }
        if (integerParams != null) {
            for (Map.Entry<String, Object> entry : integerParams.entrySet()) {
                parameter = (WfIntegerParameter)pm.newInstance(WfIntegerParameter.class);
                parameter.setName(entry.getKey());
                parameter.setIntegerValue((Integer)entry.getValue());
                processInstance.addParameter(this.getUidAsString(), parameter);
            }
        }
        if (decimalParams != null) {
            for (Map.Entry<String, Object> entry : decimalParams.entrySet()) {
                parameter = (WfDecimalParameter)pm.newInstance(WfDecimalParameter.class);
                parameter.setName(entry.getKey());
                parameter.setDecimalValue((BigDecimal)entry.getValue());
                processInstance.addParameter(this.getUidAsString(), parameter);
            }
        }
        if (uriParams != null) {
            for (Map.Entry<String, Object> entry : uriParams.entrySet()) {
                parameter = (WfUriParameter)pm.newInstance(WfUriParameter.class);
                parameter.setName(entry.getKey());
                parameter.setUriValue(((Path)entry.getValue()).toXRI());
                processInstance.addParameter(this.getUidAsString(), parameter);
            }
        }
        if (booleanParams != null) {
            for (Map.Entry<String, Object> entry : booleanParams.entrySet()) {
                parameter = (WfBooleanParameter)pm.newInstance(WfBooleanParameter.class);
                parameter.setName(entry.getKey());
                parameter.setBooleanValue((Boolean)entry.getValue());
                processInstance.addParameter(this.getUidAsString(), parameter);
            }
        }
        if (isSynchronous) {
            SynchronousWorkflow workflow = null;
            Object var18_28 = null;
            if (wfProcess.getExecuteScript() == null || wfProcess.getExecuteScript().isEmpty()) {
                try {
                    Class clazz = Classes.getApplicationClass((String)wfProcess.getName());
                    Constructor workflowConstructor = clazz.getConstructor(new Class[0]);
                    workflow = (SynchronousWorkflow)workflowConstructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    new ServiceException((Exception)e).log();
                    throw new ServiceException("OpenCrxDomain", 1242, "missing constructor", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)wfProcess.getName()), new BasicException.Parameter("param1", (Object)e.getMessage())});
                }
                catch (ClassNotFoundException e) {
                    new ServiceException((Exception)e).log();
                    throw new ServiceException("OpenCrxDomain", 1241, "implementation not found", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)wfProcess.getName()), new BasicException.Parameter("param1", (Object)e.getMessage())});
                }
                catch (InstantiationException e) {
                    new ServiceException((Exception)e).log();
                    throw new ServiceException("OpenCrxDomain", 1243, "can not instantiate", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)wfProcess.getName()), new BasicException.Parameter("param1", (Object)e.getMessage())});
                }
                catch (IllegalAccessException e) {
                    new ServiceException((Exception)e).log();
                    throw new ServiceException("OpenCrxDomain", 1244, "illegal access", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)wfProcess.getName()), new BasicException.Parameter("param1", (Object)e.getMessage())});
                }
                catch (IllegalArgumentException e) {
                    new ServiceException((Exception)e).log();
                    throw new ServiceException("OpenCrxDomain", 1245, "illegal argument", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)wfProcess.getName()), new BasicException.Parameter("param1", (Object)e.getMessage())});
                }
                catch (InvocationTargetException e) {
                    throw new ServiceException("OpenCrxDomain", 1246, "can not invoke", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)wfProcess.getName()), new BasicException.Parameter("param1", (Object)e.getTargetException().getMessage())});
                }
            } else {
                Class<?> clazz = ScriptUtils.getClass(wfProcess.getExecuteScript());
            }
            Method executeMethod = null;
            try {
                void var18_31;
                executeMethod = var18_31.getMethod("execute", WorkflowTarget.class, ContextCapable.class, WfProcessInstance.class);
            }
            catch (NoSuchMethodException e) {
                new ServiceException((Exception)e).log();
                throw new ServiceException("OpenCrxDomain", 1242, "missing constructor", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)wfProcess.getName()), new BasicException.Parameter("param1", (Object)e.getMessage())});
            }
            try {
                executeMethod.invoke((Object)workflow, wfTarget, targetObject, processInstance);
                processInstance.setStartedOn(new Date());
                processInstance.setLastActivityOn(new Date());
                processInstance.setFailed(Boolean.FALSE);
            }
            catch (Exception e) {
                Integer stepCounter;
                ServiceException e0 = new ServiceException(e);
                SysLog.warning((String)e0.getMessage(), (Throwable)e0.getCause());
                processInstance.setLastActivityOn(new Date());
                Integer maxRetries = wfProcess.getMaxRetries();
                if (maxRetries == null || maxRetries == 0) {
                    processInstance.setStartedOn(new Date());
                    processInstance.setFailed(Boolean.TRUE);
                }
                if ((stepCounter = processInstance.getStepCounter()) == null) {
                    stepCounter = new Integer(0);
                }
                processInstance.setStepCounter(new Integer(stepCounter + 1));
                WfActionLogEntry logEntry = (WfActionLogEntry)pm.newInstance(WfActionLogEntry.class);
                logEntry.setName(e0.getMessage());
                logEntry.setCorrelation((org.openmdx.base.cci2.BasicObject)(targetObject instanceof BasicObject ? (BasicObject)targetObject : null));
                processInstance.addActionLog(this.getUidAsString(), logEntry);
            }
        }
        return processInstance;
    }

    protected List<String> getTaskParams(ImporterExporterTask task, List<String> params) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)task);
        ArrayList<String> importExportParams = new ArrayList<String>();
        StringPropertyQuery propertyQuery = (StringPropertyQuery)pm.newQuery(StringProperty.class);
        propertyQuery.orderByName().ascending();
        for (StringProperty property : task.getProperty(propertyQuery)) {
            importExportParams.add(property.getStringValue());
        }
        for (int i = 0; i < params.size(); ++i) {
            if (i >= importExportParams.size()) {
                importExportParams.add(params.get(i));
                continue;
            }
            if (params.get(i) == null) continue;
            importExportParams.set(i, params.get(i));
        }
        return importExportParams;
    }

    public RunExportResult runExport(ExporterTask exporterTask, List<String> params) throws ServiceException {
        try {
            Class<?> clazz = ScriptUtils.getClass(exporterTask.getExecuteScript());
            Method runExportMethod = clazz.getMethod("runExport", ExporterTask.class, String[].class);
            List<String> exportParams = this.getTaskParams(exporterTask, params);
            return (RunExportResult)runExportMethod.invoke(null, exporterTask, exportParams.toArray(new String[exportParams.size()]));
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public RunImportResult runImport(ImporterTask importerTask, List<String> params) throws ServiceException {
        try {
            Class<?> clazz = ScriptUtils.getClass(importerTask.getExecuteScript());
            Method runImportMethod = clazz.getMethod("runImport", ImporterTask.class, String[].class);
            List<String> importParams = this.getTaskParams(importerTask, params);
            return (RunImportResult)runImportMethod.invoke(null, importerTask, importParams.toArray(new String[importParams.size()]));
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    public static enum EventType {
        NONE(0),
        OBJECT_CREATION(1),
        OBJECT_REPLACEMENT(3),
        OBJECT_REMOVAL(4),
        TIMER(5);

        private short value;

        private EventType(short value) {
            this.value = value;
        }

        public short getValue() {
            return this.value;
        }
    }

    public static abstract class AsynchronousWorkflow {
        public abstract void execute(WfProcessInstance var1) throws ServiceException;

        public boolean isAtomic() {
            return false;
        }
    }

    public static abstract class SynchronousWorkflow {
        public abstract void execute(WorkflowTarget var1, ContextCapable var2, WfProcessInstance var3) throws ServiceException;
    }
}

