/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.portal;

import java.util.Collections;
import java.util.List;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jmi.reflect.RefObject;
import org.opencrx.kernel.activity1.cci2.ActivityCategoryQuery;
import org.opencrx.kernel.activity1.cci2.ActivityFilterGlobalQuery;
import org.opencrx.kernel.activity1.cci2.ActivityFilterGroupQuery;
import org.opencrx.kernel.activity1.cci2.ActivityGroupQuery;
import org.opencrx.kernel.activity1.cci2.ActivityMilestoneQuery;
import org.opencrx.kernel.activity1.cci2.ActivityTrackerQuery;
import org.opencrx.kernel.activity1.jmi1.ActivityCategory;
import org.opencrx.kernel.activity1.jmi1.ActivityFilterGlobal;
import org.opencrx.kernel.activity1.jmi1.ActivityFilterGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityGroup;
import org.opencrx.kernel.activity1.jmi1.ActivityMilestone;
import org.opencrx.kernel.activity1.jmi1.ActivityTracker;
import org.opencrx.kernel.activity1.jmi1.Segment;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.naming.Path;
import org.openmdx.portal.servlet.ApplicationContext;
import org.openmdx.portal.servlet.DefaultDataBinding;

public class FilteredActivitiesDataBinding
extends DefaultDataBinding {
    protected String getPrincipalName(ApplicationContext app) {
        String userRole = app.getCurrentUserRole();
        return userRole.indexOf("@") > 0 ? userRole.substring(0, userRole.indexOf("@")) : userRole;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue(RefObject object, String qualifiedFeatureName, ApplicationContext app) {
        if (!qualifiedFeatureName.endsWith("!filteredActivity")) return super.getValue(object, qualifiedFeatureName, app);
        String featureName = qualifiedFeatureName.substring(qualifiedFeatureName.lastIndexOf(":") + 1);
        featureName = featureName.replace("${USER}", this.getPrincipalName(app));
        if (object instanceof UserHome) {
            featureName = featureName.replace("${HOME}", ((UserHome)object).refGetPath().getLastSegment().toString());
        }
        String[] c = featureName.split("!");
        String providerName = ((RefObject_1_0)object).refGetPath().getSegment(2).toString();
        String segmentName = ((RefObject_1_0)object).refGetPath().getSegment(4).toString();
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)object);
        Segment activitySegment = (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.activity1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
        if ("tracker".equals(c[0]) || "milestone".equals(c[0]) || "category".equals(c[0])) {
            ActivityGroupQuery query;
            List groups = null;
            if ("tracker".equals(c[0])) {
                List trackers;
                query = (ActivityTrackerQuery)pm.newQuery(ActivityTracker.class);
                query.name().equalTo((Object)c[1]);
                groups = trackers = activitySegment.getActivityTracker((ActivityTrackerQuery)query);
            } else if ("milestone".equals(c[0])) {
                query = (ActivityMilestoneQuery)pm.newQuery(ActivityMilestone.class);
                query.name().equalTo((Object)c[1]);
                List milestones = activitySegment.getActivityMilestone((ActivityMilestoneQuery)query);
                groups = milestones;
            } else if ("category".equals(c[0])) {
                query = (ActivityCategoryQuery)pm.newQuery(ActivityCategory.class);
                query.name().equalTo((Object)c[1]);
                List categories = activitySegment.getActivityCategory((ActivityCategoryQuery)query);
                groups = categories;
            }
            if (groups.isEmpty()) return Collections.EMPTY_LIST;
            ActivityGroup group = (ActivityGroup)groups.iterator().next();
            if (!"filter".equals(c[2])) return super.getValue((RefObject)groups.iterator().next(), "filteredActivity", app);
            ActivityFilterGroupQuery query2 = (ActivityFilterGroupQuery)pm.newQuery(ActivityFilterGroup.class);
            query2.name().equalTo((Object)c[3]);
            List filters = group.getActivityFilter(query2);
            if (filters.isEmpty()) return Collections.EMPTY_LIST;
            return super.getValue((RefObject)filters.iterator().next(), "filteredActivity", app);
        }
        if (!"globalfilter".equals(c[0])) return Collections.EMPTY_LIST;
        ActivityFilterGlobalQuery query = (ActivityFilterGlobalQuery)pm.newQuery(ActivityFilterGlobal.class);
        query.name().equalTo((Object)c[1]);
        List filters = activitySegment.getActivityFilter(query);
        if (filters.isEmpty()) return Collections.EMPTY_LIST;
        return super.getValue((RefObject)filters.iterator().next(), "filteredActivity", app);
    }
}

