/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.security.layer.application;

import java.util.Date;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.MappedRecord;
import org.opencrx.kernel.generic.SecurityKeys;
import org.openmdx.application.dataprovider.cci.FilterProperty;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.mof.cci.Model_1_0;
import org.openmdx.base.mof.spi.Model_1Factory;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.spi.PersistenceManagers;
import org.openmdx.base.query.ConditionType;
import org.openmdx.base.query.IsInCondition;
import org.openmdx.base.query.Quantifier;
import org.openmdx.base.resource.InteractionSpecs;
import org.openmdx.base.resource.Records;
import org.openmdx.base.resource.cci.RestFunction;
import org.openmdx.base.resource.spi.ResourceExceptions;
import org.openmdx.base.resource.spi.RestInteractionSpec;
import org.openmdx.base.rest.cci.MessageRecord;
import org.openmdx.base.rest.cci.ObjectRecord;
import org.openmdx.base.rest.cci.QueryFilterRecord;
import org.openmdx.base.rest.cci.QueryRecord;
import org.openmdx.base.rest.cci.RestConnection;
import org.openmdx.base.rest.cci.ResultRecord;
import org.openmdx.base.rest.spi.AbstractRestInteraction;
import org.openmdx.base.rest.spi.AbstractRestPort;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.Object_2Facade;
import org.openmdx.base.text.conversion.Base64;
import org.openmdx.kernel.exception.BasicException;

public class OpenCrxSecurity_2
extends AbstractRestPort {
    protected final InteractionSpecs SUPER = InteractionSpecs.getRestInteractionSpecs((boolean)false);
    protected static final Path AUTHORIZATION_AUTHORITY = new Path("xri://@openmdx*org.openmdx.security.authorization1");
    protected static final Path REALM_AUTHORITY = new Path("xri://@openmdx*org.openmdx.security.realm1");
    protected static final Path IDENTITY_AUTHORITY = new Path("xri://@openmdx*org.opencrx.security.identity1");
    protected static final Path PATH_PATTERN_PRINCIPALS = REALM_AUTHORITY.getDescendant(new String[]{"provider", ":*", "segment", ":*", "realm", ":*", "principal"});
    protected static final Path PATH_PATTERN_PRINCIPAL = PATH_PATTERN_PRINCIPALS.getDescendant(new String[]{":*"});
    protected static final Path PATH_PATTERN_REALM = REALM_AUTHORITY.getDescendant(new String[]{"provider", ":*", "segment", ":*", "realm", ":*"});
    protected static final Path PATH_PATTERN_REALM_COMPOSITES = REALM_AUTHORITY.getDescendant(new String[]{"provider", ":*", "segment", ":*", "realm", ":*", ":*"});
    protected static final Path PATH_PATTERN_SUBJECTS = IDENTITY_AUTHORITY.getDescendant(new String[]{"provider", ":*", "segment", ":*", "subject"});
    protected static final Path PATH_PATTERN_POLICIES = AUTHORIZATION_AUTHORITY.getDescendant(new String[]{"provider", ":*", "segment", ":*", "policy"});
    protected static final Path PATH_PATTERN_ROLES = AUTHORIZATION_AUTHORITY.getDescendant(new String[]{"provider", ":*", "segment", ":*", "policy", ":*", "role"});
    protected static final Path PATH_PATTERN_ROLE = PATH_PATTERN_ROLES.getDescendant(new String[]{":*"});

    public Interaction getInteraction(RestConnection connection) throws ResourceException {
        return new RestInteraction(connection);
    }

    public void setDerivedAttributes(ObjectRecord obj) throws ResourceException {
        Model_1_0 model = Model_1Factory.getModel();
        try {
            Object_2Facade objFacade = Facades.asObject((MappedRecord)obj);
            if (model.objectIsSubtypeOf((Object)obj, (Object)"org:openmdx:security:realm1:Principal") || model.objectIsSubtypeOf((Object)obj, (Object)"org:openmdx:security:realm1:Realm") || model.objectIsSubtypeOf((Object)obj, (Object)"org:openmdx:security:realm1:Role") || model.objectIsSubtypeOf((Object)obj, (Object)"org:openmdx:security:realm1:Policy")) {
                if (objFacade.attributeValue("name") == null || ((String)objFacade.attributeValue("name")).isEmpty()) {
                    objFacade.attributeValuesAsList("name").clear();
                    objFacade.attributeValuesAsList("name").add(objFacade.getPath().getLastSegment().toString());
                }
            } else if (model.objectIsSubtypeOf((Object)obj, (Object)"org:openmdx:security:realm1:Credential")) {
                objFacade.attributeValuesAsList("id").clear();
                objFacade.attributeValuesAsList("id").add(objFacade.getPath().getLastSegment().toString());
            }
        }
        catch (ServiceException e) {
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
        }
    }

    public class RestInteraction
    extends AbstractRestInteraction {
        public RestInteraction(RestConnection connection) throws ResourceException {
            super(connection, OpenCrxSecurity_2.this.newDelegateInteraction(connection));
        }

        protected String getPrincipalName(RestInteractionSpec ispec) throws ResourceException {
            Connection conn = this.getConnection();
            List principalChain = PersistenceManagers.toPrincipalChain((String)conn.getMetaData().getUserName());
            return principalChain.isEmpty() ? null : (String)principalChain.get(0);
        }

        protected ResultRecord newResult() throws ResourceException {
            return (ResultRecord)Records.getRecordFactory().createIndexedRecord(ResultRecord.class);
        }

        protected MappedRecord newOperationResult(String recordType) throws ResourceException {
            return Records.getRecordFactory().createMappedRecord(recordType);
        }

        protected void touchRealm(RestInteractionSpec ispec, Path path) throws ResourceException {
            block4: {
                if (path.size() >= PATH_PATTERN_REALM_COMPOSITES.size() && path.getPrefix(PATH_PATTERN_REALM_COMPOSITES.size()).isLike(PATH_PATTERN_REALM_COMPOSITES)) {
                    try {
                        Path realmIdentity = path.getPrefix(7);
                        ObjectRecord realm = this.retrieveObject(realmIdentity, "all");
                        if (realm != null) {
                            ObjectRecord updatedRealm = realm.clone();
                            Object_2Facade updatedRealmFacade = Facades.asObject((MappedRecord)updatedRealm);
                            updatedRealmFacade.attributeValuesAsList("modifiedAt").clear();
                            updatedRealmFacade.attributeValuesAsList("modifiedAt").add(new Date());
                            ResultRecord updateResult = (ResultRecord)Records.getRecordFactory().createIndexedRecord(ResultRecord.class);
                            super.update(OpenCrxSecurity_2.this.SUPER.UPDATE, realm, updateResult);
                        }
                    }
                    catch (Exception e) {
                        ServiceException e0 = new ServiceException(e);
                        if (-34 == e0.getExceptionCode() || -20 == e0.getExceptionCode()) break block4;
                        throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
                    }
                }
            }
        }

        protected boolean changePassword(RestInteractionSpec ispec, ObjectRecord passwordCredential, MappedRecord changePasswordParams, MessageRecord result) throws ResourceException {
            try {
                String oldPassword;
                Object_2Facade passwordCredentialFacade = Facades.asObject((MappedRecord)passwordCredential);
                String string = oldPassword = changePasswordParams.get((Object)"oldPassword") != null ? Base64.encode((byte[])((byte[])changePasswordParams.get((Object)"oldPassword"))) : null;
                if (oldPassword != null && !oldPassword.equals(passwordCredentialFacade.attributeValue("password"))) {
                    throw ResourceExceptions.initHolder((ResourceException)new ResourceException("old password verification mismatch", (Throwable)BasicException.newEmbeddedExceptionStack((String)"OpenCrxDomain", (int)-2, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("credential", (Object)passwordCredential)})));
                }
                ObjectRecord changedPasswordCredential = Object_2Facade.cloneObject((MappedRecord)passwordCredential);
                Object_2Facade changedPasswordCredentialFacade = Facades.asObject((MappedRecord)changedPasswordCredential);
                changedPasswordCredentialFacade.attributeValuesAsList("password").clear();
                changedPasswordCredentialFacade.attributeValuesAsList("password").add(Base64.encode((byte[])((byte[])changePasswordParams.get((Object)"password"))));
                changedPasswordCredentialFacade.attributeValuesAsList("modifiedAt").clear();
                changedPasswordCredentialFacade.attributeValuesAsList("modifiedAt").add(new Date());
                result.setBody(this.newOperationResult("org:openmdx:base:Void"));
                return super.update(OpenCrxSecurity_2.this.SUPER.UPDATE, changedPasswordCredential, this.newResult());
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        public ObjectRecord retrieveObject(Path resourceIdentifier, String fetchGroupName) throws ResourceException {
            ResultRecord result = this.newResult();
            QueryRecord query = this.newQuery(resourceIdentifier);
            query.setFetchGroupName(fetchGroupName);
            super.get(OpenCrxSecurity_2.this.SUPER.GET, query, result);
            return result.isEmpty() ? null : (ObjectRecord)result.get(0);
        }

        protected boolean checkPermission(RestInteractionSpec ispec, Path path) throws ResourceException {
            String principalName = this.getPrincipalName(ispec);
            boolean principalIsMemberOfAdministrators = principalName.startsWith("admin" + SecurityKeys.ID_SEPARATOR);
            if (!principalIsMemberOfAdministrators) {
                try {
                    Path principalsPath = (path.startsWith(REALM_AUTHORITY) || path.startsWith(AUTHORIZATION_AUTHORITY)) && path.size() >= 7 ? REALM_AUTHORITY.getDescendant(new String[]{"provider", path.getSegment(2).toString(), "segment", "Root", "realm", path.getSegment(6).toString(), "principal"}) : REALM_AUTHORITY.getDescendant(new String[]{"provider", path.getSegment(2).toString(), "segment", "Root", "realm", path.getSegment(4).toString(), "principal"});
                    Object_2Facade principal = Facades.asObject((MappedRecord)this.retrieveObject(principalsPath.getDescendant(new String[]{principalName}), "all"));
                    if (principal != null) {
                        Path principalGroupAdministrators = principalsPath.getDescendant(new String[]{"Administrators"});
                        principalIsMemberOfAdministrators = principal.attributeValuesAsListContains("isMemberOf", (Object)principalGroupAdministrators);
                    }
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                }
            }
            if (ispec.getFunction() == RestFunction.GET) {
                return principalIsMemberOfAdministrators;
            }
            if (!(principalIsMemberOfAdministrators || path.getParent().isLike(PATH_PATTERN_PRINCIPALS) && path.getLastSegment().toString().equals(principalName))) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException("No permission for " + ispec.getFunction().name() + " on object", (Throwable)BasicException.newEmbeddedExceptionStack((String)"OpenCrxDomain", (int)1000, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("object", (Object)path), new BasicException.Parameter("param0", (Object)path)})));
            }
            return principalIsMemberOfAdministrators;
        }

        private boolean failForUnknownOperation(MessageRecord input) throws ResourceException {
            String operation = input.getTarget().getLastSegment().toString();
            throw ResourceExceptions.initHolder((ResourceException)new ResourceException("unknown operation", (Throwable)BasicException.newEmbeddedExceptionStack((String)"DefaultDomain", (int)-2, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("xri", (Object)input.getResourceIdentifier()), new BasicException.Parameter("target", (Object)input.getTarget()), new BasicException.Parameter("id", (Object)input.getMessageId()), new BasicException.Parameter("operation", (Object)operation)})));
        }

        protected boolean delete(RestInteractionSpec ispec, ObjectRecord obj) throws ResourceException {
            try {
                ResultRecord findResult;
                QueryRecord findRequest;
                this.checkPermission(ispec, obj.getResourceIdentifier());
                Object_2Facade objFacade = Facades.asObject((MappedRecord)obj);
                Path path = objFacade.getPath();
                if (path.isLike(PATH_PATTERN_PRINCIPAL)) {
                    findRequest = this.newQuery(REALM_AUTHORITY.getDescendant(new String[]{"provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString(), "realm", path.getSegment(6).toString(), "principal"}));
                    findRequest.setQueryFilter((QueryFilterRecord)Records.getRecordFactory().createMappedRecord(QueryFilterRecord.class));
                    findRequest.getQueryFilter().getCondition().addAll(FilterProperty.toCondition((FilterProperty[])new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "isMemberOf", ConditionType.IS_IN.code(), new Object[]{path})}));
                    findRequest.setSize(Long.valueOf(10L));
                    findResult = this.newResult();
                    super.find(OpenCrxSecurity_2.this.SUPER.GET, findRequest, findResult);
                    if (!findResult.isEmpty()) {
                        throw ResourceExceptions.initHolder((ResourceException)new ResourceException("Unable to remove principal. Reason: referenced by Principal::isMemberOf", (Throwable)BasicException.newEmbeddedExceptionStack((String)"OpenCrxDomain", (int)-2, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("xri", (Object)path), new BasicException.Parameter("references", (Object)findResult)})));
                    }
                }
                if (path.isLike(PATH_PATTERN_ROLE)) {
                    findRequest = this.newQuery(REALM_AUTHORITY.getDescendant(new String[]{"provider", path.getSegment(2).toString(), "segment", path.getSegment(4).toString(), "realm", path.getSegment(6).toString(), "principal"}));
                    findRequest.setQueryFilter((QueryFilterRecord)Records.getRecordFactory().createMappedRecord(QueryFilterRecord.class));
                    findRequest.getQueryFilter().getCondition().addAll(FilterProperty.toCondition((FilterProperty[])new FilterProperty[]{new FilterProperty(Quantifier.THERE_EXISTS.code(), "grantedRole", ConditionType.IS_IN.code(), new Object[]{path})}));
                    findRequest.setSize(Long.valueOf(10L));
                    findResult = this.newResult();
                    super.find(OpenCrxSecurity_2.this.SUPER.GET, findRequest, findResult);
                    if (!findResult.isEmpty()) {
                        throw ResourceExceptions.initHolder((ResourceException)new ResourceException("Unable to remove role. Reason: referenced by Principal::grantedRole", (Throwable)BasicException.newEmbeddedExceptionStack((String)"OpenCrxDomain", (int)-2, (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("xri", (Object)path), new BasicException.Parameter("references", (Object)findResult)})));
                    }
                }
                this.touchRealm(ispec, obj.getResourceIdentifier());
                return super.delete(ispec, obj);
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        public boolean create(RestInteractionSpec ispec, ObjectRecord request, ResultRecord response) throws ResourceException {
            this.checkPermission(ispec, request.getResourceIdentifier());
            OpenCrxSecurity_2.this.setDerivedAttributes(request);
            this.touchRealm(ispec, request.getResourceIdentifier());
            return super.create(ispec, request, response);
        }

        public boolean update(RestInteractionSpec ispec, ObjectRecord request, ResultRecord response) throws ResourceException {
            try {
                this.checkPermission(ispec, request.getResourceIdentifier());
                if (request.getValue().containsKey((Object)"isMemberOf")) {
                    this.touchRealm(ispec, request.getResourceIdentifier());
                }
                try {
                    return super.update(ispec, request, response);
                }
                catch (Exception e) {
                    ServiceException e0 = new ServiceException(e);
                    if (e0.getExceptionCode() == -20 && request.getResourceIdentifier().isLike(PATH_PATTERN_REALM)) {
                        if (response != null) {
                            response.add((Object)request);
                        }
                        return true;
                    }
                    throw e0;
                }
            }
            catch (ServiceException e) {
                throw ResourceExceptions.initHolder((ResourceException)new ResourceException((Throwable)BasicException.newEmbeddedExceptionStack((Throwable)e)));
            }
        }

        protected boolean get(RestInteractionSpec ispec, QueryRecord request, ResultRecord response) throws ResourceException {
            this.checkPermission(ispec, request.getResourceIdentifier());
            return super.get(ispec, request, response);
        }

        protected boolean invoke(RestInteractionSpec ispec, MessageRecord request, MessageRecord response) throws ResourceException {
            Path path = request.getResourceIdentifier();
            this.checkPermission(ispec, path);
            String operationName = path.getSegment(path.size() - 2).toString();
            ObjectRecord object = this.retrieveObject(path.getPrefix(path.size() - 2), "all");
            if (object != null) {
                String objectClass = object.getValue().getRecordName();
                MappedRecord param = request.getBody();
                if ("org:openmdx:security:authentication1:Password".equals(objectClass)) {
                    if ("change".equals(operationName)) {
                        return this.changePassword(ispec, object, param, response);
                    }
                    return this.failForUnknownOperation(request);
                }
                return this.failForUnknownOperation(request);
            }
            return super.invoke(ispec, request, response);
        }

        protected boolean find(RestInteractionSpec ispec, QueryRecord request, ResultRecord response) throws ResourceException {
            Path path = request.getResourceIdentifier();
            boolean principalIsMemberOfAdministrators = this.checkPermission(ispec, request.getResourceIdentifier());
            String principalName = this.getPrincipalName(ispec);
            if (path.isLike(PATH_PATTERN_PRINCIPALS)) {
                boolean containsSubjectFilter = false;
                List attributeFilter = FilterProperty.getFilterProperties((QueryFilterRecord)request.getQueryFilter());
                for (FilterProperty p : attributeFilter) {
                    if (!"subject".equals(p.name())) continue;
                    containsSubjectFilter = true;
                    break;
                }
                if (!(containsSubjectFilter || principalName.equals("admin-Root") || principalIsMemberOfAdministrators)) {
                    request.getQueryFilter().getCondition().add(new IsInCondition(Quantifier.THERE_EXISTS, "object_class", true, new Object[]{"org:opencrx:security:realm1:PrincipalGroup", "org:opencrx:security:realm1:User"}));
                }
            } else if (path.isLike(PATH_PATTERN_SUBJECTS)) {
                if (!principalName.equals("admin-Root")) {
                    request.getQueryFilter().getCondition().add(new IsInCondition(Quantifier.FOR_ALL, "object_class", true, new Object[0]));
                }
            } else if (path.isLike(PATH_PATTERN_POLICIES) && !principalName.equals("admin-Root")) {
                request.getQueryFilter().getCondition().add(new IsInCondition(Quantifier.FOR_ALL, "object_class", true, new Object[0]));
            }
            return super.find(ispec, request, response);
        }
    }
}

