/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import javax.xml.transform.stream.StreamResult;
import org.opencrx.application.airsync.backend.cci.ClientProfile;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.client.AbstractClientHandler;
import org.opencrx.application.airsync.client.ClientHandler;
import org.opencrx.application.airsync.datatypes.ProvisionPolicy;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.opencrx.application.airsync.utils.WbXMLTransformer;
import org.openmdx.base.exception.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProvisionHandler
extends AbstractClientHandler {
    public ProvisionHandler(SyncBackend backend) {
        super(backend);
    }

    @Override
    public void handle(ClientHandler.SyncTarget target, String userId, String profileName, Object context) throws ServiceException {
        try {
            SyncBackend backend = this.getBackend();
            SyncBackend.RequestContext requestContext = backend.newRequestContext(userId, context);
            ClientProfile clientProfile = backend.getClientProfile(requestContext, profileName);
            Object requestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Provision xmlns=\"Provision:\"><Policies><Policy><PolicyType>MS-EAS-Provisioning-WBXML</PolicyType></Policy></Policies></Provision>";
            Document requestDoc = DOMUtils.parse(new ByteArrayInputStream(((String)requestXml).getBytes("UTF-8")));
            Document docResponse = (Document)target.perform("Provision", null, clientProfile.getUserAgent(), requestDoc);
            Element ePolicies = DOMUtils.getUniqueElement(docResponse.getDocumentElement(), null, "Provision:Policies");
            if (ePolicies != null) {
                NodeList nlPolicies = ePolicies.getChildNodes();
                for (int i = 0; i < nlPolicies.getLength(); ++i) {
                    Element ePolicy = (Element)nlPolicies.item(i);
                    ProvisionPolicy policy = ProvisionPolicy.decode(ePolicy, "Provision");
                    if (!"MS-EAS-Provisioning-WBXML".equals(policy.getPolicyType())) continue;
                    requestXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Provision xmlns=\"Provision:\"><Policies><Policy><PolicyType>MS-EAS-Provisioning-WBXML</PolicyType><PolicyKey>" + policy.getPolicyKey() + "</PolicyKey><Status>1</Status></Policy></Policies></Provision>";
                    requestDoc = DOMUtils.parse(new ByteArrayInputStream(((String)requestXml).getBytes("UTF-8")));
                    docResponse = (Document)target.perform("Provision", policy.getPolicyKey(), clientProfile.getUserAgent(), requestDoc);
                    ePolicies = DOMUtils.getUniqueElement(docResponse.getDocumentElement(), null, "Provision:Policies");
                    if (ePolicies == null) continue;
                    nlPolicies = ePolicies.getChildNodes();
                    for (int j = 0; j < nlPolicies.getLength(); ++j) {
                        ePolicy = (Element)nlPolicies.item(i);
                        policy = ProvisionPolicy.decode(ePolicy, "Provision");
                        if (!"MS-EAS-Provisioning-WBXML".equals(policy.getPolicyType())) continue;
                        clientProfile.setPolicyKey(policy.getPolicyKey());
                    }
                }
                backend.updateClientProfile(requestContext, clientProfile, null, true, true);
            }
            if (logger.isLoggable(Level.FINE)) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                WbXMLTransformer.transform(docResponse, new StreamResult(out), true);
                out.close();
                logger.log(Level.FINE, "+-+-+-+-+- Response +-+-+-+-+-");
                logger.log(Level.FINE, out.toString());
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }
}

