/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.datatypes;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.opencrx.application.airsync.datatypes.IDataFormat;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.format.DateTimeFormat;
import org.w3c.spi2.Datatypes;

public abstract class AbstractXmlFormat
implements IDataFormat {
    protected Logger logger = Logger.getLogger(AbstractXmlFormat.class.getPackage().getName());

    protected DateTimeFormat getUtcFormat(boolean utc) {
        if (utc) {
            return DateTimeFormat.EXTENDED_UTC_FORMAT;
        }
        return DateTimeFormat.getInstance((String)"yyyyMMdd'T'HHmmss'Z'");
    }

    public String parseDOMString(Element elt, String default_value) {
        if (elt != null) {
            return elt.getTextContent();
        }
        return default_value;
    }

    public String parseDOMString(Element elt) {
        return this.parseDOMString(elt, null);
    }

    public Date parseDOMDate(Element elt) {
        if (elt != null) {
            return this.parseDate(elt.getTextContent());
        }
        return null;
    }

    protected void createElement(Element p, String prefix, String name, String val) {
        if (val != null && val.trim().length() > 0) {
            DOMUtils.createElementAndText(p, prefix, name, val);
        }
    }

    public Byte parseDOMByte(Element elt, Byte default_value) {
        if (elt != null) {
            return this.parseByte(elt.getTextContent());
        }
        return default_value;
    }

    public Byte parseDOMByte(Element elt) {
        return this.parseDOMByte(elt, null);
    }

    public Integer parseDOMInt(Element elt, Integer default_value) {
        if (elt != null) {
            return this.parseInt(elt.getTextContent());
        }
        return default_value;
    }

    public Integer parseDOMInt(Element elt) {
        return this.parseDOMInt(elt, null);
    }

    public Date parseDate(String str) {
        return (Date)Datatypes.create(Date.class, (String)str);
    }

    public List<String> parseDOMStringCollection(Element node, String elementPrefix, String elementName, ArrayList<String> default_value) {
        if (node != null) {
            return DOMUtils.getTexts(node, elementPrefix, elementName);
        }
        return default_value;
    }

    public List<String> parseDOMStringCollection(Element node, String elementPrefix, String elementName) {
        return this.parseDOMStringCollection(node, elementPrefix, elementName, null);
    }

    public byte parseByte(String str) {
        return Byte.parseByte(str);
    }

    public int parseInt(String str) {
        return Integer.parseInt(str);
    }

    public boolean parseBoolean(String str) {
        return Boolean.parseBoolean(str);
    }

    public Boolean parseDOMBoolean(Element elt, Boolean default_value) {
        if (elt != null) {
            return this.parseBoolean(elt.getTextContent());
        }
        return default_value;
    }

    public Boolean parseDOMBoolean(Element elt) {
        return this.parseDOMBoolean(elt, null);
    }

    public int parseDOMNoNullInt(Element elt) {
        if (elt == null) {
            return -1;
        }
        return Integer.parseInt(elt.getTextContent());
    }

    public Boolean parseDOMInt2Boolean(Element elt) {
        if (this.parseDOMNoNullInt(elt) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

