/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.server;

import java.util.ArrayList;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.datatypes.SyncStatus;
import org.opencrx.application.airsync.server.AbstractServerHandler;
import org.opencrx.application.airsync.server.SyncRequest;
import org.opencrx.application.airsync.utils.DOMUtils;
import org.openmdx.base.exception.ServiceException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MoveItemsHandler
extends AbstractServerHandler {
    public MoveItemsHandler(SyncBackend backend, String profilePrefix) {
        super(backend, profilePrefix);
    }

    @Override
    public Document handle(SyncRequest request, Document docRequest) {
        SyncBackend.RequestContext requestContext = this.backend.newRequestContext(request.getUserId(), request.getContext());
        String profileName = this.getProfileName(request);
        NodeList lMove = docRequest.getDocumentElement().getElementsByTagName("Move");
        ArrayList<MoveItem> moveItems = new ArrayList<MoveItem>();
        for (int i = 0; i < lMove.getLength(); ++i) {
            Element eMove = (Element)lMove.item(i);
            MoveItem moveItem = MoveItem.decode(eMove);
            moveItems.add(moveItem);
        }
        Document docResponse = DOMUtils.createDoc("Move:", "Moves", new String[0][]);
        Element eRoot = docResponse.getDocumentElement();
        for (MoveItem moveItem : moveItems) {
            Element eResponse = DOMUtils.createElement(eRoot, null, "Response");
            if (moveItem.getSrcFldId() == null) {
                DOMUtils.createElementAndText(eResponse, null, "Status", Integer.toString(SyncStatus.OBJECT_NOT_FOUND.getValue()));
                continue;
            }
            if (moveItem.getSrcFldId().equals(moveItem.getDstFldId())) {
                DOMUtils.createElementAndText(eResponse, null, "Status", Integer.toString(SyncStatus.PROTOCOL_ERROR.getValue()));
                continue;
            }
            SyncStatus syncStatus = SyncStatus.OK;
            String dstMsgId = null;
            try {
                dstMsgId = this.backend.moveDataItem(requestContext, profileName, moveItem.getSrcFldId(), moveItem.getDstFldId(), moveItem.getSrcMsgId());
            }
            catch (Exception e) {
                new ServiceException(e).log();
                syncStatus = SyncStatus.SERVER_ERROR;
            }
            DOMUtils.createElementAndText(eResponse, null, "Status", Integer.toString(syncStatus.getValue()));
            if (syncStatus != SyncStatus.OK) continue;
            DOMUtils.createElementAndText(eResponse, null, "DstMsgId", dstMsgId == null ? moveItem.getSrcMsgId() : dstMsgId);
            DOMUtils.createElementAndText(eResponse, null, "SrcMsgId", moveItem.getSrcMsgId());
        }
        return docResponse;
    }

    static class MoveItem {
        private String srcMsgId;
        private String srcFldId;
        private String dstFldId;

        public void setDstFldId(String destinationFolderId) {
            this.dstFldId = destinationFolderId;
        }

        public void setSrcFldId(String sourceFolderId) {
            this.srcFldId = sourceFolderId;
        }

        public void setSrcMsgId(String sourceMessageId) {
            this.srcMsgId = sourceMessageId;
        }

        public String getSrcMsgId() {
            return this.srcMsgId;
        }

        public String getSrcFldId() {
            return this.srcFldId;
        }

        public String getDstFldId() {
            return this.dstFldId;
        }

        public static MoveItem decode(Element e) {
            MoveItem moveItem = new MoveItem();
            moveItem.setSrcMsgId(DOMUtils.getElementText(e, null, "SrcMsgId"));
            moveItem.setSrcFldId(DOMUtils.getElementText(e, null, "SrcFldId"));
            moveItem.setDstFldId(DOMUtils.getElementText(e, null, "DstFldId"));
            return moveItem;
        }
    }
}

