/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.resource.Records;
import org.openmdx.kernel.log.SysLog;

public class SyncRequest {
    private final HttpServletRequest context;
    private double protocolVersion;
    private final String cmd;
    private final String attachmentName;
    private final String deviceId;
    private final String userId;
    public static final String DEFAULT_SEGMENT_NAME = "Standard";

    public SyncRequest() {
        this.context = null;
        this.cmd = null;
        this.attachmentName = null;
        this.deviceId = null;
        this.userId = null;
    }

    public SyncRequest(String cmd, String userId, String deviceId) {
        this.cmd = cmd;
        this.deviceId = deviceId;
        this.userId = userId;
        this.context = null;
        this.attachmentName = null;
    }

    public SyncRequest(HttpServletRequest httpServletRequest) {
        Object userId;
        this.context = httpServletRequest;
        ArrayList<CallSite> params = new ArrayList<CallSite>();
        for (Object parameter : httpServletRequest.getParameterMap().keySet()) {
            if (!(parameter instanceof String)) continue;
            params.add((CallSite)((Object)(parameter + "=" + httpServletRequest.getParameter((String)parameter))));
        }
        System.out.println(new Date() + "  SyncRequest: " + params);
        SysLog.warning((String)"SyncRequest", params);
        this.cmd = httpServletRequest.getParameter("Cmd");
        this.attachmentName = httpServletRequest.getParameter("AttachmentName");
        this.deviceId = httpServletRequest.getParameter("DeviceId");
        Object object = userId = httpServletRequest.getUserPrincipal() == null ? null : httpServletRequest.getUserPrincipal().getName();
        if (((String)userId).indexOf("\\") < 0) {
            userId = "Standard\\" + (String)userId;
        }
        this.userId = userId;
    }

    public File getTempDir() throws ServiceException {
        if (System.getProperty("org.opencrx.airsyncdir") != null) {
            return new File(System.getProperty("org.opencrx.airsyncdir"));
        }
        return (File)this.context.getSession().getServletContext().getAttribute("javax.servlet.context.tempdir");
    }

    public Object getContext() {
        return this.context;
    }

    public double getProtocolVersion() {
        return this.protocolVersion;
    }

    public InputStream getInputStream() throws IOException {
        return this.context.getInputStream();
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String toString() {
        return Records.getRecordFactory().asMappedRecord(SyncRequest.class.getName(), null, (Object[])new String[]{"cmd", "userId", "deviceId", "protocolVersion"}, new Object[]{this.cmd, this.userId, this.deviceId, this.protocolVersion}).toString();
    }
}

