/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.airsync.server;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.airsync.backend.cci.SyncBackend;
import org.opencrx.application.airsync.backend.impl.OpenCrxSyncBackend;
import org.opencrx.application.airsync.server.FolderSyncHandler;
import org.opencrx.application.airsync.server.GetAttachmentHandler;
import org.opencrx.application.airsync.server.GetItemEstimateHandler;
import org.opencrx.application.airsync.server.MoveItemsHandler;
import org.opencrx.application.airsync.server.PingHandler;
import org.opencrx.application.airsync.server.SendMailHandler;
import org.opencrx.application.airsync.server.ServerHandler;
import org.opencrx.application.airsync.server.SyncHandler;
import org.opencrx.application.airsync.server.SyncRequest;
import org.opencrx.application.airsync.server.SyncResponse;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.kernel.loading.Classes;
import org.openmdx.kernel.log.SysLog;

public class SyncServlet
extends HttpServlet {
    private static final long serialVersionUID = -4136686109306545436L;
    public static final String DEFAULT_PROVIDER_NAME = "CRX";
    public static final String DEFAULT_SEGMENT_NAME = "Standard";
    public static final String DOMAIN_SEPARATOR = "\\";
    public static final String DEFAULT_PROFILE_PREFIX = "AirSync~";
    protected Map<String, ServerHandler> handlers;
    protected SyncBackend backend;

    public void init() throws ServletException {
        try {
            super.init();
            String providerName = this.getInitParameter("provider") != null && this.getInitParameter("provider").startsWith("provider/") ? this.getInitParameter("provider").substring(9) : DEFAULT_PROVIDER_NAME;
            PersistenceManagerFactory pmf = Utils.getPersistenceManagerFactory();
            String backendClassName = this.getInitParameter("backendClassName") == null ? OpenCrxSyncBackend.class.getName() : this.getInitParameter("backendClassName");
            Class backendClass = Classes.getApplicationClass((String)backendClassName);
            this.backend = (SyncBackend)backendClass.getConstructor(PersistenceManagerFactory.class, String.class).newInstance(pmf, providerName);
            String profilePrefix = this.getInitParameter("profilePrefix") == null ? DEFAULT_PROFILE_PREFIX : this.getInitParameter("profilePrefix");
            this.handlers = new HashMap<String, ServerHandler>();
            this.handlers.put("FolderSync", new FolderSyncHandler(this.backend, profilePrefix));
            this.handlers.put("Sync", new SyncHandler(this.backend, profilePrefix));
            this.handlers.put("GetItemEstimate", new GetItemEstimateHandler(this.backend, profilePrefix));
            this.handlers.put("Ping", new PingHandler(this.backend, profilePrefix));
            this.handlers.put("MoveItems", new MoveItemsHandler(this.backend, profilePrefix));
            this.handlers.put("GetAttachment", new GetAttachmentHandler(this.backend, profilePrefix));
            this.handlers.put("SendMail", new SendMailHandler(this.backend, profilePrefix));
            System.out.println("AirSyncServlet " + providerName + " is running");
        }
        catch (Exception e) {
            new ServiceException(e).log();
            throw new ServletException((Throwable)e);
        }
    }

    protected SyncRequest getSyncRequest(HttpServletRequest req) {
        return new SyncRequest(req);
    }

    protected SyncResponse getSyncResponse(HttpServletResponse res) {
        return new SyncResponse(res);
    }

    protected void logRequest(HttpServletRequest request, String command) {
        SysLog.warning((String)"Request URL", (Object)request.getRequestURL());
        SysLog.warning((String)"Parameters", request.getParameterMap().keySet());
        for (Object parameter : request.getParameterMap().keySet()) {
            if (!(parameter instanceof String)) continue;
            SysLog.warning((String)((String)parameter), (Object)request.getParameter((String)parameter));
        }
        Enumeration heads = request.getHeaderNames();
        while (heads.hasMoreElements()) {
            String h = (String)heads.nextElement();
            SysLog.warning((String)(h + ": " + request.getHeader(h)));
        }
    }

    protected void setActiveSyncHeader(HttpServletResponse response) {
        response.setHeader("Server", "Microsoft-IIS/6.0");
        response.setHeader("MS-Server-ActiveSync", "8.1");
        response.setHeader("Cache-Control", "private");
    }

    protected ServerHandler getHandler(String command) {
        return this.handlers.get(command);
    }

    protected String getUserId(HttpServletRequest request) {
        return request.getUserPrincipal() == null ? null : request.getUserPrincipal().getName();
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setStatus(200);
        this.setActiveSyncHeader(response);
        response.setHeader("MS-ASProtocolVersions", "1.0,2.0,2.1,2.5");
        response.setHeader("MS-ASProtocolCommands", "Sync,GetAttachment,FolderSync,MoveItems,GetItemEstimate,Ping,SendMail");
        response.setHeader("Public", "OPTIONS,POST");
        response.setHeader("Allow", "OPTIONS,POST");
        response.setContentLength(0);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.getSession(true);
        SyncRequest syncRequest = this.getSyncRequest(request);
        SyncResponse syncResponse = this.getSyncResponse(response);
        String cmd = syncRequest.getCmd();
        ServerHandler handler = this.getHandler(cmd);
        if (handler == null) {
            response.setStatus(400);
            SysLog.warning((String)"No handler for command", (Object)cmd);
            this.logRequest(request, cmd);
            return;
        }
        this.setActiveSyncHeader(response);
        try {
            handler.handle(syncRequest, syncResponse);
        }
        catch (Exception e) {
            new ServiceException(e).log();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doGet(request, response);
    }
}

