/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiAction;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.application.bpi.datatype.BpiCreateActivityParams;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.activity1.cci2.NewActivityParams;
import org.opencrx.kernel.activity1.jmi1.ActivityCreator;
import org.opencrx.kernel.activity1.jmi1.NewActivityParams;
import org.opencrx.kernel.activity1.jmi1.NewActivityResult;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class CreateActivityAction
extends BpiAction {
    @Override
    public void perform(Path path, PersistenceManager pm, BpiPlugIn plugIn, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        List<ActivityCreator> activityCreators = plugIn.findActivityCreators(path.getPrefix(7), pm);
        if (activityCreators == null || activityCreators.isEmpty()) {
            resp.setStatus(404);
        } else {
            ActivityCreator activityCreator = activityCreators.iterator().next();
            BpiCreateActivityParams bpiCreateActivityParams = plugIn.parseObject(req.getReader(), BpiCreateActivityParams.class);
            Contact reportingContact = null;
            try {
                String contactId = bpiCreateActivityParams.getReportingContact();
                if (contactId != null) {
                    List<Contact> contacts = plugIn.findContacts(path.getPrefix(5).getDescendant(new String[]{"contact", contactId}), pm);
                    reportingContact = contacts.isEmpty() ? null : contacts.iterator().next();
                }
            }
            catch (Exception contactId) {
                // empty catch block
            }
            try {
                pm.currentTransaction().begin();
                NewActivityParams params = (NewActivityParams)Structures.create(NewActivityParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)NewActivityParams.Member.name, (Object)bpiCreateActivityParams.getName()), Datatypes.member((Enum)NewActivityParams.Member.description, (Object)bpiCreateActivityParams.getDescription()), Datatypes.member((Enum)NewActivityParams.Member.detailedDescription, (Object)bpiCreateActivityParams.getDetailedDescription()), Datatypes.member((Enum)NewActivityParams.Member.scheduledStart, (Object)bpiCreateActivityParams.getScheduledStart()), Datatypes.member((Enum)NewActivityParams.Member.scheduledEnd, (Object)bpiCreateActivityParams.getScheduledEnd()), Datatypes.member((Enum)NewActivityParams.Member.priority, (Object)bpiCreateActivityParams.getPriority()), Datatypes.member((Enum)NewActivityParams.Member.icalType, (Object)0), Datatypes.member((Enum)NewActivityParams.Member.reportingContact, (Object)reportingContact)});
                NewActivityResult result = activityCreator.newActivity(params);
                pm.currentTransaction().commit();
                if (result.getActivity() != null) {
                    resp.setCharacterEncoding("UTF-8");
                    resp.setContentType("application/json");
                    PrintWriter pw = resp.getWriter();
                    plugIn.printObject(pw, plugIn.toBpiActivity(result.getActivity(), plugIn.newBpiActivity(), "all"));
                    resp.setStatus(200);
                }
            }
            catch (Exception e) {
                resp.setStatus(500);
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

