/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiAction;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.application.bpi.datatype.BpiAddress;
import org.opencrx.kernel.account1.cci2.AccountAddressQuery;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.PhoneNumber;
import org.opencrx.kernel.account1.jmi1.PostalAddress;
import org.opencrx.kernel.activity1.cci2.AddressGroupMemberQuery;
import org.opencrx.kernel.activity1.jmi1.AddressGroup;
import org.opencrx.kernel.activity1.jmi1.AddressGroupMember;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.Query_2Facade;
import org.w3c.cci2.AnyTypePredicate;

public class GetAddressGroupMembersAction
extends BpiAction {
    @Override
    public void perform(Path path, PersistenceManager pm, BpiPlugIn plugIn, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        List<AddressGroup> addressGroups = plugIn.findAddressGroups(path.getPrefix(7), pm);
        if (addressGroups == null || addressGroups.isEmpty()) {
            resp.setStatus(404);
        } else {
            try {
                AddressGroup addressGroup = addressGroups.iterator().next();
                Query_2Facade queryFacade = Facades.newQuery((Path)addressGroup.refGetPath().getChild("member"));
                String queryType = req.getParameter("queryType");
                queryFacade.setQueryType(queryType == null ? "org:opencrx:kernel:account1:AccountAddress" : queryType);
                String query = req.getParameter("query");
                queryFacade.setQuery(query);
                String position = req.getParameter("position");
                queryFacade.setPosition((Number)(position == null ? Integer.valueOf(0) : Integer.valueOf(position)));
                String size = req.getParameter("size");
                queryFacade.setSize((Number)(size == null ? 25 : Integer.parseInt(size)));
                AccountAddressQuery accountAddressQuery = (AccountAddressQuery)pm.newQuery("org.openmdx.query.OPENMDXQL", (Object)queryFacade.getDelegate());
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("application/json");
                AddressGroupMemberQuery addressGroupMemberQuery = (AddressGroupMemberQuery)pm.newQuery(AddressGroupMember.class);
                addressGroupMemberQuery.forAllDisabled().isFalse();
                addressGroupMemberQuery.thereExistsAddress().elementOf(PersistenceHelper.asSubquery((AnyTypePredicate)accountAddressQuery));
                ArrayList<BpiAddress> bpiAddresses = new ArrayList<BpiAddress>();
                int count = 0;
                ListIterator i = addressGroup.getMember(addressGroupMemberQuery).listIterator(queryFacade.getPosition().intValue());
                while (i.hasNext()) {
                    AddressGroupMember member = (AddressGroupMember)i.next();
                    if (member.getAddress() != null) {
                        AccountAddress address = member.getAddress();
                        if (address instanceof EMailAddress) {
                            bpiAddresses.add(plugIn.toBpiEMailAddress((EMailAddress)address, this.getFetchGroup(req)));
                        } else if (address instanceof PostalAddress) {
                            bpiAddresses.add(plugIn.toBpiPostalAddress((PostalAddress)address, this.getFetchGroup(req)));
                        } else if (address instanceof PhoneNumber) {
                            bpiAddresses.add(plugIn.toBpiPhoneNumber((PhoneNumber)address, this.getFetchGroup(req)));
                        }
                    }
                    if ((long)(++count) <= queryFacade.getSize()) continue;
                    break;
                }
                PrintWriter pw = resp.getWriter();
                plugIn.printObject(pw, bpiAddresses);
                resp.setStatus(200);
            }
            catch (Exception e) {
                resp.setStatus(500);
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

