/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.bpi.adapter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.jdo.PersistenceManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.application.bpi.adapter.BpiPlugIn;
import org.opencrx.application.bpi.adapter.GetAccountsAction;
import org.opencrx.application.bpi.datatype.BpiContact;
import org.opencrx.kernel.account1.cci2.AccountAddressQuery;
import org.opencrx.kernel.account1.cci2.ContactQuery;
import org.opencrx.kernel.account1.jmi1.AccountFilterGlobal;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.Segment;
import org.opencrx.kernel.backend.Accounts;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.rest.spi.Facades;
import org.openmdx.base.rest.spi.Query_2Facade;
import org.w3c.cci2.AnyTypePredicate;

public class GetContactsAction
extends GetAccountsAction {
    @Override
    public void perform(Path path, PersistenceManager pm, BpiPlugIn plugIn, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServiceException {
        block13: {
            try {
                ListIterator<Object> i;
                AccountFilterGlobal accountFilter = null;
                boolean hasErrors = false;
                if (path.size() >= 6 && "accountFilter".equals(path.get(5))) {
                    List<AccountFilterGlobal> accountFilters = plugIn.findAccountFilters(path, pm);
                    if (accountFilters == null || accountFilters.isEmpty()) {
                        resp.setStatus(404);
                        hasErrors = true;
                    } else {
                        accountFilter = accountFilters.iterator().next();
                    }
                }
                Segment accountSegment = Accounts.getInstance().getAccountSegment(pm, path.get(2), path.get(4));
                if (hasErrors) break block13;
                Query_2Facade queryFacade = Facades.newQuery((Path)accountSegment.refGetPath().getChild("account"));
                queryFacade.setQueryType("org:opencrx:kernel:account1:Contact");
                String query = req.getParameter("query");
                ArrayList<AccountAddressQuery> addressQueries = new ArrayList<AccountAddressQuery>();
                if (query != null) {
                    query = this.getAddressQueries(pm, query, addressQueries);
                }
                queryFacade.setQuery(query);
                String position = req.getParameter("position");
                queryFacade.setPosition((Number)(position == null ? Integer.valueOf(0) : Integer.valueOf(position)));
                String size = req.getParameter("size");
                queryFacade.setSize((Number)(size == null ? 25 : Integer.parseInt(size)));
                ContactQuery contactQuery = (ContactQuery)pm.newQuery("org.openmdx.query.OPENMDXQL", (Object)queryFacade.getDelegate());
                for (AccountAddressQuery addressQuery : addressQueries) {
                    contactQuery.thereExistsAddress().elementOf(PersistenceHelper.asSubquery((AnyTypePredicate)addressQuery));
                }
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("application/json");
                ArrayList<BpiContact> bpiContacts = new ArrayList<BpiContact>();
                int count = 0;
                if (accountFilter != null) {
                    i = accountFilter.getFilteredAccount(contactQuery).listIterator(queryFacade.getPosition().intValue());
                    while (i.hasNext()) {
                        Contact contact = (Contact)i.next();
                        bpiContacts.add(plugIn.toBpiContact(contact, plugIn.newBpiContact(), this.getFetchGroup(req)));
                        if ((long)(++count) <= queryFacade.getSize()) continue;
                        break;
                    }
                } else {
                    i = accountSegment.getAccount(contactQuery).listIterator(queryFacade.getPosition().intValue());
                    while (i.hasNext()) {
                        Contact contact = (Contact)i.next();
                        bpiContacts.add(plugIn.toBpiContact(contact, plugIn.newBpiContact(), this.getFetchGroup(req)));
                        if ((long)(++count) <= queryFacade.getSize()) continue;
                        break;
                    }
                }
                PrintWriter pw = resp.getWriter();
                plugIn.printObject(pw, bpiContacts);
                resp.setStatus(200);
            }
            catch (Exception e) {
                resp.setStatus(500);
                new ServiceException(e).log();
                try {
                    pm.currentTransaction().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

