/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.document;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jdo.Extent;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencrx.kernel.admin1.jmi1.ComponentConfiguration;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.Documents;
import org.opencrx.kernel.base.jmi1.StringProperty;
import org.opencrx.kernel.document1.cci2.DocumentBasedFolderEntryQuery;
import org.opencrx.kernel.document1.cci2.DocumentFolderQuery;
import org.opencrx.kernel.document1.cci2.DocumentFolderShareQuery;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentBasedFolderEntry;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.document1.jmi1.DocumentFolderShare;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.document1.jmi1.Segment;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.utils.ComponentConfigHelper;
import org.opencrx.kernel.utils.FileUtils;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.cci2.ExtentCapableQuery;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.w3c.cci2.BinaryLargeObjects;

public class DocumentExporterServlet
extends HttpServlet {
    private static final long serialVersionUID = 4441731357561757549L;
    private static final String COMMAND_EXECUTE = "/execute";
    private static final String WORKFLOW_NAME = "DocumentExporter";
    private static final String CONFIGURATION_ID = "DocumentExporter";
    private static final String OPTION_BASE_DIR = "baseDir";
    private static final String OPTION_SYNC_KEY = "syncKey";
    private static final long STARTUP_DELAY = 180000L;
    private static final String DOCDIR_PROPERTY_NAME = "org.opencrx.docdir";
    private PersistenceManagerFactory pmf = null;
    private static final Map<String, Thread> runningSegments = new ConcurrentHashMap<String, Thread>();
    private long startedAt = System.currentTimeMillis();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.pmf = Utils.getPersistenceManagerFactory();
        }
        catch (Exception e) {
            throw new ServletException("Can not get connection to persistence manager", (Throwable)e);
        }
    }

    protected String getQualifiedFolderName(DocumentFolder documentFolder, String separator) {
        if (documentFolder == null) {
            return "";
        }
        if (documentFolder.getParent() == null) {
            return documentFolder.getName();
        }
        return this.getQualifiedFolderName(documentFolder.getParent(), separator) + separator + documentFolder.getName();
    }

    protected String getNormalizedFilename(String name) {
        int MAX_NAME_LENGHT = 250;
        Object normalizedFileName = "";
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            normalizedFileName = Character.isJavaIdentifierPart(c) ? (String)normalizedFileName + c : (c == '\"' ? (String)normalizedFileName + "'" : (c == '.' ? (String)normalizedFileName + "." : (c == '-' ? (String)normalizedFileName + "-" : (c == '(' ? (String)normalizedFileName + "(" : (c == ')' ? (String)normalizedFileName + ")" : (c == '~' ? (String)normalizedFileName + "~" : (String)normalizedFileName + (((String)normalizedFileName).length() > 0 && ((String)normalizedFileName).charAt(((String)normalizedFileName).length() - 1) != '_' ? "_" : "")))))));
        }
        if (((String)normalizedFileName).length() > 250) {
            int pos = ((String)normalizedFileName).lastIndexOf(".");
            if (pos > 0) {
                String suffix = ((String)normalizedFileName).substring(pos + 1);
                return ((String)normalizedFileName).substring(0, 250 - suffix.length()) + "." + suffix;
            }
            return ((String)normalizedFileName).substring(0, 250);
        }
        return normalizedFileName;
    }

    protected void executeHook(File hook, File targetDir, String providerName, String segmentName) {
        try {
            System.out.println(new Date() + ": DocumentExporter " + providerName + "/" + segmentName + ": Running " + hook.getAbsolutePath());
            Process p = Runtime.getRuntime().exec(hook.getAbsolutePath(), null, targetDir);
            BufferedReader out = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            while ((line = out.readLine()) != null) {
                System.out.println(line);
            }
            out = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            line = null;
            while ((line = out.readLine()) != null) {
                System.out.println(line);
            }
            p.waitFor();
        }
        catch (Exception e) {
            new ServiceException(e).log();
            System.out.println(new Date() + ": DocumentExporter " + providerName + "/" + segmentName + ": Error running " + hook.getAbsolutePath() + ". Message is " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDocuments(File targetDir, DocumentFolder documentFolder, File hooksDir, long syncKey) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)documentFolder);
        String providerName = documentFolder.refGetPath().get(2);
        String segmentName = documentFolder.refGetPath().get(4);
        DocumentBasedFolderEntryQuery folderEntryQuery = (DocumentBasedFolderEntryQuery)pm.newQuery(DocumentBasedFolderEntry.class);
        folderEntryQuery.forAllDisabled().isFalse();
        ArrayList<String> exportedFiles = new ArrayList<String>();
        for (Object entry : documentFolder.getFolderEntry(folderEntryQuery)) {
            Document document;
            if (!(entry.getDocument() instanceof Document) || !((document = (Document)entry.getDocument()).getHeadRevision() instanceof MediaContent)) continue;
            FileOutputStream target = null;
            InputStream source = null;
            try {
                String name = document.getName() == null ? "unknown.bin" : this.getNormalizedFilename(document.getName());
                File targetFile = new File(targetDir, name);
                if (!targetFile.exists() || document.getModifiedAt().getTime() > syncKey) {
                    target = new FileOutputStream(targetFile);
                    MediaContent mediaContent = (MediaContent)document.getHeadRevision();
                    source = mediaContent.getContent().getContent();
                    BinaryLargeObjects.streamCopy((InputStream)source, (long)0L, (OutputStream)target);
                }
                exportedFiles.add(name);
            }
            catch (Exception e) {
                new ServiceException(e).log();
                Base.getInstance().sendAlert((ContextCapable)document, "admin" + SecurityKeys.ID_SEPARATOR + segmentName, DocumentExporterServlet.class.getName() + ": unable to export document", e.getMessage(), (short)2, 0, null);
            }
            finally {
                if (target != null) {
                    try {
                        target.close();
                    }
                    catch (Exception e) {}
                }
                if (source == null) continue;
                try {
                    source.close();
                }
                catch (Exception e) {}
            }
        }
        DocumentFolderQuery subFolderQuery = (DocumentFolderQuery)pm.newQuery(DocumentFolder.class);
        subFolderQuery.forAllDisabled().isFalse();
        for (DocumentFolder subFolder : documentFolder.getSubFolder(subFolderQuery)) {
            String name = this.getNormalizedFilename(subFolder.getName());
            File subDir = new File(targetDir, name);
            subDir.mkdirs();
            File preExportSubdirHook = new File(hooksDir, "pre-export-subdir");
            if (preExportSubdirHook.exists()) {
                this.executeHook(preExportSubdirHook, subDir, providerName, segmentName);
            }
            this.exportDocuments(subDir, subFolder, hooksDir, syncKey);
            File postExportSubdirHook = new File(hooksDir, "post-export-subdir");
            if (postExportSubdirHook.exists()) {
                this.executeHook(postExportSubdirHook, subDir, providerName, segmentName);
            }
            exportedFiles.add(name);
        }
        File[] files = targetDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (exportedFiles.contains(file.getName())) continue;
                FileUtils.deleteQuietly(file);
            }
        }
    }

    public void exportDocuments(String id, String providerName, String segmentName, HttpServletRequest req, HttpServletResponse res) throws IOException {
        System.out.println(new Date().toString() + ": DocumentExporter " + providerName + "/" + segmentName);
        try {
            PersistenceManager pm = this.pmf.getPersistenceManager("admin" + SecurityKeys.ID_SEPARATOR + segmentName, null);
            PersistenceManager rootPm = Utils.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
            ComponentConfiguration componentConfig = ComponentConfigHelper.getComponentConfiguration("DocumentExporter", providerName, rootPm, true, new String[][]{{providerName + "." + segmentName + ".baseDir", "./docdir"}, {providerName + "." + segmentName + ".syncKey", "0"}});
            String docDirName = null;
            if (System.getProperty("org.opencrx.docdir." + providerName) != null) {
                docDirName = System.getProperty("org.opencrx.docdir." + providerName);
            } else if (System.getProperty(DOCDIR_PROPERTY_NAME) != null) {
                docDirName = System.getProperty(DOCDIR_PROPERTY_NAME);
            } else {
                StringProperty docDirProperty = ComponentConfigHelper.getComponentConfigProperty(providerName + "." + segmentName + ".baseDir", componentConfig);
                if (docDirProperty != null) {
                    docDirName = docDirProperty.getStringValue();
                }
            }
            StringProperty syncKeyProperty = ComponentConfigHelper.getComponentConfigProperty(providerName + "." + segmentName + ".syncKey", componentConfig);
            long newSyncKey = System.currentTimeMillis();
            long syncKey = 0L;
            try {
                syncKey = Long.valueOf(syncKeyProperty.getStringValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Segment documentSegment = Documents.getInstance().getDocumentSegment(pm, providerName, segmentName);
            DocumentFolderShareQuery folderShareQuery = (DocumentFolderShareQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(DocumentFolderShare.class), (Object)documentSegment.refGetPath().getDescendant(new String[]{"folder", ":*", "folderShare", ":*"}));
            folderShareQuery.orderByCreatedAt().ascending();
            HashMap<File, DocumentFolderShare> exportedShares = new HashMap<File, DocumentFolderShare>();
            for (DocumentFolderShare folderShare : documentSegment.getExtent((ExtentCapableQuery)folderShareQuery)) {
                File postExportHook;
                File preExportHook;
                File baseDir = new File(docDirName == null || docDirName.isEmpty() ? "./docdir" : docDirName);
                File hooksDir = new File(baseDir, "hooks");
                DocumentFolder documentFolder = (DocumentFolder)pm.getObjectById((Object)folderShare.refGetPath().getParent().getParent());
                File userDir = new File(baseDir, providerName);
                userDir = new File(userDir, segmentName);
                File folderDir = new File(userDir = new File(userDir, folderShare.getShareForUser().refGetPath().getLastSegment().toString()), folderShare.getName());
                if (exportedShares.containsKey(folderDir)) {
                    folderDir = new File(folderDir, this.getQualifiedFolderName(documentFolder.getParent(), ".") + "~" + folderShare.getName());
                }
                if (exportedShares.containsKey(folderDir)) {
                    System.out.println(new Date() + ": DocumentExporter " + providerName + "/" + segmentName + ": Duplicate share names. Will not export. Share.1=" + ((DocumentFolderShare)exportedShares.get(folderDir)).refGetPath().toXRI() + ". Share.2=" + folderShare.refGetPath().toXRI() + ". Target.dir=" + folderDir);
                    continue;
                }
                if (Boolean.TRUE.equals(folderShare.isActive())) {
                    System.out.println(new Date() + ": DocumentExporter " + providerName + "/" + segmentName + ": Exporting " + folderShare.refGetPath().toXRI() + " to " + folderDir);
                    folderDir.mkdirs();
                    preExportHook = new File(hooksDir, "pre-export");
                    if (preExportHook.exists()) {
                        this.executeHook(preExportHook, folderDir.exists() ? folderDir : userDir, providerName, segmentName);
                    }
                    this.exportDocuments(folderDir, documentFolder, hooksDir, syncKey);
                    exportedShares.put(folderDir, folderShare);
                } else {
                    System.out.println(new Date() + ": DocumentExporter " + providerName + "/" + segmentName + ": Removing " + folderShare.refGetPath().toXRI() + " at " + folderDir);
                    preExportHook = new File(hooksDir, "pre-export");
                    if (preExportHook.exists()) {
                        this.executeHook(preExportHook, folderDir.exists() ? folderDir : userDir, providerName, segmentName);
                    }
                    FileUtils.deleteQuietly(folderDir);
                }
                if (!(postExportHook = new File(hooksDir, "post-export")).exists()) continue;
                this.executeHook(postExportHook, folderDir.exists() ? folderDir : userDir, providerName, segmentName);
            }
            rootPm.currentTransaction().begin();
            syncKeyProperty.setStringValue(Long.toString(newSyncKey));
            rootPm.currentTransaction().commit();
            try {
                if (pm != null) {
                    pm.close();
                }
                if (rootPm != null) {
                    rootPm.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            new ServiceException(e).log();
            System.out.println(new Date() + ": DocumentExporter " + providerName + "/" + segmentName + ": ERROR: Exception occured " + e.getMessage() + ". Continuing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (System.currentTimeMillis() > this.startedAt + 180000L) {
            String segmentName = req.getParameter("segment");
            String providerName = req.getParameter("provider");
            String id = providerName + "/" + segmentName;
            if (COMMAND_EXECUTE.equals(req.getPathInfo())) {
                if (!runningSegments.containsKey(id)) {
                    try {
                        runningSegments.put(id, Thread.currentThread());
                        this.exportDocuments(id, providerName, segmentName, req, res);
                    }
                    catch (Exception e) {
                        new ServiceException(e).log();
                    }
                    finally {
                        runningSegments.remove(id);
                    }
                } else if (!runningSegments.get(id).isAlive() || runningSegments.get(id).isInterrupted()) {
                    Thread t = runningSegments.get(id);
                    System.out.println(new Date() + ": DocumentExporter " + providerName + "/" + segmentName + ": workflow " + t.getId() + " is alive=" + t.isAlive() + "; interrupted=" + t.isInterrupted() + ". Skipping execution.");
                }
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(200);
        res.flushBuffer();
        this.handleRequest(req, res);
    }
}

