/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.document;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opencrx.kernel.backend.Documents;
import org.opencrx.kernel.backend.UserHomes;
import org.opencrx.kernel.base.cci2.CheckPermissionsParams;
import org.opencrx.kernel.base.cci2.IndexEntryQuery;
import org.opencrx.kernel.base.jmi1.CheckPermissionsParams;
import org.opencrx.kernel.base.jmi1.CheckPermissionsResult;
import org.opencrx.kernel.base.jmi1.IndexEntry;
import org.opencrx.kernel.document1.cci2.DocumentBasedFolderEntryQuery;
import org.opencrx.kernel.document1.cci2.DocumentFolderQuery;
import org.opencrx.kernel.document1.cci2.DocumentQuery;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentBasedFolderEntry;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.document1.jmi1.DocumentRevision;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.document1.jmi1.Segment;
import org.opencrx.kernel.home1.cci2.DocumentFeedQuery;
import org.opencrx.kernel.home1.cci2.DocumentProfileQuery;
import org.opencrx.kernel.home1.cci2.SearchBasicParams;
import org.opencrx.kernel.home1.jmi1.DocumentFeed;
import org.opencrx.kernel.home1.jmi1.DocumentProfile;
import org.opencrx.kernel.home1.jmi1.ObjectFinder;
import org.opencrx.kernel.home1.jmi1.SearchBasicParams;
import org.opencrx.kernel.home1.jmi1.UserHome;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.persistence.cci.UserObjects;
import org.openmdx.base.rest.cci.QueryExtensionRecord;
import org.openmdx.base.text.conversion.Base64;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;
import org.openmdx.uses.org.apache.commons.fileupload.DiskFileUpload;
import org.openmdx.uses.org.apache.commons.fileupload.FileItem;
import org.openmdx.uses.org.apache.commons.fileupload.FileUpload;
import org.openmdx.uses.org.apache.commons.fileupload.FileUploadException;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.cci2.BinaryLargeObjects;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class DocumentFinderServlet
extends HttpServlet {
    private static final long serialVersionUID = 1206167904673263531L;
    protected static final int FETCH_SIZE = 200;
    protected File tempdir = null;
    protected boolean isDebug = false;
    protected boolean checkPermissions = false;
    protected PersistenceManagerFactory pmf = null;

    public void init(ServletConfig config) throws ServletException {
        super.init();
        if (this.pmf == null) {
            try {
                Utils.getModel();
                this.pmf = Utils.getPersistenceManagerFactory();
            }
            catch (ServiceException e) {
                throw new ServletException("Can not get persistence manager", (Throwable)e);
            }
        }
        this.tempdir = (File)config.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this.isDebug = Boolean.valueOf(config.getInitParameter("debug"));
        this.checkPermissions = Boolean.valueOf(config.getInitParameter("checkPermissions"));
    }

    protected PersistenceManager getPersistenceManager(HttpServletRequest req) {
        return req.getUserPrincipal() == null ? null : this.pmf.getPersistenceManager(req.getUserPrincipal().getName(), null);
    }

    protected File getTempDirectory() {
        return this.tempdir;
    }

    protected String getTempFilePrefix(HttpServletRequest req) {
        return req.getSession().getId() + "-";
    }

    protected String getTempFileName(HttpServletRequest req, String name, String extension) {
        Object fileName = "";
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == ':') continue;
            fileName = (String)fileName + name.charAt(i);
        }
        return this.getTempDirectory().getPath() + File.separator + this.getTempFilePrefix(req) + "-" + (String)fileName + extension;
    }

    protected Map<String, String[]> parseRequest(HttpServletRequest req) {
        boolean uploadFailed = false;
        HashMap<String, String[]> parameterMap = req.getParameterMap();
        if (FileUpload.isMultipartContent((HttpServletRequest)req)) {
            parameterMap = new HashMap<String, String[]>();
            DiskFileUpload upload = new DiskFileUpload();
            upload.setHeaderEncoding("UTF-8");
            List items = null;
            try {
                items = upload.parseRequest(req, 200, 50000000L, this.getTempDirectory().getPath());
            }
            catch (FileUploadException e) {
                uploadFailed = true;
                SysLog.warning((String)"first try to upload file failed", (Object)e.getMessage());
                new ServiceException((Exception)((Object)e)).log();
            }
            try {
                if (uploadFailed) {
                    items = upload.parseRequest(req, 200, 60000000L, this.getTempDirectory().getPath());
                }
                for (FileItem item : items) {
                    try {
                        String[] values;
                        if (item.isFormField()) {
                            values = (String[])parameterMap.get(item.getFieldName());
                            if (values == null) {
                                values = new String[]{item.getString("UTF-8")};
                            } else {
                                ArrayList<String> l = new ArrayList<String>(Arrays.asList(values));
                                l.add(item.getString("UTF-8"));
                                values = l.toArray(new String[l.size()]);
                            }
                            parameterMap.put(item.getFieldName(), values);
                            continue;
                        }
                        values = (String[])parameterMap.get(item.getFieldName());
                        String itemName = item.getName();
                        String fixedItemName = new String(itemName.getBytes("ISO8859-1"), "UTF-8");
                        if (fixedItemName.length() < itemName.length() && fixedItemName.indexOf(".") > 0) {
                            itemName = fixedItemName;
                        }
                        if (values == null) {
                            values = new String[]{itemName};
                        } else {
                            ArrayList<String> l = new ArrayList<String>(Arrays.asList(values));
                            l.add(itemName);
                            values = l.toArray(new String[l.size()]);
                        }
                        parameterMap.put(item.getFieldName(), values);
                        String location = this.getTempFileName(req, item.getFieldName(), Integer.toString(values.length));
                        File outFile = new File(location);
                        item.write(outFile);
                        PrintWriter pw = new PrintWriter(new File(location + ".INFO"), "UTF-8");
                        pw.println(item.getContentType());
                        int sep = item.getName().lastIndexOf("/");
                        if (sep < 0) {
                            sep = item.getName().lastIndexOf("\\");
                        }
                        pw.println(item.getName().substring(sep + 1));
                        pw.close();
                    }
                    catch (Exception e) {
                        ServiceException e0 = new ServiceException(e, "DefaultDomain", -37, "Error parsing request. Ignoring", new BasicException.Parameter[]{new BasicException.Parameter("name", (Object)item.getFieldName())});
                        e0.log();
                    }
                }
            }
            catch (FileUploadException e) {
                SysLog.warning((String)"File upload errror", (Object)e.getMessage());
                new ServiceException((Exception)((Object)e)).log();
            }
        }
        return parameterMap;
    }

    protected String encodeURL(String s) throws ServiceException {
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20");
        }
        catch (Exception ignore) {
            return URLEncoder.encode(s).replace("+", "%20");
        }
    }

    protected String getDocumentUrl(HttpServletRequest req, DocumentFolder folder, Document document, List<DocumentFolder> rootFolders, boolean encode) throws ServiceException {
        Object path = encode ? this.encodeURL(document.getName()) : document.getName();
        for (DocumentFolder current = folder; current != null; current = current.getParent()) {
            path = (encode ? this.encodeURL(current.getName()) : current.getName()) + "/" + (String)path;
            if (rootFolders.contains(current)) break;
        }
        return req.getRequestURI().replace("-documents-", "-webdav-").replace("/connector", "") + "/" + (String)path;
    }

    protected boolean isSet(String[] flag) {
        return flag != null && flag.length > 0 && ("1".equals(flag[0]) || Boolean.valueOf(flag[0]) != false);
    }

    protected String toHash(String s) {
        String hash = null;
        try {
            hash = Base64.encode((byte[])s.getBytes("UTF-8"));
        }
        catch (Exception ignore) {
            hash = Base64.encode((byte[])s.getBytes());
        }
        hash = hash.replace("+", "u002B");
        hash = hash.replace("=", "u003D");
        hash = hash.replace("/", "u002F");
        return hash;
    }

    protected String fromHash(String e) {
        if (e != null) {
            e = e.replace("u002B", "+");
            e = e.replace("u003D", "=");
            e = e.replace("u002F", "/");
        }
        try {
            return new String(Base64.decode((String)e), "UTF-8");
        }
        catch (Exception e0) {
            try {
                return new String(Base64.decode((String)e));
            }
            catch (Exception e1) {
                return e;
            }
        }
    }

    protected void sendResponse(HttpServletRequest req, HttpServletResponse resp, Object bean) throws ServiceException {
        try {
            Gson gson = new Gson();
            resp.setContentType("application/json; charset=UTF-8");
            resp.getWriter();
            gson.toJson(bean, (Appendable)resp.getWriter());
            if (this.isDebug) {
                System.out.println(new Date() + "  DocumentFinderServlet: " + req.getRequestURL());
                gson.toJson(bean, (Appendable)System.out);
                System.out.println();
                System.out.println();
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    protected void sendErrorResponse(HttpServletRequest req, HttpServletResponse resp, String error) throws ServiceException {
        ErrorResult errorBean = new ErrorResult();
        errorBean.setError(error);
        this.sendResponse(req, resp, errorBean);
    }

    protected FileDescr stat(HttpServletRequest req, DocumentFolder folder, List<DocumentFolder> rootFolders, boolean checkPermissions) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)folder);
        CheckPermissionsResult checkPermissionsResult = null;
        if (this.checkPermissions && checkPermissions) {
            UserHome userHome = UserHomes.getInstance().getUserHome(folder.refGetPath(), pm);
            CheckPermissionsParams checkPermissionsParams = (CheckPermissionsParams)Structures.create(CheckPermissionsParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CheckPermissionsParams.Member.principalName, (Object)userHome.refGetPath().getLastSegment().toString())});
            pm.currentTransaction().begin();
            checkPermissionsResult = folder.checkPermissions(checkPermissionsParams);
            pm.currentTransaction().commit();
        }
        FileDescr fd = new FileDescr();
        fd.setHash(this.toHash(folder.refGetPath().toXRI()));
        if (folder.getParent() != null && rootFolders != null && !rootFolders.contains(folder)) {
            fd.setPhash(this.toHash(folder.getParent().refGetPath().toXRI()));
        }
        fd.setName(folder.getName());
        fd.setMime("directory");
        fd.setSize(0L);
        fd.setDate(folder.getModifiedAt());
        fd.setRead(true);
        fd.setWrite(checkPermissionsResult == null ? true : checkPermissionsResult.isHasUpdatePermission());
        fd.setRm(checkPermissionsResult == null ? true : checkPermissionsResult.isHasDeletePermission());
        DocumentFolderQuery subFolderQuery = (DocumentFolderQuery)pm.newQuery(DocumentFolder.class);
        subFolderQuery.orderByName().ascending();
        subFolderQuery.forAllDisabled().isFalse();
        fd.setDirs(!folder.getSubFolder(subFolderQuery).isEmpty());
        return fd;
    }

    protected FileDescr stat(HttpServletRequest req, DocumentFolder folder, Document document, List<DocumentFolder> rootFolders, boolean checkPermissions) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)document);
        UserHome userHome = UserHomes.getInstance().getUserHome(document.refGetPath(), pm);
        CheckPermissionsResult checkPermissionsResult = null;
        if (this.checkPermissions && checkPermissions) {
            CheckPermissionsParams checkPermissionsParams = (CheckPermissionsParams)Structures.create(CheckPermissionsParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CheckPermissionsParams.Member.principalName, (Object)userHome.refGetPath().getLastSegment().toString())});
            checkPermissionsResult = document.checkPermissions(checkPermissionsParams);
        }
        MediaContent headRevision = document.getHeadRevision() instanceof MediaContent ? (MediaContent)document.getHeadRevision() : null;
        FileDescr fd = new FileDescr();
        fd.setName(document.getName());
        fd.setHash(this.toHash(document.refGetPath().toXRI()));
        if (folder == null) {
            if (document.getFolder().size() == 1) {
                folder = (DocumentFolder)document.getFolder().get(0);
            } else {
                Iterator iterator = document.getFolder().iterator();
                block2: while (iterator.hasNext()) {
                    DocumentFolder f;
                    for (DocumentFolder current = f = (DocumentFolder)iterator.next(); current != null; current = current.getParent()) {
                        if (!rootFolders.contains(current)) continue;
                        folder = current;
                        continue block2;
                    }
                }
            }
        }
        if (folder != null) {
            fd.setPhash(this.toHash(folder.refGetPath().toXRI()));
        }
        String mimeType = headRevision == null ? document.getContentType() : headRevision.getContentMimeType();
        fd.setMime(mimeType == null || mimeType.isEmpty() ? "application/octet-stream" : mimeType);
        fd.setDate(headRevision == null ? document.getModifiedAt() : headRevision.getModifiedAt());
        try {
            fd.setSize(headRevision == null ? 0L : (headRevision.getContentLength() == null ? headRevision.getContent().getLength() : headRevision.getContentLength()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        fd.setRead(true);
        fd.setWrite(checkPermissionsResult == null ? true : checkPermissionsResult.isHasUpdatePermission());
        fd.setRm(checkPermissionsResult == null ? true : checkPermissionsResult.isHasDeletePermission());
        if (folder != null) {
            fd.setUrl(this.getDocumentUrl(req, folder, document, rootFolders, false));
        }
        return fd;
    }

    protected List<FileDescr> ls(HttpServletRequest req, DocumentFolder folder, List<DocumentFolder> rootFolders, boolean includeDocuments, boolean includeFolders) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)folder);
        ArrayList<FileDescr> fds = new ArrayList<FileDescr>();
        if (includeFolders) {
            DocumentFolderQuery subFolderQuery = (DocumentFolderQuery)pm.newQuery(DocumentFolder.class);
            subFolderQuery.orderByName().ascending();
            subFolderQuery.forAllDisabled().isFalse();
            for (DocumentFolder subFolder : folder.getSubFolder(subFolderQuery)) {
                fds.add(this.stat(req, subFolder, rootFolders, true));
            }
        }
        if (includeDocuments) {
            String providerName = folder.refGetPath().getSegment(2).toString();
            String segmentName = folder.refGetPath().getSegment(4).toString();
            Segment documentSegment = Documents.getInstance().getDocumentSegment(pm, providerName, segmentName);
            DocumentQuery documentQuery = (DocumentQuery)pm.newQuery(Document.class);
            documentQuery.orderByName().ascending();
            documentQuery.forAllDisabled().isFalse();
            documentQuery.thereExistsFolder().equalTo(folder);
            ((Query)documentQuery).getFetchPlan().setFetchSize(200);
            for (Document document : documentSegment.getDocument(documentQuery)) {
                fds.add(this.stat(req, folder, document, rootFolders, true));
            }
        }
        return fds;
    }

    protected List<DocumentFolder> getRootFolders(HttpServletRequest req, PersistenceManager pm) {
        String path = req.getPathInfo();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String[] components = path.split("/");
        UserHome userHome = (UserHome)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.home1").getDescendant(new String[]{"provider", components[0], "segment", components[1], "userHome", components[2]}));
        ArrayList<DocumentFolder> rootFolders = new ArrayList<DocumentFolder>();
        String profileName = components[3];
        DocumentProfileQuery documentProfileQuery = (DocumentProfileQuery)pm.newQuery(DocumentProfile.class);
        documentProfileQuery.name().equalTo((Object)profileName);
        List documentProfiles = userHome.getSyncProfile(documentProfileQuery);
        if (!documentProfiles.isEmpty()) {
            DocumentProfile documentProfile = (DocumentProfile)documentProfiles.iterator().next();
            DocumentFeedQuery documentFeedQuery = (DocumentFeedQuery)pm.newQuery(DocumentFeed.class);
            documentFeedQuery.thereExistsIsActive().isTrue();
            documentFeedQuery.thereExistsDocumentFolder().forAllDisabled().isFalse();
            for (DocumentFeed documentFeed : documentProfile.getFeed(documentFeedQuery)) {
                rootFolders.add(documentFeed.getDocumentFolder());
            }
        }
        return rootFolders;
    }

    protected List<DocumentFolder> getAllSubFolders(DocumentFolder folder) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)folder);
        ArrayList<DocumentFolder> subFolders = new ArrayList<DocumentFolder>();
        DocumentFolderQuery subFolderQuery = (DocumentFolderQuery)pm.newQuery(DocumentFolder.class);
        subFolderQuery.forAllDisabled().isFalse();
        for (DocumentFolder subFolder : folder.getSubFolder(subFolderQuery)) {
            subFolders.add(subFolder);
            subFolders.addAll(this.getAllSubFolders(subFolder));
        }
        return subFolders;
    }

    protected FileDescr getVolumeFileDescr(HttpServletRequest req) throws ServiceException {
        FileDescr fd = new FileDescr();
        String id = req.getPathInfo();
        fd.setHash(this.toHash(id));
        fd.setVolumeid(id);
        fd.setName(id);
        fd.setMime("directory");
        fd.setRead(true);
        fd.setWrite(false);
        fd.setRm(false);
        fd.setDate(new Date());
        return fd;
    }

    protected List<FileDescr> search(HttpServletRequest req, DocumentFolder folder, List<DocumentFolder> rootFolders, String query) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)folder);
        String providerName = folder.refGetPath().getSegment(2).toString();
        String segmentName = folder.refGetPath().getSegment(4).toString();
        Segment documentSegment = Documents.getInstance().getDocumentSegment(pm, providerName, segmentName);
        ArrayList<DocumentFolder> folders = new ArrayList<DocumentFolder>();
        folders.add(folder);
        folders.addAll(this.getAllSubFolders(folder));
        ArrayList<FileDescr> files = new ArrayList<FileDescr>();
        DocumentQuery documentQuery = (DocumentQuery)pm.newQuery(Document.class);
        documentQuery.forAllDisabled().isFalse();
        documentQuery.name().like((Object)("(?i).*" + query + ".*"));
        documentQuery.thereExistsFolder().elementOf(folders);
        documentQuery.orderByName().ascending();
        for (Document document : documentSegment.getDocument(documentQuery)) {
            files.add(this.stat(req, null, document, rootFolders, true));
        }
        UserHome userHome = UserHomes.getInstance().getUserHome(documentSegment.refGetPath(), pm);
        Object searchResult = null;
        try {
            pm.currentTransaction().begin();
            SearchBasicParams params = (SearchBasicParams)Structures.create(SearchBasicParams.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)SearchBasicParams.Member.searchExpression, (Object)query)});
            searchResult = userHome.searchBasic(params);
            pm.currentTransaction().commit();
        }
        catch (Exception e) {
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (searchResult != null && searchResult.getObjectFinder() != null) {
            ObjectFinder objectFinder = (ObjectFinder)pm.getObjectById((Object)searchResult.getObjectFinder().refGetPath());
            IndexEntryQuery indexEntryQuery = (IndexEntryQuery)pm.newQuery(IndexEntry.class);
            QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)indexEntryQuery);
            String[] stringParams = new String[folders.size()];
            Object clause = "EXISTS (SELECT 0 FROM OOCKE1_DOCUMENT_ d_ INNER JOIN OOCKE1_MEDIA m ON m.p$$parent = d_.object_id AND v.indexed_object = m.object_id AND (";
            for (int i = 0; i < folders.size(); ++i) {
                clause = (String)clause + (i > 0 ? " OR " : "") + "d_.folder LIKE '%/" + ((DocumentFolder)folders.get(i)).refGetPath().getLastSegment().toString() + "'";
            }
            clause = (String)clause + "))";
            queryExtension.setStringParam(stringParams);
            queryExtension.setClause((String)clause);
            for (IndexEntry indexEntry : objectFinder.getIndexEntryDocument(indexEntryQuery)) {
                MediaContent mediaContent = (MediaContent)indexEntry.getIndexedObject();
                Document document = (Document)pm.getObjectById((Object)mediaContent.refGetPath().getParent().getParent());
                if (Boolean.TRUE.equals(document.isDisabled())) continue;
                files.add(this.stat(req, null, document, rootFolders, true));
            }
        }
        documentQuery = (DocumentQuery)pm.newQuery(Document.class);
        documentQuery.forAllDisabled().isFalse();
        documentQuery.thereExistsKeywords().like((Object)("(?i).*" + query + ".*"));
        documentQuery.thereExistsFolder().elementOf(folders);
        documentQuery.orderByName().ascending();
        for (Document document : documentSegment.getDocument(documentQuery)) {
            files.add(this.stat(req, null, document, rootFolders, true));
        }
        for (DocumentFolder f : folders) {
            if (!f.getName().matches("(?i).*" + query + ".*")) continue;
            files.add(this.stat(req, f, rootFolders, true));
        }
        return files;
    }

    protected List<FileDescr> getTree(HttpServletRequest req, DocumentFolder folder, List<DocumentFolder> rootFolders) throws ServiceException {
        ArrayList<FileDescr> tree = new ArrayList<FileDescr>();
        for (DocumentFolder current = folder; current != null; current = current.getParent()) {
            tree.addAll(this.ls(req, current, rootFolders, false, true));
            if (rootFolders.contains(current)) break;
        }
        for (DocumentFolder rootFolder : rootFolders) {
            tree.add(this.stat(req, rootFolder, rootFolders, true));
        }
        return tree;
    }

    protected void mkdirCommand(HttpServletRequest req, HttpServletResponse resp, Map<String, String[]> requestParams, PersistenceManager pm) throws ServiceException {
        String[] targets = requestParams.get("target");
        String[] name = requestParams.get("name");
        if (targets != null && targets.length > 0 && name != null && name.length > 0) {
            DocumentFolder folder = (DocumentFolder)pm.getObjectById((Object)new Path(this.fromHash(targets[0])));
            List<DocumentFolder> rootFolders = this.getRootFolders(req, pm);
            DocumentFolderQuery subFolderQuery = (DocumentFolderQuery)pm.newQuery(DocumentFolder.class);
            subFolderQuery.name().equalTo((Object)name[0]);
            subFolderQuery.forAllDisabled().isFalse();
            List folders = folder.getSubFolder(subFolderQuery);
            DocumentFolder newFolder = null;
            if (folders.isEmpty()) {
                Segment documentSegment = (Segment)pm.getObjectById((Object)folder.refGetPath().getPrefix(5));
                pm.currentTransaction().begin();
                newFolder = (DocumentFolder)pm.newInstance(DocumentFolder.class);
                newFolder.setName(name[0]);
                newFolder.setParent(folder);
                newFolder.getOwningGroup().addAll(folder.getOwningGroup());
                documentSegment.addFolder(Utils.getUidAsString(), newFolder);
                pm.currentTransaction().commit();
            } else {
                newFolder = (DocumentFolder)folders.iterator().next();
            }
            FilesOpResult mkdirResult = new FilesOpResult();
            mkdirResult.setAdded(Arrays.asList(this.stat(req, newFolder, rootFolders, true)));
            this.sendResponse(req, resp, mkdirResult);
        } else {
            this.sendErrorResponse(req, resp, "errOpen");
        }
    }

    protected void treeCommand(HttpServletRequest req, HttpServletResponse resp, Map<String, String[]> requestParams, PersistenceManager pm) throws ServiceException {
        String[] targets = requestParams.get("target");
        if (targets != null && targets.length > 0) {
            String target = "".equals(targets[0]) ? "" : this.fromHash(targets[0]);
            DocumentFolder folder = (DocumentFolder)pm.getObjectById((Object)new Path(target));
            List<DocumentFolder> rootFolders = this.getRootFolders(req, pm);
            List<FileDescr> tree = this.getTree(req, folder, rootFolders);
            TreeResult treeDescr = new TreeResult();
            treeDescr.setTree(tree);
            this.sendResponse(req, resp, treeDescr);
        } else {
            this.sendErrorResponse(req, resp, "errOpen");
        }
    }

    protected void openCommand(HttpServletRequest req, HttpServletResponse resp, Map<String, String[]> requestParams, PersistenceManager pm) throws ServiceException {
        String[] targets = requestParams.get("target");
        boolean isTree = this.isSet(requestParams.get("tree"));
        boolean isInit = this.isSet(requestParams.get("init"));
        if (targets != null && targets.length > 0) {
            List<DocumentFolder> rootFolders = this.getRootFolders(req, pm);
            FileDescr cwd = null;
            ArrayList<FileDescr> files = new ArrayList<FileDescr>();
            String target = "".equals(targets[0]) ? "" : this.fromHash(targets[0]);
            DocumentFolder folder = null;
            if ("".equals(target) || req.getPathInfo().equals(target)) {
                cwd = this.getVolumeFileDescr(req);
                for (DocumentFolder rootFolder : rootFolders) {
                    files.add(this.stat(req, rootFolder, rootFolders, false));
                }
            } else {
                folder = (DocumentFolder)pm.getObjectById((Object)new Path(target));
                cwd = this.stat(req, folder, rootFolders, true);
                files.addAll(this.ls(req, folder, rootFolders, true, true));
                if (isTree) {
                    files.addAll(this.getTree(req, folder.getParent(), rootFolders));
                }
            }
            OpenResult openDescr = new OpenResult();
            openDescr.setCwd(cwd);
            openDescr.setFiles(files);
            if (isInit) {
                openDescr.setNetDrivers(Collections.emptyList());
                openDescr.setApi(2);
            }
            this.sendResponse(req, resp, openDescr);
        } else {
            this.sendErrorResponse(req, resp, "errOpen");
        }
    }

    protected void lsCommand(HttpServletRequest req, HttpServletResponse resp, Map<String, String[]> requestParams, PersistenceManager pm) throws ServiceException {
        String[] targets = requestParams.get("target");
        if (targets != null && targets.length > 0) {
            DocumentFolder targetFolder = (DocumentFolder)pm.getObjectById((Object)new Path(this.fromHash(targets[0])));
            List<DocumentFolder> rootFolders = this.getRootFolders(req, pm);
            List<FileDescr> files = this.ls(req, targetFolder, rootFolders, true, false);
            LsResult lsResult = new LsResult();
            lsResult.setList(files);
            this.sendResponse(req, resp, lsResult);
        } else {
            this.sendErrorResponse(req, resp, "errOpen");
        }
    }

    protected void searchCommand(HttpServletRequest req, HttpServletResponse resp, Map<String, String[]> requestParams, PersistenceManager pm) throws ServiceException {
        String[] q = requestParams.get("q");
        if (q != null && q.length > 0) {
            String query = q[0];
            List<DocumentFolder> rootFolders = this.getRootFolders(req, pm);
            List<FileDescr> files = null;
            if (query.length() >= 3 && !rootFolders.isEmpty()) {
                files = new ArrayList();
                for (DocumentFolder folder : rootFolders) {
                    files.addAll(this.search(req, folder, rootFolders, query));
                }
            } else {
                files = Collections.emptyList();
            }
            FilesResult searchResult = new FilesResult();
            searchResult.setFiles(files);
            this.sendResponse(req, resp, searchResult);
        } else {
            this.sendErrorResponse(req, resp, "errOpen");
        }
    }

    protected void parentsCommand(HttpServletRequest req, HttpServletResponse resp, Map<String, String[]> requestParams, PersistenceManager pm) throws ServiceException {
        String[] targets = requestParams.get("target");
        if (targets != null && targets.length > 0) {
            HttpSession session;
            String target = "".equals(targets[0]) ? "" : this.fromHash(targets[0]);
            if (target.equals((session = req.getSession()).getAttribute("parents.target"))) {
                this.sendErrorResponse(req, resp, "errOpen");
            } else {
                session.setAttribute("parents.target", (Object)target);
                List<DocumentFolder> rootFolders = this.getRootFolders(req, pm);
                ArrayList<FileDescr> parents = new ArrayList<FileDescr>();
                if (!"".equals(target) && !req.getPathInfo().equals(target)) {
                    DocumentFolder folder = (DocumentFolder)pm.getObjectById((Object)new Path(target));
                    for (DocumentFolder current = folder.getParent(); current != null && !rootFolders.contains(current); current = current.getParent()) {
                        parents.addAll(this.ls(req, current, rootFolders, false, true));
                    }
                }
                for (DocumentFolder rootFolder : rootFolders) {
                    parents.add(this.stat(req, rootFolder, rootFolders, true));
                }
                TreeResult treeResult = new TreeResult();
                treeResult.setTree(parents);
                this.sendResponse(req, resp, treeResult);
            }
        } else {
            this.sendErrorResponse(req, resp, "errOpen");
        }
    }

    protected void rmCommand(HttpServletRequest req, HttpServletResponse resp, Map<String, String[]> requestParams, PersistenceManager pm) throws ServiceException {
        String[] targets = requestParams.get("targets[]");
        if (targets != null) {
            ArrayList<String> removed = new ArrayList<String>();
            for (String target : targets) {
                RefObject_1_0 targetObj = (RefObject_1_0)pm.getObjectById((Object)new Path(this.fromHash(target)));
                if (targetObj instanceof DocumentFolder) {
                    DocumentFolder folder = (DocumentFolder)targetObj;
                    try {
                        pm.currentTransaction().begin();
                        folder.setDisabled(true);
                        pm.currentTransaction().commit();
                        removed.add(this.toHash(folder.refGetPath().toXRI()));
                    }
                    catch (Exception e) {
                        try {
                            pm.currentTransaction().rollback();
                        }
                        catch (Exception exception) {}
                    }
                    continue;
                }
                if (!(targetObj instanceof Document)) continue;
                Document document = (Document)targetObj;
                try {
                    pm.currentTransaction().begin();
                    document.setDisabled(true);
                    pm.currentTransaction().commit();
                    removed.add(this.toHash(document.refGetPath().toXRI()));
                }
                catch (Exception e) {
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            FilesOpResult rmResult = new FilesOpResult();
            rmResult.setRemoved(removed);
            this.sendResponse(req, resp, rmResult);
        } else {
            this.sendErrorResponse(req, resp, "errOpen");
        }
    }

    protected void renameCommand(HttpServletRequest req, HttpServletResponse resp, Map<String, String[]> requestParams, PersistenceManager pm) throws ServiceException {
        String[] targets = requestParams.get("target");
        String[] name = requestParams.get("name");
        if (targets != null && targets.length > 0 && name != null && name.length > 0) {
            RefObject_1_0 targetObj = (RefObject_1_0)pm.getObjectById((Object)new Path(this.fromHash(targets[0])));
            String newName = name[0];
            if (targetObj instanceof DocumentFolder) {
                DocumentFolder folder = (DocumentFolder)targetObj;
                try {
                    pm.currentTransaction().begin();
                    folder.setName(newName);
                    pm.currentTransaction().commit();
                }
                catch (Exception e) {
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {}
                }
            } else if (targetObj instanceof Document) {
                Document document = (Document)targetObj;
                try {
                    pm.currentTransaction().begin();
                    document.setName(newName);
                    document.setTitle(newName);
                    if (document.getHeadRevision() != null) {
                        DocumentRevision headRevision = document.getHeadRevision();
                        headRevision.setName(newName);
                        if (headRevision instanceof MediaContent) {
                            ((MediaContent)headRevision).setContentName(newName);
                        }
                    }
                    pm.currentTransaction().commit();
                }
                catch (Exception e) {
                    try {
                        pm.currentTransaction().rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            FilesOpResult renameResult = new FilesOpResult();
            renameResult.setAdded(Collections.emptyList());
            renameResult.setRemoved(Collections.emptyList());
            this.sendResponse(req, resp, renameResult);
        } else {
            this.sendErrorResponse(req, resp, "errOpen");
        }
    }

    protected void fileCommand(HttpServletRequest req, HttpServletResponse resp, Map<String, String[]> requestParams, PersistenceManager pm) throws ServiceException {
        block9: {
            String[] targets = requestParams.get("target");
            boolean isDownload = this.isSet(requestParams.get("download"));
            if (targets != null && targets.length > 0) {
                Document document = (Document)pm.getObjectById((Object)new Path(this.fromHash(targets[0])));
                if (document.getHeadRevision() instanceof MediaContent) {
                    try {
                        boolean isMedia;
                        List<DocumentFolder> rootFolders = this.getRootFolders(req, pm);
                        MediaContent headRevision = (MediaContent)document.getHeadRevision();
                        FileDescr fd = this.stat(req, null, document, rootFolders, false);
                        boolean bl = isMedia = fd.getMime().startsWith("image/") || fd.getMime().startsWith("audio/") || fd.getMime().startsWith("video/");
                        if (isMedia) {
                            ServletOutputStream os = resp.getOutputStream();
                            resp.setStatus(200);
                            resp.setContentType(fd.getMime());
                            resp.setHeader("Content-disposition", (isDownload ? "attachment; " : "inline; ") + "filename=\"" + MimeUtility.encodeText((String)(document.getName() + "\"")));
                            long length = BinaryLargeObjects.streamCopy((InputStream)headRevision.getContent().getContent(), (long)0L, (OutputStream)os);
                            resp.setContentLength((int)length);
                            break block9;
                        }
                        DocumentFolder folder = (DocumentFolder)pm.getObjectById((Object)new Path(this.fromHash(fd.getPhash())));
                        resp.sendRedirect(this.getDocumentUrl(req, folder, document, rootFolders, true));
                    }
                    catch (Exception e) {
                        SysLog.warning((String)"Error sending file", (Throwable)e.getCause());
                        try {
                            this.sendErrorResponse(req, resp, e.getMessage());
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    this.sendErrorResponse(req, resp, "errOpen");
                }
            } else {
                this.sendErrorResponse(req, resp, "errOpen");
            }
        }
    }

    protected void uploadCommand(HttpServletRequest req, HttpServletResponse resp, Map<String, String[]> requestParams, PersistenceManager pm) throws ServiceException {
        String[] targets = requestParams.get("target");
        String[] uploads = requestParams.get("upload[]");
        if (targets != null && targets.length > 0 && uploads != null && uploads.length > 0) {
            DocumentFolder folder = (DocumentFolder)pm.getObjectById((Object)new Path(this.fromHash(targets[0])));
            String providerName = folder.refGetPath().getSegment(2).toString();
            String segmentName = folder.refGetPath().getSegment(4).toString();
            Segment documentSegment = Documents.getInstance().getDocumentSegment(pm, providerName, segmentName);
            List<DocumentFolder> rootFolders = this.getRootFolders(req, pm);
            ArrayList<FileDescr> added = new ArrayList<FileDescr>();
            for (int i = 0; i < uploads.length; ++i) {
                try {
                    List principalChain = UserObjects.getPrincipalChain((PersistenceManager)pm);
                    String author = null;
                    if (principalChain != null) {
                        author = principalChain.size() == 1 ? (String)principalChain.get(0) : principalChain.toString();
                    }
                    String name = uploads[i];
                    String resourceLocation = this.getTempFileName(req, "upload[]", Integer.toString(i + 1));
                    BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(resourceLocation + ".INFO"), "UTF-8"));
                    String contentMimeType = r.readLine();
                    String contentName = r.readLine();
                    r.close();
                    DocumentBasedFolderEntryQuery folderEntryQuery = (DocumentBasedFolderEntryQuery)pm.newQuery(DocumentBasedFolderEntry.class);
                    folderEntryQuery.forAllDisabled().isFalse();
                    folderEntryQuery.name().equalTo((Object)name);
                    Document document = null;
                    List folderEntries = folder.getFolderEntry(folderEntryQuery);
                    if (folderEntries.isEmpty()) {
                        pm.currentTransaction().begin();
                        document = (Document)pm.newInstance(Document.class);
                        document.setName(name);
                        document.setAuthor(author);
                        document.setActiveOn(new Date());
                        document.setContentType(contentMimeType);
                        document.getFolder().add(folder);
                        document.getOwningGroup().addAll(folder.getOwningGroup());
                        documentSegment.addDocument(Utils.getUidAsString(), document);
                        pm.currentTransaction().commit();
                    } else {
                        document = (Document)((DocumentBasedFolderEntry)folderEntries.iterator().next()).getDocument();
                    }
                    pm.currentTransaction().begin();
                    Documents.getInstance().addRevision(document, contentName, contentMimeType, author, BinaryLargeObjects.valueOf((File)new File(resourceLocation)));
                    pm.currentTransaction().commit();
                    added.add(this.stat(req, folder, document, rootFolders, false));
                    continue;
                }
                catch (Exception e) {
                    new ServiceException(e).log();
                    this.sendErrorResponse(req, resp, e.getMessage());
                }
            }
            FilesOpResult uploadResult = new FilesOpResult();
            uploadResult.setAdded(added);
            this.sendResponse(req, resp, uploadResult);
        } else {
            this.sendErrorResponse(req, resp, "errOpen");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PersistenceManager pm = null;
        HttpSession session = req.getSession(true);
        try {
            pm = this.getPersistenceManager(req);
            req.setCharacterEncoding("UTF-8");
            Map<String, String[]> requestParams = this.parseRequest(req);
            String[] command = requestParams.get("cmd");
            if (command != null && command.length > 0) {
                String cmd = command[0];
                if ("mkdir".equalsIgnoreCase(cmd)) {
                    this.mkdirCommand(req, resp, requestParams, pm);
                } else if ("open".equalsIgnoreCase(cmd)) {
                    this.openCommand(req, resp, requestParams, pm);
                } else if ("rename".equalsIgnoreCase(cmd)) {
                    this.renameCommand(req, resp, requestParams, pm);
                } else if ("rm".equalsIgnoreCase(cmd)) {
                    this.rmCommand(req, resp, requestParams, pm);
                } else if ("parents".equalsIgnoreCase(cmd)) {
                    this.parentsCommand(req, resp, requestParams, pm);
                } else if ("tree".equalsIgnoreCase(cmd)) {
                    this.treeCommand(req, resp, requestParams, pm);
                } else if ("ls".equalsIgnoreCase(cmd)) {
                    this.lsCommand(req, resp, requestParams, pm);
                } else if ("file".equalsIgnoreCase(cmd)) {
                    this.fileCommand(req, resp, requestParams, pm);
                } else if ("upload".equalsIgnoreCase(cmd)) {
                    this.uploadCommand(req, resp, requestParams, pm);
                } else if ("search".equalsIgnoreCase(cmd)) {
                    this.searchCommand(req, resp, requestParams, pm);
                } else {
                    this.sendErrorResponse(req, resp, "Unknown Command");
                }
            } else {
                this.sendErrorResponse(req, resp, "Unknown Command");
            }
        }
        catch (Exception e) {
            new ServiceException(e).log();
            try {
                this.sendErrorResponse(req, resp, e.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            if (pm != null) {
                try {
                    pm.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    static class FilesOpResult {
        private List<String> removed;
        private List<FileDescr> added;

        FilesOpResult() {
        }

        public List<FileDescr> getAdded() {
            return this.added;
        }

        public void setAdded(List<FileDescr> added) {
            this.added = added;
        }

        public List<String> getRemoved() {
            return this.removed;
        }

        public void setRemoved(List<String> removed) {
            this.removed = removed;
        }
    }

    static class FilesResult {
        private List<FileDescr> files;

        FilesResult() {
        }

        public List<FileDescr> getFiles() {
            return this.files;
        }

        public void setFiles(List<FileDescr> files) {
            this.files = files;
        }
    }

    static class LsResult {
        private List<FileDescr> list;

        LsResult() {
        }

        public List<FileDescr> getList() {
            return this.list;
        }

        public void setList(List<FileDescr> list) {
            this.list = list;
        }
    }

    static class OpenResult {
        private FileDescr cwd;
        private List<FileDescr> files;
        private List<String> netDrivers;
        private int api;

        OpenResult() {
        }

        public FileDescr getCwd() {
            return this.cwd;
        }

        public void setCwd(FileDescr cwd) {
            this.cwd = cwd;
        }

        public List<FileDescr> getFiles() {
            return this.files;
        }

        public void setFiles(List<FileDescr> files) {
            this.files = files;
        }

        public List<String> getNetDrivers() {
            return this.netDrivers;
        }

        public void setNetDrivers(List<String> netDrivers) {
            this.netDrivers = netDrivers;
        }

        public int getApi() {
            return this.api;
        }

        public void setApi(int api) {
            this.api = api;
        }
    }

    static class TreeResult {
        private List<FileDescr> tree;

        TreeResult() {
        }

        public List<FileDescr> getTree() {
            return this.tree;
        }

        public void setTree(List<FileDescr> tree) {
            this.tree = tree;
        }
    }

    static class FileDescr {
        private String hash;
        private String phash;
        private String name;
        private String mime;
        private String rel;
        private long size;
        private Date date;
        private Boolean read;
        private Boolean write;
        private Boolean rm;
        private String url;
        private String volumeid;
        private Boolean dirs;

        FileDescr() {
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMime() {
            return this.mime;
        }

        public void setMime(String mime) {
            this.mime = mime;
        }

        public String getRel() {
            return this.rel;
        }

        public void setRel(String rel) {
            this.rel = rel;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public Boolean isRead() {
            return this.read;
        }

        public void setRead(Boolean read) {
            this.read = read;
        }

        public Boolean isRm() {
            return this.rm;
        }

        public void setRm(Boolean rm) {
            this.rm = rm;
        }

        public Boolean isWrite() {
            return this.write;
        }

        public void setWrite(Boolean write) {
            this.write = write;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Boolean getDirs() {
            return this.dirs;
        }

        public void setDirs(Boolean dirs) {
            this.dirs = dirs;
        }

        public String getPhash() {
            return this.phash;
        }

        public void setPhash(String phash) {
            this.phash = phash;
        }

        public String getVolumeid() {
            return this.volumeid;
        }

        public void setVolumeid(String volumeid) {
            this.volumeid = volumeid;
        }
    }

    static class ErrorResult {
        private String error;

        ErrorResult() {
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}

