/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.document;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.activity1.jmi1.Activity;
import org.opencrx.kernel.backend.Documents;
import org.opencrx.kernel.document1.cci2.DocumentFolderEntryQuery;
import org.opencrx.kernel.document1.cci2.DocumentFolderQuery;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentFolder;
import org.opencrx.kernel.document1.jmi1.DocumentFolderEntry;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.opencrx.kernel.document1.jmi1.Segment;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.utils.Utils;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.BasicObject;
import org.openmdx.base.text.conversion.Base64;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.BinaryLargeObjects;

public class DocumentSpaceServlet
extends HttpServlet {
    private static final long serialVersionUID = -1420175264506058947L;
    protected static List<String> WELL_DEFINED_RESOURCES = Arrays.asList("/js/jquery.min.js", "/js/bootstrap.min.js", "/js/jquery.blueimp-gallery.min.js", "/css/bootstrap.min.css", "/css/blueimp-gallery.min.css");
    protected List<String> folderPrefix = Collections.emptyList();
    protected String runAs = null;
    protected PersistenceManagerFactory pmf = null;

    public void init(ServletConfig config) throws ServletException {
        String folderPrefix;
        super.init();
        if (this.pmf == null) {
            try {
                Utils.getModel();
                this.pmf = Utils.getPersistenceManagerFactory();
            }
            catch (ServiceException e) {
                throw new ServletException("Can not get persistence manager", (Throwable)e);
            }
        }
        if ((folderPrefix = config.getInitParameter("folderPrefix")) != null) {
            this.folderPrefix = Arrays.asList(folderPrefix.split("/"));
        }
        this.runAs = config.getInitParameter("runAs");
    }

    protected PersistenceManager getPersistenceManager(String segmentName) {
        return this.pmf.getPersistenceManager((String)(this.runAs == null ? "admin" + SecurityKeys.ID_SEPARATOR + segmentName : this.runAs), null);
    }

    protected boolean sendFile(HttpServletRequest req, HttpServletResponse resp, String resourcePath) throws IOException {
        resp.setContentType(req.getServletContext().getMimeType(resourcePath));
        InputStream is = req.getServletContext().getResourceAsStream(resourcePath);
        if (is == null) {
            return false;
        }
        resp.setStatus(200);
        ServletOutputStream os = resp.getOutputStream();
        BinaryLargeObjects.streamCopy((InputStream)is, (long)0L, (OutputStream)os);
        os.close();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object servletPath = req.getServletPath();
        PersistenceManager pm = null;
        HttpSession session = req.getSession(true);
        try {
            for (String string : WELL_DEFINED_RESOURCES) {
                if (!((String)servletPath).endsWith(string)) continue;
                if (this.sendFile(req, resp, string)) return;
                req.getServletContext().log("file not found " + (String)servletPath);
                resp.sendError(404, "Not found");
                return;
            }
        }
        catch (Exception e) {
            resp.sendError(500);
            new ServiceException(e).log();
            return;
        }
        while (true) {
            int index;
            ArrayList<String> path = new ArrayList<String>();
            path.addAll(this.folderPrefix);
            for (String component : ((String)servletPath).split("/")) {
                if (component.isEmpty()) continue;
                path.add(component);
            }
            if (this.folderPrefix.isEmpty() && path.size() >= 3 && !"Spaces".equals(path.get(2))) {
                path.add(2, "Spaces");
            }
            if (path.size() < 3) {
                req.getServletContext().log("document not found " + (String)servletPath);
                resp.sendError(404, "Not found");
                return;
            }
            if (".passwd".equals(path.get(path.size() - 1))) {
                resp.sendError(403);
                return;
            }
            String string = (String)path.get(0);
            String segmentName = (String)path.get(1);
            pm = this.getPersistenceManager(segmentName);
            DocumentFolder documentFolder = null;
            Segment documentSegment = Documents.getInstance().getDocumentSegment(pm, string, segmentName);
            for (index = 2; index < path.size() - 1; ++index) {
                String password;
                String credentials;
                int p;
                String authType;
                Document passwdDocument;
                DocumentFolderEntry passwdEntry;
                List documentFolders;
                String component = (String)path.get(index);
                DocumentFolderQuery documentFolderQuery = (DocumentFolderQuery)pm.newQuery(DocumentFolder.class);
                documentFolderQuery.name().equalTo((Object)component);
                documentFolderQuery.forAllDisabled().isFalse();
                if (documentFolder != null) {
                    documentFolderQuery.thereExistsParent().equalTo(documentFolder);
                }
                if ((documentFolders = documentSegment.getFolder(documentFolderQuery)).isEmpty()) break;
                documentFolder = (DocumentFolder)documentFolders.iterator().next();
                if (Boolean.TRUE.equals(session.getAttribute(documentFolder.refGetPath().toXRI() + ".auth"))) continue;
                DocumentFolderEntryQuery entryQuery = (DocumentFolderEntryQuery)pm.newQuery(DocumentFolderEntry.class);
                entryQuery.name().equalTo((Object)".passwd");
                List entries = documentFolder.getFolderEntry(entryQuery);
                if (entries.isEmpty() || !((passwdEntry = (DocumentFolderEntry)entries.iterator().next()).getDocument() instanceof Document) || !((passwdDocument = (Document)passwdEntry.getDocument()).getHeadRevision() instanceof MediaContent)) continue;
                MediaContent passwdContent = (MediaContent)passwdDocument.getHeadRevision();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                BinaryLargeObjects.streamCopy((InputStream)passwdContent.getContent().getContent(), (long)0L, (OutputStream)os);
                String passwd = os.toString("UTF-8");
                String authHeader = req.getHeader("Authorization");
                if (authHeader == null) {
                    resp.setStatus(401);
                    resp.setHeader("WWW-Authenticate", "basic realm=\"" + path.subList(0, index + 1) + "\"");
                    return;
                }
                StringTokenizer st = new StringTokenizer(authHeader);
                if (!st.hasMoreTokens() || !"Basic".equals(authType = st.nextToken()) || (p = (credentials = new String(Base64.decode((String)st.nextToken()), "UTF-8")).indexOf(":")) == -1) continue;
                String user = credentials.substring(0, p).trim();
                if (passwd.indexOf(user + ":" + (password = credentials.substring(p + 1).trim())) < 0) {
                    resp.sendError(403, "Forbidden");
                    return;
                }
                session.setAttribute(documentFolder.refGetPath().toXRI() + ".auth", (Object)Boolean.TRUE);
            }
            DocumentFolderEntry entry = null;
            if (documentFolder != null) {
                DocumentFolderEntryQuery entryQuery = (DocumentFolderEntryQuery)pm.newQuery(DocumentFolderEntry.class);
                entryQuery.name().equalTo(path.get(index));
                entryQuery.forAllDisabled().isFalse();
                List entries = documentFolder.getFolderEntry(entryQuery);
                DocumentFolderEntry documentFolderEntry = entry = entries.isEmpty() ? null : (DocumentFolderEntry)entries.iterator().next();
            }
            if (entry != null && entry.getDocument() != null) {
                PrintWriter pw;
                BasicObject object = entry.getDocument();
                if (object instanceof Document) {
                    Document document = (Document)object;
                    MediaContent mediaContent = (MediaContent)document.getHeadRevision();
                    resp.setContentType(mediaContent.getContentMimeType());
                    InputStream is = mediaContent.getContent().getContent();
                    resp.setStatus(200);
                    ServletOutputStream os = resp.getOutputStream();
                    BinaryLargeObjects.streamCopy((InputStream)is, (long)0L, (OutputStream)os);
                    os.close();
                    return;
                }
                if (object instanceof Account) {
                    Account account = (Account)object;
                    resp.setContentType("text/x-vcard");
                    resp.setStatus(200);
                    pw = resp.getWriter();
                    pw.print(account.getVcard());
                    pw.close();
                    return;
                }
                if (object instanceof Activity) {
                    Activity activity = (Activity)object;
                    resp.setContentType("text/calendar");
                    resp.setStatus(200);
                    pw = resp.getWriter();
                    pw.print(activity.getIcal());
                    pw.close();
                    return;
                }
                resp.sendError(500);
                SysLog.warning((String)"Unsupported entry type", (Object)entry);
                return;
            }
            if (this.sendFile(req, resp, (String)servletPath)) return;
            if (((String)servletPath).endsWith("/index.html") || !((String)servletPath).endsWith("/")) {
                req.getServletContext().log("file not found " + (String)servletPath);
                resp.sendError(404, "Not found");
                return;
            }
            servletPath = (String)servletPath + "index.html";
        }
        finally {
            if (pm != null) {
                try {
                    pm.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

