/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.com.auxilii.msgparser;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opencrx.application.uses.com.auxilii.msgparser.RecipientEntry;
import org.opencrx.application.uses.com.auxilii.msgparser.attachment.Attachment;
import org.opencrx.application.uses.net.freeutils.tnef.TNEFUtils;

public class Message {
    protected static final Logger logger = Logger.getLogger(Message.class.getName());
    protected String messageClass = "IPM.Note";
    protected String messageId = null;
    protected String fromEmail = null;
    protected String fromName = null;
    protected String toEmail = null;
    protected String toName = null;
    protected String subject = null;
    protected String bodyText = null;
    protected String displayTo = null;
    protected String displayCc = null;
    protected String displayBcc = null;
    protected String bodyRTF = null;
    protected String headers = null;
    protected Date date = null;
    protected List<Attachment> attachments = new ArrayList<Attachment>();
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected List<RecipientEntry> recipients = new ArrayList<RecipientEntry>();

    public void addAttachment(Attachment attachment) {
        this.attachments.add(attachment);
    }

    public void addRecipient(RecipientEntry recipient) {
        this.recipients.add(recipient);
    }

    public void setProperty(String name, Object value) throws ClassCastException {
        if (name == null || value == null) {
            return;
        }
        if ((name = name.intern()) == "001a") {
            this.setMessageClass((String)value);
        } else if (name == "1035") {
            this.setMessageId((String)value);
        } else if (name == "0037") {
            this.setSubject((String)value);
        } else if (name == "0c1f") {
            this.setFromEmail((String)value);
        } else if (name == "0042") {
            this.setFromName((String)value);
        } else if (name == "0076") {
            this.setToEmail((String)value);
        } else if (name == "3001") {
            this.setToName((String)value);
        } else if (name == "0e04") {
            this.setDisplayTo((String)value);
        } else if (name == "0e03") {
            this.setDisplayCc((String)value);
        } else if (name == "0e02") {
            this.setDisplayBcc((String)value);
        } else if (name == "1000") {
            if (value instanceof String) {
                this.setBodyText((String)value);
            } else if (value instanceof byte[]) {
                this.setBodyText(new String((byte[])value));
            } else {
                logger.log(Level.FINE, "Unexpected body class: " + value.getClass().getName());
                this.setBodyText(value.toString());
            }
        } else if (name == "1009") {
            if (value instanceof byte[]) {
                byte[] compressedRTF = (byte[])value;
                try {
                    byte[] decompressedRTF = TNEFUtils.decompressRTF(compressedRTF);
                    this.setBodyRTF(new String(decompressedRTF));
                }
                catch (Exception e) {
                    logger.log(Level.FINEST, "Could not decompress RTF data", e);
                }
            } else {
                logger.log(Level.FINEST, "Unexpected data type " + value.getClass());
            }
        } else if (name == "007d") {
            String headers = (String)value;
            this.setHeaders(headers);
            Date date = Message.getDateFromHeaders(headers);
            if (date != null) {
                this.setDate(date);
            }
        }
        this.properties.put(name, value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("From: " + this.createMailString(this.fromEmail, this.fromName) + "\n");
        sb.append("To: " + this.createMailString(this.toEmail, this.toName) + "\n");
        if (this.date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            sb.append("Date: " + formatter.format(this.date) + "\n");
        }
        if (this.subject != null) {
            sb.append("Subject: " + this.subject + "\n");
        }
        sb.append(this.attachments.size() + " attachments.");
        return sb.toString();
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append("From: " + this.createMailString(this.fromEmail, this.fromName) + "\n");
        sb.append("To: " + this.createMailString(this.toEmail, this.toName) + "\n");
        if (this.date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            sb.append("Date: " + formatter.format(this.date) + "\n");
        }
        if (this.subject != null) {
            sb.append("Subject: " + this.subject + "\n");
        }
        sb.append("\n");
        if (this.bodyText != null) {
            sb.append(this.bodyText);
        }
        if (this.attachments.size() > 0) {
            sb.append("\n");
            sb.append(this.attachments.size() + " attachments.\n");
            for (Attachment att : this.attachments) {
                sb.append(att.toString() + "\n");
            }
        }
        return sb.toString();
    }

    public String createMailString(String mail, String name) {
        if (mail == null && name == null) {
            return null;
        }
        if (name == null) {
            return mail;
        }
        if (mail == null) {
            return name;
        }
        if (mail.equalsIgnoreCase(name)) {
            return mail;
        }
        return "\"" + name + "\" <" + mail + ">";
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public List<RecipientEntry> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(List<RecipientEntry> recipients) {
        this.recipients = recipients;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public void setBodyText(String bodyText) {
        if (bodyText != null) {
            bodyText = bodyText.trim();
        }
        this.bodyText = bodyText;
    }

    public String getFromEmail() {
        return this.fromEmail;
    }

    public void setFromEmail(String fromEmail) {
        if (fromEmail != null) {
            fromEmail = fromEmail.trim();
        }
        this.fromEmail = fromEmail;
    }

    public String getFromName() {
        return this.fromName;
    }

    public void setFromName(String fromName) {
        if (fromName != null) {
            fromName = fromName.trim();
        }
        this.fromName = fromName;
    }

    public String getDisplayTo() {
        return this.displayTo;
    }

    public void setDisplayTo(String displayTo) {
        this.displayTo = displayTo;
    }

    public String getDisplayCc() {
        return this.displayCc;
    }

    public void setDisplayCc(String displayCc) {
        this.displayCc = displayCc;
    }

    public String getDisplayBcc() {
        return this.displayBcc;
    }

    public void setDisplayBcc(String displayBcc) {
        this.displayBcc = displayBcc;
    }

    public String getMessageClass() {
        return this.messageClass;
    }

    public void setMessageClass(String messageClass) {
        this.messageClass = messageClass;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        if (subject != null) {
            subject = subject.trim();
        }
        this.subject = subject;
    }

    public String getToEmail() {
        return this.toEmail;
    }

    public void setToEmail(String toEmail) {
        if (toEmail != null) {
            toEmail = toEmail.trim();
        }
        this.toEmail = toEmail;
    }

    public String getToName() {
        return this.toName;
    }

    public void setToName(String toName) {
        if (toName != null) {
            toName = toName.trim();
        }
        this.toName = toName;
    }

    public String getBodyRTF() {
        return this.bodyRTF;
    }

    public void setBodyRTF(String bodyRTF) {
        if (bodyRTF != null) {
            bodyRTF = bodyRTF.trim();
        }
        this.bodyRTF = bodyRTF;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public static Date getDateFromHeaders(String headers) {
        String[] headerLines;
        if (headers == null) {
            return null;
        }
        for (String headerLine : headerLines = headers.split("\n")) {
            if (!headerLine.toLowerCase().startsWith("date:")) continue;
            String dateValue = headerLine.substring("Date:".length()).trim();
            SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            try {
                Date date = formatter.parse(dateValue);
                if (date == null) continue;
                return date;
            }
            catch (Exception e) {
                logger.log(Level.FINEST, "Could not parse date " + dateValue, e);
            }
        }
        return null;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Set<String> getProperties() {
        return this.properties.keySet();
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }
}

