/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.List;
import org.opencrx.application.uses.ezvcard.Messages;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.EmbeddedVCardException;
import org.opencrx.application.uses.ezvcard.io.SkipMeException;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.Agent;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;

public class AgentScribe
extends VCardPropertyScribe<Agent> {
    public AgentScribe() {
        super(Agent.class, "AGENT");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return null;
    }

    @Override
    protected VCardDataType _dataType(Agent property, VCardVersion version) {
        if (property.getUrl() != null) {
            return version == VCardVersion.V2_1 ? VCardDataType.URL : VCardDataType.URI;
        }
        return null;
    }

    @Override
    protected String _writeText(Agent property, VCardVersion version) {
        String url = property.getUrl();
        if (url != null) {
            return url;
        }
        VCard vcard = property.getVCard();
        if (vcard != null) {
            throw new EmbeddedVCardException(vcard);
        }
        throw new SkipMeException(Messages.INSTANCE.getValidationWarning(8, new Object[0]));
    }

    @Override
    protected Agent _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        Agent property = new Agent();
        if (dataType == null) {
            throw new EmbeddedVCardException(new Injector(property));
        }
        property.setUrl(AgentScribe.unescape(value));
        return property;
    }

    private static class Injector
    implements EmbeddedVCardException.InjectionCallback {
        private final Agent property;

        public Injector(Agent property) {
            this.property = property;
        }

        @Override
        public void injectVCard(VCard vcard) {
            this.property.setVCard(vcard);
        }

        @Override
        public VCardProperty getProperty() {
            return this.property;
        }
    }
}

