/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.io.scribe;

import java.util.HashMap;
import java.util.List;
import org.opencrx.application.uses.ezvcard.VCardDataType;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.io.CannotParseException;
import org.opencrx.application.uses.ezvcard.io.scribe.VCardPropertyScribe;
import org.opencrx.application.uses.ezvcard.io.xml.XCardElement;
import org.opencrx.application.uses.ezvcard.parameter.VCardParameters;
import org.opencrx.application.uses.ezvcard.property.Xml;
import org.opencrx.application.uses.ezvcard.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlScribe
extends VCardPropertyScribe<Xml> {
    public XmlScribe() {
        super(Xml.class, "XML");
    }

    @Override
    protected VCardDataType _defaultDataType(VCardVersion version) {
        return VCardDataType.TEXT;
    }

    @Override
    protected String _writeText(Xml property, VCardVersion version) {
        Document value = (Document)property.getValue();
        if (value == null) {
            return "";
        }
        String xml = this.valueToString(value);
        return XmlScribe.escape(xml);
    }

    @Override
    protected Xml _parseText(String value, VCardDataType dataType, VCardVersion version, VCardParameters parameters, List<String> warnings) {
        value = XmlScribe.unescape(value);
        try {
            return new Xml(value);
        }
        catch (SAXException e) {
            throw new CannotParseException("Cannot parse value as XML: " + value);
        }
    }

    @Override
    protected void _writeXml(Xml property, XCardElement element) {
        super._writeXml(property, element);
    }

    @Override
    protected Xml _parseXml(XCardElement element, VCardParameters parameters, List<String> warnings) {
        Xml xml = new Xml(element.element());
        Element root = XmlUtils.getRootElement((Document)xml.getValue());
        for (Element child : XmlUtils.toElementList(root.getChildNodes())) {
            if (!"parameters".equals(child.getLocalName()) || !VCardVersion.V4_0.getXmlNamespace().equals(child.getNamespaceURI())) continue;
            root.removeChild(child);
        }
        return xml;
    }

    private String valueToString(Document document) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("omit-xml-declaration", "yes");
        return XmlUtils.toString(document, props);
    }
}

