/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.property;

import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencrx.application.uses.ezvcard.VCard;
import org.opencrx.application.uses.ezvcard.VCardVersion;
import org.opencrx.application.uses.ezvcard.ValidationWarnings;
import org.opencrx.application.uses.ezvcard.Warning;
import org.opencrx.application.uses.ezvcard.property.VCardProperty;

public class Agent
extends VCardProperty {
    private String url;
    private VCard vcard;

    public Agent() {
    }

    public Agent(String url) {
        this.setUrl(url);
    }

    public Agent(VCard vcard) {
        this.setVCard(vcard);
    }

    @Override
    public Set<VCardVersion> _supportedVersions() {
        return EnumSet.of(VCardVersion.V2_1, VCardVersion.V3_0);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.vcard = null;
    }

    public VCard getVCard() {
        return this.vcard;
    }

    public void setVCard(VCard vcard) {
        this.vcard = vcard;
        this.url = null;
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        if (this.url == null && this.vcard == null) {
            warnings.add(new Warning(8, new Object[0]));
        }
        if (this.vcard != null) {
            NumberFormat nf = NumberFormat.getIntegerInstance();
            nf.setMinimumIntegerDigits(2);
            ValidationWarnings validationWarnings = this.vcard.validate(version);
            for (Map.Entry<VCardProperty, List<Warning>> entry : validationWarnings) {
                VCardProperty property = entry.getKey();
                List<Warning> propViolations = entry.getValue();
                for (Warning propViolation : propViolations) {
                    String className = property == null ? "" : property.getClass().getSimpleName();
                    int code = propViolation.getCode();
                    String codeStr = code >= 0 ? "W" + nf.format(code) : "";
                    String message = propViolation.getMessage();
                    warnings.add(new Warning(10, className, codeStr, message));
                }
            }
        }
    }
}

