/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.ezvcard.util;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencrx.application.uses.ezvcard.util.UtcOffset;

public final class PartialDate {
    private static final int SKIP = -1;
    private static final int YEAR = 0;
    private static final int MONTH = 1;
    private static final int DATE = 2;
    private static final int HOUR = 3;
    private static final int MINUTE = 4;
    private static final int SECOND = 5;
    private static final int TIMEZONE_HOUR = 6;
    private static final int TIMEZONE_MINUTE = 7;
    private static final Format[] dateFormats = new Format[]{new Format("(\\d{4})", 0), new Format("(\\d{4})-(\\d{2})", 0, 1), new Format("(\\d{4})-?(\\d{2})-?(\\d{2})", 0, 1, 2), new Format("--(\\d{2})-?(\\d{2})", 1, 2), new Format("--(\\d{2})", 1), new Format("---(\\d{2})", 2)};
    private static final String timezoneRegex = "(([-+]\\d{1,2}):?(\\d{2})?)?";
    private static final Format[] timeFormats = new Format[]{new Format("(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 3, -1, 6, 7), new Format("(\\d{2}):?(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 3, 4, -1, 6, 7), new Format("(\\d{2}):?(\\d{2}):?(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 3, 4, 5, -1, 6, 7), new Format("-(\\d{2}):?(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 4, 5, -1, 6, 7), new Format("-(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 4, -1, 6, 7), new Format("--(\\d{2})(([-+]\\d{1,2}):?(\\d{2})?)?", 5, -1, 6, 7)};
    final Integer[] components = new Integer[8];

    public static PartialDate date(Integer year, Integer month, Integer date) {
        return new PartialDate(year, month, date, null, null, null, null);
    }

    public static PartialDate time(Integer hour, Integer minute, Integer second) {
        return PartialDate.time(hour, minute, second, null);
    }

    public static PartialDate time(Integer hour, Integer minute, Integer second, UtcOffset offset) {
        return new PartialDate(null, null, null, hour, minute, second, offset);
    }

    public static PartialDate dateTime(Integer year, Integer month, Integer date, Integer hour, Integer minute, Integer second) {
        return PartialDate.dateTime(year, month, date, hour, minute, second, null);
    }

    public static PartialDate dateTime(Integer year, Integer month, Integer date, Integer hour, Integer minute, Integer second, UtcOffset offset) {
        return new PartialDate(year, month, date, hour, minute, second, offset);
    }

    public PartialDate(Integer year, Integer month, Integer date, Integer hour, Integer minute, Integer second, UtcOffset offset) {
        if (month != null && (month < 1 || month > 12)) {
            throw new IllegalArgumentException("Month must be between 1 and 12 inclusive.");
        }
        if (date != null && (date < 1 || date > 31)) {
            throw new IllegalArgumentException("Date must be between 1 and 31 inclusive.");
        }
        if (hour != null && (hour < 0 || hour > 23)) {
            throw new IllegalArgumentException("Hour must be between 0 and 23 inclusive.");
        }
        if (minute != null && (minute < 0 || minute > 59)) {
            throw new IllegalArgumentException("Minute must be between 0 and 59 inclusive.");
        }
        if (second != null && (second < 0 || second > 59)) {
            throw new IllegalArgumentException("Second must be between 0 and 59 inclusive.");
        }
        if (offset != null && (offset.getMinute() < 0 || offset.getMinute() > 59)) {
            throw new IllegalArgumentException("Timezone minute must be between 0 and 59 inclusive.");
        }
        if (year != null && month == null && date != null) {
            throw new IllegalArgumentException("Invalid date component combination: year, date");
        }
        if (hour != null && minute == null && second != null) {
            throw new IllegalArgumentException("Invalid time component combination: hour, second");
        }
        this.components[0] = year;
        this.components[1] = month;
        this.components[2] = date;
        this.components[3] = hour;
        this.components[4] = minute;
        this.components[5] = second;
        this.components[6] = offset == null ? null : Integer.valueOf(offset.getHour());
        this.components[7] = offset == null ? null : Integer.valueOf(offset.getMinute());
    }

    public PartialDate(String string) {
        boolean success;
        String[] split = string.split("T");
        if (split.length == 1) {
            success = this.parseDate(string) || this.parseTime(string);
        } else if (split[0].length() == 0) {
            success = this.parseTime(split[1]);
        } else {
            boolean bl = success = this.parseDate(split[0]) && this.parseTime(split[1]);
        }
        if (!success) {
            throw new IllegalArgumentException("Could not parse date: " + string);
        }
    }

    private boolean parseDate(String value) {
        for (Format regex : dateFormats) {
            if (!regex.parse(this, value)) continue;
            return true;
        }
        return false;
    }

    private boolean parseTime(String value) {
        for (Format regex : timeFormats) {
            if (!regex.parse(this, value)) continue;
            return true;
        }
        return false;
    }

    public Integer getYear() {
        return this.components[0];
    }

    private boolean hasYear() {
        return this.getYear() != null;
    }

    public Integer getMonth() {
        return this.components[1];
    }

    private boolean hasMonth() {
        return this.getMonth() != null;
    }

    public Integer getDate() {
        return this.components[2];
    }

    private boolean hasDate() {
        return this.getDate() != null;
    }

    public Integer getHour() {
        return this.components[3];
    }

    private boolean hasHour() {
        return this.getHour() != null;
    }

    public Integer getMinute() {
        return this.components[4];
    }

    private boolean hasMinute() {
        return this.getMinute() != null;
    }

    public Integer getSecond() {
        return this.components[5];
    }

    private boolean hasSecond() {
        return this.getSecond() != null;
    }

    public Integer[] getTimezone() {
        if (!this.hasTimezone()) {
            return null;
        }
        return new Integer[]{this.components[6], this.components[7]};
    }

    private boolean hasTimezone() {
        return this.components[6] != null;
    }

    public boolean hasDateComponent() {
        return this.hasYear() || this.hasMonth() || this.hasDate();
    }

    public boolean hasTimeComponent() {
        return this.hasHour() || this.hasMinute() || this.hasSecond();
    }

    public String toDateAndOrTime(boolean extended) {
        String dash;
        StringBuilder sb = new StringBuilder();
        DecimalFormat nf = new DecimalFormat("00");
        String yearStr = this.hasYear() ? this.getYear().toString() : null;
        String monthStr = this.hasMonth() ? nf.format(this.getMonth()) : null;
        String dateStr = this.hasDate() ? nf.format(this.getDate()) : null;
        String string = dash = extended ? "-" : "";
        if (this.hasYear() && !this.hasMonth() && !this.hasDate()) {
            sb.append(yearStr);
        } else if (!this.hasYear() && this.hasMonth() && !this.hasDate()) {
            sb.append("--").append(monthStr);
        } else if (!this.hasYear() && !this.hasMonth() && this.hasDate()) {
            sb.append("---").append(dateStr);
        } else if (this.hasYear() && this.hasMonth() && !this.hasDate()) {
            sb.append(yearStr).append("-").append(monthStr);
        } else if (!this.hasYear() && this.hasMonth() && this.hasDate()) {
            sb.append("--").append(monthStr).append(dash).append(dateStr);
        } else {
            if (this.hasYear() && !this.hasMonth() && this.hasDate()) {
                throw new IllegalStateException("Invalid date component combination: year, date");
            }
            if (this.hasYear() && this.hasMonth() && this.hasDate()) {
                sb.append(yearStr).append(dash).append(monthStr).append(dash).append(dateStr);
            }
        }
        if (this.hasTimeComponent()) {
            sb.append('T');
            String hourStr = this.hasHour() ? nf.format(this.getHour()) : null;
            String minuteStr = this.hasMinute() ? nf.format(this.getMinute()) : null;
            String secondStr = this.hasSecond() ? nf.format(this.getSecond()) : null;
            String string2 = dash = extended ? ":" : "";
            if (this.hasHour() && !this.hasMinute() && !this.hasSecond()) {
                sb.append(hourStr);
            } else if (!this.hasHour() && this.hasMinute() && !this.hasSecond()) {
                sb.append("-").append(minuteStr);
            } else if (!this.hasHour() && !this.hasMinute() && this.hasSecond()) {
                sb.append("--").append(secondStr);
            } else if (this.hasHour() && this.hasMinute() && !this.hasSecond()) {
                sb.append(hourStr).append(dash).append(minuteStr);
            } else if (!this.hasHour() && this.hasMinute() && this.hasSecond()) {
                sb.append("-").append(minuteStr).append(dash).append(secondStr);
            } else {
                if (this.hasHour() && !this.hasMinute() && this.hasSecond()) {
                    throw new IllegalStateException("Invalid time component combination: hour, second");
                }
                if (this.hasHour() && this.hasMinute() && this.hasSecond()) {
                    sb.append(hourStr).append(dash).append(minuteStr).append(dash).append(secondStr);
                }
            }
            if (this.hasTimezone()) {
                Integer[] timezone = this.getTimezone();
                if (timezone[1] == null) {
                    timezone[1] = 0;
                }
                sb.append(new UtcOffset(timezone[0], timezone[1]).toString(extended));
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.components);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartialDate other = (PartialDate)obj;
        return Arrays.equals((Object[])this.components, (Object[])other.components);
    }

    public String toString() {
        return this.toDateAndOrTime(true);
    }

    private static class Format {
        private Pattern regex;
        private int[] componentIndexes;

        public Format(String regex, int ... componentIndexes) {
            this.regex = Pattern.compile("^" + regex + "$");
            this.componentIndexes = componentIndexes;
        }

        public boolean parse(PartialDate partialDate, String value) {
            Matcher m = this.regex.matcher(value);
            if (m.find()) {
                for (int i = 0; i < this.componentIndexes.length; ++i) {
                    int group;
                    String groupStr;
                    int index = this.componentIndexes[i];
                    if (index == -1 || (groupStr = m.group(group = i + 1)) == null) continue;
                    if (groupStr.startsWith("+")) {
                        groupStr = groupStr.substring(1);
                    }
                    partialDate.components[index] = Integer.valueOf(groupStr);
                }
                return true;
            }
            return false;
        }
    }
}

