/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.freeutils.tnef;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import org.opencrx.application.uses.net.freeutils.tnef.CompressedRTFInputStream;
import org.opencrx.application.uses.net.freeutils.tnef.GUID;
import org.opencrx.application.uses.net.freeutils.tnef.RawInputStream;

public class TNEFUtils {
    public static int getU8(byte[] buf, int offset) {
        return buf[offset] & 0xFF;
    }

    public static int getU16(int b1, int b2) {
        return (b1 & 0xFF | (b2 & 0xFF) << 8) & 0xFFFF;
    }

    public static int getU16(byte[] buf, int offset) {
        return (buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8) & 0xFFFF;
    }

    public static long getU32(int b1, int b2, int b3, int b4) {
        return (long)(b1 & 0xFF | (b2 & 0xFF) << 8 | (b3 & 0xFF) << 16 | (b4 & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    public static long getU32(byte[] buf, int offset) {
        return (long)(buf[offset] & 0xFF | (buf[offset + 1] & 0xFF) << 8 | (buf[offset + 2] & 0xFF) << 16 | (buf[offset + 3] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    public static long getU64(byte[] buf, int offset) {
        return (TNEFUtils.getU32(buf, offset + 4) & 0xFFFFFFFFL) << 32 | TNEFUtils.getU32(buf, offset) & 0xFFFFFFFFL;
    }

    public static int attribute(int atp, int id) {
        return atp << 16 | id;
    }

    public static int attID(int att) {
        return att & 0xFFFF;
    }

    public static int attType(int att) {
        return att >> 16 & 0xFFFF;
    }

    public static int calculateChecksum(byte[] data) {
        return TNEFUtils.calculateChecksum(data, 0, data.length);
    }

    public static int calculateChecksum(byte[] data, int offset, int length) {
        long checksum = 0L;
        length += offset;
        for (int i = offset; i < length; ++i) {
            checksum += (long)(data[i] & 0xFF);
        }
        return (int)(checksum % 65536L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int calculateChecksum(RawInputStream ris) throws IOException {
        int checksum = 0;
        byte[] buf = new byte[4096];
        try (RawInputStream r = new RawInputStream(ris);){
            int read;
            while ((read = r.read(buf)) != -1) {
                checksum = (checksum + TNEFUtils.calculateChecksum(buf, 0, read)) % 65536;
            }
        }
        return checksum;
    }

    public static String getConstName(Class cls, String constPrefix, long value) {
        Field[] fields = cls.getFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().startsWith(constPrefix) || fields[i].getLong(null) != value) continue;
                return fields[i].getName();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return "0x" + Long.toHexString(value);
    }

    public static String removeTerminatingNulls(String s) {
        int len;
        if (s == null) {
            return null;
        }
        for (len = s.length(); len > 0 && s.charAt(len - 1) == '\u0000'; --len) {
        }
        return len == s.length() ? s : s.substring(0, len);
    }

    public static String replace(String s, String search, String replace) {
        if (s == null || search == null || search.length() == 0) {
            return s;
        }
        if (replace == null) {
            replace = "";
        }
        int len = ((String)s).length();
        int slen = search.length();
        int rlen = replace.length();
        for (int ind = 0; ind < len && (ind = ((String)s).indexOf(search, ind)) > -1; ind += rlen) {
            s = ((String)s).substring(0, ind) + replace + ((String)s).substring(ind + slen);
        }
        return s;
    }

    public static String createString(byte[] bytes, int offset, int length) {
        try {
            return TNEFUtils.removeTerminatingNulls(new String(bytes, offset, length, "ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String createStringUnicode(byte[] bytes, int offset, int length) {
        try {
            return TNEFUtils.removeTerminatingNulls(new String(bytes, offset, length, "UTF-16LE"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String toHexString(byte[] bytes) {
        return TNEFUtils.toHexString(bytes, 0, bytes != null ? bytes.length : 0, -1);
    }

    public static String toHexString(byte[] bytes, int max) {
        return TNEFUtils.toHexString(bytes, 0, bytes != null ? bytes.length : 0, max);
    }

    public static String toHexString(byte[] bytes, int offset, int len, int max) {
        if (bytes == null) {
            return "[null]";
        }
        int count = max > -1 && max < len ? max : len;
        StringBuffer s = new StringBuffer();
        s.append('[');
        for (int i = 0; i < count; ++i) {
            String b = Integer.toHexString(bytes[offset + i] & 0xFF).toUpperCase();
            if (b.length() == 1) {
                s.append('0');
            }
            s.append(b);
        }
        if (count < len) {
            s.append("... (" + len + " bytes)");
        }
        s.append(']');
        return s.toString();
    }

    public static boolean isTNEFMimeType(String mimeType) {
        return mimeType != null && ((mimeType = mimeType.toLowerCase()).startsWith("application/ms-tnef") || mimeType.startsWith("application/vnd.ms-tnef"));
    }

    @Deprecated
    public static byte[] toGUID(String guid) throws IllegalArgumentException {
        return new GUID(guid).toByteArray();
    }

    @Deprecated
    public static int calculateCRC32(byte[] buf, int off, int len) {
        return CompressedRTFInputStream.calculateCRC32(buf, off, len);
    }

    @Deprecated
    public static byte[] decompressRTF(byte[] src) {
        return CompressedRTFInputStream.decompressRTF(src);
    }

    public static int read(InputStream in, byte[] b, int off, int min, int max) throws IOException {
        int total;
        int read;
        for (total = 0; total < min; total += read) {
            read = in.read(b, off + total, max - total);
            if (read >= 0) continue;
            throw new IOException("Unexpected end of stream");
        }
        return total;
    }
}

