/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.uses.net.sf.webdav.fromcatalina;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class XMLWriter {
    public static final int OPENING = 0;
    public static final int CLOSING = 1;
    public static final int NO_CONTENT = 2;
    protected PrintWriter _writer = null;
    protected Map<String, String> _namespaces;
    protected boolean _isRootElement = true;

    public XMLWriter(PrintWriter writer, Map<String, String> namespaces) {
        this._writer = writer;
        this._namespaces = namespaces;
    }

    public void writeProperty(String name, String value) {
        this.writeElement(name, 0);
        this._writer.write(value);
        this.writeElement(name, 1);
    }

    public void writeProperty(String name) {
        this.writeElement(name, 2);
    }

    public void writeElement(String name, int type) {
        int pos;
        StringBuffer nsdecl = new StringBuffer();
        if (this._isRootElement) {
            for (String fullName : this._namespaces.keySet()) {
                String abbrev = this._namespaces.get(fullName);
                nsdecl.append(" xmlns:").append(abbrev).append("=\"").append(fullName).append("\"");
            }
            this._isRootElement = false;
        }
        if ((pos = ((String)name).lastIndexOf(58)) >= 0) {
            String fullns = ((String)name).substring(0, pos);
            String prefix = this._namespaces.get(fullns);
            if (prefix == null) {
                name = ((String)name).substring(pos + 1);
                nsdecl.append(" xmlns=\"").append(fullns).append("\"");
            } else {
                name = prefix + ":" + ((String)name).substring(pos + 1);
            }
        } else {
            throw new IllegalArgumentException("All XML elements must have a namespace");
        }
        switch (type) {
            case 0: {
                this._writer.write("<");
                this._writer.write((String)name);
                this._writer.write(nsdecl.toString());
                this._writer.write(">");
                break;
            }
            case 1: {
                this._writer.write("</");
                this._writer.write((String)name);
                this._writer.write(">\n");
                break;
            }
            default: {
                this._writer.write("<");
                this._writer.write((String)name);
                this._writer.write(nsdecl.toString());
                this._writer.write("/>");
            }
        }
    }

    public void writeText(String text) {
        this._writer.write(text);
    }

    public void writeData(String data) {
        this._writer.write("<![CDATA[");
        this._writer.write(data);
        this._writer.write("]]>");
    }

    public void writeXMLHeader() {
        this._writer.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
    }

    public void sendData() throws IOException {
        this._writer.flush();
    }
}

