/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.application.webdav;

import java.util.Date;
import org.opencrx.application.uses.net.sf.webdav.RequestContext;
import org.opencrx.application.uses.net.sf.webdav.WebDavStore;
import org.opencrx.application.webdav.DocumentCollectionResource;
import org.opencrx.application.webdav.WebDavResource;
import org.opencrx.kernel.document1.jmi1.Document;
import org.opencrx.kernel.document1.jmi1.DocumentRevision;
import org.opencrx.kernel.document1.jmi1.MediaContent;
import org.w3c.cci2.BinaryLargeObject;
import org.w3c.cci2.BinaryLargeObjects;

class DocumentResource
extends WebDavResource {
    private final DocumentCollectionResource parent;

    public DocumentResource(RequestContext requestContext, Document document, DocumentCollectionResource parent) {
        super(requestContext, document);
        this.parent = parent;
    }

    @Override
    public Document getObject() {
        return (Document)super.getObject();
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public String getMimeType() {
        return this.getObject().getContentType();
    }

    @Override
    public String getName() {
        Document document = this.getObject();
        DocumentRevision headRevision = document.getHeadRevision();
        return headRevision == null ? document.getName() : (headRevision instanceof MediaContent ? ((MediaContent)headRevision).getContentName() : headRevision.getName());
    }

    @Override
    public String getDisplayName() {
        return this.getObject().getTitle();
    }

    @Override
    public Date getLastModified() {
        Document document = this.getObject();
        return document.getHeadRevision() == null ? super.getLastModified() : document.getHeadRevision().getModifiedAt();
    }

    public DocumentCollectionResource getDocumentCollectionResource() {
        return this.parent;
    }

    @Override
    public WebDavStore.ResourceContent getContent() {
        Document document = this.getObject();
        if (document.getHeadRevision() instanceof MediaContent) {
            final MediaContent headRevision = (MediaContent)document.getHeadRevision();
            return new WebDavStore.ResourceContent(){

                @Override
                public BinaryLargeObject getContent() {
                    return headRevision.getContent();
                }

                @Override
                public Long getLength() {
                    try {
                        return headRevision.getContentLength() == null ? this.getContent().getLength() : headRevision.getContentLength();
                    }
                    catch (Exception ignore) {
                        return 0L;
                    }
                }
            };
        }
        return new WebDavStore.ResourceContent(){

            @Override
            public BinaryLargeObject getContent() {
                return BinaryLargeObjects.valueOf((byte[])new byte[0]);
            }

            @Override
            public Long getLength() {
                return 0L;
            }
        };
    }
}

