/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.io.BufferedReader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.jdo.Extent;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jmi.reflect.RefObject;
import org.opencrx.kernel.account1.cci2.Account;
import org.opencrx.kernel.account1.cci2.AccountAddressQuery;
import org.opencrx.kernel.account1.cci2.AccountFilterGlobalQuery;
import org.opencrx.kernel.account1.cci2.AccountQuery;
import org.opencrx.kernel.account1.cci2.AddressFilterGlobalQuery;
import org.opencrx.kernel.account1.cci2.CheckForAutoUpdateResult;
import org.opencrx.kernel.account1.cci2.ContactQuery;
import org.opencrx.kernel.account1.cci2.EMailAddressQuery;
import org.opencrx.kernel.account1.cci2.PhoneNumberQuery;
import org.opencrx.kernel.account1.cci2.PostalAddressQuery;
import org.opencrx.kernel.account1.cci2.RoomQuery;
import org.opencrx.kernel.account1.cci2.WebAddressQuery;
import org.opencrx.kernel.account1.jmi1.AbstractFilterAccount;
import org.opencrx.kernel.account1.jmi1.AbstractFilterAddress;
import org.opencrx.kernel.account1.jmi1.AbstractGroup;
import org.opencrx.kernel.account1.jmi1.AccountAddress;
import org.opencrx.kernel.account1.jmi1.AccountFilterGlobal;
import org.opencrx.kernel.account1.jmi1.AccountFilterProperty;
import org.opencrx.kernel.account1.jmi1.AddressFilterGlobal;
import org.opencrx.kernel.account1.jmi1.AddressFilterProperty;
import org.opencrx.kernel.account1.jmi1.CheckForAutoUpdateResult;
import org.opencrx.kernel.account1.jmi1.Contact;
import org.opencrx.kernel.account1.jmi1.EMailAddress;
import org.opencrx.kernel.account1.jmi1.Member;
import org.opencrx.kernel.account1.jmi1.PhoneNumber;
import org.opencrx.kernel.account1.jmi1.PostalAddress;
import org.opencrx.kernel.account1.jmi1.Room;
import org.opencrx.kernel.account1.jmi1.UriAddress;
import org.opencrx.kernel.account1.jmi1.WebAddress;
import org.opencrx.kernel.activity1.cci2.ActivityQuery;
import org.opencrx.kernel.activity1.cci2.AddressGroupMemberQuery;
import org.opencrx.kernel.activity1.cci2.EMailQuery;
import org.opencrx.kernel.activity1.cci2.EMailRecipientQuery;
import org.opencrx.kernel.activity1.cci2.IncidentPartyQuery;
import org.opencrx.kernel.activity1.cci2.MeetingPartyQuery;
import org.opencrx.kernel.activity1.cci2.TaskPartyQuery;
import org.opencrx.kernel.activity1.jmi1.AddressGroupMember;
import org.opencrx.kernel.activity1.jmi1.EMail;
import org.opencrx.kernel.activity1.jmi1.EMailRecipient;
import org.opencrx.kernel.activity1.jmi1.IncidentParty;
import org.opencrx.kernel.activity1.jmi1.MeetingParty;
import org.opencrx.kernel.activity1.jmi1.Segment;
import org.opencrx.kernel.activity1.jmi1.TaskParty;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Activities;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.Cloneable;
import org.opencrx.kernel.backend.Contracts;
import org.opencrx.kernel.backend.VCard;
import org.opencrx.kernel.contract1.jmi1.Invoice;
import org.opencrx.kernel.contract1.jmi1.Lead;
import org.opencrx.kernel.contract1.jmi1.Opportunity;
import org.opencrx.kernel.contract1.jmi1.Quote;
import org.opencrx.kernel.contract1.jmi1.SalesContract;
import org.opencrx.kernel.contract1.jmi1.SalesOrder;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.generic.cci2.CrxObjectQuery;
import org.opencrx.kernel.generic.jmi1.CrxObject;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.security.realm1.jmi1.PrincipalGroup;
import org.opencrx.security.realm1.jmi1.User;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.cci2.ExtentCapableQuery;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.rest.cci.QueryExtensionRecord;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class Accounts
extends AbstractImpl {
    public static final int MAIL_BUSINESS = 0;
    public static final int MAIL_HOME = 1;
    public static final int PHONE_BUSINESS = 2;
    public static final int PHONE_HOME = 3;
    public static final int FAX_BUSINESS = 4;
    public static final int FAX_HOME = 5;
    public static final int POSTAL_BUSINESS = 6;
    public static final int WEB_BUSINESS = 7;
    public static final int POSTAL_HOME = 8;
    public static final int WEB_HOME = 9;
    public static final int MOBILE = 10;
    public static final int PHONE_OTHER = 11;
    public static final int MAIL_OTHER = 12;
    public static final short MEMBER_ROLE_EMPLOYEE = 11;
    public static final short MEMBER_ROLE_ASSISTANT = 17;
    public static final short MEMBER_QUALITY_NORMAL = 5;

    public static void register() {
        Accounts.registerImpl(new Accounts());
    }

    public static Accounts getInstance() throws ServiceException {
        return Accounts.getInstance(Accounts.class);
    }

    protected Accounts() {
    }

    public void markAccountAsDirty(org.opencrx.kernel.account1.jmi1.Account account) throws ServiceException {
        account.setAccountRating(account.getAccountRating());
        Utils.touchObject((RefObject)account);
    }

    @Deprecated
    public void initContract(SalesContract contract, org.opencrx.kernel.account1.jmi1.Account account, String name, String description) throws ServiceException {
        if (name != null) {
            contract.setName(name);
        }
        if (description != null) {
            contract.setDescription(description);
        }
        contract.setCustomer(account);
        contract.setActiveOn(new Date());
        Base.getInstance().assignToMe(contract, true, false);
    }

    @Deprecated
    public Lead createLead(org.opencrx.kernel.account1.jmi1.Account account, String name, String description, String nextStep, Lead basedOn) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        String providerName = account.refGetPath().get(2);
        String segmentName = account.refGetPath().get(4);
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = Contracts.getInstance().getContractSegment(pm, providerName, segmentName);
        Lead contract = (Lead)Contracts.getInstance().createContract(contractSegment, (short)1, basedOn);
        contract.setNextStep(nextStep);
        this.initContract(contract, account, name, description);
        return contract;
    }

    @Deprecated
    public Opportunity createOpportunity(org.opencrx.kernel.account1.jmi1.Account account, String name, String description, String nextStep, Opportunity basedOn) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        String providerName = account.refGetPath().get(2);
        String segmentName = account.refGetPath().get(4);
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = Contracts.getInstance().getContractSegment(pm, providerName, segmentName);
        Opportunity contract = (Opportunity)Contracts.getInstance().createContract(contractSegment, (short)2, basedOn);
        contract.setNextStep(nextStep);
        this.initContract(contract, account, name, description);
        return contract;
    }

    @Deprecated
    public Quote createQuote(org.opencrx.kernel.account1.jmi1.Account account, String name, String description, Quote basedOn) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        String providerName = account.refGetPath().get(2);
        String segmentName = account.refGetPath().get(4);
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = Contracts.getInstance().getContractSegment(pm, providerName, segmentName);
        Quote contract = (Quote)Contracts.getInstance().createContract(contractSegment, (short)3, basedOn);
        this.initContract(contract, account, name, description);
        return contract;
    }

    @Deprecated
    public SalesOrder createSalesOrder(org.opencrx.kernel.account1.jmi1.Account account, String name, String description, SalesOrder basedOn) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        String providerName = account.refGetPath().get(2);
        String segmentName = account.refGetPath().get(4);
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = Contracts.getInstance().getContractSegment(pm, providerName, segmentName);
        SalesOrder contract = (SalesOrder)Contracts.getInstance().createContract(contractSegment, (short)4, basedOn);
        this.initContract(contract, account, name, description);
        return contract;
    }

    @Deprecated
    public Invoice createInvoice(org.opencrx.kernel.account1.jmi1.Account account, String name, String description, Invoice basedOn) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        String providerName = account.refGetPath().get(2);
        String segmentName = account.refGetPath().get(4);
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = Contracts.getInstance().getContractSegment(pm, providerName, segmentName);
        Invoice contract = (Invoice)Contracts.getInstance().createContract(contractSegment, (short)5, basedOn);
        this.initContract(contract, account, name, description);
        return contract;
    }

    public AccountFilterGlobal findAccountFilter(String accountFilterName, org.opencrx.kernel.account1.jmi1.Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        AccountFilterGlobalQuery query = (AccountFilterGlobalQuery)pm.newQuery(AccountFilterGlobal.class);
        query.name().equalTo((Object)accountFilterName);
        List accountFilters = segment.getAccountFilter(query);
        if (!accountFilters.isEmpty()) {
            return (AccountFilterGlobal)accountFilters.iterator().next();
        }
        return null;
    }

    public AddressFilterGlobal findAddressFilter(String accountFilterName, org.opencrx.kernel.account1.jmi1.Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        AddressFilterGlobalQuery query = (AddressFilterGlobalQuery)pm.newQuery(AddressFilterGlobal.class);
        query.name().equalTo((Object)accountFilterName);
        List addressFilters = segment.getAddressFilter(query);
        if (!addressFilters.isEmpty()) {
            return (AddressFilterGlobal)addressFilters.iterator().next();
        }
        return null;
    }

    public AccountFilterGlobal initAccountFilter(String filterName, AccountFilterProperty[] filterProperties, org.opencrx.kernel.account1.jmi1.Segment segment, List<PrincipalGroup> allUsers) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        AccountFilterGlobal accountFilter = this.findAccountFilter(filterName, segment);
        if (accountFilter != null) {
            return accountFilter;
        }
        try {
            pm.currentTransaction().begin();
            accountFilter = (AccountFilterGlobal)pm.newInstance(AccountFilterGlobal.class);
            accountFilter.setName(filterName);
            accountFilter.getOwningGroup().addAll(allUsers);
            segment.addAccountFilter(false, Accounts.getInstance().getUidAsString(), accountFilter);
            for (int i = 0; i < filterProperties.length; ++i) {
                filterProperties[i].getOwningGroup().addAll(allUsers);
                accountFilter.addAccountFilterProperty(false, Accounts.getInstance().getUidAsString(), filterProperties[i]);
            }
            pm.currentTransaction().commit();
        }
        catch (Exception e) {
            new ServiceException(e).log();
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return accountFilter;
    }

    public AddressFilterGlobal initAddressFilter(String filterName, AddressFilterProperty[] filterProperties, org.opencrx.kernel.account1.jmi1.Segment segment, List<PrincipalGroup> allUsers) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        AddressFilterGlobal addressFilter = this.findAddressFilter(filterName, segment);
        if (addressFilter != null) {
            return addressFilter;
        }
        try {
            pm.currentTransaction().begin();
            addressFilter = (AddressFilterGlobal)pm.newInstance(AddressFilterGlobal.class);
            addressFilter.setName(filterName);
            addressFilter.getOwningGroup().addAll(allUsers);
            segment.addAddressFilter(false, Accounts.getInstance().getUidAsString(), addressFilter);
            for (int i = 0; i < filterProperties.length; ++i) {
                filterProperties[i].getOwningGroup().addAll(allUsers);
                addressFilter.addAddressFilterProperty(false, Accounts.getInstance().getUidAsString(), filterProperties[i]);
            }
            pm.currentTransaction().commit();
        }
        catch (Exception e) {
            new ServiceException(e).log();
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return addressFilter;
    }

    public void updateAccountFullName(org.opencrx.kernel.account1.jmi1.Account account) throws ServiceException {
        if (account instanceof Contact) {
            Contact contact = (Contact)account;
            String fullName = ((contact.getLastName() == null ? "" : contact.getLastName()) + ", " + (String)(contact.getFirstName() == null ? "" : contact.getFirstName() + " ") + (String)(contact.getMiddleName() == null ? "" : contact.getMiddleName())).trim();
            if (!Utils.areEqual(fullName, contact.getFullName())) {
                contact.setFullName(fullName);
            }
        } else if (account instanceof AbstractGroup) {
            String fullName;
            AbstractGroup group = (AbstractGroup)account;
            String string = fullName = group.getName() == null ? "" : group.getName();
            if (!Utils.areEqual(fullName, group.getFullName())) {
                group.setFullName(fullName);
            }
        }
    }

    public void updatePostalAddressLine(org.opencrx.kernel.account1.jmi1.Account account) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        try {
            if (account instanceof Contact) {
                Contact contact = (Contact)account;
                PersistenceManager pmOld = pm.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
                Contact contactOld = (Contact)pmOld.getObjectById((Object)contact.refGetPath());
                PostalAddressQuery query = (PostalAddressQuery)pm.newQuery(PostalAddress.class);
                query.forAllDisabled().isFalse();
                for (PostalAddress postalAddress : contact.getAddress(query)) {
                    ArrayList<Object> postalAddressLines;
                    if (postalAddress.getPostalAddressLine().size() == 1 && Utils.areEqual(postalAddress.getPostalAddressLine().get(1), contactOld.getFirstName() + " " + contactOld.getLastName())) {
                        postalAddressLines = new ArrayList<Object>();
                        postalAddressLines.add(contact.getFirstName() + " " + contact.getLastName());
                        if (Utils.areEqual(postalAddress.getPostalAddressLine(), postalAddressLines)) continue;
                        postalAddress.getPostalAddressLine().clear();
                        postalAddress.getPostalAddressLine().addAll(postalAddressLines);
                        continue;
                    }
                    if (postalAddress.getPostalAddressLine().size() != 2 || !Utils.areEqual(postalAddress.getPostalAddressLine().get(0), contactOld.getSalutation()) || !Utils.areEqual(postalAddress.getPostalAddressLine().get(1), contactOld.getFirstName() + " " + contactOld.getLastName())) continue;
                    postalAddressLines = new ArrayList();
                    if (contact.getSalutation() != null && !contact.getSalutation().isEmpty()) {
                        postalAddressLines.add(contact.getSalutation());
                    }
                    postalAddressLines.add(contact.getFirstName() + " " + contact.getLastName());
                    if (Utils.areEqual(postalAddress.getPostalAddressLine(), postalAddressLines)) continue;
                    postalAddress.getPostalAddressLine().clear();
                    postalAddress.getPostalAddressLine().addAll(postalAddressLines);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateAssignedAddresses(AccountAddress address) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)address);
        if (address instanceof PostalAddress) {
            PostalAddress postalAddress = (PostalAddress)address;
            try {
                PersistenceManager pmOld = pm.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
                PostalAddress postalAddressOld = (PostalAddress)pmOld.getObjectById((Object)postalAddress.refGetPath());
                if (Utils.areEqual(postalAddressOld.getPostalAddressLine(), postalAddress.getPostalAddressLine()) && Utils.areEqual(postalAddressOld.getPostalStreet(), postalAddress.getPostalStreet()) && Utils.areEqual(postalAddressOld.getPostalStreetNumber(), postalAddress.getPostalStreetNumber()) && Utils.areEqual(postalAddressOld.getPostalCode(), postalAddress.getPostalCode()) && Utils.areEqual(postalAddressOld.getPostalCity(), postalAddress.getPostalCity()) && Utils.areEqual(postalAddressOld.getPostalState(), postalAddress.getPostalState()) && postalAddressOld.getPostalCountry() == postalAddress.getPostalCountry()) return;
                org.opencrx.kernel.account1.jmi1.Account account = (org.opencrx.kernel.account1.jmi1.Account)pm.getObjectById((Object)address.refGetPath().getParent().getParent());
                PostalAddressQuery query = (PostalAddressQuery)pm.newQuery(PostalAddress.class);
                query.forAllDisabled().isFalse();
                for (PostalAddress assignedAddress : account.getAssignedAddress(query)) {
                    if (!Utils.areEqual(postalAddressOld.getPostalStreet(), assignedAddress.getPostalStreet()) || !Utils.areEqual(postalAddressOld.getPostalStreetNumber(), assignedAddress.getPostalStreetNumber()) || !Utils.areEqual(postalAddressOld.getPostalCode(), assignedAddress.getPostalCode()) || !Utils.areEqual(postalAddressOld.getPostalCity(), assignedAddress.getPostalCity()) || !Utils.areEqual(postalAddressOld.getPostalState(), assignedAddress.getPostalState()) || postalAddressOld.getPostalCountry() != assignedAddress.getPostalCountry()) continue;
                    assignedAddress.getPostalStreet().clear();
                    assignedAddress.getPostalStreet().addAll(postalAddress.getPostalStreet());
                    assignedAddress.setPostalStreetNumber(postalAddress.getPostalStreetNumber());
                    assignedAddress.setPostalCode(postalAddress.getPostalCode());
                    assignedAddress.setPostalCity(postalAddress.getPostalCity());
                    assignedAddress.setPostalState(postalAddress.getPostalState());
                    assignedAddress.setPostalCountry(postalAddress.getPostalCountry());
                }
                return;
            }
            catch (Exception pmOld) {
                return;
            }
        }
        if (!(address instanceof EMailAddress)) return;
        EMailAddress emailAddress = (EMailAddress)address;
        try {
            String emailAddressDomain;
            PersistenceManager pmOld = pm.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
            EMailAddress emailAddressOld = (EMailAddress)pmOld.getObjectById((Object)emailAddress.refGetPath());
            String emailAddressDomainOld = emailAddressOld.getEmailAddress() != null && emailAddressOld.getEmailAddress().indexOf("@") > 0 ? emailAddressOld.getEmailAddress().substring(emailAddressOld.getEmailAddress().indexOf("@")) : null;
            String string = emailAddressDomain = emailAddress.getEmailAddress() != null && emailAddress.getEmailAddress().indexOf("@") > 0 ? emailAddress.getEmailAddress().substring(emailAddress.getEmailAddress().indexOf("@")) : null;
            if (Utils.areEqual(emailAddressDomainOld, emailAddressDomain)) return;
            org.opencrx.kernel.account1.jmi1.Account account = (org.opencrx.kernel.account1.jmi1.Account)pm.getObjectById((Object)address.refGetPath().getParent().getParent());
            EMailAddressQuery query = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
            query.forAllDisabled().isFalse();
            for (EMailAddress assignedAddress : account.getAssignedAddress(query)) {
                String emailAddressDomainAssigned = assignedAddress.getEmailAddress() != null && assignedAddress.getEmailAddress().indexOf("@") > 0 ? assignedAddress.getEmailAddress().substring(assignedAddress.getEmailAddress().indexOf("@")) : null;
                if (!Utils.areEqual(emailAddressDomainOld, emailAddressDomainAssigned)) continue;
                assignedAddress.setEmailAddress(assignedAddress.getEmailAddress().replace(emailAddressDomainAssigned, emailAddressDomain));
            }
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void updateSearchAddressFields(org.opencrx.kernel.account1.jmi1.Account account) throws ServiceException {
    }

    protected void updateVCard(org.opencrx.kernel.account1.jmi1.Account account, List<String> statusMessage) throws ServiceException {
        String oldVCardAsString = account.getVcard();
        String newVCardAsString = VCard.getInstance().mergeVcard(account, oldVCardAsString, statusMessage);
        if (newVCardAsString == null) {
            newVCardAsString = "";
        }
        try {
            Map<String, VCard.VCardField> oldFields = VCard.getInstance().parseVCard(new BufferedReader(new StringReader(oldVCardAsString == null ? "" : oldVCardAsString)), new StringBuilder());
            Map<String, VCard.VCardField> newFields = VCard.getInstance().parseVCard(new BufferedReader(new StringReader(newVCardAsString)), new StringBuilder());
            oldFields.remove("REV");
            newFields.remove("REV");
            if (!newFields.equals(oldFields)) {
                account.setVcard(newVCardAsString);
            }
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
        String uid = VCard.getInstance().getVCardUid(newVCardAsString);
        if (uid == null) {
            ServiceException e = new ServiceException("DefaultDomain", -2, "Missing UID in accounts's vcard", new BasicException.Parameter[]{new BasicException.Parameter("activity", (Object)account), new BasicException.Parameter("externalLink", account.getExternalLink()), new BasicException.Parameter("vcard", (Object)newVCardAsString)});
            SysLog.warning((String)"Missing UID in accounts's vcard", (Object)account.refGetPath());
            SysLog.detail((String)e.getMessage(), (Throwable)e.getCause());
        }
        boolean vcardLinkMatches = false;
        boolean hasVCardLink = false;
        for (String externalLink : account.getExternalLink()) {
            if (!externalLink.startsWith("VCARD:")) continue;
            hasVCardLink = true;
            if (!externalLink.endsWith(uid)) continue;
            vcardLinkMatches = true;
            break;
        }
        if (!hasVCardLink) {
            account.getExternalLink().add("VCARD:" + uid);
        } else if (!vcardLinkMatches) {
            ServiceException e = new ServiceException("DefaultDomain", -2, "Accounts's external link does not contain vcard UID", new BasicException.Parameter[]{new BasicException.Parameter("activity", (Object)account), new BasicException.Parameter("externalLink", account.getExternalLink()), new BasicException.Parameter("vcard", (Object)newVCardAsString)});
            SysLog.warning((String)"Accounts's external link does not contain vcard UID", (Object)account.refGetPath());
            SysLog.detail((String)e.getMessage(), (Throwable)e.getCause());
        }
    }

    protected void updateAccount(org.opencrx.kernel.account1.jmi1.Account account) throws ServiceException {
        this.updateAccountFullName(account);
        this.updatePostalAddressLine(account);
        ArrayList<String> statusMessage = new ArrayList<String>();
        this.updateSearchAddressFields(account);
        this.updateVCard(account, statusMessage);
    }

    protected void updateAddress(AccountAddress address) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)address);
        if (address instanceof PhoneNumber) {
            Addresses.getInstance().updatePhoneNumber((PhoneNumber)address);
        } else if (address instanceof EMailAddress) {
            Addresses.getInstance().updateEMailAddress((EMailAddress)address);
        } else if (address instanceof UriAddress) {
            Addresses.getInstance().updateUriAddress((UriAddress)address);
        }
        this.updateAssignedAddresses(address);
        this.markAccountAsDirty((org.opencrx.kernel.account1.jmi1.Account)pm.getObjectById((Object)address.refGetPath().getParent().getParent()));
    }

    protected void removeAddress(AccountAddress address, boolean preDelete) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)address);
        this.markAccountAsDirty((org.opencrx.kernel.account1.jmi1.Account)pm.getObjectById((Object)address.refGetPath().getParent().getParent()));
    }

    public int countFilteredAccount(AbstractFilterAccount accountFilter) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountFilter);
        AccountQuery query = (AccountQuery)pm.newQuery(org.opencrx.kernel.account1.jmi1.Account.class);
        QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
        queryExtension.setClause("/*!COUNT*/(1=1)");
        List accounts = accountFilter.getFilteredAccount(query);
        return accounts.size();
    }

    public org.opencrx.kernel.account1.jmi1.Segment getAccountSegment(PersistenceManager pm, String providerName, String segmentName) {
        return (org.opencrx.kernel.account1.jmi1.Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.account1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
    }

    public List<EMailAddress> lookupEmailAddress(PersistenceManager pm, String providerName, String segmentName, String emailAddress) {
        return this.lookupEmailAddress(pm, providerName, segmentName, emailAddress, false);
    }

    public List<EMailAddress> lookupEmailAddress(PersistenceManager pm, String providerName, String segmentName, String emailAddress, boolean exactCaseInsensitiveOnly) {
        org.opencrx.kernel.account1.jmi1.Segment accountSegment = this.getAccountSegment(pm, providerName, segmentName);
        emailAddress = emailAddress.trim();
        List<EMailAddress> addresses = Collections.emptyList();
        EMailAddressQuery query = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
        query.orderByModifiedAt().descending();
        query.thereExistsEmailAddress().equalTo((Object)emailAddress);
        query.forAllDisabled().isFalse();
        addresses = accountSegment.getAddress(query);
        if (addresses.isEmpty()) {
            query = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
            query.orderByModifiedAt().descending();
            query.thereExistsEmailAddress().like((Object)("(?i)" + emailAddress.replace(".", "\\.")));
            query.forAllDisabled().isFalse();
            addresses = accountSegment.getAddress(query);
        }
        if (!exactCaseInsensitiveOnly && addresses.isEmpty()) {
            query = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
            query.orderByModifiedAt().descending();
            query.thereExistsEmailAddress().like((Object)("(?i).*" + emailAddress.replace(".", "\\.") + ".*"));
            query.forAllDisabled().isFalse();
            addresses = accountSegment.getAddress(query);
        }
        ArrayList<EMailAddress> activeAddresses = new ArrayList<EMailAddress>();
        for (EMailAddress address : addresses) {
            int index;
            Account account = address.getAccount();
            if (account.isDisabled() != null && account.isDisabled().booleanValue()) continue;
            for (index = 0; index < activeAddresses.size() && address.getEmailAddress().length() >= ((EMailAddress)activeAddresses.get(index)).getEmailAddress().length(); ++index) {
            }
            activeAddresses.add(index, address);
        }
        return activeAddresses;
    }

    public org.opencrx.kernel.account1.jmi1.Account getUnassignableAddressesHolder(org.opencrx.kernel.account1.jmi1.Segment accountSegment) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountSegment);
        String providerName = accountSegment.refGetPath().get(2);
        String segmentName = accountSegment.refGetPath().get(4);
        return (org.opencrx.kernel.account1.jmi1.Account)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.account1").getDescendant(new String[]{"provider", providerName, "segment", segmentName, "account", "admin" + SecurityKeys.ID_SEPARATOR + segmentName}));
    }

    public List<EMailAddress> lookupEmailAddress(PersistenceManager pm, String providerName, String segmentName, String email, boolean exactCaseInsensitiveOnly, boolean forceCreate) throws ServiceException {
        List<EMailAddress> emailAddresses = this.lookupEmailAddress(pm, providerName, segmentName, email, exactCaseInsensitiveOnly);
        if (forceCreate && emailAddresses.isEmpty()) {
            PersistenceManager pmAdmin = pm.getPersistenceManagerFactory().getPersistenceManager("admin" + SecurityKeys.ID_SEPARATOR + segmentName, null);
            org.opencrx.kernel.account1.jmi1.Segment accountSegment = this.getAccountSegment(pmAdmin, providerName, segmentName);
            org.opencrx.kernel.account1.jmi1.Account addressHolder = this.getUnassignableAddressesHolder(accountSegment);
            if (addressHolder != null) {
                EMailAddressQuery query = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
                query.thereExistsEmailAddress().equalTo((Object)email);
                List existingAddresses = addressHolder.getAddress(query);
                if (existingAddresses.isEmpty()) {
                    pmAdmin.currentTransaction().begin();
                    EMailAddress emailAddress = (EMailAddress)pmAdmin.newInstance(EMailAddress.class);
                    emailAddress.setEmailAddress(email);
                    emailAddress.setEmailType((short)1);
                    addressHolder.addAddress(this.getUidAsString(), emailAddress);
                    pmAdmin.currentTransaction().commit();
                    emailAddresses = Collections.singletonList((EMailAddress)pm.getObjectById((Object)emailAddress.refGetPath()));
                } else {
                    emailAddresses = Collections.singletonList((EMailAddress)pm.getObjectById((Object)((EMailAddress)existingAddresses.iterator().next()).refGetPath()));
                }
            }
            pmAdmin.close();
        }
        return emailAddresses;
    }

    public List<AccountAddress> getAccountAddresses(org.opencrx.kernel.account1.jmi1.Account account, short usage) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        AccountAddressQuery query = (AccountAddressQuery)pm.newQuery(AccountAddress.class);
        query.thereExistsUsage().equalTo((Object)usage);
        query.forAllDisabled().isFalse();
        query.orderByCreatedAt().ascending();
        return account.getAddress(query);
    }

    public String getPrimaryBusinessEMail(org.opencrx.kernel.account1.jmi1.Account account, String hint) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        String emailAddress = null;
        for (boolean ignoreDisabled : Arrays.asList(true, false)) {
            EMailAddressQuery emailAddressQuery = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
            if (ignoreDisabled) {
                emailAddressQuery.forAllDisabled().isFalse();
            }
            for (EMailAddress address : account.getAddress(emailAddressQuery)) {
                String addr = address.getEmailAddress();
                if (emailAddress == null || hint != null && !hint.isEmpty()) {
                    if (emailAddress == null) {
                        emailAddress = addr;
                    } else if (hint.equals(addr)) {
                        emailAddress = addr;
                    }
                }
                if (addr == null || !address.isMain() || !address.getUsage().contains(Addresses.USAGE_BUSINESS)) continue;
                emailAddress = addr;
            }
            if (emailAddress == null) continue;
            return emailAddress;
        }
        return emailAddress;
    }

    public String getPrimaryBusinessPhone(org.opencrx.kernel.account1.jmi1.Account account) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)account);
        String phoneNumber = null;
        for (boolean ignoreDisabled : Arrays.asList(true, false)) {
            PhoneNumberQuery phoneNumberQuery = (PhoneNumberQuery)pm.newQuery(PhoneNumber.class);
            if (ignoreDisabled) {
                phoneNumberQuery.forAllDisabled().isFalse();
            }
            for (PhoneNumber address : account.getAddress(phoneNumberQuery)) {
                String adr = address.getPhoneNumberFull();
                if (phoneNumber == null && adr != null) {
                    phoneNumber = adr;
                }
                if (adr == null || !address.isMain() || !address.getUsage().contains(Addresses.USAGE_BUSINESS)) continue;
                phoneNumber = adr;
            }
            if (phoneNumber == null) continue;
            return phoneNumber;
        }
        return phoneNumber;
    }

    public AccountAddress[] getMainAddresses(org.opencrx.kernel.account1.jmi1.Account account) {
        return this.getMainAddresses(account, false);
    }

    public AccountAddress[] getMainAddresses(org.opencrx.kernel.account1.jmi1.Account account, boolean strict) {
        return this.getAccountAddresses(account, new AddressFilter(){

            @Override
            public boolean matches(AccountAddress address) {
                boolean isMain = false;
                try {
                    isMain = address.isMain();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return isMain;
            }
        }, strict);
    }

    public AccountAddress[] getAccountAddresses(org.opencrx.kernel.account1.jmi1.Account account, AddressFilter addressFilter, boolean strict) {
        EMailAddress mailAddress;
        PostalAddress postalAddress;
        PhoneNumber phoneNumber;
        boolean matchesFilter;
        WebAddress webAddress;
        boolean hasBusinessMail = false;
        boolean hasHomeMail = false;
        boolean hasBusinessPhone = false;
        boolean hasHomePhone = false;
        boolean hasBusinessFax = false;
        boolean hasOrderHomeFax = false;
        boolean hasBusinessPostal = false;
        boolean hasBusinessWeb = false;
        boolean hasHomePostal = false;
        boolean hasHomeWeb = false;
        boolean hasMobile = false;
        boolean hasOtherPhone = false;
        boolean hasOtherMail = false;
        AccountAddress[] accountAddresses = new AccountAddress[13];
        account.getAddress().isEmpty();
        List<AccountAddress> addresses = this.getAccountAddresses(account, Addresses.USAGE_HOME);
        for (AccountAddress address : addresses) {
            if (address instanceof WebAddress) {
                webAddress = (WebAddress)address;
                matchesFilter = addressFilter.matches(webAddress);
                if ((strict || hasHomeWeb) && !matchesFilter) continue;
                accountAddresses[9] = webAddress;
                hasHomeWeb = true;
                continue;
            }
            if (address instanceof PhoneNumber) {
                phoneNumber = (PhoneNumber)address;
                matchesFilter = addressFilter.matches(phoneNumber);
                if ((strict || hasHomePhone) && !matchesFilter) continue;
                accountAddresses[3] = phoneNumber;
                hasHomePhone = true;
                continue;
            }
            if (address instanceof PostalAddress) {
                postalAddress = (PostalAddress)address;
                matchesFilter = addressFilter.matches(postalAddress);
                if ((strict || hasHomePostal) && !matchesFilter) continue;
                accountAddresses[8] = postalAddress;
                hasHomePostal = true;
                continue;
            }
            if (!(address instanceof EMailAddress)) continue;
            mailAddress = (EMailAddress)address;
            matchesFilter = addressFilter.matches(mailAddress);
            if ((strict || hasHomeMail) && !matchesFilter) continue;
            accountAddresses[1] = mailAddress;
            hasHomeMail = true;
        }
        addresses = this.getAccountAddresses(account, Addresses.USAGE_BUSINESS);
        for (AccountAddress address : addresses) {
            if (address instanceof WebAddress) {
                webAddress = (WebAddress)address;
                matchesFilter = addressFilter.matches(webAddress);
                if ((strict || hasBusinessWeb) && !matchesFilter) continue;
                accountAddresses[7] = webAddress;
                hasBusinessWeb = true;
                continue;
            }
            if (address instanceof PhoneNumber) {
                phoneNumber = (PhoneNumber)address;
                matchesFilter = addressFilter.matches(phoneNumber);
                if ((strict || hasBusinessPhone) && !matchesFilter) continue;
                accountAddresses[2] = phoneNumber;
                hasBusinessPhone = true;
                continue;
            }
            if (address instanceof PostalAddress) {
                postalAddress = (PostalAddress)address;
                matchesFilter = addressFilter.matches(postalAddress);
                if ((strict || hasBusinessPostal) && !matchesFilter) continue;
                accountAddresses[6] = postalAddress;
                hasBusinessPostal = true;
                continue;
            }
            if (!(address instanceof EMailAddress)) continue;
            mailAddress = (EMailAddress)address;
            matchesFilter = addressFilter.matches(mailAddress);
            if ((strict || hasBusinessMail) && !matchesFilter) continue;
            accountAddresses[0] = mailAddress;
            hasBusinessMail = true;
        }
        addresses = this.getAccountAddresses(account, Addresses.USAGE_OTHER);
        for (AccountAddress address : addresses) {
            if (address instanceof PhoneNumber) {
                phoneNumber = (PhoneNumber)address;
                matchesFilter = addressFilter.matches(phoneNumber);
                if ((strict || hasOtherPhone) && !matchesFilter) continue;
                accountAddresses[11] = phoneNumber;
                hasOtherPhone = true;
                continue;
            }
            if (!(address instanceof EMailAddress)) continue;
            mailAddress = (EMailAddress)address;
            matchesFilter = addressFilter.matches(mailAddress);
            if ((strict || hasOtherMail) && !matchesFilter) continue;
            accountAddresses[12] = mailAddress;
            hasOtherMail = true;
        }
        addresses = this.getAccountAddresses(account, Addresses.USAGE_HOME_FAX);
        for (AccountAddress address : addresses) {
            if (!(address instanceof PhoneNumber)) continue;
            phoneNumber = (PhoneNumber)address;
            matchesFilter = addressFilter.matches(phoneNumber);
            if ((strict || hasOrderHomeFax) && !matchesFilter) continue;
            accountAddresses[5] = phoneNumber;
            hasOrderHomeFax = true;
        }
        addresses = this.getAccountAddresses(account, Addresses.USAGE_BUSINESS_FAX);
        for (AccountAddress address : addresses) {
            if (!(address instanceof PhoneNumber)) continue;
            phoneNumber = (PhoneNumber)address;
            matchesFilter = addressFilter.matches(phoneNumber);
            if ((strict || hasBusinessFax) && !matchesFilter) continue;
            accountAddresses[4] = phoneNumber;
            hasBusinessFax = true;
        }
        addresses = this.getAccountAddresses(account, Addresses.USAGE_MOBILE);
        for (AccountAddress address : addresses) {
            if (!(address instanceof PhoneNumber)) continue;
            phoneNumber = (PhoneNumber)address;
            matchesFilter = addressFilter.matches(phoneNumber);
            if ((strict || hasMobile) && !matchesFilter) continue;
            accountAddresses[10] = phoneNumber;
            hasMobile = true;
        }
        return accountAddresses;
    }

    public void updateVcard(org.opencrx.kernel.account1.jmi1.Account account) throws ServiceException {
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> report = new ArrayList<String>();
        String vcard = VCard.getInstance().mergeVcard(account, account.getVcard(), messages);
        byte[] item = null;
        try {
            item = vcard.getBytes("UTF-8");
        }
        catch (Exception e) {
            item = vcard.getBytes();
        }
        VCard.getInstance().importItem(item, account, (short)0, errors, report);
    }

    protected void updateMember(Member member) throws ServiceException {
    }

    public int countFilteredAddress(AbstractFilterAddress addressFilter) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)addressFilter);
        AccountAddressQuery query = (AccountAddressQuery)pm.newQuery(AccountAddress.class);
        QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
        queryExtension.setClause("/*!COUNT*/(1=1)");
        List addresses = addressFilter.getFilteredAddress(query);
        return addresses.size();
    }

    public int moveAddressToAccount(AccountAddress source, org.opencrx.kernel.account1.jmi1.Account targetAccount, Date updateRelationshipsSince, Date updateRelationshipsBefore) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)source);
        AccountAddress target = null;
        if (source instanceof EMailAddress) {
            EMailAddressQuery query = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
            query.thereExistsEmailAddress().equalTo((Object)((EMailAddress)source).getEmailAddress());
            List addresses = targetAccount.getAddress(query);
            target = addresses.isEmpty() ? null : (AccountAddress)addresses.iterator().next();
        } else if (source instanceof PhoneNumber) {
            PhoneNumberQuery query = (PhoneNumberQuery)pm.newQuery(PhoneNumber.class);
            query.thereExistsPhoneNumberFull().equalTo((Object)((PhoneNumber)source).getPhoneNumberFull());
            List addresses = targetAccount.getAddress(query);
            target = addresses.isEmpty() ? null : (AccountAddress)addresses.iterator().next();
        } else if (source instanceof WebAddress) {
            WebAddressQuery query = (WebAddressQuery)pm.newQuery(WebAddress.class);
            query.thereExistsWebUrl().equalTo((Object)((WebAddress)source).getWebUrl());
            List addresses = targetAccount.getAddress(query);
            target = addresses.isEmpty() ? null : (AccountAddress)addresses.iterator().next();
        } else if (source instanceof Room) {
            RoomQuery query = (RoomQuery)pm.newQuery(Room.class);
            query.thereExistsRoomNumber().equalTo((Object)((Room)source).getRoomNumber());
            List addresses = targetAccount.getAddress(query);
            AccountAddress accountAddress = target = addresses.isEmpty() ? null : (AccountAddress)addresses.iterator().next();
        }
        if (target == null) {
            target = (AccountAddress)Cloneable.getInstance().cloneObject(source, targetAccount, source.refGetPath().getParent().getLastSegment().toString(), null, "", (User)targetAccount.getOwningUser(), targetAccount.getOwningGroup());
        }
        return this.moveAddress(source, target, updateRelationshipsSince, updateRelationshipsBefore);
    }

    public int moveAddress(AccountAddress source, AccountAddress target, Date updateRelationshipsSince, Date updateRelationshipsBefore) throws ServiceException {
        List parties;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)source);
        String providerName = source.refGetPath().get(2);
        String segmentName = source.refGetPath().get(4);
        Segment activitySegment = Activities.getInstance().getActivitySegment(pm, providerName, segmentName);
        org.opencrx.kernel.account1.jmi1.Account sourceAccount = source.getAccount();
        org.opencrx.kernel.account1.jmi1.Account targetAccount = target.getAccount();
        int count = 0;
        CrxObjectQuery query = (AddressGroupMemberQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(AddressGroupMember.class), (Object)activitySegment.refGetPath().getDescendant(new String[]{"addressGroup", ":*", "member", ":*"}));
        query.thereExistsAddress().equalTo(source);
        if (updateRelationshipsSince != null) {
            query.createdAt().greaterThanOrEqualTo((Comparable)updateRelationshipsSince);
        }
        if (updateRelationshipsBefore != null) {
            query.createdAt().lessThanOrEqualTo((Comparable)updateRelationshipsBefore);
        }
        ArrayList members = new ArrayList();
        List addressGroupMembers = activitySegment.getExtent((ExtentCapableQuery)query);
        members.addAll(addressGroupMembers);
        for (CrxObject member : members) {
            member.setAddress(target);
            ++count;
        }
        query = (EMailQuery)pm.newQuery(EMail.class);
        query.thereExistsSender().equalTo(source);
        if (updateRelationshipsSince != null) {
            query.createdAt().greaterThanOrEqualTo((Comparable)updateRelationshipsSince);
        }
        if (updateRelationshipsBefore != null) {
            query.createdAt().lessThanOrEqualTo((Comparable)updateRelationshipsBefore);
        }
        members = new ArrayList();
        List emails = activitySegment.getActivity((ActivityQuery)query);
        members.addAll(emails);
        for (CrxObject member : members) {
            member.setSender(target);
            ++count;
        }
        query = (EMailRecipientQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(EMailRecipient.class), (Object)activitySegment.refGetPath().getDescendant(new String[]{"activity", ":*", "emailRecipient", ":*"}));
        query.thereExistsParty().equalTo(source);
        if (updateRelationshipsSince != null) {
            query.createdAt().greaterThanOrEqualTo((Comparable)updateRelationshipsSince);
        }
        if (updateRelationshipsBefore != null) {
            query.createdAt().lessThanOrEqualTo((Comparable)updateRelationshipsBefore);
        }
        members = new ArrayList();
        List recipients = activitySegment.getExtent((ExtentCapableQuery)query);
        members.addAll(recipients);
        for (CrxObject member : members) {
            member.setParty(target);
            ++count;
        }
        if (source instanceof EMailAddress) {
            query = (IncidentPartyQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(IncidentParty.class), (Object)activitySegment.refGetPath().getDescendant(new String[]{"activity", ":*", "incidentParty", ":*"}));
            query.thereExistsParty().equalTo(sourceAccount);
            query.thereExistsEmailHint().equalTo((Object)((EMailAddress)source).getEmailAddress());
            if (updateRelationshipsSince != null) {
                query.createdAt().greaterThanOrEqualTo((Comparable)updateRelationshipsSince);
            }
            if (updateRelationshipsBefore != null) {
                query.createdAt().lessThanOrEqualTo((Comparable)updateRelationshipsBefore);
            }
            members = new ArrayList();
            parties = activitySegment.getExtent((ExtentCapableQuery)query);
            members.addAll(parties);
            for (CrxObject member : members) {
                member.setParty(targetAccount);
                ++count;
            }
        }
        if (source instanceof EMailAddress) {
            query = (MeetingPartyQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(MeetingParty.class), (Object)activitySegment.refGetPath().getDescendant(new String[]{"activity", ":*", "meetingParty", ":*"}));
            query.thereExistsParty().equalTo(sourceAccount);
            query.thereExistsEmailHint().equalTo((Object)((EMailAddress)source).getEmailAddress());
            if (updateRelationshipsSince != null) {
                query.createdAt().greaterThanOrEqualTo((Comparable)updateRelationshipsSince);
            }
            if (updateRelationshipsBefore != null) {
                query.createdAt().lessThanOrEqualTo((Comparable)updateRelationshipsBefore);
            }
            members = new ArrayList();
            parties = activitySegment.getExtent((ExtentCapableQuery)query);
            members.addAll(parties);
            for (CrxObject member : members) {
                member.setParty(targetAccount);
                ++count;
            }
        }
        if (source instanceof EMailAddress) {
            query = (TaskPartyQuery)PersistenceHelper.newQuery((Extent)pm.getExtent(TaskParty.class), (Object)activitySegment.refGetPath().getDescendant(new String[]{"activity", ":*", "taskParty", ":*"}));
            query.thereExistsParty().equalTo(sourceAccount);
            query.thereExistsEmailHint().equalTo((Object)((EMailAddress)source).getEmailAddress());
            if (updateRelationshipsSince != null) {
                query.createdAt().greaterThanOrEqualTo((Comparable)updateRelationshipsSince);
            }
            if (updateRelationshipsBefore != null) {
                query.createdAt().lessThanOrEqualTo((Comparable)updateRelationshipsBefore);
            }
            members = new ArrayList();
            parties = activitySegment.getExtent((ExtentCapableQuery)query);
            members.addAll(parties);
            for (CrxObject member : members) {
                member.setParty(targetAccount);
                ++count;
            }
        }
        source.setDisabled(true);
        return count;
    }

    public CheckForAutoUpdateResult checkForAutoUpdate(AccountAddress address) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)address);
        ArrayList<AccountAddress> lCandidateAddress = new ArrayList<AccountAddress>();
        ArrayList<Boolean> lCandidateAddressQualifiesForAutoUpdate = new ArrayList<Boolean>();
        ArrayList<Object> lCandidateMatchingFields = new ArrayList<Object>();
        ArrayList<Object> lCandidateNonMatchingFields = new ArrayList<Object>();
        if (address.getAuthority() != null) {
            if (address instanceof PostalAddress) {
                PostalAddress postalAddress = (PostalAddress)address;
                PostalAddressQuery query = (PostalAddressQuery)pm.newQuery(PostalAddress.class);
                query.orderByCreatedAt().ascending();
                for (PostalAddress candidate : address.getAuthority().getAddress(query)) {
                    boolean postalCountryMatches;
                    Object matchingFields = "";
                    Object nonMatchingFields = "";
                    boolean qualifiesForAutoUpdate = true;
                    boolean postalStreetMatches = Utils.areEqual(candidate.getPostalStreet(), postalAddress.getPostalStreet());
                    if (postalStreetMatches) {
                        matchingFields = (String)matchingFields + "postalStreet";
                    } else {
                        nonMatchingFields = (String)nonMatchingFields + "postalStreet";
                        qualifiesForAutoUpdate = false;
                    }
                    boolean postalStreetNumberMatches = Utils.areEqual(candidate.getPostalStreetNumber(), postalAddress.getPostalStreetNumber());
                    if (postalStreetNumberMatches) {
                        matchingFields = (String)matchingFields + (((String)matchingFields).isEmpty() ? "" : "<br />");
                        matchingFields = (String)matchingFields + "postalStreetNumber";
                    } else {
                        nonMatchingFields = (String)nonMatchingFields + (((String)nonMatchingFields).isEmpty() ? "" : "<br />");
                        nonMatchingFields = (String)nonMatchingFields + "postalStreetNumber";
                        qualifiesForAutoUpdate = false;
                    }
                    boolean postalCodeMatches = Utils.areEqual(candidate.getPostalCode(), postalAddress.getPostalCode());
                    if (postalCodeMatches) {
                        matchingFields = (String)matchingFields + (((String)matchingFields).isEmpty() ? "" : "<br />");
                        matchingFields = (String)matchingFields + "postalCode";
                    } else {
                        nonMatchingFields = (String)nonMatchingFields + (((String)nonMatchingFields).isEmpty() ? "" : "<br />");
                        nonMatchingFields = (String)nonMatchingFields + "postalCode";
                        qualifiesForAutoUpdate = false;
                    }
                    boolean postalCityMatches = Utils.areEqual(candidate.getPostalCity(), postalAddress.getPostalCity());
                    if (postalCityMatches) {
                        matchingFields = (String)matchingFields + (((String)matchingFields).isEmpty() ? "" : "<br />");
                        matchingFields = (String)matchingFields + "postalCity";
                    } else {
                        nonMatchingFields = (String)nonMatchingFields + (((String)nonMatchingFields).isEmpty() ? "" : "<br />");
                        nonMatchingFields = (String)nonMatchingFields + "postalCity";
                        qualifiesForAutoUpdate = false;
                    }
                    boolean postalStateMatches = Utils.areEqual(candidate.getPostalState(), postalAddress.getPostalState());
                    if (postalStateMatches) {
                        matchingFields = (String)matchingFields + (((String)matchingFields).isEmpty() ? "" : "<br />");
                        matchingFields = (String)matchingFields + "postalState";
                    } else {
                        nonMatchingFields = (String)nonMatchingFields + (((String)nonMatchingFields).isEmpty() ? "" : "<br />");
                        nonMatchingFields = (String)nonMatchingFields + "postalState";
                        qualifiesForAutoUpdate = false;
                    }
                    boolean bl = postalCountryMatches = candidate.getPostalCountry() == postalAddress.getPostalCountry();
                    if (postalCountryMatches) {
                        matchingFields = (String)matchingFields + (((String)matchingFields).isEmpty() ? "" : "<br />");
                        matchingFields = (String)matchingFields + "postalCountry";
                    } else {
                        nonMatchingFields = (String)nonMatchingFields + (((String)nonMatchingFields).isEmpty() ? "" : "<br />");
                        nonMatchingFields = (String)nonMatchingFields + "postalCountry";
                        qualifiesForAutoUpdate = false;
                    }
                    if (qualifiesForAutoUpdate) {
                        lCandidateAddress.add(0, candidate);
                        lCandidateAddressQualifiesForAutoUpdate.add(0, qualifiesForAutoUpdate);
                        lCandidateMatchingFields.add(0, matchingFields);
                        lCandidateNonMatchingFields.add(0, nonMatchingFields);
                        continue;
                    }
                    lCandidateAddress.add(candidate);
                    lCandidateAddressQualifiesForAutoUpdate.add(qualifiesForAutoUpdate);
                    lCandidateMatchingFields.add(matchingFields);
                    lCandidateNonMatchingFields.add(nonMatchingFields);
                }
            } else if (address instanceof EMailAddress) {
                EMailAddress emailAddress = (EMailAddress)address;
                EMailAddressQuery query = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
                query.orderByCreatedAt().ascending();
                for (EMailAddress candidateAddress : address.getAuthority().getAddress(query)) {
                    Object matchingFields = "";
                    Object nonMatchingFields = "";
                    boolean qualifiesForAutoUpdate = true;
                    String emailAddressDomain = emailAddress.getEmailAddress() != null && emailAddress.getEmailAddress().indexOf("@") > 0 ? emailAddress.getEmailAddress().substring(emailAddress.getEmailAddress().indexOf("@")) : null;
                    String emailAddressDomainCandidate = candidateAddress.getEmailAddress() != null && candidateAddress.getEmailAddress().indexOf("@") > 0 ? candidateAddress.getEmailAddress().substring(candidateAddress.getEmailAddress().indexOf("@")) : null;
                    boolean domainNameMatches = Utils.areEqual(emailAddressDomainCandidate, emailAddressDomain);
                    if (domainNameMatches) {
                        matchingFields = (String)matchingFields + "emailAddressDomain";
                    } else {
                        nonMatchingFields = (String)nonMatchingFields + "emailAddressDomain";
                        qualifiesForAutoUpdate = false;
                    }
                    if (qualifiesForAutoUpdate) {
                        lCandidateAddress.add(0, candidateAddress);
                        lCandidateAddressQualifiesForAutoUpdate.add(0, qualifiesForAutoUpdate);
                        lCandidateMatchingFields.add(0, matchingFields);
                        lCandidateNonMatchingFields.add(0, nonMatchingFields);
                        continue;
                    }
                    lCandidateAddress.add(candidateAddress);
                    lCandidateAddressQualifiesForAutoUpdate.add(qualifiesForAutoUpdate);
                    lCandidateMatchingFields.add(matchingFields);
                    lCandidateNonMatchingFields.add(nonMatchingFields);
                }
            }
        }
        int size = lCandidateAddress.size();
        return (CheckForAutoUpdateResult)Structures.create(CheckForAutoUpdateResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateAddress1, size > 0 ? lCandidateAddress.get(0) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateQualifiesForAutoUpdate1, size > 0 ? (Boolean)lCandidateAddressQualifiesForAutoUpdate.get(0) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateMatchingFields1, size > 0 ? lCandidateMatchingFields.get(0) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateNonMatchingFields1, size > 0 ? lCandidateNonMatchingFields.get(0) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateAddress2, size > 1 ? lCandidateAddress.get(1) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateQualifiesForAutoUpdate2, size > 1 ? (Boolean)lCandidateAddressQualifiesForAutoUpdate.get(1) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateMatchingFields2, size > 1 ? lCandidateMatchingFields.get(1) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateNonMatchingFields2, size > 1 ? lCandidateNonMatchingFields.get(1) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateAddress3, size > 2 ? lCandidateAddress.get(2) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateQualifiesForAutoUpdate3, size > 2 ? (Boolean)lCandidateAddressQualifiesForAutoUpdate.get(2) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateMatchingFields3, size > 2 ? lCandidateMatchingFields.get(2) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateNonMatchingFields3, size > 2 ? lCandidateNonMatchingFields.get(2) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateAddress4, size > 3 ? lCandidateAddress.get(3) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateQualifiesForAutoUpdate4, size > 3 ? (Boolean)lCandidateAddressQualifiesForAutoUpdate.get(3) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateMatchingFields4, size > 3 ? lCandidateMatchingFields.get(3) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateNonMatchingFields4, size > 3 ? lCandidateNonMatchingFields.get(3) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateAddress5, size > 4 ? lCandidateAddress.get(4) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateQualifiesForAutoUpdate5, size > 4 ? (Boolean)lCandidateAddressQualifiesForAutoUpdate.get(4) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateMatchingFields5, size > 4 ? lCandidateMatchingFields.get(4) : null), Datatypes.member((Enum)CheckForAutoUpdateResult.Member.candidateNonMatchingFields5, size > 4 ? lCandidateNonMatchingFields.get(4) : null)});
    }

    protected void removeAccount(org.opencrx.kernel.account1.jmi1.Account account, boolean preDelete) throws ServiceException {
    }

    public List<org.opencrx.kernel.account1.jmi1.Account> getMatchingAccounts(org.opencrx.kernel.account1.jmi1.Segment accountSegment, AccountQuery accountQuery, String fullName, String firstName, String lastName, String aliasName, String phoneNumberMobile, String phoneNumberHome, String phoneNumberBusiness, String postalCityHome, String postalCityBusiness, List<String> postalStreetHome, List<String> postalStreetBusiness, String emailHome, String emailBusiness) throws ServiceException {
        AccountAddressQuery query;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)accountSegment);
        accountQuery.orderByFullName().ascending();
        boolean hasQueryProperty = false;
        String wildcard = ".*";
        if (accountQuery instanceof ContactQuery) {
            ContactQuery contactQuery = (ContactQuery)accountQuery;
            if (firstName != null) {
                hasQueryProperty = true;
                contactQuery.thereExistsFirstName().like((Object)("(?i).*" + firstName + ".*"));
            }
            if (lastName != null) {
                hasQueryProperty = true;
                contactQuery.thereExistsLastName().like((Object)("(?i).*" + lastName + ".*"));
            } else {
                hasQueryProperty = true;
                contactQuery.thereExistsLastName().like((Object)".*");
            }
        }
        if (fullName != null) {
            hasQueryProperty = true;
            accountQuery.thereExistsFullName().like((Object)("(?i).*" + fullName + ".*"));
        }
        if (aliasName != null) {
            hasQueryProperty = true;
            accountQuery.thereExistsAliasName().like((Object)("(?i).*" + aliasName + ".*"));
        }
        Object queryFilterClause = null;
        ArrayList<CallSite> stringParams = new ArrayList<CallSite>();
        int stringParamIndex = 0;
        if (phoneNumberMobile != null) {
            query = (PhoneNumberQuery)pm.newQuery(PhoneNumber.class);
            query.thereExistsPhoneNumberFull().like((Object)(".*" + phoneNumberMobile + ".*"));
            accountQuery.thereExistsAddress().elementOf(PersistenceHelper.asSubquery((AnyTypePredicate)query));
        }
        if (phoneNumberHome != null) {
            query = (PhoneNumberQuery)pm.newQuery(PhoneNumber.class);
            query.thereExistsPhoneNumberFull().like((Object)(".*" + phoneNumberHome + ".*"));
            accountQuery.thereExistsAddress().elementOf(PersistenceHelper.asSubquery((AnyTypePredicate)query));
        }
        if (phoneNumberBusiness != null) {
            query = (PhoneNumberQuery)pm.newQuery(PhoneNumber.class);
            query.thereExistsPhoneNumberFull().like((Object)(".*" + phoneNumberBusiness + ".*"));
            accountQuery.thereExistsAddress().elementOf(PersistenceHelper.asSubquery((AnyTypePredicate)query));
        }
        if (postalCityHome != null) {
            query = (PostalAddressQuery)pm.newQuery(PostalAddress.class);
            query.thereExistsPostalCity().like((Object)(".*" + postalCityHome + ".*"));
            accountQuery.thereExistsAddress().elementOf(PersistenceHelper.asSubquery((AnyTypePredicate)query));
        }
        if (postalCityBusiness != null) {
            query = (PostalAddressQuery)pm.newQuery(PostalAddress.class);
            query.thereExistsPostalCity().like((Object)(".*" + postalCityBusiness + ".*"));
            accountQuery.thereExistsAddress().elementOf(PersistenceHelper.asSubquery((AnyTypePredicate)query));
        }
        if (postalStreetHome != null) {
            for (int i = 0; i < postalStreetHome.size(); ++i) {
                hasQueryProperty = true;
                queryFilterClause = stringParamIndex > 0 ? queryFilterClause + " AND " : "";
                queryFilterClause = (String)queryFilterClause + "v.object_id IN (SELECT act.object_id FROM OOCKE1_ACCOUNT act INNER JOIN OOCKE1_ADDRESS adr ON adr.p$$parent = act.object_id WHERE ((adr.postal_street_0 LIKE ?s" + stringParamIndex + ") OR (adr.postal_street_1 LIKE ?s" + stringParamIndex + ") OR (adr.postal_street_2 LIKE ?s" + stringParamIndex + ") OR (adr.postal_street_3 LIKE ?s" + stringParamIndex + ") OR (adr.postal_street_4 LIKE ?s" + stringParamIndex + ")))";
                stringParams.add((CallSite)((Object)(".*" + postalStreetHome.get(i) + ".*")));
                ++stringParamIndex;
            }
        }
        if (postalStreetBusiness != null) {
            for (int i = 0; i < postalStreetBusiness.size(); ++i) {
                hasQueryProperty = true;
                queryFilterClause = stringParamIndex > 0 ? (String)queryFilterClause + " AND " : "";
                queryFilterClause = (String)queryFilterClause + "v.object_id IN (SELECT act.object_id FROM OOCKE1_ACCOUNT act INNER JOIN OOCKE1_ADDRESS adr ON adr.p$$parent = act.object_id WHERE ((adr.postal_street_0 LIKE ?s" + stringParamIndex + ") OR (adr.postal_street_1 LIKE ?s" + stringParamIndex + ") OR (adr.postal_street_2 LIKE ?s" + stringParamIndex + ") OR (adr.postal_street_3 LIKE ?s" + stringParamIndex + ") OR (adr.postal_street_4 LIKE ?s" + stringParamIndex + ")))";
                stringParams.add((CallSite)((Object)(".*" + postalStreetBusiness.get(i) + ".*")));
                ++stringParamIndex;
            }
        }
        if (emailHome != null) {
            emailHome = emailHome.trim();
            EMailAddressQuery query2 = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
            query2.thereExistsEmailAddress().like((Object)(".*" + emailHome + ".*"));
            accountQuery.thereExistsAddress().elementOf(PersistenceHelper.asSubquery((AnyTypePredicate)query2));
        }
        if (emailBusiness != null) {
            emailBusiness = emailBusiness.trim();
            EMailAddressQuery query3 = (EMailAddressQuery)pm.newQuery(EMailAddress.class);
            query3.thereExistsEmailAddress().like((Object)(".*" + emailBusiness + ".*"));
            accountQuery.thereExistsAddress().elementOf(PersistenceHelper.asSubquery((AnyTypePredicate)query3));
        }
        if (queryFilterClause != null) {
            QueryExtensionRecord queryFilter = PersistenceHelper.newQueryExtension((AnyTypePredicate)accountQuery);
            queryFilter.setClause((String)queryFilterClause);
            queryFilter.getStringParam().addAll(stringParams);
        }
        return hasQueryProperty ? accountSegment.getAccount(accountQuery) : null;
    }

    @Override
    public void preDelete(RefObject_1_0 object, boolean preDelete) throws ServiceException {
        super.preDelete(object, preDelete);
        if (object instanceof org.opencrx.kernel.account1.jmi1.Account) {
            this.removeAccount((org.opencrx.kernel.account1.jmi1.Account)object, preDelete);
        } else if (object instanceof AccountAddress) {
            this.removeAddress((AccountAddress)object, preDelete);
        }
    }

    @Override
    public void preStore(RefObject_1_0 object) throws ServiceException {
        super.preStore(object);
        if (object instanceof org.opencrx.kernel.account1.jmi1.Account) {
            this.updateAccount((org.opencrx.kernel.account1.jmi1.Account)object);
        } else if (object instanceof AccountAddress) {
            this.updateAddress((AccountAddress)object);
        } else if (object instanceof Member) {
            this.updateMember((Member)object);
        }
    }

    public static interface AddressFilter {
        public boolean matches(AccountAddress var1);
    }
}

