/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.backend.Base;
import org.opencrx.kernel.backend.Cloneable;
import org.opencrx.kernel.backend.Products;
import org.opencrx.kernel.contract1.cci2.AbstractContractQuery;
import org.opencrx.kernel.contract1.cci2.AbstractInvoicePositionQuery;
import org.opencrx.kernel.contract1.cci2.AbstractOpportunityPositionQuery;
import org.opencrx.kernel.contract1.cci2.AbstractQuotePositionQuery;
import org.opencrx.kernel.contract1.cci2.AbstractSalesOrderPositionQuery;
import org.opencrx.kernel.contract1.cci2.CalculationRuleQuery;
import org.opencrx.kernel.contract1.cci2.ContractContainsContractGroupAssignment;
import org.opencrx.kernel.contract1.cci2.ContractContainsPositionModification;
import org.opencrx.kernel.contract1.cci2.ContractCreatorQuery;
import org.opencrx.kernel.contract1.cci2.ContractFilterGlobalQuery;
import org.opencrx.kernel.contract1.cci2.ContractPositionContainsDeliveryInformation;
import org.opencrx.kernel.contract1.cci2.ContractTypeQuery;
import org.opencrx.kernel.contract1.cci2.GetContractAmountsResult;
import org.opencrx.kernel.contract1.cci2.GetPositionAmountsResult;
import org.opencrx.kernel.contract1.cci2.PreviewRepriceResult;
import org.opencrx.kernel.contract1.jmi1.AbstractContract;
import org.opencrx.kernel.contract1.jmi1.AbstractFilterContract;
import org.opencrx.kernel.contract1.jmi1.AbstractInvoicePosition;
import org.opencrx.kernel.contract1.jmi1.AbstractOpportunityPosition;
import org.opencrx.kernel.contract1.jmi1.AbstractQuotePosition;
import org.opencrx.kernel.contract1.jmi1.AbstractSalesOrderPosition;
import org.opencrx.kernel.contract1.jmi1.AccountAssignmentContract;
import org.opencrx.kernel.contract1.jmi1.CalculationRule;
import org.opencrx.kernel.contract1.jmi1.Contract1Package;
import org.opencrx.kernel.contract1.jmi1.ContractCreator;
import org.opencrx.kernel.contract1.jmi1.ContractFilterGlobal;
import org.opencrx.kernel.contract1.jmi1.ContractFilterProperty;
import org.opencrx.kernel.contract1.jmi1.ContractGroup;
import org.opencrx.kernel.contract1.jmi1.ContractGroupAssignment;
import org.opencrx.kernel.contract1.jmi1.ContractType;
import org.opencrx.kernel.contract1.jmi1.DeliveryInformation;
import org.opencrx.kernel.contract1.jmi1.EMailAddress;
import org.opencrx.kernel.contract1.jmi1.GenericContract;
import org.opencrx.kernel.contract1.jmi1.GetContractAmountsResult;
import org.opencrx.kernel.contract1.jmi1.GetPositionAmountsResult;
import org.opencrx.kernel.contract1.jmi1.Invoice;
import org.opencrx.kernel.contract1.jmi1.InvoicePosition;
import org.opencrx.kernel.contract1.jmi1.Lead;
import org.opencrx.kernel.contract1.jmi1.Opportunity;
import org.opencrx.kernel.contract1.jmi1.OpportunityPosition;
import org.opencrx.kernel.contract1.jmi1.PhoneNumber;
import org.opencrx.kernel.contract1.jmi1.PositionCreation;
import org.opencrx.kernel.contract1.jmi1.PositionModification;
import org.opencrx.kernel.contract1.jmi1.PositionRemoval;
import org.opencrx.kernel.contract1.jmi1.PreviewRepriceResult;
import org.opencrx.kernel.contract1.jmi1.QuantityModification;
import org.opencrx.kernel.contract1.jmi1.Quote;
import org.opencrx.kernel.contract1.jmi1.QuotePosition;
import org.opencrx.kernel.contract1.jmi1.RemovedPosition;
import org.opencrx.kernel.contract1.jmi1.SalesContract;
import org.opencrx.kernel.contract1.jmi1.SalesContractCreator;
import org.opencrx.kernel.contract1.jmi1.SalesContractPosition;
import org.opencrx.kernel.contract1.jmi1.SalesOrder;
import org.opencrx.kernel.contract1.jmi1.SalesOrderPosition;
import org.opencrx.kernel.contract1.jmi1.SalesVolumeContract;
import org.opencrx.kernel.contract1.jmi1.UriAddress;
import org.opencrx.kernel.depot1.cci2.DepotPositionReferenceQuery;
import org.opencrx.kernel.depot1.cci2.DepotReferenceHolderContainsDepotReference;
import org.opencrx.kernel.depot1.cci2.DepotReferenceQuery;
import org.opencrx.kernel.depot1.jmi1.Depot;
import org.opencrx.kernel.depot1.jmi1.DepotPosition;
import org.opencrx.kernel.depot1.jmi1.DepotPositionReference;
import org.opencrx.kernel.depot1.jmi1.DepotReference;
import org.opencrx.kernel.generic.SecurityKeys;
import org.opencrx.kernel.generic.cci2.CrxObjectContainsPropertySet;
import org.opencrx.kernel.generic.cci2.DescriptionContainerContainsDescription;
import org.opencrx.kernel.generic.jmi1.CrxObject;
import org.opencrx.kernel.generic.jmi1.Description;
import org.opencrx.kernel.generic.jmi1.DescriptionContainer;
import org.opencrx.kernel.generic.jmi1.PropertySet;
import org.opencrx.kernel.product1.cci2.ConfiguredProductQuery;
import org.opencrx.kernel.product1.cci2.PricingRuleQuery;
import org.opencrx.kernel.product1.cci2.Product;
import org.opencrx.kernel.product1.cci2.SalesTaxType;
import org.opencrx.kernel.product1.cci2.SalesTaxTypeAssignmentQuery;
import org.opencrx.kernel.product1.cci2.SalesTaxTypeQuery;
import org.opencrx.kernel.product1.jmi1.AbstractPriceLevel;
import org.opencrx.kernel.product1.jmi1.AbstractProduct;
import org.opencrx.kernel.product1.jmi1.ConfiguredProduct;
import org.opencrx.kernel.product1.jmi1.DiscountOrigin;
import org.opencrx.kernel.product1.jmi1.GetPriceLevelResult;
import org.opencrx.kernel.product1.jmi1.PricingRule;
import org.opencrx.kernel.product1.jmi1.ProductBasePrice;
import org.opencrx.kernel.product1.jmi1.SalesTaxTypeAssignment;
import org.opencrx.kernel.product1.jmi1.SalesTaxTypeGroup;
import org.opencrx.kernel.product1.jmi1.SalesTransactionType;
import org.opencrx.kernel.product1.jmi1.Segment;
import org.opencrx.kernel.uom1.jmi1.Uom;
import org.opencrx.kernel.utils.ScriptUtils;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.security.realm1.jmi1.PrincipalGroup;
import org.opencrx.security.realm1.jmi1.User;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.accessor.jmi.cci.RefPackage_1_0;
import org.openmdx.base.exception.RuntimeServiceException;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.Authority;
import org.openmdx.base.marshalling.Marshaller;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.rest.cci.QueryExtensionRecord;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.id.UUIDs;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class Contracts
extends AbstractImpl {
    public static final short STATUS_CODE_OK = 0;
    public static final short STATUS_CODE_ERROR = 1;
    public static final int MIN_MAX_QUANTITY_HANDLING_NA = 0;
    public static final int MIN_MAX_QUANTITY_HANDLING_LIMIT = 3;
    public static final short PRICING_STATE_NA = 0;
    public static final short PRICING_STATE_DIRTY = 10;
    public static final short PRICING_STATE_OK = 20;
    public static final String BOOKING_TEXT_NAME_RETURN_GOODS = "return goods";
    public static final String BOOKING_TEXT_NAME_DELIVER_GOODS = "deliver goods";
    public static final String CALCULATION_RULE_NAME_DEFAULT = "Default";
    public static final short CONTRACT_TYPE_LEAD = 1;
    public static final short CONTRACT_TYPE_OPPORTUNITY = 2;
    public static final short CONTRACT_TYPE_QUOTE = 3;
    public static final short CONTRACT_TYPE_SALES_ORDER = 4;
    public static final short CONTRACT_TYPE_INVOICE = 5;
    public static final short CONTRACT_TYPE_SALESVOLUME_CONTRACT = 6;
    public static final short CONTRACT_TYPE_GENERIC_CONTRACT = 7;
    public static final BigDecimal HUNDRED = new BigDecimal("100.0");
    public static final String PRIVATE_GROUP_SUFFIX = "~Private";
    public static final String DEFAULT_GET_POSITION_AMOUNTS_SCRIPT = "//<pre>\npublic static org.opencrx.kernel.contract1.jmi1.GetPositionAmountsResult getPositionAmounts(\n    org.openmdx.base.accessor.jmi.cci.RefPackage_1_0 rootPkg,\n    org.opencrx.kernel.contract1.jmi1.CalculationRule calculationRule,\n    org.opencrx.kernel.contract1.jmi1.SalesContractPosition position,\n    java.math.BigDecimal pricePerUnit,\n    java.math.BigDecimal quantity,\n    java.math.BigDecimal uomScaleFactor,\n    java.math.BigDecimal discount,\n    java.lang.Boolean discountIsPercentage,\n    java.lang.Short discountCalculationType,\n    java.math.BigDecimal salesTaxRate\n) {\n    return org.opencrx.kernel.backend.Contracts.getPositionAmounts(\n        rootPkg,\n        calculationRule,\n        position,\n        pricePerUnit,\n        quantity,\n        uomScaleFactor,\n        discount,\n        discountIsPercentage,\n        discountCalculationType,\n        salesTaxRate\n   );\n}//</pre>";
    public static final String DEFAULT_GET_CONTRACT_AMOUNTS_SCRIPT = "//<pre>\npublic static org.opencrx.kernel.contract1.jmi1.GetContractAmountsResult getContractAmounts(\n    org.openmdx.base.accessor.jmi.cci.RefPackage_1_0 rootPkg,\n    org.opencrx.kernel.contract1.jmi1.CalculationRule calculationRule,\n    org.opencrx.kernel.contract1.jmi1.SalesContract contract,\n    Integer[] lineItemNumbers,\n    java.math.BigDecimal[] positionBaseAmounts,\n    java.math.BigDecimal[] positionDiscountAmounts,\n    java.math.BigDecimal[] positionTaxAmounts,\n    java.math.BigDecimal[] positionAmounts,\n    java.math.BigDecimal[] salesCommissions,\n    Boolean[] salesCommissionIsPercentages\n) {\n    return org.opencrx.kernel.backend.Contracts.getContractAmounts(\n        rootPkg,\n        calculationRule,\n        contract,\n        lineItemNumbers,\n        positionBaseAmounts,\n        positionDiscountAmounts,\n        positionTaxAmounts,\n        positionAmounts,\n        salesCommissions,\n        salesCommissionIsPercentages\n    );\n}//</pre>";

    public static void register() {
        Contracts.registerImpl(new Contracts());
    }

    public static Contracts getInstance() throws ServiceException {
        return Contracts.getInstance(Contracts.class);
    }

    protected Contracts() {
    }

    public CalculationRule findCalculationRule(String name, org.opencrx.kernel.contract1.jmi1.Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        CalculationRuleQuery calculationRuleQuery = (CalculationRuleQuery)pm.newQuery(CalculationRule.class);
        calculationRuleQuery.name().equalTo((Object)name);
        List calculationRules = segment.getCalculationRule(calculationRuleQuery);
        return calculationRules.isEmpty() ? null : (CalculationRule)calculationRules.iterator().next();
    }

    public ContractCreator findContractCreator(String name, org.opencrx.kernel.contract1.jmi1.Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        ContractCreatorQuery contractCreatorQuery = (ContractCreatorQuery)pm.newQuery(ContractCreator.class);
        contractCreatorQuery.name().equalTo((Object)name);
        List contractCreators = segment.getContractCreator(contractCreatorQuery);
        return contractCreators.isEmpty() ? null : (ContractCreator)contractCreators.iterator().next();
    }

    public org.opencrx.kernel.contract1.jmi1.Segment getContractSegment(PersistenceManager pm, String providerName, String segmentName) {
        return (org.opencrx.kernel.contract1.jmi1.Segment)pm.getObjectById((Object)new Path("xri:@openmdx:org.opencrx.kernel.contract1/provider/" + providerName + "/segment/" + segmentName));
    }

    public CalculationRule initCalculationRule(String calculationRuleName, String description, String getPositionAmountsScript, String getContractAmountsScript, PersistenceManager pm, String providerName, String segmentName) {
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = this.getContractSegment(pm, providerName, segmentName);
        CalculationRule calculationRule = null;
        calculationRule = this.findCalculationRule(calculationRuleName, contractSegment);
        if (calculationRule != null) {
            return calculationRule;
        }
        pm.currentTransaction().begin();
        calculationRule = (CalculationRule)pm.newInstance(CalculationRule.class);
        calculationRule.setName(calculationRuleName);
        calculationRule.setDescription(description);
        calculationRule.setGetPositionAmountsScript(getPositionAmountsScript);
        calculationRule.setGetContractAmountsScript(getContractAmountsScript);
        calculationRule.setDefault(true);
        calculationRule.getOwningGroup().addAll(contractSegment.getOwningGroup());
        contractSegment.addCalculationRule(UUIDConversion.toUID((UUID)UUIDs.newUUID()), calculationRule);
        pm.currentTransaction().commit();
        return calculationRule;
    }

    public ContractFilterGlobal findContractFilter(String contractFilterName, org.opencrx.kernel.contract1.jmi1.Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        ContractFilterGlobalQuery query = (ContractFilterGlobalQuery)pm.newQuery(ContractFilterGlobal.class);
        query.name().equalTo((Object)contractFilterName);
        List contractFilters = segment.getContractFilter(query);
        if (!contractFilters.isEmpty()) {
            return (ContractFilterGlobal)contractFilters.iterator().next();
        }
        return null;
    }

    public ContractFilterGlobal initContractFilter(String filterName, ContractFilterProperty[] filterProperties, org.opencrx.kernel.contract1.jmi1.Segment segment, List<PrincipalGroup> allUsers) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        ContractFilterGlobal contractFilter = this.findContractFilter(filterName, segment);
        if (contractFilter != null) {
            return contractFilter;
        }
        try {
            pm.currentTransaction().begin();
            contractFilter = (ContractFilterGlobal)pm.newInstance(ContractFilterGlobal.class);
            contractFilter.setName(filterName);
            contractFilter.getOwningGroup().addAll(allUsers);
            segment.addContractFilter(false, Contracts.getInstance().getUidAsString(), contractFilter);
            for (int i = 0; i < filterProperties.length; ++i) {
                filterProperties[i].getOwningGroup().addAll(allUsers);
                contractFilter.addFilterProperty(false, Contracts.getInstance().getUidAsString(), filterProperties[i]);
            }
            pm.currentTransaction().commit();
        }
        catch (Exception e) {
            new ServiceException(e).log();
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return contractFilter;
    }

    protected void copyCrxObject(CrxObject source, CrxObject target) {
        target.setUserBoolean0(source.isUserBoolean0());
        target.setUserNumber0(source.getUserNumber0());
        target.setUserString0(source.getUserString0());
        target.setUserDateTime0(source.getUserDateTime0());
        target.setUserDate0(source.getUserDate0());
        target.setUserCode0(source.getUserCode0());
        target.setUserBoolean1(source.isUserBoolean1());
        target.setUserNumber1(source.getUserNumber1());
        target.setUserString1(source.getUserString1());
        target.setUserDateTime1(source.getUserDateTime1());
        target.setUserDate1(source.getUserDate1());
        target.setUserCode1(source.getUserCode1());
        target.setUserBoolean2(source.isUserBoolean2());
        target.setUserNumber2(source.getUserNumber2());
        target.setUserString2(source.getUserString2());
        target.setUserDateTime2(source.getUserDateTime2());
        target.setUserDate2(source.getUserDate2());
        target.setUserCode2(source.getUserCode2());
        target.setUserBoolean3(source.isUserBoolean3());
        target.setUserNumber3(source.getUserNumber3());
        target.setUserString3(source.getUserString3());
        target.setUserDateTime3(source.getUserDateTime3());
        target.setUserDate3(source.getUserDate3());
        target.setUserCode3(source.getUserCode3());
        target.setUserBoolean4(source.getUserBoolean4());
        target.setUserNumber4(source.getUserNumber4());
        target.setUserString4(source.getUserString4());
        target.setUserDateTime4(source.getUserDateTime4());
        target.setUserDate4(source.getUserDate4());
        target.setUserCode4(source.getUserCode4());
    }

    protected void copySalesContract(SalesContract source, SalesContract target) throws ServiceException {
        target.setName(source.getName());
        target.setDescription(source.getDescription());
        target.setPriority(source.getPriority());
        target.setActiveOn(source.getActiveOn());
        target.setExpiresOn(source.getExpiresOn());
        target.setCancelOn(source.getCancelOn());
        target.setClosedOn(source.getClosedOn());
        target.setContractNumber(source.getContractNumber());
        target.setContractCurrency(source.getContractCurrency());
        target.setPaymentTerms(source.getPaymentTerms());
        target.setContractLanguage(source.getContractLanguage());
        target.setContractState(source.getContractState());
        target.setPricingDate(source.getPricingDate());
        target.getCompetitor().clear();
        target.getCompetitor().addAll(source.getCompetitor());
        target.getContact().clear();
        target.getContact().addAll(source.getContact());
        target.setBroker(source.getBroker());
        target.setCustomer(source.getCustomer());
        target.setSalesRep(source.getSalesRep());
        target.setSupplier(source.getSupplier());
        target.getActivity().clear();
        target.getActivity().addAll(source.getActivity());
        target.setOrigin(source.getOrigin());
        target.getInventoryCb().clear();
        target.getInventoryCb().addAll(source.getInventoryCb());
        target.setPricingRule(source.getPricingRule());
        target.setCalcRule(source.getCalcRule());
        target.setShippingMethod(source.getShippingMethod());
        target.setShippingTrackingNumber(source.getShippingTrackingNumber());
        target.setShippingInstructions(source.getShippingInstructions());
        target.setGift(source.isGift());
        target.setGiftMessage(source.getGiftMessage());
        target.getOwningGroup().clear();
        target.getOwningGroup().addAll(source.getOwningGroup());
        target.setOwningUser(source.getOwningUser());
        target.setDisabled(source.isDisabled());
        target.setDisabledReason(source.getDisabledReason());
        target.getExternalLink().clear();
        target.getExternalLink().addAll(source.getExternalLink());
        target.getCategory().clear();
        target.getCategory().addAll(source.getCategory());
        target.setCarrier(source.getCarrier());
        target.setFreightTerms(source.getFreightTerms());
        target.setSalesTaxTypeGroup(source.getSalesTaxTypeGroup());
        this.copyCrxObject(source, target);
    }

    protected void copySalesContractPosition(SalesContractPosition source, SalesContractPosition target) throws ServiceException {
        target.setLineItemNumber(source.getLineItemNumber());
        target.setName(source.getName());
        target.setDescription(source.getDescription());
        target.setPositionNumber(source.getPositionNumber());
        target.setContractPositionState(source.getContractPositionState());
        target.setQuantity(source.getQuantity());
        target.setMinQuantity(source.getMinQuantity());
        target.setMaxQuantity(source.getMaxQuantity());
        target.setOffsetQuantity(source.getOffsetQuantity());
        try {
            target.setMinMaxQuantityHandling(source.getMinMaxQuantityHandling());
        }
        catch (Exception exception) {
            // empty catch block
        }
        target.setPricePerUnit(source.getPricePerUnit());
        try {
            target.setPricingState(source.getPricingState());
        }
        catch (Exception exception) {
            // empty catch block
        }
        target.setDiscount(source.getDiscount());
        target.setDiscountDescription(source.getDiscountDescription());
        target.setDiscountIsPercentage(source.isDiscountIsPercentage());
        target.setSalesCommission(source.getSalesCommission());
        target.setSalesCommissionIsPercentage(source.isSalesCommissionIsPercentage());
        target.getContact().clear();
        target.getContact().addAll(source.getContact());
        target.setPriceUom(source.getPriceUom());
        target.setUom(source.getUom());
        target.setSalesTaxType(source.getSalesTaxType());
        try {
            target.setListPrice(source.getListPrice());
        }
        catch (Exception exception) {
            // empty catch block
        }
        target.setPricingRule(source.getPricingRule());
        target.setPriceLevel(source.getPriceLevel());
        target.setCalcRule(source.getCalcRule());
        try {
            target.setShippingMethod(source.getShippingMethod());
        }
        catch (Exception exception) {
            // empty catch block
        }
        target.setShippingTrackingNumber(source.getShippingTrackingNumber());
        target.setShippingInstructions(source.getShippingInstructions());
        try {
            target.setGift(source.isGift());
        }
        catch (Exception exception) {
            // empty catch block
        }
        target.setGiftMessage(source.getGiftMessage());
        target.setCarrier(source.getCarrier());
        target.setSalesTransactionType(source.getSalesTransactionType());
        if (source instanceof ConfiguredProduct && target instanceof ConfiguredProduct) {
            ((ConfiguredProduct)((Object)target)).setProduct(((ConfiguredProduct)((Object)source)).getProduct());
            ((ConfiguredProduct)((Object)target)).setProductSerialNumber(((ConfiguredProduct)((Object)source)).getProductSerialNumber());
            ((ConfiguredProduct)((Object)target)).setConfigType(((ConfiguredProduct)((Object)source)).getConfigType());
        }
        if (source instanceof CrxObject && target instanceof CrxObject) {
            this.copyCrxObject((CrxObject)((Object)source), (CrxObject)((Object)target));
        }
        target.setOrigin(source);
    }

    protected Description getAdditionalDescription(DescriptionContainer container, short language) throws ServiceException {
        DescriptionContainerContainsDescription.AdditionalDescription descriptions = container.getAdditionalDescription();
        Iterator iterator = descriptions.iterator();
        while (iterator.hasNext()) {
            Description description = (Description)iterator.next();
            if (description.getLanguage() != language) continue;
            return description;
        }
        return null;
    }

    public CalculationRule getDefaultCalculationRule(org.opencrx.kernel.contract1.jmi1.Segment contractSegment) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contractSegment);
        CalculationRuleQuery query = (CalculationRuleQuery)pm.newQuery(CalculationRule.class);
        query.thereExistsIsDefault().isTrue();
        List calculationRules = contractSegment.getCalculationRule(query);
        return calculationRules.isEmpty() ? null : (CalculationRule)calculationRules.iterator().next();
    }

    public void markAsClosed(AbstractContract contract, short newContractState) throws ServiceException {
        contract.setClosedOn(new Date());
        contract.setContractState(newContractState);
    }

    public BigDecimal getUomScaleFactor(SalesContractPosition position) {
        return position.getUom() != null && position.getPriceUom() != null ? Utils.getUomScaleFactor(position.getUom(), position.getPriceUom()) : BigDecimal.ONE;
    }

    protected AbstractPriceLevel getPriceLevel(SalesContractPosition position) {
        return position.getPriceLevel();
    }

    public BigDecimal getSalesTaxRate(SalesContractPosition position) {
        BigDecimal salesTaxRate = BigDecimal.ZERO;
        try {
            if (position.getSalesTaxType() != null && position.getSalesTaxType().getRate() != null) {
                salesTaxRate = position.getSalesTaxType().getRate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return salesTaxRate;
    }

    public BigDecimal getPricePerUnit(SalesContractPosition position) {
        return position.getPricePerUnit() == null ? BigDecimal.ZERO : position.getPricePerUnit();
    }

    protected RefPackage getJmiPackage(PersistenceManager pm, String authorityXri) {
        Authority obj = (Authority)pm.getObjectById(Authority.class, (Object)authorityXri);
        return obj.refOutermostPackage().refPackage(obj.refGetPath().getLastSegment().toString());
    }

    protected Contract1Package getContractPackage(PersistenceManager pm) {
        return (Contract1Package)this.getJmiPackage(pm, "xri://@openmdx*org.opencrx.kernel.contract1");
    }

    protected BigDecimal getMinMaxAdjustedQuantity(SalesContractPosition position) {
        BigDecimal quantity;
        BigDecimal minMaxAdjustedQuantity = quantity = position.getQuantity() != null ? position.getQuantity() : BigDecimal.ZERO;
        BigDecimal minQuantity = position.getMinQuantity() != null ? position.getMinQuantity() : BigDecimal.ZERO;
        BigDecimal maxQuantity = position.getMaxQuantity() != null ? position.getMaxQuantity() : new BigDecimal(Double.MAX_VALUE);
        BigDecimal offsetQuantity = position.getOffsetQuantity() != null ? position.getOffsetQuantity() : BigDecimal.ZERO;
        short minMaxQuantityHandling = 0;
        try {
            minMaxQuantityHandling = position.getMinMaxQuantityHandling();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (minMaxQuantityHandling == 3) {
            minMaxAdjustedQuantity = quantity.compareTo(BigDecimal.ZERO) < 0 ? minMaxAdjustedQuantity.add(offsetQuantity).max(maxQuantity.negate()).min(minQuantity.negate()) : minMaxAdjustedQuantity.subtract(offsetQuantity).max(minQuantity).min(maxQuantity);
        }
        return minMaxAdjustedQuantity;
    }

    public static GetPositionAmountsResult getPositionAmounts(RefPackage_1_0 rootPkg, CalculationRule calculationRule, SalesContractPosition position, BigDecimal quantity, BigDecimal uomScaleFactor, BigDecimal salesTaxRate) {
        try {
            return Contracts.getInstance().getPositionAmountsInternal(calculationRule, position, Contracts.getInstance().getPricePerUnit(position), quantity, uomScaleFactor, position.getDiscount() != null ? position.getDiscount() : BigDecimal.ZERO, position.isDiscountIsPercentage(), position.getDiscountCalculationType(), salesTaxRate);
        }
        catch (ServiceException e) {
            throw new RuntimeServiceException((Exception)((Object)e));
        }
    }

    public static GetPositionAmountsResult getPositionAmounts(RefPackage_1_0 rootPkg, CalculationRule calculationRule, SalesContractPosition position, BigDecimal pricePerUnit, BigDecimal quantity, BigDecimal uomScaleFactor, BigDecimal discount, Boolean discountIsPercentage, Short discountCalculationType, BigDecimal salesTaxRate) {
        try {
            return Contracts.getInstance().getPositionAmountsInternal(calculationRule, position, pricePerUnit, quantity, uomScaleFactor, discount, discountIsPercentage, discountCalculationType, salesTaxRate);
        }
        catch (ServiceException e) {
            throw new RuntimeServiceException((Exception)((Object)e));
        }
    }

    public GetPositionAmountsResult getPositionAmounts(CalculationRule calculationRule, SalesContractPosition position, BigDecimal overridePricePerUnit, BigDecimal overrideQuantity, BigDecimal overrideUomScaleFactor, BigDecimal overrideDiscount, Boolean overrideDiscountIsPercentage, Short overrideDiscountCalculationType, BigDecimal overrideSalesTaxRate) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)calculationRule);
        String script = calculationRule.getGetPositionAmountsScript() == null || calculationRule.getGetPositionAmountsScript().length() == 0 ? DEFAULT_GET_POSITION_AMOUNTS_SCRIPT : calculationRule.getGetPositionAmountsScript();
        Contract1Package contractPkg = this.getContractPackage(pm);
        try {
            GetPositionAmountsResult result;
            Class<?> clazz = ScriptUtils.getClass(script);
            Method getPositionAmountMethod1 = null;
            Method getPositionAmountMethod2 = null;
            try {
                getPositionAmountMethod1 = clazz.getMethod("getPositionAmounts", RefPackage_1_0.class, CalculationRule.class, SalesContractPosition.class, BigDecimal.class, BigDecimal.class, BigDecimal.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                getPositionAmountMethod2 = clazz.getMethod("getPositionAmounts", RefPackage_1_0.class, CalculationRule.class, SalesContractPosition.class, BigDecimal.class, BigDecimal.class, BigDecimal.class, BigDecimal.class, Boolean.class, Short.class, BigDecimal.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (getPositionAmountMethod1 != null) {
                result = (GetPositionAmountsResult)getPositionAmountMethod1.invoke(null, contractPkg.refOutermostPackage(), calculationRule, position, overrideQuantity == null ? this.getMinMaxAdjustedQuantity(position) : overrideQuantity, overrideUomScaleFactor == null ? this.getUomScaleFactor(position) : overrideUomScaleFactor, overrideSalesTaxRate == null ? this.getSalesTaxRate(position) : overrideSalesTaxRate);
                return result;
            }
            if (getPositionAmountMethod2 != null) {
                result = (GetPositionAmountsResult)getPositionAmountMethod2.invoke(null, contractPkg.refOutermostPackage(), calculationRule, position, overridePricePerUnit == null ? this.getPricePerUnit(position) : overridePricePerUnit, overrideQuantity == null ? this.getMinMaxAdjustedQuantity(position) : overrideQuantity, overrideUomScaleFactor == null ? this.getUomScaleFactor(position) : overrideUomScaleFactor, overrideDiscount == null ? position.getDiscount() : overrideDiscount, overrideDiscount == null ? position.isDiscountIsPercentage() : overrideDiscountIsPercentage, overrideDiscountCalculationType == null ? position.getDiscountCalculationType() : overrideDiscountCalculationType, overrideSalesTaxRate == null ? this.getSalesTaxRate(position) : overrideSalesTaxRate);
                return result;
            }
            return (GetPositionAmountsResult)Structures.create(GetPositionAmountsResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)GetPositionAmountsResult.Member.statusCode, (Object)1), Datatypes.member((Enum)GetPositionAmountsResult.Member.statusMessage, (Object)"getPositionAmounts does not define a method with the following signature:\n//<pre>\npublic static org.opencrx.kernel.contract1.jmi1.GetPositionAmountsResult getPositionAmounts(\n    org.openmdx.base.accessor.jmi.cci.RefPackage_1_0 rootPkg,\n    org.opencrx.kernel.contract1.jmi1.CalculationRule calculationRule,\n    org.opencrx.kernel.contract1.jmi1.SalesContractPosition position,\n    java.math.BigDecimal pricePerUnit,\n    java.math.BigDecimal quantity,\n    java.math.BigDecimal uomScaleFactor,\n    java.math.BigDecimal discount,\n    java.lang.Boolean discountIsPercentage,\n    java.lang.Short discountCalculationType,\n    java.math.BigDecimal salesTaxRate\n) {\n    return org.opencrx.kernel.backend.Contracts.getPositionAmounts(\n        rootPkg,\n        calculationRule,\n        position,\n        pricePerUnit,\n        quantity,\n        uomScaleFactor,\n        discount,\n        discountIsPercentage,\n        discountCalculationType,\n        salesTaxRate\n   );\n}//</pre>")});
        }
        catch (InvocationTargetException e) {
            return (GetPositionAmountsResult)Structures.create(GetPositionAmountsResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)GetPositionAmountsResult.Member.statusCode, (Object)1), Datatypes.member((Enum)GetPositionAmountsResult.Member.statusMessage, (Object)("Can not invoke getPositionAmounts:\n" + e.getTargetException().getMessage()))});
        }
        catch (IllegalAccessException e) {
            return (GetPositionAmountsResult)Structures.create(GetPositionAmountsResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)GetPositionAmountsResult.Member.statusCode, (Object)1), Datatypes.member((Enum)GetPositionAmountsResult.Member.statusMessage, (Object)("Illegal access when invoking getPositionAmounts:\n" + e.getMessage()))});
        }
        catch (Exception e) {
            return (GetPositionAmountsResult)Structures.create(GetPositionAmountsResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)GetPositionAmountsResult.Member.statusCode, (Object)1), Datatypes.member((Enum)GetPositionAmountsResult.Member.statusMessage, (Object)("Error parsing getPositionAmountsScript:\n" + e.getMessage()))});
        }
    }

    public GetContractAmountsResult getContractAmounts(CalculationRule calculationRule, SalesContract contract, SalesContractAmounts salesContractAmounts) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)calculationRule);
        String script = calculationRule.getGetContractAmountsScript() == null || calculationRule.getGetContractAmountsScript().length() == 0 ? DEFAULT_GET_CONTRACT_AMOUNTS_SCRIPT : calculationRule.getGetContractAmountsScript();
        Contract1Package contractPkg = this.getContractPackage(pm);
        try {
            Class<?> clazz = ScriptUtils.getClass(script);
            Method getContractAmountMethod = clazz.getMethod("getContractAmounts", RefPackage_1_0.class, CalculationRule.class, SalesContract.class, Integer[].class, BigDecimal[].class, BigDecimal[].class, BigDecimal[].class, BigDecimal[].class, BigDecimal[].class, Boolean[].class);
            GetContractAmountsResult result = (GetContractAmountsResult)getContractAmountMethod.invoke(null, contractPkg.refOutermostPackage(), calculationRule, contract, salesContractAmounts.lineItemNumbers.toArray(new Integer[salesContractAmounts.lineItemNumbers.size()]), salesContractAmounts.positionBaseAmounts.toArray(new BigDecimal[salesContractAmounts.positionBaseAmounts.size()]), salesContractAmounts.positionDiscountAmounts.toArray(new BigDecimal[salesContractAmounts.positionDiscountAmounts.size()]), salesContractAmounts.positionTaxAmounts.toArray(new BigDecimal[salesContractAmounts.positionTaxAmounts.size()]), salesContractAmounts.positionAmounts.toArray(new BigDecimal[salesContractAmounts.positionAmounts.size()]), salesContractAmounts.salesCommissions.toArray(new BigDecimal[salesContractAmounts.salesCommissions.size()]), salesContractAmounts.salesCommissionIsPercentages.toArray(new Boolean[salesContractAmounts.salesCommissionIsPercentages.size()]));
            return result;
        }
        catch (NoSuchMethodException e) {
            return contractPkg.createGetContractAmountsResult((short)1, "getContractAmounts does not define a method with the following signature:\n//<pre>\npublic static org.opencrx.kernel.contract1.jmi1.GetContractAmountsResult getContractAmounts(\n    org.openmdx.base.accessor.jmi.cci.RefPackage_1_0 rootPkg,\n    org.opencrx.kernel.contract1.jmi1.CalculationRule calculationRule,\n    org.opencrx.kernel.contract1.jmi1.SalesContract contract,\n    Integer[] lineItemNumbers,\n    java.math.BigDecimal[] positionBaseAmounts,\n    java.math.BigDecimal[] positionDiscountAmounts,\n    java.math.BigDecimal[] positionTaxAmounts,\n    java.math.BigDecimal[] positionAmounts,\n    java.math.BigDecimal[] salesCommissions,\n    Boolean[] salesCommissionIsPercentages\n) {\n    return org.opencrx.kernel.backend.Contracts.getContractAmounts(\n        rootPkg,\n        calculationRule,\n        contract,\n        lineItemNumbers,\n        positionBaseAmounts,\n        positionDiscountAmounts,\n        positionTaxAmounts,\n        positionAmounts,\n        salesCommissions,\n        salesCommissionIsPercentages\n    );\n}//</pre>", null, null, null, null, null, null);
        }
        catch (InvocationTargetException e) {
            return contractPkg.createGetContractAmountsResult((short)1, "Can not invoke getContractAmounts:\n" + e.getTargetException().getMessage(), null, null, null, null, null, null);
        }
        catch (IllegalAccessException e) {
            return contractPkg.createGetContractAmountsResult((short)1, "Illegal access when invoking getContractAmounts:\n" + e.getMessage(), null, null, null, null, null, null);
        }
        catch (Exception e) {
            return contractPkg.createGetContractAmountsResult((short)1, "Error parsing getContractAmountsScript:\n" + e.getMessage(), null, null, null, null, null, null);
        }
    }

    public BigDecimal[] calculateAmounts(SalesContractPosition position) throws ServiceException {
        CalculationRule calculationRule;
        BigDecimal baseAmount = null;
        BigDecimal discountAmount = null;
        BigDecimal amount = null;
        BigDecimal taxAmount = null;
        BigDecimal pricePerUnit = position.getPricePerUnit() == null ? BigDecimal.ZERO : position.getPricePerUnit();
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)position);
        String providerName = position.refGetPath().getSegment(2).toString();
        String segmentName = position.refGetPath().getSegment(4).toString();
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = this.getContractSegment(pm, providerName, segmentName);
        SalesContract contract = (SalesContract)pm.getObjectById((Object)position.refGetPath().getParent().getParent());
        BigDecimal minMaxAdjustedQuantity = this.getMinMaxAdjustedQuantity(position);
        CalculationRule calculationRule2 = calculationRule = position.getCalcRule() == null ? contract.getCalcRule() : position.getCalcRule();
        if (calculationRule == null) {
            calculationRule = this.getDefaultCalculationRule(contractSegment);
        }
        if (calculationRule != null) {
            GetPositionAmountsResult result = this.getPositionAmounts(calculationRule, position, null, null, null, null, null, null, null);
            if (result.getStatusCode() != 0) {
                throw new ServiceException("DefaultDomain", -19, "Unable to calculate position amounts", new BasicException.Parameter[]{new BasicException.Parameter("result", (Object)result)});
            }
            baseAmount = result.getBaseAmount();
            discountAmount = result.getDiscountAmount();
            taxAmount = result.getTaxAmount();
            amount = result.getAmount();
        } else {
            BigDecimal uomScaleFactor = this.getUomScaleFactor(position);
            BigDecimal salesTaxRate = this.getSalesTaxRate(position);
            baseAmount = minMaxAdjustedQuantity.multiply(pricePerUnit.multiply(uomScaleFactor));
            Boolean discountIsPercentage = position.isDiscountIsPercentage() == null ? Boolean.FALSE : position.isDiscountIsPercentage();
            BigDecimal discount = position.getDiscount() == null ? BigDecimal.ZERO : position.getDiscount();
            discountAmount = discountIsPercentage != false ? baseAmount.multiply(discount.divide(HUNDRED, RoundingMode.UP)) : minMaxAdjustedQuantity.multiply(discount.multiply(uomScaleFactor));
            taxAmount = baseAmount.subtract(discountAmount).multiply(salesTaxRate.divide(HUNDRED, RoundingMode.UP));
            amount = baseAmount.subtract(discountAmount).add(taxAmount);
        }
        return new BigDecimal[]{baseAmount, discountAmount, amount, taxAmount};
    }

    public BigDecimal[] calculateQuantities(SalesContractPosition position) {
        BigDecimal minMaxAdjustedQuantity = this.getMinMaxAdjustedQuantity(position);
        ContractPositionContainsDeliveryInformation.DeliveryInformation deliveryInformations = position.getDeliveryInformation();
        BigDecimal quantityShipped = BigDecimal.ZERO;
        Iterator iterator = deliveryInformations.iterator();
        while (iterator.hasNext()) {
            DeliveryInformation deliveryInformation = (DeliveryInformation)iterator.next();
            if (deliveryInformation.getQuantityShipped() == null) continue;
            quantityShipped = quantityShipped.add(deliveryInformation.getQuantityShipped());
        }
        return new BigDecimal[]{quantityShipped, minMaxAdjustedQuantity.subtract(quantityShipped)};
    }

    public String[] calculateUomDescriptions(SalesContractPosition position) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)position);
        AbstractContract contract = (AbstractContract)pm.getObjectById((Object)position.refGetPath().getParent().getParent());
        short contractLanguage = contract.getContractLanguage();
        String description = "N/A";
        String detailedDescription = "N/A";
        if (position.getUom() != null) {
            try {
                description = position.getUom().getDescription();
                detailedDescription = position.getUom().getDetailedDescription();
                Description additionalDescription = this.getAdditionalDescription(position.getUom(), contractLanguage);
                if (additionalDescription != null) {
                    description = additionalDescription.getDescription();
                    detailedDescription = additionalDescription.getDetailedDescription();
                }
            }
            catch (Exception e) {
                new ServiceException(e).log();
                description = "#ERR";
                detailedDescription = "#ERR";
            }
        }
        return new String[]{description, detailedDescription};
    }

    public String[] calculatePriceUomDescriptions(SalesContractPosition position) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)position);
        AbstractContract contract = (AbstractContract)pm.getObjectById((Object)position.refGetPath().getParent().getParent());
        short contractLanguage = contract.getContractLanguage();
        String description = "N/A";
        String detailedDescription = "N/A";
        if (position.getPriceUom() != null) {
            try {
                description = position.getPriceUom().getDescription();
                detailedDescription = position.getPriceUom().getDetailedDescription();
                Description additionalDescription = this.getAdditionalDescription(position.getPriceUom(), contractLanguage);
                if (additionalDescription != null) {
                    description = additionalDescription.getDescription();
                    detailedDescription = additionalDescription.getDetailedDescription();
                }
            }
            catch (Exception e) {
                new ServiceException(e).log();
                description = "#ERR";
                detailedDescription = "#ERR";
            }
        }
        return new String[]{description, detailedDescription};
    }

    public String[] calculateProductDescriptions(SalesContractPosition position) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)position);
        AbstractContract contract = (AbstractContract)pm.getObjectById((Object)position.refGetPath().getParent().getParent());
        short contractLanguage = contract.getContractLanguage();
        String description = "N/A";
        String detailedDescription = "N/A";
        if (position instanceof ConfiguredProduct && ((ConfiguredProduct)((Object)position)).getProduct() != null) {
            try {
                Product product = ((ConfiguredProduct)((Object)position)).getProduct();
                description = product.getDescription();
                detailedDescription = product.getDetailedDescription();
                Description additionalDescription = this.getAdditionalDescription((DescriptionContainer)((Object)product), contractLanguage);
                if (additionalDescription != null) {
                    description = additionalDescription.getDescription();
                    detailedDescription = additionalDescription.getDetailedDescription();
                }
            }
            catch (Exception e) {
                new ServiceException(e).log();
                description = "#ERR";
                detailedDescription = "#ERR";
            }
        }
        return new String[]{description, detailedDescription};
    }

    public String[] calculateSalesTaxTypeDescriptions(SalesContractPosition position) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)position);
        AbstractContract contract = (AbstractContract)pm.getObjectById((Object)position.refGetPath().getParent().getParent());
        short contractLanguage = contract.getContractLanguage();
        String description = "N/A";
        String detailedDescription = "N/A";
        if (position.getSalesTaxType() != null) {
            try {
                description = position.getSalesTaxType().getDescription();
                detailedDescription = position.getSalesTaxType().getDetailedDescription();
                Description additionalDescription = this.getAdditionalDescription(position.getSalesTaxType(), contractLanguage);
                if (additionalDescription != null) {
                    description = additionalDescription.getDescription();
                    detailedDescription = additionalDescription.getDetailedDescription();
                }
            }
            catch (Exception e) {
                new ServiceException(e).log();
                description = "#ERR";
                detailedDescription = "#ERR";
            }
        }
        return new String[]{description, detailedDescription};
    }

    public void markContractAsDirty(AbstractContract contract) throws ServiceException {
        Utils.touchObject((RefObject)contract);
    }

    public List<SalesContractPosition> getSalesContractPositions(SalesContract contract) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contract);
        ArrayList<SalesContractPosition> positions = new ArrayList<SalesContractPosition>();
        if (contract instanceof Opportunity) {
            AbstractOpportunityPositionQuery query = (AbstractOpportunityPositionQuery)pm.newQuery(AbstractOpportunityPosition.class);
            query.orderByLineItemNumber().ascending();
            List p = ((Opportunity)contract).getPosition(query);
            positions.addAll(p);
        } else if (contract instanceof Quote) {
            AbstractQuotePositionQuery query = (AbstractQuotePositionQuery)pm.newQuery(AbstractQuotePosition.class);
            query.orderByLineItemNumber().ascending();
            List p = ((Quote)contract).getPosition(query);
            positions.addAll(p);
        } else if (contract instanceof SalesOrder) {
            AbstractSalesOrderPositionQuery query = (AbstractSalesOrderPositionQuery)pm.newQuery(AbstractSalesOrderPosition.class);
            query.orderByLineItemNumber().ascending();
            List p = ((SalesOrder)contract).getPosition(query);
            positions.addAll(p);
        } else if (contract instanceof Invoice) {
            AbstractInvoicePositionQuery query = (AbstractInvoicePositionQuery)pm.newQuery(AbstractInvoicePosition.class);
            query.orderByLineItemNumber().ascending();
            List p = ((Invoice)contract).getPosition(query);
            positions.addAll(p);
        }
        return positions;
    }

    public SalesContractAmounts calculateAmounts(SalesContract contract) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contract);
        String providerName = contract.refGetPath().getSegment(2).toString();
        String segmentName = contract.refGetPath().getSegment(4).toString();
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = this.getContractSegment(pm, providerName, segmentName);
        SalesContractAmounts salesContractAmounts = new SalesContractAmounts();
        if (contract instanceof Lead) {
            Lead lead = (Lead)contract;
            salesContractAmounts.totalBaseAmount = lead.getEstimatedValue();
            salesContractAmounts.totalBaseAmount = salesContractAmounts.totalBaseAmount == null ? BigDecimal.ZERO : salesContractAmounts.totalBaseAmount;
            salesContractAmounts.totalDiscountAmount = BigDecimal.ZERO;
            salesContractAmounts.totalTaxAmount = BigDecimal.ZERO;
            salesContractAmounts.totalAmount = salesContractAmounts.totalBaseAmount;
            salesContractAmounts.totalAmountIncludingTax = salesContractAmounts.totalBaseAmount;
            salesContractAmounts.totalSalesCommission = BigDecimal.ZERO;
        } else {
            CalculationRule calculationRule;
            List<SalesContractPosition> positions = this.getSalesContractPositions(contract);
            for (SalesContractPosition position : positions) {
                BigDecimal[] amounts = this.calculateAmounts(position);
                salesContractAmounts.positions.add(position);
                salesContractAmounts.lineItemNumbers.add((int)position.getLineItemNumber());
                salesContractAmounts.positionBaseAmounts.add(amounts[0]);
                salesContractAmounts.positionDiscountAmounts.add(amounts[1]);
                salesContractAmounts.positionAmounts.add(amounts[2]);
                salesContractAmounts.positionTaxAmounts.add(amounts[3]);
                salesContractAmounts.salesCommissions.add(position.getSalesCommission() == null ? BigDecimal.ZERO : position.getSalesCommission());
                salesContractAmounts.salesCommissionIsPercentages.add(position.isDiscountIsPercentage() == null ? Boolean.FALSE : position.isSalesCommissionIsPercentage());
            }
            CalculationRule calculationRule2 = calculationRule = contract.getCalcRule() == null ? this.getDefaultCalculationRule(contractSegment) : contract.getCalcRule();
            if (calculationRule != null) {
                GetContractAmountsResult result = this.getContractAmounts(calculationRule, contract, salesContractAmounts);
                if (result.getStatusCode() != 0) {
                    throw new ServiceException("DefaultDomain", -19, "Unable to calculate contract amounts", new BasicException.Parameter[]{new BasicException.Parameter("result", (Object)result)});
                }
                salesContractAmounts.totalBaseAmount = result.getTotalBaseAmount();
                salesContractAmounts.totalDiscountAmount = result.getTotalDiscountAmount();
                salesContractAmounts.totalTaxAmount = result.getTotalTaxAmount();
                salesContractAmounts.totalAmount = result.getTotalAmount();
                salesContractAmounts.totalAmountIncludingTax = result.getTotalAmountIncludingTax();
                salesContractAmounts.totalSalesCommission = result.getTotalSalesCommission();
            } else {
                salesContractAmounts.totalBaseAmount = BigDecimal.ZERO;
                salesContractAmounts.totalDiscountAmount = BigDecimal.ZERO;
                salesContractAmounts.totalTaxAmount = BigDecimal.ZERO;
                salesContractAmounts.totalSalesCommission = BigDecimal.ZERO;
                for (int i = 0; i < salesContractAmounts.positionBaseAmounts.size(); ++i) {
                    salesContractAmounts.totalBaseAmount = salesContractAmounts.totalBaseAmount.add(salesContractAmounts.positionBaseAmounts.get(i));
                    BigDecimal discountAmount = salesContractAmounts.positionDiscountAmounts.get(i);
                    salesContractAmounts.totalDiscountAmount = salesContractAmounts.totalDiscountAmount.add(discountAmount);
                    salesContractAmounts.totalTaxAmount = salesContractAmounts.totalTaxAmount.add(salesContractAmounts.positionTaxAmounts.get(i));
                    BigDecimal salesCommission = salesContractAmounts.salesCommissions.get(i) != null ? salesContractAmounts.salesCommissions.get(i) : BigDecimal.ZERO;
                    BigDecimal baseAmount = salesContractAmounts.positionBaseAmounts.get(i);
                    salesContractAmounts.totalSalesCommission = salesContractAmounts.totalSalesCommission.add(salesContractAmounts.salesCommissionIsPercentages.get(i) != null && Boolean.TRUE.equals(salesContractAmounts.salesCommissionIsPercentages.get(i)) ? baseAmount.subtract(discountAmount).multiply(salesCommission.divide(HUNDRED, RoundingMode.UP)) : salesCommission);
                }
                salesContractAmounts.totalAmount = salesContractAmounts.totalBaseAmount.subtract(salesContractAmounts.totalDiscountAmount);
                salesContractAmounts.totalAmountIncludingTax = salesContractAmounts.totalAmount.add(salesContractAmounts.totalTaxAmount);
            }
        }
        return salesContractAmounts;
    }

    protected void updateContract(AbstractContract contract) throws ServiceException {
        if (JDOHelper.isNew((Object)contract)) {
            Base.getInstance().assignToMe(contract, false, false);
        }
    }

    protected void updateSalesContract(SalesContract contract) throws ServiceException {
        if (JDOHelper.isNew((Object)contract)) {
            contract.setPricingState((short)0);
        }
        if (!Boolean.TRUE.equals(contract.isNoAutoRecalc())) {
            this.recalcSalesContract(contract);
        }
    }

    public SalesContractAmounts recalcSalesContract(SalesContract contract) throws ServiceException {
        SalesContractAmounts salesContractAmounts = Contracts.getInstance().calculateAmounts(contract);
        if (!Utils.areEqual(contract.getTotalBaseAmount(), salesContractAmounts.totalBaseAmount)) {
            contract.setTotalBaseAmount(salesContractAmounts.totalBaseAmount);
        }
        if (!Utils.areEqual(contract.getTotalDiscountAmount(), salesContractAmounts.totalDiscountAmount)) {
            contract.setTotalDiscountAmount(salesContractAmounts.totalDiscountAmount);
        }
        if (!Utils.areEqual(contract.getTotalAmount(), salesContractAmounts.totalAmount)) {
            contract.setTotalAmount(salesContractAmounts.totalAmount);
        }
        if (!Utils.areEqual(contract.getTotalTaxAmount(), salesContractAmounts.totalTaxAmount)) {
            contract.setTotalTaxAmount(salesContractAmounts.totalTaxAmount);
        }
        if (!Utils.areEqual(contract.getTotalAmountIncludingTax(), salesContractAmounts.totalAmountIncludingTax)) {
            contract.setTotalAmountIncludingTax(salesContractAmounts.totalAmountIncludingTax);
        }
        if (!Utils.areEqual(contract.getTotalSalesCommission(), salesContractAmounts.totalSalesCommission)) {
            contract.setTotalSalesCommission(salesContractAmounts.totalSalesCommission);
        }
        return salesContractAmounts;
    }

    public Invoice createInvoice(SalesOrder salesOrder) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)salesOrder);
        String providerName = salesOrder.refGetPath().getSegment(2).toString();
        String segmentName = salesOrder.refGetPath().getSegment(4).toString();
        HashMap<String, Marshaller> objectMarshallers = new HashMap<String, Marshaller>();
        objectMarshallers.put("org:opencrx:kernel:contract1:SalesOrder", new Marshaller(){

            public Object marshal(Object s) throws ServiceException {
                SalesOrder salesOrder = (SalesOrder)s;
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)salesOrder);
                Invoice invoice = (Invoice)pm.newInstance(Invoice.class);
                Contracts.getInstance().copySalesContract(salesOrder, invoice);
                return invoice;
            }

            public Object unmarshal(Object s) {
                throw new UnsupportedOperationException();
            }
        });
        objectMarshallers.put("org:opencrx:kernel:contract1:SalesOrderPosition", new Marshaller(){

            public Object marshal(Object s) throws ServiceException {
                SalesOrderPosition salesOrderPosition = (SalesOrderPosition)s;
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)salesOrderPosition);
                InvoicePosition invoicePosition = (InvoicePosition)pm.newInstance(InvoicePosition.class);
                Contracts.getInstance().copySalesContractPosition(salesOrderPosition, invoicePosition);
                return invoicePosition;
            }

            public Object unmarshal(Object s) {
                throw new UnsupportedOperationException();
            }
        });
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = this.getContractSegment(pm, providerName, segmentName);
        Invoice invoice = (Invoice)Cloneable.getInstance().cloneObject(salesOrder, contractSegment, "invoice", objectMarshallers, null, null, null);
        invoice.setOrigin(salesOrder);
        if (invoice.getSalesRep() == null) {
            Base.getInstance().assignToMe(invoice, true, false);
        }
        return invoice;
    }

    public SalesOrder createSalesOrder(Quote quote) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)quote);
        String providerName = quote.refGetPath().getSegment(2).toString();
        String segmentName = quote.refGetPath().getSegment(4).toString();
        HashMap<String, Marshaller> objectMarshallers = new HashMap<String, Marshaller>();
        objectMarshallers.put("org:opencrx:kernel:contract1:Quote", new Marshaller(){

            public Object marshal(Object s) throws ServiceException {
                Quote quote = (Quote)s;
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)quote);
                SalesOrder salesOrder = (SalesOrder)pm.newInstance(SalesOrder.class);
                Contracts.getInstance().copySalesContract(quote, salesOrder);
                return salesOrder;
            }

            public Object unmarshal(Object s) {
                throw new UnsupportedOperationException();
            }
        });
        objectMarshallers.put("org:opencrx:kernel:contract1:QuotePosition", new Marshaller(){

            public Object marshal(Object s) throws ServiceException {
                QuotePosition quotePosition = (QuotePosition)s;
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)quotePosition);
                SalesOrderPosition salesOrderPosition = (SalesOrderPosition)pm.newInstance(SalesOrderPosition.class);
                Contracts.getInstance().copySalesContractPosition(quotePosition, salesOrderPosition);
                return salesOrderPosition;
            }

            public Object unmarshal(Object s) {
                throw new UnsupportedOperationException();
            }
        });
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = this.getContractSegment(pm, providerName, segmentName);
        SalesOrder salesOrder = (SalesOrder)Cloneable.getInstance().cloneObject(quote, contractSegment, "salesOrder", objectMarshallers, null, null, null);
        salesOrder.setOrigin(quote);
        if (salesOrder.getSalesRep() == null) {
            Base.getInstance().assignToMe(salesOrder, true, false);
        }
        return salesOrder;
    }

    public Quote createQuote(Opportunity opportunity) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)opportunity);
        String providerName = opportunity.refGetPath().getSegment(2).toString();
        String segmentName = opportunity.refGetPath().getSegment(4).toString();
        HashMap<String, Marshaller> objectMarshallers = new HashMap<String, Marshaller>();
        objectMarshallers.put("org:opencrx:kernel:contract1:Opportunity", new Marshaller(){

            public Object marshal(Object s) throws ServiceException {
                Opportunity opportunity = (Opportunity)s;
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)opportunity);
                Quote quote = (Quote)pm.newInstance(Quote.class);
                Contracts.getInstance().copySalesContract(opportunity, quote);
                return quote;
            }

            public Object unmarshal(Object s) {
                throw new UnsupportedOperationException();
            }
        });
        objectMarshallers.put("org:opencrx:kernel:contract1:OpportunityPosition", new Marshaller(){

            public Object marshal(Object s) throws ServiceException {
                OpportunityPosition opportunityPosition = (OpportunityPosition)s;
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)opportunityPosition);
                QuotePosition quotePosition = (QuotePosition)pm.newInstance(QuotePosition.class);
                Contracts.getInstance().copySalesContractPosition(opportunityPosition, quotePosition);
                return quotePosition;
            }

            public Object unmarshal(Object s) {
                throw new UnsupportedOperationException();
            }
        });
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = this.getContractSegment(pm, providerName, segmentName);
        Quote quote = (Quote)Cloneable.getInstance().cloneObject(opportunity, contractSegment, "quote", objectMarshallers, null, null, null);
        quote.setOrigin(opportunity);
        if (quote.getSalesRep() == null) {
            Base.getInstance().assignToMe(quote, true, false);
        }
        return quote;
    }

    public Opportunity createOpportunity(Lead lead) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)lead);
        String providerName = lead.refGetPath().getSegment(2).toString();
        String segmentName = lead.refGetPath().getSegment(4).toString();
        HashMap<String, Marshaller> objectMarshallers = new HashMap<String, Marshaller>();
        objectMarshallers.put("org:opencrx:kernel:contract1:Lead", new Marshaller(){

            public Object marshal(Object s) throws ServiceException {
                Lead lead = (Lead)s;
                PersistenceManager pm = JDOHelper.getPersistenceManager((Object)lead);
                Opportunity opportunity = (Opportunity)pm.newInstance(Opportunity.class);
                Contracts.getInstance().copySalesContract(lead, opportunity);
                return opportunity;
            }

            public Object unmarshal(Object s) {
                throw new UnsupportedOperationException();
            }
        });
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = this.getContractSegment(pm, providerName, segmentName);
        Opportunity opportunity = (Opportunity)Cloneable.getInstance().cloneObject(lead, contractSegment, "opportunity", objectMarshallers, null, null, null);
        opportunity.setOrigin(lead);
        if (opportunity.getSalesRep() == null) {
            Base.getInstance().assignToMe(opportunity, true, false);
        }
        return opportunity;
    }

    public void repriceSalesContractPosition(SalesContractPosition position, SalesContract contract, org.opencrx.kernel.product1.jmi1.Product product) throws ServiceException {
        DiscountOrigin discountOrigin;
        Date pricingDate;
        if (contract == null) {
            return;
        }
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contract);
        if (position == null) {
            return;
        }
        if (product == null) {
            return;
        }
        PricingRule pricingRule = position.getPricingRule();
        if (pricingRule == null) {
            return;
        }
        BigDecimal quantity = position.getQuantity();
        if (quantity == null) {
            return;
        }
        Date date = position.getPricingDate() != null ? position.getPricingDate() : (contract.getPricingDate() != null ? contract.getPricingDate() : (pricingDate = contract.getActiveOn() != null ? contract.getActiveOn() : new Date()));
        Uom priceUom = position.getPriceUom() != null ? position.getPriceUom() : (position.getUom() != null ? position.getUom() : null);
        short contractPositionState = position.getContractPositionState();
        GetPriceLevelResult result = Products.getInstance().getPriceLevel(pricingRule, contract, position, product, priceUom, quantity, contractPositionState, pricingDate, null);
        if (result.getStatusCode() != 0) {
            throw new ServiceException("DefaultDomain", -19, "Unable to get price level", new BasicException.Parameter[]{new BasicException.Parameter("code", result.getStatusCode()), new BasicException.Parameter("message", (Object)result.getStatusMessage())});
        }
        AbstractPriceLevel priceLevel = result.getPriceLevel() == null ? null : (AbstractPriceLevel)pm.getObjectById((Object)result.getPriceLevel().refGetPath());
        ProductBasePrice basePrice = result.getBasePrice() == null ? null : (ProductBasePrice)pm.getObjectById((Object)result.getBasePrice().refGetPath());
        BigDecimal discount = result.getDiscount();
        Boolean discountIsPercentage = result.isDiscountIsPercentage();
        DiscountOrigin discountOrigin2 = discountOrigin = result.getDiscountOrigin() == null ? null : (DiscountOrigin)pm.getObjectById((Object)result.getDiscountOrigin().refGetPath());
        if (!Boolean.TRUE.equals(position.isManualPricing())) {
            if (!Utils.areEqual(priceLevel, position.getPriceLevel())) {
                position.setPriceLevel(priceLevel);
            }
            if (!Utils.areEqual(basePrice, position.getListPrice())) {
                position.setListPrice(basePrice);
            }
            if (basePrice != null) {
                if (!Utils.areEqual(basePrice.getPrice(), position.getPricePerUnit())) {
                    position.setPricePerUnit(basePrice.getPrice());
                }
                if (!Utils.areEqual(discount, position.getDiscount())) {
                    position.setDiscount(discount);
                }
                if (!Utils.areEqual(discountIsPercentage, position.isDiscountIsPercentage())) {
                    position.setDiscountIsPercentage(discountIsPercentage);
                }
                if (!Utils.areEqual(discountOrigin, position.getDiscountOrigin())) {
                    position.setDiscountOrigin(discountOrigin);
                }
                if (!Utils.areEqual(basePrice.getUom(), position.getPriceUom())) {
                    position.setPriceUom(basePrice.getUom());
                }
            }
        }
        if (!Utils.areEqual((short)20, position.getPricingState())) {
            position.setPricingState((short)20);
        }
    }

    protected boolean isEnabledContractPositionModifications() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSalesContractPosition(SalesContract contract, SalesContractPosition position, org.opencrx.kernel.product1.jmi1.Product product, boolean reprice) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contract);
        if (JDOHelper.isNew((Object)position)) {
            PricingRule pricingRule;
            if (position.getUom() == null) {
                position.setUom(product.getDefaultUom());
            }
            if (position.getSalesTaxType() == null) {
                position.setSalesTaxType(product.getSalesTaxType());
            }
            PricingRule pricingRule2 = pricingRule = position.getPricingRule() == null ? contract.getPricingRule() : position.getPricingRule();
            if (pricingRule == null) {
                Segment productSegment = Products.getInstance().getProductSegment(pm, position.refGetPath().getSegment(2).toString(), position.refGetPath().getSegment(4).toString());
                PricingRuleQuery pricingRuleQuery = (PricingRuleQuery)pm.newQuery(PricingRule.class);
                pricingRuleQuery.thereExistsIsDefault().isTrue();
                List pricingRules = productSegment.getPricingRule(pricingRuleQuery);
                if (!pricingRules.isEmpty()) {
                    pricingRule = (PricingRule)pricingRules.iterator().next();
                }
            }
            position.setPricingRule(pricingRule);
            if (this.isEnabledContractPositionModifications()) {
                PositionCreation positionCreation = (PositionCreation)pm.newInstance(PositionCreation.class);
                positionCreation.setInvolved(position);
                contract.addPositionModification(this.getUidAsString(), positionCreation);
            }
        } else if (this.isEnabledContractPositionModifications()) {
            try (PersistenceManager pmOld = null;){
                pmOld = pm.getPersistenceManagerFactory().getPersistenceManager("admin-Root", null);
                BigDecimal quantityOld = ((SalesContractPosition)pmOld.getObjectById((Object)position.refGetPath())).getQuantity();
                BigDecimal quantityNew = position.getQuantity();
                if (!Utils.areEqual(quantityOld, quantityNew)) {
                    QuantityModification quantityModification = (QuantityModification)pm.newInstance(QuantityModification.class);
                    quantityModification.setInvolved(position);
                    quantityModification.setQuantity(quantityOld);
                    contract.addPositionModification(this.getUidAsString(), quantityModification);
                }
            }
        }
        if (reprice) {
            this.repriceSalesContractPosition(position, contract, product);
        }
    }

    public org.opencrx.kernel.product1.jmi1.SalesTaxType getSalesTaxType(SalesContract contract, SalesContractPosition position, org.opencrx.kernel.product1.jmi1.Product product) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contract);
        String providerName = contract.refGetPath().getSegment(2).toString();
        String segmentName = contract.refGetPath().getSegment(4).toString();
        Segment productSegment = Products.getInstance().getProductSegment(pm, providerName, segmentName);
        SalesTaxType salesTaxType = null;
        SalesTransactionType salesTransactionType = position.getSalesTransactionType();
        Uom priceUom = position.getPriceUom();
        if (product.getSalesTaxType() != null) {
            salesTaxType = product.getSalesTaxType();
        } else {
            List salesTaxTypeAssignments;
            SalesTaxTypeAssignmentQuery salesTaxTypeAssignmentQuery = (SalesTaxTypeAssignmentQuery)pm.newQuery(SalesTaxTypeAssignment.class);
            salesTaxTypeAssignmentQuery.forAllDisabled().isFalse();
            salesTaxTypeAssignmentQuery.thereExistsSalesTaxType().forAllDisabled().isFalse();
            if (priceUom != null) {
                salesTaxTypeAssignmentQuery.thereExistsUom().equalTo(priceUom);
            }
            if (contract.getSalesTaxTypeGroup() != null) {
                salesTaxTypeAssignmentQuery.thereExistsSalesTaxType().thereExistsSalesTaxTypeGroup().equalTo(contract.getSalesTaxTypeGroup());
            }
            if (salesTransactionType != null) {
                salesTaxTypeAssignmentQuery.thereExistsSalesTaxType().thereExistsSalesTransactionType().equalTo(salesTransactionType);
            }
            if (!(salesTaxTypeAssignments = product.getSalesTaxTypeAssignment(salesTaxTypeAssignmentQuery)).isEmpty()) {
                salesTaxType = ((SalesTaxTypeAssignment)salesTaxTypeAssignments.iterator().next()).getSalesTaxType();
            } else {
                List salesTaxTypes;
                SalesTaxTypeQuery salesTaxTypeQuery = (SalesTaxTypeQuery)pm.newQuery(org.opencrx.kernel.product1.jmi1.SalesTaxType.class);
                salesTaxTypeQuery.forAllDisabled().isFalse();
                salesTaxTypeQuery.orderByValidFrom().descending();
                if (contract.getSalesTaxTypeGroup() != null) {
                    salesTaxTypeQuery.thereExistsSalesTaxTypeGroup().equalTo(contract.getSalesTaxTypeGroup());
                }
                if (salesTransactionType != null) {
                    salesTaxTypeQuery.thereExistsSalesTransactionType().equalTo(salesTransactionType);
                }
                if (!(salesTaxTypes = productSegment.getSalesTaxType(salesTaxTypeQuery)).isEmpty()) {
                    salesTaxType = (org.opencrx.kernel.product1.jmi1.SalesTaxType)salesTaxTypes.iterator().next();
                }
            }
        }
        if (salesTaxType != null) {
            position.setSalesTaxType(salesTaxType);
        }
        return salesTaxType;
    }

    public SalesContractPosition createSalesContractPosition(SalesContract contract, Boolean isIgnoreProductConfiguration, String name, BigDecimal quantity, Date pricingDate, org.opencrx.kernel.product1.jmi1.Product product, Uom uom, Uom priceUom, SalesTransactionType salesTransactionType, PricingRule pricingRule, AbstractPriceLevel priceLevel) throws ServiceException {
        List positions;
        ConfiguredProductQuery positionQuery;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contract);
        SalesContractPosition position = null;
        long maxLineItemNumber = 0L;
        if (contract instanceof Opportunity) {
            positionQuery = (AbstractOpportunityPositionQuery)pm.newQuery(AbstractOpportunityPosition.class);
            positionQuery.orderByLineItemNumber().descending();
            positions = ((Opportunity)contract).getPosition((AbstractOpportunityPositionQuery)positionQuery);
            if (!positions.isEmpty()) {
                maxLineItemNumber = ((AbstractOpportunityPosition)positions.iterator().next()).getLineItemNumber();
            }
            position = (SalesContractPosition)pm.newInstance(OpportunityPosition.class);
            ((Opportunity)contract).addPosition(this.getUidAsString(), (OpportunityPosition)position);
        } else if (contract instanceof Quote) {
            positionQuery = (AbstractQuotePositionQuery)pm.newQuery(AbstractQuotePosition.class);
            positionQuery.orderByLineItemNumber().descending();
            positions = ((Quote)contract).getPosition((AbstractQuotePositionQuery)positionQuery);
            if (!positions.isEmpty()) {
                maxLineItemNumber = ((AbstractQuotePosition)positions.iterator().next()).getLineItemNumber();
            }
            position = (SalesContractPosition)pm.newInstance(QuotePosition.class);
            ((Quote)contract).addPosition(this.getUidAsString(), (QuotePosition)position);
        } else if (contract instanceof SalesOrder) {
            positionQuery = (AbstractSalesOrderPositionQuery)pm.newQuery(AbstractSalesOrderPosition.class);
            positionQuery.orderByLineItemNumber().descending();
            positions = ((SalesOrder)contract).getPosition((AbstractSalesOrderPositionQuery)positionQuery);
            if (!positions.isEmpty()) {
                maxLineItemNumber = ((AbstractSalesOrderPosition)positions.iterator().next()).getLineItemNumber();
            }
            position = (SalesContractPosition)pm.newInstance(SalesOrderPosition.class);
            ((SalesOrder)contract).addPosition(this.getUidAsString(), (SalesOrderPosition)position);
        } else if (contract instanceof Invoice) {
            positionQuery = (AbstractInvoicePositionQuery)pm.newQuery(AbstractInvoicePosition.class);
            positionQuery.orderByLineItemNumber().descending();
            positions = ((Invoice)contract).getPosition((AbstractInvoicePositionQuery)positionQuery);
            if (!positions.isEmpty()) {
                maxLineItemNumber = ((AbstractInvoicePosition)positions.iterator().next()).getLineItemNumber();
            }
            position = (SalesContractPosition)pm.newInstance(InvoicePosition.class);
            ((Invoice)contract).addPosition(this.getUidAsString(), (InvoicePosition)position);
        } else {
            return null;
        }
        Long positionNumber = 100000L * (maxLineItemNumber / 100000L + 1L);
        position.setLineItemNumber(positionNumber);
        position.setPositionNumber(positionNumber.toString());
        if (name != null) {
            position.setName(name);
        } else {
            position.setName("Position " + position.getLineItemNumber());
        }
        if (quantity != null) {
            position.setQuantity(quantity);
        } else {
            position.setQuantity(BigDecimal.ONE);
        }
        if (pricingDate != null) {
            position.setPricingDate(pricingDate);
        } else {
            position.setPricingDate(contract.getPricingDate());
        }
        position.setUom(uom);
        if (priceUom != null) {
            position.setPriceUom(priceUom);
        }
        if (salesTransactionType != null) {
            position.setSalesTransactionType(salesTransactionType);
        }
        if (pricingRule != null) {
            position.setPricingRule(pricingRule);
        }
        if (priceLevel != null) {
            position.setPriceLevel(priceLevel);
        }
        position.setCalcRule(contract.getCalcRule());
        if (product != null) {
            org.opencrx.kernel.product1.jmi1.SalesTaxType salesTaxType = this.getSalesTaxType(contract, position, product);
            if (salesTaxType != null) {
                position.setSalesTaxType(salesTaxType);
            }
            this.updateSalesContractPosition(contract, position, product, true);
            if (position instanceof ConfiguredProduct) {
                ((ConfiguredProduct)((Object)position)).setProduct(product);
            }
            if (isIgnoreProductConfiguration == null || !isIgnoreProductConfiguration.booleanValue()) {
                Products.getInstance().cloneProductConfigurationSet(product, position, false, true, (User)(JDOHelper.isNew((Object)contract) ? null : contract.getOwningUser()), JDOHelper.isNew((Object)contract) ? null : contract.getOwningGroup());
            }
            DepotReferenceHolderContainsDepotReference.DepotReference existingDepotReferences = position.getDepotReference();
            ArrayList<Depot> excludeDepotReferences = new ArrayList<Depot>();
            Iterator iterator = existingDepotReferences.iterator();
            while (iterator.hasNext()) {
                DepotReference existingDepotReference = (DepotReference)iterator.next();
                excludeDepotReferences.add(existingDepotReference.getDepot());
            }
            ArrayList depotReferences = new ArrayList(product.getDepotReference());
            if (salesTaxType != null) {
                depotReferences.addAll(salesTaxType.getDepotReference());
            }
            for (DepotReference depotReference : depotReferences) {
                if (excludeDepotReferences.contains(depotReference.getDepot())) continue;
                Cloneable.getInstance().cloneObject(depotReference, position, "depotReference", null, "property", (User)contract.getOwningUser(), contract.getOwningGroup());
            }
        }
        this.markContractAsDirty(contract);
        return position;
    }

    protected void removeSalesContractPosition(SalesContractPosition position, boolean checkForMinPositions, boolean preDelete) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)position);
        SalesContract contract = (SalesContract)pm.getObjectById((Object)position.refGetPath().getParent().getParent());
        if (this.isEnabledContractPositionModifications()) {
            Marshaller positionMarshaller = new Marshaller(){

                public Object marshal(Object s) throws ServiceException {
                    if (s instanceof SalesContractPosition) {
                        SalesContractPosition position = (SalesContractPosition)s;
                        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)position);
                        RemovedPosition removedPosition = (RemovedPosition)pm.newInstance(RemovedPosition.class);
                        Contracts.getInstance().copySalesContractPosition(position, removedPosition);
                        return removedPosition;
                    }
                    return s;
                }

                public Object unmarshal(Object s) {
                    throw new UnsupportedOperationException();
                }
            };
            HashMap<String, Marshaller> objectMarshallers = new HashMap<String, Marshaller>();
            objectMarshallers.put("org:opencrx:kernel:contract1:OpportunityPosition", positionMarshaller);
            objectMarshallers.put("org:opencrx:kernel:contract1:QuotePosition", positionMarshaller);
            objectMarshallers.put("org:opencrx:kernel:contract1:SalesOrderPosition", positionMarshaller);
            objectMarshallers.put("org:opencrx:kernel:contract1:InvoicePosition", positionMarshaller);
            RemovedPosition removedPosition = (RemovedPosition)Cloneable.getInstance().cloneObject(position, contract, "removedPosition", objectMarshallers, null, (User)contract.getOwningUser(), contract.getOwningGroup());
            ContractContainsPositionModification.PositionModification positionModifications = contract.getPositionModification();
            Iterator iterator = positionModifications.iterator();
            while (iterator.hasNext()) {
                PositionModification positionModification = (PositionModification)iterator.next();
                try {
                    if (!positionModification.getInvolved().equals(position)) continue;
                    positionModification.setInvolved(removedPosition);
                }
                catch (Exception exception) {}
            }
            PositionRemoval positionRemoval = (PositionRemoval)pm.newInstance(PositionRemoval.class);
            positionRemoval.setInvolved(removedPosition);
            contract.addPositionModification(this.getUidAsString(), positionRemoval);
        }
        if (!preDelete) {
            position.refDelete();
        }
        this.markContractAsDirty(contract);
    }

    protected void removeContract(AbstractContract contract, boolean preDelete) throws ServiceException {
    }

    public void updatePricingState(SalesContractPosition position, short pricingState) {
        if (JDOHelper.isPersistent((Object)position)) {
            PersistenceManager pm = JDOHelper.getPersistenceManager((Object)position);
            SalesContract contract = (SalesContract)pm.getObjectById((Object)position.refGetPath().getParent().getParent());
            this.updatePricingState(contract, pricingState);
        }
        position.setPricingState(pricingState);
    }

    public void updatePricingState(SalesContract contract, short pricingState) {
        contract.setPricingState(pricingState);
    }

    public void updateContractState(AbstractContract contract, short contractState) {
    }

    protected void updateSalesContractPosition(SalesContractPosition position) throws ServiceException {
        Product product;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)position);
        SalesContract contract = (SalesContract)pm.getObjectById((Object)position.refGetPath().getParent().getParent());
        if (position instanceof ConfiguredProduct && (product = ((ConfiguredProduct)((Object)position)).getProduct()) != null) {
            this.updateSalesContractPosition(contract, position, (org.opencrx.kernel.product1.jmi1.Product)product, false);
        }
        this.markContractAsDirty(contract);
    }

    public short repriceSalesContractPosition(SalesContractPosition position) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)position);
        SalesContract contract = (SalesContract)pm.getObjectById((Object)position.refGetPath().getParent().getParent());
        short pricingState = 0;
        if (position instanceof ConfiguredProduct) {
            Product product = ((ConfiguredProduct)((Object)position)).getProduct();
            if (product != null) {
                this.updateSalesContractPosition(contract, position, (org.opencrx.kernel.product1.jmi1.Product)product, true);
            }
            pricingState = position.getPricingState();
        }
        return pricingState;
    }

    public PreviewRepriceResult previewRepriceSalesContractPosition(SalesContractPosition position, CalculationRule overrideCalculationRule, AbstractPriceLevel overridePriceLevel, AbstractProduct overrideProduct, Uom overridePriceUom, Boolean overrideManualPricing, BigDecimal overridePricePerUnit, BigDecimal overrideQuantity, BigDecimal overrideUomScaleFactor, BigDecimal overrideSalesTaxRate, BigDecimal overrideDiscount, Boolean overrideDiscountIsPercentage, Short overrideDiscountCalculationType, Short overrideContractPositionState, Date overridePricingDate) throws ServiceException {
        Boolean manualPricing;
        Uom priceUom;
        BigDecimal quantity;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)position);
        String providerName = position.refGetPath().getSegment(2).toString();
        String segmentName = position.refGetPath().getSegment(4).toString();
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = this.getContractSegment(pm, providerName, segmentName);
        SalesContract contract = (SalesContract)pm.getObjectById((Object)position.refGetPath().getParent().getParent());
        PricingRule pricingRule = position.getPricingRule();
        AbstractProduct product = overrideProduct != null ? overrideProduct : ((ConfiguredProduct)((Object)position)).getProduct();
        BigDecimal bigDecimal = quantity = overrideQuantity != null ? overrideQuantity : this.getMinMaxAdjustedQuantity(position);
        Uom uom = overridePriceUom != null ? overridePriceUom : (position.getPriceUom() != null ? position.getPriceUom() : (priceUom = position.getUom() != null ? position.getUom() : null));
        Date pricingDate = overridePricingDate != null ? overridePricingDate : (position.getPricingDate() != null ? position.getPricingDate() : (contract.getPricingDate() != null ? contract.getPricingDate() : (contract.getActiveOn() != null ? contract.getActiveOn() : new Date())));
        short contractPositionState = overrideContractPositionState != null ? overrideContractPositionState.shortValue() : position.getContractPositionState();
        GetPriceLevelResult getPriceLevelResult = Products.getInstance().getPriceLevel(pricingRule, contract, position, product, priceUom, quantity, contractPositionState, pricingDate, overridePriceLevel);
        if (getPriceLevelResult.getStatusCode() != 0) {
            return (PreviewRepriceResult)Structures.create(PreviewRepriceResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)PreviewRepriceResult.Member.statusCode, (Object)getPriceLevelResult.getStatusCode()), Datatypes.member((Enum)PreviewRepriceResult.Member.statusMessage, (Object)getPriceLevelResult.getStatusMessage())});
        }
        if (getPriceLevelResult.getBasePrice() == null) {
            return (PreviewRepriceResult)Structures.create(PreviewRepriceResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)PreviewRepriceResult.Member.statusCode, (Object)-1), Datatypes.member((Enum)PreviewRepriceResult.Member.statusMessage, (Object)"getPriceLevelResult::basePrice is null")});
        }
        CalculationRule calculationRule = overrideCalculationRule != null ? overrideCalculationRule : this.getDefaultCalculationRule(contractSegment);
        BigDecimal uomScaleFactor = overrideUomScaleFactor != null ? overrideUomScaleFactor : this.getUomScaleFactor(position);
        BigDecimal salesTaxRate = overrideSalesTaxRate != null ? overrideSalesTaxRate : this.getSalesTaxRate(position);
        BigDecimal discount = null;
        Boolean discountIsPercentage = null;
        if (overrideDiscount != null) {
            discount = overrideDiscount;
            discountIsPercentage = overrideDiscountIsPercentage;
        } else {
            discount = getPriceLevelResult.getDiscount();
            discountIsPercentage = getPriceLevelResult.isDiscountIsPercentage();
        }
        Short discountCalculationType = overrideDiscountCalculationType != null ? overrideDiscountCalculationType : position.getDiscountCalculationType();
        Boolean bl = manualPricing = overrideManualPricing != null ? overrideManualPricing : position.isManualPricing();
        BigDecimal pricePerUnit = overridePricePerUnit != null ? overridePricePerUnit : (Boolean.TRUE.equals(manualPricing) ? position.getPricePerUnit() : getPriceLevelResult.getBasePrice().getPrice());
        GetPositionAmountsResult getPositionAmountsResult = this.getPositionAmounts(calculationRule, position, pricePerUnit, quantity, uomScaleFactor, discount, discountIsPercentage, discountCalculationType, salesTaxRate);
        if (getPositionAmountsResult.getStatusCode() != 0) {
            return (PreviewRepriceResult)Structures.create(PreviewRepriceResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)PreviewRepriceResult.Member.statusCode, (Object)getPositionAmountsResult.getStatusCode()), Datatypes.member((Enum)PreviewRepriceResult.Member.statusMessage, (Object)getPositionAmountsResult.getStatusMessage())});
        }
        return (PreviewRepriceResult)Structures.create(PreviewRepriceResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)PreviewRepriceResult.Member.statusCode, (Object)0), Datatypes.member((Enum)PreviewRepriceResult.Member.amount, (Object)getPositionAmountsResult.getAmount()), Datatypes.member((Enum)PreviewRepriceResult.Member.baseAmount, (Object)getPositionAmountsResult.getBaseAmount()), Datatypes.member((Enum)PreviewRepriceResult.Member.baseAmountIncludingTax, (Object)getPositionAmountsResult.getBaseAmountIncludingTax()), Datatypes.member((Enum)PreviewRepriceResult.Member.basePrice, (Object)getPriceLevelResult.getBasePrice()), Datatypes.member((Enum)PreviewRepriceResult.Member.discount, (Object)discount), Datatypes.member((Enum)PreviewRepriceResult.Member.discountAmount, (Object)getPositionAmountsResult.getDiscountAmount()), Datatypes.member((Enum)PreviewRepriceResult.Member.discountAmountIncludingTax, (Object)getPositionAmountsResult.getDiscountAmountIncludingTax()), Datatypes.member((Enum)PreviewRepriceResult.Member.discountIsPercentage, (Object)discountIsPercentage), Datatypes.member((Enum)PreviewRepriceResult.Member.discountOrigin, (Object)getPriceLevelResult.getDiscountOrigin()), Datatypes.member((Enum)PreviewRepriceResult.Member.priceLevel, (Object)getPriceLevelResult.getPriceLevel()), Datatypes.member((Enum)PreviewRepriceResult.Member.pricePerUnit, (Object)getPositionAmountsResult.getPricePerUnit()), Datatypes.member((Enum)PreviewRepriceResult.Member.pricePerUnitIncludingTax, (Object)getPositionAmountsResult.getPricePerUnitIncludingTax()), Datatypes.member((Enum)PreviewRepriceResult.Member.taxAmount, (Object)getPositionAmountsResult.getTaxAmount())});
    }

    public void repriceSalesContract(SalesContract contract) throws ServiceException {
        Object p;
        ArrayList positions = new ArrayList();
        if (contract instanceof Opportunity) {
            p = ((Opportunity)contract).getPosition();
            positions.addAll(p);
        } else if (contract instanceof Quote) {
            p = ((Quote)contract).getPosition();
            positions.addAll(p);
        } else if (contract instanceof SalesOrder) {
            p = ((SalesOrder)contract).getPosition();
            positions.addAll(p);
        } else if (contract instanceof Invoice) {
            p = ((Invoice)contract).getPosition();
            positions.addAll(p);
        }
        int pricingState = 20;
        for (SalesContractPosition position : positions) {
            short pricingStatePosition = this.repriceSalesContractPosition(position);
            if (pricingStatePosition != 10) continue;
            pricingState = 10;
        }
        contract.setPricingState((short)pricingState);
    }

    public int countFilteredContract(AbstractFilterContract contractFilter) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contractFilter);
        AbstractContractQuery query = (AbstractContractQuery)pm.newQuery(AbstractContract.class);
        QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
        queryExtension.setClause("/*!COUNT*/(1=1)");
        List contracts = contractFilter.getFilteredContract(query);
        return contracts.size();
    }

    public BigDecimal getRoundingFactorTotal(SalesContractPosition position) {
        return new BigDecimal(0.01);
    }

    public BigDecimal getRoundingFactorTotal(SalesContract contract) {
        return new BigDecimal(0.01);
    }

    public BigDecimal getDiscountAmountPerUnit(SalesContractPosition position, BigDecimal quantity, BigDecimal discount, Boolean discountIsPercentage, Short discountCalculationType, BigDecimal pricePerUnit, BigDecimal salesTaxRate) {
        return Boolean.TRUE.equals(discountIsPercentage) ? pricePerUnit.multiply(discount.divide(HUNDRED)) : (discount == null ? BigDecimal.ZERO : discount);
    }

    public GetPositionAmountsResult getPositionAmountsInternal(CalculationRule calculationRule, SalesContractPosition position, BigDecimal pricePerUnit, BigDecimal quantity, BigDecimal uomScaleFactor, BigDecimal discount, Boolean discountIsPercentage, Short discountCalculationType, BigDecimal salesTaxRate) {
        MathContext mathCtx = new MathContext(100, RoundingMode.HALF_UP);
        BigDecimal salesTaxRateFactor = salesTaxRate.divide(HUNDRED);
        BigDecimal roundingFactorTotal = this.getRoundingFactorTotal(position);
        BigDecimal discountAmountPerUnit = this.getDiscountAmountPerUnit(position, quantity, discount, discountIsPercentage, discountCalculationType, pricePerUnit, salesTaxRate);
        BigDecimal pricePerUnitIncludingTax = pricePerUnit.multiply(BigDecimal.ONE.add(salesTaxRateFactor));
        BigDecimal discountAmountUnrounded = discountAmountPerUnit == null ? BigDecimal.ZERO : quantity.multiply(discountAmountPerUnit.multiply(uomScaleFactor, mathCtx), mathCtx);
        BigDecimal baseAmountUnrounded = quantity.multiply(pricePerUnit.multiply(uomScaleFactor, mathCtx), mathCtx);
        BigDecimal grossAmountUnrounded = baseAmountUnrounded.subtract(discountAmountUnrounded);
        BigDecimal taxAmountUnrounded = grossAmountUnrounded.multiply(salesTaxRateFactor, mathCtx);
        BigDecimal amount = Utils.round(grossAmountUnrounded.add(taxAmountUnrounded), roundingFactorTotal);
        BigDecimal baseAmount = Utils.round(baseAmountUnrounded, roundingFactorTotal);
        BigDecimal baseAmountIncludingTax = Utils.round(baseAmount.multiply(BigDecimal.ONE.add(salesTaxRateFactor), mathCtx), roundingFactorTotal);
        BigDecimal taxAmount = Utils.round(amount.multiply(salesTaxRateFactor, mathCtx).divide(BigDecimal.ONE.add(salesTaxRateFactor), mathCtx), roundingFactorTotal);
        BigDecimal discountAmount = baseAmount.add(taxAmount).subtract(amount);
        BigDecimal discountAmountIncludingTax = Utils.round(discountAmount.multiply(BigDecimal.ONE.add(salesTaxRateFactor), mathCtx), roundingFactorTotal);
        GetPositionAmountsResult result = (GetPositionAmountsResult)Structures.create(GetPositionAmountsResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)GetPositionAmountsResult.Member.amount, (Object)amount), Datatypes.member((Enum)GetPositionAmountsResult.Member.baseAmount, (Object)baseAmount), Datatypes.member((Enum)GetPositionAmountsResult.Member.baseAmountIncludingTax, (Object)baseAmountIncludingTax), Datatypes.member((Enum)GetPositionAmountsResult.Member.discountAmount, (Object)discountAmount), Datatypes.member((Enum)GetPositionAmountsResult.Member.discountAmountIncludingTax, (Object)discountAmountIncludingTax), Datatypes.member((Enum)GetPositionAmountsResult.Member.pricePerUnit, (Object)pricePerUnit), Datatypes.member((Enum)GetPositionAmountsResult.Member.pricePerUnitIncludingTax, (Object)pricePerUnitIncludingTax), Datatypes.member((Enum)GetPositionAmountsResult.Member.statusCode, (Object)0), Datatypes.member((Enum)GetPositionAmountsResult.Member.statusMessage, null), Datatypes.member((Enum)GetPositionAmountsResult.Member.taxAmount, (Object)taxAmount)});
        return result;
    }

    public static GetContractAmountsResult getContractAmounts(RefPackage_1_0 rootPkg, CalculationRule calculationRule, SalesContract contract, Integer[] lineItemNumbers, BigDecimal[] positionBaseAmounts, BigDecimal[] positionDiscountAmounts, BigDecimal[] positionTaxAmounts, BigDecimal[] positionAmounts, BigDecimal[] salesCommissions, Boolean[] salesCommissionIsPercentages) {
        try {
            return Contracts.getInstance().getContractAmounts(calculationRule, contract, lineItemNumbers, positionBaseAmounts, positionDiscountAmounts, positionTaxAmounts, positionAmounts, salesCommissions, salesCommissionIsPercentages);
        }
        catch (ServiceException e) {
            throw new RuntimeServiceException((Exception)((Object)e));
        }
    }

    public GetContractAmountsResult getContractAmounts(CalculationRule calculationRule, SalesContract contract, Integer[] lineItemNumbers, BigDecimal[] positionBaseAmounts, BigDecimal[] positionDiscountAmounts, BigDecimal[] positionTaxAmounts, BigDecimal[] positionAmounts, BigDecimal[] salesCommissions, Boolean[] salesCommissionIsPercentages) {
        BigDecimal roundingFactor = this.getRoundingFactorTotal(contract);
        BigDecimal totalBaseAmount = BigDecimal.ZERO;
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal totalSalesCommission = BigDecimal.ZERO;
        for (int i = 0; i < positionBaseAmounts.length; ++i) {
            BigDecimal baseAmount = positionBaseAmounts[i] != null ? positionBaseAmounts[i] : BigDecimal.ZERO;
            totalBaseAmount = totalBaseAmount.add(baseAmount);
            BigDecimal discountAmount = positionDiscountAmounts[i] != null ? positionDiscountAmounts[i] : BigDecimal.ZERO;
            totalDiscountAmount = totalDiscountAmount.add(discountAmount);
            BigDecimal taxAmount = positionTaxAmounts[i] != null ? positionTaxAmounts[i] : BigDecimal.ZERO;
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            BigDecimal salesCommission = salesCommissions[i] != null ? salesCommissions[i] : BigDecimal.ZERO;
            totalSalesCommission = totalSalesCommission.add(salesCommissionIsPercentages[i] != null && salesCommissionIsPercentages[i] != false ? baseAmount.subtract(discountAmount).multiply(salesCommission.divide(new BigDecimal(100), RoundingMode.UP)) : salesCommission);
        }
        totalBaseAmount = Utils.round(totalBaseAmount, roundingFactor);
        totalTaxAmount = Utils.round(totalTaxAmount, roundingFactor);
        totalDiscountAmount = Utils.round(totalDiscountAmount, roundingFactor);
        totalSalesCommission = Utils.round(totalSalesCommission, roundingFactor);
        BigDecimal totalAmount = totalBaseAmount.subtract(totalDiscountAmount);
        BigDecimal totalAmountIncludingTax = totalAmount.add(totalTaxAmount);
        GetContractAmountsResult result = (GetContractAmountsResult)Structures.create(GetContractAmountsResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)GetContractAmountsResult.Member.statusCode, (Object)0), Datatypes.member((Enum)GetContractAmountsResult.Member.statusMessage, null), Datatypes.member((Enum)GetContractAmountsResult.Member.totalAmount, (Object)totalAmount), Datatypes.member((Enum)GetContractAmountsResult.Member.totalAmountIncludingTax, (Object)totalAmountIncludingTax), Datatypes.member((Enum)GetContractAmountsResult.Member.totalBaseAmount, (Object)totalBaseAmount), Datatypes.member((Enum)GetContractAmountsResult.Member.totalDiscountAmount, (Object)totalDiscountAmount), Datatypes.member((Enum)GetContractAmountsResult.Member.totalSalesCommission, (Object)totalSalesCommission), Datatypes.member((Enum)GetContractAmountsResult.Member.totalTaxAmount, (Object)totalTaxAmount)});
        return result;
    }

    public AbstractContract createContract(org.opencrx.kernel.contract1.jmi1.Segment contractSegment, short contractType, AbstractContract basedOn) throws ServiceException {
        ContractType defaultContractType;
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contractSegment);
        AbstractContract contract = null;
        ContractTypeQuery contractTypeQuery = (ContractTypeQuery)pm.newQuery(ContractType.class);
        contractTypeQuery.contractType().equalTo((Object)contractType);
        List contractTypes = contractSegment.getContractType(contractTypeQuery);
        ContractType contractType2 = defaultContractType = contractTypes.isEmpty() ? null : (ContractType)contractTypes.iterator().next();
        if (contractType == 1) {
            contract = (AbstractContract)pm.newInstance(Lead.class);
            contractSegment.addLead(this.getUidAsString(), (Lead)contract);
            contract.setOrigin(basedOn);
        } else if (contractType == 2) {
            if (basedOn instanceof Lead) {
                contract = this.createOpportunity((Lead)basedOn);
            } else if (basedOn instanceof Opportunity) {
                contract = (Opportunity)Cloneable.getInstance().cloneObject(basedOn, contractSegment, "opportunity", null, null, null, null);
            } else {
                contract = (AbstractContract)pm.newInstance(Opportunity.class);
                contractSegment.addOpportunity(this.getUidAsString(), (Opportunity)contract);
                contract.setOrigin(basedOn);
            }
        } else if (contractType == 3) {
            if (basedOn instanceof Opportunity) {
                contract = this.createQuote((Opportunity)basedOn);
            } else if (basedOn instanceof Quote) {
                contract = (Quote)Cloneable.getInstance().cloneObject(basedOn, contractSegment, "quote", null, null, null, null);
            } else {
                contract = (AbstractContract)pm.newInstance(Quote.class);
                contractSegment.addQuote(this.getUidAsString(), (Quote)contract);
                contract.setOrigin(basedOn);
            }
        } else if (contractType == 4) {
            if (basedOn instanceof Quote) {
                contract = this.createSalesOrder((Quote)basedOn);
            } else if (basedOn instanceof SalesOrder) {
                contract = (SalesOrder)Cloneable.getInstance().cloneObject(basedOn, contractSegment, "salesOrder", null, null, null, null);
            } else {
                contract = (AbstractContract)pm.newInstance(SalesOrder.class);
                contractSegment.addSalesOrder(this.getUidAsString(), (SalesOrder)contract);
                contract.setOrigin(basedOn);
            }
        } else if (contractType == 5) {
            if (basedOn instanceof SalesOrder) {
                contract = this.createInvoice((SalesOrder)basedOn);
            } else if (basedOn instanceof Invoice) {
                contract = (Invoice)Cloneable.getInstance().cloneObject(basedOn, contractSegment, "invoice", null, null, null, null);
            } else {
                contract = (AbstractContract)pm.newInstance(Invoice.class);
                contractSegment.addInvoice(this.getUidAsString(), (Invoice)contract);
                contract.setOrigin(basedOn);
            }
        } else if (contractType == 6) {
            if (basedOn instanceof SalesVolumeContract) {
                contract = (SalesVolumeContract)Cloneable.getInstance().cloneObject(basedOn, contractSegment, "contract", null, null, null, null);
            } else {
                contract = (AbstractContract)pm.newInstance(SalesVolumeContract.class);
                contractSegment.addContract(this.getUidAsString(), (SalesVolumeContract)contract);
                contract.setOrigin(basedOn);
            }
        } else if (contractType == 7) {
            if (basedOn instanceof GenericContract) {
                contract = (GenericContract)Cloneable.getInstance().cloneObject(basedOn, contractSegment, "contract", null, null, null, null);
            } else {
                contract = (AbstractContract)pm.newInstance(GenericContract.class);
                contractSegment.addContract(this.getUidAsString(), (GenericContract)contract);
                contract.setOrigin(basedOn);
            }
        }
        if (contract != null) {
            contract.setContractType(defaultContractType);
        }
        return contract;
    }

    public AbstractContract createContract(ContractCreator contractCreator, String name, String description, ContractType contractType, Date activeOn, Short priority, AbstractContract basedOn) throws ServiceException {
        return this.createContract(contractCreator, name, description, contractType, activeOn, priority, basedOn, true);
    }

    public AbstractContract createContract(ContractCreator contractCreator, String name, String description, ContractType contractType, Date activeOn, Short priority, AbstractContract basedOn, boolean reapplyContractCreator) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contractCreator);
        String providerName = contractCreator.refGetPath().getSegment(2).toString();
        String segmentName = contractCreator.refGetPath().getSegment(4).toString();
        boolean useRunAsPrincipal = Utils.hasObjectRunAsPermission(contractCreator.refGetPath(), Utils.getPermissions(Utils.getRequestingPrincipal(pm, providerName, segmentName), SecurityKeys.Action.RUN_AS.getName()));
        org.opencrx.kernel.contract1.jmi1.Segment contractSegment = this.getContractSegment(pm, providerName, segmentName);
        AbstractContract contract = null;
        if (contractType == null) {
            contractType = contractCreator.getDefaultType();
        }
        if (contractType != null && (contract = this.createContract(contractSegment, contractType.getContractType(), basedOn)) != null) {
            contract.setName((String)(name == null ? "@" + new Date() : name));
            if (description != null) {
                contract.setDescription(description);
            }
            Date date = activeOn = activeOn == null ? contractCreator.getActiveOn() : activeOn;
            if (activeOn != null) {
                contract.setActiveOn(activeOn);
            }
            if ((priority = Short.valueOf(priority == null ? contractCreator.getPriority() : priority.shortValue())) != null) {
                contract.setPriority(priority);
            }
            contract.setContractType(contractType);
            Base.getInstance().assignToMe(contract, true, useRunAsPrincipal);
            if (reapplyContractCreator) {
                this.reapplyContractCreator(contract, contractCreator);
            }
        }
        return contract;
    }

    public SalesTaxTypeGroup getSalesTaxTypeGroup(AbstractContract contract, SalesContractCreator contractCreator) throws ServiceException {
        return contractCreator.getSalesTaxTypeGroup();
    }

    public AbstractContract createSalesContract(SalesContractCreator contractCreator, String name, String description, ContractType contractType, Date activeOn, Short priority, Date pricingDate, Short contractCurrency, Short paymentTerms, Account customer, Account salesRep, Account broker, Account supplier, SalesTaxTypeGroup salesTaxTypeGroup, AbstractContract basedOn) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contractCreator);
        String providerName = contractCreator.refGetPath().getSegment(2).toString();
        String segmentName = contractCreator.refGetPath().getSegment(4).toString();
        AbstractContract contract = this.createContract(contractCreator, name, description, contractType, activeOn, priority, basedOn, false);
        if (contract instanceof SalesContract) {
            org.opencrx.kernel.contract1.jmi1.Segment contractSegment = this.getContractSegment(pm, providerName, segmentName);
            Segment productSegment = Products.getInstance().getProductSegment(pm, providerName, segmentName);
            SalesContract salesContract = (SalesContract)contract;
            Date date = pricingDate = pricingDate == null ? contractCreator.getPricingDate() : pricingDate;
            if (pricingDate != null) {
                salesContract.setPricingDate(pricingDate);
            }
            salesContract.setPricingRule(contractCreator.getPricingRule() == null ? (((SalesContract)contract).getPricingRule() == null ? Products.getInstance().getDefaultPricingRule(productSegment) : ((SalesContract)contract).getPricingRule()) : contractCreator.getPricingRule());
            salesContract.setCalcRule(contractCreator.getCalcRule() == null ? (((SalesContract)contract).getCalcRule() == null ? this.getDefaultCalculationRule(contractSegment) : ((SalesContract)contract).getCalcRule()) : contractCreator.getCalcRule());
            contractCurrency = contractCurrency == null ? contractCreator.getContractCurrency() : contractCurrency.shortValue();
            if (contractCurrency != null) {
                salesContract.setContractCurrency(contractCurrency);
            }
            Short s = paymentTerms = paymentTerms == null ? contractCreator.getPaymentTerms() : paymentTerms;
            if (paymentTerms != null) {
                salesContract.setPaymentTerms(paymentTerms);
            }
            Account account = customer = customer == null ? contractCreator.getCustomer() : customer;
            if (customer != null) {
                salesContract.setCustomer(customer);
            }
            Account account2 = salesRep = salesRep == null ? contractCreator.getSalesRep() : salesRep;
            if (salesRep != null) {
                salesContract.setSalesRep(salesRep);
            }
            Account account3 = broker = broker == null ? contractCreator.getBroker() : broker;
            if (broker != null) {
                salesContract.setBroker(broker);
            }
            Account account4 = supplier = supplier == null ? contractCreator.getSupplier() : supplier;
            if (supplier != null) {
                salesContract.setSupplier(supplier);
            }
            SalesTaxTypeGroup salesTaxTypeGroup2 = salesTaxTypeGroup = salesTaxTypeGroup == null ? this.getSalesTaxTypeGroup(contract, contractCreator) : salesTaxTypeGroup;
            if (salesTaxTypeGroup != null) {
                salesContract.setSalesTaxTypeGroup(salesTaxTypeGroup);
            }
        }
        this.reapplyContractCreator(contract, contractCreator);
        return contract;
    }

    public void createOrUpdateDepotReferences(AbstractContract contract, ContractCreator contractCreator) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contract);
        ArrayList<Depot> depots = new ArrayList<Depot>();
        DepotReferenceQuery depotReferenceQuery = (DepotReferenceQuery)pm.newQuery(DepotReference.class);
        for (DepotReference depotReference : contract.getDepotReference(depotReferenceQuery)) {
            depots.add(depotReference.getDepot());
        }
        for (DepotReference depotReference : contractCreator.getDepotReference(depotReferenceQuery)) {
            if (depots.contains(depotReference.getDepot())) continue;
            Cloneable.getInstance().cloneObject(depotReference, contract, "depotReference", null, "property", (User)contract.getOwningUser(), contract.getOwningGroup());
        }
        ArrayList<DepotPosition> depotPositions = new ArrayList<DepotPosition>();
        DepotPositionReferenceQuery depotPositionReferenceQuery = (DepotPositionReferenceQuery)pm.newQuery(DepotPositionReference.class);
        for (DepotPositionReference depotPositionReference : contract.getDepotReference(depotPositionReferenceQuery)) {
            depotPositions.add(depotPositionReference.getDepotPosition());
        }
        for (DepotPositionReference depotPositionReference : contractCreator.getDepotReference(depotPositionReferenceQuery)) {
            if (depotPositions.contains(depotPositionReference.getDepotPosition())) continue;
            Cloneable.getInstance().cloneObject(depotPositionReference, contract, "depotReference", null, "property", (User)contract.getOwningUser(), contract.getOwningGroup());
        }
    }

    public Set<PrincipalGroup> getDefaultOwningGroups(AbstractContract contract, List<ContractGroup> contractGroups) throws ServiceException {
        HashSet<PrincipalGroup> owningGroups = new HashSet<PrincipalGroup>();
        for (ContractGroup contractGroup : contractGroups) {
            List groups = contractGroup.getOwningGroup();
            for (PrincipalGroup group : groups) {
                if (contractGroup.getName().endsWith(PRIVATE_GROUP_SUFFIX)) {
                    String principalGroupName;
                    String contractGroupName = contractGroup.getName().substring(0, contractGroup.getName().indexOf("~"));
                    if (!contractGroupName.equals(principalGroupName = group.getName().substring(0, group.getName().indexOf(".")))) continue;
                    owningGroups.add(group);
                    continue;
                }
                owningGroups.add(group);
            }
        }
        return owningGroups;
    }

    public void reapplyContractCreator(AbstractContract contract, ContractCreator contractCreator) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)contract);
        if (contractCreator == null) {
            contractCreator = contract.getLastAppliedCreator();
        }
        if (contractCreator != null) {
            Object assignment;
            List<ContractGroup> contractGroups = contractCreator.getContractGroup();
            Set<PrincipalGroup> owningGroups = this.getDefaultOwningGroups(contract, contractGroups);
            if (!owningGroups.containsAll(contract.getOwningGroup()) || !contract.getOwningGroup().containsAll(owningGroups)) {
                contract.getOwningGroup().clear();
                contract.getOwningGroup().addAll(owningGroups);
            }
            ContractContainsContractGroupAssignment.GroupAssignment existingGroupAssignments = contract.getGroupAssignment();
            ArrayList<ContractGroup> excludeGroups = new ArrayList<ContractGroup>();
            Iterator<Object> iterator = existingGroupAssignments.iterator();
            while (iterator.hasNext()) {
                ContractGroupAssignment existingGroupAssignment = (ContractGroupAssignment)iterator.next();
                if (existingGroupAssignment.getContractGroup() == null) continue;
                excludeGroups.add(existingGroupAssignment.getContractGroup());
            }
            for (ContractGroup contractGroup : contractGroups) {
                if (excludeGroups.contains(contractGroup)) continue;
                assignment = (ContractGroupAssignment)pm.newInstance(ContractGroupAssignment.class);
                assignment.setName(contractGroup.getName());
                assignment.setContractGroup(contractGroup);
                assignment.getOwningGroup().addAll(owningGroups);
                contract.addGroupAssignment(this.getUidAsString(), (ContractGroupAssignment)assignment);
            }
            this.createOrUpdateDepotReferences(contract, contractCreator);
            CrxObjectContainsPropertySet.PropertySet existingPropertySets = contract.getPropertySet();
            ArrayList<String> excludePropertySets = new ArrayList<String>();
            assignment = existingPropertySets.iterator();
            while (assignment.hasNext()) {
                PropertySet existingPropertySet = (PropertySet)assignment.next();
                excludePropertySets.add(existingPropertySet.getName());
            }
            CrxObjectContainsPropertySet.PropertySet propertySets = contractCreator.getPropertySet();
            Iterator iterator2 = propertySets.iterator();
            while (iterator2.hasNext()) {
                PropertySet propertySet = (PropertySet)iterator2.next();
                if (excludePropertySets.contains(propertySet.getName())) continue;
                Cloneable.getInstance().cloneObject(propertySet, contract, "propertySet", null, "property", (User)contract.getOwningUser(), contract.getOwningGroup());
            }
            contract.setLastAppliedCreator(contractCreator);
        }
    }

    protected void updateAccountAssignmentContract(AccountAssignmentContract accountAssignment) throws ServiceException {
    }

    protected void removeAccountAssignmentContract(AccountAssignmentContract accountAssignment, boolean preDelete) throws ServiceException {
        if (!preDelete) {
            accountAssignment.refDelete();
        }
    }

    @Override
    public void preDelete(RefObject_1_0 object, boolean preDelete) throws ServiceException {
        super.preDelete(object, preDelete);
        if (object instanceof AbstractContract) {
            this.removeContract((AbstractContract)object, preDelete);
        } else if (object instanceof AccountAssignmentContract) {
            this.removeAccountAssignmentContract((AccountAssignmentContract)object, preDelete);
        } else if (object instanceof SalesContractPosition) {
            this.removeSalesContractPosition((SalesContractPosition)object, true, preDelete);
        }
    }

    @Override
    public void preStore(RefObject_1_0 object) throws ServiceException {
        super.preStore(object);
        if (object instanceof SalesContract) {
            this.updateContract((AbstractContract)object);
            this.updateSalesContract((SalesContract)object);
        } else if (object instanceof AbstractContract) {
            this.updateContract((AbstractContract)object);
        } else if (object instanceof SalesContractPosition) {
            this.updateSalesContractPosition((SalesContractPosition)object);
        } else if (object instanceof AccountAssignmentContract) {
            this.updateAccountAssignmentContract((AccountAssignmentContract)object);
        } else if (object instanceof PhoneNumber) {
            Addresses.getInstance().updatePhoneNumber((PhoneNumber)object);
        } else if (object instanceof EMailAddress) {
            Addresses.getInstance().updateEMailAddress((EMailAddress)object);
        } else if (object instanceof UriAddress) {
            Addresses.getInstance().updateUriAddress((UriAddress)object);
        }
    }

    public static class SalesContractAmounts {
        public BigDecimal totalBaseAmount = null;
        public BigDecimal totalDiscountAmount = null;
        public BigDecimal totalTaxAmount = null;
        public BigDecimal totalAmount = null;
        public BigDecimal totalAmountIncludingTax = null;
        public BigDecimal totalSalesCommission = null;
        public List<SalesContractPosition> positions = new ArrayList<SalesContractPosition>();
        public List<Integer> lineItemNumbers = new ArrayList<Integer>();
        public List<BigDecimal> positionBaseAmounts = new ArrayList<BigDecimal>();
        public List<BigDecimal> positionDiscountAmounts = new ArrayList<BigDecimal>();
        public List<BigDecimal> positionTaxAmounts = new ArrayList<BigDecimal>();
        public List<BigDecimal> positionAmounts = new ArrayList<BigDecimal>();
        public List<BigDecimal> salesCommissions = new ArrayList<BigDecimal>();
        public List<Boolean> salesCommissionIsPercentages = new ArrayList<Boolean>();
    }
}

