/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.util.List;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.model1.cci2.Classifier;
import org.opencrx.kernel.model1.cci2.ParameterQuery;
import org.opencrx.kernel.model1.jmi1.Element;
import org.opencrx.kernel.model1.jmi1.Namespace;
import org.opencrx.kernel.model1.jmi1.Operation;
import org.opencrx.kernel.model1.jmi1.Parameter;
import org.opencrx.kernel.model1.jmi1.Segment;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.naming.Path;

public class Models
extends AbstractImpl {
    protected static final String[] PARAMETER_DIRECTIONS = new String[]{"N/A", "in", "out", "inout", "return"};
    protected static final String[] MULTIPLICITIES = new String[]{"N/A", "0..*", "0..1", "1", "1..*", "set", "sparsearray"};

    public static void register() {
        Models.registerImpl(new Models());
    }

    public static Models getInstance() throws ServiceException {
        return Models.getInstance(Models.class);
    }

    protected Models() {
    }

    public Segment getModelSegment(PersistenceManager pm, String providerName, String segmentName) {
        return (Segment)pm.getObjectById((Object)new Path("xri://@openmdx*org.opencrx.kernel.model1").getDescendant(new String[]{"provider", providerName, "segment", segmentName}));
    }

    public String getOperationSignature(Operation operation) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)operation);
        Segment modelSegment = (Segment)pm.getObjectById((Object)operation.refGetPath().getPrefix(5));
        ParameterQuery parameterQuery = (ParameterQuery)pm.newQuery(Parameter.class);
        parameterQuery.thereExistsContainer().equalTo(operation);
        parameterQuery.orderByElementOrder().ascending();
        List parameters = modelSegment.getElement(parameterQuery);
        String signature = operation.getName() + "(";
        int ii = 0;
        for (Parameter parameter : parameters) {
            Classifier type = parameter.getType();
            if (ii > 0) {
                signature = signature + ",";
            }
            signature = signature + "\n  ";
            String typeName = type == null ? "void" : type.getQualifiedName();
            signature = signature + PARAMETER_DIRECTIONS[parameter.getDirection()] + " " + typeName + " [" + MULTIPLICITIES[parameter.getMultiplicity()] + "] " + parameter.getName() + " ";
        }
        signature = signature + "\n);";
        return signature;
    }

    protected void updateModelElement(Element element) throws ServiceException {
        Namespace container = element.getContainer();
        String name = element.getName();
        element.setQualifiedName((String)(container == null ? name : container.getQualifiedName() + ":" + name));
    }

    @Override
    public void preDelete(RefObject_1_0 object, boolean preDelete) throws ServiceException {
        super.preDelete(object, preDelete);
    }

    @Override
    public void preStore(RefObject_1_0 object) throws ServiceException {
        super.preStore(object);
        if (object instanceof Element) {
            this.updateModelElement((Element)object);
        }
    }
}

