/*
 * Decompiled with CFR 0.152.
 */
package org.opencrx.kernel.backend;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import org.opencrx.kernel.account1.cci2.AccountQuery;
import org.opencrx.kernel.account1.jmi1.Account;
import org.opencrx.kernel.backend.AbstractImpl;
import org.opencrx.kernel.backend.Addresses;
import org.opencrx.kernel.backend.Cloneable;
import org.opencrx.kernel.backend.Codes;
import org.opencrx.kernel.backend.Contracts;
import org.opencrx.kernel.base.cci2.PropertyQuery;
import org.opencrx.kernel.base.cci2.PropertySetContainsProperty;
import org.opencrx.kernel.base.jmi1.AttributeFilterProperty;
import org.opencrx.kernel.base.jmi1.Property;
import org.opencrx.kernel.code1.jmi1.ValidateObjectResult;
import org.opencrx.kernel.contract1.jmi1.AbstractContract;
import org.opencrx.kernel.contract1.jmi1.SalesContract;
import org.opencrx.kernel.contract1.jmi1.SalesContractPosition;
import org.opencrx.kernel.product1.cci2.AbstractPriceLevelQuery;
import org.opencrx.kernel.product1.cci2.DiscountOrigin;
import org.opencrx.kernel.product1.cci2.DiscountRuleQuery;
import org.opencrx.kernel.product1.cci2.GetPriceLevelResult;
import org.opencrx.kernel.product1.cci2.PriceLevelHasAssignedAccount;
import org.opencrx.kernel.product1.cci2.PriceListEntryQuery;
import org.opencrx.kernel.product1.cci2.PriceModifierQuery;
import org.opencrx.kernel.product1.cci2.PricingRuleQuery;
import org.opencrx.kernel.product1.cci2.ProductBasePriceQuery;
import org.opencrx.kernel.product1.cci2.ProductConfigurationQuery;
import org.opencrx.kernel.product1.cci2.ProductConfigurationSetContainsConfiguration;
import org.opencrx.kernel.product1.cci2.ProductConfigurationTypeSetContainsConfigurationType;
import org.opencrx.kernel.product1.cci2.ProductFilterHasFilterProperty;
import org.opencrx.kernel.product1.cci2.ProductQuery;
import org.opencrx.kernel.product1.cci2.SalesTaxTypeQuery;
import org.opencrx.kernel.product1.jmi1.AbstractFilterProduct;
import org.opencrx.kernel.product1.jmi1.AbstractPriceLevel;
import org.opencrx.kernel.product1.jmi1.AbstractProduct;
import org.opencrx.kernel.product1.jmi1.AccountAssignment;
import org.opencrx.kernel.product1.jmi1.CategoryFilterProperty;
import org.opencrx.kernel.product1.jmi1.ConfiguredProduct;
import org.opencrx.kernel.product1.jmi1.DefaultSalesTaxTypeFilterProperty;
import org.opencrx.kernel.product1.jmi1.DisabledFilterProperty;
import org.opencrx.kernel.product1.jmi1.DiscountPriceModifier;
import org.opencrx.kernel.product1.jmi1.DiscountRule;
import org.opencrx.kernel.product1.jmi1.DiscountSchedule;
import org.opencrx.kernel.product1.jmi1.EMailAddress;
import org.opencrx.kernel.product1.jmi1.GetPriceLevelResult;
import org.opencrx.kernel.product1.jmi1.LinearPriceModifier;
import org.opencrx.kernel.product1.jmi1.PhoneNumber;
import org.opencrx.kernel.product1.jmi1.PriceLevel;
import org.opencrx.kernel.product1.jmi1.PriceListEntry;
import org.opencrx.kernel.product1.jmi1.PriceModifier;
import org.opencrx.kernel.product1.jmi1.PriceModifierReference;
import org.opencrx.kernel.product1.jmi1.PriceUomFilterProperty;
import org.opencrx.kernel.product1.jmi1.PricingRule;
import org.opencrx.kernel.product1.jmi1.Product;
import org.opencrx.kernel.product1.jmi1.ProductAttributeFilterProperty;
import org.opencrx.kernel.product1.jmi1.ProductBasePrice;
import org.opencrx.kernel.product1.jmi1.ProductClassificationFilterProperty;
import org.opencrx.kernel.product1.jmi1.ProductConfiguration;
import org.opencrx.kernel.product1.jmi1.ProductConfigurationSet;
import org.opencrx.kernel.product1.jmi1.ProductConfigurationType;
import org.opencrx.kernel.product1.jmi1.ProductConfigurationTypeSet;
import org.opencrx.kernel.product1.jmi1.ProductFilterProperty;
import org.opencrx.kernel.product1.jmi1.ProductPhasePriceLevel;
import org.opencrx.kernel.product1.jmi1.ProductQueryFilterProperty;
import org.opencrx.kernel.product1.jmi1.RelatedProduct;
import org.opencrx.kernel.product1.jmi1.SalesTaxType;
import org.opencrx.kernel.product1.jmi1.Segment;
import org.opencrx.kernel.product1.jmi1.UriAddress;
import org.opencrx.kernel.uom1.jmi1.Uom;
import org.opencrx.kernel.utils.ScriptUtils;
import org.opencrx.kernel.utils.Utils;
import org.opencrx.security.realm1.cci2.PrincipalGroup;
import org.opencrx.security.realm1.jmi1.User;
import org.openmdx.base.accessor.jmi.cci.RefObject_1_0;
import org.openmdx.base.accessor.jmi.cci.RefPackage_1_0;
import org.openmdx.base.exception.ServiceException;
import org.openmdx.base.jmi1.ContextCapable;
import org.openmdx.base.marshalling.Marshaller;
import org.openmdx.base.naming.Path;
import org.openmdx.base.persistence.cci.PersistenceHelper;
import org.openmdx.base.query.ConditionType;
import org.openmdx.base.query.Quantifier;
import org.openmdx.base.rest.cci.QueryExtensionRecord;
import org.openmdx.base.text.conversion.UUIDConversion;
import org.openmdx.kernel.exception.BasicException;
import org.openmdx.kernel.id.UUIDs;
import org.openmdx.kernel.log.SysLog;
import org.w3c.cci2.AnyTypePredicate;
import org.w3c.spi2.Datatypes;
import org.w3c.spi2.Structures;

public class Products
extends AbstractImpl {
    public static final int BATCHING_MODE_SIZE = 1000;
    public static final short PROCESSING_MODE_NA = 0;
    public static final short PROCESSING_MODE_TEST = 1;
    public static final short PROCESSING_MODE_PROCESS = 2;
    public static final short PROCESSING_MODE_PROCESS_INCLUDE_DEPENDENT = 3;
    public static final short PROCESSING_MODE_CLONE_PRICELEVEL_INCLUDE_PRICES = 4;
    public static final short PROCESSING_MODE_CLONE_PRICELEVEL_NO_PRICES = 5;
    public static final short STATUS_CODE_OK = 0;
    public static final short STATUS_CODE_ERROR = 1;
    public static final String PRICING_RULE_NAME_LOWEST_PRICE = "Lowest Price";
    public static final String PRICING_RULE_DESCRIPTION_LOWEST_PRICE = "Get price level which returns the lowest price of the given product, contract currency, pricing date and quantity. If the product is not defined return the price level which matches the contract currency, price uom and pricing date.";
    public static final String PRICING_RULE_GET_PRICE_LEVEL_SCRIPT_LOWEST_PRICE = "//<pre>\n    public static org.opencrx.kernel.product1.jmi1.GetPriceLevelResult getPriceLevel(\n    org.openmdx.base.accessor.jmi.cci.RefPackage_1_0 rootPkg,\n    org.opencrx.kernel.product1.jmi1.PricingRule pricingRule,\n    org.opencrx.kernel.contract1.jmi1.SalesContract contract,\n    org.opencrx.kernel.contract1.jmi1.SalesContractPosition position,\n    org.opencrx.kernel.product1.jmi1.AbstractProduct product,\n    org.opencrx.kernel.uom1.jmi1.Uom priceUom,\n    java.math.BigDecimal quantity,\n    java.lang.Short contractPositionState,\n    java.util.Date pricingDate,\n    org.opencrx.kernel.product1.jmi1.AbstractPriceLevel overridePriceLevel\n) {\n    return org.opencrx.kernel.backend.Products.getLowestPricePriceLevel(\n        rootPkg,\n        pricingRule,\n        contract,\n        position,\n        product,\n        priceUom,\n        quantity,\n        contractPositionState,\n        pricingDate,\n        overridePriceLevel\n    );\n}//</pre>";

    public static void register() {
        Products.registerImpl(new Products());
    }

    public static Products getInstance() throws ServiceException {
        return Products.getInstance(Products.class);
    }

    protected Products() {
    }

    @Deprecated
    public PricingRule findPricingRule(String name, Segment segment, PersistenceManager pm) {
        return this.findPricingRule(name, segment);
    }

    public PricingRule findPricingRule(String name, Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        PricingRuleQuery pricingRuleQuery = (PricingRuleQuery)pm.newQuery(PricingRule.class);
        pricingRuleQuery.name().equalTo((Object)name);
        List pricingRules = segment.getPricingRule(pricingRuleQuery);
        return pricingRules.isEmpty() ? null : (PricingRule)pricingRules.iterator().next();
    }

    public PricingRule getDefaultPricingRule(Segment productSegment) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)productSegment);
        PricingRuleQuery query = (PricingRuleQuery)pm.newQuery(PricingRule.class);
        query.thereExistsIsDefault().isTrue();
        List pricingRules = productSegment.getPricingRule(query);
        return pricingRules.isEmpty() ? null : (PricingRule)pricingRules.iterator().next();
    }

    public SalesTaxType findSalesTaxType(String name, Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        SalesTaxTypeQuery query = (SalesTaxTypeQuery)pm.newQuery(SalesTaxType.class);
        query.name().equalTo((Object)name);
        List salesTaxTypes = segment.getSalesTaxType(query);
        if (!salesTaxTypes.isEmpty()) {
            return (SalesTaxType)salesTaxTypes.iterator().next();
        }
        return null;
    }

    public SalesTaxType initSalesTaxType(String name, BigDecimal rate, Segment segment) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)segment);
        SalesTaxType salesTaxType = this.findSalesTaxType(name, segment);
        if (salesTaxType != null) {
            return salesTaxType;
        }
        try {
            pm.currentTransaction().begin();
            salesTaxType = (SalesTaxType)pm.newInstance(SalesTaxType.class);
            salesTaxType.setName(name);
            salesTaxType.setRate(rate);
            salesTaxType.getOwningGroup().addAll(segment.getOwningGroup());
            segment.addSalesTaxType(Contracts.getInstance().getUidAsString(), salesTaxType);
            pm.currentTransaction().commit();
        }
        catch (Exception e) {
            try {
                pm.currentTransaction().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return salesTaxType;
    }

    public Segment getProductSegment(PersistenceManager pm, String providerName, String segmentName) {
        return (Segment)pm.getObjectById((Object)new Path("xri:@openmdx:org.opencrx.kernel.product1/provider/" + providerName + "/segment/" + segmentName));
    }

    public PricingRule initPricingRule(String pricingRuleName, String description, String getPriceLevelScript, PersistenceManager pm, String providerName, String segmentName) {
        Segment productSegment = this.getProductSegment(pm, providerName, segmentName);
        PricingRule pricingRule = null;
        pricingRule = this.findPricingRule(pricingRuleName, productSegment, pm);
        if (pricingRule != null) {
            return pricingRule;
        }
        pm.currentTransaction().begin();
        pricingRule = (PricingRule)pm.newInstance(PricingRule.class);
        pricingRule.setName(pricingRuleName);
        pricingRule.setDescription(description);
        pricingRule.setGetPriceLevelScript(getPriceLevelScript);
        pricingRule.setDefault(true);
        pricingRule.getOwningGroup().addAll(productSegment.getOwningGroup());
        productSegment.addPricingRule(false, UUIDConversion.toUID((UUID)UUIDs.newUUID()), pricingRule);
        pm.currentTransaction().commit();
        return pricingRule;
    }

    public int cloneProductConfigurationSet(ProductConfigurationSet from, SalesContractPosition to, boolean cloneDefaultOnly, boolean updateCurrentConfig, User owningUser, List<PrincipalGroup> owningGroup) throws ServiceException {
        ProductConfigurationSetContainsConfiguration.Configuration configurations = from.getConfiguration();
        Iterator iterator = configurations.iterator();
        while (iterator.hasNext()) {
            ProductConfiguration configuration = (ProductConfiguration)iterator.next();
            if (cloneDefaultOnly && (configuration.isDefault() == null || !configuration.isDefault().booleanValue())) continue;
            Cloneable.getInstance().cloneObject(configuration, to, "configuration", null, null, owningUser, owningGroup);
        }
        if (to instanceof ConfiguredProduct) {
            ((ConfiguredProduct)((Object)to)).setConfigType(from.getConfigType());
            if (updateCurrentConfig) {
                configurations = ((ConfiguredProduct)((Object)to)).getConfiguration();
                ProductConfiguration defaultConfiguration = null;
                Iterator iterator2 = configurations.iterator();
                while (iterator2.hasNext()) {
                    ProductConfiguration configuration = (ProductConfiguration)iterator2.next();
                    if (configuration.isDefault() == null || !configuration.isDefault().booleanValue()) continue;
                    defaultConfiguration = configuration;
                    break;
                }
                if (defaultConfiguration != null) {
                    ((ConfiguredProduct)((Object)to)).setCurrentConfig(defaultConfiguration);
                }
            }
        }
        return configurations.size();
    }

    public void setConfigurationType(Product product, ProductConfigurationTypeSet configurationTypeSet) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)product);
        ProductConfigurationTypeSetContainsConfigurationType.ConfigurationType configurationTypes = configurationTypeSet.getConfigurationType();
        Iterator iterator = configurationTypes.iterator();
        while (iterator.hasNext()) {
            ProductConfigurationType configurationType = (ProductConfigurationType)iterator.next();
            ProductConfigurationQuery configurationQuery = (ProductConfigurationQuery)pm.newQuery(ProductConfiguration.class);
            configurationQuery.name().equalTo((Object)configurationType.getName());
            configurationQuery.thereExistsConfigType().equalTo(configurationType);
            configurationQuery.orderByCreatedAt().descending();
            List configurations = product.getConfiguration(configurationQuery);
            ProductConfiguration configuration = null;
            if (configurations.isEmpty()) {
                configuration = (ProductConfiguration)pm.newInstance(ProductConfiguration.class);
                product.addConfiguration(this.getUidAsString(), configuration);
            } else {
                configuration = (ProductConfiguration)configurations.iterator().next();
            }
            configuration.setDefault(configurationType.isDefault());
            configuration.setName(configurationType.getName());
            configuration.setDescription(configurationType.getDescription());
            configuration.setValidFrom(configurationType.getValidFrom());
            configuration.setValidTo(configurationType.getValidTo());
            configuration.setConfigType(configurationType);
            if (Boolean.TRUE.equals(configuration.isDisabled())) {
                configuration.setDisabled(false);
            }
            PropertySetContainsProperty.Property properties = configurationType.getProperty();
            Iterator iterator2 = properties.iterator();
            while (iterator2.hasNext()) {
                Property property = (Property)iterator2.next();
                PropertyQuery propertyQuery = (PropertyQuery)pm.newQuery(Property.class);
                propertyQuery.name().equalTo((Object)property.getName());
                if (!configuration.getProperty(propertyQuery).isEmpty()) continue;
                Cloneable.getInstance().cloneObject(property, configuration, "property", null, "", null, null);
            }
        }
        product.setConfigType(configurationTypeSet);
    }

    public void unsetConfigurationType(ProductConfigurationSet productConfigurationSet) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)productConfigurationSet);
        if (productConfigurationSet.getConfigType() != null) {
            ProductConfigurationTypeSet configurationTypeSet = productConfigurationSet.getConfigType();
            Iterator iterator = configurationTypeSet.getConfigurationType().iterator();
            while (iterator.hasNext()) {
                ProductConfigurationType configurationType = (ProductConfigurationType)iterator.next();
                ProductConfigurationQuery configurationQuery = (ProductConfigurationQuery)pm.newQuery(ProductConfiguration.class);
                configurationQuery.thereExistsConfigType().equalTo(configurationType);
                for (ProductConfiguration configuration : productConfigurationSet.getConfiguration(configurationQuery)) {
                    configuration.setDisabled(true);
                }
            }
            productConfigurationSet.setConfigType(null);
            if (productConfigurationSet instanceof ConfiguredProduct) {
                ((ConfiguredProduct)productConfigurationSet).setCurrentConfig(null);
            }
        }
    }

    public void unsetConfigurationType(ProductConfiguration productConfiguration) throws ServiceException {
        productConfiguration.setConfigType(null);
        productConfiguration.setDisabled(true);
    }

    public ProductQuery getFilteredProductQuery(AbstractFilterProduct productFilter, ProductQuery query, boolean forCounting) throws ServiceException {
        ProductFilterHasFilterProperty.ProductFilterProperty filterProperties = productFilter.getProductFilterProperty();
        boolean hasQueryFilterClause = false;
        Iterator iterator = filterProperties.iterator();
        block67: while (iterator.hasNext()) {
            ProductAttributeFilterProperty p;
            ProductFilterProperty filterProperty = (ProductFilterProperty)iterator.next();
            Boolean isActive = filterProperty.isActive();
            if (isActive == null || !isActive.booleanValue()) continue;
            if (filterProperty instanceof ProductQueryFilterProperty) {
                ProductQueryFilterProperty p2 = (ProductQueryFilterProperty)filterProperty;
                QueryExtensionRecord queryFilter = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
                queryFilter.setClause((forCounting ? "/*!COUNT*/" : "") + p2.getClause());
                queryFilter.getStringParam().addAll(p2.getStringParam());
                queryFilter.getIntegerParam().addAll(p2.getIntegerParam());
                queryFilter.getDecimalParam().addAll(p2.getDecimalParam());
                queryFilter.setBooleanParam(new Boolean[]{p2.getBooleanParam().isEmpty() ? Boolean.FALSE : p2.getBooleanParam().iterator().next()});
                queryFilter.getDateParam().addAll(p2.getDateParam());
                queryFilter.getDateTimeParam().addAll(p2.getDateTimeParam());
                hasQueryFilterClause = true;
                continue;
            }
            if (!(filterProperty instanceof AttributeFilterProperty)) continue;
            AttributeFilterProperty attributeFilterProperty = (AttributeFilterProperty)((Object)filterProperty);
            short operator = attributeFilterProperty.getFilterOperator();
            operator = operator == 0 ? ConditionType.IS_IN.code() : operator;
            short quantor = attributeFilterProperty.getFilterQuantor();
            short s = quantor = quantor == 0 ? Quantifier.THERE_EXISTS.code() : quantor;
            if (filterProperty instanceof PriceUomFilterProperty) {
                p = (PriceUomFilterProperty)filterProperty;
                block0 : switch (Quantifier.valueOf((short)quantor)) {
                    case FOR_ALL: {
                        switch (ConditionType.valueOf((short)operator)) {
                            case IS_IN: {
                                query.forAllPriceUom().elementOf(p.getPriceUom());
                                break block0;
                            }
                            case IS_NOT_IN: {
                                query.forAllPriceUom().notAnElementOf(p.getPriceUom());
                                break block0;
                            }
                        }
                        query.forAllPriceUom().elementOf(p.getPriceUom());
                        break;
                    }
                    default: {
                        switch (ConditionType.valueOf((short)operator)) {
                            case IS_IN: {
                                query.thereExistsPriceUom().elementOf(p.getPriceUom());
                                break block0;
                            }
                            case IS_NOT_IN: {
                                query.thereExistsPriceUom().notAnElementOf(p.getPriceUom());
                                break block0;
                            }
                        }
                        query.thereExistsPriceUom().elementOf(p.getPriceUom());
                        break;
                    }
                }
                continue;
            }
            if (filterProperty instanceof CategoryFilterProperty) {
                p = (CategoryFilterProperty)filterProperty;
                block11 : switch (Quantifier.valueOf((short)quantor)) {
                    case FOR_ALL: {
                        switch (ConditionType.valueOf((short)operator)) {
                            case IS_IN: {
                                query.forAllCategory().elementOf(p.getCategory());
                                break block11;
                            }
                            case IS_LIKE: {
                                query.forAllCategory().like(p.getCategory());
                                break block11;
                            }
                            case IS_GREATER: {
                                query.forAllCategory().greaterThan((Comparable)((Object)p.getCategory().get(0)));
                                break block11;
                            }
                            case IS_GREATER_OR_EQUAL: {
                                query.forAllCategory().greaterThanOrEqualTo((Comparable)((Object)p.getCategory().get(0)));
                                break block11;
                            }
                            case IS_LESS: {
                                query.forAllCategory().lessThan((Comparable)((Object)p.getCategory().get(0)));
                                break block11;
                            }
                            case IS_LESS_OR_EQUAL: {
                                query.forAllCategory().lessThanOrEqualTo((Comparable)((Object)p.getCategory().get(0)));
                                break block11;
                            }
                            case IS_NOT_IN: {
                                query.forAllCategory().notAnElementOf(p.getCategory());
                                break block11;
                            }
                            case IS_UNLIKE: {
                                query.forAllCategory().unlike(p.getCategory());
                                break block11;
                            }
                        }
                        query.forAllCategory().elementOf(p.getCategory());
                        break;
                    }
                    default: {
                        switch (ConditionType.valueOf((short)operator)) {
                            case IS_IN: {
                                query.thereExistsCategory().elementOf(p.getCategory());
                                break block11;
                            }
                            case IS_LIKE: {
                                query.thereExistsCategory().like(p.getCategory());
                                break block11;
                            }
                            case IS_GREATER: {
                                query.thereExistsCategory().greaterThan((Comparable)((Object)p.getCategory().get(0)));
                                break block11;
                            }
                            case IS_GREATER_OR_EQUAL: {
                                query.thereExistsCategory().greaterThanOrEqualTo((Comparable)((Object)p.getCategory().get(0)));
                                break block11;
                            }
                            case IS_LESS: {
                                query.thereExistsCategory().lessThan((Comparable)((Object)p.getCategory().get(0)));
                                break block11;
                            }
                            case IS_LESS_OR_EQUAL: {
                                query.thereExistsCategory().lessThanOrEqualTo((Comparable)((Object)p.getCategory().get(0)));
                                break block11;
                            }
                            case IS_NOT_IN: {
                                query.thereExistsCategory().notAnElementOf(p.getCategory());
                                break block11;
                            }
                            case IS_UNLIKE: {
                                query.thereExistsCategory().unlike(p.getCategory());
                                break block11;
                            }
                        }
                        query.thereExistsCategory().elementOf(p.getCategory());
                        break;
                    }
                }
                continue;
            }
            if (filterProperty instanceof ProductClassificationFilterProperty) {
                p = (ProductClassificationFilterProperty)filterProperty;
                block34 : switch (Quantifier.valueOf((short)quantor)) {
                    case FOR_ALL: {
                        switch (ConditionType.valueOf((short)operator)) {
                            case IS_IN: {
                                query.forAllClassification().elementOf(p.getClassification());
                                break block34;
                            }
                            case IS_NOT_IN: {
                                query.forAllClassification().notAnElementOf(p.getClassification());
                                break block34;
                            }
                        }
                        query.forAllClassification().elementOf(p.getClassification());
                        break;
                    }
                    default: {
                        switch (ConditionType.valueOf((short)operator)) {
                            case IS_IN: {
                                query.thereExistsClassification().elementOf(p.getClassification());
                                break block34;
                            }
                            case IS_NOT_IN: {
                                query.thereExistsClassification().notAnElementOf(p.getClassification());
                                break block34;
                            }
                        }
                        query.thereExistsClassification().elementOf(p.getClassification());
                        break;
                    }
                }
                continue;
            }
            if (filterProperty instanceof DefaultSalesTaxTypeFilterProperty) {
                p = (DefaultSalesTaxTypeFilterProperty)filterProperty;
                block45 : switch (Quantifier.valueOf((short)quantor)) {
                    case FOR_ALL: {
                        switch (ConditionType.valueOf((short)operator)) {
                            case IS_IN: {
                                query.forAllSalesTaxType().elementOf(p.getSalesTaxType());
                                break block45;
                            }
                            case IS_NOT_IN: {
                                query.forAllSalesTaxType().notAnElementOf(p.getSalesTaxType());
                                break block45;
                            }
                        }
                        query.forAllSalesTaxType().elementOf(p.getSalesTaxType());
                        break;
                    }
                    default: {
                        switch (ConditionType.valueOf((short)operator)) {
                            case IS_IN: {
                                query.thereExistsSalesTaxType().elementOf(p.getSalesTaxType());
                                break block45;
                            }
                            case IS_NOT_IN: {
                                query.thereExistsSalesTaxType().notAnElementOf(p.getSalesTaxType());
                                break block45;
                            }
                        }
                        query.thereExistsSalesTaxType().elementOf(p.getSalesTaxType());
                        break;
                    }
                }
                continue;
            }
            if (!(filterProperty instanceof DisabledFilterProperty)) continue;
            p = (DisabledFilterProperty)filterProperty;
            switch (Quantifier.valueOf((short)quantor)) {
                case FOR_ALL: {
                    switch (ConditionType.valueOf((short)operator)) {
                        case IS_IN: {
                            query.forAllDisabled().equalTo(p.isDisabled());
                            continue block67;
                        }
                        case IS_NOT_IN: {
                            query.forAllDisabled().equalTo(!p.isDisabled());
                            continue block67;
                        }
                    }
                    continue block67;
                }
            }
            switch (ConditionType.valueOf((short)operator)) {
                case IS_IN: {
                    query.thereExistsDisabled().equalTo(p.isDisabled());
                    break;
                }
                case IS_NOT_IN: {
                    query.thereExistsDisabled().equalTo(!p.isDisabled());
                    break;
                }
            }
        }
        if (!hasQueryFilterClause && forCounting) {
            QueryExtensionRecord queryFilter = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
            queryFilter.setClause("/*!COUNT*/(1=1)");
        }
        return query;
    }

    public List<PriceListEntry> getPriceListEntries(AbstractPriceLevel priceLevel, boolean applyPriceFilter) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)priceLevel);
        PriceListEntryQuery priceListEntryQuery = (PriceListEntryQuery)pm.newQuery(PriceListEntry.class);
        priceListEntryQuery.thereExistsPriceLevel().equalTo(priceLevel);
        if (applyPriceFilter) {
            priceListEntryQuery.priceCurrency().equalTo((Object)priceLevel.getPriceCurrency());
            if (!priceLevel.getPriceUsage().isEmpty()) {
                priceListEntryQuery.thereExistsUsage().elementOf(priceLevel.getPriceUsage());
            }
        }
        Segment productSegment = (Segment)pm.getObjectById((Object)priceLevel.refGetPath().getPrefix(5));
        return productSegment.getPriceListEntry(priceListEntryQuery);
    }

    public List<ProductBasePrice> findPrices(Product product, AbstractPriceLevel priceLevel, Uom uom, boolean useBasedOnPriceLevel) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)product);
        ProductBasePriceQuery priceQuery = (ProductBasePriceQuery)pm.newQuery(ProductBasePrice.class);
        priceLevel = useBasedOnPriceLevel && priceLevel.getBasedOn() != null ? priceLevel.getBasedOn() : priceLevel;
        priceQuery.priceCurrency().equalTo((Object)priceLevel.getPriceCurrency());
        if (priceLevel != null && !priceLevel.getPriceUsage().isEmpty()) {
            priceQuery.thereExistsUsage().elementOf(priceLevel.getPriceUsage());
        }
        if (priceLevel != null) {
            priceQuery.thereExistsPriceLevel().equalTo(priceLevel);
        }
        if (uom != null) {
            priceQuery.uom().equalTo(uom);
        }
        return product.getBasePrice(priceQuery);
    }

    public int clonePriceLevel(AbstractPriceLevel priceLevel, Short processingMode, Map<String, Marshaller> priceLevelMarshallers) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)priceLevel);
        Segment productSegment = (Segment)pm.getObjectById((Object)priceLevel.refGetPath().getParent().getParent());
        List<AbstractPriceLevel> dependentPriceLevels = this.getDependentPriceLevels(priceLevel, true);
        if (processingMode == 5 || processingMode == 4) {
            HashMap<Path, AbstractPriceLevel> clonedLevels = new HashMap<Path, AbstractPriceLevel>();
            AbstractPriceLevel clonedPriceLevel = (AbstractPriceLevel)Cloneable.getInstance().cloneObject(priceLevel, productSegment, "priceLevel", priceLevelMarshallers, "priceModifier, accountFilterProperty, assignedAccount, productFilterProperty", (User)priceLevel.getOwningUser(), priceLevel.getOwningGroup());
            clonedLevels.put(priceLevel.refGetPath(), clonedPriceLevel);
            for (AbstractPriceLevel dependentPriceLevel : dependentPriceLevels) {
                AbstractPriceLevel clonedDependentPriceLevel = (AbstractPriceLevel)Cloneable.getInstance().cloneObject(dependentPriceLevel, productSegment, "priceLevel", priceLevelMarshallers, "priceModifier, accountFilterProperty, assignedAccount, productFilterProperty", (User)dependentPriceLevel.getOwningUser(), dependentPriceLevel.getOwningGroup());
                clonedLevels.put(dependentPriceLevel.refGetPath(), clonedDependentPriceLevel);
            }
            for (AbstractPriceLevel level : clonedLevels.values()) {
                if (level.getBasedOn() == null || !clonedLevels.keySet().contains(level.getBasedOn().refGetPath())) continue;
                AbstractPriceLevel clonedLevel = (AbstractPriceLevel)clonedLevels.get(level.getBasedOn().refGetPath());
                level.setBasedOn(clonedLevel);
            }
            if (processingMode == 4 && priceLevel.getBasedOn() == null) {
                List<PriceListEntry> priceListEntries = this.getPriceListEntries(priceLevel, true);
                for (PriceListEntry priceListEntry : priceListEntries) {
                    Product product;
                    ProductBasePrice price = priceListEntry.getBasePrice();
                    if (price.isDisabled() != null && price.isDisabled().booleanValue() || (product = (Product)pm.getObjectById((Object)price.refGetPath().getParent().getParent())).isDisabled() != null && product.isDisabled().booleanValue()) continue;
                    ProductBasePrice clonedPrice = (ProductBasePrice)PersistenceHelper.clone((Object)price, (String[])new String[0]);
                    clonedPrice.getPriceLevel().clear();
                    clonedPrice.getPriceLevel().add(clonedPriceLevel);
                    product.addBasePrice(false, this.getUidAsString(), clonedPrice);
                }
            }
        }
        return dependentPriceLevels.size() + 1;
    }

    public int clonePriceLevel(PriceLevel priceLevel, Short processingMode, String nameReplacementRegex, String nameReplacementValue, Date validFrom, Date validTo) throws ServiceException {
        HashMap<String, Marshaller> priceLevelMarshallers = new HashMap<String, Marshaller>();
        priceLevelMarshallers.put("org:opencrx:kernel:product1:PriceLevel", new PriceLevelMarshaller(nameReplacementRegex, nameReplacementValue, validFrom, validTo));
        return this.clonePriceLevel(priceLevel, processingMode, priceLevelMarshallers);
    }

    public int cloneProductPhasePriceLevel(ProductPhasePriceLevel priceLevel, Short processingMode, String nameReplacementRegex, String nameReplacementValue, String productPhaseKey) throws ServiceException {
        HashMap<String, Marshaller> priceLevelMarshallers = new HashMap<String, Marshaller>();
        priceLevelMarshallers.put("org:opencrx:kernel:product1:ProductPhasePriceLevel", new ProductPhasePriceLevelMarshaller(nameReplacementRegex, nameReplacementValue, productPhaseKey));
        return this.clonePriceLevel(priceLevel, processingMode, priceLevelMarshallers);
    }

    public List<AbstractPriceLevel> getDependentPriceLevels(AbstractPriceLevel priceLevel, boolean recursive) throws ServiceException {
        HashSet<Object> dependentPriceLevels = new HashSet<Object>();
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)priceLevel);
        Segment productSegment = (Segment)pm.getObjectById((Object)priceLevel.refGetPath().getPrefix(5));
        AbstractPriceLevelQuery priceLevelQuery = (AbstractPriceLevelQuery)pm.newQuery(AbstractPriceLevel.class);
        priceLevelQuery.thereExistsBasedOn().equalTo(priceLevel);
        List levels = productSegment.getPriceLevel(priceLevelQuery);
        dependentPriceLevels.addAll(levels);
        if (recursive) {
            for (AbstractPriceLevel level : levels) {
                dependentPriceLevels.addAll(this.getDependentPriceLevels(level, true));
            }
        }
        return new ArrayList<AbstractPriceLevel>(dependentPriceLevels);
    }

    public int calculatePrices(AbstractPriceLevel priceLevel, Short processingMode, Date includeProductsModifiedSince) throws ServiceException {
        if (processingMode == 1) {
            return this.calculatePrices(priceLevel, true, includeProductsModifiedSince);
        }
        if (processingMode == 2) {
            return this.calculatePrices(priceLevel, false, includeProductsModifiedSince);
        }
        if (processingMode == 3) {
            int numberProcessed = this.calculatePrices(priceLevel, false, includeProductsModifiedSince);
            List<AbstractPriceLevel> dependentPriceLevels = this.getDependentPriceLevels(priceLevel, false);
            for (AbstractPriceLevel dependentPriceLevel : dependentPriceLevels) {
                numberProcessed += this.calculatePrices(dependentPriceLevel, (short)3, includeProductsModifiedSince);
            }
            return numberProcessed;
        }
        return 0;
    }

    public void applyPriceModifier(ProductBasePrice modifiedPrice, PriceModifier priceModifier) {
        BigDecimal quantityFromPrice = modifiedPrice.getQuantityFrom();
        BigDecimal quantityToPrice = modifiedPrice.getQuantityTo();
        BigDecimal quantityFromModifier = priceModifier.getQuantityFrom();
        quantityFromModifier = quantityFromModifier == null ? quantityFromPrice : quantityFromModifier;
        BigDecimal quantityToModifier = priceModifier.getQuantityTo();
        BigDecimal bigDecimal = quantityToModifier = quantityToModifier == null ? quantityToPrice : quantityToModifier;
        if (!(quantityFromModifier != null && quantityFromPrice != null && quantityFromModifier.compareTo(quantityFromPrice) > 0 || quantityToModifier != null && quantityToPrice != null && quantityToModifier.compareTo(quantityToPrice) < 0)) {
            if (priceModifier instanceof DiscountPriceModifier) {
                boolean discountIsPercentagePrice;
                DiscountPriceModifier discountPriceModifier = (DiscountPriceModifier)priceModifier;
                boolean discountIsPercentageModifier = discountPriceModifier.isDiscountIsPercentage() != null && discountPriceModifier.isDiscountIsPercentage() != false;
                boolean bl = discountIsPercentagePrice = modifiedPrice.isDiscountIsPercentage() != null && modifiedPrice.isDiscountIsPercentage() != false;
                if (discountIsPercentageModifier == discountIsPercentagePrice) {
                    modifiedPrice.setDiscount(discountPriceModifier.getDiscount());
                }
            } else if (priceModifier instanceof LinearPriceModifier) {
                LinearPriceModifier linearPriceModifier = (LinearPriceModifier)priceModifier;
                BigDecimal priceMultiplier = linearPriceModifier.getPriceMultiplier();
                priceMultiplier = priceMultiplier == null ? BigDecimal.ZERO : priceMultiplier;
                BigDecimal priceOffset = linearPriceModifier.getPriceOffset();
                priceOffset = priceOffset == null ? BigDecimal.ZERO : priceOffset;
                BigDecimal roundingFactor = linearPriceModifier.getRoundingFactor();
                roundingFactor = roundingFactor == null ? BigDecimal.ONE : roundingFactor;
                BigDecimal price = modifiedPrice.getPrice();
                price = price == null ? BigDecimal.ZERO : price;
                price = new BigDecimal(price.multiply(priceMultiplier).multiply(roundingFactor).add(new BigDecimal("0.5")).toBigInteger()).divide(roundingFactor, price.scale(), 3).add(priceOffset);
                modifiedPrice.setPrice(price);
            } else if (priceModifier instanceof PriceModifierReference) {
                this.applyPriceModifier(modifiedPrice, ((PriceModifierReference)priceModifier).getPriceModifier());
            }
        }
    }

    public void applyPriceModifiers(ProductBasePrice modifiedPrice, Collection<PriceModifier> priceModifiers) {
        for (PriceModifier priceModifier : priceModifiers) {
            this.applyPriceModifier(modifiedPrice, priceModifier);
        }
    }

    public int calculatePrices(AbstractPriceLevel priceLevel, boolean testOnly, Date includeProductsModifiedSince) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)priceLevel);
        if (priceLevel.isFinal().booleanValue()) {
            throw new ServiceException("OpenCrxDomain", 1252, "Operation is not allowed for final price level.", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)priceLevel)});
        }
        boolean isBasePriceLevel = priceLevel.getBasedOn() == null;
        PriceModifierQuery priceModifierQuery = (PriceModifierQuery)pm.newQuery(PriceModifier.class);
        priceModifierQuery.orderByOrderIndex().ascending();
        List priceModifiers = priceLevel.getPriceModifier(priceModifierQuery);
        ProductQuery productQuery = (ProductQuery)pm.newQuery(Product.class);
        if (includeProductsModifiedSince != null) {
            productQuery.modifiedAt().greaterThanOrEqualTo((Comparable)includeProductsModifiedSince);
        }
        productQuery = this.getFilteredProductQuery(priceLevel, productQuery, false);
        Segment productSegment = (Segment)pm.getObjectById((Object)priceLevel.refGetPath().getParent().getParent());
        List filteredProducts = productSegment.getProduct(productQuery);
        int numberProcessed = 0;
        for (Product product : filteredProducts) {
            List<ProductBasePrice> basedOnPrices = this.findPrices(product, priceLevel, null, !isBasePriceLevel);
            List<ProductBasePrice> existingPrices = this.findPrices(product, priceLevel, null, false);
            ArrayList<ProductBasePrice> newPrices = new ArrayList<ProductBasePrice>();
            for (ProductBasePrice basePrice : basedOnPrices) {
                if (testOnly) continue;
                if (priceModifiers.isEmpty()) {
                    List priceLevels = basePrice.getPriceLevel();
                    if (priceLevels.contains(priceLevel)) continue;
                    priceLevels.add(priceLevel);
                    continue;
                }
                ProductBasePrice newPrice = (ProductBasePrice)PersistenceHelper.clone((Object)basePrice, (String[])new String[0]);
                this.applyPriceModifiers(newPrice, priceModifiers);
                newPrice.getPriceLevel().clear();
                newPrice.getPriceLevel().add(priceLevel);
                newPrice.setPriceCurrency(priceLevel.getPriceCurrency());
                newPrice.getUsage().clear();
                newPrice.getUsage().addAll(priceLevel.getPriceUsage());
                if (existingPrices.isEmpty()) {
                    newPrices.add(newPrice);
                    continue;
                }
                for (ProductBasePrice existingPrice : existingPrices) {
                    boolean priceIsEqual = true;
                    priceIsEqual &= Utils.areEqual(existingPrice.getPrice(), newPrice.getPrice());
                    priceIsEqual &= Utils.areEqual(existingPrice.getDiscount(), newPrice.getDiscount());
                    priceIsEqual &= Utils.areEqual(existingPrice.getQuantityFrom(), newPrice.getQuantityFrom());
                    priceIsEqual &= Utils.areEqual(existingPrice.getQuantityTo(), newPrice.getQuantityTo());
                    if (priceIsEqual &= Utils.areEqual(existingPrice.isDiscountIsPercentage(), newPrice.isDiscountIsPercentage())) continue;
                    if (existingPrice.getPriceLevel().size() == 1) {
                        existingPrice.setPrice(newPrice.getPrice());
                        existingPrice.setDiscount(newPrice.getDiscount());
                        existingPrice.setQuantityFrom(newPrice.getQuantityFrom());
                        existingPrice.setQuantityTo(newPrice.getQuantityTo());
                        existingPrice.setDiscountIsPercentage(newPrice.isDiscountIsPercentage());
                        continue;
                    }
                    existingPrice.getPriceLevel().remove(priceLevel);
                    newPrices.add(newPrice);
                }
            }
            for (ProductBasePrice newPrice : newPrices) {
                product.addBasePrice(false, this.getUidAsString(), newPrice);
            }
            ++numberProcessed;
        }
        return numberProcessed;
    }

    public int removePrices(AbstractPriceLevel priceLevel) throws ServiceException {
        if (priceLevel.isFinal().booleanValue()) {
            throw new ServiceException("OpenCrxDomain", 1252, "Operation is not allowed for final price level.", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)priceLevel)});
        }
        List<PriceListEntry> priceListEntries = this.getPriceListEntries(priceLevel, false);
        int numberProcessed = 0;
        for (PriceListEntry priceListEntry : priceListEntries) {
            if (priceListEntry.getBasePrice() == null) continue;
            ProductBasePrice basePrice = priceListEntry.getBasePrice();
            basePrice.getPriceLevel().remove(priceLevel);
            if (basePrice.getPriceLevel().isEmpty()) {
                basePrice.refDelete();
            }
            ++numberProcessed;
        }
        return numberProcessed;
    }

    public int removePrices(AbstractPriceLevel priceLevel, Short processingMode) throws ServiceException {
        int numberProcessed = 0;
        if (processingMode == 2) {
            numberProcessed = this.removePrices(priceLevel);
        } else if (processingMode == 3) {
            this.removePrices(priceLevel);
            List<AbstractPriceLevel> dependentPriceLevels = this.getDependentPriceLevels(priceLevel, true);
            for (AbstractPriceLevel dependentPriceLevel : dependentPriceLevels) {
                this.removePrices(dependentPriceLevel);
            }
            numberProcessed = 1 + dependentPriceLevels.size();
        }
        return numberProcessed;
    }

    public int removePriceLevels(AbstractPriceLevel priceLevel, Short processingMode, boolean preDelete) throws ServiceException {
        int numberProcessed = 0;
        if (processingMode == 2) {
            this.removePrices(priceLevel, processingMode);
            this.removePriceLevel(priceLevel, preDelete);
            numberProcessed = 1;
        } else if (processingMode == 3) {
            List<AbstractPriceLevel> dependentPriceLevels = this.getDependentPriceLevels(priceLevel, false);
            for (AbstractPriceLevel dependentPriceLevel : dependentPriceLevels) {
                this.removePriceLevels(dependentPriceLevel, processingMode, false);
            }
            this.removePrices(priceLevel, (short)2);
            this.removePriceLevel(priceLevel, preDelete);
            numberProcessed = 1 + dependentPriceLevels.size();
        }
        return numberProcessed;
    }

    public void propagateValidity(AbstractPriceLevel priceLevel, Date validFrom, Date validTo) throws ServiceException {
        if (validFrom != null) {
            priceLevel.setValidFrom(validFrom);
        }
        if (validTo != null) {
            priceLevel.setValidTo(validTo);
        }
        List<AbstractPriceLevel> dependentPriceLevels = this.getDependentPriceLevels(priceLevel, true);
        for (AbstractPriceLevel dependentPriceLevel : dependentPriceLevels) {
            if (validFrom != null) {
                dependentPriceLevel.setValidFrom(validFrom);
            }
            if (validTo == null) continue;
            dependentPriceLevel.setValidTo(validTo);
        }
    }

    public int createInitialPrices(AbstractPriceLevel priceLevel, Short processingMode, Uom uom, Date includeProductsCreatedSince) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)priceLevel);
        if (priceLevel.isFinal() != null && priceLevel.isFinal().booleanValue()) {
            throw new ServiceException("OpenCrxDomain", 1252, "Operation is not allowed for final price level.", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)priceLevel.getName())});
        }
        PriceModifierQuery priceModifierQuery = (PriceModifierQuery)pm.newQuery(PriceModifier.class);
        priceModifierQuery.orderByOrderIndex().ascending();
        List priceModifiers = priceLevel.getPriceModifier(priceModifierQuery);
        ProductQuery productQuery = (ProductQuery)pm.newQuery(Product.class);
        if (includeProductsCreatedSince != null) {
            productQuery.modifiedAt().greaterThanOrEqualTo((Comparable)includeProductsCreatedSince);
        }
        productQuery = this.getFilteredProductQuery(priceLevel, productQuery, false);
        Segment productSegment = (Segment)pm.getObjectById((Object)priceLevel.refGetPath().getPrefix(5));
        List products = productSegment.getProduct(productQuery);
        int numberProcessed = 0;
        for (Product product : products) {
            List<ProductBasePrice> basePrices = this.findPrices(product, priceLevel, uom, false);
            if (!basePrices.isEmpty()) continue;
            ProductBasePrice basePrice = (ProductBasePrice)pm.newInstance(ProductBasePrice.class);
            basePrice.getPriceLevel().add(priceLevel);
            basePrice.getUsage().addAll(priceLevel.getPriceUsage());
            basePrice.setPrice(BigDecimal.ZERO);
            basePrice.setPriceCurrency(priceLevel.getPriceCurrency());
            basePrice.setDiscount(BigDecimal.ZERO);
            basePrice.setDiscountIsPercentage(Boolean.FALSE);
            basePrice.setUom(uom);
            this.applyPriceModifiers(basePrice, priceModifiers);
            if (processingMode == 2) {
                product.addBasePrice(this.getUidAsString(), basePrice);
            }
            ++numberProcessed;
        }
        return numberProcessed;
    }

    protected GetPriceLevelResult getPriceLevel(Class<?> clazz, Class<?>[] signature, Object[] params) throws ServiceException, NoSuchMethodException {
        try {
            Method m = clazz.getMethod("getPriceLevel", signature);
            GetPriceLevelResult result = (GetPriceLevelResult)m.invoke(null, params);
            return result;
        }
        catch (InvocationTargetException e) {
            ServiceException e0 = new ServiceException((Exception)BasicException.toStackedException((Throwable)e.getTargetException(), (Throwable)e, (String)"OpenCrxDomain", (int)1257, (String)"Error invoking method getPriceLevel", (BasicException.Parameter[])new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)e.getMessage())}));
            e0.log();
            throw e0;
        }
        catch (IllegalAccessException e) {
            ServiceException e0 = new ServiceException("OpenCrxDomain", 1257, "Illegal access when invoking method getPriceLevel", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)e.getMessage())});
            e0.log();
            throw e0;
        }
    }

    public GetPriceLevelResult getPriceLevel(PricingRule pricingRule, SalesContract contract, SalesContractPosition position, AbstractProduct product, Uom priceUom, BigDecimal quantity, Short contractPositionState, Date pricingDate, AbstractPriceLevel overridePriceLevel) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)pricingRule);
        String script = pricingRule.getGetPriceLevelScript() == null || pricingRule.getGetPriceLevelScript().isEmpty() ? PRICING_RULE_GET_PRICE_LEVEL_SCRIPT_LOWEST_PRICE : pricingRule.getGetPriceLevelScript().intern();
        Class<?> clazz = ScriptUtils.getClass(script);
        try {
            return this.getPriceLevel(clazz, new Class[]{RefPackage_1_0.class, PricingRule.class, SalesContract.class, SalesContractPosition.class, AbstractProduct.class, Uom.class, BigDecimal.class, Short.class, Date.class, AbstractPriceLevel.class}, new Object[]{Utils.getProductPackage(pm).refOutermostPackage(), pricingRule, contract, position, product, priceUom, quantity, contractPositionState, pricingDate, overridePriceLevel});
        }
        catch (NoSuchMethodException ignore) {
            try {
                return this.getPriceLevel(clazz, new Class[]{RefPackage_1_0.class, PricingRule.class, AbstractContract.class, AbstractProduct.class, Uom.class, BigDecimal.class, Date.class}, new Object[]{Utils.getProductPackage(pm).refOutermostPackage(), pricingRule, contract, product, priceUom, quantity, pricingDate});
            }
            catch (NoSuchMethodException e) {
                ServiceException e0 = new ServiceException("OpenCrxDomain", 1257, "Missing method getPriceLevel", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)e.getMessage())});
                e0.log();
                throw e0;
            }
        }
    }

    public boolean hasDependentPriceLevels(AbstractPriceLevel priceLevel) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)priceLevel);
        Segment productSegment = (Segment)pm.getObjectById((Object)priceLevel.refGetPath().getPrefix(5));
        AbstractPriceLevelQuery priceLevelQuery = (AbstractPriceLevelQuery)pm.newQuery(AbstractPriceLevel.class);
        priceLevelQuery.thereExistsBasedOn().equalTo(priceLevel);
        List levels = productSegment.getPriceLevel(priceLevelQuery);
        for (AbstractPriceLevel level : levels) {
            if (JDOHelper.isDeleted((Object)level)) continue;
            return true;
        }
        return false;
    }

    public void removePriceLevel(AbstractPriceLevel priceLevel, boolean preDelete) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)priceLevel);
        Segment productSegment = (Segment)pm.getObjectById((Object)priceLevel.refGetPath().getPrefix(5));
        if (this.hasDependentPriceLevels(priceLevel)) {
            throw new ServiceException("OpenCrxDomain", 1254, "Can not delete price level. Other price levels are based on this price level.", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)priceLevel.getName())});
        }
        PriceListEntryQuery priceListEntryQuery = (PriceListEntryQuery)pm.newQuery(PriceListEntry.class);
        priceListEntryQuery.thereExistsPriceLevel().equalTo(priceLevel);
        List priceListEntries = productSegment.getPriceListEntry(priceListEntryQuery);
        if (!priceListEntries.isEmpty()) {
            throw new ServiceException("OpenCrxDomain", 1255, "Can not delete price level. Price level has assigned prices.", new BasicException.Parameter[]{new BasicException.Parameter("param0", (Object)priceLevel.getName())});
        }
        if (!preDelete) {
            priceLevel.refDelete();
        }
    }

    public int countFilteredProduct(AbstractFilterProduct productFilter) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)productFilter);
        ProductQuery query = (ProductQuery)pm.newQuery(Product.class);
        QueryExtensionRecord queryExtension = PersistenceHelper.newQueryExtension((AnyTypePredicate)query);
        queryExtension.setClause("/*!COUNT*/(1=1)");
        List products = productFilter.getFilteredProduct(query);
        return products.size();
    }

    public ProductBasePrice findProductBasePrice(AbstractPriceLevel priceLevel, AbstractProduct product, Uom priceUom, BigDecimal quantity) throws ServiceException {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)product);
        ProductBasePrice listPrice = null;
        ProductBasePriceQuery basePriceQuery = (ProductBasePriceQuery)pm.newQuery(ProductBasePrice.class);
        basePriceQuery.forAllDisabled().isFalse();
        basePriceQuery.thereExistsPriceLevel().equalTo(priceLevel);
        basePriceQuery.uom().equalTo(priceUom);
        SysLog.trace((String)"Lookup of prices with filter", Arrays.asList(basePriceQuery));
        List prices = product.getBasePrice(basePriceQuery);
        SysLog.trace((String)"Matching prices found", prices);
        for (ProductBasePrice current : prices) {
            SysLog.trace((String)"Testing price", (Object)current);
            boolean quantityFromMatches = current.getQuantityFrom() == null || quantity == null || current.getQuantityFrom().compareTo(quantity) <= 0;
            SysLog.trace((String)"Quantity from matches", (Object)quantityFromMatches);
            boolean quantityToMatches = current.getQuantityTo() == null || quantity == null || current.getQuantityTo().compareTo(quantity) >= 0;
            SysLog.trace((String)"Quantity to matches", (Object)quantityToMatches);
            if (!quantityFromMatches || !quantityToMatches) continue;
            listPrice = current;
            break;
        }
        return listPrice;
    }

    public static GetPriceLevelResult getLowestPricePriceLevel(RefPackage_1_0 rootPkg, PricingRule pricingRule, SalesContract contract, SalesContractPosition position, AbstractProduct product, Uom priceUom, BigDecimal quantity, Short contractPositionState, Date pricingDate, AbstractPriceLevel overridePriceLevel) {
        PersistenceManager pm = JDOHelper.getPersistenceManager((Object)pricingRule);
        String providerName = pricingRule.refGetPath().getSegment(2).toString();
        String segmentName = pricingRule.refGetPath().getSegment(4).toString();
        boolean loggingActivated = false;
        if (loggingActivated) {
            System.out.println("Pricing rule LowestPriceRule invoked: get lowest price");
        }
        short statusCode = 0;
        String statusMessage = null;
        AbstractPriceLevel lowestPriceLevel = null;
        DiscountOrigin lowestPriceDiscountOrigin = null;
        ProductBasePrice lowestPrice = null;
        BigDecimal lowestPriceAfterDiscount = null;
        if (pricingRule != null && priceUom != null) {
            SalesContract salesContract = contract;
            try {
                List<AbstractPriceLevel> priceLevels = null;
                if (overridePriceLevel != null) {
                    priceLevels = Collections.singletonList(overridePriceLevel);
                } else {
                    Segment productSegment = Products.getInstance().getProductSegment(pm, providerName, segmentName);
                    AbstractPriceLevelQuery priceLevelFilter = (AbstractPriceLevelQuery)pm.newQuery(AbstractPriceLevel.class);
                    priceLevelFilter.forAllDisabled().isFalse();
                    priceLevels = productSegment.getPriceLevel(priceLevelFilter);
                }
                for (AbstractPriceLevel priceLevelCandidate : priceLevels) {
                    boolean validToMatches;
                    boolean candidateMatches = false;
                    boolean validFromMatches = pricingDate == null || priceLevelCandidate.getValidFrom() == null || priceLevelCandidate.getValidFrom().compareTo(pricingDate) <= 0;
                    boolean bl = validToMatches = pricingDate == null || priceLevelCandidate.getValidTo() == null || priceLevelCandidate.getValidTo().compareTo(pricingDate) >= 0;
                    if (loggingActivated) {
                        System.out.println("Testing price level=" + priceLevelCandidate.getName() + "; validFromMatches=" + validFromMatches + "; validToMatches=" + validToMatches);
                    }
                    if (!(candidateMatches = validFromMatches && validToMatches) || salesContract.getContractCurrency() != priceLevelCandidate.getPriceCurrency()) continue;
                    if (loggingActivated) {
                        System.out.println("Price level is candidate: " + priceLevelCandidate.getName());
                    }
                    candidateMatches = false;
                    if (product != null) {
                        ArrayList<Object> discountCandidates = new ArrayList<Object>();
                        boolean customerMatchesFilter = false;
                        boolean customerIsAssigned = false;
                        Account customer = salesContract.getCustomer();
                        if (customer != null) {
                            AccountQuery accountQuery = (AccountQuery)pm.newQuery(Account.class);
                            accountQuery.forAllDisabled().isFalse();
                            accountQuery.identity().equalTo((Object)new String(customer.refMofId()));
                            customerMatchesFilter = !priceLevelCandidate.getFilteredAccount(accountQuery).isEmpty();
                            PriceLevelHasAssignedAccount.AssignedAccount accountAssignments = priceLevelCandidate.getAssignedAccount();
                            Iterator iterator = accountAssignments.iterator();
                            while (iterator.hasNext()) {
                                AccountAssignment accountAssignment = (AccountAssignment)iterator.next();
                                try {
                                    boolean assignmentValidToMatches;
                                    boolean assignmentValidFromMatches = accountAssignment.getValidFrom() == null || accountAssignment.getValidFrom().compareTo(pricingDate) <= 0;
                                    boolean bl2 = assignmentValidToMatches = accountAssignment.getValidTo() == null || accountAssignment.getValidTo().compareTo(pricingDate) >= 0;
                                    if (accountAssignment.getAccount() != customer || !assignmentValidFromMatches || !assignmentValidToMatches) continue;
                                    customerIsAssigned = true;
                                    discountCandidates.add(accountAssignment);
                                    break;
                                }
                                catch (Exception assignmentValidFromMatches) {
                                }
                            }
                        }
                        if (customer == null || customerMatchesFilter || customerIsAssigned) {
                            ProductBasePrice basePrice;
                            if (loggingActivated) {
                                System.out.println("Customer is " + (customer == null ? "undefined" : "") + (customerMatchesFilter ? "filtered " : "") + (customerIsAssigned ? "assigned" : ""));
                            }
                            if ((basePrice = Products.getInstance().findProductBasePrice(priceLevelCandidate, product, priceUom, quantity)) == null || basePrice.getPrice() == null) continue;
                            if (priceLevelCandidate.getDiscountSchedule() != null) {
                                DiscountSchedule discountSchedule = priceLevelCandidate.getDiscountSchedule();
                                DiscountRuleQuery discountRuleQuery = (DiscountRuleQuery)pm.newQuery(DiscountRule.class);
                                discountRuleQuery.forAllDisabled().isFalse();
                                for (DiscountRule discountRule : discountSchedule.getDiscountRule(discountRuleQuery)) {
                                    ValidateObjectResult result;
                                    if (discountRule.getCondition() == null || !Boolean.TRUE.equals((result = Codes.getInstance().validateObject(discountRule.getCondition(), (ContextCapable)position, new Date(), Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList())).isValid())) continue;
                                    discountCandidates.add(discountRule);
                                }
                            }
                            discountCandidates.add(basePrice);
                            for (org.opencrx.kernel.product1.jmi1.DiscountOrigin discountOrigin : discountCandidates) {
                                BigDecimal priceAfterDiscount = basePrice.getPrice();
                                if (discountOrigin.getDiscount() != null) {
                                    priceAfterDiscount = Boolean.TRUE.equals(discountOrigin.isDiscountIsPercentage()) ? priceAfterDiscount.multiply(BigDecimal.ONE.subtract(discountOrigin.getDiscount().divide(new BigDecimal(100.0)))) : priceAfterDiscount.subtract(discountOrigin.getDiscount());
                                }
                                if (lowestPriceAfterDiscount != null && priceAfterDiscount.compareTo(lowestPriceAfterDiscount) >= 0) continue;
                                lowestPriceLevel = priceLevelCandidate;
                                lowestPrice = basePrice;
                                lowestPriceAfterDiscount = priceAfterDiscount;
                                if (discountOrigin.getDiscount() != null) {
                                    lowestPriceDiscountOrigin = discountOrigin;
                                }
                                if (!loggingActivated) continue;
                                System.out.println("New lowest price {priceLevel: \"" + lowestPriceLevel.refGetPath() + "\", lowestPrice: \"" + lowestPrice.refGetPath() + "\", lowestPriceAfterDiscount: \"" + lowestPriceAfterDiscount + "\", lowestPriceDiscountOrigin: \"" + lowestPriceDiscountOrigin.refGetPath() + "\"}");
                            }
                            continue;
                        }
                        if (!loggingActivated) continue;
                        System.out.println("Customer is neither filtered nor assigned");
                        continue;
                    }
                    if (loggingActivated) {
                        System.out.println("Product is null");
                    }
                    break;
                }
            }
            catch (Exception e) {
                statusCode = 1;
                ServiceException e0 = new ServiceException(e);
                statusMessage = e0.getMessage();
                e0.log();
            }
        }
        GetPriceLevelResult result = (GetPriceLevelResult)Structures.create(GetPriceLevelResult.class, (Structures.Member[])new Structures.Member[]{Datatypes.member((Enum)GetPriceLevelResult.Member.basePrice, lowestPrice), Datatypes.member((Enum)GetPriceLevelResult.Member.discountOrigin, lowestPriceDiscountOrigin), Datatypes.member((Enum)GetPriceLevelResult.Member.discount, (Object)(lowestPriceDiscountOrigin == null ? null : lowestPriceDiscountOrigin.getDiscount())), Datatypes.member((Enum)GetPriceLevelResult.Member.discountIsPercentage, (Object)(lowestPriceDiscountOrigin == null ? null : lowestPriceDiscountOrigin.isDiscountIsPercentage())), Datatypes.member((Enum)GetPriceLevelResult.Member.priceLevel, lowestPriceLevel), Datatypes.member((Enum)GetPriceLevelResult.Member.statusCode, (Object)statusCode), Datatypes.member((Enum)GetPriceLevelResult.Member.statusMessage, (Object)statusMessage)});
        return result;
    }

    protected void updateProduct(Product product) throws ServiceException {
    }

    protected void removeProduct(Product product, boolean preDelete) throws ServiceException {
    }

    protected void updateProductBasePrice(ProductBasePrice price) throws ServiceException {
    }

    protected void removeProductBasePrice(ProductBasePrice price, boolean preDelete) throws ServiceException {
    }

    protected void updateRelatedProduct(RelatedProduct relatedProduct) throws ServiceException {
    }

    protected void removeRelatedProduct(RelatedProduct relatedProduct, boolean preDelete) throws ServiceException {
    }

    @Override
    public void preDelete(RefObject_1_0 object, boolean preDelete) throws ServiceException {
        super.preDelete(object, preDelete);
        if (object instanceof Product) {
            this.removeProduct((Product)object, preDelete);
        } else if (object instanceof AbstractPriceLevel) {
            this.removePriceLevel((AbstractPriceLevel)object, preDelete);
        } else if (object instanceof ProductBasePrice) {
            this.removeProductBasePrice((ProductBasePrice)object, preDelete);
        } else if (object instanceof RelatedProduct) {
            this.removeRelatedProduct((RelatedProduct)object, preDelete);
        }
    }

    @Override
    public void preStore(RefObject_1_0 object) throws ServiceException {
        super.preStore(object);
        if (object instanceof Product) {
            this.updateProduct((Product)object);
        } else if (object instanceof RelatedProduct) {
            this.updateRelatedProduct((RelatedProduct)object);
        } else if (object instanceof ProductBasePrice) {
            this.updateProductBasePrice((ProductBasePrice)object);
        } else if (object instanceof PhoneNumber) {
            Addresses.getInstance().updatePhoneNumber((PhoneNumber)object);
        } else if (object instanceof EMailAddress) {
            Addresses.getInstance().updateEMailAddress((EMailAddress)object);
        } else if (object instanceof UriAddress) {
            Addresses.getInstance().updateUriAddress((UriAddress)object);
        }
    }

    public class ProductPhasePriceLevelMarshaller
    implements Marshaller {
        private final String nameReplacementRegex;
        private final String nameReplacementValue;
        private final String productPhaseKey;

        public ProductPhasePriceLevelMarshaller(String nameReplacementRegex, String nameReplacementValue, String productPhaseKey) {
            this.nameReplacementRegex = nameReplacementRegex;
            this.nameReplacementValue = nameReplacementValue;
            this.productPhaseKey = productPhaseKey;
        }

        public Object marshal(Object s) throws ServiceException {
            String name;
            ProductPhasePriceLevel priceLevel = (ProductPhasePriceLevel)PersistenceHelper.clone((Object)((ProductPhasePriceLevel)s), (String[])new String[0]);
            if (priceLevel.getName() != null && this.nameReplacementRegex != null && this.nameReplacementValue != null && (name = priceLevel.getName()) != null) {
                priceLevel.setName(name.replaceAll(this.nameReplacementRegex, this.nameReplacementValue));
            }
            if (this.productPhaseKey != null) {
                priceLevel.setProductPhaseKey(this.productPhaseKey);
            }
            priceLevel.setFinal(Boolean.FALSE);
            return priceLevel;
        }

        public Object unmarshal(Object s) {
            throw new UnsupportedOperationException();
        }
    }

    public class PriceLevelMarshaller
    implements Marshaller {
        private final String nameReplacementRegex;
        private final String nameReplacementValue;
        private final Date validFrom;
        private final Date validTo;

        public PriceLevelMarshaller(String nameReplacementRegex, String nameReplacementValue, Date validFrom, Date validTo) {
            this.nameReplacementRegex = nameReplacementRegex;
            this.nameReplacementValue = nameReplacementValue;
            this.validFrom = validFrom;
            this.validTo = validTo;
        }

        public Object marshal(Object s) throws ServiceException {
            String name;
            AbstractPriceLevel priceLevel = (AbstractPriceLevel)PersistenceHelper.clone((Object)((AbstractPriceLevel)s), (String[])new String[0]);
            if (priceLevel.getName() != null && this.nameReplacementRegex != null && this.nameReplacementValue != null && (name = priceLevel.getName()) != null) {
                priceLevel.setName(name.replaceAll(this.nameReplacementRegex, this.nameReplacementValue));
            }
            if (this.validFrom != null) {
                priceLevel.setValidFrom(this.validFrom);
            }
            priceLevel.setValidTo(null);
            if (this.validTo != null) {
                priceLevel.setValidTo(this.validTo);
            }
            priceLevel.setFinal(Boolean.FALSE);
            return priceLevel;
        }

        public Object unmarshal(Object s) {
            throw new UnsupportedOperationException();
        }
    }
}

